/*
 * SystemProc.c
 *
 *  Created on: Jul 31, 2014
 *      Author: QTC
 */
 
#include "tim4.h"
#include "CalcFrequency.h"

#define              INTERVAL_TIMER_MODE        0
#define              CAPTURE_MODE               0x0104
#define              _00_TMR_OPCLK_BIT_14_15    0
#define              TPS_CKm_500_000KHZ         0x07



void Capture_Init(uint8_t pin_num)
{
	  uint16_t  TPSm = 0u;
	  volatile uint16_t *pTMRmn;
	  uint8_t chl;
	
	  if(pin_num == 21)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM03_IRQn);
				NVIC_ClearPendingIRQ(TM03_IRQn);
			  pTMRmn = &TM40->TMR03;
			  chl = TIMER4_CH3;
		}
	  else if(pin_num == 39)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM02_IRQn);
				NVIC_ClearPendingIRQ(TM02_IRQn);
			  pTMRmn = &TM40->TMR02;
			  chl = TIMER4_CH2;
		}
	  else if(pin_num == 40)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM01_IRQn);
				NVIC_ClearPendingIRQ(TM01_IRQn);
			  pTMRmn = &TM40->TMR01;
			  chl = TIMER4_CH1;
		}
	  else if(pin_num == 62)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM00_IRQn);
				NVIC_ClearPendingIRQ(TM00_IRQn);
			  pTMRmn = &TM40->TMR00;
			  chl = TIMER4_CH0;
		}

    CGC->PER0 |= CGC_PER0_TM40EN_Msk;    /* enables input clock supply */
		
		TPSm = TM40->TPS0;
		
		TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_500_000KHZ;
		TM40->TT0 |= chl; 
    
		/* Channel 0 is used to measure input pulse interval */
		*pTMRmn = CAPTURE_MODE | 0x0040;
		TM40->TO0  &= ~chl;
		TM40->TOE0 &= ~chl;
	
		if(pin_num == 21)
		{
				MISC->NFEN1 |= chl;
				TI03_PORT_SETTING();
				/* enable interrupt */
				INTC_EnableIRQ(TM03_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 39)
		{
				MISC->NFEN1 |= chl;
				TI02_PORT_SETTING();
				/* enable interrupt */
				INTC_EnableIRQ(TM02_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 40)
		{
			  MISC->TIOS0 |= 0x00;
				MISC->NFEN1 |= chl;
				TI01_PORT_SETTING();
				/* enable interrupt */
				INTC_EnableIRQ(TM01_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 62)
		{
			  MISC->TIOS0 |= 0x00;
				MISC->NFEN1 |= chl;
				TI00_PORT_SETTING();
				/* enable interrupt */
				INTC_EnableIRQ(TM00_IRQn);
			  TM40->TS0 |= chl; 
		}
}

void Capture_Stop(uint8_t pin_num)
{
	  uint16_t  TPSm = 0u;
	  volatile uint16_t *pTMRmn;
	  uint8_t chl;
	
	  if(pin_num == 21)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM03_IRQn);
				NVIC_ClearPendingIRQ(TM03_IRQn);
			  pTMRmn = &TM40->TMR03;
			  chl = TIMER4_CH3;
		}
	  else if(pin_num == 39)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM02_IRQn);
				NVIC_ClearPendingIRQ(TM02_IRQn);
			  pTMRmn = &TM40->TMR02;
			  chl = TIMER4_CH1;
		}
	  else if(pin_num == 40)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM01_IRQn);
				NVIC_ClearPendingIRQ(TM01_IRQn);
			  pTMRmn = &TM40->TMR01;
			  chl = TIMER4_CH1;
		}
	  else if(pin_num == 62)
		{
				/* clear interrupt flag */
				INTC_ClearPendingIRQ(TM00_IRQn);
				NVIC_ClearPendingIRQ(TM00_IRQn);
			  pTMRmn = &TM40->TMR00;
			  chl = TIMER4_CH0;
		}

        CGC->PER0 &= ~CGC_PER0_TM40EN_Msk;    /* enables input clock supply */
		
		TPSm = TM40->TPS0;
		
		TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_500_000KHZ;
		TM40->TT0 |= chl; 
    
		/* Channel 0 is used to measure input pulse interval */
		*pTMRmn = CAPTURE_MODE | 0x0040;
		TM40->TO0  &= ~chl;
		TM40->TOE0 &= ~chl;
	
		if(pin_num == 21)
		{
				MISC->NFEN1 |= chl;
				TI03_PORT_SETTING();
				/* enable interrupt */
				INTC_DisableIRQ(TM03_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 39)
		{
				MISC->NFEN1 |= chl;
				TI02_PORT_SETTING();
				/* enable interrupt */
				INTC_DisableIRQ(TM02_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 40)
		{
			  MISC->TIOS0 |= 0x00;
				MISC->NFEN1 |= chl;
				TI01_PORT_SETTING();
				/* enable interrupt */
				INTC_DisableIRQ(TM01_IRQn);
			  TM40->TS0 |= chl; 
		}		
		else if(pin_num == 62)
		{
			  MISC->TIOS0 |= 0x00;
				MISC->NFEN1 |= chl;
				TI00_PORT_SETTING();
				/* enable interrupt */
				INTC_DisableIRQ(TM00_IRQn);
			  TM40->TS0 |= chl; 
		}
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_tim4_0m_isr_Handler
* Description    : Timer module init
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/

void  bsp_tim4_01_isr_Handler( void )
{
    uint16_t *pTMRmn = (uint16_t *)&TM40->TMR01;
    uint16_t *pTDRmn = (uint16_t *)&TM40->TDR01;
    uint16_t *pTSRmn = (uint16_t *)&TM40->TSR01; 

    if(*pTMRmn == EdgeRising){
        
        *pTMRmn = EdgeFalling;
        InputRevHighPulseTime(pTDRmn,pTSRmn);   //高低电平是反的，我也不知道为啥

    }
    else{
        
        *pTMRmn = EdgeRising;
        InputRevLowPulseTime(pTDRmn,pTSRmn);
        
    }      
    INTC_ClearPendingIRQ(TM01_IRQn); 
}


void bsp_tim4_02_isr_Handler(void)
{
    /*uint16_t *pTMRmn = (uint16_t *)&TM40->TMR02;
    uint16_t *pTDRmn = (uint16_t *)&TM40->TDR02;
    uint16_t *pTSRmn = (uint16_t *)&TM40->TSR02;

    if(*pTMRmn == EdgeRising){
        
        *pTMRmn = EdgeFalling;
			  InputVehHighPulseTime(pTDRmn,pTSRmn);
        

    }
    else{
        
        *pTMRmn = EdgeRising;
        
			  InputVehLowPulseTime(pTDRmn,pTSRmn);
    }*/

    INTC_ClearPendingIRQ(TM02_IRQn); 
}




/*-------------------------------------------------------------------------
* Function Name  : bsp_TIMER_Init
* Description    : Timer module init
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Timer4_Init(uint16_t Frequency,uint8_t ch)
{
//    uint32_t  InterruptFrequency = 0U;
//    uint32_t  CKmClockFrequency = 0U;
//    uint16_t  TPSm = 0u;
//    InterruptFrequency = Frequency;
//    CKmClockFrequency = 93750;
//	
//	  switch(ch)
//		{
//			case TIMER4_CH0:
//				/* clear interrupt flag */
//				INTC_ClearPendingIRQ(TM00_IRQn);
//				NVIC_ClearPendingIRQ(TM00_IRQn);
//
//				CGC->PER0 |= CGC_PER0_TM40EN_Msk;
//			
//				TPSm = TM40->TPS0;
//				
//				TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_93_75KHZ;
//				TM40->TT0 |= TIMER4_CH0;
//				TM40->TMR00 = _00_TMR_OPCLK_BIT_14_15 | INTERVAL_TIMER_MODE;      /* Interval timer; Operation clock CKm0 set byTPSm register */
//				TM40->TDR00 = (CKmClockFrequency / InterruptFrequency) -1; /* cycle */
//			
//				TM40->TOE0 &= ~TIMER4_CH0;
//				/* enable interrupt */
//				INTC_EnableIRQ(TM00_IRQn);
//			
//				TM40->TS0 |= TIMER4_CH0;      /* chl start count */
//
//				break;
//			
//			case TIMER4_CH1:
//				/* clear interrupt flag */
//				INTC_ClearPendingIRQ(TM01_IRQn);
//				NVIC_ClearPendingIRQ(TM01_IRQn);
//
//				CGC->PER0 |= CGC_PER0_TM40EN_Msk;
//			
//				TPSm = TM40->TPS0;
//				
//				TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_93_75KHZ;
//				TM40->TT0 |= TIMER4_CH1;
//				TM40->TMR01 = _00_TMR_OPCLK_BIT_14_15 | INTERVAL_TIMER_MODE;      /* Interval timer; Operation clock CKm0 set byTPSm register */
//				TM40->TDR01 = (CKmClockFrequency / InterruptFrequency) -1; /* cycle */
//			
//				TM40->TOE0 &= ~TIMER4_CH1;
//				/* enable interrupt */
//				INTC_EnableIRQ(TM01_IRQn);
//			
//				TM40->TS0 |= TIMER4_CH1;      /* chl start count */
//
//				break;
//			
//			case TIMER4_CH2:
//				/* clear interrupt flag */
//				INTC_ClearPendingIRQ(TM02_IRQn);
//				NVIC_ClearPendingIRQ(TM02_IRQn);
//
//				CGC->PER0 |= CGC_PER0_TM40EN_Msk;
//			
//				TPSm = TM40->TPS0;
//				
//				TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_93_75KHZ;
//				TM40->TT0 |= TIMER4_CH2;
//				TM40->TMR02 = _00_TMR_OPCLK_BIT_14_15 | INTERVAL_TIMER_MODE;      /* Interval timer; Operation clock CKm0 set byTPSm register */
//				TM40->TDR02 = (CKmClockFrequency / InterruptFrequency) -1; /* cycle */
//			
//				TM40->TOE0 &= ~TIMER4_CH2;
//				/* enable interrupt */
//				INTC_EnableIRQ(TM02_IRQn);
//			
//				TM40->TS0 |= TIMER4_CH2;      /* chl start count */
//
//				break;
//
//			case TIMER4_CH3:
//				/* clear interrupt flag */
//				INTC_ClearPendingIRQ(TM03_IRQn);
//				NVIC_ClearPendingIRQ(TM03_IRQn);
//
//				CGC->PER0 |= CGC_PER0_TM40EN_Msk; /* PER0.TAU0EN */
//			
//				TPSm = TM40->TPS0;
//				
//				TM40->TPS0 = (TPSm & 0xFFF0) | TPS_CKm_93_75KHZ;
//				TM40->TT0 |= TIMER4_CH3;
//				TM40->TMR03 = _00_TMR_OPCLK_BIT_14_15 | INTERVAL_TIMER_MODE;      /* Interval timer; Operation clock CKm0 set byTPSm register */
//				TM40->TDR03 = (CKmClockFrequency / InterruptFrequency) -1; /* cycle */
//			
//				TM40->TOE0 &= ~TIMER4_CH3;
//				/* enable interrupt */
//				INTC_EnableIRQ(TM03_IRQn);
//			
//				TM40->TS0 |= TIMER4_CH3;      /* chl start count */
//
//				break;
//			
//			default:
//				break;
//		}
}


