#include "common.h"
#include "gpio.h"
#include "Line_in.h"

/*硬线输入服务函数调用周期 单位：ms*/
#define LINE_IN_CYCLE 10U


/*---------------------------------------------------------------------------------------*/

const Line_In_Attribute_st_t g_stLineInAttribute[] =
{
    { LINE_IN_IG_ON,    20U,  0U,   LINE_IN_Get_RightTurn,},
    { LINE_IN_IG_ON,    20U,  0U,   LINE_IN_Get_LeftTurn,},
    { LINE_IN_IG_ON,    60U,  0U,   LINE_IN_Get_HighBeam,},
    { LINE_IN_IG_ON,   300U,  0U,   LINE_IN_Get_ABS,},
    { LINE_IN_IG_ON,   300U,  0U,   LINE_IN_Get_AutoStarStop,},
    { LINE_IN_IG_ON,   100U,  0U,   LINE_IN_Get_TirePressure,},
    { LINE_IN_IG_ON,  2000U,  0U,   LINE_IN_Get_OilPressure,},
    { LINE_IN_IG_ON,   300U,  0U,   LINE_IN_Get_OBD,},
};

uint8_t LINE_IN_Get_RightTurn(void){
    uint8_t Res = 0;
    if(PORT_GetBit(RightTurn_P_In)){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_LeftTurn(void){
    uint8_t Res = 0;
    if(PORT_GetBit(LeftTurn_P_In)){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_HighBeam(void){
    uint8_t Res = 0;
    if(PORT_GetBit(HighBeam_P_In) == 0){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_ABS(void){
    uint8_t Res = 0;
    if(PORT_GetBit(ABS_N_In) == 1){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_AutoStarStop(void){
    uint8_t Res = 0;
    if(PORT_GetBit(AutoStarStop_N_In) == 0){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_TirePressure(void){
    uint8_t Res = 0;
    if(PORT_GetBit(TirePressure_N_In) == 0){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_OilPressure(void){
    uint8_t Res = 0;
    if(PORT_GetBit(OilPressure_N_In) == 0){
        Res = 1;
    }
    return Res;
}
uint8_t LINE_IN_Get_OBD(void){
    uint8_t Res = 0;
    if(PORT_GetBit(OBD_N_In) == 0){
        Res = 1;
    }
    return Res;
}

//=========================================================================================
                                    /*以下内容不要改*/
//=========================================================================================
typedef struct
{
    LineIn_LogicLevel_en_t u8Status;      /*硬线最后输出状态*/
    uint16_t u16TimeCount;  /*消抖计时变量*/
    uint8_t u8PinInputLast; /*实际硬线输入引脚记忆的上一次状态*/
} Line_In_Control_st_t;

Line_In_Control_st_t g_stLineInControl[LINE_IN_NUMBER];

/*电源状态*/
LINE_IN_WorkSt_en_t g_enLineInPowerStatus;



static void Line_In_Debounce_Handle(uint8_t Channel);
static void Line_In_Debounce_Handle(uint8_t Channel)
{
    uint8_t enRealtimeLevel;
    uint8_t (*pRead)(void);

    pRead = g_stLineInAttribute[Channel].pfnLineIn_Read_Cbk;
    if (pRead != NULL)
    {
        enRealtimeLevel = pRead();
        if (g_stLineInControl[Channel].u8PinInputLast != enRealtimeLevel)
        {
            g_stLineInControl[Channel].u16TimeCount = 0U;
            g_stLineInControl[Channel].u8PinInputLast = enRealtimeLevel;
        }
        else
        {
            /*硬线输入等于有效电平*/
            if (1 == enRealtimeLevel)
            {
                g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
                if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16ValidTime)
                {
                    g_stLineInControl[Channel].u16TimeCount = 0U;
                    g_stLineInControl[Channel].u8Status = LINE_IN_LOGIC_VALID;
                }
            }
            else
            {
                g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
                if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16InvalidTime)
                {
                    g_stLineInControl[Channel].u16TimeCount = 0U;
                    g_stLineInControl[Channel].u8Status = LINE_IN_LOGIC_INVALID;
                }
            }
        }
    }
}





void Line_In_SetPowerSt(LINE_IN_WorkSt_en_t u8PowerSt)
{
    g_enLineInPowerStatus = u8PowerSt;
}



/*推荐值10ms*/
void Line_In_Debounce_Service(void)
{
    uint8_t i;

    for (i = 0u; i < LINE_IN_NUMBER; i++)
    {
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ONOFF)
        {
            Line_In_Debounce_Handle(i);
        }
        else if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ON)
        {
            if (g_enLineInPowerStatus == LINE_IN_IG_ON)
            {
                Line_In_Debounce_Handle(i);
            }
            else /*切换电源状态时已经操作过了*/
            {
            }
        }
        else /* if(LINE_IN_IG_OFF==g_stLineInAttribute[i].enPowerStatus) */
        {
            if (g_enLineInPowerStatus == LINE_IN_IG_OFF)
            {
                Line_In_Debounce_Handle(i);
            }
            else  /*切换电源状态时已经操作过了*/
            {
            }
        }
    }
}

LineIn_LogicLevel_en_t Line_In_Get_Status(uint8_t Channel)
{
    return g_stLineInControl[Channel].u8Status;
}


void Line_In_KL30_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_OFF;
    for (i = 0U; i < LINE_IN_NUMBER; i++)
    {
        g_stLineInControl[i].u16TimeCount = 0U;
        g_stLineInControl[i].u8PinInputLast = 0U;
        g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
    }
}

void Line_In_KL15_ON_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_ON;
    for (i = 0U; i < LINE_IN_NUMBER; i++)
    {
        /*硬线在当前电源状态下不工作*/
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_OFF)

        {
            g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
            g_stLineInControl[i].u16TimeCount = 0U;
        }
    }
}
void Line_In_KL15_OFF_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_OFF;
    for (i = 0U; i < LINE_IN_NUMBER; i++)
    {
        /*硬线在当前电源状态下不工作*/
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ON)
        {
            g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
            g_stLineInControl[i].u16TimeCount = 0U;
        }
    }
}

