#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Flash_synchronizer.h"
#include "Common_Interface.h"
#include "Line_in.h"
#include "CAN_User.h"

#include "CoolantTemp.h"
#include "gpio.h"
#include "Fuel.h"
#include "CoolantTemp.h"
#include "CAN_Communication_Matrix.h"
#include "MCU_Core_Protocol.h"
#include "Data_Gear.h"
#include "app_Telltales.h"
#include "Menus.h"
#include "Fuel.h"
#include "Key.h"
#include "Menus.h"
const LED_Attribute_st LED_Attribute[LED_Max]__attribute__ ((aligned (4)));

Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ] __attribute__ ((aligned (4)));


void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk = Common_Get_IG_Sts;
    Telltales_KL30_Wakeup_Init((uint8_t *)Tel_Mem, LED_Attribute, &m_ExtPara);
}

const LED_Attribute_st LED_Attribute[LED_Max] =
{
    /*  指示灯索引                  是否自检          外部信号自检          工作电源状态      自检开始时间  自检持续时间                 指示灯点亮条件                        指示灯执行函数                   */
    {   m_LED_RIGHT             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//右转向
    {   m_LED_LEFT              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//左转向
    {   m_LED_HI_BEAM           ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//远光灯
    {   m_LED_MIL               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//发动机报警灯
    {   m_LED_ABS               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//ABS_低有效
    {   m_LED_TSC               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//TSC
    {   m_LED_AutoStarStop      ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//自动启停
    {   m_LED_Batterylow        ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//蓄电池电压报警
    {   m_LED_Auto_HI_BEAM      ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//自动远光灯（预留）
    {   m_LED_Shore             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//边撑状态
    {   m_LED_ENGINE_OIL_LOW    ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//机油压力报警灯（预留）
    {   m_LED_TPMS              ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//胎压功能（预留）
    {   m_LED_READY             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//READY
    {   m_LED_Fuel              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//燃油
    {   m_LED_Temp              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     NULL     ,   NULL  },//水温
};

