
#ifdef        GLOBALS_BSP_CAN
    #define   EXTERN_BSP_CAN
#else
    #define   EXTERN_BSP_CAN     extern
#endif

#ifndef BSP_CAN_H_
#define BSP_CAN_H_
    #include "stdint.h"

  

    
    #define     txResNum                 13 
    #define     U2_txResNum                 14 
    #define     txCommon                 15

    #define     MSG_EMPTY                   0
    #define     MSG_FULL                 1
                                  
    
    #define     SJW_1Tq                  0
    #define     SJW_2Tq                  1
    #define     SJW_3Tq                  2

    #define     SAMP_1                   0
    #define     Seg1_10Tq                9
    #define     Seg1_11Tq                10
    #define     Seg1_12Tq                11
    #define     Seg1_13Tq                12
    #define     Seg1_14Tq                13  
    #define     Seg1_8Tq                 7
    #define     Seg2_7Tq                 6
    #define     Seg2_8Tq                 7
    #define     Seg1_3Tq                 2
    #define     Seg1_4Tq                 3
    #define     Seg1_5Tq                 4
    #define     Seg1_6Tq                 5
    #define     Seg2_1Tq                 0
    #define     Seg2_2Tq                 1
    #define     Seg2_3Tq                 2
    #define     Seg2_4Tq                 3
    #define     Seg2_5Tq                 4
    #define     IDAM_2_32Bit             0
    #define     IDAM_4_16Bit             1
    #define     IDHIT0                   0
    #define     MSG_EMPOTY               0
    #define     MSG_FULL                 1

    #define     CanWakeUpEn              1
    #define     CanWakeUpDis             0  

    
    
    #define     success                  1
    #define     failt                    0 
    #define     CanON                    1
    #define     CanOFF                   0
      
    #define     ID280                    0x280  
    #define     ID2C0                    0x2C0     
    #define     ID392                    0x392    
    #define     ID350                    0x350    
    #define     ID51B                    0x51B     
    #define     ID380                    0x380      
    #define     ID320                    0x320     
    #define     ID301                    0x301    
    #define     ID440                    0x440     
    #define     ID360                    0x360     
    #define     ID515                    0x515  
    #define     ID600                    0x600
    #define     ID3E6                    0x3E6

/* ToDo: You can allocate the CTXD0 to P02 or P51 with PIOR33 register */
#define CTXD0_PORT_SETTING() do{ \
        PORT->PIOR3 &= ~(1 << 3);    /* allocate CTXD0 to P02 */ \
        PORT->P0    |=  (1 << 2);    /* P02 output high level */ \
        PORT->PM0   &= ~(1 << 2);    /* P02 is used as CTXD0 output */ \
        PORT->PMC0  &= ~(1 << 2);    /* P02 is digital function */ \
}while(0)

/* ToDo: You can allocate the CRXD0 to P03 or P50 with PIOR33 register */
#define CRXD0_PORT_SETTING() do{ \
        PORT->PIOR3 &= ~(1 << 3);    /* allocate CRXD0 to P03 */ \
        PORT->PM0   |=  (1 << 3);    /* P03 is used as CRXD0 input */ \
        PORT->PMC0  &= ~(1 << 3);    /* P03 is digital function */ \
}while(0)
    
//Format of CAN Module Control Register CTRL
#define CTRL_RSTA_READ 0x0200U
#define CTRL_TSTA_READ 0x0100U
#define CTRL_CCERC_READ 0x0080U
#define CTRL_AL_READ 0x0040U
#define CTRL_VALID_READ 0x0020U
#define CTRL_PSMODE_READ 0x0018U
#define CTRL_OPMODE_READ 0x0007U

#define CTRL_CCERC_CLR 0x0080U
#define CTRL_AL_CLR 0x0040U
#define CTRL_VALID_CLR 0x0020U

#define CTRL_CCERC_SET 0x8000U
#define CTRL_AL_SET 0x4000U

#define PSMODE_IDLE 0x0018U
#define PSMODE_SLEEP 0x0810U//0x0800U
#define PSMODE_STOP 0x1800U

#define OPMODE_IDLE 0x0007U
#define OPMODE_NORMAL 0x0106U//0x0100U
#define OPMODE_NORMAL_ABT 0x0205U//0x0200U
#define OPMODE_ONLY_RX 0x0304U//0x0300U
#define OPMODE_SHOT 0x0403U//0x0400U
#define OPMODE_TEST 0x0502U//0x0500U

//CAN module receive history list register RGPT
#define RGPT_RHPM_READ 0x0002U
#define RGPT_ROVF_READ 0x0001U

#define RGPT_ROVF_CLR 0x0001U

#define MCTRL_DN_CLR 0x0004U

//CAN module interrupt status register INTS
#define INTS_TX_READ 0x0001U
#define INTS_RX_READ 0x0002U
#define INTS_ERR_READ 0x0004U
#define INTS_PERR_READ 0x0008U
#define INTS_AL_READ 0x0010U
#define INTS_WK_READ 0x0020U


#define INTS_TX_CLR 0x0001U
#define INTS_RX_CLR 0x0002U
#define INTS_ERR_CLR 0x0004U
#define INTS_PERR_CLR 0x0008U
#define INTS_AL_CLR 0x0010U
#define INTS_WK_CLR 0x0020U

typedef enum
{
    Canm_BusOk = 0,
    Canm_ActiveErr,
    Canm_PassiveErr,
    Canm_busoff,
}CanState_t;

    EXTERN_BSP_CAN	    void	    bsp_CAN_Init(void);
    EXTERN_BSP_CAN          uint8_t         bsp_CANSendFrame(uint32_t id,uint8_t buff_num,uint8_t *txdata,uint8_t length);
    EXTERN_BSP_CAN          void            bsp_CAN_Msgbuf_init(void);
    EXTERN_BSP_CAN          void            bsp_tx_msgbuf_init(uint8_t buffer_number,uint32_t tx_msg_ID,uint8_t tx_msg_DLC);
    EXTERN_BSP_CAN          void            bsp_rx_msgbuf_init(uint8_t buf_num,uint32_t id,uint8_t MaskReg_n);
    
    EXTERN_BSP_CAN          void            bsp_tx_msgbuf_abort(uint8_t buffer_number);
    EXTERN_BSP_CAN          void            bsp_CAN_Sleep(void);
    EXTERN_BSP_CAN          void            bsp_CAN_SleepRelease(void);
    EXTERN_BSP_CAN          void            bsp_CAN_BusOff_Recover(void);    
    EXTERN_BSP_CAN          CanState_t      GetBusOffState(void);
    EXTERN_BSP_CAN          uint8_t         CAN0_Get_Wake_Up_Flag ( void );
    EXTERN_BSP_CAN          uint8_t         CanSendLock;
    EXTERN_BSP_CAN  volatile    uint8_t                   g_bReturn;  
    EXTERN_BSP_CAN          uint8_t Get_CH0_BusOffStatus(void);
    EXTERN_BSP_CAN          uint8_t bsp_Is_CAN_Sleep(void);
    EXTERN_BSP_CAN          void bsp_CAN_MaskCheck(void);
    
#endif /* BSP_CAN_H_ */
