#ifdef U2_GLOBALS_TP_DIAGNO
#define U2_EXTERN_TP_DIAGNO
#else
#define U2_EXTERN_TP_DIAGNO extern
#endif

#ifndef _U2_TP_DIAGNO_H_
#define _U2_TP_DIAGNO_H_

#include "U2_uds_includes.h"

#define U2_SingleFrame 0x00
#define U2_FirstFrame 0x10
#define U2_ConsecutiveFrame 0x20
#define U2_FlowControlFrame 0x30
#define U2_FC_WAIT 0x31

typedef struct
{
    uint32_t id;
    uint8_t msg[8];
    uint8_t dlc;
} _U2_SendCanMsg;
U2_EXTERN_TP_DIAGNO volatile _U2_SendCanMsg U2_g_txCanMsg;

extern volatile _U2_N_USData U2_N_US_R_MultiData;
extern volatile _U2_N_USData U2_N_US_S_MultiData;
extern volatile _U2_N_RSPData U2_N_RSPData;
extern volatile _U2_N_US_Data_FF U2_N_US_R_Data_FF;
extern volatile _U2_N_US_Data_FF U2_N_US_S_Data_FF;
extern volatile _U2_N_USSFData U2_N_USSFData[2];
extern volatile uint16_t U2_N_RecLen;

U2_EXTERN_TP_DIAGNO uint8_t U2_TP_CalMsgLen(uint16_t BIT_DATA, uint8_t SnLoop);
U2_EXTERN_TP_DIAGNO void U2_TP_AbnormalInResSF_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_AbnormalInResFC_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_AbnormalInResCF_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_AbnormalInReqFC_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_NormalRecFC_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_Buffer_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_UnknownlPDU_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_ReciveSF_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_ReciveMultiF_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_AbnormalInReqFF_handle(void);
U2_EXTERN_TP_DIAGNO void U2_TP_NormalSendFC_Fun(void);
U2_EXTERN_TP_DIAGNO void U2_TP_TooShortDLC_handle(_U2_LinkData *LK_Data);
U2_EXTERN_TP_DIAGNO void U2_TP_TransmitPDU(void);
U2_EXTERN_TP_DIAGNO void U2_TP_TransmitNegatePDU(_U2_ErrorFrame *Err);

U2_EXTERN_TP_DIAGNO void U2_TP_SetSTminTimer(uint32_t Second, _U2_DiagClock *T);
U2_EXTERN_TP_DIAGNO uint8_t U2_TP_STminTimerOver(_U2_DiagClock *T);

U2_EXTERN_TP_DIAGNO void U2_TP_SetBsTimer(uint32_t Second, _U2_DiagClock *T);
U2_EXTERN_TP_DIAGNO uint8_t U2_TP_BsTimerOver(_U2_DiagClock *T);

U2_EXTERN_TP_DIAGNO void U2_TP_SetCrTimer(uint32_t Second, _U2_DiagClock *T);
U2_EXTERN_TP_DIAGNO uint8_t U2_TP_CrTimerOver(_U2_DiagClock *T);

#endif /* _TP_DIAGNO_H_ */
