
#include "Fuel.h"
#include "gpio.h"
#include "Analog_Signals.h"
#include "Common_Interface.h"
#include "Flash_synchronizer.h"

_Fuel_Dis FuelDis;
_FuelData Fuel_Data;
void Fuel_KL30_Init(void)
{
    PORT_ClrBit(Fuel_Vcc_en);

    Fuel_Data.u8FuelInitFlag = 0u;
    Fuel_Data.FuelDir = Up_Dir;
    Fuel_Data.FuelSensorState = FuelSensorNormal;
    Fuel_Data.u8FuelDataCount = 0u;
    for (uint8_t i = 0; i < FUEL_DATA_NUM; i++)
    {
        Fuel_Data.FuelDataBuffer[i] = 0;
    }

    Fuel_Data.FuelDataArray[0] = 0u;    /* Short */
    Fuel_Data.FuelDataArray[1] = 970u;  /* Seg1 */
    Fuel_Data.FuelDataArray[2] = 790u;  /* Seg2 */
    Fuel_Data.FuelDataArray[3] = 610u;  /* Sge3 */
    Fuel_Data.FuelDataArray[4] = 430u;  /* Seg4 */
    Fuel_Data.FuelDataArray[5] = 250u;  /* Seg5 */
    Fuel_Data.FuelDataArray[6] = 1100u; /* Open */

    Fuel_Data.u8FuelInitFlag = 1;
    Fuel_Data.u8FuelInitState = 1;
    Fuel_Data.u8FuelADCompleteFlg = 0;
    Fuel_Data.u16SensorNormalTimer = 0;
    Fuel_Data.u16SensorOpenTimer = 0;
    Fuel_Data.u16SensorShortTimer = 0;

    FuelDis.u8Curseg = 0;
    FuelDis.u8DestSeg = 0;
    FuelDis.u16Down_Timer = Creep_Down_Up_Timer;
}

void Fuel_KL15_Init(void)
{
    PORT_SetBit(Fuel_Vcc_en);
    Fuel_Data.FuelDir = Up_Dir;
    Fuel_Data.FuelSensorState = FuelSensorNormal;
    Fuel_Data.u8FuelDataCount = 0u;
    for (uint8_t i = 0; i < FUEL_DATA_NUM; i++)
    {
        Fuel_Data.FuelDataBuffer[i] = 0;
    }

    Fuel_Data.FuelDataArray[0] = 0u;    /* Short */
    Fuel_Data.FuelDataArray[1] = 970u;  /* Seg1 */
    Fuel_Data.FuelDataArray[2] = 790u;  /* Seg2 */
    Fuel_Data.FuelDataArray[3] = 610u;  /* Sge3 */
    Fuel_Data.FuelDataArray[4] = 430u;  /* Seg4 */
    Fuel_Data.FuelDataArray[5] = 250u;  /* Seg5 */
    Fuel_Data.FuelDataArray[6] = 1100u; /* Open */

    Fuel_Data.u8FuelInitFlag = 1;
    Fuel_Data.u8FuelInitState = 1;
    Fuel_Data.u8FuelADCompleteFlg = 0;
    Fuel_Data.u16SensorNormalTimer = 0;
    Fuel_Data.u16SensorOpenTimer = 0;
    Fuel_Data.u16SensorShortTimer = 0;

    FuelDis.u8Curseg = 0;
    FuelDis.u8DestSeg = 0;
    FuelDis.u16Down_Timer = Creep_Down_Up_Timer;
}
/**
 * @brief 燃油采集计算服务
 *
 */
void Fuel_R_Cal(uint8_t deltaTime)
{
    uint16_t FuelRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;

    if (Fuel_Data.u8FuelCollectCount >= FUEL_DATA_TIME) /* 多久采集一次燃油数据 */
    {
        Fuel_Data.u8FuelCollectCount = 0;
        if (Fuel_Data.u8FuelDataCount < FUEL_DATA_NUM)
        {
            /*获取燃油电阻*/
            FuelRes = 0;

            /*四舍五入*/
            if (FuelRes < Fuel_Data.FuelDataArray[6]) /* 小于开路阻值 */
            {
                if (FuelRes % 10 >= 5)
                {
                    FuelRes += 5;
                }
            }
            else
            {
                FuelRes = Fuel_Data.FuelDataArray[6];
            }
            /*由小到大插入数据*/
            for (i = 0; i < Fuel_Data.u8FuelDataCount; i++)
            {
                if (FuelRes < Fuel_Data.FuelDataBuffer[i])
                {
                    break;
                }
            }
            for (j = Fuel_Data.u8FuelDataCount; j > i; j--)
            {
                Fuel_Data.FuelDataBuffer[j] = Fuel_Data.FuelDataBuffer[j - 1];
            }
            Fuel_Data.FuelDataBuffer[i] = FuelRes;
            Fuel_Data.u8FuelDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = FUEL_CAL_START; i < FUEL_CAL_END; i++)
            {
                temp32 += Fuel_Data.FuelDataBuffer[i];
            }
            Fuel_Data.Fuel_Res = temp32 / (FUEL_CAL_END - FUEL_CAL_START);
            Fuel_Data.u8FuelDataCount = 0;
            Fuel_Data.u8FuelADCompleteFlg = 1;
        }
    }
    Fuel_Data.u8FuelCollectCount += deltaTime;
}

/**
 * @brief 检查燃油传感器状态
 *
 */
void Fuel_State_Check(uint8_t deltaTime)
{

    // if (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[0])
    //{ /*短路 1*/
    //     Fuel_Data.u16SensorOpenTimer = 0;
    //     Fuel_Data.u16SensorNormalTimer = 0;
    //     if ((Fuel_Data.u16SensorShortTimer > Fuet_Short_Dealy_Timer) || ((Fuel_Data.u8FuelInitState) && (Fuel_Data.u16SensorShortTimer > Fuet_Short_Dealy_Timer)))
    //     {
    //         Fuel_Data.FuelSensorState = FuelSensorShortCircuit;
    //         FuelDis.u8DestSeg = 0;
    //         FuelDis.u8Curseg = 0;
    //         Fuel_Data.u8FuelInitState = 0;
    //         Fuel_Data.u8FuelInitFlag = 1;
    //         Fuel_Data.FuelDir = FUEL_SEG_UP;
    //     }
    //     else
    //     {
    //         Fuel_Data.u16SensorShortTimer += deltaTime;
    //     }
    // }
    // else
    if (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[6]) /* 开路 */
    {
        Fuel_Data.u16SensorShortTimer = 0;
        Fuel_Data.u16SensorNormalTimer = 0;
        if ((Fuel_Data.u16SensorOpenTimer > Fuel_Open_Dealy_Timer) || ((Fuel_Data.u8FuelInitState) && (Fuel_Data.u16SensorOpenTimer > Fuel_Open_Dealy_Timer)))
        {
            Fuel_Data.FuelSensorState = FuelSensorOpenCircuit;
            FuelDis.u8DestSeg = 0;
            FuelDis.u8Curseg = 0;
            Fuel_Data.u8FuelInitState = 0;
            Fuel_Data.u8FuelInitFlag = 1;
            Fuel_Data.FuelDir = Up_Dir;
        }
        else
        {

            Fuel_Data.u16SensorOpenTimer += deltaTime;
        }
    }
    else
    {
        Fuel_Data.u16SensorShortTimer = 0;
        Fuel_Data.u16SensorOpenTimer = 0;
        if (Fuel_Data.u16SensorNormalTimer > Fuel_Normal_Dealy_Timer)
        {
            Fuel_Data.FuelSensorState = FuelSensorNormal;
            Fuel_Data.u8FuelInitState = 0;
        }
        else
        {
            Fuel_Data.u16SensorNormalTimer += deltaTime;
        }
    }
}

/**
 * @brief 燃油显示服务
 *
 */
void Fuel_Gauges_Cal(uint8_t deltaTime)
{

    if ((Fuel_Data.FuelSensorState == FuelSensorNormal) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[0]) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[6]))
    {
        /*采集完第一组数据后，开始计算燃油格数*/
        if (Fuel_Data.u8FuelADCompleteFlg)
        {
            if (Fuel_Data.u8FuelInitFlag)
            {
                Fuel_Data.Fuel_Res_Back = Fuel_Data.Fuel_Res;
            }
            /*根据回差计算走动方向*/
            if (Fuel_Data.FuelDir == Up_Dir)
            {

                if (Fuel_Data.Fuel_Res >= Fuel_Data.Fuel_Res_Back + RETURN_DIFFERENCE)
                {
                    Fuel_Data.FuelDir = Down_Dir;
                    Fuel_Data.Fuel_Res_Back = Fuel_Data.Fuel_Res;
                }
                if (Fuel_Data.Fuel_Res < Fuel_Data.Fuel_Res_Back)
                {
                    Fuel_Data.Fuel_Res_Back = Fuel_Data.Fuel_Res;
                }
            }
            else
            {
                if (Fuel_Data.Fuel_Res_Back >= Fuel_Data.Fuel_Res + RETURN_DIFFERENCE)
                {
                    Fuel_Data.FuelDir = Up_Dir;
                    Fuel_Data.Fuel_Res_Back = Fuel_Data.Fuel_Res;
                }
                if (Fuel_Data.Fuel_Res > Fuel_Data.Fuel_Res_Back)
                {
                    Fuel_Data.Fuel_Res_Back = Fuel_Data.Fuel_Res;
                }
            }

            /*计算目标格数*/

            if (Fuel_Data.FuelDir == Up_Dir)
            {
                if (((FuelDis.u8DestSeg == 4) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[5]))
                {
                    FuelDis.u8DestSeg = 5;
                }
                else if (((FuelDis.u8DestSeg == 3) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[4]))
                {
                    FuelDis.u8DestSeg = 4;
                }
                else if (((FuelDis.u8DestSeg == 2) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[3]))
                {
                    FuelDis.u8DestSeg = 3;
                }
                else if (((FuelDis.u8DestSeg == 1) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[2]))
                {
                    FuelDis.u8DestSeg = 2;
                }
                else if (((FuelDis.u8DestSeg == 0) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res < Fuel_Data.FuelDataArray[1]))
                {
                    FuelDis.u8DestSeg = 1;
                }
            }
            else if (Fuel_Data.FuelDir == Down_Dir)
            {
                if (((FuelDis.u8DestSeg == 1) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[1]))
                {
                    FuelDis.u8DestSeg = 0;
                }
                else if (((FuelDis.u8DestSeg == 2) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[2]))
                {
                    FuelDis.u8DestSeg = 1;
                }
                else if (((FuelDis.u8DestSeg == 3) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[3]))
                {
                    FuelDis.u8DestSeg = 2;
                }
                else if (((FuelDis.u8DestSeg == 4) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[4]))
                {
                    FuelDis.u8DestSeg = 3;
                }
                else if (((FuelDis.u8DestSeg == 5) || (Fuel_Data.u8FuelInitFlag)) && (Fuel_Data.Fuel_Res >= Fuel_Data.FuelDataArray[5]))
                {
                    FuelDis.u8DestSeg = 4;
                }
            }
            if (Fuel_Data.u8FuelInitFlag == 1) /* 首次上电 当前格等于目标格 */
            {
                FuelDis.u8Curseg = FuelDis.u8DestSeg;
                Fuel_Data.u8FuelInitFlag = 0;
            }
        }

        /* 阻尼处理 上升下降每10S一格 */
        if (FuelDis.u8Curseg > FuelDis.u8DestSeg) /* 下降方向 */
        {
            FuelDis.u16Up_Timer = 0;
            FuelDis.u16Down_Timer += deltaTime;
            if (FuelDis.u16Down_Timer >= Creep_Down_Up_Timer)
            {
                FuelDis.u8Curseg--;
                FuelDis.u16Down_Timer = 0;
            }
        }
        else if (FuelDis.u8Curseg < FuelDis.u8DestSeg) /* 上升方向 */
        {
            FuelDis.u16Down_Timer = 0;
            FuelDis.u16Up_Timer += deltaTime;
            if (FuelDis.u16Up_Timer >= Creep_Down_Up_Timer)
            {
                FuelDis.u8Curseg++;
                FuelDis.u16Up_Timer = 0;
            }
        }
        else
        {
            FuelDis.u16Down_Timer = 0;
            FuelDis.u16Up_Timer = 0;
            FuelDis.u8Curseg = FuelDis.u8DestSeg;
        }
    }
}

/**
 * @brief 用于计算燃油电阻值
 * 10ms 调用
 */
void Fuel_Res_Call(uint8_t deltaTime)
{
    Fuel_R_Cal(deltaTime);
}

/**
 * @brief 燃油服务函数
 * 100ms
 */
void Fuel_Cal_Sevice(uint8_t deltaTime)
{
    /*检测燃油电阻状态*/
    Fuel_State_Check(deltaTime);
    /*显示燃油格*/
    Fuel_Gauges_Cal(deltaTime);
}

/**
 * @brief 获取燃油当前格数
 * @return 格数 Seg0~Sge5
 */
uint8_t Get_CurFuelSetp(void)
{
    return FuelDis.u8Curseg;
}
/**
 * @brief 获取燃油传感器状态
 * @return 0 FuelSensorNormal
 *         1 FuelSensorShortCircuit
 *         2 FuelSensorOpenCircuit
 */
FuelSensorSts_t Get_Fuel_Sensor_State(void)
{
    return Fuel_Data.FuelSensorState;
}
