

#ifndef TELLTALES_H
#define TELLTALES_H


	#define Tellib_uint8_t  unsigned char
	#define Tellib_uint16_t unsigned short
	#define Tellib_uint32_t unsigned int
	#define Tellib_uint64_t unsigned long long




#define Tel_MEM_Block_Addition ((Tellib_uint8_t)16u)
#define Tel_MEM_Block_Size (((Tellib_uint8_t)2u))
/*
total size =Tel_MEM_Block_Size*LED_Max+Tel_MEM_Block_Addition
*/
#define LED_OFF (Tellib_uint8_t)(0x00u)
#define LED_ON  (Tellib_uint8_t)(0x01u)

#define Diag_LED_OFF (Tellib_uint8_t)(0x10u)
#define Diag_LED_ON  (Tellib_uint8_t)(0x11u)

#define NoSelfCheck (Tellib_uint8_t)(0x00u)
#define SelfCheck   (Tellib_uint8_t)(0x01u)

#define LED_Exist   (Tellib_uint8_t)(0x00u)
#define LED_NOExist (Tellib_uint8_t)(0x01u)

#define AllowBreak (Tellib_uint8_t)(0x00u)
#define NoBreak    (Tellib_uint8_t)(0x01u)

#define NoExterNalCheck (Tellib_uint8_t)(0x00u)
#define ExterNalCheck   (Tellib_uint8_t)(0x01u)

#define LED_IGN_OFF    (Tellib_uint8_t)(0x00u)
#define LED_IGN_ON     (Tellib_uint8_t)(0x01u)
#define LED_IGN_ON_OFF (Tellib_uint8_t)(0x02u)

#define LED_PWR_OFF (Tellib_uint8_t)(0x00u)
#define LED_PWR_ON  (Tellib_uint8_t)(0x01u)

#define LED_CheckNoFinish (Tellib_uint8_t)(0x00u)
#define LED_CheckFinished (Tellib_uint8_t)(0x01u)

#define LED_OFF_State (Tellib_uint8_t)(0x00u)
#define LED_ON_State  (Tellib_uint8_t)(0x01u)

typedef Tellib_uint16_t (*LED_Judgment)(void);
typedef void (*LED_Execution)(Tellib_uint16_t led_status);

typedef Tellib_uint8_t (*LED_PowerSts)(void);
typedef Tellib_uint32_t (*LED_PowerONTimer)(void);
typedef Tellib_uint32_t (*LED_PowerOFFTimer)(void);

typedef struct
{
    Tellib_uint32_t   TotalLength;
    LED_PowerOFFTimer LED_PowerOFF_TimerCbk;
    LED_PowerONTimer  LED_PowerON_TimerCbk;
    LED_PowerSts      LED_PowerCbk;
} TelExtPara;

typedef struct
{
    Tellib_uint16_t LED_Index;
    Tellib_uint16_t isSelfCheck;
    Tellib_uint16_t isExCheck;
    Tellib_uint16_t WorkSts;

    Tellib_uint32_t CheckStart;
    Tellib_uint32_t CheckEnd;

    LED_Judgment  LED_Judgment_Cbk;
    LED_Execution LED_Execution_Cbk;
} LED_Attribute_st;

Tellib_uint16_t  Get_TelltalesLedSts(Tellib_uint32_t LedIdx);
Tellib_uint16_t Tel_VersionGet(void);

void Telltales_Management(void);
void Test_LED_AllLight(Tellib_uint16_t LedSts);
void Telltales_KL30_Wakeup_Init(Tellib_uint8_t *MemSpace, const LED_Attribute_st *Array, TelExtPara *para);
void Telltales_DiagCtrl(Tellib_uint32_t ledIdx, Tellib_uint8_t LED_Sts);
void Telltales_DiagRelease(Tellib_uint32_t ledIdx);

void Telltales_KL15_Init(void);
void Telltales_SetCheckFinish(Tellib_uint8_t CheckFinish);

#endif
