#include "CAN_User.h"

#include "can.h"
#include "CAN_Communication_Matrix.h"
#include "gpio.h"
#include "uds_includes.h"
#include "U2_uds_includes.h"
#include <string.h>
#include "PowerManagement_user.h"

#include "Common_Interface.h"


#include "Fuel.h"
#include "Telltales_user.h"


#include "Services_Mileage_User.h"
#include "U2_app_Service.h"
#include "System_Monitor.h"
#include "Services_Mileage.h"

#include "Flash_synchronizer.h"

static int16_t SendTempValue = 0;
static RSCAN0BusoffMonitorStruct     RSCAN0Busoff;
uint8_t BusOffEvent;
uint8_t BUS_OFF_FLAG;
uint32_t CanSleepDelayTime = 0;
static uint8_t UDSSendStep = 0;
volatile uint16_t ReqSilentTimer = 0; //  静默计时�?

static uint32_t CurFault[25];
static uint32_t HisFault[25];
static uint8_t CurFaultNum = 0;
static uint8_t HisFaultNum = 0;


uint16_t Get_ReqSilentTimer(void)
{
    return ReqSilentTimer;
}
uint8_t Get_RSCAN0Busoff_Status(void)
{
    return RSCAN0Busoff.Status;
}
void Set_ReqSilentTimer(uint16_t data)
{
    ReqSilentTimer = data;
}
void ReqSilentTimer100mSService(void)
{
    if (ReqSilentTimer > 0)
        ReqSilentTimer--;
}
void Set_CanSleepDelayTime(uint32_t data)
{
    CanSleepDelayTime = data;

}

uint32_t Get_CanSleepDelayTime(void)
{
    return CanSleepDelayTime;

}

void Can_Set_Buff_105(uint8_t CopyData[])
{
    //uint8_t temp8 = 0;
    uint16_t temp16 = 0;

    CopyData[0] = 9;  /* 1  */

    temp16 = Common_Get_Disp_E_Speed();
    
    CopyData[1] = temp16>>8;
    CopyData[2] = temp16&0xff;

    CopyData[3] = 0u; /* 4  */
    CopyData[4] = 0u; /* 5  */
    CopyData[5] = 0u; /* 6  */

    temp16 = Common_Get_Disp_V_Speed();
		if(temp16>1990)		temp16=1990;
    temp16 /= 10;    
    CopyData[6] = temp16>>8;
    CopyData[7] = temp16&0xff;    
}

void Can_Set_Buff_51C(uint8_t CopyData[])
{
    CopyData[0] = 0;  /* 1  */
    CopyData[1] = 0;  /* 2  */
    CopyData[2] = 0;  /* 3  */
    CopyData[3] = 0u; /* 4  */
    CopyData[4] = 0u; /* 5  */

    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */
    //外销状�?�（此信号外发应�?0�?    
    //0 = 内销
    //1 = 外销
    CopyData[5] |= 0;
    
    //仪表类型外发（此信号外发应发1�?
    //0 = 保留
    //1 = LCD
    //2 = TFT
    CopyData[5] |= 1<<1;    
}
extern uint16_t FuelR;
void Can_Set_Buff_510(uint8_t CopyData[])
{
    uint16_t temp16 = 0;
    //    Receive_ID_12_Struct * msg_0x12;
    //    Get_Msg_0x12(&msg_0x12);



    CopyData[0] = 0u; /* 1  */
    // CopyData[1] = 0u; /* 2  */
    // CopyData[2] = 0u; /* 3  */
    // CopyData[3] = 0u; /* 4  */
    // CopyData[4] = 0u; /* 5  */
    CopyData[5] = 0u; /* 6  */
    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */

    if(Get_Fuel_Sensor_State() == FuelSensorShortCircuit){
        CopyData[0] = 0x07;
    }
    else if(Get_Fuel_Sensor_State() == FuelSensorOpenCircuit){
        CopyData[0] = 0x0A;
    }
    else { /*FuelSensorNormal*/
        CopyData[0] = Get_CurFuelSetp();
    }



    temp16 = FuelR/10;
    if(FuelR>3100){
        temp16 = 320;
    }
    CopyData[2] = (temp16>>8)&0xff;
    CopyData[3] = temp16&0xff;



}
void Can_Set_Buff_523(uint8_t CopyData[])
{
    uint32_t temp32;

    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */
    temp32 = Data_Read_Trip(EM_TRIP_A);
    temp32 /= 100;
    CopyData[0] = temp32/10000;
    
    CopyData[1] = (temp32%10000)/1000;
    CopyData[1] <<= 4;
    CopyData[1] |= (temp32%1000)/100;
    
    CopyData[2]  = (temp32%100)/10;
    CopyData[2] <<= 4;
    CopyData[2] |= (temp32%10);    

    temp32 = Data_Read_Trip(EM_TRIP_B);
    temp32 /= 100;
    CopyData[3] = temp32/10000;
    
    CopyData[4] = (temp32%10000)/1000;
    CopyData[4] <<= 4;
    CopyData[4] |= (temp32%1000)/100;
    
    CopyData[5]  = (temp32%100)/10;
    CopyData[5] <<= 4;
    CopyData[5] |= (temp32%10); 
    
}
void Can_Set_Buff_450(uint8_t CopyData[])
{
	uint8_t i = 6;
    uint8_t temp8 = 0;

    CopyData[0] = 0;  /* 1  */
    // CopyData[1] = 0;  /* 2  */
    CopyData[2] = 0u; /* 3  */
    CopyData[3] = 0u; /* 4  */
    CopyData[4] = 0u; /* 5  */
    CopyData[5] = 0u; /* 6  */
    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */


    

    CopyData[1] = temp8 & 0x0f;

}
void Can_Set_Buff_515(uint8_t CopyData[])
{
    uint16_t temp16 = 0;
    uint32_t temp32 = 0;
//    static uint32_t CurFault[25];
//    static uint32_t HisFault[25];
//    static uint8_t CurFaultNum = 0;
//    static uint8_t HisFaultNum = 0;
    static uint8_t FauleSendStep = 0;
    static uint8_t CurFaultSendCount = 0;
    static uint8_t HisFaultSendCount = 0;
    //_BCM_Module bcm_module_temp;

    

    




    if ((CAN_SIG_LOST == CAN_MSG_Status(ID_ECU_Count)) && (CAN_SIG_LOST == CAN_MSG_Status(ID_ECU_DTC_Count)))
    {
        temp16 = 1;
    }
    else
    {
        temp16 = 0;
    }
    CopyData[0] = temp16 & 0x01;

    CopyData[1] = 0;  /* 2  */
    CopyData[2] = 0u; /* 3  */
    CopyData[3] = 0u; /* 4  */
    

   


    if(SendTempValue >= (-40)){
        temp16 = (uint16_t)(SendTempValue + 40);
    }
    else{
        temp16 = 0;
    }
    CopyData[4] = temp16>>8;
    CopyData[5] = temp16&0xff;
    
    //step0:判断是否有故�?
    if(FauleSendStep == 0){
        if(CurFaultNum || HisFaultNum){
            FauleSendStep = 1;
        }
        else{
            temp32 = 0;
            goto SEND_FAULT_END;
        }
    }
    //发�?�当前故�? 
    //step1:发�??7777标志
    if(FauleSendStep == 1){
        if(CurFaultNum){
            temp32 = 0x77770000;
            FauleSendStep = 2;
            CurFaultSendCount = 0;
            goto SEND_FAULT_END;
        }
        else{
            FauleSendStep = 4;
        }
    }
    //step2:连续发�?�故�?
    if(FauleSendStep == 2){
        if(CurFaultSendCount < CurFaultNum){
            temp32 = CurFault[CurFaultSendCount];
            CurFaultSendCount++;
            goto SEND_FAULT_END;
        }
        else{
            FauleSendStep = 3;
        }
    }
    //step3:发�?�结束标�?
    if(FauleSendStep == 3){
        temp32 = 0x99990000;
        if(HisFaultNum){
            FauleSendStep = 4;
        }
        else{
            FauleSendStep = 0;
        }
        goto SEND_FAULT_END;
    }

    //发�?�历史故�?
    //step4:发�??8888标志
    if(FauleSendStep == 4){
        if(HisFaultNum){
            temp32 = 0x88880000;
            FauleSendStep = 5;
            HisFaultSendCount = 0;
            goto SEND_FAULT_END;
        }
        else{
            FauleSendStep = 0;
            temp32 = 0;
            goto SEND_FAULT_END;
        }
    }
    //step5:连续发�?�故�?
    if(FauleSendStep == 5){
        if(HisFaultSendCount < HisFaultNum){
            temp32 = HisFault[HisFaultSendCount];
            HisFaultSendCount++;
            goto SEND_FAULT_END;
        }
        else{
            FauleSendStep = 6;
        }
    }
    //step6:发�?�结束标�?
    if(FauleSendStep == 6){
        temp32 = 0x99990000;
        FauleSendStep = 0;
        goto SEND_FAULT_END;
    }

SEND_FAULT_END:    
    temp32 >>= 16;
    CopyData[6] = temp32>>8;
    CopyData[7] = temp32&0xff;
}
/* extern uint8_t ModfyODORemainTimes; */
void Can_Set_Buff_522(uint8_t CopyData[])
{
    uint32_t temp32 = 0;
    uint16_t temp16 = 0;

     CopyData[4] = 0u; /* 5  */
     CopyData[5] = 0u; /* 6  */

 
     temp32 = Data_ODO_Read( );
     temp32 /= 100;
     
     CopyData[0] = temp32/1000000;
     
     CopyData[1] = (temp32%1000000)/100000;
     CopyData[1] <<= 4;
     CopyData[1] |= (temp32%100000)/10000;
     
     CopyData[2]  = (temp32%10000)/1000;
     CopyData[2] <<= 4;
     CopyData[2] |= (temp32%1000)/100;     

     CopyData[3]  = (temp32%100)/10;
     CopyData[3] <<= 4;
     CopyData[3] |= (temp32%10);     

  /*   CopyData[4] |= ModfyODORemainTimes&0x0f; */
     temp16 = Common_Get_Disp_V_Speed();
		 if(temp16>1990)		temp16=1990;
     temp16 /= 10;    
     CopyData[6] = temp16>>8;
     CopyData[7] = temp16&0xff;  

}

void Can_Set_Buff_502(uint8_t CopyData[])
{
	uint8_t temp8 = 0;
	CopyData[1] = 0U;
	CopyData[2] = 0U;
	CopyData[3] = 0U;
	CopyData[4] = 0U;
	CopyData[5] = 0U;
	CopyData[6] = 0U;
	CopyData[7] = 0U;


	CopyData[0] = temp8 << 2;
		


}


void Send_22_ID0005(void)
{
  /*  uint8_t SendUdsData[8];
    SendUdsData[0] = 0x03;
    SendUdsData[1] = 0x22;
    SendUdsData[2] = 0x62;
    SendUdsData[3] = 0x02;
    SendUdsData[4] = 0u;
    SendUdsData[5] = 0u;
    SendUdsData[6] = 0u;
    SendUdsData[7] = 0u;
    g_bReturn = bsp_CANSendFrame(0x767, txResNum, (uint8_t *)&SendUdsData[0], 8);*/
    st_CAN_Msg canMag;
    canMag.MsgID = U2_ID_BCM_PhyAddr;
    canMag.Msg[0] = 0x03u;
    canMag.Msg[1] = 0x22u;
    canMag.Msg[2] = 0x00;
    canMag.Msg[3] = 0x05;
    canMag.Msg[4] = 0;
    canMag.Msg[5] = 0;
    canMag.Msg[6] = 0;
    canMag.Msg[7] = 0;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 9u;
    canMag.MsgStd = 0;
    Can_Write(&canMag);
}

void Send_19_0209(void)
{
    /*uint8_t SendUdsData[8];
    SendUdsData[0] = 0x03;
    SendUdsData[1] = 0x19;
    SendUdsData[2] = 0x02;
    SendUdsData[3] = 0x09;
    SendUdsData[4] = 0u;
    SendUdsData[5] = 0u;
    SendUdsData[6] = 0u;
    SendUdsData[7] = 0u;
    g_bReturn = bsp_CANSendFrame(0x747, txResNum, (uint8_t *)&SendUdsData[0], 8);*/
    st_CAN_Msg canMag;
    canMag.MsgID = U2_ID_BCM_PhyAddr;
    canMag.Msg[0] = 0x03;
    canMag.Msg[1] = 0x19;
    canMag.Msg[2] = 0x02;
    canMag.Msg[3] = 0x21;
    canMag.Msg[4] = 0;
    canMag.Msg[5] = 0;
    canMag.Msg[6] = 0;
    canMag.Msg[7] = 0;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 10u;
    canMag.MsgStd = 0;
    Can_Write(&canMag);
}
void Send_01_01(void)
{
    /*uint8_t SendUdsData[8];
    SendUdsData[0] = 0x02;
    SendUdsData[1] = 0x01;
    SendUdsData[2] = 0x01;
    SendUdsData[3] = 0x00;
    SendUdsData[4] = 0u;
    SendUdsData[5] = 0u;
    SendUdsData[6] = 0u;
    SendUdsData[7] = 0u;
    g_bReturn = bsp_CANSendFrame(0x7DF, txResNum, (uint8_t *)&SendUdsData[0], 8);*/

    st_CAN_Msg canMag;
    canMag.MsgID = 0X7df;
    canMag.Msg[0] = 0x02;
    canMag.Msg[1] = 0x01;
    canMag.Msg[2] = 0x01;
    canMag.Msg[3] = 0;
    canMag.Msg[4] = 0;
    canMag.Msg[5] = 0;
    canMag.Msg[6] = 0;
    canMag.Msg[7] = 0;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 11u;
    canMag.MsgStd = 0;
    Can_Write(&canMag);
}
void CAN_SendAppMesageOpinion(void)
{

    CAN_TX_SetEnable(CAN_APP_TX_ENABLE);
}
uint8_t CanLibSendFlag=0;
uint8_t Can_Write(st_CAN_Msg *Msg)
{
    if (CanSendLock == 0)
    {
        CanSendLock = 1;
        switch (Msg->MsgPro)
        {

        case 2:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 3:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 4:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 5:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 6:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 7:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 8:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 9:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
        case 10:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;
         case 11:
            g_bReturn = bsp_CANSendFrame(Msg->MsgID, txCommon, Msg->Msg, Msg->MsgDLC);
            break;    
        default:
            //CAN_CH0_Data_Request(Msg->MsgID, Msg->MsgStd, Msg->MsgRTR, Msg->MsgDLC, Msg->Msg);
            break;
        }
    }
    else
    {
        return 1;
    }
    CanLibSendFlag = 1;
    return 0;
}
static uint32_t pTXBuff[CAN_TX_MSG_Block * ID_SEND_TOTAL];


static uint32_t pRXBuff[CAN_RX_MSG_Block * ID_TOTAL_MAX];

static _BCM_Module BCM_Module = BCM_UNKNOW;
uint8_t LianDianModuleFlg = 0;
uint8_t DelfuModuleFlg = 0;
void LianDianModuleIn(void)
{
    LianDianModuleFlg = 1;
}
void DelfuModuleIn(void)
{
    DelfuModuleFlg = 1;
}

_BCM_Module Get_Bcm_Module(void)
{
    return BCM_Module;
}
void CAN_Check_Liandian(void)
{
    if(LianDianModuleFlg){
        /*if(CAN_SIG_LOST == CAN_MSG_Status(ID_ECU_Engine_Data_M2_Msg_Count)){
            LianDianModuleFlg = 0;
        }*/
        BCM_Module = BCM_LIANDIAN;
    }
  //  else if(DelfuModuleFlg){
    else{//不检测德尔福识别标志，只要不是联电，就认为是德尔�?
        DelfuModuleFlg = 0;
        BCM_Module = BCM_DELFU;
    }
}
uint8_t CAN_Initflag = 0;
void APP_CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/
    Can_TX_BuffInit((uint8_t *)pTXBuff, st_CANSendAttr, ID_SEND_TOTAL, Can_Write);
    Can_RX_BuffInit((uint8_t *)pRXBuff, CAN_MSG_CONST_ARRAY, ID_TOTAL_MAX);
    CAN_RX_SetEnable(0u);
    CAN_TX_SetEnable(CAN_APP_TX_ENABLE);
    PORT_ClrBit(CAN_STB_MCU);
    BCM_Module = BCM_UNKNOW;
    SendTempValue = 0;
    UDSSendStep = 0;
    CAN_Initflag = 0xeb;
}
void CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/
    Can_TX_BuffInit((uint8_t *)pTXBuff, st_CANSendAttr, ID_SEND_TOTAL, Can_Write);
    Can_RX_BuffInit((uint8_t *)pRXBuff, CAN_MSG_CONST_ARRAY, ID_TOTAL_MAX);
    CAN_RX_SetEnable(0u);
    CAN_TX_SetEnable(CAN_APP_TX_ENABLE);
    PORT_ClrBit(CAN_STB_MCU);
}

void CAN_RX_Tick(void)
{
    CanMSg_XMS_Analysis(5U);
}

void CAN_TX_Tick(void)
{
    Can_Write_Fun(2000UL);
}

void Can_Receive_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{
    // ReceivedMsg(m_id, m_dlc);

    Co_Can_Buff_Set(Co_Can_ConvertSubID(m_id), m_dlc, m_Msg);
}
uint32_t SendUdsTimeCount_190209 = 0;
uint32_t SendUdsTimeCount_220005 = 0;
uint32_t SendUdsTimeCount_0101 = 0;

void SetSendUdsTimeCount_190209(uint32_t data)
{
    SendUdsTimeCount_190209 = data;
}
void SetSendUdsTimeCount_220005(uint32_t data)
{
    SendUdsTimeCount_220005 = data;
}
void SetSendUdsTimeCount_0101(uint32_t data)
{
    SendUdsTimeCount_0101 = data;
}
uint32_t DTCCurFaultTimes = 0;
uint32_t DTCHisFaultTimes = 0;
extern COMMON_PowerStatus_t Common_Get_IG_Sts(void);
void Diag_Req_Send(uint16_t Diag_Time_SendCn) /* Trainmit 2ms */
{
    COMMON_PowerStatus_t Diag_PowerState;
    _BCM_Module Module;

    Module = Get_Bcm_Module();
   // if((Module  == BCM_UNKNOW) || (Module  == BCM_DELFU))
    {
        Diag_PowerState = Common_Get_IG_Sts();
        if (Diag_PowerState == COMMON_POWER_ON)
        {
            if (DTCCurFaultTimes < 0xffffffff)
            {

                DTCCurFaultTimes += Diag_Time_SendCn;
            }
            else
                ;
            if (DTCHisFaultTimes < 0xffffffff)
            {

                DTCHisFaultTimes += Diag_Time_SendCn;
            }
            else
                ;

            if ((CanSendLock == 0) && (DiagnoCtl.CommCtl == 0) && (Get_ReqSilentTimer() == 0))
            {
             //   CanLibSendFlag = 0;

                switch(UDSSendStep){
                    case 0:
                        Send_19_0209();
                        Set_UDS_59_MsgRecFlg(0);
                        UDSSendStep = 1;
                        SendUdsTimeCount_190209 = 0;
                        break;
                    case 1:
                        if(Get_UDS_59_MsgRecFlg() || (SendUdsTimeCount_190209>500)){
                            UDSSendStep = 2;
                        }
                        break;
                    case 2:
                        if((Module  == BCM_UNKNOW) || (Module  == BCM_DELFU)){
                            Send_22_ID0005();
                            Set_UDS_62_MsgRecFlg(0);
                            UDSSendStep = 3;
                            SendUdsTimeCount_220005 = 0;                            
                        }
                        else{
                            UDSSendStep = 4;
                        }

                        break;
                    case 3:
                        if(Get_UDS_62_MsgRecFlg() || (SendUdsTimeCount_220005>500)){
                            UDSSendStep = 4;
                        }
                        break;
                    case 4:
                        if((Module  == BCM_UNKNOW) || (Module  == BCM_DELFU)){
                            Send_01_01();
                            Set_UDS_01_MsgRecFlg(0);
                            UDSSendStep = 5;
                            SendUdsTimeCount_0101 = 0;                            
                        }
                        else{
                            UDSSendStep = 0;
                        }

                        break;
                    case 5:
                        if(Get_UDS_01_MsgRecFlg() || (SendUdsTimeCount_0101>500)){
                            UDSSendStep = 0;
                        }
                        break;
                    default:
                        UDSSendStep = 0;
                        break;
                }
                SendUdsTimeCount_190209 += Diag_Time_SendCn;
                SendUdsTimeCount_220005 += Diag_Time_SendCn;
                SendUdsTimeCount_0101 += Diag_Time_SendCn;
            }
            else
                ;
        }
        else
        {
            DTCCurFaultTimes = 0;
            DTCHisFaultTimes = 0;
        }
    }
}

/* CAN Parameter  */

uint16_t Mil_Signal_Time = 0;
uint8_t Mil_Signal_Connect = 0;

void Reset_Mil_Signal_Time(void)
{
    Mil_Signal_Time = 0;
    Mil_Signal_Connect = 1;
}


void Can_User_Time_Service(uint8_t deltaTime)
{
    uint8_t u8Condition1;
    Mil_Signal_Time += deltaTime;
    if(Mil_Signal_Time > 3000){ //3秒超�?
        Mil_Signal_Connect = 0;
    }

    u8Condition1 = Common_Get_IG_Sts() ;
    if( u8Condition1 == COMMON_POWER_OFF ){
        CAN_TX_SetEnable(CAN_APP_TX_DISABLE);
        if(CanSleepDelayTime > deltaTime){
            CanSleepDelayTime -= deltaTime;
        }
        else{
            if( CanSleepDelayTime > 0 ){
                bsp_tx_msgbuf_abort(txResNum);
								//bsp_tx_msgbuf_abort(U2_txResNum);//20221026  CANH与CANL短路/CANH接地不睡�? 
                bsp_tx_msgbuf_abort(txCommon);
                bsp_CAN_Sleep();
                CanSleepDelayTime = 0;
            }
        }
    }
    else{
			if(DiagnoCtl.CommCtl==1)	//20220922
                CAN_TX_SetEnable(CAN_APP_TX_DISABLE);
			else
				CAN_TX_SetEnable(CAN_APP_TX_ENABLE);
    }
}
uint8_t Get_Mil_Signal_Connect(void)
{
    return Mil_Signal_Connect;
}


void swap32(uint32_t *DwData)
{
    uint8_t *ptmp = (uint8_t *)DwData;
    ptmp[0] ^= ptmp[3];
    ptmp[3] ^= ptmp[0];
    ptmp[0] ^= ptmp[3];

    ptmp[1] ^= ptmp[2];
    ptmp[2] ^= ptmp[1];
    ptmp[1] ^= ptmp[2];
}




void GetAllDtcFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{//8.0
    uint8_t  i = 0;
    uint8_t  j = 0;
    uint32_t  NewDTC1 = 0;
    uint32_t  NewDTC2 = 0;
    uint8_t  NewDTCNums = 0;
    uint8_t  OldDTCNums = 0;
    uint8_t  OldDTCNums1 = 0;
    uint32_t  TemDTC = 0;


    /* Current_DTC  */
    NewDTC1 = Get_ID_402_ECU_DTCH1();
    NewDTC1 <<= 8;
    TemDTC = Get_ID_402_ECU_DTCM1();
    NewDTC1 = NewDTC1 + TemDTC;
    NewDTC1 <<= 16;

    NewDTC2 = Get_ID_402_ECU_DTCH2();
    NewDTC2 <<= 8;
    TemDTC = Get_ID_402_ECU_DTCM2();
    NewDTC2 = NewDTC2 + TemDTC;
    NewDTC2 <<= 16;
    NewDTCNums = Get_ID_402_ECU_DTC1Amnt();
    OldDTCNums = * pCurFaultNum;
    if( NewDTCNums > 25 )
    { NewDTCNums = 25; }
    if( OldDTCNums < NewDTCNums )
    {
        /* 比较是否有相同故障码 */
        for( i = 0; i < OldDTCNums; i++ )
        {
            if( pCurFault[ i ] == NewDTC1 )
            { break; }
        }
        for( j = 0; j < OldDTCNums; j++ )
        {
            if( pCurFault[ j ] == NewDTC2 )
            { break; }
        }

        if(( i >= OldDTCNums ) && ( j >= OldDTCNums ))
        {
            pCurFault[ OldDTCNums ] = NewDTC1;
            pCurFault[ OldDTCNums+1 ] = NewDTC2;
            * pCurFaultNum = OldDTCNums + 2 ;
        }
        else if(( i >= OldDTCNums ) && ( j < OldDTCNums ))
        {
            pCurFault[ OldDTCNums ] = NewDTC1;
            * pCurFaultNum = OldDTCNums + 1 ;            
        }
        else if(( i < OldDTCNums ) && ( j >= OldDTCNums ))
        {
            pCurFault[ OldDTCNums ] = NewDTC2;
            * pCurFaultNum = OldDTCNums + 1 ;            
        }
    }
    if( OldDTCNums >= NewDTCNums ) 
    {
        if( NewDTCNums == 0 )
        {
            pCurFault[ NewDTCNums ] = 0;
            * pCurFaultNum = 0 ;            
        }
        else
        {
            /* 比较是否有相同故障码 */
            for( i = ( OldDTCNums - NewDTCNums ) ; i < OldDTCNums; i++ )
            {
                if( pCurFault[ i ] == NewDTC1 )
                { break; }
            }
            for( j = ( OldDTCNums - NewDTCNums ) ; j < OldDTCNums; j++ )
            {
                if( pCurFault[ j ] == NewDTC2 )
                { break; }
            }


            if(( i < OldDTCNums ) && (j < OldDTCNums))
            {
                /* 有相同报文,只移位 */
                for( i = 0; i < NewDTCNums; i++ )
                {
                    pCurFault[ i ] = pCurFault[ OldDTCNums - NewDTCNums + i ];
                }            
            }
            else if(( i < OldDTCNums ) && (j >= OldDTCNums))
            {
                /* 有相同报文,只移位 */
                for( i = 0; i < NewDTCNums; i++ )
                {
                    pCurFault[ i ] = pCurFault[ OldDTCNums - NewDTCNums + i + 1 ];
                }            
                pCurFault[ NewDTCNums - 1 ] = NewDTC2;
                * pCurFaultNum = NewDTCNums ;
            }
            else if(( i >= OldDTCNums ) && (j < OldDTCNums))
            {
                /* 有相同报文,只移位 */
                for( i = 0; i < NewDTCNums; i++ )
                {
                    pCurFault[ i ] = pCurFault[ OldDTCNums - NewDTCNums + i + 1 ];
                }            
                pCurFault[ NewDTCNums - 1 ] = NewDTC1;
                * pCurFaultNum = NewDTCNums ;
            }
            else if(( i >= OldDTCNums ) && (j >= OldDTCNums))
            {
                /* 没有相同报文,移位并保存新值 */
                for( i = 0; i < ( NewDTCNums - 2 ) ; i++ )
                {
                    pCurFault[ i ] = pCurFault[ OldDTCNums - NewDTCNums + i + 2 ];
                } 
                pCurFault[ NewDTCNums - 2 ] = NewDTC1;
                pCurFault[ NewDTCNums - 1 ] = NewDTC2;
                * pCurFaultNum = NewDTCNums ;
            }
        }
    }

}

void Can_BusOffRecover(void)
{
    BusOffEvent = 0u;
    RSCAN0Busoff.Cnt = 0u;
    RSCAN0Busoff.ReportDTCCnt = 0u;
    RSCAN0Busoff.Status = 0u;
    RSCAN0Busoff.Timer = 0u;
}


// must set in 10ms task;
void Can_BusOff_Fun(uint8_t deltaTime)
{
    if (Get_CH0_BusOffStatus() != 0u)
    {
        bsp_tx_msgbuf_abort(txResNum);
        CanSendLock = 0;
        BusOffEvent = 1U;
        if (RSCAN0Busoff.ReportDTCCnt < 100u)
        {
            RSCAN0Busoff.ReportDTCCnt++;
        }
        else
        {
            BUS_OFF_FLAG = 1U;
        }
        if (RSCAN0Busoff.Status == RSCAN0_BUS_STABLE)
        {
            RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV1;
        }

        if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV1)
        {
            RSCAN0Busoff.Timer++;
            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV1_RECOVERY_TIME / deltaTime)
            {
                RSCAN0Busoff.Timer = 0U;

                RSCAN0Busoff.Cnt++;
                if (RSCAN0Busoff.Cnt >= 10U)
                {

                    RSCAN0Busoff.Cnt = 0U;

                    RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV2;
                }
                bsp_CAN_BusOff_Recover();
            }
        }
        else if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV2)
        {
            RSCAN0Busoff.Timer++;

            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV2_RECOVERY_TIME / deltaTime)
            {
                RSCAN0Busoff.Timer = 0U;
                bsp_CAN_BusOff_Recover();

            }
        }
        else
        {

        }
    }
    else                                          /* 总线正常,没有Bus-off发生*/
    {
        Can_BusOffRecover();
    }
}
























