/**************************************************************************//**
  * \file     Init.c
  * \brief    Initializations during work state switching
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Jan-2019
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/

#include "BAT32A239.h"
#include "gpio.h"
#include "Sys_Tick.h"
#include "Analog_Signals.h"
#include "PowerManagement.h"
#include "PowerManagement_user.h"
#include "sci.h"
#include "clk.h"
#include "rtc.h"
#include "can.h"
#include "eeManager_Interface.h"
#include "Services_Mileage_User.h"


#include "Services_Mileage.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**************************************************************************//**
  * \brief      Initializations during work state switching
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Pre_Init(void)
{

}

/**************************************************************************//**
  * \brief      Initializations during system power up
  * \attention
  * \retval     None
******************************************************************************/


void Sys_Startup_Init(void)
{
    
    Clock_Init();
    
    GPIO_Init(GPIO_WAKEUP_MODE);





    Sys_Tick_Timer_Start();

    
//    /*COM_CAN_Init(); 原CAN初始化位置*/
//
    Analog_Signal_Conv_Init();
 //   UART2_Init(115200);
    RTC_Init(RTC_FSUB);

//     /*30电数据初始化*/
    Power_Management_Lib_Init();
    Power_Management_Init(0u);
    bsp_CAN_Init();
    eeprom_StoreInfo_Init( );	//20221028

		
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system sleep
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Sleep_Init(void)
{

}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system run
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Wakeup_Init(void)
{

}

