#define U2_GLOBALS_TP_DIAGNO

#include "U2_Link_Layer.h"
#include "U2_TP_Layer.h"
#include "UDS_def.h"
#include "U2_UDS_CFG.H"
#include "U2_APP_Service.h"
#include "U2_app_ServiceProc.h"
#include "can.h"
#include <string.h>

volatile _U2_N_USData U2_N_US_R_MultiData;
volatile _U2_N_USData U2_N_US_S_MultiData; //仪表外发的数据信息-multi
volatile _U2_N_RSPData U2_N_RSPData;       //仪表外发的数据信息
volatile _U2_N_US_Data_FF U2_N_US_R_Data_FF;
volatile _U2_N_US_Data_FF U2_N_US_S_Data_FF;
volatile _U2_N_USSFData U2_N_USSFData[2];
volatile uint16_t U2_N_RecLen;

/*-------------------------------------------------------------------------
* Function Name  : TP_Buffer_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_Buffer_handle(void)
{
    if (U2_LinkDataBuf[0].TransferStatus == u2_full)
    {
        (void)memcpy((uint8_t *)&U2_LinkData, (uint8_t *)&U2_LinkDataBuf[0], sizeof(_U2_LinkData));
        U2_LinkDataBuf[0].TransferStatus = u2_empoty;
    }
    else if (U2_LinkDataBuf[1].TransferStatus == u2_full)
    {
        (void)memcpy((uint8_t *)&U2_LinkData, (uint8_t *)&U2_LinkDataBuf[1], sizeof(_U2_LinkData));
        U2_LinkDataBuf[1].TransferStatus = u2_empoty;
    }

    U2_TP_AbnormalInResSF_handle();
    U2_TP_AbnormalInReqFF_handle();
    U2_TP_UnknownlPDU_handle();
    U2_TP_AbnormalInResCF_handle();
    U2_TP_AbnormalInReqFC_handle();
    U2_TP_AbnormalInResFC_handle();
    U2_TP_TooShortDLC_handle((_U2_LinkData *)&U2_LinkData);
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TooShortDLC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_TooShortDLC_handle(_U2_LinkData *LK_Data)
{
    uint16_t len;
    uint8_t CtrlMask;

    CtrlMask = LK_Data->Data[0] & 0xf0;
    len = LK_Data->Data[0] & 0x0F;

    if (CtrlMask == U2_SingleFrame)
    {
        if (LK_Data->DLC <= len)
        {
            LK_Data->TransferStatus = u2_empoty;
        }
    }
    if (CtrlMask == U2_FirstFrame)
    {
        if (LK_Data->DLC != 8)
        {
            LK_Data->TransferStatus = u2_empoty;
        }
    }
    if (CtrlMask == U2_FlowControlFrame)
    {
        if (LK_Data->DLC < 3)
        {
            LK_Data->TransferStatus = u2_empoty;
            U2_N_US_R_MultiData.ind.N_Result = u2_N_WRONG_SN;
        }
    }
    if (CtrlMask == U2_ConsecutiveFrame)
    {
        if ((U2_N_US_R_MultiData.ind.Length / 7) == len)
        {
            len = len - 1;
            if ((len * 7 + 5 + LK_Data->DLC) < U2_N_US_R_MultiData.ind.Length)
            {
                LK_Data->TransferStatus = u2_empoty;
                U2_N_US_R_MultiData.ind.N_Result = u2_N_WRONG_SN;
            }
        }
        else
        {
            if (LK_Data->DLC < 7)
            {
                LK_Data->TransferStatus = u2_empoty;
                U2_N_US_R_MultiData.ind.N_Result = u2_N_WRONG_SN;
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_UnknownlPDU_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_AbnormalInResSF_handle(void)
{
    uint8_t CtrlMask;
    if ((U2_N_US_S_MultiData.ind.N_Result == u2_N_OK) && (U2_N_US_S_Data_FF.ind.N_PCI) && (U2_LinkData.TransferStatus == u2_full))
    {
        CtrlMask = U2_LinkData.Data[0] & 0x30;
        if (CtrlMask == U2_FirstFrame)
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
        if (CtrlMask == U2_ConsecutiveFrame)
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
        if (CtrlMask == U2_SingleFrame)
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_UnknownlPDU_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_UnknownlPDU_handle(void)
{
    uint8_t CtrlMask;
    CtrlMask = U2_LinkData.Data[0] & 0xC0;

    if (U2_N_US_S_MultiData.ind.N_Result == u2_N_OK)
    {
        if (CtrlMask)
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
    if ((U2_N_US_R_MultiData.ind.N_Result == u2_WAIT) || (U2_N_US_R_MultiData.ind.N_Result == u2_CTS))
    {
        if ((CtrlMask) && (U2_LinkData.TransferStatus == u2_full))
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInReqFF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_AbnormalInReqFF_handle(void)
{
    uint8_t CtrlMask;

    CtrlMask = U2_LinkData.Data[0] & 0xf0;

    if ((CtrlMask == U2_FirstFrame) && (U2_LinkData.TransferStatus == u2_full))
    {
        if (U2_N_US_R_MultiData.ind.N_Result == u2_CTS)
        {
            U2_N_US_R_MultiData.ind.N_Result = u2_STATE0;
            U2_N_US_R_Data_FF.ind.pos = 0;
            U2_N_US_R_Data_FF.ind.N_PCI = 0;
            U2_N_US_R_Data_FF.ind.N_RecSN_L = 0;
        }
        
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInResCF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_AbnormalInResCF_handle(void)
{
    if (U2_N_US_S_MultiData.ind.N_Result == u2_N_OK)
    {
        if (((U2_LinkData.Data[0] & 0xf0) == U2_ConsecutiveFrame) && (U2_LinkData.TransferStatus == u2_full))
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInReqFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_AbnormalInReqFC_handle(void)
{
    if (U2_N_US_R_MultiData.ind.N_Result == u2_CTS)
    {
        if (((U2_LinkData.Data[0] & 0xf0) == U2_FlowControlFrame) && (U2_LinkData.TransferStatus == u2_full))
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInResFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_AbnormalInResFC_handle(void)
{
    if (U2_N_US_S_Data_FF.ind.N_PCI == U2_ConsecutiveFrame)
    {
        if ((U2_LinkData.TransferStatus == u2_full) && ((U2_LinkData.Data[0] & 0x30) == U2_FlowControlFrame))
        {
            U2_LinkData.TransferStatus = u2_empoty;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_NormalRecFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_NormalRecFC_handle(void)
{
    uint8_t CtrlMask;
    uint8_t FC_State;

    CtrlMask = U2_LinkData.Data[0] & 0xF0;

    if (U2_N_US_S_Data_FF.ind.N_PCI == U2_FC_WAIT)
    {
 
        if (CtrlMask == U2_FlowControlFrame)
        {
            

            FC_State = U2_LinkData.Data[0] & 0x0f;
            if (FC_State == 1)
            {
                U2_N_US_S_Data_FF.ind.N_PCI = U2_FC_WAIT;
                U2_TP_SetBsTimer(U2_N_Bs, (_U2_DiagClock *)&U2_DiagClock);
            }
            if (FC_State == 2)
            {
                U2_N_US_S_MultiData.ind.N_Result = u2_OVFLW;
            }
            if ((FC_State >= 3) && (FC_State <= 0x0F))
            {
                U2_N_US_S_MultiData.ind.N_Result = u2_N_INVALID_FS;
            }
            if (FC_State == 0)
            {
                U2_N_US_S_MultiData.ind.N_Result = u2_N_OK;

                U2_N_US_S_Data_FF.ind.N_PCI = U2_ConsecutiveFrame;

                U2_N_US_S_Data_FF.ind.N_FC_Num = 0;
                U2_N_US_S_Data_FF.ind.N_BS = U2_LinkData.Data[1];
                U2_N_US_S_Data_FF.ind.N_BS_CNT = 0;

                if ((U2_LinkData.Data[2] <= 0x7F))
                {
                    U2_DiagnoCtl.N_STmin = U2_LinkData.Data[2] + 1;
                }
                if ((U2_LinkData.Data[2] >= 0xF1) && (U2_LinkData.Data[2] <= 0xF9))
                {
                    U2_DiagnoCtl.N_STmin = 1;
                }
                if ((U2_LinkData.Data[2] >= 0xFA) && (U2_LinkData.Data[2] <= 0xFF))
                {
                    U2_DiagnoCtl.N_STmin = 128;
                }
                U2_DiagClock.TT_BsEnable = 0;
                U2_TP_SetSTminTimer(U2_DiagnoCtl.N_STmin, (_U2_DiagClock *)&U2_DiagClock);
            }
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_NormalSendFC_Fun
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_NormalSendFC_Fun(void)
{
    if (U2_N_US_R_MultiData.ind.N_Result == u2_WAIT)
    {
        U2_N_RSPData.ind.N_Result = u2_N_OK;
        U2_N_RSPData.ind.len = 3;
        U2_N_RSPData.ind.MsgData[1] = U2_DiagnoCtl.N_REV_MAX_BS;
        if (U2_N_US_R_MultiData.ind.Length <= U2_MaxBuff)
        {
            U2_N_RSPData.ind.MsgData[0] = 0x30;
            U2_N_RSPData.ind.MsgData[2] = 0x0A;
            U2_N_US_R_MultiData.ind.N_Result = u2_CTS;
            U2_TP_SetCrTimer(U2_N_Cr, (_U2_DiagClock *)&U2_DiagClock);
        }
        else
        {
            U2_N_RSPData.ind.MsgData[0] = 0x32;
            U2_N_RSPData.ind.MsgData[2] = 0x32;
            U2_N_US_R_MultiData.ind.N_Result = u2_STATE0;
        }
    }
    if (U2_N_US_R_MultiData.ind.N_Result == u2_CTS)
    {
        if (U2_TP_CrTimerOver((_U2_DiagClock *)&U2_DiagClock))
        {
            U2_N_US_R_MultiData.ind.N_Result = u2_N_TIMEOUT_Bs;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_ReciveSF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_ReciveSF_handle(void)
{
    uint16_t len;
    if ((U2_LinkData.Data[0] & 0xf0) == U2_SingleFrame)
    {
        len = U2_LinkData.Data[0] & 0x0f;
        if ((len > 0) && (len <= 7))
        {
            if ((U2_Exct_USData.ind.N_Result == u2_N_OK) || (U2_N_USSFData[0].ind.N_Result == u2_N_OK))
            {
                U2_N_USSFData[1].ind.Length = len;

                U2_N_USSFData[1].ind.N_TAtype = U2_LinkData.Identifier;
                U2_N_USSFData[1].ind.N_PCI = U2_SingleFrame;
                U2_N_USSFData[1].ind.N_Result = u2_N_OK;
                (void)U2_App_CopyRam((uint8_t *)&(U2_N_USSFData[1].ind.MsgData[0]), (uint8_t *)&U2_LinkData.Data[1], 7);
            }
            else
            {
                U2_N_USSFData[0].ind.Length = len;

                U2_N_USSFData[0].ind.N_TAtype = U2_LinkData.Identifier;
                U2_N_USSFData[0].ind.N_PCI = U2_SingleFrame;
                U2_N_USSFData[0].ind.N_Result = u2_N_OK;

                (void)U2_App_CopyRam((uint8_t *)&(U2_N_USSFData[0].ind.MsgData[0]), (uint8_t *)&U2_LinkData.Data[1], 7);
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_ReciveMultiF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_ReciveMultiF_handle(void)
{
    uint16_t wPos = 0;
    uint16_t SN = 0;
    uint8_t len = 0;

    if (((U2_LinkData.Data[0] & 0xf0) == U2_FirstFrame) && (U2_N_US_R_MultiData.ind.N_Result == u2_STATE0))
    {
        U2_N_US_R_MultiData.ind.Length = U2_LinkData.Data[0] & 0x0F;
        U2_N_US_R_MultiData.ind.Length <<= 8;
        U2_N_US_R_MultiData.ind.Length |= U2_LinkData.Data[1];

        if (U2_N_US_R_MultiData.ind.Length >= 8)
        {
            U2_N_US_R_MultiData.ind.N_TAtype = U2_LinkData.Identifier;

            U2_N_US_R_Data_FF.ind.N_PCI = U2_FirstFrame;
            U2_N_US_R_Data_FF.ind.N_RecSN_L = 0x0001; //

            (void)U2_App_CopyRam((uint8_t *)&U2_N_US_R_MultiData.ind.MsgData[0], (uint8_t *)&U2_LinkData.Data[2], 6);

            U2_N_US_R_MultiData.ind.N_Result = u2_WAIT;

            U2_N_US_R_Data_FF.ind.N_SID = U2_LinkData.Data[2];
        }
        else
        {
            U2_N_US_R_Data_FF.ind.N_PCI = 0;
        }
        U2_N_RecLen = 0;
    }
    if ((U2_LinkData.Data[0] & 0xf0) == U2_ConsecutiveFrame)
    {
        U2_N_US_R_Data_FF.ind.N_PCI = U2_ConsecutiveFrame;
    }
    if ((U2_N_US_R_Data_FF.ind.N_PCI == U2_ConsecutiveFrame) && (U2_N_US_R_MultiData.ind.N_Result == u2_CTS))
    {
        U2_TP_SetCrTimer(U2_N_Cr, (_U2_DiagClock *)&U2_DiagClock);

        U2_N_US_R_Data_FF.ind.N_PCI = 0;

        SN = U2_LinkData.Data[0] & 0x0F;

        wPos = (1 << SN);

        if (U2_N_US_R_Data_FF.ind.N_RecSN_L & wPos)
        {
            U2_N_US_R_MultiData.ind.N_Result = u2_N_WRONG_SN;
        }
        else
        {
            U2_N_US_R_Data_FF.ind.N_RecSN_L |= wPos;
        }

        if (U2_N_US_R_MultiData.ind.Length <= 111)
        {
            U2_N_RecLen = U2_TP_CalMsgLen(U2_N_US_R_Data_FF.ind.N_RecSN_L, 0);

            if (SN == 0)
            {
                U2_N_US_R_MultiData.ind.N_Result = u2_N_WRONG_SN;
            }
        }
        else
        {
            if (U2_N_RecLen == 0)
            {
                len = U2_TP_CalMsgLen(U2_N_US_R_Data_FF.ind.N_RecSN_L, 0);
            }
            else
            {
                len = U2_TP_CalMsgLen(U2_N_US_R_Data_FF.ind.N_RecSN_L, 1);
            }
            if (U2_N_US_R_Data_FF.ind.N_RecSN_L == 0xFFFF)
            {
                U2_N_RecLen += len;
                len = 0;
                U2_N_US_R_Data_FF.ind.N_RecSN_L = 0;
            }
        }

        if (SN > 0)
        {
            SN -= 1;
        }

        (void)U2_App_CopyRam((uint8_t *)&U2_N_US_R_MultiData.ind.MsgData[(U2_N_RecLen + len) - 7], (uint8_t *)&U2_LinkData.Data[1], 7);

        if ((U2_N_RecLen + len) >= U2_N_US_R_MultiData.ind.Length)
        {
            U2_N_US_R_MultiData.ind.N_Result = u2_N_OK;
            U2_DiagClock.TT_CrEnable = 0;
            U2_N_US_R_Data_FF.ind.N_RecSN_L = 0;
            U2_N_RecLen = 0;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TransmitPDU                              仪表诊断外发
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_TransmitPDU(void)
{
    U2_g_txCanMsg.id = U2_ID_BCM_PhyAddr;

    if (U2_N_US_S_MultiData.ind.N_Result == u2_N_OK) //no use
    {
        if (U2_N_US_S_Data_FF.ind.N_PCI == 0)
        {
            U2_g_txCanMsg.msg[0] = (uint8_t)U2_N_US_S_MultiData.ind.Length;
            (void)U2_App_CopyRam((uint8_t *)&U2_g_txCanMsg.msg[1], (uint8_t *)&U2_N_US_S_MultiData.ind.MsgData[0], 7);

            U2_LK_FillMsg((uint8_t *)&U2_g_txCanMsg.msg[0], U2_N_FILL, U2_N_US_S_MultiData.ind.Length + 1);

            g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
            U2_N_US_S_MultiData.ind.N_Result = u2_STATE0;
        }
        else
        {
            if (U2_N_US_S_Data_FF.ind.N_PCI == U2_FirstFrame)
            {
                U2_N_US_S_Data_FF.ind.N_PCI = U2_FC_WAIT;

                U2_g_txCanMsg.msg[0] = U2_FirstFrame | (U2_N_US_S_Data_FF.ind.Length >> 8);
                U2_g_txCanMsg.msg[1] = (uint8_t)U2_N_US_S_Data_FF.ind.Length;

                (void)U2_App_CopyRam((uint8_t *)&U2_g_txCanMsg.msg[2], (uint8_t *)&U2_N_US_S_MultiData.ind.MsgData[0], 6);

                g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
                U2_N_US_S_Data_FF.ind.N_SendSN = 0;
                U2_N_US_S_Data_FF.ind.pos = 6;
                U2_TP_SetBsTimer(U2_N_Bs, (_U2_DiagClock *)&U2_DiagClock);
            }
            if (U2_TP_STminTimerOver((_U2_DiagClock *)&U2_DiagClock))
            {
                if (U2_N_US_S_Data_FF.ind.N_PCI == U2_ConsecutiveFrame)
                {
                    (void)U2_App_CopyRam((uint8_t *)&U2_g_txCanMsg.msg[1], (uint8_t *)&U2_N_US_S_MultiData.ind.MsgData[U2_N_US_S_Data_FF.ind.pos], 7);

                    U2_N_US_S_Data_FF.ind.N_SendSN++;
                    U2_N_US_S_Data_FF.ind.N_FC_Num++;

                    if (U2_N_US_S_Data_FF.ind.N_BS)
                    {
                        U2_N_US_S_Data_FF.ind.N_BS_CNT++;
                        if (U2_N_US_S_Data_FF.ind.N_BS_CNT >= U2_N_US_S_Data_FF.ind.N_BS)
                        {
                            U2_N_US_S_Data_FF.ind.N_PCI = U2_FC_WAIT;
                            U2_TP_SetBsTimer(U2_N_Bs, (_U2_DiagClock *)&U2_DiagClock);
                        }
                    }
                    if (U2_N_US_S_Data_FF.ind.N_SendSN > 0x0F)
                    {
                        U2_N_US_S_Data_FF.ind.N_SendSN = 0;
                    }
                    U2_N_US_S_Data_FF.ind.pos += 7;
                    if (U2_N_US_S_Data_FF.ind.pos >= U2_N_US_S_Data_FF.ind.Length)
                    {
                        U2_N_US_S_Data_FF.ind.N_PCI = 0;
                        U2_N_US_S_MultiData.ind.N_Result = u2_STATE0;
                        if (((U2_N_US_S_Data_FF.ind.Length - 6) % 7) != 0)
                        {
                            U2_LK_FillMsg((uint8_t *)&U2_g_txCanMsg.msg[0], U2_N_FILL, ((U2_N_US_S_Data_FF.ind.Length - 6) % 7) + 1);
                        }
                    }
                    else
                    {
                        if (U2_N_US_S_Data_FF.ind.N_BS)
                        {
                            if (U2_N_US_S_Data_FF.ind.N_FC_Num == U2_N_US_S_Data_FF.ind.N_BS)
                            {
                                U2_N_US_S_Data_FF.ind.N_PCI = U2_FC_WAIT;
                                U2_TP_SetBsTimer(U2_N_Bs, (_U2_DiagClock *)&U2_DiagClock);
                            }
                        }
                    }

                    U2_g_txCanMsg.msg[0] = U2_ConsecutiveFrame | U2_N_US_S_Data_FF.ind.N_SendSN;

                    g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
                    U2_TP_SetSTminTimer(U2_DiagnoCtl.N_STmin, (_U2_DiagClock *)&U2_DiagClock);
                }
            }
        }
    }

    //-- 返回正确格式 --//
    if (U2_N_RSPData.ind.N_Result == u2_N_OK)
    {
        U2_N_RSPData.ind.N_Result = u2_STATE0; //1

        (void)U2_App_CopyRam((uint8_t *)&U2_g_txCanMsg.msg[0], (uint8_t *)&U2_N_RSPData.ind.MsgData[0], 8);

        U2_LK_FillMsg((uint8_t *)&U2_g_txCanMsg.msg[0], U2_N_FILL, U2_N_RSPData.ind.len);

        g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
    }

    U2_TP_TransmitNegatePDU((_U2_ErrorFrame *)&U2_Error); //返回错误内容
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TransmitNegatePDU                        服务否定响应
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_TransmitNegatePDU(_U2_ErrorFrame *Err)
{
    if (Err->FrameErr)
    {
        if (U2_N_US_R_Data_FF.ind.N_SID == Err->RespSerId)
        {
            U2_N_US_R_Data_FF.ind.Length = 0;
            U2_N_US_R_Data_FF.ind.N_SID = 0;
        }
        if (Err->N_TAtype == U2_ID_BCM_ResAddr) //物理寻址--回复错误
        {
            U2_g_txCanMsg.id = U2_ID_BCM_PhyAddr;
            U2_g_txCanMsg.msg[0] = 3;
            U2_g_txCanMsg.msg[1] = NegativeId;     //7F
            U2_g_txCanMsg.msg[2] = Err->RespSerId; //服务ID-27
            U2_g_txCanMsg.msg[3] = Err->FrameErr;  //0x35
            U2_g_txCanMsg.msg[4] = U2_N_FILL;         //0x55
            U2_g_txCanMsg.msg[5] = U2_N_FILL;         //0x55
            U2_g_txCanMsg.msg[6] = U2_N_FILL;         //0x55
            U2_g_txCanMsg.msg[7] = U2_N_FILL;         //0x55
            U2_g_txCanMsg.dlc = 8;

            g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
        }
        if ((Err->FrameErr != ServiceNotSupported) &&
            (Err->FrameErr != SubFunctionNotSupported) &&
            (Err->FrameErr != RequestOutOfRange))
        {
            U2_g_txCanMsg.id = U2_ID_BCM_PhyAddr;
            U2_g_txCanMsg.msg[0] = 3;
            U2_g_txCanMsg.msg[1] = NegativeId;
            U2_g_txCanMsg.msg[2] = Err->RespSerId;
            U2_g_txCanMsg.msg[3] = Err->FrameErr;
            U2_g_txCanMsg.msg[4] = U2_N_FILL;
            U2_g_txCanMsg.msg[5] = U2_N_FILL;
            U2_g_txCanMsg.msg[6] = U2_N_FILL;
            U2_g_txCanMsg.msg[7] = U2_N_FILL;
            U2_g_txCanMsg.dlc = 8;

            g_bReturn = bsp_CANSendFrame(U2_g_txCanMsg.id, U2_txResNum, (uint8_t *)&U2_g_txCanMsg.msg[0], 8);
        }
        Err->FrameErr = 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_CalMsgLen
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_TP_CalMsgLen(uint16_t BIT_DATA, uint8_t SnLoop)
{
    uint16_t wTemp;
    uint8_t len;
    uint8_t i;
    len = 0;
    wTemp = BIT_DATA;
    for (i = 0; i <= 15; i++)
    {
        if (wTemp & 0x0001)
        {
            len += 7;
        }
        wTemp = wTemp >> 1;
    }
    if (SnLoop == 0)
    {
        len -= 1;
    }

    return len;
}

/*-------------------------------------------------------------------------
* Function Name  : TP_SetCrTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_SetCrTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_CrEnable = 1;
    T->OverCrTime = Second;
    T->CrTime = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : Api_TTimerOver2
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_TP_CrTimerOver(_U2_DiagClock *T)
{
    if ((T->CrTime >= T->OverCrTime) && (T->TT_CrEnable))
    {
        T->TT_CrEnable = 0;
        T->CrTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_SetSTminTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_SetSTminTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_STminEnable = 1;
    T->OverSTminTime = Second;
    T->STminTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : TP_STminTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_TP_STminTimerOver(_U2_DiagClock *T)
{
    if ((T->STminTime >= T->OverSTminTime) && (T->TT_STminEnable))
    {
        T->TT_STminEnable = 0;
        T->STminTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_SetBsTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_TP_SetBsTimer(uint32_t Second, _U2_DiagClock *T)
{
    T->TT_BsEnable = 1;
    T->OverBsTime = Second;
    T->BsTime = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : TP_BsTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_TP_BsTimerOver(_U2_DiagClock *T)
{
    if ((T->BsTime >= T->OverBsTime) && (T->TT_BsEnable))
    {
        T->TT_BsEnable = 0;
        T->BsTime = 0;
        return 1;
    }
    else
    {
        return 0;
    }
}
