

#include "Analog_Circuits.h"
#include "Analog_Signals.h"
#include "gpio.h"

static DATA_GEAR_VALUE Gear_Number = DIS_DATA_GEAR_UNKNOW;

/******************************************************************************
  Function：Data_Gear_KL30_Init
  Description：该服务函数首次KL30时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL30_Init(void)
{
	

}
/******************************************************************************
  Function：Data_Gear_KL15_Init
  Description：该服务函数首次KL15时调用一次
  Input:
  Output:
 ******************************************************************************/
void Data_Gear_KL15_Init(void)
{
    Gear_Number = DIS_DATA_GEAR_UNKNOW;
}

/******************************************************************************
  Function：Data_Service_Gear_Processing
  Description：如果有特殊数据处理在此函数中进行处理
  Input:
  Output:
 ******************************************************************************/
_DATA_GEAR_AD_VALUE	 GEAR_AD_VALUE;
static const uint16_t GEAR_ADResultMIN[7]={4100, 3750, 3300, 2500, 1900, 1200, 500 };
static const uint16_t GEAR_ADResultMAM[7]={4500, 4000, 3650, 3100, 2300, 1700, 1000};
void Data_Service_Gear_Processing(void)
{
    static uint8_t timeCount = 0;
	
    uint8_t 	i ,j, position,activesum;
    uint16_t 	temp8 ;
		uint16_t 	GEARADResult[6] ;
	

		GEAR_AD_VALUE.DATA_GEAR_Non++;	//滚动纪录数据
		if(GEAR_AD_VALUE.DATA_GEAR_Non>=6)	GEAR_AD_VALUE.DATA_GEAR_Non = 0 ;
		//GEAR_AD_VALUE.DATA_GEAR_ADResult[GEAR_AD_VALUE.DATA_GEAR_Non] = ADC_Read_Signal(ADC_CH_GEAR);
	
		for (i = 0; i < 6; i++)		//取值
		{
			GEARADResult[i] = GEAR_AD_VALUE.DATA_GEAR_ADResult[i];
		}
		for (i = 0; i < 6-1; i++)	//冒泡排序
		{
			for (j = 0; j < 6-1-i; j++)
			{
				if(GEARADResult[j] > GEARADResult[j+1])
				{
					temp8 = GEARADResult[j] ;
					GEARADResult[j] =GEARADResult[j+1]; 
					GEARADResult[j+1] = temp8 ;
				}					
			}
		}
		temp8 = 0;
		for (i = 1; i < 5; i++)		//求和
		{
			temp8 += GEARADResult[i] ;
		}
		temp8 >>= 2;							//平均值
		i=0;	position = 0 ;			//档位定位，  7组档位1-6、N
		while(i < 7)							
		{
				if(temp8 >= GEAR_ADResultMIN[i])
				{
						position = i ;
						i=7;
				}
				i++ ;
		}
		activesum = 0;
		for (i = 1; i < 5; i++)		//中间4个数据，在一个档位范围内有效
		{
			if((GEARADResult[i] >= GEAR_ADResultMIN[position]) &&(GEARADResult[i] <= GEAR_ADResultMAM[position]))
				activesum ++;
		}
    if((temp8 >= GEAR_ADResultMIN[0])&&(temp8 <= GEAR_ADResultMAM[0])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_1;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[1])&&(temp8 <= GEAR_ADResultMAM[1])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_N;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[2])&&(temp8 <= GEAR_ADResultMAM[2])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_2;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[3])&&(temp8 <= GEAR_ADResultMAM[3])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_3;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[4])&&(temp8 <= GEAR_ADResultMAM[4])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_4;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[5])&&(temp8 <= GEAR_ADResultMAM[5])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_5;
				timeCount = 0;
    }
    else if((temp8 >= GEAR_ADResultMIN[6])&&(temp8 <= GEAR_ADResultMAM[6])&&(activesum >=4)){
        Gear_Number = DIS_DATA_GEAR_6;
				timeCount = 0;
    }
    else{
        if(timeCount > 20){
            Gear_Number = DIS_DATA_GEAR_UNKNOW;
        }
        else{
           timeCount++;
        }
		}
    
}

/******************************************************************************
  Function：Get_Gear_Mode_Number
  Description：Get Gear  1/2/3/4/...
  Input:
  Output:   1/2/3/4/...
 ******************************************************************************/
uint8_t Get_Gear_Mode_Number(void)
{
    return (uint8_t)Gear_Number;
}



