#define U2_GLOBALS_SERPROC_DIAGNO

#include "U2_app_Service.h"
#include "U2_TP_Layer.h"
#include "UDS_def.h"
#include "U2_app_ServiceProc.h"

/*-------------------------------------------------------------------------
* Function Name  : App_CreateCRCCheckSum
* Description    :
* Input          : uint8_t *p ,uint8_t Nub
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t U2_App_CreateCRCCheckSum(uint8_t *p, uint8_t Nub)
{
    uint8_t bCheckSun;
    uint8_t i;
    bCheckSun = 0;
    while (Nub--)
    {
        bCheckSun ^= *p++;
        for (i = 0; i < 8; i++)
        {
            if (bCheckSun & 0x01)
            {
                bCheckSun = (bCheckSun >> 1) ^ 0x8C;
            }
            else
                bCheckSun >>= 1;
        }
    }
    return (bCheckSun);
}
/*-------------------------------------------------------------------------
* Function Name  : App_CopyRam
* Description    : ran copy
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_CopyRam(uint8_t *Dp, uint8_t *Sp, uint16_t Nub)
{
    uint16_t b;

    for (b = 0; b < Nub; b++)
    {
        *Dp++ = *Sp++;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DID
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_Load_DID(uint16_t *DID, uint8_t *data)
{
    (*DID) = data[0];
    (*DID) = (*DID) << 8;
    (*DID) |= data[1];
}
/*-------------------------------------------------------------------------
* Function Name  : App_ErrorInfoInit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_ErrorInfoInit(_U2_N_USData *AppUSData)
{
    U2_Error.RespSerId = AppUSData->ind.MsgData[0];
    U2_Error.N_TAtype = AppUSData->ind.N_TAtype;

    U2_Error.FrameErr = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : App_11_Reset_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_App_11_Reset_handle(void)
{

}
/*-------------------------------------------------------------------------
* Function Name  : App_2F_IOCtl_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void U2_Diagno_Tick(uint16_t DiagnoTimeCn)
{
    //
    if (U2_DiagClock.TT_STminEnable)
    {
        if (U2_DiagClock.STminTime < U2_DiagClock.OverSTminTime)
        {
            U2_DiagClock.STminTime += DiagnoTimeCn;
        }
    }
    if (U2_DiagClock.TT_BsEnable)
    {
        if (U2_DiagClock.BsTime < U2_DiagClock.OverBsTime)
        {
            U2_DiagClock.BsTime += DiagnoTimeCn;
        }
    }
    if (U2_DiagClock.TT_CrEnable)
    {
        if (U2_DiagClock.CrTime < U2_DiagClock.OverCrTime)
        {
            U2_DiagClock.CrTime += DiagnoTimeCn;
        }
    }

    if (U2_DiagClock.TT_SequenceEnable)
    {
        if (U2_DiagClock.SequenceTime < U2_DiagClock.OverSequenceTime)
        {
            U2_DiagClock.SequenceTime += DiagnoTimeCn;
        }
    }

    if (U2_DiagClock.TT_SessionEnable)
    {
        if (U2_DiagClock.SessionTime < U2_DiagClock.OverSessionTime)
        {
            U2_DiagClock.SessionTime += DiagnoTimeCn;
        }
    }

    if (U2_DiagClock.TT_UnlockEnable)
    {
        if (U2_DiagClock.UnlockTime < U2_DiagClock.OverUnlockTime)
        {
            U2_DiagClock.UnlockTime += DiagnoTimeCn;
        }
    }
    
    if (U2_DiagClock.TT_DtcMsgEnable)
    {
        if (U2_DiagClock.DtcMsgTime < U2_DiagClock.OverDtcMsgTime)
        {
            U2_DiagClock.DtcMsgTime += DiagnoTimeCn;
        }
    }
    
}
