#ifndef FUEL_H
#define FUEL_H

#include "common.h"

#define Fuel_Short_Value 0           /* 燃油短路值 精度0.1ohm */
#define Fuel_Open_Value 1100         /* 燃油开路值 精度0.1ohm */
#define Fuet_Short_Dealy_Timer 3000  /* 燃油从正常进入短路的延迟时间  单位ms*/
#define Fuel_Open_Dealy_Timer 3000   /* 燃油从正常进入开路的延迟时间 单位ms*/
#define Fuel_Normal_Dealy_Timer 3000 /* 燃油从异常状态进入正常的延迟时间 单位ms*/
#define FUEL_DATA_TIME 25u           /*这里填写多长时间采集一个数据，单位ms*/
#define FUEL_DATA_NUM 20u            /*燃油电阻采集数据总数 最大255*/
#define FUEL_CAL_START 5u            /*数据排序后取中间部分计算平均：起始*/
#define FUEL_CAL_END 15u             /*数据排序后取中间部分计算平均：结束*/
#define RETURN_DIFFERENCE 25u        /*判断上升或下降的回差，精度0.1*/
#define Creep_Down_Up_Timer 10000    /* 一个格的时间 单位ms */
typedef enum
{
    Up_Dir = 0,
    Down_Dir = 1,
    Unvalid = 0XFF,
} _FuelDir;

typedef enum
{
    FuelSensorNormal = 0,
    FuelSensorShortCircuit,
    FuelSensorOpenCircuit,
} FuelSensorSts_t;

typedef struct
{
    uint8_t u8FuelDataCount;                /* 燃油采集计数 */
    uint8_t u8FuelCollectCount;             /* 多久采集一次燃油数据 */
    uint16_t FuelDataBuffer[FUEL_DATA_NUM]; /* 存储燃油数据buffer */
    uint8_t u8FuelInitState;                /* 燃油传感器初始化状态 */
    uint8_t u8FuelInitFlag;                 /* 燃油初始化标志 */
    uint16_t FuelDataArray[7];              /* 数组下标0用于存储短路值，1~5用于存储当前对应格数阻值，6用于存储开路阻值 */
    uint16_t Fuel_Res;                      /* 进行滤波处理后的燃油阻值 */
    uint16_t Fuel_Res_Back;                 /* 历史燃油阻值 */
    uint16_t u16SensorShortTimer;           /* 传感器进入短路时间 */
    uint16_t u16SensorOpenTimer;            /* 传感器进入开路时间 */
    uint16_t u16SensorNormalTimer;          /* 传感器进入正常时间 */
    uint8_t u8FuelADCompleteFlg;            /* 一组数据采集完成标志 */
    _FuelDir FuelDir;                       /* 燃油方向 */
    FuelSensorSts_t FuelSensorState;        /* 燃油传感器状态 */

} _FuelData;

typedef struct
{
    uint8_t u8Curseg;       /* 当前格 */
    uint8_t u8DestSeg;      /* 目标格 */
    uint16_t u16Down_Timer; /* 上升延迟时间 */
    uint16_t u16Up_Timer;   /* 下降延迟时间 */
} _Fuel_Dis;

extern _Fuel_Dis FuelDis;
extern _FuelData Fuel_Data;

extern void Fuel_KL15_Init(void);
extern void Fuel_KL30_Init(void);
extern void Fuel_Cal_Sevice(uint8_t deltaTime);
extern uint8_t Get_CurFuelSetp(void);
extern FuelSensorSts_t Get_Fuel_Sensor_State(void);
void Fuel_Res_Call(uint8_t deltaTime);

#endif
