
#include "MCU_Core_Protocol.h"
#include "sci.h"
#include "Common_Interface.h"
#include "Telltales_user.h"
#include "Fuel.h"
#include "rtc.h"
#include "Flash_synchronizer.h"
#include "Data_Gear.h"
#include "Menus.h"
#include "BGLInterface.h"
#include "SEG_LCD.h"
#include "System_Monitor.h"
#include "Gauges.h" 
#include "CoolantTemp.h"
#include "Services_Mileage_User.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_User.h"
#include "Flash_synchronizer.h"

uint8_t PackageCnt;


typedef struct 
{
  uint32_t UpdateRoC;
  uint32_t SigDevTime;
  
}ReceiveStructure;

ReceiveStructure Msg_12_Rec_Sta;

uint8_t             Uart2_tx_buf [ Uart_tx_Buffer_Size ];
uint8_t             Uart2_rx_buf [ Uart_rx_Buffer_Size ];
uint8_t             SendLength;

static Send_ID_01_00_Struct               Send_ID_01_00;
static Send_ID_01_01_Struct               Send_ID_01_01;
static Send_ID_01_02_Struct               Send_ID_01_02;
static Send_ID_01_03_Struct               Send_ID_01_03;
static Send_ID_02_Struct               Send_ID_02;
static Receive_ID_12_Struct               Receive_ID_12;


static uint8_t Event_Send_Queue[EVENT_MSG_MAX_QUEUE_NUM][EVENT_MSG_MAX_LENGTH+3];
static uint8_t Event_Msg_QueueFront = 0;
static uint8_t Event_Msg_QueueRear = 0;
static uint8_t Event_Msg_Count = 0;



    
#define Send_ID_01_00_Len  (sizeof(Send_ID_01_00.Msg))
#define Send_ID_01_01_Len  (sizeof(Send_ID_01_01.Msg))
#define Send_ID_01_02_Len  (sizeof(Send_ID_01_02.Msg))
#define Send_ID_01_03_Len  (sizeof(Send_ID_01_03.Msg))
#define Send_ID_02_Len     (sizeof(Send_ID_02.Msg))
#define Receive_ID_12_Len  (sizeof(Receive_ID_12.Msg))



extern void Get_ID_01_Data(uint8_t** buffer, uint8_t* length);
extern void Get_ID_02_Data(uint8_t** buffer, uint8_t* length);
extern void Send_To_Core(uint8_t str [], uint8_t clen);

typedef struct
{
    uint8_t  IdType;
    uint8_t  En;
    uint16_t  Cyc;
    uint16_t  Timer;
    void (*GetData)(uint8_t** buffer, uint8_t* length);
} SendCtrl_TblStructure;

SendCtrl_TblStructure SendCtrl_Tbl [] = {
    /* ID            En  Cyc  Timer    CallBack      */
    {PROTOCOL_ID_01, 0u, 20u,  19u, Get_ID_01_Data}, /*20ms */
    {PROTOCOL_ID_02, 0u, 100u, 90u, Get_ID_02_Data}, /*100ms */
};

void Protocol_KL15_ON_Init(void)
{
    Event_Msg_QueueFront = 0;
    Event_Msg_QueueRear = 0;
    Event_Msg_Count = 0;

}

uint8_t Send_Event_Msg(uint8_t type, uint8_t* data)
{
    uint8_t i;
    if(Event_Msg_Count >= EVENT_MSG_MAX_QUEUE_NUM) 
        return SendEventMsgError;
    
    Event_Send_Queue[Event_Msg_QueueRear][0] = 0x06;
    Event_Send_Queue[Event_Msg_QueueRear][1] = type;

    
    for(i=0; i<EVENT_MSG_MAX_LENGTH; i++){
        Event_Send_Queue[Event_Msg_QueueRear][3+i] = data[i];
        if(data[i] == 0){
            i++;
            break;
        }
    }
    Event_Send_Queue[Event_Msg_QueueRear][2] = i;
    Event_Msg_QueueRear = (Event_Msg_QueueRear+1) % EVENT_MSG_MAX_QUEUE_NUM;
    Event_Msg_Count ++;
		return SendEventMsgOk;
}
void Check_Event_Msg(void)
{
    uint8_t          Length;
    uint8_t          *pBuffer;

    if((Event_Msg_Count) && (Get_Uart2_State() == UART_TX_IDEL)){
        pBuffer = Event_Send_Queue[Event_Msg_QueueFront];
        Length = Event_Send_Queue[Event_Msg_QueueRear][2];
        Send_To_Core(pBuffer, Length+3);   
        Event_Msg_QueueFront = (Event_Msg_QueueFront+1) % EVENT_MSG_MAX_QUEUE_NUM;
        Event_Msg_Count--;
    }
     
}
uint8_t Get_Event_Msg_Queue_Length(void)
{
    return Event_Msg_Count;
}

void Get_ID_01_Data(uint8_t** buffer, uint8_t* length)
{
    MSG_01_DISP_MODE_t m_DispMode;
    m_DispMode = Common_Get_DispMode();
    uint16_t temp16 = 0;
    uint32_t temp32 = 0;
    rtc_counter_value_t RtcTime;
    switch(m_DispMode){
        case    DISP_MODE_NONE:  //不显示(黑屏)
                /*Byte4*/
                Send_ID_01_00.Sig.MessageID = PROTOCOL_ID_01;
                if(Common_Get_IG_Sts() == COMMON_POWER_ON){
                    Send_ID_01_00.Sig.PowerMode = 0x01;
                }
                else{
                    Send_ID_01_00.Sig.PowerMode = 0x00;
                }
                /*Byte5*/
                Send_ID_01_00.Sig.DispMode      = 0x05;//DISP_MODE_NONE;
                Send_ID_01_00.Sig.Language      = Common_Get_Language();
                if(Get_Day_Or_Night() == _DAY){
                    Send_ID_01_02.Sig.Theme = 0;
                }
                else{
                    Send_ID_01_02.Sig.Theme = 1;
                }
                Send_ID_01_00.Sig.ConnectPhone  = Common_Get_ConnectPhoneSts();
                
                *buffer = Send_ID_01_00.Msg;
                *length = Send_ID_01_00_Len;
            break;        
            
        case    DISP_MODE_ANIMATION:  //开机动画
                /*Byte4*/
                Send_ID_01_01.Sig.MessageID = PROTOCOL_ID_01;
                if(Common_Get_IG_Sts() == COMMON_POWER_ON){
                    Send_ID_01_01.Sig.PowerMode = 0x01;
                }
                else{
                    Send_ID_01_01.Sig.PowerMode = 0x00;
                }

                /*Byte5*/
                Send_ID_01_01.Sig.DispMode      = DISP_MODE_ANIMATION;
                Send_ID_01_01.Sig.Language      = Common_Get_Language();
                if(Get_Day_Or_Night() == _DAY){
                    Send_ID_01_02.Sig.Theme = 0;
                }
                else{
                    Send_ID_01_02.Sig.Theme = 1;
                }
                Send_ID_01_01.Sig.ConnectPhone  = Common_Get_ConnectPhoneSts();
                /*Byte6*/
                Send_ID_01_01.Sig.Animation = 1;
                *buffer = Send_ID_01_01.Msg;
                *length = Send_ID_01_01_Len;
            break;
            
        case    DISP_MODE_DRIVE_INFO:  //行车显示信息
                /*Byte4*/
                Send_ID_01_02.Sig.MessageID = PROTOCOL_ID_01;
                if(Common_Get_IG_Sts() == COMMON_POWER_ON){
                    Send_ID_01_02.Sig.PowerMode = 0x01;
                }
                else{
                    Send_ID_01_02.Sig.PowerMode = 0x00;
                }

                /*Byte5*/
                Send_ID_01_02.Sig.DispMode      = DISP_MODE_DRIVE_INFO;
                Send_ID_01_02.Sig.SelfTest      = Get_Self_Test_Sts();               
                Send_ID_01_02.Sig.Language      = Common_Get_Language();
                if(Get_Day_Or_Night() == _DAY){
                    Send_ID_01_02.Sig.Theme = 0;
                }
                else{
                    Send_ID_01_02.Sig.Theme = 1;
                }
                Send_ID_01_02.Sig.ConnectPhone  = Common_Get_ConnectPhoneSts();
                /*Byte6*/
            //     Send_ID_01_02.Sig.LED_Coolant   =   Get_LED_Sts(m_LED_Coolant);
            //     Send_ID_01_02.Sig.LED_ENGINE_OIL_LOW  =   Get_LED_Sts(m_LED_ENGINE_OIL_LOW);
            //   //  Send_ID_01_02.Sig.LED_ABS       =   Get_LED_Sts(m_LED_ABS);
            //     Send_ID_01_02.Sig.LED_HI_BEAM   =   Get_LED_Sts(m_LED_HI_BEAM);
            //     Send_ID_01_02.Sig.LED_MIL       =   Get_LED_Sts(m_LED_MIL);
            //     Send_ID_01_02.Sig.LED_RIGHT     =   Get_LED_Sts(m_LED_RIGHT);
            //     Send_ID_01_02.Sig.LED_LEFT      =   Get_LED_Sts(m_LED_LEFT);
            //     /*Byte7*/
            // //    Send_ID_01_02.Sig.LED_Fuel      =   Get_LED_Sts(m_LED_Fuel);
            // //    Send_ID_01_02.Sig.LED_TPMS      =   Get_LED_Sts(m_LED_TPMS);
            //     Send_ID_01_02.Sig.LED_Bluetooth =   Get_LED_Sts(m_LED_Bluetooth);
            //     Send_ID_01_02.Sig.LED_WIFI      =   Get_LED_Sts(m_LED_WIFI);
                /*Byte8-11 */
                temp16 = Common_Get_Disp_E_Speed();
                Send_ID_01_02.Sig.Espeed        =   temp16/100;
                Send_ID_01_02.Sig.Espeed_Bars   =   ((uint32_t)temp16*29)/12000;
                
                temp16 = Common_Get_Disp_V_Speed();
                temp16 /= 10;
                Send_ID_01_02.Sig.Vspeed_L      =   temp16&0xFF;
                Send_ID_01_02.Sig.Vspeed_H      =   (temp16>>8) & 0x01;
                Send_ID_01_02.Sig.Vspeed_Bars   =   (temp16*29)/360;
                /*Byte12*/
                if(FLASH_SYNC_05Hz){
                    temp16 = 1;
                }
                else{
                    temp16 = 0;
                }
                Send_ID_01_02.Sig.Time_colon    =   temp16;
                Get_RTC_Time(&RtcTime);
                Send_ID_01_02.Sig.Time_hour     =   (RtcTime.hour>>4)*10 + (RtcTime.hour&0x0f);
                /*Byte13*/
                Send_ID_01_02.Sig.Time_minute   =   (RtcTime.min>>4)*10 + (RtcTime.min&0x0f);
                /*Byte14*/
                //Send_ID_01_02.Sig.Coolant_Temp_Bars = Get_CoolantTemp_Disp_Byte();        
                /*Byte15*/
                //Send_ID_01_02.Sig.Fuel_Bars     =   Get_Fuel_Disp_Byte();       

                /*Byte16*/
                //Send_ID_01_02.Sig.Gear = Get_Gear_Mode_Number();

                /*Byte17*/
                temp32 = Data_ODO_Read( );
                temp32 /= 10;
                Send_ID_01_02.Sig.Mileage_Unit  = Get_Unit_Setting();   
                Send_ID_01_02.Sig.Disp_Mileage_Mode = Get_Disp_Mileage_Mode();  
                
                Send_ID_01_02.Sig.TOTAL_H4 = (temp32>>16)&0x0000000F;        
                /*Byte18*/
                Send_ID_01_02.Sig.TOTAL_M8 = (temp32>>8)&0x000000FF;  
                /*Byte19*/
                Send_ID_01_02.Sig.TOTAL_L8 = temp32&0x000000FF;  
                /*Byte20*/
                temp32 = Data_Read_Trip(EM_TRIP_A);
                Send_ID_01_02.Sig.TRIPA_H8 = (temp32>>8)&0x000000FF;  
                /*Byte21*/
                Send_ID_01_02.Sig.TRIPA_L8 = temp32&0x000000FF;  
                /*Byte22*/
                temp32 = Data_Read_Trip(EM_TRIP_B);
                Send_ID_01_02.Sig.TRIPB_H8 = (temp32>>8)&0x000000FF;   
                /*Byte23*/
                Send_ID_01_02.Sig.TRIPB_L8 = temp32&0x000000FF;  
                
                /*Byte26*/
                Send_ID_01_02.Sig.EasyNavigation = 0;  

                
                *buffer = Send_ID_01_02.Msg;
                *length = Send_ID_01_02_Len;
            break;
            
        case    DISP_MODE_MENU:  //菜单
                /*Byte4*/
                Send_ID_01_03.Sig.MessageID = PROTOCOL_ID_01;
                if(Common_Get_IG_Sts() == COMMON_POWER_ON){
                    Send_ID_01_03.Sig.PowerMode = 0x01;
                }
                else{
                    Send_ID_01_03.Sig.PowerMode = 0x00;
                }

                /*Byte5*/
                Send_ID_01_03.Sig.DispMode      = DISP_MODE_MENU;
                Send_ID_01_03.Sig.Language      = Common_Get_Language();
                if(Get_Day_Or_Night() == _DAY){
                    Send_ID_01_02.Sig.Theme = 0;
                }
                else{
                    Send_ID_01_02.Sig.Theme = 1;
                }
                Send_ID_01_03.Sig.ConnectPhone  = Common_Get_ConnectPhoneSts();
                /*Byte6*/
                Send_ID_01_03.Sig.Data6         = Get_Menu_Byte6();
                /*Byte7*/
                Send_ID_01_03.Sig.Data7         = Get_Menu_Byte7();
                /*Byte8*/
                Send_ID_01_03.Sig.Data8         = Get_Menu_Byte8();
                /*Byte9*/
                Send_ID_01_03.Sig.Data9         = Get_Menu_Byte9();


                *buffer = Send_ID_01_03.Msg;
                *length = Send_ID_01_03_Len;
            break;

        default:
            break;

    }
    
}

uint16_t SEG_Check_ContrlTime = 0;
static uint16_t DtcDispNum = 0u;

static uint16_t Animat_GEAR = 0u;
static uint16_t Animat_Vspeed = 0u;
static uint16_t Animat_Espeed = 0u;
static uint16_t Animat_ODO = 0u;
static uint16_t Animat_Temp = 0u;
static uint16_t Animat_Fuel = 0u;
static uint16_t Animat_Battery = 0u;
void  Drive_Info_Display_Update_Service(void)
{
    //rtc_counter_value_t RtcTime;
    uint8_t BatteryErrFlg = 0;
    uint64_t totaldisp = 0;
    uint32_t vehicle = 0;
    static uint16_t Checktime = 0;
    //里程\车速
    if(Get_Disp_Mileage_Mode() == Mileage_Mode_Total)
    {
        totaldisp = Data_ODO_Read();
        totaldisp /= 100;
    }
    else if(Get_Disp_Mileage_Mode() == Mileage_Mode_TripA)
    {
        totaldisp = Data_Read_Trip(EM_TRIP_A);
        totaldisp /= 100;
    }
    else if(Get_Disp_Mileage_Mode() == Mileage_Mode_TripB)
    {
        totaldisp = Data_Read_Trip(EM_TRIP_B);
        totaldisp /= 100;
    }
    vehicle = Common_Get_Disp_V_Speed();
    
    if(Get_Unit_Setting() == Imperial)
    {
        totaldisp = (totaldisp * 6213)/10000;
        vehicle = (vehicle * 621)/1000;
    }
    else
    {
        if((Get_Disp_Mileage_Mode() == Mileage_Mode_TripA) && (totaldisp > 9999))
        {
            Data_Clear_Trip ( EM_TRIP_A );
        }
        else if((Get_Disp_Mileage_Mode() == Mileage_Mode_TripB) && (totaldisp > 9999))
        {
            Data_Clear_Trip ( EM_TRIP_B );
        }
    }
    
    if (Get_Disp_Mileage_Mode() == Mileage_Mode_FaultCode)
    {
        if (GetDtcAmnt() == 0)
        {
            Checktime = 0;
            DtcDispNum = 0;
            totaldisp = 0;
        }
        else
        {
            if(Common_GetIgnOnTime() < IGON_SelfcheckingTimer)
            {
                Checktime = 0;
               DtcDispNum = 0;
            }
            
            Checktime++;
            totaldisp = GetDtcDispNum(DtcDispNum);
            if (Checktime > 50)
            {
                Checktime = 0;
                if ((DtcDispNum + 1) < GetDtcAmnt())
                    DtcDispNum ++;
                else
                    DtcDispNum = 0;
            }
        }
    }
    else
    {
        Checktime = 0;
        DtcDispNum = 0;
    }    
    
    if(Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if(Common_GetIgnOnTime() < IGON_SelfcheckingTimer)
        {            
            //100ms
            if (Common_GetIgnOnTime() < 1600)
            {
                //档位自检
                SEG_LCD_Gear_Display(1, Animat_GEAR / 15, 0);
                Animat_GEAR+=10;
                //车速自检
                SEG_LCD_Vehicle_Speed_Num_Display(1, 0, Animat_Vspeed * 100 / 75); //1:mph default:km/h
                Animat_Vspeed+=10;
                //转速自检12000
                SEG_LCD_Engine_Speed_Seg_Selftest(Animat_Espeed * 80);
                Animat_Espeed+=10;
                
                //里程自检
                if ((Get_Disp_Mileage_Mode() != Mileage_Mode_TempErr) && (!Get_ID_113_Tbatt()))				
                {
                	SEG_LCD_ODO_Trip_FaultCode_Selftest(Animat_ODO / 15);
				   Animat_ODO+=10;
				}
                else
				{
				    SEG_LCD_BatteryErr_Display(1, Common_GetIgnOnTime());
				  	BatteryErrFlg = 1;
				}
                //Animat_ODO+=10;
                //水温自检
                SEG_Coolant_Temp_Display(1, Animat_Temp / 30);
                Animat_Temp+=10;
                //燃油自检
                SEG_Fuel_Level_Display(1, Animat_Fuel / 30);
                Animat_Fuel+=10;
                //蓄电池电压自检
                SEG_LCD_Battery_Voltage_Selftest(Animat_Battery / 15);
                Animat_Battery+=10;
            }
            else
            {
                //档位自检
                SEG_LCD_Gear_Display(1, Animat_GEAR / 15, 0);
                if (Animat_GEAR) Animat_GEAR-=11;
                //车速自检
                SEG_LCD_Vehicle_Speed_Num_Display(1, 0, Animat_Vspeed * 100 / 75); //1:mph default:km/h
                if (Animat_Vspeed) Animat_Vspeed-=11;
                //转速自检12000
                SEG_LCD_Engine_Speed_Seg_Selftest(Animat_Espeed * 80);
                if (Animat_Espeed) Animat_Espeed-=11;
				
                //里程自检
                if ((Get_Disp_Mileage_Mode() != Mileage_Mode_TempErr) && (!Get_ID_113_Tbatt()))				
                {
                	SEG_LCD_ODO_Trip_FaultCode_Selftest(Animat_ODO / 15);
				   	Animat_ODO-=11; 
				}
                else
				{
				    SEG_LCD_BatteryErr_Display(1, Common_GetIgnOnTime());
				  	BatteryErrFlg = 1;
				}

							
                //if (Animat_ODO) Animat_ODO-=11;
                //水温自检
                SEG_Coolant_Temp_Display(1, Animat_Temp / 30);
                if (Animat_Temp) Animat_Temp-=11;
                //燃油自检
                SEG_Fuel_Level_Display(1, Animat_Fuel / 30);
                if (Animat_Fuel) Animat_Fuel-=11;
                //蓄电池电压自检
                SEG_LCD_Battery_Voltage_Selftest(Animat_Battery / 15);
                if (Animat_Battery) Animat_Battery-=11;
            }
			
        }
        else 
        {
            if(get_SEG_Check_Contrl() == 0)
            {            
                //档位显示
                SEG_LCD_Gear_Display(1, get_ID_ISG_Power(), CAN_MSG_Status(ID_ISG_Count));
				
                //车速显示
                SEG_LCD_Vehicle_Speed_Num_Display(1, Get_Unit_Setting(), vehicle / 10); //1:mph default:km/h

				//转速显示
                SEG_LCD_Engine_Speed_Seg_Display(1, Common_Get_Disp_E_Speed());

				//累计里程显示
			if((Common_GetIgnOnTime() >= IGON_SelfcheckingTimer) && (BatteryErrFlg))
			{	
				SEG_LCD_BatteryErr_Display(1, Common_GetIgnOnTime());
				if((Common_GetIgnOnTime() >= 5000u) && (Common_GetIgnOnTime() <6000u))
				{
					SEG_LCD_BatteryErr_Display(0, Common_GetIgnOnTime());
				}
				else if ((6000u <= Common_GetIgnOnTime()) && (Common_GetIgnOnTime() < 11000u))
				{
					
					SEG_LCD_BatteryErr_Display(1, Common_GetIgnOnTime());
				}
				else
				{
					SEG_LCD_BatteryErr_Display(0, Common_GetIgnOnTime());
					SEG_LCD_ODO_Trip_FaultCode_Display(1, Get_Disp_Mileage_Mode(), Get_Unit_Setting(), totaldisp); //mode/unit/batt/totaldisp
				}						
			}
			else
			{		
				SEG_LCD_ODO_Trip_FaultCode_Display(1, Get_Disp_Mileage_Mode(), Get_Unit_Setting(), totaldisp); //mode/unit/batt/totaldisp
			}
			


                //水温显示
                SEG_Coolant_Temp_Display(1, Get_CoolantTemp_Disp_Byte());

				//燃油显示
                SEG_Fuel_Level_Display(1, Get_Fuel_Disp_Byte());

				//蓄电池电压
                SEG_LCD_Battery_Voltage_Display(1, get_ECU_Battery_Voltage() ,CAN_MSG_Status(ID_ECU_Battery_Count));

			}
            else//20221117  TYW大计清零后，循环显示断码检测
            {
                if(SEG_Check_ContrlTime > 30)
                {
                	SEG_Check_ContrlTime = 0;
                    Animat_GEAR = 0u;
                    Animat_Vspeed = 0u;
                    Animat_Espeed = 0u;
                    Animat_ODO = 0u;
                    Animat_Temp = 0u;
                    Animat_Fuel = 0u;
                    Animat_Battery = 0u;
                }
                else
                {
                    SEG_Check_ContrlTime ++;
                }	
                SEG_LCD_Gear_Display(1, Animat_GEAR / 15, 0);
                Animat_GEAR+=5;
                //车速自检
                SEG_LCD_Vehicle_Speed_Num_Selftest(Animat_Vspeed / 15);
                Animat_Vspeed+=5;
                //转速自检12000
                SEG_LCD_Engine_Speed_Seg_Selftest(Animat_Espeed * 80);
                Animat_Espeed+=5;
                //里程自检
                SEG_LCD_ODO_Trip_FaultCode_Selftest(Animat_ODO / 15);
                Animat_ODO+=5;
                //水温自检
                SEG_Coolant_Temp_Display(1, Animat_Temp / 30);
                Animat_Temp+=5;
                //燃油自检
                SEG_Fuel_Level_Display(1, Animat_Fuel / 30);
                Animat_Fuel+=5;
                //蓄电池电压自检
                SEG_LCD_Battery_Voltage_Selftest(Animat_Battery / 15);
                Animat_Battery+=5;
            }
        }
    }
    else
    {
        Animat_GEAR = 0u;
        Animat_Vspeed = 0u;
        Animat_Espeed = 0u;
        Animat_ODO = 0u;
        Animat_Temp = 0u;
        Animat_Fuel = 0u;
        Animat_Battery = 0u;
    }
}

void Get_ID_02_Data(uint8_t** buffer, uint8_t* length)
{
    /*Byte4*/
    Send_ID_02.Sig.MessageID = PROTOCOL_ID_02;
    if(Common_Get_IG_Sts() == COMMON_POWER_ON){
        Send_ID_02.Sig.PowerMode = 0x01;
    }
    else{
        Send_ID_02.Sig.PowerMode = 0x00;
    }

    *buffer = Send_ID_02.Msg;
    *length = Send_ID_02_Len;
}
void SetUartRxMsg_0x12(uint8_t * data)
{
    uint8_t i;
    for(i=0; i<Receive_ID_12_Len; i++){
        Receive_ID_12.Msg[i] = data[i+1];
    }
}

SocDispSts_E GetSocDispSts(void)
{
    return (SocDispSts_E)Receive_ID_12.Sig.DisplaySts;
}

static const unsigned char CRC16_TAB_H [ 256 ] = {0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u,
                                                  0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u,
                                                  0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u,
                                                  0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u,
                                                  0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u,
                                                  0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u,
                                                  0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u,
                                                  0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u,
                                                  0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u,
                                                  0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u,
                                                  0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u,
                                                  0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u,
                                                  0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u,
                                                  0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u,
                                                  0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u,
                                                  0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u,
                                                  0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u,
                                                  0xC0u, 0x80u, 0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x00u, 0xC1u,
                                                  0x81u, 0x40u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u, 0x01u, 0xC0u, 0x80u,
                                                  0x41u, 0x01u, 0xC0u, 0x80u, 0x41u, 0x00u, 0xC1u, 0x81u, 0x40u};

static const unsigned char CRC16_TAB_L [ 256 ] = {0x00u, 0xC0u, 0xC1u, 0x01u, 0xC3u, 0x03u, 0x02u, 0xC2u, 0xC6u, 0x06u, 0x07u, 0xC7u, 0x05u,
                                                  0xC5u, 0xC4u, 0x04u, 0xCCu, 0x0Cu, 0x0Du, 0xCDu, 0x0Fu, 0xCFu, 0xCEu, 0x0Eu, 0x0Au, 0xCAu,
                                                  0xCBu, 0x0Bu, 0xC9u, 0x09u, 0x08u, 0xC8u, 0xD8u, 0x18u, 0x19u, 0xD9u, 0x1Bu, 0xDBu, 0xDAu,
                                                  0x1Au, 0x1Eu, 0xDEu, 0xDFu, 0x1Fu, 0xDDu, 0x1Du, 0x1Cu, 0xDCu, 0x14u, 0xD4u, 0xD5u, 0x15u,
                                                  0xD7u, 0x17u, 0x16u, 0xD6u, 0xD2u, 0x12u, 0x13u, 0xD3u, 0x11u, 0xD1u, 0xD0u, 0x10u, 0xF0u,
                                                  0x30u, 0x31u, 0xF1u, 0x33u, 0xF3u, 0xF2u, 0x32u, 0x36u, 0xF6u, 0xF7u, 0x37u, 0xF5u, 0x35u,
                                                  0x34u, 0xF4u, 0x3Cu, 0xFCu, 0xFDu, 0x3Du, 0xFFu, 0x3Fu, 0x3Eu, 0xFEu, 0xFAu, 0x3Au, 0x3Bu,
                                                  0xFBu, 0x39u, 0xF9u, 0xF8u, 0x38u, 0x28u, 0xE8u, 0xE9u, 0x29u, 0xEBu, 0x2Bu, 0x2Au, 0xEAu,
                                                  0xEEu, 0x2Eu, 0x2Fu, 0xEFu, 0x2Du, 0xEDu, 0xECu, 0x2Cu, 0xE4u, 0x24u, 0x25u, 0xE5u, 0x27u,
                                                  0xE7u, 0xE6u, 0x26u, 0x22u, 0xE2u, 0xE3u, 0x23u, 0xE1u, 0x21u, 0x20u, 0xE0u, 0xA0u, 0x60u,
                                                  0x61u, 0xA1u, 0x63u, 0xA3u, 0xA2u, 0x62u, 0x66u, 0xA6u, 0xA7u, 0x67u, 0xA5u, 0x65u, 0x64u,
                                                  0xA4u, 0x6Cu, 0xACu, 0xADu, 0x6Du, 0xAFu, 0x6Fu, 0x6Eu, 0xAEu, 0xAAu, 0x6Au, 0x6Bu, 0xABu,
                                                  0x69u, 0xA9u, 0xA8u, 0x68u, 0x78u, 0xB8u, 0xB9u, 0x79u, 0xBBu, 0x7Bu, 0x7Au, 0xBAu, 0xBEu,
                                                  0x7Eu, 0x7Fu, 0xBFu, 0x7Du, 0xBDu, 0xBCu, 0x7Cu, 0xB4u, 0x74u, 0x75u, 0xB5u, 0x77u, 0xB7u,
                                                  0xB6u, 0x76u, 0x72u, 0xB2u, 0xB3u, 0x73u, 0xB1u, 0x71u, 0x70u, 0xB0u, 0x50u, 0x90u, 0x91u,
                                                  0x51u, 0x93u, 0x53u, 0x52u, 0x92u, 0x96u, 0x56u, 0x57u, 0x97u, 0x55u, 0x95u, 0x94u, 0x54u,
                                                  0x9Cu, 0x5Cu, 0x5Du, 0x9Du, 0x5Fu, 0x9Fu, 0x9Eu, 0x5Eu, 0x5Au, 0x9Au, 0x9Bu, 0x5Bu, 0x99u,
                                                  0x59u, 0x58u, 0x98u, 0x88u, 0x48u, 0x49u, 0x89u, 0x4Bu, 0x8Bu, 0x8Au, 0x4Au, 0x4Eu, 0x8Eu,
                                                  0x8Fu, 0x4Fu, 0x8Du, 0x4Du, 0x4Cu, 0x8Cu, 0x44u, 0x84u, 0x85u, 0x45u, 0x87u, 0x47u, 0x46u,
                                                  0x86u, 0x82u, 0x42u, 0x43u, 0x83u, 0x41u, 0x81u, 0x80u, 0x40u};

unsigned short int TFT_CreateCRCCheckSum(unsigned char pData [], unsigned char len)
{

    unsigned char      u8_crc_h = 0xFFu;
    unsigned char      u8_crc_l = 0xFFu;
    unsigned char      u8_index = 0u;
    unsigned char      i        = 0u;
    unsigned short int re_value;

    while ( len-- )
    {
        u8_index = u8_crc_h ^ (pData [ i++ ]);
        u8_crc_h = u8_crc_l ^ CRC16_TAB_H [ u8_index ];
        u8_crc_l = CRC16_TAB_L [ u8_index ];
    }

    re_value = ( unsigned short int )u8_crc_h << 8u;
    re_value |= u8_crc_l;

    return re_value;
}



void Send_To_Core(uint8_t str [], uint8_t clen)
{
    uint8_t            i          = 0u;
    unsigned short int sum        = 0u;


    /* SOI */
    Uart2_tx_buf [ 0 ] = 0xEB; /*0xEB*/
    Uart2_tx_buf [ 1 ] = 0x90; /*0x90*/

    /* LENGTH */
    Uart2_tx_buf [ 2 ] = clen + 3u;
    /* INDX */
    Uart2_tx_buf [ 3 ] = PackageCnt++;

    /* INFO */
    for ( i = 0u; i < clen; i++ )
    {
        Uart2_tx_buf [ 4+i ] = str [ i ];
    }

    /* CHKSUM*/
    sum = TFT_CreateCRCCheckSum(&Uart2_tx_buf [ 2 ],  clen + 2u); /**/

    Uart2_tx_buf [ 4 + i++ ] = ( uint8_t )(sum >> 8u);
    Uart2_tx_buf [ 4 + i++ ] = ( uint8_t )(sum);

    /* UART SEND MESSAGE */
    UART_Ch2_Send_Multiple_Byte( Uart2_tx_buf, clen + 6 );
    g_uart2_tx_state = UART_TX_BUSY;

}

//建议放在2ms任务
void MCU_Send_Service(uint8_t deltaTime)
{
    uint8_t          i             = 0u;
    uint8_t          Length;
    uint8_t          *pBuffer;
    if(uart2_Get_0x10_Rev_Flag()){
        for ( i = 0u; i < CycMsgNumber; i++ )
        {

            if(SendCtrl_Tbl [ i ].En){
                if ( SendCtrl_Tbl [ i ].Timer + deltaTime <= 0xffff )
                {
                    SendCtrl_Tbl [ i ].Timer += deltaTime;
                }
                if (( SendCtrl_Tbl [ i ].Timer >= SendCtrl_Tbl [ i ].Cyc )  &&  (Get_Uart2_State() == UART_TX_IDEL))
                {
                    SendCtrl_Tbl [ i ].Timer -= SendCtrl_Tbl [ i ].Cyc;
                    SendCtrl_Tbl [ i ].GetData(&pBuffer, &Length);
                    Send_To_Core(pBuffer, Length);    
                }
                        
            }
        }
        Check_Event_Msg();
    }
}

void Enable_Cyc_Msg(CycMsg_t msgIndex)
{
    if(msgIndex < CycMsgNumber){
        SendCtrl_Tbl [ msgIndex ].En = 1;
    }
}

void Disable_Cyc_Msg(CycMsg_t msgIndex)
{
    if(msgIndex < CycMsgNumber){
        SendCtrl_Tbl [ msgIndex ].En = 0;
    }
}


