
#include "Menus.h"
#include "Common_Interface.h"
#include "rtc.h"
#include "MCU_Core_Protocol.h"
#include "CAN_User.h"
#include "Services_Mileage_User.h"
#include "CalcFrequency.h" 
#include "CAN_Communication_Matrix.h" 
#include "Flash_synchronizer.h"

uint8_t MenuByte6 = 0;
uint8_t MenuByte7 = 0;
uint8_t MenuByte8 = 0;
uint8_t MenuByte9 = 0;

uint8_t             bMenuSwFlag;
uint8_t             bNextMenuIDX;      //the index of next menu .
uint8_t             bCurMenuIDX;       //the index of current menu.EXTERN_MEU_PROCESS   void    Level1Animation_Enter(void);
uint8_t             bMainMenuIDX;      //the index of main menu.EXTERN_MEU_PROCESS   void    Level1Animation_Do(void);
uint8_t             bOldMenuIDX;       //the index of old menu.EXTERN_MEU_PROCESS   void    Level1Animation_Exit(void);
uint8_t             DoorDisFlag;
uint8_t             bMenuFlag;

unitSetting_E UnitSettings = Metric;
LANGUAGE_t Language = LANGUAGE_ZH;

dayOrNightControl_E  DayOrNightControl = DayOrNight_Automatic;
rtc_counter_value_t CalendarTemp;
uint8_t timeFlashNumber = 0;

extern const _MenuOptTab   MenuOptTab[];
static uint16_t AnimationTimeCount = 0;
static uint16_t SelfTestTimeCount = 0;
BL_USER_SET_LV_E BL_User_Set_Level = BL_USER_SET_LV_5;

Disp_Mileage_Mode_E Disp_Mileage_Mode = Mileage_Mode_Total;
uint8_t BatteryErr;

static PHONE_CONNECT_t g_ConnectPhone;
uint8_t BluetoothSwitch = 1;

uint8_t BluetoothCursorPosition = 1;
uint8_t BluetoothSyncContacts = 0;
uint8_t SendEventMsgBuffer[54];
uint8_t SEG_Check_Contrl = 0 ;//20221117  TYW大计清零后，循环显示断码检测
uint8_t TCS_Contrl = 1;

uint8_t get_SEG_Check_Contrl(void)
{
    return SEG_Check_Contrl;
}
void Set_SEG_Check_Contrl(uint8_t data)
{
    SEG_Check_Contrl = data;
}
void NextMenu(_MENU_IDX idx)
{
    if((idx) != _MN_IDX_NULL)
    {
        bNextMenuIDX = (idx);
    }
    else
    {
        ; // do nothing
    }
}
void MenuKL30Init(void)
{
    //DayOrNightControl = DayOrNight_Automatic;
    //BL_User_Set_Level = BL_USER_SET_LV_3;
    //Language = LANGUAGE_ZH;
    UnitSettings = Metric;
    Disp_Mileage_Mode = Mileage_Mode_Total;
    //BluetoothSwitch = 1;//蓝牙默认打开
    //g_ConnectPhone = PHONE_NOT_CONNECT;
    TCS_Contrl = 1;
}
void MenuIgnOnInit(void)
{
    //bCurMenuIDX = _MN_DSP_ANIMATION;
    //bNextMenuIDX = _MN_DSP_ANIMATION;
    //bMenuSwFlag = 0;
    //BluetoothCursorPosition = 1;
    //BluetoothSyncContacts = 0;
    //AnimationTimeCount = 0;
    //SelfTestTimeCount = 0;
    //NoKeyPressTimeCount = 0u;
    //MenuByte6 = 0;
    // MenuByte7 = 0;
    // MenuByte8 = 0;
    // MenuByte9 = 0;
    TCS_Contrl = 1;
}

void MenuManage(void)
{
    if(bMenuSwFlag)
    {
        if(MenuOptTab[bCurMenuIDX].Enter)
            MenuOptTab[bCurMenuIDX].Enter();
    }

    if(MenuOptTab[bCurMenuIDX].Do)
        MenuOptTab[bCurMenuIDX].Do();

    bMenuSwFlag = (bCurMenuIDX != bNextMenuIDX) ? 1 : 0;

    if(bMenuSwFlag)
    {
        
        if(MenuOptTab[bCurMenuIDX].Exit)
        {
            MenuOptTab[bCurMenuIDX].Exit();
        }
    }
    bCurMenuIDX = bNextMenuIDX;
    
    if(AnimationTimeCount < ANIMATION_TIME){
        AnimationTimeCount += 100;
    }
    
    if((bCurMenuIDX >= _MN_DSP_DRIVE_INFO) && (SelfTestTimeCount < SELF_TEST_TIME)){
        SelfTestTimeCount += 100;
    }

    
}

uint8_t Get_Unit_Setting(void)
{
    uint8_t temp;
    if(UnitSettings == Metric){
        temp = 0;
    }
    else{
        temp = 1;
    }
    return temp;
}


uint8_t Get_Language_Byte(void)
{
    uint8_t temp;
    if(Language == LANGUAGE_ZH){
        temp = 0;
    }
    else{
        temp = 1;
    }
    return temp;
}
BL_USER_SET_LV_E Get_BL_User_Set_Level(void)
{
    return BL_User_Set_Level;
}
uint8_t Get_Disp_Mileage_Mode(void)
{
    return (uint8_t)Disp_Mileage_Mode;
}

uint8_t Get_Self_Test_Sts(void)
{
    uint8_t temp8 = 0;
    if(/*(GetSocDispSts() >= SelfTestDone) ||*/ (SelfTestTimeCount >= SELF_TEST_TIME)){
        temp8 = 0;
    }
    else{
        temp8 = 1;
    }
    return temp8;
}
uint8_t Common_Get_ConnectPhoneSts(void)
{
    return (uint8_t)g_ConnectPhone;
}
/*---------------------------------------------------------------------*/
void    Level1Animation_Enter(void)
{
    AnimationTimeCount = 0;

}
void    Level1Animation_Do(void)
{
    if((GetSocDispSts() == DisplayAnimationDone) || (AnimationTimeCount >= ANIMATION_TIME)){
        NextMenu(_MN_DSP_DRIVE_INFO);
    }
    else{
        Common_Set_DispMode(DISP_MODE_ANIMATION);
    }
}
void    Level1Animation_Exit(void)
{
    SelfTestTimeCount = 0;
}
/*---------------------------------------------------------------------*/
void    Level1DriveInfo_Enter(void)
{
    Common_Set_DispMode(DISP_MODE_DRIVE_INFO);
}
void    Level1DriveInfo_Do(void)
{

}
void    Level1DriveInfo_Exit(void)
{
    
}

void    Level1PhoneConnect_Enter(void)
{
    Common_Set_DispMode(DISP_MODE_DRIVE_INFO);
    g_ConnectPhone = PHONE_CONNECT;
}
void    Level1PhoneConnect_Do(void)
{
    
}
void    Level1PhoneConnect_Exit(void)
{
    g_ConnectPhone = PHONE_NOT_CONNECT;
}
/*---------------------------------------------------------------------*/
void    Level1Menu_1Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x10;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;
}
void    Level1Menu_1Do(void)
{

}
void    Level1Menu_1Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_2Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x20;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_2Do(void)
{
    
}
void    Level1Menu_2Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_3Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x30;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_3Do(void)
{
    
}
void    Level1Menu_3Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_4Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x40;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_4Do(void)
{
    MenuByte7 = Get_Unit_Setting();
}
void    Level1Menu_4Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_5Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x50;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_5Do(void)
{
    MenuByte8 = Get_Language_Byte();
}
void    Level1Menu_5Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_6Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x60;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_6Do(void)
{

}
void    Level1Menu_6Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_7Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x70;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_7Do(void)
{
    
}
void    Level1Menu_7Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_8Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x80;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_8Do(void)
{
    
}
void    Level1Menu_8Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level1Menu_9Enter(void)
{
    Common_Set_DispMode(DISP_MODE_MENU);
    MenuByte6 = 0x90;
    MenuByte7 = Get_Unit_Setting();
    MenuByte8 = Get_Language_Byte();
    MenuByte9 = 0;    
}
void    Level1Menu_9Do(void)
{
    
}
void    Level1Menu_9Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_1Enter(void)
{
    MenuByte6 = 0x11;
    if(DayOrNightControl == DayOrNight_Automatic){
        MenuByte7 = 3;
    }
    else if(DayOrNightControl == Manual_Day){
        MenuByte7 = 2;
    }
    else if(DayOrNightControl == Manual_Night){
        MenuByte7 = 1;
    }
    MenuByte8 = 0;
    MenuByte9 = 0;        
}
void    Level2Menu_1Do(void)
{
    if(DayOrNightControl == DayOrNight_Automatic){
        MenuByte7 = 3;
    }
    else if(DayOrNightControl == Manual_Day){
        MenuByte7 = 2;
    }
    else if(DayOrNightControl == Manual_Night){
        MenuByte7 = 1;
    }
    MenuByte8 = 0;
    MenuByte9 = 0;       
}
void    Level2Menu_1Exit(void)
{

}
/*---------------------------------------------------------------------*/
void    Level2Menu_2Enter(void)
{

    MenuByte6 = 0x21;
    timeFlashNumber = 1;
    MenuByte7 = timeFlashNumber;
    Get_RTC_Time(&CalendarTemp);
    MenuByte8 = CalendarTemp.hour;
    MenuByte9 = CalendarTemp.min;
    
}
void    Level2Menu_2Do(void)
{
    MenuByte7 = timeFlashNumber;
    MenuByte8 = CalendarTemp.hour;
    MenuByte9 = CalendarTemp.min;
			
}
void    Level2Menu_2Exit(void)
{
    CalendarTemp.sec = 0;
		RTC_Set_CounterValue(&CalendarTemp);  
		MenuByte6 = 0;
		timeFlashNumber = 0;
		MenuByte7 = timeFlashNumber;
}
/*---------------------------------------------------------------------*/
void    Level2Menu_3Enter(void)
{
    MenuByte6 = 0x31;
    MenuByte7 = (uint8_t)BL_User_Set_Level + 1;
    MenuByte8 = 0;
    MenuByte9 = 0;    
}

void    Level2Menu_3Do(void)
{
    MenuByte7 = (uint8_t)BL_User_Set_Level + 1;

}
void    Level2Menu_3Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
uint8_t abcToChar(uint8_t data)
{
    uint8_t temp8;
    if(data<=9)
    {
        temp8 = '0'+  data;
    }
    else if((data>=0x0A) && (data<=0x0F))
    {
        temp8 = 'a'+(data-0x0A);
    }
    return temp8;
}
void dtcToString(uint32_t abc, uint8_t* dtcString)
{
    uint32_t temp32;
    temp32 = abc >> 20;
    temp32 &= 0x0F;
//    if((temp32 >= 0x08) && (temp32 >= 0x0B)){ /* 8xxx - Bxxx  ===  B0xxx - B3xxx  车体 */
//        dtcString[0] = 'B'
//        dtcString[1] = 0x30 - 0x08 + temp32;      
//    }
//    else if((temp32 >= 0x04) && (temp32 >= 0x07)){ /* 4xxx - 7xxx  ===  C0xxx - C3xxx  底盘*/
//        dtcString[0] = 'C'
//        dtcString[1] = 0x30 - 0x04 + temp32;     
//    }
//    else if((temp32 >= 0x00) && (temp32 >= 0x03)){ /* 0xxx - 3xxx  ===  P0xxx - P3xxx  动力 */
//        dtcString[0] = 'P'
//        dtcString[1] = 0x30 + temp32;     
//    }
//    else if((temp32 >= 0x0C) && (temp32 >= 0x0F)){ /* Cxxx - Fxxx  ===  U0xxx - U3xxx  动力 */
//        dtcString[0] = 'P'
//        dtcString[1] = 0x30 - 0x0C + temp32;     
//    }
    dtcString[0] = 'P';
    
    dtcString[1] = abcToChar((abc>>28)&0x0f);
    dtcString[2] = abcToChar((abc>>24)&0x0f);
    dtcString[3] = abcToChar((abc>>20)&0x0f);
    dtcString[4] = abcToChar((abc>>16)&0x0f);
    
}
void    Level2Menu_6Enter(void)
{
    _DTCReturnVal dtc;
    uint32_t temp32;
    MenuByte6 = 0x61;
    DtcFaultTimeInit();
    dtc = GetDtcFault();

    
    //当前故障
    temp32 = dtc.StructDtcCurFault;
    if(temp32){
        dtcToString(temp32, (uint8_t*)&SendEventMsgBuffer);
        Send_Event_Msg(EventMsgType_CurFault, (uint8_t*)&SendEventMsgBuffer);
    }
    else{
        SendEventMsgBuffer[0] = 0u;
        Send_Event_Msg(EventMsgType_CurFault, (uint8_t*)&SendEventMsgBuffer);
    }      

    
    //历史故障
    temp32 = dtc.StructDtcHisFault;
    if(temp32){
        dtcToString(temp32, (uint8_t*)&SendEventMsgBuffer);
        Send_Event_Msg(EventMsgType_HisFault, (uint8_t*)&SendEventMsgBuffer);
    }
    else{
        SendEventMsgBuffer[0] = 0u;
        Send_Event_Msg(EventMsgType_HisFault, (uint8_t*)&SendEventMsgBuffer);
    }    

}


void    Level2Menu_6Do(void)
{
    _DTCReturnVal dtc;
    uint32_t temp32;
    dtc = GetDtcFault();



    //当前故障    
    temp32 = dtc.StructDtcCurFault;
    if(temp32){
        dtcToString(temp32, (uint8_t*)&SendEventMsgBuffer);
        Send_Event_Msg(EventMsgType_CurFault, (uint8_t*)&SendEventMsgBuffer);
    }
    else{
        SendEventMsgBuffer[0] = 0u;
        Send_Event_Msg(EventMsgType_CurFault, (uint8_t*)&SendEventMsgBuffer);
    }    


    //历史故障    
    temp32 = dtc.StructDtcHisFault;
    if(temp32){
        dtcToString(temp32, (uint8_t*)&SendEventMsgBuffer);
        Send_Event_Msg(EventMsgType_HisFault, (uint8_t*)&SendEventMsgBuffer);
    }
    else{
        SendEventMsgBuffer[0] = 0u;
        Send_Event_Msg(EventMsgType_HisFault, (uint8_t*)&SendEventMsgBuffer);
    }


    
}
void    Level2Menu_6Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_7_1Enter(void)
{
    MenuByte6 = 0x71;
    MenuByte7 = BluetoothSwitch;            //蓝牙连接开关
    BluetoothCursorPosition = 1;
    MenuByte8 = BluetoothCursorPosition;    //光标位置
    MenuByte9 = BluetoothSyncContacts;      //同步联系人
}
void    Level2Menu_7_1Do(void)
{
    MenuByte7 = BluetoothSwitch;            //蓝牙连接开关

}
void    Level2Menu_7_1Exit(void)
{

}
/*---------------------------------------------------------------------*/
static uint8_t BluetoothSyncTime = 0;
void    Level2Menu_7_2Enter(void)
{
    MenuByte6 = 0x71;
    MenuByte7 = BluetoothSwitch;            //蓝牙连接开关
    BluetoothCursorPosition = 2;
    MenuByte8 = BluetoothCursorPosition;    //光标位置
    MenuByte9 = BluetoothSyncContacts;      //同步联系人    
    BluetoothSyncTime = 0;
}
void    Level2Menu_7_2Do(void)
{
    if(BluetoothSyncContacts){
        MenuByte9 = 1;      //同步联系人  
        if(BluetoothSyncTime < 10){
            BluetoothSyncTime++;
        }
        else{
            BluetoothSyncContacts = 0;
        }

    }
    else{
        BluetoothSyncTime = 0;
    }
    
}
void    Level2Menu_7_2Exit(void)
{
    BluetoothSyncContacts = 0;
}
/*---------------------------------------------------------------------*/
void    Level2Menu_7_3Enter(void)
{
    MenuByte6 = 0x71;
    MenuByte7 = BluetoothSwitch;            //蓝牙连接开关
    BluetoothCursorPosition = 3;
    MenuByte8 = BluetoothCursorPosition;    //光标位置
    MenuByte9 = BluetoothSyncContacts;      //同步联系人        
}
void    Level2Menu_7_3Do(void)
{
    
}
void    Level2Menu_7_3Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_7_4Enter(void)
{
    MenuByte6 = 0x71;
    MenuByte7 = BluetoothSwitch;            //蓝牙连接开关
    BluetoothCursorPosition = 4;
    MenuByte8 = BluetoothCursorPosition;    //光标位置
    MenuByte9 = BluetoothSyncContacts;      //同步联系人      
}
void    Level2Menu_7_4Do(void)
{
    
}
void    Level2Menu_7_4Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_8_1Enter(void)
{
    MenuByte6 = 0x81;
}
void    Level2Menu_8_1Do(void)
{
    
}
void    Level2Menu_8_1Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_8_2Enter(void)
{
    MenuByte6 = 0x81;
}
void    Level2Menu_8_2Do(void)
{
    
}
void    Level2Menu_8_2Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_8_3Enter(void)
{
    MenuByte6 = 0x81;
}
void    Level2Menu_8_3Do(void)
{
    
}
void    Level2Menu_8_3Exit(void)
{
    
}
/*---------------------------------------------------------------------*/
void    Level2Menu_8_4Enter(void)
{
    MenuByte6 = 0x81;
}
void    Level2Menu_8_4Do(void)
{
    
}
void    Level2Menu_8_4Exit(void)
{
    
}


/******************************************************************************
  函数名：MenuStatusSwitch
  功  能：按键检测
  参  数IOInput 输入状态
  返回值：无
 ******************************************************************************/
//按键检测  确认键
void MenuStatusSwitchODO(KeyStatusEnum set_button)
{
    if((Common_GetIgnOnTime() > IGON_SelfcheckingTimer) && (BatteryErr == 0))
    {
        // 按键短按 1    
        if (KEY_PRESS == set_button)
        {
            NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_MODE);

            if (Disp_Mileage_Mode < Mileage_Mode_FaultCode)
            {
                Disp_Mileage_Mode++;
            }
            else
            {
                Disp_Mileage_Mode = Mileage_Mode_Total;
            }
        }

        // 长按Set键的逻辑
        if (KEY_HOLD == set_button)
        {
            if (Disp_Mileage_Mode == Mileage_Mode_TripA)
            {
                if ((bCurMenuIDX != _MN_DSP_PHONE_CONNECT) || (timeFlashNumber == 0))
                    Data_Clear_Trip(EM_TRIP_A);
            }
            else if (Disp_Mileage_Mode == Mileage_Mode_TripB)
            {
                if ((bCurMenuIDX != _MN_DSP_PHONE_CONNECT) || (timeFlashNumber == 0))
                    Data_Clear_Trip(EM_TRIP_B);
            }
            else
            {
                if (Disp_Mileage_Mode == Mileage_Mode_Total)
                {
                    if (Common_GetIgnOnTime() > 10000)
                    {
                        if ((Common_Get_Disp_E_Speed() >= 12000) && (Common_Get_Disp_V_Speed() >= 1990))
                        {
                            Data_Mileage_Clear();
                            Set_SEG_Check_Contrl(1); // 20221117  TYW大计清零后，循环显示断码检测
                        }
                    }
                }
            }
        }
    }
    else
    {
        if ((10 > get_ID_ISG_BATT()) && (CAN_SIG_NORMAL == CAN_MSG_Status(ID_ISG_BATT_Count)))
        {
            BatteryErr = 1;
            Disp_Mileage_Mode = Mileage_Mode_TempErr;
        }
    }

    if ((BatteryErr == 1) && (Common_GetIgnOnTime() >= 14000U))
    {
        BatteryErr = 0;
        Disp_Mileage_Mode = Mileage_Mode_Total;
    }
}
/******************************************************************************
  函数名：MenuStatusSwitch
  功  能：按键检测
  参  数IOInput 输入状态
  返回值：无
 ******************************************************************************/
//按键检测  选择键
void MenuStatusSwitchUnit(KeyStatusEnum set_button)
{
	uint8_t i = 6;

    if(Common_GetIgnOnTime() > IGON_SelfcheckingTimer)
    {
        // 按键短按 1
        if (KEY_PRESS == set_button)
        {
            if (UnitSettings == Metric)
            {
                UnitSettings = Imperial;
            }
            else
            {
                UnitSettings = Metric;
            }
        }

        // 长按Set键的逻辑
        if (KEY_HOLD == set_button)
        {
        
            if (TCS_Contrl == 0)
            {
                TCS_Contrl = 1;
            }
            else
            {
                TCS_Contrl = 0;
            }
        }
    }
}

uint8_t Get_TCS_Status(void)
{
    return TCS_Contrl;
}



uint8_t Get_Menu_Byte6(void)
{
    return MenuByte6;
}

uint8_t Get_Menu_Byte7(void)
{
    return MenuByte7;
}
uint8_t Get_Menu_Byte8(void)
{
    return MenuByte8;
}
uint8_t Get_Menu_Byte9(void)
{
    return MenuByte9;
}


dayOrNightControl_E Get_Day_Or_Night_Control(void)
{
    return DayOrNightControl;
}
const _MenuOptTab   MenuOptTab[] =
{
   
    //          MODE                       SET                     Enter                        Do                       Exit
    //行车电脑界面
    {          _MN_IDX_NULL,            _MN_IDX_NULL,       Level1Animation_Enter,       Level1Animation_Do,       Level1Animation_Exit },// _MN_DSP_ANIMATION ,    //开机动画
    {          _MN_IDX_NULL,            _MN_IDX_NULL,       Level1DriveInfo_Enter,       Level1DriveInfo_Do,       Level1DriveInfo_Exit },//_MN_DSP_DRIVE_INFO,     //行车信息
    {          _MN_IDX_NULL,            _MN_IDX_NULL,       Level2Menu_2Enter,           Level2Menu_2Do,           Level2Menu_2Exit     },//_MN_DSP_PHONE_CONNECT,  //时钟设置 借用

    //一级菜单
    {  _MN_DSP_LEVEL1MENU_2,    _MN_DSP_LEVEL2MENU_1,           Level1Menu_1Enter,           Level1Menu_1Do,           Level1Menu_1Exit },//_MN_DSP_LEVEL1MENU_1,   //界面切换
    {  _MN_DSP_LEVEL1MENU_3,    _MN_DSP_LEVEL2MENU_2,           Level1Menu_2Enter,           Level1Menu_2Do,           Level1Menu_2Exit },//_MN_DSP_LEVEL1MENU_2,   //时钟设置
    {  _MN_DSP_LEVEL1MENU_4,    _MN_DSP_LEVEL2MENU_3,           Level1Menu_3Enter,           Level1Menu_3Do,           Level1Menu_3Exit },//_MN_DSP_LEVEL1MENU_3,   //背光设置
    {  _MN_DSP_LEVEL1MENU_5,            _MN_IDX_NULL,           Level1Menu_4Enter,           Level1Menu_4Do,           Level1Menu_4Exit },//_MN_DSP_LEVEL1MENU_4,   //单位设置
    {  _MN_DSP_LEVEL1MENU_6,            _MN_IDX_NULL,           Level1Menu_5Enter,           Level1Menu_5Do,           Level1Menu_5Exit },//_MN_DSP_LEVEL1MENU_5,   //语言设置
    {  _MN_DSP_LEVEL1MENU_7,    _MN_DSP_LEVEL2MENU_6,           Level1Menu_6Enter,           Level1Menu_6Do,           Level1Menu_6Exit },//_MN_DSP_LEVEL1MENU_6,   //车辆设置
    {  _MN_DSP_LEVEL1MENU_8,  _MN_DSP_LEVEL2MENU_7_1,           Level1Menu_7Enter,           Level1Menu_7Do,           Level1Menu_7Exit },//_MN_DSP_LEVEL1MENU_7,   //手机蓝牙
    {  _MN_DSP_LEVEL1MENU_9,  _MN_DSP_LEVEL2MENU_8_1,           Level1Menu_8Enter,           Level1Menu_8Do,           Level1Menu_8Exit },//_MN_DSP_LEVEL1MENU_8,   //胎压设置
    {  _MN_DSP_LEVEL1MENU_1,      _MN_DSP_DRIVE_INFO,           Level1Menu_9Enter,           Level1Menu_9Do,           Level1Menu_9Exit },//_MN_DSP_LEVEL1MENU_9,   //退出

    //二级菜单
    {          _MN_IDX_NULL,      _MN_DSP_DRIVE_INFO,           Level2Menu_1Enter,           Level2Menu_1Do,           Level2Menu_1Exit },//_MN_DSP_LEVEL2MENU_1, //界面切换-黑夜/白天/自动
    {          _MN_IDX_NULL,            _MN_IDX_NULL,           Level2Menu_2Enter,           Level2Menu_2Do,           Level2Menu_2Exit },//_MN_DSP_LEVEL2MENU_2,   //时钟设置
    {          _MN_IDX_NULL,    _MN_DSP_LEVEL1MENU_3,           Level2Menu_3Enter,           Level2Menu_3Do,           Level2Menu_3Exit },//_MN_DSP_LEVEL2MENU_3,   //背光设置
    {          _MN_IDX_NULL,    _MN_DSP_LEVEL1MENU_6,           Level2Menu_6Enter,           Level2Menu_6Do,           Level2Menu_6Exit },//_MN_DSP_LEVEL2MENU_6,   //车辆设置
    {_MN_DSP_LEVEL2MENU_7_2,            _MN_IDX_NULL,         Level2Menu_7_1Enter,         Level2Menu_7_1Do,         Level2Menu_7_1Exit },//_MN_DSP_LEVEL2MENU_7_1, //手机蓝牙-蓝牙连接
    {_MN_DSP_LEVEL2MENU_7_3,            _MN_IDX_NULL,         Level2Menu_7_2Enter,         Level2Menu_7_2Do,         Level2Menu_7_2Exit },//_MN_DSP_LEVEL2MENU_7_2, //手机蓝牙-同步联系人
    {_MN_DSP_LEVEL2MENU_7_4,            _MN_IDX_NULL,         Level2Menu_7_3Enter,         Level2Menu_7_3Do,         Level2Menu_7_3Exit },//_MN_DSP_LEVEL2MENU_7_3, //手机蓝牙-蓝牙名称
    {_MN_DSP_LEVEL2MENU_7_1,    _MN_DSP_LEVEL1MENU_7,         Level2Menu_7_4Enter,         Level2Menu_7_4Do,         Level2Menu_7_4Exit },//_MN_DSP_LEVEL2MENU_7_4, //手机蓝牙-退出
    {_MN_DSP_LEVEL2MENU_8_2,            _MN_IDX_NULL,         Level2Menu_8_1Enter,         Level2Menu_8_1Do,         Level2Menu_8_1Exit },//_MN_DSP_LEVEL2MENU_8_1, //车辆设置-压力单位设置
    {_MN_DSP_LEVEL2MENU_8_3,            _MN_IDX_NULL,         Level2Menu_8_2Enter,         Level2Menu_8_2Do,         Level2Menu_8_2Exit },//_MN_DSP_LEVEL2MENU_8_2, //车辆设置-前轮传感器学习
    {_MN_DSP_LEVEL2MENU_8_4,            _MN_IDX_NULL,         Level2Menu_8_3Enter,         Level2Menu_8_3Do,         Level2Menu_8_3Exit },//_MN_DSP_LEVEL2MENU_8_3, //车辆设置-后轮传感器学习
    {_MN_DSP_LEVEL2MENU_8_1,    _MN_DSP_LEVEL1MENU_8,         Level2Menu_8_4Enter,         Level2Menu_8_4Do,         Level2Menu_8_4Exit },//_MN_DSP_LEVEL2MENU_8_4, //车辆设置-退出

};





