
#include "stdint.h"
#include "Key.h"

#ifndef MEU_PROCESS_H_
#define MEU_PROCESS_H_

#define   _MN_IDX_NULL  0xff
#define   _MN_IDX_NULL0 0x00
#define   _MN_OPR_NULL  (void *)0

#define    NoKeyPressReturnThreshold    10000    //无按键操作返回阈?
#define    ANIMATION_TIME    3000    //?机动画超时时间，单位ms
#define    SELF_TEST_TIME    3000    //自检扫表超时时间，单位ms

#define EventMsgType_CurFault       0x21
#define EventMsgType_HisFault       0x22
#define EventMsgType_VersionNum     0x23
#define EventMsgType_MCUVersion     0x24

#define PART_NUM  "70000M310001"  // part number 零件?

#define MCU_version         "9.0.004"       //Must be 1.a.bbb format??!!! 韫囧懘銆忛弰?1.a.bcd閺嶇厧绱￠敍? a<=9, bcd<=255
#define MCU_CompileData     "231013"        //The data format must be 6 Byte length!!! 閺冨爼妫块弽鐓庣?韫囧懘銆忔稉?6娑擃亜鐡ч懞鍌炴毐??
    //1) 閺€璺哄? xx 50 02 xx xx xx xx xx閸氬函绱濋崣顏勪粻鐠囧﹥鏌囨径鏍у絺閿涘奔绗夐崑婊冪安閻劌顦婚崣?
    //2) 閸樼粯甯€妤傛ê甯囬幁顖氱潌閸旂喕鍏橀敍灞肩秵閻㈤潧甯囧銈嗗皾閺冨爼妫挎晶鐐插??5??


//#define MCU_version         "1.0.006"       //Must be 1.a.bbb format?!!! 必须?1.a.bcd格式? a<=9, bcd<=255
//#define MCU_CompileData     "230817"        //The data format must be 6 Byte length!!! 时间格式必须?6个字节长?
    //1) 增加F187读零件号
    //2) ?15电马上关闭背光（之前延时10ms?
    //3) 增加清大计后扫表
    //4) 修改R档变其它档位先显示白?"R"问题
    //5) 增加0x55C TRIPA/TRIPB同时清零





//#define PART_NUM  "70000XB00000"  // 零件?
//#define MCU_version         "V01.00.05"  //20230731
    //1) 修改燃油参数
    //2) 燃油外发??320?
    
//#define MCU_version         "V01.00.04"  //20230612 
    //1）修改剩余清除?计次数外发错误问题

typedef enum _tagMenuName
{
    _MN_DSP_ANIMATION = 0,  //?机动?
    _MN_DSP_DRIVE_INFO,     //行车信息
    _MN_DSP_PHONE_CONNECT,  //手机互联
    
    _MN_DSP_LEVEL1MENU_1,   //界面切换
    _MN_DSP_LEVEL1MENU_2,   //时钟设置
    _MN_DSP_LEVEL1MENU_3,   //背光设置
    _MN_DSP_LEVEL1MENU_4,   //单位设置
    _MN_DSP_LEVEL1MENU_5,   //语言设置
    _MN_DSP_LEVEL1MENU_6,   //车辆设置
    _MN_DSP_LEVEL1MENU_7,   //手机蓝牙
    _MN_DSP_LEVEL1MENU_8,   //胎压设置
    _MN_DSP_LEVEL1MENU_9,   //??
    
    _MN_DSP_LEVEL2MENU_1,   //界面切换-黑夜/白天/自动
    _MN_DSP_LEVEL2MENU_2,   //时钟设置
    _MN_DSP_LEVEL2MENU_3,   //背光设置
    _MN_DSP_LEVEL2MENU_6,   //车辆设置
    _MN_DSP_LEVEL2MENU_7_1, //手机蓝牙-蓝牙连接
    _MN_DSP_LEVEL2MENU_7_2, //手机蓝牙-同步联系?
    _MN_DSP_LEVEL2MENU_7_3, //手机蓝牙-蓝牙名称
    _MN_DSP_LEVEL2MENU_7_4, //手机蓝牙-??
    _MN_DSP_LEVEL2MENU_8_1, //车辆设置-压力单位设置
    _MN_DSP_LEVEL2MENU_8_2, //车辆设置-前轮传感器学?
    _MN_DSP_LEVEL2MENU_8_3, //车辆设置-后轮传感器学?
    _MN_DSP_LEVEL2MENU_8_4, //车辆设置-??

}MenuName_E;
typedef enum _dayOrNightControl
{
    
    DayOrNight_Automatic,
    Manual_Day,
    Manual_Night,

}dayOrNightControl_E;

typedef enum _unitSetting
{
    Metric,
    Imperial,
}unitSetting_E;

typedef enum  {
    BL_Automatic,
    BL_Manual,

}BG_MODE;

typedef enum {
    BL_USER_SET_LV_1,
    BL_USER_SET_LV_2,
    BL_USER_SET_LV_3,
    BL_USER_SET_LV_4,
    BL_USER_SET_LV_5,
    BL_USER_SET_LV_AUTO,
    BL_REAL_LV_TOTAL,
}BL_USER_SET_LV_E;
typedef enum {
    Mileage_Mode_Total = 0,
    Mileage_Mode_TripA,
    Mileage_Mode_TripB,
    Mileage_Mode_FaultCode,
    Mileage_Mode_TempErr,

}Disp_Mileage_Mode_E;
typedef uint8_t _MENU_IDX;
typedef struct
{
    _MENU_IDX   VK_IDX_MODE;
    _MENU_IDX   VK_IDX_SET;

    void (*Enter)(void);
    void (*Do)(void);
    void (*Exit)(void);
} _MenuOptTab;

extern    void    MenuKL30Init(void);
extern    void    MenuIgnOnInit(void);
extern   void    MenuManage(void);
extern uint8_t Get_Menu_Byte6(void);
extern uint8_t Get_Menu_Byte7(void);
extern uint8_t Get_Menu_Byte8(void);
extern uint8_t Get_Menu_Byte9(void);
extern BL_USER_SET_LV_E Get_BL_User_Set_Level(void);
extern Disp_Mileage_Mode_E Get_Disp_Mileage_Mode(void);
extern uint8_t Get_Self_Test_Sts(void);
extern uint8_t Get_Unit_Setting(void);
extern PHONE_CONNECT_t Common_Get_ConnectPhoneSts(void);
extern void MenuStatusSwitchODO(KeyStatusEnum set_button);
extern void MenuStatusSwitchUnit(KeyStatusEnum set_button);
extern dayOrNightControl_E Get_Day_Or_Night_Control(void);
extern uint8_t get_SEG_Check_Contrl(void);
extern uint8_t Get_TCS_Status(void);
#endif


