#ifndef _SEG_LCD_H_
#define _SEG_LCD_H_

#include "BU98R10.H"


/******************************************************************************
段码状态
******************************************************************************/
#define   SEG_LCD_LIGHT                     7
#define   SEG_LCD_GRAY                      1
#define   SEG_LCD_GRAY_2                    2
#define   SEG_LCD_OFF                       0
#define   SEG_LCD_ON                        255
/******************************************************************************
显示模式
******************************************************************************/
#define   GUI_DISP_MODE_NORMAL              0x00    //正常
#define   GUI_DISP_MODE_WARNING             0x01    //报警
#define   GUI_DISP_MODE_NEGATIVE            0x01    //负数
#define   GUI_DISP_MODE_BLANK               0x02    //空白
#define   GUI_DISP_MODE_INVALID             0x03    //无效

/******************************************************************************
段码液晶显示数据备份结构
******************************************************************************/
typedef struct
{
  uint8_t   Brightness;
  uint8_t   Window;
  uint8_t   SetMode;
  uint8_t   VSpeedSeg;
  uint8_t   ESpeedSeg;
  uint16_t  VSpeed;
  uint16_t  ESpeed; 
  uint16_t  Voltage;
  uint8_t   VolCANset;
	uint8_t   Gear;
	uint8_t   TempSeg;
	uint8_t   FuelSeg;
	uint8_t   ODOMode;
	uint32_t  ODOMileage;
	uint8_t   ODOUnit;
	
}SEGLCDBackupStruct;

/******************************************************************************
图标状态寄存器SEGLCDIconxxxStatus位定义
================================================================
 Bit 7 | SEG_LCD_ICON_FORCE      | 强制显示标志
-------+-------------------------+------------------------------
 Bit 6 | Rsvd.                   | 保留
-------+-------------------------+------------------------------
 Bit 5 | Rsvd.                   | 保留
-------+-------------------------+------------------------------
 Bit 4 | Rsvd.                   | 保留
-------+-------------------------+------------------------------
 Bit 3 | Rsvd.                   | 保留
-------+-------------------------+------------------------------
 Bit 2 | Rsvd.                   | 保留
-------+-------------------------+------------------------------
 Bit 1 | SEG_LCD_ICON_FORCE_STAT | 强制显示状态 1-强制点亮 0-强制熄灭
-------+-------------------------+------------------------------
 Bit 0 | SEG_LCD_ICON_STAT       | 显示状态 1-点亮 0-熄灭
================================================================
******************************************************************************/
#define  SEG_LCD_ICON_FORCE                 ((uint8_t)0x80)
#define  SEG_LCD_ICON_FORCE_STAT            ((uint8_t)0x02)
#define  SEG_LCD_ICON_STAT                  ((uint8_t)0x01)


#define Clr_Bit(p, b)           (p) &= (~(1u << (b)))
#define Set_Bit(p, b)           (p) |= (1u << (b))
#define Bit_Is_Set(p, b)        ((p) &(1u << (b)))
#define Bit_Is_Clr(p, b)       (!((p) & (1u << (b))))

/******************************************************************************
Icon开关状态
******************************************************************************/
typedef enum
{
  SEG_LCD_ICON_OFF = 0,    //熄灭图标
  SEG_LCD_ICON_ON,         //点亮图标
  SEG_LCD_ICON_FORCE_OFF,  //强制熄灭图标,通过 SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON 状态不能控制图标熄灭或点亮
  SEG_LCD_ICON_FORCE_ON,   //强制点亮图标,通过 SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON 状态不能控制图标熄灭或点亮
  SEG_LCD_ICON_FREE,       //取消对图标的强制熄灭或点亮,将图标交由 SEG_LCD_ICON_OFF / SEG_LCD_ICON_ON 状态控制 
}SEGLCDIconStatusEnum;
/**********************************************************************************
全局变量
***********************************************************************************/
extern SEGLCDBackupStruct   SEGLCDBackup;

/******************************************************************************
函数声明
******************************************************************************/
void SEG_LCD_Init(void);
void SEG_LCD_Shutdown(void);



void SEG_LCD_Gear_Display(uint8_t m_Flag, uint8_t Gear, uint8_t CanStand);
void SEG_LCD_Vehicle_Speed_Num_Display(uint8_t m_Flag, uint8_t SetMode, uint16_t Vspeed);  //1:mph default:km/h
void SEG_LCD_Vehicle_Speed_Num_Selftest(uint16_t Vspeed);
void SEG_LCD_Engine_Speed_Seg_Display(uint8_t m_Flag, uint16_t SegNum);
void SEG_LCD_Engine_Speed_Seg_Selftest(uint16_t SegNum);
void SEG_LCD_ODO_Trip_FaultCode_Display(uint8_t m_Flag, uint8_t Mode, uint8_t Unit, uint32_t Mileage);
void SEG_LCD_ODO_Trip_FaultCode_Selftest(uint8_t Mileage);
void SEG_LCD_BatteryErr_Display(uint8_t m_Flag, uint32_t ModeTime);
void SEG_Coolant_Temp_Display(uint8_t m_Flag, uint8_t Seg);
void SEG_Fuel_Level_Display(uint8_t m_Flag, uint8_t Seg);
void SEG_LCD_Battery_Voltage_Display(uint8_t m_Flag, uint8_t Voltage ,uint16_t VolCANset);
void SEG_LCD_Battery_Voltage_Selftest(uint8_t Voltage);




//Light
void SEG_LCD_OilPressure(uint8_t state);
void SEG_LCD_TirePressure(uint8_t state);
void SEG_LCD_READY(uint8_t state);
void SEG_LCD_ABS(uint8_t state);
void SEG_LCD_TSC(uint8_t state);
void SEG_LCD_AutoStarStop(uint8_t state);
void SEG_LCD_Batterylow(uint8_t state);
void SEG_LCD_HI_BEAM(uint8_t state);
void SEG_LCD_Shore(uint8_t state);
void SEG_LCD_OBD(uint8_t state);
void SEG_LCD_HighBeam(uint8_t state);
void SEG_LCD_LeftTurn(uint8_t state);
void SEG_LCD_RightTurn(uint8_t state);
void SEG_LCD_Fuel(uint8_t state);
void SEG_LCD_Temp(uint8_t state);

void Engine_Speed_Update(void);
#endif 
