#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Flash_synchronizer.h"
#include "Common_Interface.h"
#include "Line_in.h"
#include "CAN_User.h"
#include "SEG_LCD.h"
#include "CoolantTemp.h"
#include "gpio.h"
#include "Fuel.h"
#include "CoolantTemp.h"
#include "CAN_Communication_Matrix.h"
#include "MCU_Core_Protocol.h"
#include "Data_Gear.h"
#include "app_Telltales.h"
#include "Menus.h"
#include "Fuel.h"
#include "Key.h"
#include "Menus.h"
const LED_Attribute_st LED_Attribute[LED_Max]__attribute__ ((aligned (4)));

Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ] __attribute__ ((aligned (4)));


void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk = Common_Get_IG_Sts;
    Telltales_KL30_Wakeup_Init((uint8_t *)Tel_Mem, LED_Attribute, &m_ExtPara);
}

const LED_Attribute_st LED_Attribute[LED_Max] =
{
    /*  指示灯索引                  是否自检          外部信号自检          工作电源状态      自检开始时间  自检持续时间                 指示灯点亮条件                        指示灯执行函数                   */
    {   m_LED_RIGHT             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_RIGHT_Judgement              ,   LED_RIGHT_Execution             },//右转向
    {   m_LED_LEFT              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_LEFT_Judgement               ,   LED_LEFT_Execution              },//左转向
    {   m_LED_HI_BEAM           ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_HI_BEAM_Judgement            ,   LED_HI_BEAM_Execution           },//远光灯
    {   m_LED_MIL               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_MIL_Judgement                ,   LED_MIL_Execution               },//发动机报警灯
    {   m_LED_ABS               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_ABS_Judgement                ,   LED_ABS_Execution               },//ABS_低有效
    {   m_LED_TSC               ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_TSC_Judgement                ,   LED_TSC_Execution               },//TSC
    {   m_LED_AutoStarStop      ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_AutoStarStop_Judgement       ,   LED_AutoStarStop_Execution      },//自动启停
    {   m_LED_Batterylow        ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_Batterylow_Judgement         ,   LED_Batterylow_Execution        },//蓄电池电压报警
    {   m_LED_Auto_HI_BEAM      ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_Auto_HI_BEAM_Judgement       ,   LED_Auto_HI_BEAM_Execution      },//自动远光灯（预留）
    {   m_LED_Shore             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_Shore_Judgement              ,   LED_Shore_Execution             },//边撑状态
    {   m_LED_ENGINE_OIL_LOW    ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_ENGINE_OIL_LOW_Judgement     ,   LED_ENGINE_OIL_LOW_Execution    },//机油压力报警灯（预留）
    {   m_LED_TPMS              ,  NoSelfCheck   ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_TPMS_Judgement               ,   LED_TPMS_Execution              },//胎压功能（预留）
    {   m_LED_READY             ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_READY_Judgement              ,   LED_READY_Execution             },//READY
    {   m_LED_Fuel              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_Fuel_Judgement               ,   LED_Fuel_Execution              },//燃油
    {   m_LED_Temp              ,  SelfCheck     ,  NoExterNalCheck  ,   LED_IGN_ON    ,       0u,     IGON_SelfcheckingTimer,     LED_Temp_Judgement               ,   LED_Temp_Execution              },//水温
};

/******************************************************************************
  右转向灯
  信号接口：硬线
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_RIGHT_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_RightTurn);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_RIGHT_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_RightTurn(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Right, 1);
    }
    else
    {
        SEG_LCD_RightTurn(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_Right, 0);
    }
}
/******************************************************************************
  左转向灯
  信号接口：硬线
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_LEFT_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_LeftTurn);
    if (Get_LIne_Sta == LINE_IN_LOGIC_VALID)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_LEFT_Execution(uint16_t led_status)
{

    if (led_status == 1u)
    {
        SEG_LCD_LeftTurn(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Left, 1);
    }
    else
    {
        SEG_LCD_LeftTurn(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_Left, 0);
    }
}
/******************************************************************************
  远光灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_HI_BEAM_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_HighBeam);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_HI_BEAM_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_HighBeam(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_HighBeam, 1);
    }
    else
    {
        SEG_LCD_HighBeam(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_HighBeam, 0);
    }
}
/******************************************************************************
  发动机故障报警灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_MIL_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_OBD);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_MIL_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_OBD(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_OBD, 1);
    }
    else
    {
        SEG_LCD_OBD(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_OBD, 0);
    }
}
/******************************************************************************
  ABS故障报警灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_ABS_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_ABS);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_ABS_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_ABS(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_ABS, 1);
    }
    else
    {
        SEG_LCD_ABS(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_ABS, 0);
    }
}
/******************************************************************************
  TSC故障报警灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_TSC_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    uint8_t Get_CANdate1 = 0u;
    uint8_t Get_CANdate2 = 0u;
    uint8_t Get_CANdate3 = 0u;
    
    Get_CANdate = Get_ID_125_Sig_TCS_SysState();
    Get_CANdate1 = Get_ID_125_Sig_TCS_WorkMode();
    Get_CANdate2 = Get_ID_125_Sig_TCS_WarningLamp();
    Get_CANdate3 = (CAN_SIG_NORMAL == CAN_MSG_Status(ID_TCS_Count)) ? 1 : 0;

	
    if (Get_CANdate3 == 1)
    {
        if (Get_CANdate == 0u)
        {
            u8Result = 1u;
        }
        else if (Get_CANdate1 == 1u)
        {
            u8Result = 0u;
        }
        else if ((Get_CANdate1 == 0u) && (Get_TCS_WorkModeFlash() == 1))
        {
            if (FLASH_SYNC_1Hz)
            {
                
                u8Result = 1;
            }
            else
            {
                u8Result = 0;
            }
            
        }
        else if (Get_CANdate1 == 0u)
        {
            if (Get_CANdate2 == 1)
            {
                if (FLASH_SYNC_1Hz)
                {
                    u8Result = 1;
                }
                else
                {
                    u8Result = 0;
                }
            }
            else
            {
                u8Result = 1;
            }
            
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}


int count = 0;
extern uint8_t Button_Flg;
void LED_TSC_Execution(uint16_t led_status)
{	
	
    if ((led_status == 1u) && (Get_TCS_Status()))
    {	
		if(Button_Flg == 1)
		{	
			if(FLASH_SYNC_1Hz)
			{
				count++;
				SEG_LCD_TSC(SEG_LCD_LIGHT);
        		App_Telltales_Ctrl(LED_TLight, 1);
			}
			else
			{
				SEG_LCD_TSC(SEG_LCD_OFF);
        		App_Telltales_Ctrl(LED_TLight, 0);	
			}
	
		}	
				

    }

	
    else
    {
        SEG_LCD_TSC(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_TLight, 0);
    }
}
/******************************************************************************
  自动启停故障报警灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_AutoStarStop_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_AutoStarStop);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_AutoStarStop_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_AutoStarStop(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_AutoStartStop, 1);
    }
    else
    {
        SEG_LCD_AutoStarStop(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_AutoStartStop, 0);
    }
}
/******************************************************************************
  蓄电池电压报警
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_Batterylow_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    u8Result = Get_LED_ECU_Battery_VoltageFlag();
    Get_CANdate = (CAN_SIG_NORMAL == CAN_MSG_Status(ID_ECU_Battery_Count)) ? 1 : 0;
    
    if ((u8Result == 1u) && (Get_CANdate == 1))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_Batterylow_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_Batterylow(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Battery, 1);
    }
    else
    {
        SEG_LCD_Batterylow(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_Battery, 0);
    }
}
/******************************************************************************
  自动远光灯（预留）
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_Auto_HI_BEAM_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    // Get_CANdate = get_240_MILLampSts();
    if (Get_CANdate == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_Auto_HI_BEAM_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_HI_BEAM(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_ALight, 1);
    }
    else
    {
        SEG_LCD_HI_BEAM(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_ALight, 0);
    }
}
/******************************************************************************
  边撑状态
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_Shore_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    Get_CANdate = Get_ID_111_Sig_ISG_SideStand();
    if (Get_CANdate == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_Shore_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_Shore(SEG_LCD_LIGHT);
        PORT_SetBit(TLight_OUT);
    }
    else
    {
        SEG_LCD_Shore(SEG_LCD_OFF);
        PORT_ClrBit(TLight_OUT);
    }
}
/******************************************************************************
  机油压力低报警灯
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_ENGINE_OIL_LOW_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    // Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_OilPressure);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_ENGINE_OIL_LOW_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_OilPressure(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_OilPressure, 1);
    }
    else
    {
        SEG_LCD_OilPressure(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_OilPressure, 0);
    }
}
/******************************************************************************
  胎压功能（预留）
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_TPMS_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_LIne_Sta = 0u;
    // Get_LIne_Sta = (uint8_t)Line_In_Get_Status(LINE_IN_OilPressure);
    if (Get_LIne_Sta == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_TPMS_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_TirePressure(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_TirePressure, 1);
    }
    else
    {
        SEG_LCD_TirePressure(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_TirePressure, 0);
    }
}
/******************************************************************************
  READY
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_READY_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    Get_CANdate = Get_ID_111_ISG_Ready();
    if (Get_CANdate == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_READY_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_READY(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_READY, 1);
    }
    else
    {
        SEG_LCD_READY(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_READY, 0);
    }
}
/******************************************************************************
  燃油
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_Fuel_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_Fueldate = 0u;
    Get_Fueldate = Get_CurFuelSetp();
    if (Get_Fuel_Sensor_State() == FuelSensorNormal)
    {
        if (Get_Fueldate == 0u)
        {
            //u8Result = FLASH_SYNC_1Hz ? 2 : 0;
            if(FLASH_SYNC_1Hz) 
            	u8Result = 2;
			else
				u8Result = 0;
        }
        else if (Get_Fueldate == 1u)
        {
            u8Result = 2u;
        }
        else
        {
            u8Result = 1u;
        }
    }
    else
    {
        u8Result = 1u;
    }
    
    return u8Result;
}
extern uint8_t CurFuelSetp;
void LED_Fuel_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_Fuel(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Fuel_W, 1);
        App_Telltales_Ctrl(LED_Fuel_Y, 0);
    }
    else if (led_status == 2u)
    {
        SEG_LCD_Fuel(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Fuel_W, 0);
        App_Telltales_Ctrl(LED_Fuel_Y, 1);
    }
    else
    {
        SEG_LCD_Fuel(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_Fuel_W, 0);
        App_Telltales_Ctrl(LED_Fuel_Y, 0);
    }
}
/******************************************************************************
  水温
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint16_t LED_Temp_Judgement(void)
{
    uint16_t u8Result = 0u;
    uint8_t Get_CANdate = 0u;
    Get_CANdate = Get_CoolantTemp_Alarm();
    if (Get_CANdate == 0u)
    {
        u8Result = 1u;
    }
    else if (Get_CANdate)
    {
        u8Result = 2u;
    }
    else
    {
        u8Result = 0u;
    }
    return u8Result;
}
void LED_Temp_Execution(uint16_t led_status)
{
    if (led_status == 1u)
    {
        SEG_LCD_Temp(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Temp_W, 1);
        App_Telltales_Ctrl(LED_Temp_R, 0);
    }
    else if (led_status == 2u)
    {
        SEG_LCD_Temp(SEG_LCD_LIGHT);
        App_Telltales_Ctrl(LED_Temp_W, 0);
        App_Telltales_Ctrl(LED_Temp_R, 1);
    }
    else
    {
        SEG_LCD_Temp(SEG_LCD_OFF);
        App_Telltales_Ctrl(LED_Temp_W, 0);
        App_Telltales_Ctrl(LED_Temp_R, 0);
    }
}
