#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_

#include "common.h"

   
void Common_DataInit(void);
extern void Common_Input_Para(void);

MSG_01_DISP_MODE_t Common_Get_DispMode(void);
void Common_Set_DispMode(MSG_01_DISP_MODE_t mode);
LANGUAGE_t Common_Get_Language(void);

COMMON_PowerStatus_t Common_Get_IG_Sts(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);

uint16_t Common_Get_Act_V_Speed(void);
uint16_t Common_Get_Act_E_Speed(void);
uint16_t Common_Get_Disp_V_Speed(void);
uint16_t Common_Get_Disp_E_Speed(void);
uint16_t Common_Get_Gauges_Disp_E_Speed(void);

//Լ
uint16_t Common_Get_E_Speed_TEST(void);
uint16_t Common_Get_V_Speed_TEST(void);
uint8_t Common_Get_Fuel_TEST(void);
uint8_t Common_Get_Temp_TEST(void);

DataValid_t Common_Get_Act_V_Speed_Valid(void);
DataValid_t Common_Get_Act_E_Speed_Valid(void);
DataValid_t Common_Get_Disp_V_Speed_Valid(void);
DataValid_t Common_Get_Disp_E_Speed_Valid(void);


void Common_Set_Act_V_Speed(uint16_t Val);
void Common_Set_Act_E_Speed(uint16_t Val);
void Common_Set_Disp_V_Speed(uint16_t Val);
void Common_Set_Disp_E_Speed(uint16_t Val);
void Common_Set_Gauges_E_Speed(uint16_t Val);

//Լ
void Common_Set_E_Speed_Test(uint16_t Val);
void Common_Set_V_Speed_Test(uint16_t Val);
void Common_Set_Fuel_Test(uint8_t Val);
void Common_Set_Temp_Test(uint8_t Val);


void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
void Common_Set_Act_E_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_E_Speed_Valid(DataValid_t Val);


uint16_t Common_Get_DispSpeed(void);

uint32_t Common_GetIgnOnTime(void);  /*ms*/
uint32_t Common_GetIgnOffTime(void); /*ms*/


void Common_RollingCounterAdd(void);
void Common_RollingCounterClear(void);
void Common_BlockDelay(uint16_t m_MS);
uint16_t Common_ReadRollingCounter(void);

#endif

