

#include "System_Monitor.h"
#include "RTE_ADC.h"
#include "GPIO.h"
#include "wdt.h"

#define u16Base_Vol 0u

#define u16ENTER_LOW_N_RANGE 6350U  //6000U  //20220627
#define u16EXIT_LOW_N_RANGE  7000U

#define u16ENTER_LOW_Y_RANGE 6500U
#define u16EXIT_LOW_Y_RANGE  7000U

#define u16EXIT_HIGH_Y_RANGE  31000U
#define u16ENTER_HIGH_Y_RANGE 32000U

#define u16EXIT_HIGH_N_RANGE  33000U
#define u16ENTER_HIGH_N_RANGE 34000U

#define u16Top_Vol 0xffffu

uint32_t  u32SysRollingCounter;

static const uint16_t SysFun_Range[10u] =
{
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
};

static const uint16_t SysNM_Range[10u] =
{
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
};

uint16_t Sys_Force_Read_KL30_Voltage(void)
{
    uint16_t u16Voltage;
  //  u16Voltage = (uint16_t)RTE_ForceRead_KL30_Voltage();
    u16Voltage = 13500;
    return u16Voltage;
}


uint16_t Sys_Read_KL30_Voltage(void)
{
    uint16_t u16Voltage;
    u16Voltage = (uint16_t)RTE_Read_KL15_Voltage();
 //   u16Voltage = 13500;
    return u16Voltage;
}


uint8_t Sys_Read_KL30_Valid(void)
{
    uint8_t u8Valid;
    u8Valid = RTE_Read_KL30_Valid();
    return u8Valid;
}


uint8_t System_LINE_KL15(void)
{
    uint8_t u8KL15;
    if(PORT_GetBit(CHECK_KL15_In)){
        u8KL15 = 1;
    }
    else{
        u8KL15 = 0;
    }
    
    
    return u8KL15;
}


void Sys_KL30_Init ( void)
{
    Sys_Set_DebounceTimer(2500u, 2u, 2500u, 80u);
    Sys_Set_VolRange(SysFun_Range, SysNM_Range);
    System_Monitor_KL30Init();
    System_Fast_WakeUp();
}

void Sys_WakeUp_Init ( void)
{
    Sys_Set_DebounceTimer(2500u, 2u, 2500u, 80u);
    Sys_Set_VolRange(SysFun_Range, SysNM_Range);
    System_Monitor_WakeupInit();
    System_Fast_WakeUp();
}

void Sys_LogicProcess(void)
{
   // COM_NM_ACT();
}


void Sys_BlockDelay(uint32_t u32Ms)
{
    uint32_t  i, Counter;
    for(Counter = 0; Counter<u32Ms; Counter++)
    {
        for(i=0;i<44;i++){
           __NOP(); 
           __NOP(); 
           __NOP(); 
        }
    }
}

