
#include "Key_user.h"
#include "Components.h"


__align(4)

#define BACK_MENU_TIME		1000
_Menu_Data MenuData;
RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_CounterTypeDef counter_val;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)//选择
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		Key_Event_Short_Press_Left();
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_LEFT_EVENT_NONE_Service();
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)//确认
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		Key_Event_Short_Press_Right();
		break;
	case KEY_EVENT_SHORT_PRESS_2:
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		//TYW_RESET_ODO();
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_RIGHT_EVENT_NONE_Service();
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (RTE_GPIO_Get_Level(KEY_SELECT_MCU))//选择
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	else
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	return enKeyReal;
}

Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;

	if (RTE_GPIO_Get_Level(KEY_OK_MCU))//确认
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	else
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,2000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,6000U);

	Key_Parameter_Set_Long_Press_1_Time(7000U);
	Key_Parameter_Set_Long_Press_2_Time(8000U);
	Key_Parameter_Set_Long_Press_3_Time(9000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,2000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,6000U);

	Key_Parameter_Set_Long_Press_1_Time(7000U);
	Key_Parameter_Set_Long_Press_2_Time(8000U);
	Key_Parameter_Set_Long_Press_3_Time(9000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);
}

void Key_TimeOut_Service(void)
{
	if((MenuData.Back_Time_Left_Flag == 1)&&(MenuData.Back_Time_Right_Flag == 1))
	{
		Menu_Service(MENU_KEY_TIMEOUT);
	}
}

void Key_Auto_Save(void)
{
	
	{
		//RTC_SetTime(&counter_val.time);
	}


	{
		//RTC_SetTime(&counter_val.time);
	}

}

void Key_Event_Short_Press_Left(void)//选择
{		
	if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM)//切换大小计
	{
		Menu_Service(MENU_KEY_FUNCTION_1_SHORT);
	}

	if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_DISPLAY_MODE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_FAULT_INFORMATION)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_QUIT))
	{
		Menu_Service(MENU_KEY_RIGHT_SHORT);
	}
	else
	{
		if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_DAYTIME)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_NIGHTTIME)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_AUTO)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_5)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_4)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_3)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_2)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_1)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_AUTO)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_OPEN_CLOSE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_SYNC)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_BACK)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_BACK)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_KM)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_MILE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_CHINESE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_ENGLISH))
		{
			Menu_Service(MENU_KEY_DOWN_SHORT);
		}
	}
}

void Key_Event_Short_Press_Right(void)//确认
{
	if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_DISPLAY_MODE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_FAULT_INFORMATION)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_QUIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_DAYTIME)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_NIGHTTIME)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_AUTO)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_5)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_4)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_3)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_2)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_1)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_AUTO)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_OPEN_CLOSE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_SYNC)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_BACK)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_BACK)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_KM)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_MILE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_CHINESE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_ENGLISH)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_APP))
	{
		Menu_Service(MENU_KEY_CONFIRM_SHORT);
	}
}

void KEY_LEFT_EVENT_NONE_Service(void)	
{
	MenuData.Back_Time_Left++;
	if(MenuData.Back_Time_Left > BACK_MENU_TIME)
	{
		MenuData.Back_Time_Left = BACK_MENU_TIME;
		MenuData.Back_Time_Left_Flag = 1;
	}
}

void KEY_RIGHT_EVENT_NONE_Service(void)	
{
	MenuData.Back_Time_Right++;
	if(MenuData.Back_Time_Right > BACK_MENU_TIME)
	{
		MenuData.Back_Time_Right = BACK_MENU_TIME;
		MenuData.Back_Time_Right_Flag = 1;
	}
}

void Key_Clear_Time(void)
{
	if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	{
		MenuData.Back_Time_Left = 0;
		MenuData.Back_Time_Left_Flag = 0;
		MenuData.Back_Time_Right_Flag = 0;
	}
	if(Key_Status_Read_Right() == KEY_REALTIME_PRESS)
	{
		MenuData.Back_Time_Right = 0;
		MenuData.Back_Time_Left_Flag = 0;
		MenuData.Back_Time_Right_Flag = 0;
	}
}

uint8_t ClearODO_Flag = 0;
void TYW_RESET_ODO(void)
{
	if(SYS_OPR_STAT_IGN_ON)
    {
        if(ClearODO_Flag < 1)
        {
            if((Get_DispVechileSpeed() >= 1500)&&(Get_DispEngineSpeed() >= 12000))
            {
                ClearODO_Flag = 1;
                //Data_Mileage_Clear();
            }
        }
    }
    else
    {
        ClearODO_Flag = 0;
    }
}

void Get_DisTime_Service(void)
{
	if(1)
    {
        RTE_RTC_Get_CounterValue(&counter_val);
        counter_val.time.RTC_Hours = RTC_Bcd2ToByte(counter_val.time.RTC_Hours);
		counter_val.time.RTC_Minutes = RTC_Bcd2ToByte(counter_val.time.RTC_Minutes);
    }
}


uint8_t Get_Dis_Hour_Time(void)
{
	return counter_val.time.RTC_Hours;
}

uint8_t Get_Dis_Minute_Time(void)
{
	return counter_val.time.RTC_Minutes;
}

uint8_t Get_Dis_Unit(void)
{
	return MenuData.Unit; //0km,1mile
}

uint8_t Get_Dis_OdoAndTrip(void)
{
	return MenuData.OdoAndTrip; //0Odo,1Trip
}

uint8_t Get_Dis_Bluetooth_Open_Close(void)
{
	return MenuData.Bluetooth_Open_Close; //0开,1关
}

uint8_t Get_Dis_Language(void)
{
	return MenuData.Language; //0中文,1英文
}