
#ifndef _S6J3360_EE_MANAGE_H_
#define _S6J3360_EE_MANAGE_H_



#pragma pack(1)  /* 必须保留 */

typedef unsigned char    ee_uint8_t;
typedef unsigned short   ee_uint16_t;
typedef unsigned int     ee_uint32_t;
    

#define    READ_FAIL                      0x0000
#define    READING                        0x0001
#define    READ_COMPLETE                  0x0002

#define    WRITE_FAIL                     0x0000
#define    WRITING                        0x0001 
#define    WRITE_COMPLETE                 0x0002



typedef enum
{
    distance_1m = 1,
    distance_10m = 10,
    distance_100m = 100,
    distance_1000m = 1000,
}StorageDistance_t;


typedef enum
{
    AT24C04 = 4,
    AT24C16 = 16,
}DeviceNo_t;
      
typedef struct __attribute__((aligned(4)))
{
    ee_uint32_t Odo;
    ee_uint32_t Trip;
    ee_uint32_t Trip1;
    ee_uint8_t  IsTripClear;
    ee_uint8_t  IsTrip1Clear;
}Mileage_t;

extern ee_uint16_t            OdoValidAddress;
/* 读取库版本号 */
extern        ee_uint8_t*       eeprom_getVersion(void);

/*-------------------------------------------------------------------------
* Function Name  : eeprom_1ms_timeCount
* Description    : 中断中调用 必须中断时间 >= 1ms,这个时间影响写的整体速度
* Input          : 
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_1ms_timeCount(void);  
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_SetParameter
* Description    :
* Input          : device_No:芯片型号 AT24C04 or AT24C16 
                   StorageDistance :相邻两次存储数据间隔，两次存储数据之差必须大于这个间隔
                    distance_1m = 0,
                    distance_10m = 10,
                    distance_100m = 100,
                    distance_1000m = 1000
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_SetParameter(DeviceNo_t device_No,StorageDistance_t StorageDistance);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ClearOdoSection
* Description    : 清零ODO，但是清零完成不死机
* Input          : 
* Output         : 
* Return         :
* onther         :
--------------------------------------------------------------------------*/
extern        void                   eeprom_ClearOdoSection(void);
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_WriteRecord
* Description    :
* Input          : address ; 0~xxx
                   recordDatas:存储数据指针
                   record_len : 记录长度
* Output         : 
* Return         :
                  #define    WRITE_FAIL                     0x0000
                  #define    WRITING                        0x0001 
                  #define    WRITE_COMPLETE                 0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t        eeprom_WriteRecord(ee_uint16_t address,ee_uint8_t* recordDatas,ee_uint16_t record_len);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ReadRecord
* Description    :
* Input          : address ; 0~xxx
                   recordDatas:存储数据指针
                   record_len : 记录长度
* Output         : 
* Return         :
                  #define    READ_FAIL                      0x0000
                  #define    READING                        0x0001
                  #define    READ_COMPLETE                  0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t        eeprom_ReadRecord(ee_uint16_t address,ee_uint8_t* recordDatas,ee_uint16_t record_len);
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_WriteODO
* Description    :
* Input          : StorageDistance 必须与 eeprom_SetParameter设置的一致
                   u32_odo 单位必须与 StorageDistance 保持一致
                   每次唤醒必须执行读 调用eeprom_ReadODO，因为有些信息休眠无法保存
* Output         : 
* Return         :
                  #define    WRITE_FAIL                     0x0000
                  #define    WRITING                        0x0001 
                  #define    WRITE_COMPLETE                 0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t       eeprom_WriteODO(Mileage_t *MileageInfo,StorageDistance_t StorageDistance,ee_uint8_t ign); 
    
    
/*-------------------------------------------------------------------------
* Function Name  : eeprom_ReadODO
* Description    :
* Input          : 
* Output         : 
* Return         :
                  #define    READ_FAIL                      0x0000
                  #define    READING                        0x0001
                  #define    READ_COMPLETE                  0x0002
* onther         :
--------------------------------------------------------------------------*/
extern        ee_uint16_t       eeprom_ReadODO(Mileage_t *MileageInfo);


/*-------------------------------------------------------------------------
get state infomation
--------------------------------------------------------------------------*/
extern        ee_uint16_t         eeprom_getWriteState(void);
extern        ee_uint16_t         eeprom_getReadState(void);
extern        ee_uint16_t         eeprom_getOdoCurWriteAddress(void);
extern        ee_uint32_t         eeprom_getOdoLastWriteValue(void);

/***30电只存储一次调用**/
/*extern void SetEEWriteDressToLib(ee_uint16_t EEWriteDressDate);

extern ee_uint16_t GetEEWriteDressToRam(void);*/
    
#pragma pack () /* 必须保留 */    
    
#endif /* _S6J3360_EE_MANAGE_H_ */


