#include "Data_Coolant.h"
#include "Components.h"
#include "Hysteresis.h"
#define FAST_TIME 20 //20*20 400ms变化一格
#define NORMAL_TIME 500 //500*20 10s变化一格
#define Disconnected_TIME 25 //掉线时间
#pragma ghs section  bss = ".myNonInitArea"
//_Data_Cng Data_Cng_Percent;
//_Data_Cng Data_Cng_Pressure;
Hys_uint8_t u8HysRamData[HYS_RAM_DATA_LEN];
#pragma ghs section  bss = default

DataCoolantTempStruct DataCoolantTemp ;
DataCoolantTempDisStruct DataCoolantTemp_Dis;

DataCoolantTempSamplerStruct DataResCoolantTempSampler ;

 uint8_t u8SelfCheckTime;
 uint8_t u8SelfCheckTime_Finish;
#define SelfCheckTime 60
uint16_t TEMP_SPEED;
uint16_t time_temp;
uint16_t time_power_on = 0;
uint16_t time_lost = 0;

const HYS_Seg_Table_st_t stHYSSegTableCng[9] =
{
	{0,529},		    
	{550, 609},   		
	{630, 689}, 		
	{710, 859}, 		
	{880, 939}, 		
	{960, 1019},
    {1040, 1099},
    {1120, 1179},
    {1200,0xFFFF}, 		
};

/*为了过QAC用的，实际完全不会使用*/
const HYS_Seg_Table_st_t stHYSSegTablePWM[3] =
{
	{0U, 40U},
	{50U, 60U},
	{70U, 100U},
};

const HYS_Attribute_st_t stHysAttribute[HYS_NUM_MAX] =
{
	{stHYSSegTableCng, 0U, 7U, 1U},
	{stHYSSegTablePWM, 0U, 3U, 1U},			/*为了过QAC用的，实际完全不会使用*/
};

uint16_t  Coolant_Res[Coolant_LEN] =
{
    3000,
    1540,
    1510,
    1130,
    1100,
    990,
    960,
    850,
    820,
    680,
	650,
    500,
	470,
    410,
	380,
    230,
	200,
};

uint16_t  Coolant_Temp[Coolant_LEN] =
{
    0,
    52,
    55,
    60,
	63,
    68,
    71,
    85,
    88,
    93,
    96,
    101,
    104,
    109,
    112,
    117,
    120,
} ;

/*
*  DataCoolantTemp.Temp_Value    当前温度值
*  DataCoolantTemp.u8Res_Valid   AD采集的数据是否有效
*  DataCoolantTemp.u8Res_ADValid AD采集是否有效
*  DataCoolantTemp.TEMPMode      此时水温表所在状态
*  DataCoolantTemp_Dis.u8_CurSeg 当前格数
*  DataCoolantTemp.TEMPSetp      目标个数
*/
void TEMP_KL30_Init ( void )
{
    DataCoolantTemp.Temp_Value = 0; 
    DataCoolantTemp.u8Can_Valid = 0;
    DataCoolantTemp.u16Can_Actual = 0;
    DataCoolantTemp.u8Res_Valid = 0 ;
    DataCoolantTemp.u16Res_ADValue  = 0;
    DataCoolantTemp.u8Res_ADValid  = 0;

    DataResCoolantTempSampler.Cnt = 0; 
    DataCoolantTemp.TEMPMode = 0;
    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataCoolantTemp.TEMPSetp = 0;
    TEMP_SPEED = 0;
    time_power_on = 0;
    time_lost = 0;
    time_temp = 0;
    HYS_Init_st_t stHYSInit;
	stHYSInit.u8HYSNum = HYS_NUM_MAX;
    HYS_KL30_Init(&u8HysRamData[0], stHysAttribute, &stHYSInit);
}

void TEMP_KL15_Init ( void )
{

    DataCoolantTemp.Temp_Value = 0; 
    DataCoolantTemp.u8Can_Valid = 0;
    DataCoolantTemp.u16Can_Actual = 0;
    DataCoolantTemp.u8Res_Valid = 0 ;
    DataCoolantTemp.u16Res_ADValue  = 0;
    DataCoolantTemp.u8Res_ADValid  = 0;
    DataCoolantTemp_Dis.u8_CurSeg = 0;
    DataResCoolantTempSampler.Cnt = 0;  
    DataCoolantTemp.TEMPMode = 0;
    TEMP_SPEED = 0;
    time_power_on = 0;
    time_lost = 0;
    time_temp = 0;
}

void Data_Coolant_Temp_Processing_Service ( void )
{
    uint16_t  Coolant_Temperature;
    uint32_t Temp;
    uint8_t  i;
    
    Coolant_Temperature = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature();
    //can
    if (SYS_OPR_STAT_IGN_ON )
    {   
        //can
        if( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_101_Msg_Count) == CAN_SIG_LOST))
        {
            DataCoolantTemp.u8Can_Valid = 0;
            DataCoolantTemp.u16Can_Actual = 0;
        }
        else
        {
            if(Coolant_Temperature >= 0x6338)
            {
                DataCoolantTemp.u8Can_Valid = 0;
                DataCoolantTemp.u16Can_Actual = 0;
            }
            else
            {
                DataCoolantTemp.u8Can_Valid = 1;
                if(Coolant_Temperature >= 2730)
                {
                    Coolant_Temperature -= 2730; 
                }
                else if(Coolant_Temperature <= 2430)
                {
                    Coolant_Temperature =0; 
                    DataCoolantTemp.u8Can_Valid = 0; 
                }
                else
                {
                    Coolant_Temperature =0; 
                }
                DataCoolantTemp.u16Can_Actual = Coolant_Temperature;
            }
        }
    }
    else
    {
        DataCoolantTemp.u8Can_Valid = 0;
        DataCoolantTemp.u16Can_Actual = 0;  
    }
    //Res
    if(ADC_Read_Signal_Valid(ADC_CH_COOLANT_TEMP1_R) == 0)
    {
        DataCoolantTemp.u8Res_ADValid = 0;
        DataResCoolantTempSampler.Cnt = 0;
        DataCoolantTemp.u16Res_ADValue = 65535;
        DataCoolantTemp.u8Res_Flashtimer = 0;
    }
    else
    {
        DataCoolantTemp.u8Res_Flashtimer ++;
        if(DataCoolantTemp.u8Res_Flashtimer >= 5)
        {
            DataCoolantTemp.u8Res_Flashtimer = 5;
            if(DataCoolantTemp.u8Res_ADValid == 0)
            {
                DataCoolantTemp.u16Res_ADValue = ADC_Read_Signal(ADC_CH_COOLANT_TEMP1_R);
                DataCoolantTemp.u8Res_ADValid = 1;
            }
            else
            {
                DataResCoolantTempSampler.Buffer[DataResCoolantTempSampler.Cnt] = ADC_Read_Signal(ADC_CH_COOLANT_TEMP1_R);
                i = DataResCoolantTempSampler.Cnt;
                while ((i > 0) && (DataResCoolantTempSampler.Buffer[i] < DataResCoolantTempSampler.Buffer[i - 1]))
                {
                    Temp = DataResCoolantTempSampler.Buffer[i];
                    DataResCoolantTempSampler.Buffer[i] = DataResCoolantTempSampler.Buffer[i - 1];
                    DataResCoolantTempSampler.Buffer[i - 1] = Temp;
                    i--;
                }

                DataResCoolantTempSampler.Cnt++;
                if (DataResCoolantTempSampler.Cnt >= 5)
                {
                    DataResCoolantTempSampler.Cnt = 0;
                    Temp = (DataResCoolantTempSampler.Buffer[1]+DataResCoolantTempSampler.Buffer[2]+DataResCoolantTempSampler.Buffer[3])/3;
                     DataCoolantTemp.u16Res_ADValue = (uint16_t)(Temp);
                } 
            } 
        }
    }
    
    if((ADC_Read_Signal_Valid(ADC_CH_COOLANT_TEMP1_R) == 0)||(DataCoolantTemp.u8Res_Flashtimer < 5))
    {
        DataCoolantTemp.u8Res_Valid = 0 ;  
        DataCoolantTemp.u16Res_Actual = 0; 
        DataResCoolantTempSampler.ResOpen_ActTimer = 10;  
        DataResCoolantTempSampler.ResOpen_InActTimer = 25;  
    }
    else
    {
        if((DataCoolantTemp.u8Res_ADValid)&&(DataCoolantTemp.u16Res_ADValue >= 3000))
        {            
            if(DataResCoolantTempSampler.ResOpen_ActTimer < 10) 
            {
                DataResCoolantTempSampler.ResOpen_ActTimer++;   
            }  
            else
            {
                DataCoolantTemp.u8Res_Valid = 0 ;  
                DataCoolantTemp.u16Res_Actual = 0 ; 
                DataResCoolantTempSampler.ResOpen_InActTimer = 0;  
            }   
        }
        else
        {  
            if(DataResCoolantTempSampler.ResOpen_InActTimer < 5)
            {
                DataResCoolantTempSampler.ResOpen_InActTimer++;
            }
            else
            {
                DataCoolantTemp.u8Res_Valid = 1 ; 
                DataResCoolantTempSampler.ResOpen_ActTimer = 0;
                if(DataCoolantTemp.u16Res_ADValue < 3000)
                {
                    DataCoolantTemp.u16Res_Actual = Get_Coolant_Res_To_Temp(DataCoolantTemp.u16Res_ADValue);
                }    
            }  
        }  
    }
    if (DataCoolantTemp.u8Can_Valid ==1)
    {
        DataCoolantTemp.Temp_Value = DataCoolantTemp.u16Can_Actual;
    }
    else if( DataCoolantTemp.u8Res_Valid ==1)
    {
        DataCoolantTemp.Temp_Value = DataCoolantTemp.u16Res_Actual;
    }
    else
    {
        DataCoolantTemp.Temp_Value = 0;
    }
    
    TEMP_Gauges_Cal();
    time_power_on++;
    if(time_power_on >= 100)//上电延时获取数据
    {
        time_power_on = 100;

        if(DataCoolantTemp.u8Can_Valid||DataCoolantTemp.u8Res_Valid)
        {
            time_lost = 0;
            if(DataCoolantTemp.TEMPMode == 3)//掉线
            {
                TEMP_SPEED = FAST_TIME;
            }
            else if(DataCoolantTemp.TEMPMode == 0)//自检
            {
                DataCoolantTemp_Dis.u8_CurSeg = DataCoolantTemp.TEMPSetp;
            }
            if(DataCoolantTemp.TEMPMode == 3)
            {
                DataCoolantTemp.TEMP_Fastime = 100;
            }
            DataCoolantTemp.TEMPMode = 1; 
        }
        else 
        {
            time_lost++;
            if(time_lost >= Disconnected_TIME)
            {
                time_lost = Disconnected_TIME;
                if(DataCoolantTemp.TEMPMode != 3)
                {
                    DataCoolantTemp.TEMPMode = 3;
                    TEMP_SPEED =  NORMAL_TIME;
                }
                DataCoolantTemp.TEMPSetp = 0;
            }
        }
    }

    time_temp ++;
		
    if(DataCoolantTemp.TEMP_Fastime>0)
    {
        DataCoolantTemp.TEMP_Fastime--;
    }
    if(DataCoolantTemp.TEMP_Fastime==0)
    {
        if(DataCoolantTemp.TEMPSetp == DataCoolantTemp_Dis.u8_CurSeg)
        {
            TEMP_SPEED = NORMAL_TIME;
            time_temp = 0;
        }

   }

    if(time_temp>=TEMP_SPEED)
    {
        time_temp = 0;
        if(DataCoolantTemp.TEMPSetp > DataCoolantTemp_Dis.u8_CurSeg)
        {
            DataCoolantTemp_Dis.u8_CurSeg++;
        }
        else if(DataCoolantTemp.TEMPSetp < DataCoolantTemp_Dis.u8_CurSeg)
        {
            DataCoolantTemp_Dis.u8_CurSeg--;
        }
    }        
}
//硬线数据
uint16_t Get_Coolant_Res_To_Temp(uint16_t Temp_Res)
{
    uint16_t TempValue = 0;

     TempValue = Get_Res_To_Temp(Coolant_Res, Coolant_Temp, Coolant_LEN, Temp_Res) ;   

    return TempValue*10;
}


void TEMP_Gauges_Cal(void)//计算目标格数
{

    DataCoolantTemp.TEMPSetp = 0;
    HYS_Physical_Quantity_Input(HYS_TEMP, DataCoolantTemp.Temp_Value);
    DataCoolantTemp.TEMPSetp =  HYS_Get_Seg(HYS_TEMP);
    if(DataCoolantTemp.TEMPSetp > 9 )
    {
        DataCoolantTemp.TEMPSetp = 0;
    }
    DataCoolantTemp.TEMPSetp = DataCoolantTemp.TEMPSetp - 1;
}

uint16_t Get_Res_To_Temp(uint16_t *ResBoard, uint16_t *TempBoard, uint8_t Len, uint16_t input)
{
	uint8_t i = 0;
	uint16_t ret = 0;
	uint32_t temp = 0;
	if(input >= ResBoard[0])
	{
		ret = TempBoard[0];
	}
	else if(input <= ResBoard[Len - 1])
	{
		ret = TempBoard[Len - 1];
	}
	else
	{
        for(i = 0; i < (Len - 1); i++)
		{
			if((input < ResBoard[i]) && (input >= ResBoard[i + 1]))
			{
				temp = TempBoard[i + 1] - TempBoard[i];
				temp *= (ResBoard[i] - input);
				temp /= (ResBoard[i] - ResBoard[i + 1]);
				temp += TempBoard[i];
				ret = (uint16_t)temp;
				break;
			}
		}
	}

	return ret;
}

void Common_SelfCheckTime_Init(void)
{
    u8SelfCheckTime = 0;
	u8SelfCheckTime_Finish = 0;
}

void Common_SelfCheckTime(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if (u8SelfCheckTime < SelfCheckTime)
        {
            u8SelfCheckTime++;
			u8SelfCheckTime_Finish = 0;
        }
        else
        {
            u8SelfCheckTime = SelfCheckTime;
			u8SelfCheckTime_Finish = 1;
        }
    }
    else
    {
        u8SelfCheckTime = SelfCheckTime;
		u8SelfCheckTime_Finish = 1;
    }
}


uint8_t GET_DataCoolantTempSegDisp(void)
{
   return DataCoolantTemp_Dis.u8_CurSeg;
}

uint16_t GET_DataCollantTempSegValid(void) 
{
   return DataCoolantTemp.u16Res_ADValue;//DataCoolantTemp_Dis.Dis_Valid;
}
