#include "stddef.h"
#include "BAT32A279.h"
#include "core_cm0plus.h"
#include "intp.h"
#include "gpio.h"
#include "isr.h"
#include "intp.h"
#include <stdlib.h>
#include "RTE_GPIO.h"


// GPIO_Port_t RTE_GPIO_Port_Get(uint16_t u16PortIndex);
void EXTI0_IRQHandler(void *msg);
void EXTI1_IRQHandler(void *msg);
void EXTI2_IRQHandler(void *msg);
void EXTI3_IRQHandler(void *msg);
void EXTI4_IRQHandler(void *msg);
void EXTI5_IRQHandler(void *msg);
void EXTI6_IRQHandler(void *msg);
void EXTI7_IRQHandler(void *msg);
void EXTI8_IRQHandler(void *msg);
void EXTI9_IRQHandler(void *msg);
void EXTI10_IRQHandler(void *msg);
void EXTI11_IRQHandler(void *msg);
void EXTI17_IRQHandler(void *msg);

typedef enum {
INTP0_Channel = 0x0001,
INTP1_Channel = 0x0002,
INTP2_Channel = 0x0004,
INTP3_Channel = 0x0008,
INTP4_Channel = 0x0010,
INTP5_Channel = 0x0020,
INTP6_Channel = 0x0040,
INTP7_Channel = 0x0080,
INTP8_Channel = 0x0100,
INTP9_Channel = 0x0200,
INTP10_Channel= 0x0400,
INTP11_Channel= 0x0800,
	
}INTP_Select_Channel_t;

typedef struct
{
    uint16_t                                u16Pin;          //引脚列表
    GPIO_Source_t                           PinSource; 
	GROUP_AF_t                         		u16AFt;          //引脚中断模式对应的复用功�???
	IRQn_Type                           	IRQType;         //中断类型
    INTP_Select_Channel_t                     INTP_Channel;        //�ж�ͨ��ѡ��
	void                                    *Handler;        //中断函数指针  

}RTE_GPIO_INTP_Table_st_t;

const RTE_GPIO_INTP_Table_st_t INTP_Table[] = 
{
    {RTE_GPIO_PORT00_PIN00,     GPIO_P00,      GROUP_AF_INTP8,       INTP8_IRQn,     INTP8_Channel,   (void *)EXTI8_IRQHandler},
	{RTE_GPIO_PORT00_PIN01,     GPIO_P01,      GROUP_AF_INTP10,      INTP10_IRQn,    INTP10_Channel,  (void *)EXTI10_IRQHandler},
	{RTE_GPIO_PORT00_PIN05,     GPIO_P05,      GROUP_AF_INTP10,      INTP10_IRQn,    INTP10_Channel,  (void *)EXTI10_IRQHandler},
	{RTE_GPIO_PORT00_PIN06,     GPIO_P06,      GROUP_AF_INTP11,      INTP11_IRQn,    INTP11_Channel,  (void *)EXTI11_IRQHandler},	
	{RTE_GPIO_PORT01_PIN02,     GPIO_P12,      GROUP_AF_INTP5,       INTP5_IRQn,     INTP5_Channel,   (void *)EXTI5_IRQHandler},
	{RTE_GPIO_PORT01_PIN06,     GPIO_P16,      GROUP_AF_INTP5,       INTP5_IRQn,     INTP5_Channel,   (void *)EXTI5_IRQHandler},
	{RTE_GPIO_PORT02_PIN00,     GPIO_P20,      GROUP_AF_INTP11,      INTP11_IRQn,    INTP11_Channel,  (void *)EXTI11_IRQHandler},
	{RTE_GPIO_PORT03_PIN00,     GPIO_P30,      GROUP_AF_INTP3,       INTP3_IRQn,     INTP3_Channel,   (void *)EXTI3_IRQHandler},
	{RTE_GPIO_PORT03_PIN01,     GPIO_P31,      GROUP_AF_INTP4,       INTP4_IRQn,     INTP4_Channel,   (void *)EXTI4_IRQHandler},
	{RTE_GPIO_PORT04_PIN02,     GPIO_P42,      GROUP_AF_INTP8,       INTP8_IRQn,     INTP8_Channel,   (void *)EXTI8_IRQHandler},
	{RTE_GPIO_PORT04_PIN03,     GPIO_P43,      GROUP_AF_INTP9,       INTP9_IRQn,     INTP9_Channel,   (void *)EXTI9_IRQHandler},
	{RTE_GPIO_PORT05_PIN00,     GPIO_P50,      GROUP_AF_INTP1,       INTP1_IRQn,     INTP1_Channel,   (void *)EXTI1_IRQHandler},
	{RTE_GPIO_PORT05_PIN01,     GPIO_P51,      GROUP_AF_INTP2,       INTP2_IRQn,     INTP2_Channel,   (void *)EXTI2_IRQHandler},
	{RTE_GPIO_PORT05_PIN02,     GPIO_P52,      GROUP_AF_INTP1,       INTP1_IRQn,     INTP1_Channel,   (void *)EXTI1_IRQHandler},
	{RTE_GPIO_PORT05_PIN03,     GPIO_P53,      GROUP_AF_INTP2,       INTP2_IRQn,     INTP2_Channel,   (void *)EXTI2_IRQHandler},
	{RTE_GPIO_PORT05_PIN04,     GPIO_P54,      GROUP_AF_INTP3,       INTP3_IRQn,     INTP3_Channel,   (void *)EXTI3_IRQHandler},
	{RTE_GPIO_PORT05_PIN05,     GPIO_P55,      GROUP_AF_INTP4,       INTP4_IRQn,     INTP4_Channel,   (void *)EXTI4_IRQHandler},	
	{RTE_GPIO_PORT07_PIN04,     GPIO_P74,      GROUP_AF_INTP8,       INTP8_IRQn,     INTP8_Channel,   (void *)EXTI8_IRQHandler},
	{RTE_GPIO_PORT07_PIN05,     GPIO_P75,      GROUP_AF_INTP9,       INTP9_IRQn,     INTP9_Channel,   (void *)EXTI9_IRQHandler},
	{RTE_GPIO_PORT07_PIN06,     GPIO_P76,      GROUP_AF_INTP10,      INTP10_IRQn,    INTP10_Channel,  (void *)EXTI10_IRQHandler},
	{RTE_GPIO_PORT07_PIN07,     GPIO_P77,      GROUP_AF_INTP11,      INTP11_IRQn,    INTP11_Channel,  (void *)EXTI11_IRQHandler},
	{RTE_GPIO_PORT13_PIN06,  	GPIO_P136,     GROUP_AF_ODEFAULT,    INTP0_IRQn,     INTP0_Channel,   (void *)EXTI0_IRQHandler},   
	{RTE_GPIO_PORT14_PIN06,     GPIO_P146,     GROUP_AF_INTP4,       INTP4_IRQn,     INTP4_Channel,   (void *)EXTI4_IRQHandler},
    {RTE_GPIO_PORT00_PIN00,     GPIO_P00,      GROUP_AF_ODEFAULT,    TM00_IRQn,      INTP4_Channel,   (void *)EXTI17_IRQHandler},
};


typedef enum
{
    GPIO_Mode_AIN         = 0x0,
    GPIO_Mode_IN_FLOATING = 0x04,
    GPIO_Mode_IPD         = 0x28,
    GPIO_Mode_IPU         = 0x48,
    GPIO_Mode_Out_OD      = 0x14,
    GPIO_Mode_Out_PP      = 0x10,
    GPIO_Mode_AF_OD       = 0x1C,
    GPIO_Mode_AF_PP       = 0x18
} GPIO_ModeType;

RTE_GPIO_IRQ_Desc_st_t *g_pstRTEGPIOIRQDesc[RTE_GPIO_IRQ_MAX] = 
{
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, 
};

/**
 * @brief 初始化GPIO的工作条�???
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_Init();
 @endcode
 *
 * @since 1.0.0
 */
void RTE_GPIO_Init(void)
{
    uint32_t i;

    /* 禁用所有GPIO中断 */

    INTC_DisableIRQ(INTP0_IRQn);
    INTC_DisableIRQ(INTP1_IRQn);
    INTC_DisableIRQ(INTP2_IRQn);
    INTC_DisableIRQ(INTP3_IRQn);
    INTC_DisableIRQ(INTP4_IRQn);
    INTC_DisableIRQ(INTP5_IRQn);
    INTC_DisableIRQ(INTP6_IRQn);
	INTC_DisableIRQ(INTP7_IRQn);
    INTC_DisableIRQ(INTP8_IRQn);
    INTC_DisableIRQ(INTP9_IRQn);
    INTC_DisableIRQ(INTP10_IRQn);
	INTC_DisableIRQ(INTP11_IRQn);

    /* 清除所有GPIO中断回调函数 */
    for (i = 0UL; i < RTE_GPIO_IRQ_MAX; i++)
    {
        g_pstRTEGPIOIRQDesc[i] = NULL;
    }
}

/**
 * @brief 复位GPIO至默认状�???
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_DeInit();
 @endcode
 *
 * @since 1.0.0
 */
void RTE_GPIO_DeInit(void)
{
    uint32_t i;
    
    /* 禁用所有GPIO中断 */
    
    INTC_DisableIRQ(INTP0_IRQn);
    INTC_DisableIRQ(INTP1_IRQn);
    INTC_DisableIRQ(INTP2_IRQn);
    INTC_DisableIRQ(INTP3_IRQn);
    INTC_DisableIRQ(INTP4_IRQn);
    INTC_DisableIRQ(INTP5_IRQn);
    INTC_DisableIRQ(INTP6_IRQn);
		INTC_DisableIRQ(INTP7_IRQn);
    INTC_DisableIRQ(INTP8_IRQn);
    INTC_DisableIRQ(INTP9_IRQn);
    INTC_DisableIRQ(INTP10_IRQn);
		INTC_DisableIRQ(INTP11_IRQn);

    /* 清除所有GPIO中断回调函数 */
    for (i = 0UL; i < RTE_GPIO_IRQ_MAX; i++)
    {
        g_pstRTEGPIOIRQDesc[i] = NULL;
    }
}

/**
 * @brief 使端口工作在设定的GPIO模式�???
 * @param[in] u16Pin 端口编号
 * @param[in] u8Mode GPIO工作模式
 * @return 设置结果, 0为设置成�???, -1为设置失�???
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_Config(RTE_GPIO_PORTxx_PINyy, RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_HIGH);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Config(uint16_t u16Pin, uint8_t u8Mode)
{
    int32_t  i32Result;
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    
//    GPIO_Module *pPort;
    GPIO_InitTypeDef stInit;

    i32Result = -1;
    u16PinIndex  = u16Pin & 0x00FFU;
    u16PortIndex = (u16Pin >> 8) & 0x00FFU;
    if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
    {		
        stInit.GPIO_Pin = 1U << u16PinIndex;

        if ((u8Mode & RTE_GPIO_DIR_MASK) == RTE_GPIO_DIR_IN)
        {
            stInit.GPIO_Mode = GPIO_Mode_IN;  //IN
			if ((u8Mode & RTE_GPIO_PULL_MASK) == RTE_GPIO_PULL_UP)
            {
                stInit.GPIO_PuPd =(GPIOPuPd_TypeDef) RTE_GPIO_PULL_UP;
            }
            else if ((u8Mode & RTE_GPIO_PULL_MASK) == RTE_GPIO_PULL_DOWN)
            {
                stInit.GPIO_PuPd =(GPIOPuPd_TypeDef) RTE_GPIO_PULL_DOWN;
            }
            else
            {
                stInit.GPIO_PuPd =(GPIOPuPd_TypeDef) 0U;
            }

            GPIO_Init((GPIO_Port_t)u16PortIndex, &stInit);
        }
        else
        {
            stInit.GPIO_Mode = GPIO_Mode_OUT;  //OUT
			if ((u8Mode & RTE_GPIO_SPEED_MASK) == RTE_GPIO_SPEED_0)
            {
//                /* stInit.GPIO_Speed = GPIO_Speed_50MHz; */
            }
            else if ((u8Mode & RTE_GPIO_SPEED_MASK) == RTE_GPIO_SPEED_1)
            {
//                stInit.GPIO_Speed = GPIO_Speed_10MHz;
            }
            else
            {
//                stInit.GPIO_Speed = GPIO_Speed_2MHz;
            }

            if ((u8Mode & RTE_GPIO_OUTPUT_TYPE_MASK) == RTE_GPIO_OUTPUT_PP)
            {
                stInit.GPIO_OType = GPIO_OType_PP;  //PP
            }
            else
            {
                stInit.GPIO_OType = GPIO_OType_OD;  //OD
            }
			
			if ((u8Mode & RTE_GPIO_LEVEL_MASK) == RTE_GPIO_LEVEL_LOW)
            {
                stInit.GPIO_Level = GPIO_Level_LOW;
            }
            else
            {
                stInit.GPIO_Level = GPIO_Level_HIGH;
            }

            GPIO_Init((GPIO_Port_t)u16PortIndex, &stInit);
        }

        i32Result = 0;
    }
    
    return i32Result;
}

/**
 * @brief GPIO端口批量初始�???
 * @param[in] pstGPIOPinList 指向GPIO端口配置列表的指�???
 * @param[in] u32Num 列表中的GPIO端口数量
 * @return  设置结果, 0为设置成�???, -1为设置失�???
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_Bulk_Config(&stGPIOPinList, (sizeof(stGPIOPinList) / sizeof(RTE_GPIO_Config_st_t)));
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Bulk_Config(RTE_GPIO_Config_st_t *pstGPIOPinList, uint32_t u32Num)    
{
    uint32_t i;
    uint16_t u16Pin;
    uint8_t  u8Mode;
    int32_t  i32Result;
    
    i32Result = -1;
    if ((pstGPIOPinList != NULL) && (u32Num != 0))
    {
        for(i = 0UL; i < u32Num; i++)
        {
            u16Pin = pstGPIOPinList[i].u16PinNum;
            u8Mode = (uint8_t)(pstGPIOPinList[i].u16PinMode & 0x00FFU);
            RTE_GPIO_Config(u16Pin, u8Mode);
        }

        i32Result = 0;
    }
    
    return i32Result;
}

/**
 * @brief 设置指定的端口的输出电平
 * @param[in] u16Pin 端口编号
 * @param[in] u8Level 输出电平,0为低电平,1为高电平
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_Set_Level(RTE_GPIO_PORTxx_PINyy, 0U);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Set_Level(uint16_t u16Pin, uint8_t u8Level)
{
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    int32_t  i32Result;
	
    i32Result = -1;
    u16PinIndex  = u16Pin & 0x00FFU;
    u16PortIndex = (u16Pin >> 8) & 0x00FFU;
    if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
	{

    u16PinIndex = 1 << u16PinIndex;
		if(u8Level==0)
		{GPIO_ResetBits((GPIO_Port_t)u16PortIndex, u16PinIndex);}
		else
		{GPIO_SetBits((GPIO_Port_t)u16PortIndex, u16PinIndex);}

		i32Result = 0;
	}
	return i32Result;
}

/**
 * @brief 读取设置指定的端口的输入电平
 * @param[in] u16Pin 端口编号
 * @return  端口输入电平,0为低电平,1为高电平
 * @warning None
 *
 * 示例
 @code
    uint8_t u8Level = RTE_GPIO_Get_Level(RTE_GPIO_PORTxx_PINyy);
 @endcode
 *
 * @since 1.0.0
 */
uint8_t RTE_GPIO_Get_Level(uint16_t u16Pin)
{
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    uint8_t  u8Level;
	
    u16PinIndex  = u16Pin & 0x00FFU;
    u16PortIndex = (u16Pin >> 8) & 0x00FFU;
    u8Level = 0U;
    if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
	{
		u16PinIndex = 1U << u16PinIndex;
		
		if(((*((volatile uint8_t*)(&PORT->P0 +u16PortIndex))) & u16PinIndex) != Bit_RESET)
		{
			u8Level = (uint8_t)Bit_SET;
		}
		else
		{
			u8Level = (uint8_t)Bit_RESET;
		}	
	}
	return u8Level;
}

/**
 * @brief 设置指定的一组端口的输出电平
 * @param[in] u8Port 端口组编�???
 * @param[in] u32Value 整组端口的输出电�???
 * @warning None
 *
 * 示例
 @code
    RTE_GPIO_Set_Port(RTE_GPIO_PORT_GROUP_x, 0xAABBCCDDUL);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Set_Port(uint8_t u8Port, uint32_t u32Value)
{
    int32_t  i32Result;

    i32Result = -1;
    if (u8Port < RTE_GPIO_PORT_MAX)
	{
		*((volatile uint8_t*)(&PORT->P0 +u8Port)) = (uint8_t)u32Value;
        i32Result = 0;
    }
    return i32Result;
}

/**
 * @brief 读取设置指定的一组端口的输入电平
 * @param[in] u8Port 端口组编�???
 * @return  整组端口输入电平
 * @warning None
 *
 * 示例
 @code
    uint32_t u32Value = RTE_GPIO_Get_Port(RTE_GPIO_PORT_GROUP_x);
 @endcode
 *
 * @since 1.0.0
 */
uint32_t RTE_GPIO_Get_Port(uint8_t u8Port)
{
    uint32_t u32Value;

    u32Value = 0UL;
    if (u8Port < RTE_GPIO_PORT_MAX)
		{	
		u32Value = *(&PORT->P0 + u8Port);	
    }
    return u32Value;
}

/**
 * @brief 将指定端口中断方式注册到中断描述�???,所有的中断操作都是基于中断描述符的
 * @param[in] pstIRQDesc 中断描述�???
 * @param[in] u16Pin 端口编号
 * @param[in] enType 中断类型(上升沿中�???,下降沿中�???...)
 * @param[in] pfnHandler 中断回调函数,不需要中断回调函数时可以填NULL
 * @return 注册结果,0为注册成功，-1为注册失�??? 
 * @warning 1.禁止直接改写中断描述符中的数�???,更改中断描述符必须通过此函�??? \
            2.已使能的中断的描述符不可更改,如需更改应先禁止这一中断 \
            3.受单片机特性限�???,并非所有的中断类型都会被支�???,不支持的中断类型将返回注册失�???
 *
 * 示例
 @code
    int32_t i32Result = RTE_GPIO_Interrupt_Register(&IRQDesc, RTE_GPIO_PORT_GROUP_x, RTE_GPIO_INT_FALLING_EDGE, NULL);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Interrupt_Register(RTE_GPIO_IRQ_Desc_st_t *pstIRQDesc,
                                    uint16_t u16Pin, 
                                    RTE_GPIO_Interrupt_Type_en_t enType,
                                    RTE_GPIO_Int_Handler_Func_ptr_t pfnHandler)
{
    uint32_t i;
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    uint32_t u32Available;
    int32_t  i32Result;
    Trigger_TypeDef enEXTIType;
    
    i32Result = -1;
    if (pstIRQDesc != NULL)
    {
        u16PinIndex  = u16Pin & 0x00FFU;
        u16PortIndex = (u16Pin >> 8) & 0x00FFU;
        if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
        {
            /* 确定是否支持用户请求的中断类�??? */
            if (enType == RTE_GPIO_INT_FALLING_EDGE)
            {
                enEXTIType = Trigger_Falling;
                i32Result  = 0;
            }
            else if (enType == RTE_GPIO_INT_RISING_EDGE)
            {
                enEXTIType = Trigger_Rising;
                i32Result  = 0;
            }
            else if (enType == RTE_GPIO_INT_DUAL_EDGE)
            {
                enEXTIType = Trigger_Rising_Falling;
                i32Result  = 0;
            }
            else
            {

            }

            if (i32Result == 0)
            {
                /* 确定用户请求的中断描述符没有被其他中断占�??? */
                i = 0UL;
                u32Available = 1UL;
                while ((i < 12UL) && (u32Available != 0UL))
                {
                    if (pstIRQDesc == g_pstRTEGPIOIRQDesc[i])
                    {
                        u32Available = 0UL;
                    }
                    i++;
                }
                
                if (u32Available)
                {
                    /* 用户请求有效,将中断参数注册到当前描述�??? */
                    pstIRQDesc->u16Pin    = u16Pin;
                    pstIRQDesc->u16Type   = (uint16_t)enEXTIType;
                    pstIRQDesc->i32Flag   = 0;
                    pstIRQDesc->pvHandler = (void *)pfnHandler;
                }
                else
                {
                    i32Result = -1;
                }
            }
        }
    }

    return i32Result;
}

/**
 * @brief 使能中断
 * @param[in] pstIRQDesc 中断描述�???
 * @return 中断使能结果,0为中断成功使能，-1为中断使能失败，需检查描述符是否正确注册 
 * @warning None
 *
 * 示例
 @code
    int32_t i32Result = RTE_GPIO_Interrupt_Enable(&IRQDesc);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Interrupt_Enable(RTE_GPIO_IRQ_Desc_st_t *pstIRQDesc)
{
    int32_t  i32Result;
	uint8_t  u8Index;
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    INTP_InitTypeDef stEXTICfg;
    
    i32Result = -1;
    u8Index = 0;
    if (pstIRQDesc != NULL)
    {
        u16PinIndex  = pstIRQDesc->u16Pin & 0x00FFU;
        u16PortIndex = (pstIRQDesc->u16Pin >> 8) & 0x00FFU;
        if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
        {
            if (g_pstRTEGPIOIRQDesc[u16PinIndex] == NULL)    /* 这一路中断是未被使能�??? */
            {
                for (uint8_t i = 0; i < 23U; i++)
                {
                    if(INTP_Table[i].u16Pin == pstIRQDesc->u16Pin)
                    {
                        u8Index = i;
                        break;
                    }
                }
				GPIO_PinAFConfig((GPIO_Port_t)u16PortIndex, 1 << u16PinIndex, INTP_Table[u8Index].PinSource, INTP_Table[u8Index].u16AFt); 
				
				INTP_Stop(INTP_Table[u8Index].INTP_Channel);                      /* 修改前先确保中断是已禁用状�? */
				
				stEXTICfg.INTP_Select    = INTP_Table[u8Index].INTP_Channel;
                stEXTICfg.EXTI_Trigger = pstIRQDesc->u16Type;

                pstIRQDesc->i32Flag = 0;
                g_pstRTEGPIOIRQDesc[u16PinIndex] = pstIRQDesc;
                    
                INTP_Init(&stEXTICfg);

				ISR_Register(INTP_Table[u8Index].IRQType, INTP_Table[u8Index].Handler);   /* 中断服务注册路径*/

				INTP_Start(INTP_Table[u8Index].INTP_Channel);     /* Enable INTP Interrupt */

//                ISR_DisRegister(INTP_Table[u8Index].IRQType, INTP_Table[u8Index].Handler);

                i32Result = 0;
            }
        }
    }

    return i32Result;
}

/**
 * @brief 禁止中断
 * @param[in] pstIRQDesc 中断描述�???
 * @return 中断禁止结果,0为中断成功禁止，-1为中断禁止失败，需检查描述符是否正确注册 
 * @warning None
 *
 * 示例
 @code
    int32_t i32Result = RTE_GPIO_Interrupt_Disable(&IRQDesc);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Interrupt_Disable(RTE_GPIO_IRQ_Desc_st_t *pstIRQDesc)
{
    int32_t  i32Result;
    uint16_t u16PortIndex;
    uint16_t u16PinIndex;
    INTP_InitTypeDef stEXTICfg;

    i32Result = -1;
    if (pstIRQDesc != NULL)
    {
        u16PinIndex  = pstIRQDesc->u16Pin & 0x00FFU;
        u16PortIndex = (pstIRQDesc->u16Pin >> 8) & 0x00FFU;
        if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
        {
            if (g_pstRTEGPIOIRQDesc[u16PinIndex] == pstIRQDesc)    /* 与当前已使能的中断的描述符相�??? */
            {
                stEXTICfg.INTP_Select    = 0x0000UL;
                stEXTICfg.EXTI_Trigger   = Trigger_None;
				
				INTP_Init(&stEXTICfg);				/* 禁止这一路中�??? */
                INTP_Stop(u16PinIndex);             /* 清除中断标志 */
         
                g_pstRTEGPIOIRQDesc[u16PinIndex] = NULL;
                
                i32Result = 0;
            }
        }
    }
    
    return i32Result;
}

/**
 * @brief 获取中断标志
 * @param[in] pstIRQDesc 中断描述符
 * @return 中断标志,0为无中断, 1为中断已发生, -1为获取中断标志失败, 需检查描述符是否正确注册 
 * @warning 1.使用形如if(RTE_GPIO_Get_Interrupt_Flag(&IRQDesc))的方式判断中断是否发生时需注意 \
              如果描述符未正确注册, 函数将返回-1, 也会被判定为真 \
            2.获取中断标志后并不会清除中断标志, 如需清除应调用RTE_GPIO_Clear_Interrupt_Flag函数
 *
 * 示例
 @code
    int32_t i32Flag = RTE_GPIO_Get_Interrupt_Flag(&IRQDesc);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Get_Interrupt_Flag(RTE_GPIO_IRQ_Desc_st_t *pstIRQDesc)
{
    int32_t  i32Result;

    i32Result = -1;
    if (pstIRQDesc != NULL)
    {
        i32Result = pstIRQDesc->i32Flag;
    }

    return i32Result;
}

/**
 * @brief 清除中断标志
 * @param[in] pstIRQDesc 中断描述�???
 * @return 中断标志清除结果, 0为中断标志成功清除，-1为中断标志清除失败，需检查描述符是否正确注册 
 * @warning None
 *
 * 示例
 @code
    int32_t i32Result = RTE_GPIO_Clear_Interrupt_Flag(&IRQDesc);
 @endcode
 *
 * @since 1.0.0
 */
int32_t RTE_GPIO_Clear_Interrupt_Flag(RTE_GPIO_IRQ_Desc_st_t *pstIRQDesc)
{
    int32_t  i32Result;

    i32Result = -1;
    if (pstIRQDesc != NULL)
    {
        pstIRQDesc->i32Flag = 0;
        i32Result = 0;
    }

    return i32Result;
}

/**
 * @brief 外部中断0中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI0_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP0_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[0];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断1中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI1_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP1_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[1];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断2中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI2_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP2_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[2];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断3中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI3_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP3_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[3];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断4中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI4_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP4_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断5中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI5_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP5_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断6中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI6_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP6_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断7中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI7_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP7_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断8中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI8_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP8_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断9中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI9_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP9_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断10中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI10_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP10_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}

/**
 * @brief 外部中断11中断服务
 * @warning None
 * @since 1.0.0
 */
void EXTI11_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(INTP11_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}


void EXTI17_IRQHandler(void *msg)
{
    uint8_t u8Level;
    RTE_GPIO_IRQ_Desc_st_t         *pstDesc;
    RTE_GPIO_Int_Handler_Func_ptr_t pfnIRQHandler;

    /* 清除中断标志 */
    INTC_ClearPendingIRQ(TM00_IRQn);

    /* 读取中断发生时端口的电平并执行回调函�??? */
    pstDesc = g_pstRTEGPIOIRQDesc[4];
    if (pstDesc != NULL)
    {
        u8Level = RTE_GPIO_Get_Level(pstDesc->u16Pin);
        pstDesc->i32Flag = 1;
        if (pstDesc->pvHandler != NULL)
        {
            pfnIRQHandler = (RTE_GPIO_Int_Handler_Func_ptr_t)(pstDesc->pvHandler);
            pfnIRQHandler(pstDesc->u16Pin, u8Level);
        }
    }
}


// GPIO_Port_t RTE_GPIO_Port_Get(uint16_t u16PortIndex)
// {
//     GPIO_Port_t  enGPIO_Port;
//     switch (u16PortIndex)
//     {
//         case 0U:
//             enGPIO_Port = GPIO_PORT0;
//             break;
//         case 1U:
//             enGPIO_Port = GPIO_PORT1;
//             break;
//         case 2U:
//             enGPIO_Port = GPIO_PORT2;
//             break;
//         case 3U:
//             enGPIO_Port = GPIO_PORT3;
//             break;
//         case 4U:
//             enGPIO_Port = GPIO_PORT4;
//             break;
//         case 5U:
//             enGPIO_Port = GPIO_PORT5;
//             break;
//         case 6U:
//             enGPIO_Port = GPIO_PORT6;
//             break;
//         case 7U:
//             enGPIO_Port = GPIO_PORT7;
//             break;
//         #if defined BAT32A2X9_100PIN
//         case 8U:
//             enGPIO_Port = GPIO_PORT8;	
//             break;
//         #endif
//         #if defined BAT32A2X9_80PIN || defined BAT32A2X9_100PIN
//         case 10U:
//             enGPIO_Port =  GPIO_PORT10;
//         break;
//         case 11U:
//             enGPIO_Port =  GPIO_PORT11;
//         break;   
//         case 15U: 
//             enGPIO_Port =  GPIO_PORT15;
//         break;    
//         #endif	    
//         case 12U:
//             enGPIO_Port = GPIO_PORT12;
//             break;   
//         case 13U:
//             enGPIO_Port = GPIO_PORT13;
//             break; 
//         case 14U:
//             enGPIO_Port = GPIO_PORT14;
//             break;                
//         default:
//             break;
//     }
// 		return enGPIO_Port;
// }
