#include "Data_Coolant.h"
#include "Components.h"



#define Coolant_DATA_TIME 25u /*这里填写多长时间采集一个数据，单位ms*/
#define Coolant_DATA_NUM 20u  /*燃油电阻采集数据总数 最大255*/
#define Coolant_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define Coolant_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/

#define RETURN_DIFFERENCE 25u /*判断上升或下降的回差，精度0.1*/

#define Coolant_SEG_UP 0u
#define Coolant_SEG_DOWN 1u

uint16_t g_u16CoolantData[Coolant_DATA_NUM];
uint8_t g_u8CoolantDataCount = 0u;

uint16_t CoolantR = 0u; /*滤波后的燃油电阻，精度0.1*/
static uint16_t CoolantRBak = 0;

uint8_t g_u8DesCoolantSetp = 0u;
uint8_t g_u8CurCoolantSetp = 0u;
uint8_t g_u8CoolantInitFlag = 0u;
uint8_t g_u8CoolantStateInitFlag = 0u;
uint8_t g_u8CoolantDir = Coolant_SEG_UP;
CoolantSensorSts_t CoolantSensorState = CoolantSensorNormal;
uint16_t g_u16CoolantSensorNormalTime = 0u;
uint16_t g_u16CoolantSensorShortTime = 0u;
uint16_t g_u16CoolantSensorOpenTime = 0u;
uint8_t g_u8CoolantADCompleteFlg = 0u;

void Coolant_KL30_Init(void)
{
    g_u8DesCoolantSetp = 0u;
    g_u8CurCoolantSetp = 0u;
    g_u8CoolantInitFlag = 1u;
    g_u8CoolantStateInitFlag = 1u;
    g_u8CoolantDir = Coolant_SEG_UP;
    CoolantSensorState = CoolantSensorNormal;
    g_u16CoolantSensorNormalTime = 0u;
    g_u16CoolantSensorShortTime = 0u;
    g_u16CoolantSensorOpenTime = 0u;
    g_u8CoolantADCompleteFlg = 0u;
}

void Coolant_KL15_Init(void)
{
    g_u8DesCoolantSetp = 0u;
    g_u8CurCoolantSetp = 0u;
    g_u8CoolantInitFlag = 1u;
    g_u8CoolantStateInitFlag = 1u;
    g_u8CoolantDir = Coolant_SEG_UP;
    CoolantSensorState = CoolantSensorNormal;
    g_u16CoolantSensorNormalTime = 0u;
    g_u16CoolantSensorShortTime = 0u;
    g_u16CoolantSensorOpenTime = 0u;
    g_u8CoolantADCompleteFlg = 0u;
}

void Coolant_R_Cal(uint8_t deltaTime)
{
    uint16_t CoolantRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;

    if(g_u8CoolantStateInitFlag)
    {
        // CoolantR = ADC_Read_Signal(ADC_CH_Coolant1);
    }

    if (timeCount >= Coolant_DATA_TIME)
    {
        timeCount = 0;
        if (g_u8CoolantDataCount < Coolant_DATA_NUM)
        {
            /*获取燃油电阻*/
            // CoolantRes = ADC_Read_Signal(ADC_CH_Coolant1);

            /*四舍五入*/
            if (CoolantRes < 3100)
            {
                if (CoolantRes % 10 >= 5)
                {
                    CoolantRes += 5;
                }
            }
            else
            {
                CoolantRes = 0xFFFF;
            }
            /*由小到大插入数据*/
            for (i = 0; i < g_u8CoolantDataCount; i++)
            {
                if (CoolantRes < g_u16CoolantData[i])
                {
                    break;
                }
            }
            for (j = g_u8CoolantDataCount; j > i; j--)
            {
                g_u16CoolantData[j] = g_u16CoolantData[j - 1];
            }
            g_u16CoolantData[i] = CoolantRes;
            g_u8CoolantDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = Coolant_CAL_START; i < Coolant_CAL_END; i++)
            {
                temp32 += g_u16CoolantData[i];
            }
            CoolantR = temp32 / (Coolant_CAL_END - Coolant_CAL_START);
            g_u8CoolantDataCount = 0;
            g_u8CoolantADCompleteFlg = 1;
        }
    }
    timeCount += deltaTime;
}

void Coolant_State_Check(uint8_t deltaTime)
{
    if (CoolantR < 30)
    { /*短路3*/
        g_u16CoolantSensorOpenTime = 0;
        g_u16CoolantSensorNormalTime = 0;
        if ((g_u16CoolantSensorShortTime > 3000) || ((g_u8CoolantStateInitFlag) && (g_u16CoolantSensorShortTime > 3000)))
        {
            CoolantSensorState = CoolantSensorShortCircuit;
            g_u8DesCoolantSetp = 0;
            g_u8CurCoolantSetp = 6;
            g_u8CoolantStateInitFlag = 0;
            g_u8CoolantInitFlag = 1;
            g_u8CoolantDir = Coolant_SEG_UP;
        }
        else
        {
            g_u16CoolantSensorShortTime += deltaTime;
        }
    }
    else if (CoolantR > 3100)
    { /*开路 310*/
        g_u16CoolantSensorShortTime = 0;
        g_u16CoolantSensorNormalTime = 0;
        if ((g_u16CoolantSensorOpenTime > 3000) || ((g_u8CoolantStateInitFlag) && (g_u16CoolantSensorOpenTime > 3000)))
        {
            CoolantSensorState = CoolantSensorOpenCircuit;
            g_u8DesCoolantSetp = 0;
            g_u8CurCoolantSetp = 0;
            g_u8CoolantStateInitFlag = 0;
            g_u8CoolantInitFlag = 1;
            g_u8CoolantDir = Coolant_SEG_UP;
        }
        else
        {
            g_u16CoolantSensorOpenTime += deltaTime;
        }
    }
    else
    {
        g_u16CoolantSensorShortTime = 0;
        g_u16CoolantSensorOpenTime = 0;
        if (g_u16CoolantSensorNormalTime > 3000)
        {
            CoolantSensorState = CoolantSensorNormal;
            g_u8CoolantStateInitFlag = 0;
        }
        else
        {
            g_u16CoolantSensorNormalTime += deltaTime;
        }
    }
}

void Coolant_Gauges_Cal(uint8_t deltaTime)
{
    static uint16_t time = 0;

    if ((CoolantSensorState == CoolantSensorNormal) && (CoolantR <= 3100) && (CoolantR >= 30))
    { 
        /*采集完第一组数据后，开始计算燃油格数*/
        if (g_u8CoolantADCompleteFlg)
        {
            if (g_u8CoolantInitFlag)
            {
                CoolantRBak = CoolantR;
            }

            /*根据回差计算走动方向*/
            if (g_u8CoolantDir == Coolant_SEG_UP)
            {
                if (CoolantR >= CoolantRBak + RETURN_DIFFERENCE)
                {
                    g_u8CoolantDir = Coolant_SEG_DOWN;
                    CoolantRBak = CoolantR;
                }
                if (CoolantR < CoolantRBak)
                {
                    CoolantRBak = CoolantR;
                }
            }
            else
            {
                if (CoolantRBak >= CoolantR + RETURN_DIFFERENCE)
                {
                    g_u8CoolantDir = Coolant_SEG_UP;
                    CoolantRBak = CoolantR;
                }
                if (CoolantR > CoolantRBak)
                {
                    CoolantRBak = CoolantR;
                }
            }

            /*计算目标格数*/
            if (g_u8CoolantDir == Coolant_SEG_UP)
            {
                if (((g_u8DesCoolantSetp == 5) || g_u8CoolantInitFlag) && (CoolantR < 30))
                {
                    g_u8DesCoolantSetp = 6;
                }
                else if (((g_u8DesCoolantSetp == 4) || g_u8CoolantInitFlag) && (CoolantR < 160))
                {
                    g_u8DesCoolantSetp = 5;
                }
                else if (((g_u8DesCoolantSetp == 3) || g_u8CoolantInitFlag) && (CoolantR < 300))
                {
                    g_u8DesCoolantSetp = 4;
                }
                else if (((g_u8DesCoolantSetp == 2) || g_u8CoolantInitFlag) && (CoolantR < 500))
                {
                    g_u8DesCoolantSetp = 3;
                }
                else if (((g_u8DesCoolantSetp == 1) || g_u8CoolantInitFlag) && (CoolantR < 790))
                {
                    g_u8DesCoolantSetp = 2;
                }
                else if (((g_u8DesCoolantSetp == 0) || g_u8CoolantInitFlag) && (CoolantR <= 3100))
                {
                    g_u8DesCoolantSetp = 1;
                }
            }
            else if (g_u8CoolantDir == Coolant_SEG_DOWN)
            {
                if (((g_u8DesCoolantSetp == 1) || g_u8CoolantInitFlag) && (CoolantR > 3100))
                {
                    g_u8DesCoolantSetp = 0;
                }
                else if (((g_u8DesCoolantSetp == 2) || g_u8CoolantInitFlag) && (CoolantR >= 790))
                {
                    g_u8DesCoolantSetp = 1;
                }
                else if (((g_u8DesCoolantSetp == 3) || g_u8CoolantInitFlag) && (CoolantR >= 500))
                {
                    g_u8DesCoolantSetp = 2;
                }
                else if (((g_u8DesCoolantSetp == 4) || g_u8CoolantInitFlag) && (CoolantR >= 300))
                {
                    g_u8DesCoolantSetp = 3;
                }
                else if (((g_u8DesCoolantSetp == 5) || g_u8CoolantInitFlag) && (CoolantR >= 160))
                {
                    g_u8DesCoolantSetp = 4;
                }
                else if (((g_u8DesCoolantSetp == 6) || g_u8CoolantInitFlag) && (CoolantR >= 30))
                {
                    g_u8DesCoolantSetp = 5;
                }
            }
        }

        /*IGN ON 1秒/故障恢复后，开始走格  立即指向当前格 20220704*/
        if (Common_GetIgnOnTime() >= 3000)
        {
            time += deltaTime;
            if (g_u8CoolantInitFlag)
            {
                g_u8CoolantInitFlag = 0;
                time = 0;
                g_u8CurCoolantSetp = g_u8DesCoolantSetp;
            }

            if (time >= 15000)
            { /* 15S变化一格 */
                time = 0;
                if (g_u8CurCoolantSetp < g_u8DesCoolantSetp)
                {
                    g_u8CurCoolantSetp++;
                }
                else if (g_u8CurCoolantSetp > g_u8DesCoolantSetp)
                {
                    g_u8CurCoolantSetp--;
                }
            }
            
            if (g_u8CurCoolantSetp == g_u8DesCoolantSetp)
            {
                time = 0;
            }
        }
    }
}

void Coolant_Cal_Sevice(uint8_t deltaTime)
{
    /*检测燃油电阻状态*/
    Coolant_State_Check(deltaTime);

    /*显示燃油格*/
    Coolant_Gauges_Cal(deltaTime);
}

uint8_t Get_CurCoolantSetp(void)
{
    uint8_t u8CurCoolantSetp = g_u8CurCoolantSetp;
    if(CoolantSensorState == CoolantSensorOpenCircuit)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurCoolantSetp = 6;
        }
        else
        {
            u8CurCoolantSetp = 0;
        }
    }
    else if(CoolantSensorState == CoolantSensorShortCircuit)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurCoolantSetp = 7;
        }
        else
        {
            u8CurCoolantSetp = 0;
        }
    }
    else if(u8CurCoolantSetp == 1)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurCoolantSetp = 1;
        }
        else
        {
            u8CurCoolantSetp = 0;
        }
    }
    else
    {
        ;
    }
    return u8CurCoolantSetp;
}

CoolantSensorSts_t Get_Coolant_Sensor_State(void)
{
    uint8_t u8CurCoolantSetp = 0;
    if(CoolantSensorState == CoolantSensorOpenCircuit || g_u8CurCoolantSetp == 1u)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurCoolantSetp = 2;
        }
        else
        {
            u8CurCoolantSetp = 0;
        }
    }
    else
    {
        u8CurCoolantSetp = 1u;
    }
    return u8CurCoolantSetp;
}

