#ifndef KEY_USER_H__
#define KEY_USER_H__

#include "Key\Key.h"
#include "common.h"
#include "rtc.h"

typedef struct  __attribute__((aligned(4)))
{
   uint16_t  Back_Time_Left;
   uint16_t  Back_Time_Right;
   uint8_t   Back_Time_Right_Flag;
   uint8_t   Back_Time_Left_Flag;
   uint16_t  Tpms_F_Learning_Time;
   uint16_t  Tpms_R_Learning_Time;
   uint16_t  Tpms_F_Learn_Succeed_Flag;
   uint16_t  Tpms_R_Learn_Succeed_Flag;
   uint8_t   BackLight_Val;
   uint8_t   BackLightMode;
   uint8_t   Unit;
}_Menu_Infor;

typedef enum
{
    BackLight_Val_1 = 1,
    BackLight_Val_2,
    BackLight_Val_3,
    BackLight_Val_4,
    BackLight_Val_5,
    BackLight_Val_A,
}_BackLight_Val_Type;

typedef struct __attribute__((aligned(4)))
{
   uint16_t  Back_Time_Left;
   uint16_t  Back_Time_Right;
   uint8_t   Back_Time_Right_Flag;
   uint8_t   Back_Time_Left_Flag;
   uint8_t   Dis_Hour_Tenb;
   uint8_t   Dis_Hour_Bit;
   uint8_t   Dis_Minute_Tenb;
   uint8_t   Dis_Minute_Bit;
   uint8_t   Unit;
   uint8_t   Language;
   uint8_t   OdoAndTrip;
   uint8_t   Bluetooth_Open_Close;
   uint8_t   Clock_Flash;
   uint8_t   u8Dis_Hour;
   uint8_t   u8Dis_Minute;
}_Menu_Data;

extern uint8_t OTA_Update_Flag;
extern uint8_t ClearODO_Flag;
extern uint8_t g_u8Cursor_Posittion;
extern RTC_CounterTypeDef counter_val;
extern void Key_KL30_Init_EXample(void);
extern void Key_Wakeup_Init_EXample(void);

void Key_Operation_Right(Key_Event_en_t enKeyEvent);
void Key_Operation_Left(Key_Event_en_t enKeyEvent);
Key_Status_en_t Key_Status_Read_Left(void);
Key_Status_en_t Key_Status_Read_Right(void);
void Key_Event_Short_Press_Left(void);
void Key_Event_Short_Press_Right(void);
void Key_Event_LONG_PRESS_1_Right(void);
void Key_Event_BackLight_Press_Left(void);
void Get_Into_OTA_Update_Mode(void);
void KEY_RIGHT_EVENT_NONE_Service(void);
void KEY_LEFT_EVENT_NONE_Service(void);
void Key_Auto_Save(void);
uint8_t Get_Dis_Hour_Time(void);
uint8_t Get_Dis_Minute_Time(void);
void TYW_RESET_ODO(void);
uint8_t Get_Dis_Unit(void);
void Key_TimeOut_Service(void);
void Key_Clear_Time(void);
uint8_t Get_Dis_OdoAndTrip(void);
uint8_t Get_Dis_Bluetooth_Open_Close(void);
uint8_t Get_Dis_Language(void);
void Get_DisTime_Service(void);

extern void My_Key_Service(void);



#endif
