
#include "MCU_Core_Protocol.h"
#include "Components.h"
typedef struct __attribute__((aligned(4)))
{
    uint8_t  SOC_St; /*系统启动状态  0启动中 1启动成功 2启动超时*/
    uint8_t  AnimStatus;
    uint32_t Time_out;
    uint8_t  Restart;
} Core_Monitor_t;

typedef struct __attribute__((aligned(4)))
{
    uint8_t u8POPEn;
    uint8_t u8BlueToothEn;
    uint8_t u8Logo;    
    uint8_t u8Car;    
    uint8_t u8SingleLane;    
}CoreDispCtrl_st_t;

CoreDispCtrl_st_t g_stCoreDispCtrl;


volatile uint8_t g_u8SOC_Online = 0U;
uint32_t g_u32SOC_Online_Time = 0U;
uint8_t g_u8Soc_Request_Valid = 0U;
static uint16_t  SocStartupCnt = 0u;
static Core_Monitor_t Core_Monitor;
static Rec_ID_12_Struct RecID12;
Rec_0x012_un_t g_unRec_0x012;
static void Core_Poweroff_Service(void);
uint8_t g_u8AvgSpeedOFFValid = 0U;

uint8_t SOC_Online_Status_Get(void)
{
    return g_unRec_0x012.Sig.u8Resv3;
}
uint8_t SOC_Online_Valid(void)
{
    return g_u8Soc_Request_Valid;
}
void MCU_SOC_Commnuication(void)
{
    Protocol_Service( );

    if ( Core_Monitor.SOC_St == Soc_Startup )
    {
        Core_Monitor.Time_out++;
        if ( Core_Monitor.Time_out > CORE_Timeout_CNT )
        {
            Core_Monitor.SOC_St = Soc_Timeout;
            //Protocol_Send(0x50, Protocol_NULL, 0);
        }
    }
    else
    {
        Core_Monitor.Time_out = 0u;
    }
#if 1
//***************************************************************************************
//************************12心跳报文掉线监控和重启***************************************
//***************************************************************************************
    if (SOC_Online_Status_Get() == 1U)
    {       
        g_u32SOC_Online_Time = 0U; 
        g_u8Soc_Request_Valid = 1u;     
    }
    
    if (g_u8Soc_Request_Valid == 1U)
    {
        g_u32SOC_Online_Time = 0U;
        if (SOC_Online_Status_Get() == 2U)
        {
            g_u8Soc_Request_Valid = 0U; 
        }
    }
        

    

//心跳超时计时器     
    if (g_u32SOC_Online_Time < 0xFFFFFFFFul)
    {
        if(g_u8SOC_Online == 0U)//无核心板12数据
        {
            g_u32SOC_Online_Time++;//(scale 20ms)++
        }
        else
        {
            g_u32SOC_Online_Time = 0U;
        }
        g_u8SOC_Online = 0U;
    }
    
/*重启*/
    if(g_u32SOC_Online_Time > 500ul)//500*20=10000ms
    {
        //当12报文超时10s时给SOC断电3s 之后重新启动核心板
        if((g_u32SOC_Online_Time >= 500ul) && ( g_u32SOC_Online_Time < 504ul))
        {
            // GPIO_OUT_PORT08_PIN09 = 0; //SOC EN
        }
        else if((g_u32SOC_Online_Time >= 504ul) && ( g_u32SOC_Online_Time < 654ul))
        {
            // GPIO_OUT_APORT00_PIN07 = 1;//SOC5V下电
        } 
        else
        {       
            // GPIO_OUT_APORT00_PIN07 = 0U;//SOC5V供电
            // GPIO_OUT_PORT08_PIN09  = 1U;/* 使能核心板 */     
            g_u32SOC_Online_Time = 0u; //重置
        }               
    }   
    else
    {
        
    }
#endif
}

void Core_Startup_Handle(uint8_t status)
{
    if ( status == 1 )
    {
        // Core_Monitor.SOC_St = Soc_Run;
        Core_Monitor.SOC_St = Soc_Startup;
        SocStartupCnt = 0U;
        //Protocol_Send(MCU_SOC_PROTOCOL_ID, Protocol_NULL, 0);
    }
    else
    {
        Core_Monitor.SOC_St = Soc_Startup;
    }
}

void Core_Heart_Handle(const uint8_t *pData, uint8_t len)
{
    uint8_t i = 0;
    if ( SocStartupCnt >= 95 )
    {
        Core_Monitor.SOC_St = Soc_Run;
    }
    else
    {
        SocStartupCnt++;
    }
    if (len == 2)
    {            
        g_u8SOC_Online = 1U;    
        for ( i = 0; i < len; i++ )
        {
            g_unRec_0x012.u8Msg [ i ] = pData [ i ];            
        }
    }
    
}

uint8_t Get_Core_StartStatus(void)
{
    return Core_Monitor.SOC_St;
}
uint32_t g_u32CoreDelayCnt;
uint8_t g_u8IGN_OFF_DispState;
uint8_t g_u8IGN_OFF_DelayCnt;
void Core_WinData_Service(void)
{/*Task 20ms */
    if ( Get_Core_StartStatus( ) )//bug 21467 休眠唤醒后先显示待机界面，再显示报警
    {
        Core_Poweroff_Service();
    }
}

static void Core_Poweroff_Service(void)
{
    uint32_t i;

    /* 系统刚上电 或 刚从休眠唤醒的瞬间 什么事情都不需要做 */

    Protoco_Display_Info_un_t unDisplayInfo;
    for (uint8_t i = 0;i<20;i++)
    {
        unDisplayInfo.u8Msg[i] = 0U;
    }  
    unDisplayInfo.u8Speed          = 0u; /**< 显示车速 */
    unDisplayInfo.u8ESpeedH        = 0u; /**< 转速高字节 */
    unDisplayInfo.u8ESpeedColore   = 0u; /**< 转速显示颜色 */
    unDisplayInfo.u8SpeedUnit      = 0u; /**< 车速单位 */
    unDisplayInfo.u8ESpeedL        = 0u; /**< 转速低字节 */
    unDisplayInfo.u8CoolantSeg     = 0u; /**< 水温段 */
    unDisplayInfo.u8CoolantSegSign = 0u; /**< 水温段开短路标志 */
    unDisplayInfo.u8FuelSeg        = 0u; /**< 燃油段 */
    unDisplayInfo.u8FuelSegSign    = 0u; /**< 燃油段开短路标志 */
    unDisplayInfo.u8Resv1          = 0u; /**< 占位 */
    unDisplayInfo.u8Resv2          = 0u; /**< 占位 */
    unDisplayInfo.u8MileageH       = 0u; /**< TOTAL里程高4位 */ 
    unDisplayInfo.u8MileageUnit    = 0u; /**< 里程单位 */ 
    unDisplayInfo.u8MileageMode    = 0u; /**< 里程显示 */ 
    unDisplayInfo.u8MileageC       = 0u; /**< TOTAL里程中8位 */ 
    unDisplayInfo.u8MileageL       = 0u; /**< TOTAL里程低8位 */ 
    unDisplayInfo.u8TripAH         = 0u; /**< 小计里程A高字节 */ 
    unDisplayInfo.u8TripAL         = 0u; /**< 小计里程A低字节 */ 
    unDisplayInfo.u8TripBH         = 0u; /**< 小计里程B高字节 */ 
    unDisplayInfo.u8TripBL         = 0u; /**< 小计里程B低字节 */ 
    unDisplayInfo.u8PhoneH         = 0u; /**< 来电号码高字节 */ 
    unDisplayInfo.u8PhoneC         = 0u; /**< 来电号码中字节 */ 
    unDisplayInfo.u8EasyNavigation = 0u; /**< 简易导航是否显示 */ 
    unDisplayInfo.u8BlueDisplay    = 0u; /**< 蓝牙电话控制显示 */ 
    unDisplayInfo.u8PhoneL         = 0u; /**< 来电号码低字节 */ 
    unDisplayInfo.u8TimeFormat     = 0u; /**< 时间制式 */ 
    unDisplayInfo.u8TimeAM_PM      = 0u; /**< AM/PM */ 
    unDisplayInfo.u8Colon          = 0u; /**<  “:”亮灭 */
    unDisplayInfo.u8Hour           = 0u; /**<  小时数字 */
    unDisplayInfo.u8Minute         = 0u; /**<  分钟数字 */
    if ( Core_Monitor.SOC_St > Soc_Startup )
    {
        Protocol_Send(WIN_DATA_PROTOCOL_ID, unDisplayInfo.u8Msg, sizeof(unDisplayInfo.u8Msg));
    }
    TPMS_Display_Info_un_t unTPMSDisplayInfo;
    for (uint8_t i = 0;i<8;i++)
    {
        unTPMSDisplayInfo.u8Msg[i] = 0U;
    }  
    unTPMSDisplayInfo.u8TPMSDisplay  = 0u;
    unTPMSDisplayInfo.u8PressUnit    = 0u;
    unTPMSDisplayInfo.u8PressPopup   = 0u;
    unTPMSDisplayInfo.u8PressureFH   = 0u;
    unTPMSDisplayInfo.u8PressureFL   = 0u;
    unTPMSDisplayInfo.u8PressureRH   = 0u;
    unTPMSDisplayInfo.u8PressureRL   = 0u;
    unTPMSDisplayInfo.u8TemperatureF = 0u;
    unTPMSDisplayInfo.u8TemperatureR = 0u;
    if ( Core_Monitor.SOC_St > Soc_Startup )
    {
        Protocol_Send(TPMS_PROTOCOL_ID, unDisplayInfo.u8Msg, sizeof(unDisplayInfo.u8Msg));
    }
}

void Core_TelltalesData_Service(void)
{
    Protoco_Telltales_un_t unTelltaleInfo;

    for (uint8_t i = 0;i<30;i++)
    {
        unTelltaleInfo.u8Msg[i] = 0U;
    }  

    unTelltaleInfo.stSig.u8Interface     = 0u;/**< 显示界面 */
    unTelltaleInfo.stSig.u8SelfCheck     = 0u;/**< 自检 (0-自检开始 1-自检结束) */
    unTelltaleInfo.stSig.u8Language      = 0u;/**< 语言 (0-中文 1-英文) */
    unTelltaleInfo.stSig.u8Theme         = 0u;/**< 主题 */
    unTelltaleInfo.stSig.u8ThemeColour  = 0u;/**< 手机互联模式 */

    unTelltaleInfo.stSig.u8LowFuel       = 0u;/**< 燃油低指示灯 */
    unTelltaleInfo.stSig.u8ABS           = 0u;/**< ABS/HBB故障 */
    unTelltaleInfo.stSig.u8SmartLock     = 0u;/**< 智能锁指示灯 */
    unTelltaleInfo.stSig.u8EfiFault      = 0u;/**< 电喷故障指示灯 */
    unTelltaleInfo.stSig.u8HiBeam        = 0u;/**< 远光灯 */
    unTelltaleInfo.stSig.u8Position      = 0u;/**< 位置灯 */
    unTelltaleInfo.stSig.u8Right         = 0u;/**< 右转灯 */
    unTelltaleInfo.stSig.u8Left          = 0u;/**< 左转灯 */

    unTelltaleInfo.stSig.u8AutoStartStop = 0u;/**< 自动启停 */
    unTelltaleInfo.stSig.u8LowPower      = 0u;/**< 电池电压低报警灯 */
    unTelltaleInfo.stSig.u8TCS           = 0u;/**< TCS指示灯 */
    unTelltaleInfo.stSig.u8TPMS          = 0u;/**< 胎压报警灯 */    
    unTelltaleInfo.stSig.u8BlueTooth     = 0u;/**< 蓝牙显示*/
    unTelltaleInfo.stSig.u8Gears         = 0u;/**< 1~6挡位指示灯*/
    unTelltaleInfo.stSig.u8NeutralLight  = 0u;/**< 空挡指示灯*/
    unTelltaleInfo.stSig.u8HiTemp        = 0u;/**< 水温指示灯 */

    unTelltaleInfo.stSig.u8SentryKey     = 0u;/**< 钥匙防盗 */
    unTelltaleInfo.stSig.u8WIFI          = 0u;/**< WIFI */
    
    unTelltaleInfo.stSig.u8BlueControl   = 0u;/**<  蓝牙控制 */
    unTelltaleInfo.stSig.u8ZoneB_B       = 0u;/**<  指示灯B区位置B预留 */
    unTelltaleInfo.stSig.u8ZoneB_C       = 0u;/**<  指示灯B区位置C预留 */

    unTelltaleInfo.stMenu.u8MenuStair    = 0u;/**<  一级菜单光标位置 */
    unTelltaleInfo.stMenu.u8MenuGrade    = 0u;/**<  菜单级别 */
    switch (unTelltaleInfo.stMenu.u8MenuStair)
    {
        case 1: /* 主题模式 */
            unTelltaleInfo.stMenu.stSubject_Mode.u8Subject = 0u;
            unTelltaleInfo.stMenu.stSubject_Mode.u8Mode    = 0u;
            break;
        case 2: /* 单位设置 */
            unTelltaleInfo.stMenu.stUnits_Setup.u8UnitsSetup = 0u;
            break;
        case 3: /* 时钟信息 */
            unTelltaleInfo.stMenu.stClock.u8Clock      = 0u; 
            unTelltaleInfo.stMenu.stClock.u8TimeAM_PM  = 0u;
            unTelltaleInfo.stMenu.stClock.u8TimeFormat = 0u;
            unTelltaleInfo.stMenu.stClock.u8Hour       = 0u;
            unTelltaleInfo.stMenu.stClock.u8Minute     = 0u;
            unTelltaleInfo.stMenu.stClock.u8Colon      = 0u;
            break;
        case 4: /* 亮度设置 */
            unTelltaleInfo.stMenu.stBacklight_Class.u8Backlight = 0u;
            break;
        case 5: /* 胎压学习 */
            unTelltaleInfo.stMenu.stTPMS_Study.u8TPMSPosition     = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8TPMSUnit         = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8FrontStudyStatus = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8BackStudyStatus  = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8FrontHPressure   = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8FrontLPressure   = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8BackHPressure    = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8BackLPressure    = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8SensorHID        = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8SensorHCID       = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8SensorLCID       = 0u;
            unTelltaleInfo.stMenu.stTPMS_Study.u8SensorLID        = 0u;
            break;
        case 6: /* 语言设置 */
            unTelltaleInfo.stMenu.stLanguage.u8Language = 0u;
            break;
        case 7: /* 蓝牙设置 */
            unTelltaleInfo.stMenu.stBlue_Tooth.u8Option   = 0u;
            unTelltaleInfo.stMenu.stBlue_Tooth.u8Link     = 0u;
            unTelltaleInfo.stMenu.stBlue_Tooth.u8LinkName = 0u;
            break;
        case 8: /* DVR */
            unTelltaleInfo.stMenu.stDVR.u8DVRSetTowLevel   = 0u; 
            unTelltaleInfo.stMenu.stDVR.u8DVRSetThreeLevel = 0u;
            unTelltaleInfo.stMenu.stDVR.u8DVRSet           = 0u;   
            unTelltaleInfo.stMenu.stDVR.u8DVRSetStatus     = 0u;       
            unTelltaleInfo.stMenu.stDVR.u8DVRSetFourLevel  = 0u;
            break;
        case 9: /* 版本信息 */
            unTelltaleInfo.stMenu.stVersion.u8Version         = 0u;    
            unTelltaleInfo.stMenu.stVersion.u8SoftYearH       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftYearL       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftMonth       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftDay         = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftVDisplay    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftVersionH    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftDotHDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftVersionC    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftDotCDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8SoftVersionL    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardYearH       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardYearL       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardMonth       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardDay         = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardVDisplay    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardVersionH    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardDotHDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardVersionC    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardDotCDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8HardVersionL    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueYearH       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueYearL       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueMonth       = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueDay         = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueVDisplay    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueVersionH    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueDotHDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueVersionC    = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueDotCDisplay = 0u;
            unTelltaleInfo.stMenu.stVersion.u8BlueVersionL    = 0u;
            break;
        case 10: /* 恢复出厂设置 */
            unTelltaleInfo.stMenu.stFactory_Reset.u8Factory_Reset = 0u;
            break;
        case 11: /* 手机互联 */
            unTelltaleInfo.stMenu.stQR_Code.u8Code = 0u;
            break;
        default:
            break;
    }

    if ( Core_Monitor.SOC_St > Soc_Startup )
    {
        Protocol_Send(TEL_DATA_PROTOCOL_ID, unTelltaleInfo.u8Msg, sizeof(unTelltaleInfo.u8Msg));
    }
    
}

uint8_t Get_Animation_Status(void)
{
    return g_unRec_0x012.Sig.u8AnimStatus;
}





// typedef struct
// {
//     uint8_t u8PwrStatus;
//     uint8_t u8DispSN;
//     uint8_t u8FullNavi;
//     uint8_t u8FirstFullNavi;
//     uint8_t u8TBTNavi;
//     uint32_t u32SendCnt;
//     uint8_t u8BlueFaceEn;

//     uint8_t u8BlueToothValid;
//     uint32_t u32BT_Timer;
//     uint8_t  RollingCounterF2Back;
//     uint16_t u16F2_TimeoutCnt;
    
//     uint8_t  u8MusicValid;
//     uint32_t u32Music_Timer;

//     uint8_t  u8RadioValid;
//     uint32_t u32Radio_Timer;
// }WinLeftCtrl_st_t;


// WinLeftCtrl_st_t g_stWinLeftCtrl;


// typedef struct
// {
//     uint8_t MediaPage;  
//     uint8_t BTSubFunc_CallRecrod;
//     uint8_t NaviSubFunc_ServZone;
//     uint8_t NaviSubFunc_LaneNum;
//     uint8_t u8Music[100U];
//     uint8_t u8Radio[8U];
//     uint8_t u8BlueTooth[102U];
//     uint8_t u8TBTNavi[102U];
// }WinLeftInfo_st_t;

// WinLeftInfo_st_t g_stWinLeftInfo;

// #define WIN_LEFT_DISP_SN_NONE         (0x00U)
// #define WIN_LEFT_DISP_SN_MUSIC        (0x01U)
// #define WIN_LEFT_DISP_SN_RADIO        (0x02U)
// #define WIN_LEFT_DISP_SN_NAVI         (0x03U)
// #define WIN_LEFT_DISP_SN_BLUETOOTH    (0x04U)

// #define BULETOOTH_SUB_ID_INCOMMING   (0x01U)  /*来电信息 */
// #define BULETOOTH_SUB_ID_CALL_INFO   (0x02U)  /*通话信息,时间 */
// #define BULETOOTH_SUB_ID_CALL_RECORD (0x03U)  /*通话记录 */

// #define NAVI_SUB_ID_PLAN         (0x01U)
// #define NAVI_SUB_ID_SERVICE_ZONE (0x02U)
// #define NAVI_SUB_ID_LANE_NUM     (0x03U)

// #define DisplayHintTime         2000u/10u
// #define SEND_TO_CORE_SUBCYCLE   4U
// #define SEND_TO_CORE_CYCLE      108U/2U


// void BuleTooth_Incomming_Valid_Set(uint8_t u8Valid);
// void BuleTooth_CallInfo_Valid_Set(uint8_t u8Valid);
// void BuleTooth_CallRecord_Valid_Set(uint8_t u8Valid);
// void BuleTooth_SubInfo_Set(uint8_t u8Data);

// void Navi_SubInfo_Set(uint8_t u8Data);
// void Navi_LaneNum_Valid_Set(uint8_t u8Valid);
// void Navi_ServiceZone_Valid_Set(uint8_t u8Valid);
// void Navi_Plan_Valid_Set(uint8_t u8Valid);

// void BuleTooth_Incomming_Valid_Set(uint8_t u8Valid)
// {/* BIT0 来电信息 */
//     if(u8Valid)
//     {
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xF0U;
//         g_stWinLeftInfo.u8BlueTooth[0U] |= 0x01U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xFEU;
//     }
// }
// void BuleTooth_CallInfo_Valid_Set(uint8_t u8Valid)
// {/* BIT1 通话信息 */
//     if(u8Valid)
//     {
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xF0U;
//         g_stWinLeftInfo.u8BlueTooth[0U] |= 0x02U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xFDU;
//     }
// }
// void BuleTooth_CallRecord_Valid_Set(uint8_t u8Valid)
// {/* BIT2 通话记录 */
//     if(u8Valid)
//     {        
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xF0U;
//         g_stWinLeftInfo.u8BlueTooth[0U] |= 0x04U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8BlueTooth[0U] &= 0xFBU;
//     }
// }

// void BuleTooth_SubInfo_Set(uint8_t u8Data)
// {/* BIT4 --- BIT7 */   

//     g_stWinLeftInfo.u8BlueTooth[0U] = 0x00U;
//     g_stWinLeftInfo.u8BlueTooth[0U] |= (1 << (u8Data - 1));
//     g_stWinLeftInfo.u8BlueTooth[0U] |= ((u8Data & 0x0F) << 4U);

// }

// void Navi_Plan_Valid_Set(uint8_t u8Valid)
// {/* BIT0  */
//     if(u8Valid)
//     {   
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xF0U;     
//         g_stWinLeftInfo.u8TBTNavi[0U] |= 0x01U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xFEU;
//     }
// }

// void Navi_ServiceZone_Valid_Set(uint8_t u8Valid)
// {/* BIT1  */
//     if(u8Valid)
//     {        
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xF0U;  
//         g_stWinLeftInfo.u8TBTNavi[0U] |= 0x02U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xFDU;
//     }
// }

// void Navi_LaneNum_Valid_Set(uint8_t u8Valid)
// {/* BIT2  */
//     if(u8Valid)
//     {        
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xF0U;  
//         g_stWinLeftInfo.u8TBTNavi[0U] |= 0x04U;
//     }
//     else
//     {
//         g_stWinLeftInfo.u8TBTNavi[0U] &= 0xFBU;
//     }
// }

// void Navi_SubInfo_Set(uint8_t u8Data)
// {/* BIT4 --- BIT7 */   
//     g_stWinLeftInfo.u8TBTNavi[0U] &= 0x0FU;
//     g_stWinLeftInfo.u8TBTNavi[0U] |= ((u8Data & 0x0F) << 4U);
// }
// uint8_t Navi_Menu_Status_Get(void);
// uint8_t Navi_Menu_Status_Get(void)
// {
//     uint8_t ret;
//     if (Menu_Item_Select_Get(MENU_ITEM_FullScreenNavi_Open))
//     {
//         ret = 1u;
//     }
//     else
//     {
//         ret = 0u;
//     }
//     return ret;
// }
// void Navi_Menu_Status_Set(uint8_t u8Data);
// void Navi_Menu_Status_Set(uint8_t u8Data)
// {
//     if (u8Data == 1u)
//     {
//         Menu_Set_Seclect_FullScreenNavi_Sw(MENU_ITEM_FullScreenNavi_Open);
//     }
//     else
//     {
//         Menu_Set_Seclect_FullScreenNavi_Sw(MENU_ITEM_FullScreenNavi_Close);
//     }
    
// }
// uint8_t Navi_FULL_Get(void)
// {
//     return g_stWinLeftCtrl.u8FullNavi;
// }
// void WinLeft_Data_Service(void)
// {/* Task 10ms */
//     uint8_t u8MMI_WorkMode;
//     uint16_t u16PopupMsg;
//     uint8_t u8PopupValid;
//     uint8_t u8KeyOKValid;
//     uint8_t u8NaviPathSuccCur;
//     uint8_t u8NaviMenuStatus;
//     uint8_t u8BluetoothStatus,CallStatus;
//     uint8_t MusicStatus = 0u;
//     uint8_t MusicRollingCounter = 0u;
//     uint32_t i = 0U;
//     uint8_t u8Length;
    
//     g_stWinLeftInfo.NaviSubFunc_LaneNum = 1u;
//     g_stWinLeftInfo.NaviSubFunc_ServZone = 0U;
//     g_stWinLeftInfo.BTSubFunc_CallRecrod = 0U;

//     if (Common_Get_IG_Sts() == COMMON_POWER_ON)
//     {
//         g_stWinLeftCtrl.u8PwrStatus = 1U;
        
//     } 
//     else
//     {
//         g_stWinLeftCtrl.u8PwrStatus = 0U;
//     }

//     if (g_stWinLeftCtrl.u8PwrStatus)
//     {
//         u8BluetoothStatus = get_F2_BluetoothConnectionStatus();
//         if(u8BluetoothStatus == 1u)
//         {            
                     
//             BuleTooth_Incomming_Valid_Set(1U);            
//             CallStatus = get_F2_CallStatus();            
//             if((CallStatus == 1u) || (CallStatus == 2u) || (CallStatus == 3u) || (CallStatus == 5u))
//             {
//                 g_stWinLeftCtrl.u32BT_Timer = 0u;
//                 g_stWinLeftCtrl.u32Music_Timer = 0u;              
//                 g_stWinLeftCtrl.u8BlueToothValid = 1U;
//                 g_stWinLeftCtrl.RollingCounterF2Back = 1u;  
//                 g_stWinLeftCtrl.u16F2_TimeoutCnt = 0;              
//             }
//             else
//             {
//                 g_stWinLeftCtrl.u16F2_TimeoutCnt = 0;
//                 Clr_F2_BluetoothConnectionStatus();
//                 g_stWinLeftCtrl.u8BlueToothValid = 0U;
//                 g_stWinLeftCtrl.RollingCounterF2Back = 0u;
//                 g_stWinLeftCtrl.u8BlueFaceEn = 0U;                
//             }

//             if (getRollingCounterF5() != 0u)
//             {
//                 BuleTooth_CallInfo_Valid_Set(1U);
//             }
//         }
//         else
//         {
//             g_stWinLeftCtrl.u8BlueToothValid = 0U;
//             BuleTooth_Incomming_Valid_Set(0U);
//             BuleTooth_CallInfo_Valid_Set(0U);
//             BuleTooth_CallRecord_Valid_Set(0U);  
//             g_stWinLeftCtrl.u16F2_TimeoutCnt = 0;        
//             g_stWinLeftCtrl.RollingCounterF2Back = 0;    
//             g_stWinLeftCtrl.u8BlueFaceEn = 0U;                
//         }
//     }
//     else
//     {
//         g_stWinLeftCtrl.u8BlueToothValid = 0U;             
//         g_stWinLeftCtrl.u16F2_TimeoutCnt = 0;        
//         g_stWinLeftCtrl.RollingCounterF2Back = 0; 
//         g_stWinLeftCtrl.u8BlueFaceEn = 0U;
//     }
// }


// void WinLeft_Disp_Service(void)
// {/* Task 2ms */
//     uint8_t u8Length = 0U;
//     if ((g_stWinLeftCtrl.u8PwrStatus == 1U) && (Get_HMI_Sys_Type() == DISP_RUN))
//     {/* IGN ON */
        
//         if (g_stWinLeftCtrl.u8BlueToothValid == 1U)
//         {
//             if (g_stWinLeftCtrl.u8DispSN != WIN_LEFT_DISP_SN_BLUETOOTH)
//             {
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//                 g_stWinLeftCtrl.u8DispSN = WIN_LEFT_DISP_SN_BLUETOOTH;            
//                 g_stWinLeftInfo.MediaPage = WIN_LEFT_DISP_SN_BLUETOOTH;           
                
//             }        
//         }
//         else if (g_stWinLeftCtrl.u8TBTNavi == 1U)
//         {
//             if (g_stWinLeftCtrl.u8DispSN != WIN_LEFT_DISP_SN_NAVI)
//             {
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//                 g_stWinLeftCtrl.u8DispSN = WIN_LEFT_DISP_SN_NAVI;
//                 g_stWinLeftInfo.MediaPage = WIN_LEFT_DISP_SN_NAVI;                
//             }        
//         }
//         else  if (g_stWinLeftCtrl.u8MusicValid == 1U)
//         {
//             if (g_stWinLeftCtrl.u8DispSN != WIN_LEFT_DISP_SN_MUSIC)
//             {
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//                 g_stWinLeftCtrl.u8DispSN = WIN_LEFT_DISP_SN_MUSIC;
//                 g_stWinLeftInfo.MediaPage = WIN_LEFT_DISP_SN_MUSIC;                
//             }
//         }
//         else if (g_stWinLeftCtrl.u8RadioValid == 1U)
//         {
//             if (g_stWinLeftCtrl.u8DispSN != WIN_LEFT_DISP_SN_RADIO)
//             {
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//                 g_stWinLeftCtrl.u8DispSN = WIN_LEFT_DISP_SN_RADIO;
//                 g_stWinLeftInfo.MediaPage = WIN_LEFT_DISP_SN_RADIO;                
//             }
//         }
//         else
//         {
//             if (g_stWinLeftCtrl.u8DispSN != WIN_LEFT_DISP_SN_NONE)
//             {
//                 g_stWinLeftCtrl.u8DispSN = WIN_LEFT_DISP_SN_NONE;
//                 g_stWinLeftInfo.MediaPage = WIN_LEFT_DISP_SN_NONE;
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//             }            
//         }
       

//         switch (g_stWinLeftCtrl.u8DispSN)
//         {
//             case WIN_LEFT_DISP_SN_BLUETOOTH:
//                 g_stWinLeftCtrl.u32SendCnt++;
//                 if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE + SEND_TO_CORE_SUBCYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {/*F2*/
//                     g_stWinLeftCtrl.u32SendCnt = 0U;
//                     g_stWinLeftCtrl.u8BlueFaceEn = 1U;
//                     BuleTooth_SubInfo_Set(BULETOOTH_SUB_ID_INCOMMING);                
//                     u8Length = getF2Data(&g_stWinLeftInfo.u8BlueTooth[2U]); 
//                     if (u8Length > 0U)
//                     {                   
//                         Protocol_Send(WIN_LEFT_BLUETOOTH_ID, &g_stWinLeftInfo.u8BlueTooth[0U], u8Length + 2);
//                     }
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE  + SEND_TO_CORE_SUBCYCLE)
//                 {/*F5*/
//                     BuleTooth_SubInfo_Set(BULETOOTH_SUB_ID_CALL_INFO); 
//                     u8Length = getF5Data(&g_stWinLeftInfo.u8BlueTooth[2U]); 
//                     if (u8Length > 0U)
//                     {
//                         Protocol_Send(WIN_LEFT_BLUETOOTH_ID, &g_stWinLeftInfo.u8BlueTooth[0U], u8Length + 2);
//                     }                   
//                 }         
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {/*F6*/      
//                     if (g_stWinLeftInfo.BTSubFunc_CallRecrod == 1U)
//                     {
//                         BuleTooth_SubInfo_Set(BULETOOTH_SUB_ID_CALL_RECORD); 
//                         u8Length = getF6Data(&g_stWinLeftInfo.u8BlueTooth[2U]); 
//                     }          
//                     else 
//                     {
//                         u8Length = 0U;
//                     }
//                     if (u8Length > 0U)
//                     {
//                         Protocol_Send(WIN_LEFT_BLUETOOTH_ID, &g_stWinLeftInfo.u8BlueTooth[0U], u8Length);
//                     }                   
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE)
//                 {
//                     Protocol_Send(WIN_LEFT_SWITCH_ID, &g_stWinLeftInfo.MediaPage, 1U);    
//                 }
//                 else
//                 {
//                     /*nothing*/
//                 }
//                 break;
//             case WIN_LEFT_DISP_SN_NAVI:
//                 g_stWinLeftCtrl.u32SendCnt++;
//                 if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE + SEND_TO_CORE_SUBCYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {/*F9*/
//                     g_stWinLeftCtrl.u32SendCnt = 0U;
//                     if (g_stWinLeftInfo.NaviSubFunc_ServZone == 1U)
//                     {
//                         Navi_SubInfo_Set(NAVI_SUB_ID_SERVICE_ZONE);                
//                         u8Length = getF9Data(&g_stWinLeftInfo.u8TBTNavi[2U]); 
//                     }
//                     else
//                     {
//                         u8Length = 0U;
//                     }
//                     if (u8Length > 0U)
//                     {                   
//                         Protocol_Send(WIN_LEFT_NAVI_ID, &g_stWinLeftInfo.u8TBTNavi[0U], u8Length);
//                     }
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {/*FB*/  
//                     if (g_stWinLeftInfo.NaviSubFunc_LaneNum == 1U)
//                     {
//                         Navi_SubInfo_Set(NAVI_SUB_ID_LANE_NUM);                
//                         u8Length = getFBData(&g_stWinLeftInfo.u8TBTNavi[2U]); 
//                     } 
//                     else
//                     {
//                         u8Length = 0U;
//                     }        
//                     if (u8Length > 0U)
//                     {                   
//                         Protocol_Send(WIN_LEFT_NAVI_ID, &g_stWinLeftInfo.u8TBTNavi[0U], u8Length);
//                     }
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {/*F3*/
//                     Navi_SubInfo_Set(NAVI_SUB_ID_PLAN); 
//                     u8Length = getF3Data(&g_stWinLeftInfo.u8TBTNavi[2U]); 
//                     if (u8Length > 0U)
//                     {
//                         Protocol_Send(WIN_LEFT_NAVI_ID, &g_stWinLeftInfo.u8TBTNavi[0U], u8Length);
//                     }                   
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE)
//                 {
//                     Protocol_Send(WIN_LEFT_SWITCH_ID, &g_stWinLeftInfo.MediaPage, 1U);    
//                 }
//                 else
//                 {
//                     /*nothing*/
//                 }
//                 break;
//             case WIN_LEFT_DISP_SN_MUSIC:
//                 g_stWinLeftCtrl.u32SendCnt++;
//                 if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {
//                     g_stWinLeftCtrl.u32SendCnt = 0U;
//                     if (getRollingCounterF7() != 0U)
//                     {
//                         u8Length = getF7Data(&g_stWinLeftInfo.u8Music[0U]); 
//                     }
//                     if (getF1_SongType() == 0U)
//                     {
//                         u8Length = getF1_0Data(&g_stWinLeftInfo.u8Music[8U]); 
//                     }
//                     else if (getF1_SongType() == 1U)
//                     {
//                         u8Length = getF1_0Data(&g_stWinLeftInfo.u8Music[8U]); 
//                     }
//                     else if (getF1_SongType() == 2U)
//                     {
//                         u8Length = getF1_0Data(&g_stWinLeftInfo.u8Music[8U]); 
//                     }
//                     else
//                     {

//                     }

//                     if (u8Length > 0U)
//                     {
//                         Protocol_Send(WIN_LEFT_MUSIC_ID, &g_stWinLeftInfo.u8Music[0U], u8Length + 8U);
//                     } 
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE)
//                 {
//                     Protocol_Send(WIN_LEFT_SWITCH_ID, &g_stWinLeftInfo.MediaPage, 1U);    
//                 }
//                 else
//                 {
//                     /*nothing*/
//                 }
//                 break;
//             case WIN_LEFT_DISP_SN_RADIO:
//                 g_stWinLeftCtrl.u32SendCnt++;
//                 if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE + SEND_TO_CORE_SUBCYCLE)
//                 {
//                     g_stWinLeftCtrl.u32SendCnt = 0U;
//                     u8Length = getF1_0Data(&g_stWinLeftInfo.u8Radio[0U]);
//                     Protocol_Send(WIN_LEFT_RADIO_ID, &g_stWinLeftInfo.u8Radio[0U], 4U);                    
//                 }
//                 else if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE)
//                 {
//                     Protocol_Send(WIN_LEFT_SWITCH_ID, &g_stWinLeftInfo.MediaPage, 1U);    
//                 }
//                 else
//                 {
//                     /*nothing*/
//                 }
//                 break;
//             case WIN_LEFT_DISP_SN_NONE:
//                 g_stWinLeftCtrl.u32SendCnt++;
//                 if (g_stWinLeftCtrl.u32SendCnt >= SEND_TO_CORE_CYCLE)
//                 {
//                     g_stWinLeftCtrl.u32SendCnt = 0U;
//                     Protocol_Send(WIN_LEFT_SWITCH_ID, &g_stWinLeftInfo.MediaPage, 1U);    
//                 }
//             break;
             
//             default:
//                 g_stWinLeftCtrl.u32SendCnt = 0U;
//                 break;        
//         }
//     }

// }


// uint8_t Mcu_BlueTooth_Get(void)
// {   
//     return g_stWinLeftCtrl.u8BlueFaceEn;
// }


  
// void Mcu_Disp_Priority(void)
// {/** Task 20ms */
//     uint8_t u8CurPOP;
//     uint8_t u8CurBlue;
//     uint16_t u16CurPop;

//     if (Common_Get_IG_Sts() == COMMON_POWER_ON)
//     {
//         u8CurPOP = Drive_CurPOP_Status();
//         u8CurBlue = Mcu_BlueTooth_Get();
//         if (Espeed_Start_Valid_Get())
//         {
//             g_stCoreDispCtrl.u8SingleLane = 1u;
//             g_stCoreDispCtrl.u8Logo = 0u;  
//             g_stCoreDispCtrl.u8Car = 1u;
//             if (u8CurPOP)
//             {
//                 g_stCoreDispCtrl.u8POPEn = 1u;
//                 g_stCoreDispCtrl.u8BlueToothEn = 0u;
//                 //if (Get_Door_Status())
//                 u16CurPop = Popup_Get_Current_Message( );
//                 if ((u16CurPop == POPUP_MSG_DoorOpen_FL)
//                     ||(u16CurPop == POPUP_MSG_DoorOpen_FR)
//                     ||(u16CurPop == POPUP_MSG_DoorOpen_RL)
//                     ||(u16CurPop == POPUP_MSG_DoorOpen_RR)
//                     ||(u16CurPop == POPUP_MSG_HoodtOpen)
//                     ||(u16CurPop == POPUP_MSG_TrunkOpen)
//                     || (u16CurPop == POPUP_MSG_SeatbeltWarning_DR)  
//                     || (u16CurPop == POPUP_MSG_SeatbeltWarning_PR)  
//                     || (u16CurPop == POPUP_MSG_SeatbeltWarning_LR)  
//                     || (u16CurPop == POPUP_MSG_SeatbeltWarning_MR)  
//                     || (u16CurPop == POPUP_MSG_SeatbeltWarning_RR) 
//                     || (u16CurPop == POPUP_MSG_SeatbeltFatal_DR)   
//                     || (u16CurPop == POPUP_MSG_SeatbeltFatal_PR)   
//                     || (u16CurPop == POPUP_MSG_SeatbeltFatal_LR)   
//                     || (u16CurPop == POPUP_MSG_SeatbeltFatal_MR)   
//                     || (u16CurPop == POPUP_MSG_SeatbeltFatal_RR))
//                 {                  
//                     g_stCoreDispCtrl.u8Car = 0u;
//                 }                      
//             }
//             else
//             {
//                 if (u8CurBlue)
//                 {
//                     g_stCoreDispCtrl.u8POPEn = 0u;
//                     g_stCoreDispCtrl.u8BlueToothEn = 1u;  
//                 }
//                 else
//                 {
//                     g_stCoreDispCtrl.u8POPEn = 0u;
//                     g_stCoreDispCtrl.u8BlueToothEn = 0u; 
//                 }
//             }
//         }
//         else 
//         {              
//             g_stCoreDispCtrl.u8Car = 0u;  
//             g_stCoreDispCtrl.u8SingleLane = 0u; 
//             if (u8CurPOP)
//             {
//                 g_stCoreDispCtrl.u8POPEn = 1u;
//                 g_stCoreDispCtrl.u8BlueToothEn = 0u;
//                 g_stCoreDispCtrl.u8Logo = 0u;        
//             }
//             else
//             {
//                 if (u8CurBlue)
//                 {
//                     g_stCoreDispCtrl.u8POPEn = 0u;
//                     g_stCoreDispCtrl.u8BlueToothEn = 1u;
//                     g_stCoreDispCtrl.u8Logo = 0u;  
//                 }
//                 else
//                 {
//                     g_stCoreDispCtrl.u8POPEn = 0u;
//                     g_stCoreDispCtrl.u8BlueToothEn = 0u;
//                     g_stCoreDispCtrl.u8Logo = 1u;  
//                     g_stCoreDispCtrl.u8Car = 0u;  
//                     g_stCoreDispCtrl.u8SingleLane = 0u; 
//                 }
//             }
//         }        
//     }
//     else
//     {
//         g_stCoreDispCtrl.u8POPEn = 0u;
//         g_stCoreDispCtrl.u8BlueToothEn = 0u;
//         g_stCoreDispCtrl.u8Logo = 0u;  
//         g_stCoreDispCtrl.u8Car = 0u;  
//         g_stCoreDispCtrl.u8SingleLane = 0u;  
//     }  

// }






