
#include "Sys_Scheduler_Lib.h"
#include "Components.h"
//#include "CommonInterface.h"
#include "RTE.h"
#include "UDS_ISO14229_Server.h"

void Sys_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();
    UDS_Server_Application_Service();
}

void Sys_2ms_Tasks(void)
{
    Common_Input_Para();
    Sys_Status_Update_Service();
    Analog_Signal_Conv_Service();
    AMT630H_Main();
    DoCAN_Timer_Update(2000u);
    //Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 2000u);无外发
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 2u);
}

void Sys_5ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
}

void Sys_10ms_Tasks(void)
{
    Line_In_Debounce_Service(10u);
    Key_Service();
    Data_Mileage_Write_EEPROM();
    Key_Clear_Time();
    Key_TimeOut_Service();
    Fuel_R_Cal(10u);
    Coolant_R_Cal(10u);
    Data_Light_Res_service(10);
}

void Sys_20ms_Tasks(void)
{
    Data_Vehicle_Speed_Processing_Service();
    Data_Engine_Speed_Processing_Service();
}

void Sys_50ms_Tasks(void)
{
    Telltales_Management();
    g_u8Cursor_Posittion = Menu_Get_Current_Cursor_Information();


    // if((MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit) > 23)
    // {
    //     MenuData.Dis_Hour_Tenb = 2;
    //     MenuData.Dis_Hour_Bit = 3;
    // }

    // if((MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit) > 59)
    // {
    //     MenuData.Dis_Minute_Tenb = 5;
    //     MenuData.Dis_Minute_Bit = 9;
    // }
}

uint32_t ODOtest = 0;
uint32_t Triptest = 0;
uint32_t aaa = 0;

void Sys_100ms_Tasks(void)
{
    ODOtest = Data_ODO_Read();
    Triptest = Data_Read_Trip(0);
    S3_ServerCNTT();
    Get_DisTime_Service();
    Fuel_Cal_Sevice(100u);
    Coolant_Cal_Sevice(100u);
    Services_Mileage_Callback();
    //Data_Mileage_Clear();

    RTE_GPIO_Config(RTE_GPIO_PORT05_PIN04, GpioOut_High);

    // aaa = Menu_Item_Select_Get(MENU_ITEM_SELECT_AUTO);
}
static uint16_t task_2ms = 0u;
void Sys_Exact_50us_Tasks(void)
{
    static uint32_t task_1ms = 0u;
    GenDelay_Tick();
    ////DoCAN_Timer_Update(50u);
    task_1ms++;
    if ( task_1ms >=20U )   
    {
        task_1ms =0U;
        eeprom_1ms_timeCount( );
    }

    task_2ms++;
    if (task_2ms >= 40)
    {
        task_2ms = 0;        
        AMT630H_Timer(2);
    }
}