
#include "Components.h"
#include "Simulated_IIC_master\Simulated_IIC_master.h"

int32_t SIIC_Master_Set_GPIO(uint16_t u16GPIOPin, SIIC_M_GPIO_Mode_en_t enMode)
{
    uint8_t u8GPIOMode;

    if (enMode == SIIC_M_GPIO_IN_HiZ)
    {
        u8GPIOMode = RTE_GPIO_DIR_IN;
    }
    else   /* enMode == SIIC_M_GPIO_OUT_LOW */
    {
        u8GPIOMode = RTE_GPIO_DIR_OUT | RTE_GPIO_LEVEL_LOW;
    }

    return RTE_GPIO_Config(u16GPIOPin, u8GPIOMode);
}

uint8_t SIIC_Master_Get_GPIO(uint16_t u16GPIOPin)
{
    return RTE_GPIO_Get_Level(u16GPIOPin);
}
