
#include "Menu.h"
#include "Components.h"

/*-------------------Logic_Operation Call Back---------------------*/
uint8_t g_u8Cursor_Posittion;
extern _Menu_Data MenuData;


void Menu_Logic_Operation_MAIN_ITEM(Menu_Key_en_t enKeyType);   			/*回调函数 显示模式*/
void Menu_Logic_Operation_Display_Mode(Menu_Key_en_t enKeyType);   			/*回调函数 显示模式*/
void Menu_Logic_Operation_Backlight_Setting(Menu_Key_en_t enKeyType);   			/*回调函数 背光设置*/
void Menu_Logic_Operation_Bluetooth_Connect(Menu_Key_en_t enKeyType);   			/*回调函数 蓝牙连接*/
void Menu_Logic_Operation_Clock_Setting(Menu_Key_en_t enKeyType);  	  			/*回调函数 时钟设置*/
void Menu_Logic_Operation_Unit_Setting(Menu_Key_en_t enKeyType);	   				/*回调函数 单位设置*/
void Menu_Logic_Operation_Language_Setting(Menu_Key_en_t enKeyType);				/*回调函数 语言设置*/
void Menu_Logic_Operation_Fault_Information(Menu_Key_en_t enKeyType);			/*回调函数 故障信息*/	
void Menu_Logic_Operation_Phone_Connect(Menu_Key_en_t enKeyType);  				/*回调函数 手机互联*/
void Menu_Logic_Operation_Quit(Menu_Key_en_t enKeyType);  						/*回调函数 退出*/

void Menu_Logic_Operation_Select_Daytime(Menu_Key_en_t enKeyType);	   			/*回调函数 选中日间*/
void Menu_Logic_Operation_Select_Nighttime(Menu_Key_en_t enKeyType);    			/*回调函数 选中夜间*/
void Menu_Logic_Operation_Select_Auto(Menu_Key_en_t enKeyType);	       			/*回调函数 选中自动*/

void Menu_Logic_Operation_Backlight_Auto(Menu_Key_en_t enKeyType);	 			/*回调函数 背光自动*/
void Menu_Logic_Operation_Backlight_1(Menu_Key_en_t enKeyType);	      			/*回调函数 背光_1*/
void Menu_Logic_Operation_Backlight_2(Menu_Key_en_t enKeyType);        			/*回调函数 背光_2*/
void Menu_Logic_Operation_Backlight_3(Menu_Key_en_t enKeyType);	   	   			/*回调函数 背光_3*/
void Menu_Logic_Operation_Backlight_4(Menu_Key_en_t enKeyType);		   			/*回调函数 背光_4*/
void Menu_Logic_Operation_Backlight_5(Menu_Key_en_t enKeyType);	       			/*回调函数 背光_5*/

void Menu_Logic_Operation_Bluetooth_Open(Menu_Key_en_t enKeyType);      			/*回调函数 蓝牙_开*/
void Menu_Logic_Operation_Bluetooth_Close(Menu_Key_en_t enKeyType);	   			/*回调函数 蓝牙_关*/
void Menu_Logic_Operation_Bluetooth_Sync_Contacts(Menu_Key_en_t enKeyType);	   	/*回调函数 蓝牙同步联系人*/
void Menu_Logic_Operation_Bluetooth_Back(Menu_Key_en_t enKeyType);	   			/*回调函数 蓝牙返回*/

void Menu_Logic_Operation_Clock_Back(Menu_Key_en_t enKeyType); 	      			/*回调函数 时钟返回*/
void Menu_Logic_Operation_Clock_Min_Bit(Menu_Key_en_t enKeyType);	  			/*回调函数 时钟分钟个位*/
void Menu_Logic_Operation_Clock_Min_Tenb(Menu_Key_en_t enKeyType);	  			/*回调函数 时钟分钟十位*/
void Menu_Logic_Operation_Clock_Hour_Bit(Menu_Key_en_t enKeyType);				/*回调函数 时钟小时个位*/
void Menu_Logic_Operation_Clock_Hour_Tenb(Menu_Key_en_t enKeyType);	    		/*回调函数 时钟小时十位*/

void Menu_Logic_Operation_Unit_Km(Menu_Key_en_t enKeyType);	   					/*回调函数 选中公制*/
void Menu_Logic_Operation_Unit_Mile(Menu_Key_en_t enKeyType);	   				/*回调函数 选中英制*/	

void Menu_Logic_Operation_Language_Chinese(Menu_Key_en_t enKeyType);   			/*回调函数 选中中文*/
void Menu_Logic_Operation_Language_English(Menu_Key_en_t enKeyType);	   			/*回调函数 选中英文*/	
void Menu_Logic_Operation_Phone_Connect_Win(Menu_Key_en_t enKeyType);  			/*回调函数 手机互联成功*/

void Menu_User_Init(void)
{
	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;
	Menu_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
}

void Menu_User_WAKEUP(void)
{
	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;
	Menu_Wake_Up_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
}

/*---------------------------------------------------------------------------------------*/
const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{
/*MENU_ITEM_MAIN_ITEM = 0,	    */	{0, MENU_INTF_MAIN_INTF,          	MENU_ITEM_MAX,		 		 0U,  1U,  1U,  0,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_MODE,                MENU_JUMP_FIRST,  		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_MAIN_ITEM          },/**<  行车电脑界面 */
/*MENU_ITEM_DISPLAY_MODE,  		*/	{0, MENU_INTF_MODE,          		MENU_ITEM_MAIN_ITEM, 		 0U,  9U,  1U,  1,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_DISPLAY_MODE,        MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Display_Mode          },/**<  行车电脑界面 */
/*MENU_ITEM_BACKLIGHT_SETTING,	*/	{0, MENU_INTF_MODE,            		MENU_ITEM_MAIN_ITEM, 		 1U,  9U,  1U,  2,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_BACKLIGHT_SETTING,   MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_Setting         },/**<  手机互联安卓 */
/*MENU_ITEM_BLUETOOTH_CONNECT,	*/	{0, MENU_INTF_MODE,            		MENU_ITEM_MAIN_ITEM, 		 2U,  9U,  1U,  3,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_BLUETOOTH_CONNECT,   MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Bluetooth_Connect             },/**<  手机互联苹果 */
/*MENU_ITEM_CLOCK_SETTING,  	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 3U,  9U,  1U,  4,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Setting       },/**<  主题模式 */
/*MENU_ITEM_UNIT_SETTING,	   	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 4U,  9U,  1U,  5,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_UNIT_SETTING,        MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Setting        },/**<  单位设置 */
/*MENU_ITEM_LANGUAGE_SETTING,	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 5U,  9U,  1U,  6,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_LANGUAGE_SETTING,    MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_Setting              },/**<  时钟信息 */
/*MENU_ITEM_FAULT_INFORMATION, 	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 6U,  9U,  1U,  7,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_FAULT_INFORMATION,   MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Fault_Information    },/**<  亮度设置 */
/*MENU_ITEM_PHONE_CONNECT,  	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 7U,  9U,  1U,  8,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_PHONE_CONNECT,       MENU_JUMP_SELECT,  	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Phone_Connect         },/**<  胎压学习 */
/*MENU_ITEM_QUIT,  			 	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 8U,  9U,  1U,  9,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Quit           },/**<  语言设置 */
/*MENU_ITEM_SELECT_DAYTIME,		*/	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 0U,  3U,  1U,  10,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Daytime },/**<  蓝牙设置 */
/*MENU_ITEM_SELECT_NIGHTTIME,   */	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 1U,  3U,  1U,  11,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Nighttime             },/**<  DVR */
/*MENU_ITEM_SELECT_AUTO,	    */	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 2U,  3U,  1U,  12,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Auto            },/**<  版本信息 */
/*MENU_ITEM_BACKLIGHT_5,	    */	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 0U,  6U,  1U,  13,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5 	   },/**<  恢复出厂设置 */
/*MENU_ITEM_BACKLIGHT_4,		*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 1U,  6U,  1U,  14,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  主题一 */
/*MENU_ITEM_BACKLIGHT_3,	 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 2U,  6U,  1U,  15,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  主题二 */
/*MENU_ITEM_BACKLIGHT_2,     	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 3U,  6U,  1U,  16,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  主题三 */
/*MENU_ITEM_BACKLIGHT_1,	 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 4U,  6U,  1U,  17,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  12时制 */
/*MENU_ITEM_BACKLIGHT_AUTO, 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 5U,  6U,  1U,  18,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  24时制 */
/*MENU_ITEM_BLUETOOTH_OPEN,   	*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 0U,  4U,  1U,  19,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5               },/**<  时间调整 */
/*MENU_ITEM_BLUETOOTH_CLOSE,	*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 1U,  4U,  1U,  20,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度1 */
/*MENU_ITEM_BLUETOOTH_SYNC,		*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 2U,  4U,  1U,  21,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度2 */
/*MENU_ITEM_BLUETOOTH_BACK,		*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 3U,  4U,  1U,  22,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度3 */
/*MENU_ITEM_CLOCK_HOUR_TENB,	*/	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     0U,  5U,  1U,  23,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度4 */
/*MENU_ITEM_CLOCK_HOUR_BIT,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     1U,  5U,  1U,  24,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度5 */
/*MENU_ITEM_CLOCK_MIN_TENB,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     2U,  5U,  1U,  25,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5    },/**<  亮度自动 */
/*MENU_ITEM_CLOCK_MIN_BIT,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     3U,  5U,  1U,  26,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5          },/**<  胎压单位 */
/*MENU_ITEM_CLOCK_BACK, 	  	*/	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     4U,  5U,  1U,  27,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5        },/**<  前轮学习 */
/*MENU_ITEM_UNIT_KM,		    */	{0, MENU_INTF_UNIT_SETTING,         MENU_ITEM_UNIT_SETTING,      0U,  2U,  1U,  28,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Km        },/**<  后轮学习 */
/*MENU_ITEM_UNIT_MILE,	        */	{0, MENU_INTF_UNIT_SETTING, 		MENU_ITEM_UNIT_SETTING,      1U,  2U,  1U,  29,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Mile          },/**<  蓝牙连接 */
/*MENU_ITEM_LANGUAGE_CHINESE, 	*/	{0, MENU_INTF_LANGUAGE_SETTING, 	MENU_ITEM_LANGUAGE_SETTING,  0U,  2U,  1U,  30,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_Chinese       },/**<  同步联系人 */
/*MENU_ITEM_LANGUAGE_ENGLISH,	*/	{0, MENU_INTF_LANGUAGE_SETTING, 	MENU_ITEM_LANGUAGE_SETTING,  1U,  2U,  1U,  31,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_English          },/**<  蓝牙名称 */
/*MENU_ITEM_PHONE_CONNECT_WIN	*/	{0, MENU_INTF_PHONE_CONNECT, 		MENU_ITEM_PHONE_CONNECT,     0U,  1U,  1U,  32,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           MENU_JUMP_SELECT, 		0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5           },/**<  蓝牙退出 */
};

/*-------------------------------------------------------------------------------------------------*/

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

//static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
//static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);
void Menu_Service(Menu_Key_en_t enMenuKey);

/*传入按键动作执行之前需要预先处理的动作*/
// static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
// {

// 	/*预处理中执行过本次按键了，后续不必执行时调用一次*/
// 	/*u8MenuKeyExecute = 0U;*/
// }
/*传入按键动作执行之后需要后置处理的动作*/
// static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
// {
// }

/*------------传入按键类型-----------------------*/
void Menu_Service(Menu_Key_en_t enMenuKey)
{
	/*功能回调函数的调用*/
	Menu_Logic_Process(enMenuKey);
	/*--------------------------------------------------*/
	/*按键动作对光标的处理*/
	//Menu_Cursor_Preprocess(enMenuKey);
	//Menu_Cursor_Process(enMenuKey);
	//Menu_Cursor_Postprocess(enMenuKey);
	/*--------------------------------------------------*/
}

/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
//#pragma ghs section bss = ".myNonInitArea"
Menu_uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
//#pragma ghs section bss = default
/*---------------------------------------*/
/*---------------------------------------*/
/*---------------------------------------*/


void Menu_Logic_Operation_MAIN_ITEM(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_DISPLAY_MODE);
	}
	else if(enKeyType == MENU_KEY_FUNCTION_1_SHORT)//大小计切换
	{
		if(Get_Dis_Unit() == 0)
		{
			MenuData.Unit = 1;//mile
		}
		else
		{
			MenuData.Unit = 0;//km
		}
	}
}

void Menu_Logic_Operation_Display_Mode(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_SELECT_DAYTIME);
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_BACKLIGHT_SETTING);
		}
		else
		{
			if(enKeyType == MENU_KEY_TIMEOUT)
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
			}
		}
	}
} 	

void Menu_Logic_Operation_Select_Daytime(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
	}
	else
	{
		if(enKeyType == MENU_KEY_DOWN_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_SELECT_NIGHTTIME);
		}
		else
		{
			if(enKeyType == MENU_KEY_TIMEOUT)
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
			}
		}
	}
}

void Menu_Logic_Operation_Select_Nighttime(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
	}
	else
	{
		if(enKeyType == MENU_KEY_DOWN_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_SELECT_AUTO);
		}
		else
		{
			if(enKeyType == MENU_KEY_TIMEOUT)
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
			}
		}
	}
}

void Menu_Logic_Operation_Select_Auto(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
	}
	else
	{
		if(enKeyType == MENU_KEY_DOWN_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_SELECT_DAYTIME);
		}
		else
		{
			if(enKeyType == MENU_KEY_TIMEOUT)
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
			}
		}
	}
}






void Menu_Logic_Operation_Backlight_Setting(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_BLUETOOTH_CONNECT);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 	

void Menu_Logic_Operation_Bluetooth_Connect(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_CLOCK_SETTING);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 	

void Menu_Logic_Operation_Clock_Setting(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_UNIT_SETTING);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 	

void Menu_Logic_Operation_Unit_Setting(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_LANGUAGE_SETTING);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 	

void Menu_Logic_Operation_Language_Setting(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_FAULT_INFORMATION);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 	

void Menu_Logic_Operation_Fault_Information(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_PHONE_CONNECT);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 

void Menu_Logic_Operation_Phone_Connect(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_QUIT);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
} 

void Menu_Logic_Operation_Quit(Menu_Key_en_t enKeyType)
{
    if(enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_DISPLAY_MODE);
	}
	else
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION, MENU_ITEM_MAIN_ITEM);
		}
	}
}		

void Menu_Logic_Operation_Backlight_5(Menu_Key_en_t enKeyType)
{

}

void Menu_Logic_Operation_Unit_Km(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.Unit = 1;
	}
}

void Menu_Logic_Operation_Unit_Mile(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.Unit = 0;
	}
}

void Menu_Logic_Operation_Language_Chinese(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.Language = 1;
	}
}

void Menu_Logic_Operation_Language_English(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.Language = 0;
	}
}
			
