#include "Data_Fuel.h"
#include "Components.h"


#define FUEL_DATA_TIME 25u /*这里填写多长时间采集一个数据，单位ms*/
#define FUEL_DATA_NUM 20u  /*燃油电阻采集数据总数 最大255*/
#define FUEL_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define FUEL_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/

#define RETURN_DIFFERENCE 25u /*判断上升或下降的回差，精度0.1*/

#define FUEL_SEG_UP 0u
#define FUEL_SEG_DOWN 1u

uint16_t g_u16FuelData[FUEL_DATA_NUM];
uint8_t g_u8FuelDataCount = 0u;

uint16_t FuelR = 0u; /*滤波后的燃油电阻，精度0.1*/
static uint16_t FuelRBak = 0;

uint8_t g_u8DesFuelSetp = 0u;
uint8_t g_u8CurFuelSetp = 0u;
uint8_t g_u8FuelInitFlag = 0u;
uint8_t g_u8FuelStateInitFlag = 0u;
uint8_t g_u8FuelDir = FUEL_SEG_UP;
FuelSensorSts_t FuelSensorState = FuelSensorNormal;
uint16_t g_u16FuelSensorNormalTime = 0u;
uint16_t g_u16FuelSensorShortTime = 0u;
uint16_t g_u16FuelSensorOpenTime = 0u;
uint8_t g_u8FuelADCompleteFlg = 0u;

void Fuel_KL30_Init(void)
{
    g_u8DesFuelSetp = 0u;
    g_u8CurFuelSetp = 0u;
    g_u8FuelInitFlag = 1u;
    g_u8FuelStateInitFlag = 1u;
    g_u8FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    g_u16FuelSensorNormalTime = 0u;
    g_u16FuelSensorShortTime = 0u;
    g_u16FuelSensorOpenTime = 0u;
    g_u8FuelADCompleteFlg = 0u;
}

void Fuel_KL15_Init(void)
{
    g_u8DesFuelSetp = 0u;
    g_u8CurFuelSetp = 0u;
    g_u8FuelInitFlag = 1u;
    g_u8FuelStateInitFlag = 1u;
    g_u8FuelDir = FUEL_SEG_UP;
    FuelSensorState = FuelSensorNormal;
    g_u16FuelSensorNormalTime = 0u;
    g_u16FuelSensorShortTime = 0u;
    g_u16FuelSensorOpenTime = 0u;
    g_u8FuelADCompleteFlg = 0u;
}

void Fuel_R_Cal(uint8_t deltaTime)
{
    uint16_t FuelRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;

    if(g_u8FuelStateInitFlag)
    {
        FuelR = ADC_Read_Signal(ADC_CH_FUEL1);
    }

    if (timeCount >= FUEL_DATA_TIME)
    {
        timeCount = 0;
        if (g_u8FuelDataCount < FUEL_DATA_NUM)
        {
            /*获取燃油电阻*/
            FuelRes = ADC_Read_Signal(ADC_CH_FUEL1);

            /*四舍五入*/
            if (FuelRes < 3100)
            {
                if (FuelRes % 10 >= 5)
                {
                    FuelRes += 5;
                }
            }
            else
            {
                FuelRes = 0xFFFF;
            }
            /*由小到大插入数据*/
            for (i = 0; i < g_u8FuelDataCount; i++)
            {
                if (FuelRes < g_u16FuelData[i])
                {
                    break;
                }
            }
            for (j = g_u8FuelDataCount; j > i; j--)
            {
                g_u16FuelData[j] = g_u16FuelData[j - 1];
            }
            g_u16FuelData[i] = FuelRes;
            g_u8FuelDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = FUEL_CAL_START; i < FUEL_CAL_END; i++)
            {
                temp32 += g_u16FuelData[i];
            }
            FuelR = temp32 / (FUEL_CAL_END - FUEL_CAL_START);
            g_u8FuelDataCount = 0;
            g_u8FuelADCompleteFlg = 1;
        }
    }
    timeCount += deltaTime;
}

void Fuel_State_Check(uint8_t deltaTime)
{
    if (FuelR < 30)
    { /*短路3*/
        g_u16FuelSensorOpenTime = 0;
        g_u16FuelSensorNormalTime = 0;
        if ((g_u16FuelSensorShortTime > 3000) || ((g_u8FuelStateInitFlag) && (g_u16FuelSensorShortTime > 3000)))
        {
            FuelSensorState = FuelSensorShortCircuit;
            g_u8DesFuelSetp = 0;
            g_u8CurFuelSetp = 6;
            g_u8FuelStateInitFlag = 0;
            g_u8FuelInitFlag = 1;
            g_u8FuelDir = FUEL_SEG_UP;
        }
        else
        {
            g_u16FuelSensorShortTime += deltaTime;
        }
    }
    else if (FuelR > 3100)
    { /*开路 310*/
        g_u16FuelSensorShortTime = 0;
        g_u16FuelSensorNormalTime = 0;
        if ((g_u16FuelSensorOpenTime > 3000) || ((g_u8FuelStateInitFlag) && (g_u16FuelSensorOpenTime > 3000)))
        {
            FuelSensorState = FuelSensorOpenCircuit;
            g_u8DesFuelSetp = 0;
            g_u8CurFuelSetp = 0;
            g_u8FuelStateInitFlag = 0;
            g_u8FuelInitFlag = 1;
            g_u8FuelDir = FUEL_SEG_UP;
        }
        else
        {
            g_u16FuelSensorOpenTime += deltaTime;
        }
    }
    else
    {
        g_u16FuelSensorShortTime = 0;
        g_u16FuelSensorOpenTime = 0;
        if (g_u16FuelSensorNormalTime > 3000)
        {
            FuelSensorState = FuelSensorNormal;
            g_u8FuelStateInitFlag = 0;
        }
        else
        {
            g_u16FuelSensorNormalTime += deltaTime;
        }
    }
}

void Fuel_Gauges_Cal(uint8_t deltaTime)
{
    static uint16_t time = 0;

    if ((FuelSensorState == FuelSensorNormal) && (FuelR <= 3100) && (FuelR >= 30))
    { 
        /*采集完第一组数据后，开始计算燃油格数*/
        if (g_u8FuelADCompleteFlg)
        {
            if (g_u8FuelInitFlag)
            {
                FuelRBak = FuelR;
            }

            /*根据回差计算走动方向*/
            if (g_u8FuelDir == FUEL_SEG_UP)
            {
                if (FuelR >= FuelRBak + RETURN_DIFFERENCE)
                {
                    g_u8FuelDir = FUEL_SEG_DOWN;
                    FuelRBak = FuelR;
                }
                if (FuelR < FuelRBak)
                {
                    FuelRBak = FuelR;
                }
            }
            else
            {
                if (FuelRBak >= FuelR + RETURN_DIFFERENCE)
                {
                    g_u8FuelDir = FUEL_SEG_UP;
                    FuelRBak = FuelR;
                }
                if (FuelR > FuelRBak)
                {
                    FuelRBak = FuelR;
                }
            }

            /*计算目标格数*/
            if (g_u8FuelDir == FUEL_SEG_UP)
            {
                if (((g_u8DesFuelSetp == 7) || g_u8FuelInitFlag) && (FuelR <= 110))
                {
                    g_u8DesFuelSetp = 8;
                }
                else if (((g_u8DesFuelSetp == 6) || g_u8FuelInitFlag) && (FuelR <= 210))
                {
                    g_u8DesFuelSetp = 7;
                }
                else if (((g_u8DesFuelSetp == 5) || g_u8FuelInitFlag) && (FuelR <= 310))
                {
                    g_u8DesFuelSetp = 6;
                }
                else if (((g_u8DesFuelSetp == 4) || g_u8FuelInitFlag) && (FuelR <= 380))
                {
                    g_u8DesFuelSetp = 5;
                }
                else if (((g_u8DesFuelSetp == 3) || g_u8FuelInitFlag) && (FuelR <= 490))
                {
                    g_u8DesFuelSetp = 4;
                }
                else if (((g_u8DesFuelSetp == 2) || g_u8FuelInitFlag) && (FuelR <= 610))
                {
                    g_u8DesFuelSetp = 3;
                }
                else if (((g_u8DesFuelSetp == 1) || g_u8FuelInitFlag) && (FuelR <= 830))
                {
                    g_u8DesFuelSetp = 2;
                }
                else if (((g_u8DesFuelSetp == 0) || g_u8FuelInitFlag) && (FuelR <= 5000))
                {
                    g_u8DesFuelSetp = 1;
                }
            }
            else if (g_u8FuelDir == FUEL_SEG_DOWN)
            {
                if (((g_u8DesFuelSetp == 1) || g_u8FuelInitFlag) && (FuelR > 5000))
                {
                    g_u8DesFuelSetp = 0;
                }
                else if (((g_u8DesFuelSetp == 2) || g_u8FuelInitFlag) && (FuelR > 830))
                {
                    g_u8DesFuelSetp = 1;
                }
                else if (((g_u8DesFuelSetp == 3) || g_u8FuelInitFlag) && (FuelR > 610))
                {
                    g_u8DesFuelSetp = 2;
                }
                else if (((g_u8DesFuelSetp == 4) || g_u8FuelInitFlag) && (FuelR > 490))
                {
                    g_u8DesFuelSetp = 3;
                }
                else if (((g_u8DesFuelSetp == 5) || g_u8FuelInitFlag) && (FuelR > 380))
                {
                    g_u8DesFuelSetp = 4;
                }
                else if (((g_u8DesFuelSetp == 6) || g_u8FuelInitFlag) && (FuelR > 310))
                {
                    g_u8DesFuelSetp = 5;
                }
                else if (((g_u8DesFuelSetp == 7) || g_u8FuelInitFlag) && (FuelR > 210))
                {
                    g_u8DesFuelSetp = 6;
                }
                else if (((g_u8DesFuelSetp == 8) || g_u8FuelInitFlag) && (FuelR > 110))
                {
                    g_u8DesFuelSetp = 7;
                }
            }
        }

        /*IGN ON 1秒/故障恢复后，开始走格  立即指向当前格 20220704*/
        if (Common_GetIgnOnTime() >= 3000)
        {
            time += deltaTime;
            if (g_u8FuelInitFlag)
            {
                g_u8FuelInitFlag = 0;
                time = 0;
                g_u8CurFuelSetp = g_u8DesFuelSetp;
            }

            if (time >= 15000)
            { /* 15S变化一格 */
                time = 0;
                if (g_u8CurFuelSetp < g_u8DesFuelSetp)
                {
                    g_u8CurFuelSetp++;
                }
                else if (g_u8CurFuelSetp > g_u8DesFuelSetp)
                {
                    g_u8CurFuelSetp--;
                }
            }
            
            if (g_u8CurFuelSetp == g_u8DesFuelSetp)
            {
                time = 0;
            }
        }
    }
}

void Fuel_Cal_Sevice(uint8_t deltaTime)
{
    /*检测燃油电阻状态*/
    Fuel_State_Check(deltaTime);

    /*显示燃油格*/
    Fuel_Gauges_Cal(deltaTime);
}

uint8_t Get_CurFuelSetp(void)
{
    uint8_t u8CurFuelSetp = g_u8CurFuelSetp;
    if(FuelSensorState == FuelSensorOpenCircuit)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurFuelSetp = 6;
        }
        else
        {
            u8CurFuelSetp = 0;
        }
    }
    else if(FuelSensorState == FuelSensorShortCircuit)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurFuelSetp = 7;
        }
        else
        {
            u8CurFuelSetp = 0;
        }
    }
    else if(u8CurFuelSetp == 1)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurFuelSetp = 1;
        }
        else
        {
            u8CurFuelSetp = 0;
        }
    }
    else
    {
        ;
    }
    return u8CurFuelSetp;
}

FuelSensorSts_t Get_Fuel_Sensor_State(void)
{
    uint8_t u8CurFuelSetp = 0;
    if(FuelSensorState == FuelSensorOpenCircuit || g_u8CurFuelSetp == 1u)
    {
        if(FLASH_SYNC_1Hz)
        {
            u8CurFuelSetp = 2;
        }
        else
        {
            u8CurFuelSetp = 0;
        }
    }
    else
    {
        u8CurFuelSetp = 1u;
    }
    return u8CurFuelSetp;
}
