#include "Components.h"
uint8_t Pic_mode = PIC_NIGHTTIME_CH;

// 菜单背景,菜单前必带
void AMT630H_GUI_BACKGRAND(void);
// 一级菜单
void AMT630H_GUI_Quit(void);
void AMT630H_GUI_Phone_Connect(void);
void AMT630H_GUI_Fault_Information(void);
void AMT630H_GUI_Language_Information(void);
void AMT630H_GUI_Unit_Information(void);
void AMT630H_GUI_Backlight_Information(void);
void AMT630H_GUI_Backlight_Information(void);
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON);
void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min);
// 二级菜单
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT);
void AMT630H_GUI_Backlight_Setting(uint8_t back_mode);
void AMT630H_GUI_Display_Mode_Setting(uint8_t Display_mode);
void AMT630H_GUI_Bluetooth_Connect_Setting(uint8_t select, uint8_t sync_contacts, uint8_t Connect_ON);
void AMT630H_GUI_Unit_Setting(uint8_t select);
void AMT630H_GUI_Language_Setting(uint8_t select);
void AMT630H_GUI_Phone_Connect_Win(void);

uint8_t num_time = 0;
uint8_t num_time_num1 = 0;
uint8_t num_time_num2 = 0;
uint8_t num_time_num3 = 0;
void AMT630H_GUI_Background()
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        AMT630H_GUI_BACKGRAND();
        // AMT630H_GUI_Phone_Connect_Win();
        num_time++;
        if (num_time % 20 == 0)
        {
            num_time_num2++;
            if (num_time_num2 == 100)
            {
                num_time_num2 = 0;
            }
        }
        if (num_time % 50 == 0)
        {
            num_time_num1++;

            if (num_time_num1 == 5)
                num_time_num1 = 0;
        }
        if (num_time % 100 == 0)
        {
            num_time = 0;
            num_time_num3 = ~num_time_num3;
        }
        AMT630H_GUI_Clock_Setting(num_time_num2, num_time_num2, num_time_num1);
    }
    else
    {
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0013_0_57);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0012_0_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0047_264_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0048_610_229);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0052_44_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0053_49_229);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0057_376_336);
    }
}
/**
 * @brief 故障信息 一级菜单
 * @param[in] //暂无
 */
void AMT630H_GUI_Fault_Information(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0163_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0164_913_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0165_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0155_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0166_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0091_567_356);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0167_341_354);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0093_574_292);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0168_350_290);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0095_633_240);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0169_353_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0095_633_175);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0170_354_162);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0350_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0351_913_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0352_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0342_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0353_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0279_567_356);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0354_341_354);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0281_574_292);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0355_350_290);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0283_633_240);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0356_353_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0283_633_175);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0357_354_162);
    }
}
/**
 * @brief 显示模式信息 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Backlight_Information(void)
{
    SetPagePic(GRAPHICS_PAGE_0, Pic_0190_27_396);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0191_903_396);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0161_207_485);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0185_737_485);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0192_445_517);

    SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0152_434_232);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
}
///**
// * @brief 背光信息 一级菜单
// * @param[in] null
// */
//void AMT630H_GUI_Backlight_Information(void)
//{
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0187_37_396);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0188_904_396);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0156_197_485);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0181_737_485);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0189_446_517);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
//    SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
//}
static uint16_t Bluetooth_num[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};
/**
 * @brief 蓝牙连接 一级菜单
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON)
{
    SetPagePic(GRAPHICS_PAGE_0, Pic_0183_26_396);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0184_903_396);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0185_197_485);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0177_738_485);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0186_445_517);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163);

    if (Connect_ON == 0)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
    }
    if (sync_contacts < 10)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t ArrivalNumber;
        ArrivalNumber = sync_contacts;
        DisplayNumPara.NumList = Bluetooth_num;               // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
        DisplayNumPara.x = 604;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 1;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t ArrivalNumber;
        ArrivalNumber = sync_contacts;
        DisplayNumPara.NumList = Bluetooth_num;               // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
        DisplayNumPara.x = 612;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 2;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
    }
}
///**
// * @brief 时间设置 一级菜单
// * @param[in]  Clock_Hour  小时
// * @param[in]  Clock_Min   分钟
// */
//void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min)
//{
//    if (Pic_mode == PIC_DAYTIME_CH)
//    {
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0179_27_396);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0180_903_396);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0181_197_485);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0173_737_485);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0182_446_517);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);
//        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);

//        DISPLAY_NUM_ST DisplayNumPara;
//        uint8_t ArrivalNumber;
//        ArrivalNumber = Clock_Hour;
//        DisplayNumPara.NumList = time_num;                    // 图片数组
//        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
//        DisplayNumPara.x = 574;                               // 最右边数字的最左上角的横坐标
//        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
//        DisplayNumPara.DecimalNum = 0; // 小数点后位数
//        DisplayNumPara.MinDigits = 2;  // 最小显示位数
//        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);

//        ArrivalNumber = Clock_Min;
//        DisplayNumPara.NumList = time_num;                    // 图片数组
//        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
//        DisplayNumPara.x = 457;                               // 最右边数字的最左上角的横坐标
//        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
//        DisplayNumPara.DecimalNum = 0; // 小数点后位数
//        DisplayNumPara.MinDigits = 2;  // 最小显示位数
//        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
//    }
//}
/**
 * @brief 单位设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Unit_Information(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0175_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0176_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0177_198_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0165_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0178_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0362_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0363_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0364_198_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0352_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0365_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
    }
}
/**
 * @brief 语言设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Language_Information(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0171_28_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0172_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0173_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0160_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0174_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0358_28_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0359_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0360_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0347_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0361_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
    }
}

/**
 * @brief 手机互联 一级菜单
 *
 */
void AMT630H_GUI_Phone_Connect(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0158_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0159_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0160_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0161_747_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0162_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0345_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0346_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0347_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0348_747_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0349_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
    }
}
/**
 * @brief 退出 一级菜单
 * @param[in]  null
 */
void AMT630H_GUI_Quit(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0153_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0154_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0155_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0156_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0157_461_517);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0340_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0341_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0342_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0343_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0344_461_517);
    }
}

static uint16_t time_num_day[] = {
    Pic_0022_550_211,
    Pic_0023_564_211,
    Pic_0024_550_211,
    Pic_0025_552_211,
    Pic_0026_548_211,
    Pic_0027_550_211,
    Pic_0028_551_211,
    Pic_0029_549_211,
    Pic_0030_550_211,
    Pic_0031_551_211};
static uint16_t time_num_night[] = {
    Pic_0210_550_211,
    Pic_0211_564_211,
    Pic_0212_550_211,
    Pic_0213_552_211,
    Pic_0214_548_211,
    Pic_0215_550_211,
    Pic_0216_551_211,
    Pic_0217_549_211,
    Pic_0218_550_211,
    Pic_0219_551_211};
/**
 * @brief 时间设
        置 二级菜单
 * @param[in]  Clock_Hour  小时
 * @param[in]  Clock_Min   分钟
 * @param[in]  Clock_BIT   选中位数 5选中返回
 */
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0135_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);
        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335); // 返回
            break;
        default:
            break;
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t ArrivalNumber;
        ArrivalNumber = Clock_Hour;
        DisplayNumPara.NumList = time_num_day;                // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
        DisplayNumPara.x = 455;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 2;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);

        ArrivalNumber = Clock_Min;
        DisplayNumPara.NumList = time_num_day;                // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
        DisplayNumPara.x = 572;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 2;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0323_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_338);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);
        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0207_437_316); // 返回
            break;
        default:
            break;
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t ArrivalNumber;
        ArrivalNumber = Clock_Hour;
        DisplayNumPara.NumList = time_num_night;              // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
        DisplayNumPara.x = 455;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 2;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);

        ArrivalNumber = Clock_Min;
        DisplayNumPara.NumList = time_num_night;              // 图片数组
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47; // 往左排  数字间距
        DisplayNumPara.x = 572;                               // 最右边数字的最左上角的横坐标
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0; // 小数点后位数
        DisplayNumPara.MinDigits = 2;  // 最小显示位数
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
    }
}
/**
 * @brief 显示模式设置 二级菜单
 * @param[in]  back_mode  显示模式 0为日间 1为夜间 2为自动
 */
void AMT630H_GUI_Display_Mode_Setting(uint8_t Display_mode) /*图 显示模式*/
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_256);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0149_448_101);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0152_434_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0150_448_343);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_231);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
            break;
        default:
            break;
        }
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_256);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0336_448_101);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0339_434_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);

            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0337_448_343);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_231);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
            break;
        default:
            break;
        }
    }
}
/**
 * @brief 背光设置 二级菜单
 * @param[in]  back_mode  背光模式 0为自动
 */
void AMT630H_GUI_Backlight_Setting(uint8_t back_mode) /*图 背光*/
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0144_37_396);
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0145_477_340);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_325);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0067_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_229);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0066_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_183);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0064_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_138);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0063_495_145);
            break;

        default:
            break;
        }
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0331_37_396);
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_297);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0332_477_340);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_290);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_239);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0253_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_194);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0252_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_148);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0250_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_103);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0249_495_145);
            break;

        default:
            break;
        }
    }
}
static uint16_t Bluetooth_Connect_num_day[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};

static uint16_t Bluetooth_Connect_num_night[] = {
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289};
/**
 * @brief 蓝牙连接 二级菜单
 * @param[in]  select  0为选择蓝牙连接 1选择同步联系人 2选择返回
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Connect_Setting(uint8_t select, uint8_t sync_contacts, uint8_t Connect_ON)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0137_26_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163);
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
        }
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t ArrivalNumber;
            ArrivalNumber = sync_contacts;
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;   // 图片数组
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
            DisplayNumPara.x = 604;                               // 最右边数字的最左上角的横坐标
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0; // 小数点后位数
            DisplayNumPara.MinDigits = 1;  // 最小显示位数
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t ArrivalNumber;
            ArrivalNumber = sync_contacts;
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;   // 图片数组
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
            DisplayNumPara.x = 612;                               // 最右边数字的最左上角的横坐标
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0; // 小数点后位数
            DisplayNumPara.MinDigits = 2;  // 最小显示位数
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
        }
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0325_26_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_345);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0326_369_287);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0329_367_226);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0330_367_163);
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0328_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0327_584_226);
        }
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t ArrivalNumber;
            ArrivalNumber = sync_contacts;
            DisplayNumPara.NumList = Bluetooth_Connect_num_night; // 图片数组
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
            DisplayNumPara.x = 604;                               // 最右边数字的最左上角的横坐标
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0; // 小数点后位数
            DisplayNumPara.MinDigits = 1;  // 最小显示位数
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t ArrivalNumber;
            ArrivalNumber = sync_contacts;
            DisplayNumPara.NumList = Bluetooth_Connect_num_night; // 图片数组
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14; // 往左排  数字间距
            DisplayNumPara.x = 612;                               // 最右边数字的最左上角的横坐标
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0; // 小数点后位数
            DisplayNumPara.MinDigits = 2;  // 最小显示位数
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ArrivalNumber);
        }
    }
}
/**
 * @brief 单位设置 二级菜单
 * @param[in]  select  0为公制 1为英制
 */
void AMT630H_GUI_Unit_Setting(uint8_t select) /*图 单位设置*/
{

    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0130_27_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0131_435_272);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0132_474_168);
            break;
        default:
            break;
        }
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_27_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0319_435_272);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0320_474_168);
            break;
        default:
            break;
        }
    }
}
/**
 * @brief 语言设置 二级菜单
 * @param[in]  select  0为中文 1为英文
 */
void AMT630H_GUI_Language_Setting(uint8_t select) /*图 语言设置*/
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0129_28_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
            break;
        default:
            break;
        }
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0317_28_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
            break;
        default:
            break;
        }
    }
}

/**
 * @brief 菜单背景
 *
 */
void AMT630H_GUI_BACKGRAND(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0315_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
    }
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0194_23_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
    }
}
/**
 * @brief 手机互联成功 二级菜单
 * @param[in]  NULL
 */
void AMT630H_GUI_Phone_Connect_Win(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0127_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0315_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
    }
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0195_304_155);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
}

void AMT630H_GUI_DisplayProc(void)
{
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);

    AMT630H_GUI_Background();

    PackedTransfer_Page();
}