
#include "Menu.h"
#include "Components.h"
/*-------------------------------------------------------*/

/*-----------------------------------------------------------------*/

/*-------------------Logic_Operation Call Back---------------------*/
uint8_t g_u8Menu_Grade;
uint8_t g_u8Cursor_Posittion;
uint8_t g_u8Language;
uint8_t g_u8Theme;
uint8_t g_u8Blue;
uint8_t g_u8DVR_Set;
uint8_t g_u8Formatting;
uint8_t g_u8Factory;
_Menu_Infor MenuInfor;
void DriveInfo_Service(Menu_Key_en_t enMenuKey);
void QR_ANDROID_Service(Menu_Key_en_t enMenuKey);
void QR_ODS_Service(Menu_Key_en_t enMenuKey);
void SUBJECT_MODE_Service(Menu_Key_en_t enMenuKey);
void UNITS_SETUP_Service(Menu_Key_en_t enMenuKey);
void CLOCK_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_CLASS_Service(Menu_Key_en_t enMenuKey);
void TPMS_STUDY_Service(Menu_Key_en_t enMenuKey);
void LANGUAGE_Service(Menu_Key_en_t enMenuKey);
void BLUE_TOOTH_SETTING_Service(Menu_Key_en_t enMenuKey);
void DVRSET_Service(Menu_Key_en_t enMenuKey);
void VERSION_Service(Menu_Key_en_t enMenuKey);
void FACTORY_RESET_Service(Menu_Key_en_t enMenuKey);
void SUBJECT1_Service(Menu_Key_en_t enMenuKey);
void SUBJECT2_Service(Menu_Key_en_t enMenuKey);
void SUBJECT3_Service(Menu_Key_en_t enMenuKey);
void TIME_12H_Service(Menu_Key_en_t enMenuKey);
void TIME_24H_Service(Menu_Key_en_t enMenuKey);
void TIME_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPE1_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPE2_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPE3_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPE4_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPE5_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_TYPEA_Service(Menu_Key_en_t enMenuKey);
void TPMS_UNIT_Service(Menu_Key_en_t enMenuKey);
void TPMS_STUDYF_Service(Menu_Key_en_t enMenuKey);
void TPMS_STUDYB_Service(Menu_Key_en_t enMenuKey);
void BLUE_LINK_Service(Menu_Key_en_t enMenuKey);
void BLUE_lINKMAN_Service(Menu_Key_en_t enMenuKey);
void BLUE_NAME_Service(Menu_Key_en_t enMenuKey);
void BLUE_OUT_Service(Menu_Key_en_t enMenuKey);
void DVR_SET_Service(Menu_Key_en_t enMenuKey);
void DVR_LOOK_Service(Menu_Key_en_t enMenuKey);
void VERSION2_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_BLACK_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_WHITE_Service(Menu_Key_en_t enMenuKey);
void BACKLIGHT_A_Service(Menu_Key_en_t enMenuKey);
void DVR_SET2_Service(Menu_Key_en_t enMenuKey);
void DVR_NAME_Service(Menu_Key_en_t enMenuKey);
void STORAGE_Service(Menu_Key_en_t enMenuKey);
void FORMATTING_Service(Menu_Key_en_t enMenuKey);
void DVR_LOOK2_Service(Menu_Key_en_t enMenuKey);
void FACTORY_YES_Service(Menu_Key_en_t enMenuKey);
void FACTORY_NO_Service(Menu_Key_en_t enMenuKey);
void FORMATTING_YES_Service(Menu_Key_en_t enMenuKey);
void FORMATTING_NO_Service(Menu_Key_en_t enMenuKey);
/*---------------------------------------------------------------------------------------*/
const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{
	{0, MENU_INTF_DriveInfo,          MENU_ITEM_MAX, 0U,  1U,  1U,  MENU_ITEM_DriveInfo,          MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_STAIR_MENU,         MENU_JUMP_FIRST, MENU_INTERFACE_MAX,     MENU_JUMP_FIRST, MENU_INTERFACE_MAX,  MENU_JUMP_FIRST, DriveInfo_Service          },/**<  行车电脑界面 */
	{0, MENU_INTF_QR_CODE,            MENU_ITEM_MAX, 1U,  1U,  1U,  MENU_ITEM_QR_ANDROID,         MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, QR_ANDROID_Service         },/**<  手机互联安卓 */
	{0, MENU_INTF_QR_CODE,            MENU_ITEM_MAX, 1U,  1U,  1U,  MENU_ITEM_QR_ODS,             MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, QR_ODS_Service             },/**<  手机互联苹果 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 2U,  10U, 10U, MENU_ITEM_SUBJECT_MODE,       MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SUBJECT_MODE,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, SUBJECT_MODE_Service       },/**<  主题模式 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 3U,  10U, 10U, MENU_ITEM_UNITS_SETUP,        MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, UNITS_SETUP_Service        },/**<  单位设置 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 4U,  10U, 10U, MENU_ITEM_CLOCK,              MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK,              MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, CLOCK_Service              },/**<  时钟信息 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 5U,  10U, 10U, MENU_ITEM_BACKLIGHT_CLASS,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BACKLIGHT_CLASS,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_CLASS_Service    },/**<  亮度设置 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 6U,  10U, 10U, MENU_ITEM_TPMS_STUDY,         MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_TPMS_STUDY,         MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TPMS_STUDY_Service         },/**<  胎压学习 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 7U,  10U, 10U, MENU_ITEM_LANGUAGE,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, LANGUAGE_Service           },/**<  语言设置 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 8U,  10U, 10U, MENU_ITEM_BLUE_TOOTH_SETTING, MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BLUE_TOOTH_SETTING, MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BLUE_TOOTH_SETTING_Service },/**<  蓝牙设置 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 9U,  10U, 10U, MENU_ITEM_DVRSET,             MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_DVRSET,             MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVRSET_Service             },/**<  DVR */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 10U, 10U, 10U, MENU_ITEM_VERSION,            MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_VERSION,            MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, VERSION_Service            },/**<  版本信息 */
	{0, MENU_INTF_STAIR_MENU,         MENU_ITEM_MAX, 11U, 10U, 10U, MENU_ITEM_FACTORY_RESET,      MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_FACTORY_RESET,      MENU_JUMP_FIRST, MENU_INTF_DriveInfo,    MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FACTORY_RESET_Service 	  },/**<  恢复出厂设置 */
	{0, MENU_INTF_SUBJECT_MODE,       MENU_ITEM_MAX, 12U, 3U,  3U,  MENU_ITEM_SUBJECT1,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BACKLIGHT_CLASS,    MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, SUBJECT1_Service           },/**<  主题一 */
	{0, MENU_INTF_SUBJECT_MODE,       MENU_ITEM_MAX, 13U, 3U,  3U,  MENU_ITEM_SUBJECT2,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BACKLIGHT_CLASS,    MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, SUBJECT2_Service           },/**<  主题二 */
	{0, MENU_INTF_SUBJECT_MODE,       MENU_ITEM_MAX, 14U, 3U,  3U,  MENU_ITEM_SUBJECT3,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BACKLIGHT_CLASS,    MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, SUBJECT3_Service           },/**<  主题三 */
	{0, MENU_INTF_CLOCK,              MENU_ITEM_MAX, 15U, 3U,  3U,  MENU_ITEM_TIME_12H,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TIME_12H_Service           },/**<  12时制 */
	{0, MENU_INTF_CLOCK,              MENU_ITEM_MAX, 16U, 3U,  3U,  MENU_ITEM_TIME_24H,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TIME_24H_Service           },/**<  24时制 */
	{0, MENU_INTF_CLOCK,              MENU_ITEM_MAX, 17U, 3U,  3U,  MENU_ITEM_TIME,               MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TIME_Service               },/**<  时间调整 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 18U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPE1,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPE1_Service    },/**<  亮度1 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 19U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPE2,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPE2_Service    },/**<  亮度2 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 20U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPE3,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPE3_Service    },/**<  亮度3 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 21U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPE4,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPE4_Service    },/**<  亮度4 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 22U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPE5,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPE5_Service    },/**<  亮度5 */
	{0, MENU_INTF_BACKLIGHT_CLASS,    MENU_ITEM_MAX, 23U, 6U,  6U,  MENU_ITEM_BACKLIGHT_TYPEA,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_TYPEA_Service    },/**<  亮度自动 */
	{0, MENU_INTF_TPMS_STUDY,         MENU_ITEM_MAX, 24U, 3U,  3U,  MENU_ITEM_TPMS_UNIT,          MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TPMS_UNIT_Service          },/**<  胎压单位 */
	{0, MENU_INTF_TPMS_STUDY,         MENU_ITEM_MAX, 25U, 3U,  3U,  MENU_ITEM_TPMS_STUDYF,        MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TPMS_STUDYF_Service        },/**<  前轮学习 */
	{0, MENU_INTF_TPMS_STUDY,         MENU_ITEM_MAX, 26U, 3U,  3U,  MENU_ITEM_TPMS_STUDYB,        MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, TPMS_STUDYB_Service        },/**<  后轮学习 */
	{0, MENU_INTF_BLUE_TOOTH_SETTING, MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_BLUE_LINK,          MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BLUE_LINK_Service          },/**<  蓝牙连接 */
	{0, MENU_INTF_BLUE_TOOTH_SETTING, MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_BLUE_lINKMAN,       MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BLUE_lINKMAN_Service       },/**<  同步联系人 */
	{0, MENU_INTF_BLUE_TOOTH_SETTING, MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_BLUE_NAME,          MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BLUE_NAME_Service          },/**<  蓝牙名称 */
	{0, MENU_INTF_BLUE_TOOTH_SETTING, MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_BLUE_OUT,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_STAIR_MENU,         MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BLUE_OUT_Service           },/**<  蓝牙退出 */
	{0, MENU_INTF_DVRSET,             MENU_ITEM_MAX, 11U, 2U,  2U,  MENU_ITEM_DVR_SET,            MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_DVR_SET,            MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVR_SET_Service            },/**<  DVR设置 */
	{0, MENU_INTF_DVRSET,             MENU_ITEM_MAX, 11U, 2U,  2U,  MENU_ITEM_DVR_LOOK,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_DVR_LOOK,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVR_LOOK_Service           },/**<  DVR回放 */
	{0, MENU_INTF_VERSION,            MENU_ITEM_MAX, 11U, 1U,  1U,  MENU_ITEM_VERSION2,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, VERSION2_Service           },/**<  版本信息子菜单 */
	{0, MENU_INTF_BACKLIGHT_MODE,     MENU_ITEM_MAX, 11U, 3U,  3U,  MENU_ITEM_BACKLIGHT_BLACK,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_SUBJECT_MODE, MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_BLACK_Service    },/**<  黑天模式 */
	{0, MENU_INTF_BACKLIGHT_MODE,     MENU_ITEM_MAX, 11U, 3U,  3U,  MENU_ITEM_BACKLIGHT_WHITE,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_SUBJECT_MODE, MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_WHITE_Service    },/**<  白天模式 */
	{0, MENU_INTF_BACKLIGHT_MODE,     MENU_ITEM_MAX, 11U, 3U,  3U,  MENU_ITEM_BACKLIGHT_A,        MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_SUBJECT_MODE, MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, BACKLIGHT_A_Service        },/**<  自动模式 */
	{0, MENU_INTF_DVR_SET,            MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_DVR_SET2,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVRSET,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVR_SET2_Service           },/**<  DVR设置 */
	{0, MENU_INTF_DVR_SET,            MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_DVR_NAME,           MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVRSET,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVR_NAME_Service           },/**<  记录仪名称 */
	{0, MENU_INTF_DVR_SET,            MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_STORAGE,            MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVRSET,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, STORAGE_Service            },/**<  存储空间 */
	{0, MENU_INTF_DVR_SET,            MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_FORMATTING,         MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_FORMATTING,         MENU_JUMP_FIRST, MENU_INTF_DVRSET,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FORMATTING_Service         },/**<  格式化SD卡 */
	{0, MENU_INTF_DVR_LOOK,           MENU_ITEM_MAX, 11U, 1U,  1U,  MENU_ITEM_DVR_LOOK2,          MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVRSET,       MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, DVR_LOOK2_Service          },/**<  DVR回放子菜单 */
	{0, MENU_INTF_FACTORY_RESET,      MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_FACTORY_YES,        MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FACTORY_YES_Service        },/**<  恢复出厂设置是 */
	{0, MENU_INTF_FACTORY_RESET,      MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_FACTORY_NO,         MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_STAIR_MENU,   MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FACTORY_NO_Service         },/**<  恢复出厂设置否 */
	{0, MENU_INTF_FORMATTING,         MENU_ITEM_MAX, 11U, 4U,  4U,  MENU_ITEM_FORMATTING_YES,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVR_SET,      MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FORMATTING_YES_Service     },/**<  格式化SD卡是 */
	{0, MENU_INTF_FORMATTING,         MENU_ITEM_MAX, 11U, 1U,  1U,  MENU_ITEM_FORMATTING_NO,      MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX,           MENU_JUMP_FIRST, MENU_INTF_DVR_SET,      MENU_JUMP_FIRST, MENU_INTF_DriveInfo, MENU_JUMP_FIRST, FORMATTING_NO_Service      },/**<  格式化SD卡否 */ 
};

/*-------------------------------------------------------------------------------------------------*/

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);
void Menu_Service(Menu_Key_en_t enMenuKey);

/*传入按键动作执行之前需要预先处理的动作*/
static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
{

	/*预处理中执行过本次按键了，后续不必执行时调用一次*/
	/*u8MenuKeyExecute = 0U;*/
}
/*传入按键动作执行之后需要后置处理的动作*/
static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
{
}

/*------------传入按键类型-----------------------*/
void Menu_Service(Menu_Key_en_t enMenuKey)
{
	/*功能回调函数的调用*/
	Menu_Logic_Process(enMenuKey);
	/*--------------------------------------------------*/
	/*按键动作对光标的处理*/
	Menu_Cursor_Preprocess(enMenuKey);
	Menu_Cursor_Process(enMenuKey);
	Menu_Cursor_Postprocess(enMenuKey);
	/*--------------------------------------------------*/
}

/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
//#pragma ghs section bss = ".myNonInitArea"
Menu_uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
//#pragma ghs section bss = default
/*---------------------------------------*/
/*---------------------------------------*/
/*---------------------------------------*/
void DriveInfo_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x00;
	g_u8Cursor_Posittion = 0x00;
	if(enKeyType == MENU_KEY_LEFT_SHORT)
	{
		//切换大计小计
	}
	else if(enKeyType == MENU_KEY_LEFT_LONG)
	{
		//清小计
	}
	if(enKeyType == MENU_KEY_CONFIRM_LONG)
	{
		//长按该返回上一菜单没写此处是进入手机互联
	}
	else if(enKeyType == MENU_KEY_UP_SUPER_LONG)
	{
		//请保养
	}
}
void QR_ANDROID_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0xB1;
	g_u8Cursor_Posittion = 0x01;
}
void QR_ODS_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0xB1;
	g_u8Cursor_Posittion = 0x02;
}
void SUBJECT_MODE_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x10;
	g_u8Cursor_Posittion = 0x00;
}
void UNITS_SETUP_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x20;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.Unit = !MenuInfor.Unit;//切换单位标志
	}
}
void CLOCK_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x30;
	g_u8Cursor_Posittion = 0x00;
}
void BACKLIGHT_CLASS_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x40;
	g_u8Cursor_Posittion = 0x00;
}
void TPMS_STUDY_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x50;
	g_u8Cursor_Posittion = 0x00;
}
void LANGUAGE_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x60;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		if(g_u8Language == 1u)
		{
			g_u8Language = 2;
		}
		else
		{
			g_u8Language = 1;
		}
	}
}
void BLUE_TOOTH_SETTING_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x70;
	g_u8Cursor_Posittion = 0x00;	
}
void DVRSET_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x80;
	g_u8Cursor_Posittion = 0x00;
}
void VERSION_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x90;
	g_u8Cursor_Posittion = 0x00;
}
void FACTORY_RESET_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0xA0;
	g_u8Cursor_Posittion = 0x00;
}  
void SUBJECT1_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x11;
	g_u8Cursor_Posittion = 1u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Theme = g_u8Cursor_Posittion;
	}
	
}
void SUBJECT2_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x11;
	g_u8Cursor_Posittion = 2u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Theme = g_u8Cursor_Posittion;
	}
}
void SUBJECT3_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x11;
	g_u8Cursor_Posittion = 3u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Theme = g_u8Cursor_Posittion;
	}
}
void TIME_12H_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x31;
	g_u8Cursor_Posittion = 0x00u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Theme = !g_u8Cursor_Posittion;
	}
}
void TIME_24H_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x31;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Theme = !g_u8Cursor_Posittion;
	}
}
void TIME_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x31;
	g_u8Cursor_Posittion = 0x02u;
	//亮灭逻辑没写
}
void BACKLIGHT_TYPE1_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_1;
	}
}
void BACKLIGHT_TYPE2_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x02u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_2;
	}
}
void BACKLIGHT_TYPE3_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x03u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_3;
	}
}
void BACKLIGHT_TYPE4_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x04u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_4;
	}
}
void BACKLIGHT_TYPE5_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x05u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_5;
	}
}
void BACKLIGHT_TYPEA_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x41;
	g_u8Cursor_Posittion = 0x06u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLight_Val = BackLight_Val_A;
	}
}
void TPMS_UNIT_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x51;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		//胎压单位进行顺序切换
	}
}
void TPMS_STUDYF_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x51;
	g_u8Cursor_Posittion = 0x02u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		//前胎压学习状态位
	}
	else if(enKeyType == MENU_KEY_DOWN_SUPER_LONG)
	{
		//解除胎压学习
	}
}
void TPMS_STUDYB_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x51;
	g_u8Cursor_Posittion = 0x03u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		//后胎压学习状态位
	}
	else if(enKeyType == MENU_KEY_DOWN_SUPER_LONG)
	{
		//解除胎压学习
	}
}
void BLUE_LINK_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x71;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		if(g_u8Blue == 1u)
		{
			g_u8Blue = 2;
		}
		else
		{
			g_u8Blue = 1u;
		}
	}
}
void BLUE_lINKMAN_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x71;
	g_u8Cursor_Posittion = 0x02u;
}
void BLUE_NAME_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x71;
	g_u8Cursor_Posittion = 0x03u;
}
void BLUE_OUT_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x71;
	g_u8Cursor_Posittion = 0x01u;
}
void DVR_SET_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x81;
	g_u8Cursor_Posittion = 0x01u;
}
void DVR_LOOK_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x81;
	g_u8Cursor_Posittion = 0x02u;
}
void VERSION2_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x91;
	g_u8Cursor_Posittion = 0x00u;
}
void BACKLIGHT_BLACK_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x12;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLightMode = g_u8Cursor_Posittion;
	}
}
void BACKLIGHT_WHITE_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x12;
	g_u8Cursor_Posittion = 0x02u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLightMode = g_u8Cursor_Posittion;
	}
}
void BACKLIGHT_A_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x12;
	g_u8Cursor_Posittion = 0x03u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuInfor.BackLightMode = g_u8Cursor_Posittion;
	}
}
void DVR_SET2_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x82;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		if(g_u8DVR_Set == 1u)
		{
			g_u8DVR_Set = 2;
		}
		else
		{
			g_u8DVR_Set = 1u;
		}
	}
}
void DVR_NAME_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x82;
	g_u8Cursor_Posittion = 0x02u;
}
void STORAGE_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x82;
	g_u8Cursor_Posittion = 0x03u;
}
void FORMATTING_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x82;
	g_u8Cursor_Posittion = 0x04u;
}
void DVR_LOOK2_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x84;
	g_u8Cursor_Posittion = 0x00u;
}
void FACTORY_YES_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0xA1;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Factory = g_u8Cursor_Posittion;
	}
}
void FACTORY_NO_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0xA1;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Factory = g_u8Cursor_Posittion;
	}
}
void FORMATTING_YES_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x84;
	g_u8Cursor_Posittion = 0x01u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Formatting = g_u8Cursor_Posittion;
	}
}
void FORMATTING_NO_Service(Menu_Key_en_t enKeyType)
{
	g_u8Menu_Grade = 0x84;
	g_u8Cursor_Posittion = 0x02u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		g_u8Formatting = g_u8Cursor_Posittion;
	}
}