#ifndef KEY_USER_H__
#define KEY_USER_H__

#include "Key\Key.h"
#include "common.h"
#include "rtc.h"

typedef struct 
{
   uint16_t  Back_Time_Left;
   uint16_t  Back_Time_Right;
   uint8_t   Back_Time_Right_Flag;
   uint8_t   Back_Time_Left_Flag;
   uint16_t  Tpms_F_Learning_Time;
   uint16_t  Tpms_R_Learning_Time;
   uint16_t  Tpms_F_Learn_Succeed_Flag;
   uint16_t  Tpms_R_Learn_Succeed_Flag;
   uint8_t   BackLight_Val;
   uint8_t   BackLightMode;
   uint8_t   Unit;
}_Menu_Infor;

typedef enum
{
    BackLight_Val_1 = 1,
    BackLight_Val_2,
    BackLight_Val_3,
    BackLight_Val_4,
    BackLight_Val_5,
    BackLight_Val_A,
}_BackLight_Val_Type;

typedef struct 
{
   uint8_t   Set_Hour;
   uint8_t   Set_Minute;
   uint8_t   Dis_Hour;
   uint8_t   Dis_Minute;
   uint8_t   Unit;
}_Menu_Data;

typedef enum
{
   Page_Time = 0,
   Page_Time_Set_Hour,
   Page_Time_Set_Minute,

	Page_Max,
}_Page_Type;


extern uint8_t PageType;
extern uint8_t Key_Right_Long_Press_Flag;
extern uint8_t Key_Left_Long_Press_Flag;
extern uint8_t ClearODO_Flag;
extern uint8_t g_u8Menu_Grade;
extern uint8_t g_u8Cursor_Posittion;
extern uint8_t g_u8Language;
extern uint8_t g_u8Theme;
extern uint8_t g_u8Blue;
extern uint8_t g_u8DVR_Set;
extern uint8_t g_u8Formatting;
extern uint8_t g_u8Factory;
extern _Menu_Infor MenuInfor;
extern RTC_CounterTypeDef counter_val;
extern void Key_KL30_Init_EXample(void);
extern void Key_Wakeup_Init_EXample(void);

void Key_Operation_Right(Key_Event_en_t enKeyEvent);
void Key_Operation_Left(Key_Event_en_t enKeyEvent);
Key_Status_en_t Key_Status_Read_Left(void);
Key_Status_en_t Key_Status_Read_Right(void);

void Key_Auto_Save(void);
uint8_t Get_Dis_Hour_Time(void);
uint8_t Get_Dis_Minute_Time(void);
uint8_t Get_Current_PageType(void);
void TYW_RESET_ODO(void);
uint8_t Get_Dis_Unit(void);
void Key_Check_Service(void);
void MenuData_Unit_Init(void);
#endif
