#include "Components.h"

uint8_t OTA_Update_Count_Open = 0;
uint8_t OTA_Update_Count_Close = 0;
uint8_t Update_Graphic_Count = 0;
uint8_t GetBlueToothVaild = 0;
uint8_t GetPhoneBookVaild = 0;
uint8_t TextInit = 0;
uint8_t SetUUIDTimes = 0;
uint16_t LastPhoneBookTotalCount = 0;
_PICID_Struct PicObj;
_QRCODE_RECT QRCode_Rect;
const uint8_t HJBlueToothName[9]= {"HJ750"};
uint8_t UUIDConfigBuf[21] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
//007502024092400000002
//0x30,0x30,0x37,0x35,0x30,0x32,0x30,0x32,0x34,0x30,0x39,0x32,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31
uint8_t SetBluetoothCloseCount = 0;
uint8_t OSVersionASCLLList[20] =
{
    0x56,0x00,
    0x30,0x00,
    0x30,0x00,
    0x2E,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
};
uint8_t MCUVersionASCLLList[26] =
{
    0x56,0x00,
    0x30,0x00,
    0x30,0x00,
    0x2E,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
    0x30,0x00,
};

void TextService(void);

void BlueToothService(void)
{
    if(SYS_OPR_STAT_IGN_ON)
    {
        if(Get_Dis_Bluetooth_Open_Close() == 0)
        {
            if(GetBlueToothVaild == 0)
            {
                SetBluetoothTurnXX(1);
                GetBlueToothVaild = 1;
            }
        }
        else
        {
            if(GetBlueToothVaild == 1)
            {
                if(SetBluetoothCloseCount < 30)
                {
                    SetBluetoothTurnXX(0);
                }
                else
                {
                    GetBlueToothVaild = 0;
                    SetBluetoothCloseCount = 0;
                }
                SetBluetoothCloseCount++;
            }
        }

        if ((BlueToothPhoneData.BlueToothSignalSate == BlueTooth_Connection)&&(GetPhoneBookVaild == 0))
        {
            PackedTransfer_GetPhoneBookCmd();
            GetPhoneBookVaild = 1;
        }
        else if (BlueToothPhoneData.BlueToothSignalSate == BlueTooth_DisConnect)
        {
            GetPhoneBookVaild = 0;
        }

        if((BlueToothPhoneData.BlueToothPhoneSate == Phone_Outgoing) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Incoming) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Talking))
        {
            if(g_u8Cursor_Posittion == MENU_ITEM_PHONE_CONNECT_APP)/*导航界面*/
            {
                ;
            }
            else/*非导航界面*/
            {
                Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION,MENU_ITEM_MAIN_ITEM);
            }
            
        }
        for (uint8_t i = 0; i < 21; i++)
        {
            UUIDConfigBuf[i] = Diag_Write_Data.DID_5000[i];
        }
        SetUUIDData((char *)UUIDConfigBuf, 21);
        if (OTA_Update_Flag == 1) 
        {
            QRCode_Rect.x = 650;
            QRCode_Rect.y = 210;
        }
        else 
        {
            QRCode_Rect.x = QRCode_X;
            QRCode_Rect.y = QRCode_Y;
        }
        // QRCode_Rect.x = 650;
        // QRCode_Rect.y = 210;
        QRCode_Rect.height = 240;
        QRCode_Rect.width = 240;
        SetScreenType(QRCode_TYPE, QRCode_Rect);
        // if(Menu_Get_Current_Cursor_Information() != MENU_ITEM_FAULT_INFORMATION)
        // {
        //     OTA_Update_Flag = 0;
        // }
        if(OTA_Update_Flag == 1)
        {
            if(OTA_Update_Count_Open < 5)
            {
                SetUpdateCtrl(1,QRCode_Rect);
                OTA_Update_Count_Open++;
            }  
            OTA_Update_Count_Close = 0;
        }
        else
        {
            if(OTA_Update_Count_Close < 5)
            {
                SetUpdateCtrl(0,QRCode_Rect);
                OTA_Update_Count_Close++;
            } 
            OTA_Update_Count_Open=0;
        }
        SetTaskbarHeight(130);
        SetBlueToothName((uint8_t *)HJBlueToothName, sizeof(HJBlueToothName));
        TextService();
    }    
    else
    {
        GetBlueToothVaild =0;
        OTA_Update_Flag = 0;
        SetBluetoothTurnXX(0);
        SetUpdateCtrl(0,QRCode_Rect);
    }

}

TEXT_STRUCT TextPara[TEXT_NUM_TOTAL] = 
{
    {TEXT_NUM_BLUETOOTH_NAME,           0x4005, 0},
    {TEXT_NUM_BLUETOOTH_PHONENAME,      0x4007, 0},
    {TEXT_NUM_PHONE_NUMBER,             0x4009, 0},
    {TEXT_NUM_PHONE_NUMBER_TOTAL,       0x4011, 0},
    {TEXT_NUM_INFORMATION_MCUVER,       0x4012, 0},
    {TEXT_NUM_INFORMATION_SWVERSION,    0x4013, 0},
    {TEXT_NUM_INFORMATION_UUID,         0x4014, 0}, 
    {TEXT_NUM_INFORMATION_OS,           0x4015, 0},
    {TEXT_NUM_INFORMATION_MCU,          0x4016, 0},
    {TEXT_NUM_FAUULT_CODE,              0x4022, 0},

};

uint8_t PhoneNumber[40];
uint8_t LastPhoneNumber[20];
uint8_t LastBlueToothPhoneName[100];
uint8_t CurBlueToothPhoneName[100];
uint8_t BlueToothName[40];
uint8_t LastBlueToothName[20];
uint8_t PhoneNumberTotal[20];
uint8_t InformationOSVersion[20];
uint8_t InformationMCUVersion[26];
uint8_t TextFaultCodeNum[10];
uint8_t UUIDDisplay[42];
uint8_t LastUUIDDisplay[21];

void TextService(void) 
{
    if(TextInit == 0)
    {
        TextInit = 1;

        OSVersionASCLLList[0] = DATA_Version[0];
        OSVersionASCLLList[2] = DATA_Version[1];
        OSVersionASCLLList[4] = DATA_Version[2];
        OSVersionASCLLList[6] = DATA_Version[3];
        OSVersionASCLLList[8] = DATA_Version[4];
        OSVersionASCLLList[10] = DATA_Version[5];
        OSVersionASCLLList[12] = DATA_Version[6];
        OSVersionASCLLList[14] = DATA_Version[7];
        OSVersionASCLLList[16] = 0x48;
        OSVersionASCLLList[18] = 0x4A;

        MCUVersionASCLLList[0] = DATA_Version[0];
        MCUVersionASCLLList[2] = DATA_Version[1];
        MCUVersionASCLLList[4] = DATA_Version[2];
        MCUVersionASCLLList[6] = DATA_Version[3];
        MCUVersionASCLLList[8] = DATA_Version[4];
        MCUVersionASCLLList[10] = DATA_Version[5];
        MCUVersionASCLLList[12] = DATA_Version[6];
        MCUVersionASCLLList[14] = DATA_Version[7];
        MCUVersionASCLLList[16] = 0x2E;
        MCUVersionASCLLList[18] = SW_Version[0];
        MCUVersionASCLLList[20] = 0x2E;
        MCUVersionASCLLList[22] = SW_Version[1];
        MCUVersionASCLLList[24] = SW_Version[2];


        memset(InformationOSVersion, 0, sizeof(InformationOSVersion));
        memset(InformationMCUVersion, 0, sizeof(InformationMCUVersion));
        memset(PhoneNumber, 0, sizeof(PhoneNumber));
        memset(LastPhoneNumber, 0, sizeof(LastPhoneNumber));
        memset(LastBlueToothPhoneName, 0, sizeof(LastBlueToothPhoneName));
        memset(CurBlueToothPhoneName, 0, sizeof(CurBlueToothPhoneName));
        memset(BlueToothName, 0, sizeof(BlueToothName));
        memset(LastBlueToothName, 0, sizeof(LastBlueToothName));
        memset(PhoneNumberTotal, 0, sizeof(PhoneNumberTotal));
        memset(TextFaultCodeNum, 0, sizeof(TextFaultCodeNum));
        memset(LastUUIDDisplay, 0, sizeof(LastUUIDDisplay));
        memset(UUIDDisplay, 0, sizeof(UUIDDisplay));

        for (uint8_t i = 0; i < sizeof(OSVersionASCLLList); i++)
        {
            InformationOSVersion[i] = OSVersionASCLLList[i];
        }
        TextPara[TEXT_NUM_INFORMATION_OS].Vaild = 0x01;

        for (uint8_t i = 0; i < sizeof(MCUVersionASCLLList); i++)
        {
            InformationMCUVersion[i] = MCUVersionASCLLList[i];
        }
        TextPara[TEXT_NUM_INFORMATION_MCU].Vaild = 0x01;
    }
    if (BlueToothPhoneData.BlueToothSignalSate == BlueTooth_Connection) 
    {
        if ((BlueToothPhoneData.BlueToothPhoneSate == Phone_Outgoing) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Incoming) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Talking)) {
            if ((memcmp(LastBlueToothPhoneName, BlueToothPhoneData.BlueToothPhoneName, sizeof(LastBlueToothPhoneName))) != 0) 
            {
                for (uint8_t i = 0; i < (sizeof(BlueToothPhoneData.BlueToothPhoneName) / 2); i++) 
                {
                    CurBlueToothPhoneName[i * 2] = BlueToothPhoneData.BlueToothPhoneName[(i * 2) + 1];
                    CurBlueToothPhoneName[(i * 2) + 1] = BlueToothPhoneData.BlueToothPhoneName[i * 2];
                }
                memcpy(LastBlueToothPhoneName, BlueToothPhoneData.BlueToothPhoneName, (sizeof(BlueToothPhoneData.BlueToothPhoneName) / sizeof(BlueToothPhoneData.BlueToothPhoneName[0])));
                TextPara[TEXT_NUM_BLUETOOTH_PHONENAME].Vaild = 0X01;
            }
            if ((memcmp(LastPhoneNumber, BlueToothPhoneData.PhoneNumber, sizeof(LastPhoneNumber))) != 0) 
            {
                for (uint8_t i = 0; i < sizeof(BlueToothPhoneData.PhoneNumber); i++) 
                {
                    PhoneNumber[i * 2] = (uint8_t)(BlueToothPhoneData.PhoneNumber[i]);
                    PhoneNumber[(i * 2) + 1] = 0X00;
                }
                memcpy(LastPhoneNumber, BlueToothPhoneData.PhoneNumber, (sizeof(BlueToothPhoneData.PhoneNumber) / sizeof(BlueToothPhoneData.PhoneNumber[0])));
                TextPara[TEXT_NUM_PHONE_NUMBER].Vaild = 0X01;
            }
        }
    }
    // if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_CONNECT)
    // {
        if (memcmp(LastBlueToothName, BlueToothPhoneData.BlueToothName, sizeof(LastBlueToothName)) != 0)
        {
            for (uint8_t i = 0; i < sizeof(BlueToothPhoneData.BlueToothName); i++)
            {
                BlueToothName[i * 2] = BlueToothPhoneData.BlueToothName[i];
                BlueToothName[(i * 2) + 1] = 0X00;
            }
            memcpy(LastBlueToothName, BlueToothPhoneData.BlueToothName, sizeof(LastBlueToothName));
            TextPara[TEXT_NUM_BLUETOOTH_NAME].Vaild = 0X01;
        }
    // }
    if (LastPhoneBookTotalCount != BlueToothPhoneData.PhoneBookTotalCount)
    {
        uint8_t TempNumberCnts = 0;
        if (BlueToothPhoneData.PhoneBookTotalCount > 100)
        {
            PhoneNumberTotal[TempNumberCnts++] = (BlueToothPhoneData.PhoneBookTotalCount / 100) + 0x30;
            PhoneNumberTotal[TempNumberCnts++] = 0x00;
        }
        if (BlueToothPhoneData.PhoneBookTotalCount > 10)
        {
            PhoneNumberTotal[TempNumberCnts++] = (BlueToothPhoneData.PhoneBookTotalCount / 10 % 10) + 0x30;
            PhoneNumberTotal[TempNumberCnts++] = 0x00;
        }
        PhoneNumberTotal[TempNumberCnts++] = (BlueToothPhoneData.PhoneBookTotalCount % 100 % 10) + 0x30;
        PhoneNumberTotal[TempNumberCnts++] = 0x00;
        TextPara[TEXT_NUM_PHONE_NUMBER_TOTAL].Vaild = 0x01;
        LastPhoneBookTotalCount = BlueToothPhoneData.PhoneBookTotalCount;
    }
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_402_Msg_Count) == CAN_SIG_LOST)
    {
        ;
    }
    else
    {
        uint8_t FaultCodeNumCnts = 0;
        uint8_t FaultCodeHighNum = 0;
        uint8_t FaultCodeMidNum = 0;
        FaultCodeHighNum = Get_Current_Hight_FaultCode();
        FaultCodeMidNum = Get_Current_Mid_FaultCode();
        TextFaultCodeNum[FaultCodeNumCnts++] = 0x50;
        TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        if((((FaultCodeHighNum)&(0xF0)) >> 4)<10)
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = (((FaultCodeHighNum)&(0xF0)) >> 4) + 0x30;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        else
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = ((((FaultCodeHighNum)&(0xF0)) >> 4) % 10) + 0x41;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        if((((FaultCodeHighNum)&(0x0F)))<10)
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = ((FaultCodeHighNum)&(0x0F)) + 0x30;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        else
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = (((FaultCodeHighNum)&(0x0F)) % 10) + 0x41;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }

        if((((FaultCodeMidNum)&(0xF0)) >> 4)<10)
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = (((FaultCodeMidNum)&(0xF0)) >> 4) + 0x30;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        else
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = ((((FaultCodeMidNum)&(0xF0)) >> 4) % 10) + 0x41;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        if((((FaultCodeMidNum)&(0x0F)))<10)
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = ((FaultCodeMidNum)&(0x0F)) + 0x30;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        else
        {
            TextFaultCodeNum[FaultCodeNumCnts++] = (((FaultCodeMidNum)&(0x0F)) % 10) + 0x41;
            TextFaultCodeNum[FaultCodeNumCnts++] = 0x00;
        }
        TextPara[TEXT_NUM_FAUULT_CODE].Vaild = 0x01;
    }
    if (((memcmp(LastUUIDDisplay, UUIDConfigBuf, sizeof(LastUUIDDisplay))) != 0))
    {
        for (uint8_t i = 0; i < (sizeof(UUIDConfigBuf)); i++)
        {
            UUIDDisplay[i * 2] = UUIDConfigBuf[i];
            UUIDDisplay[(i * 2) + 1] = 0x00;
        }
        memcpy(LastUUIDDisplay, UUIDConfigBuf, sizeof(LastUUIDDisplay));
        TextPara[TEXT_NUM_INFORMATION_UUID].Vaild = 0X01;
    }
}

uint8_t Get_Talking_PhoneBookValid(void)
{
    for(uint8_t i=0;i<100;i++)
    {
        if(CurBlueToothPhoneName[i]!=0)
        {
            return 1;
        }
    }
    return 0;
}

uint8_t Get_UUID_UDSStatus(void)
{
    for(uint8_t i=0;i<21;i++)
    {
        if(UUIDConfigBuf[i]!=0xFF)
        {
            return 1;
        }
    }
    return 0;
}


