

#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_In\Line_In_user.h"
#include "Components.h"

static Tellib_uint16_t LED_Turn_Left_Judgement(void);
static void            LED_Turn_Left_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Turn_Right_Judgement(void);
static void            LED_Turn_Right_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_High_Beam_Judgement(void);
static void            LED_High_Beam_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Efi_Fault_Judgement(void);//电喷故障灯
static void            LED_Efi_Fault_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ABS_Judgement(void);
static void            LED_ABS_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Auto_Start_Stop_Judgement(void);
static void            LED_Auto_Start_Stop_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Oil_Pressure_Alert_Judgement(void);
static void            LED_Oil_Pressure_Alert_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_TCS_Judgement(void);
static void            LED_TCS_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_HEV_Judgement(void);
static void            LED_HEV_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Voltage_Judgement(void);
static void            LED_Voltage_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fuel_Level_Low_Judgement(void);
static void            LED_Fuel_Level_Low_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Coolant_Temperature_Judgement(void);
static void            LED_Coolant_Temperature_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_WIFI_Judgement(void);
static void            LED_WIFI_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Bluetooth_Judgement(void);
static void            LED_Bluetooth_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_E_Judgement(void);
static void            LED_E_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_S_Judgement(void);
static void            LED_S_Execution(Tellib_uint16_t led_status);
uint8_t u8CanId401Flag = 0;
const LED_Attribute_st LED_Attribute [ LED_Max ] = {
    /*  指示灯索引                  是否自检          外部信号自检           工作电源状态       自检开始时间    自检持续时间       指示灯点亮条件                           指示灯执行函数               */
    
    {em_LED_Turn_Left,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Turn_Left_Judgement,            LED_Turn_Left_Execution                },
    {em_LED_Turn_Right,           SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Turn_Right_Judgement,           LED_Turn_Right_Execution               },
    {em_LED_High_Beam,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_High_Beam_Judgement,            LED_High_Beam_Execution                },
    {em_LED_Efi_Fault,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Efi_Fault_Judgement,            LED_Efi_Fault_Execution                },    
    {em_LED_ABS,                  SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_ABS_Judgement,                  LED_ABS_Execution                      },
    {em_LED_Auto_Start_Stop,      SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Auto_Start_Stop_Judgement,      LED_Auto_Start_Stop_Execution          },
    {em_LED_Oil_Pressure_Alert,   SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Oil_Pressure_Alert_Judgement,   LED_Oil_Pressure_Alert_Execution       },
    {em_LED_TCS,                  SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_TCS_Judgement,                  LED_TCS_Execution                      },
    {em_LED_HEV,                  SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_HEV_Judgement,                  LED_HEV_Execution                      },
    {em_LED_Voltage,              SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Voltage_Judgement,              LED_Voltage_Execution                  },
    {em_LED_Fuel_Level_Low,       SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Fuel_Level_Low_Judgement,       LED_Fuel_Level_Low_Execution           },
    {em_LED_Coolant_Temperature,  SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Coolant_Temperature_Judgement,  LED_Coolant_Temperature_Execution      },
    {em_LED_WIFI,                 SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_WIFI_Judgement,                 LED_WIFI_Execution                     },
    {em_LED_Bluetooth,            SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_Bluetooth_Judgement,            LED_Bluetooth_Execution                },
    {em_LED_E,                    SelfCheck,     NoExterNalCheck,        LED_IGN_ON,             0u,         3000ul,         LED_E_Judgement,                    LED_E_Execution                        },
};
Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];
 void Telltales_Init(void)
 {
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk  = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk          = Common_Get_IG_Sts;
    u8CanId401Flag = 0;
    Telltales_KL30_Wakeup_Init(Tel_Mem, LED_Attribute, &m_ExtPara);
 }
void Can_ID_401(uint8_t CopyData [])
{
    u8CanId401Flag = 1;
}



/*硬线－P10 高电平点亮*/
static Tellib_uint16_t LED_Turn_Left_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Turn_Left))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Turn_Left_Execution(Tellib_uint16_t led_status)
{
   
}


/*硬线－P9 高电平点亮*/
static Tellib_uint16_t LED_Turn_Right_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Turn_Right))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Turn_Right_Execution(Tellib_uint16_t led_status)
{
   
}


/*硬线－P18 高电平点亮*/
static Tellib_uint16_t LED_High_Beam_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_High_Beam))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_High_Beam_Execution(Tellib_uint16_t led_status)
{
   
}

/*硬线-P15 低电平点亮*/
static Tellib_uint16_t LED_Efi_Fault_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Efi_Fault) == 0u)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}
static void LED_Efi_Fault_Execution(Tellib_uint16_t led_status)
{
   
}


/*硬线-P7 悬空/高点亮 接地灭*/
static Tellib_uint16_t LED_ABS_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_ABS) == 0)
    {
        LED_STATE = 0;
    }
    else
    {
        LED_STATE = 1;
    }
    return LED_STATE;
}
static void LED_ABS_Execution(Tellib_uint16_t led_status)
{

}

/*硬线－P12 低电平*/
static Tellib_uint16_t LED_Auto_Start_Stop_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Auto_Start_Stop) == 0)
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Auto_Start_Stop_Execution(Tellib_uint16_t led_status)
{
   
}


/*硬线－P21 低电平点亮*/
static Tellib_uint16_t LED_Oil_Pressure_Alert_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Oil_Pressure_Alert) == 0)
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Oil_Pressure_Alert_Execution(Tellib_uint16_t led_status)
{
  
}

/*
*@name:TCS指示灯
*@return: 0-都不亮 1-TCS亮 2-TCS/亮 3-TCS闪烁 
*/
static Tellib_uint16_t LED_TCS_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_37B_Msg_Count) == CAN_SIG_LOST)
    {
       LED_STATE = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_37B_Sig_TCS_Work_Mode == 0x0)
        {
            if(Get_CAN_CH0_ID_37B_Sig_TCS_Warning_Lamp() == 0x1)
            {
                LED_STATE = 1u;/*TCS灯亮*/
            }
            else
            {
                LED_STATE = 0u;/*都不亮*/
            }
        }
        else
        {
            if(Get_CAN_CH0_ID_37B_Sig_TCS_Warning_Lamp() == 0x1)
            {
                LED_STATE = 2u;/*TCS/亮*/
            }
            else
            {
                ;
            } 
        } 
    }
    return LED_STATE;
}
static void LED_TCS_Execution(Tellib_uint16_t led_status)
{
   
}


/*
*信号来源：ISG_111
*/
static Tellib_uint16_t LED_HEV_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_111_Msg_Count) == CAN_SIG_LOST)
    {
       LED_STATE = 0u;
    }
    else
    {
        if((Get_CAN_CH0_ID_111_Sig_ISG_Ready() == 0x01UL)||((Get_CAN_CH0_ID_111_Sig_ISG_Power() == 1u)&&(Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable() == 0u)))
        {
            LED_STATE = 1u;
        }
        else if((Get_CAN_CH0_ID_111_Sig_ISG_Ready() == 0UL)||(Get_CAN_CH0_ID_111_Sig_ISG_Power() == 0u)||(Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable() == 0u))
        {
            LED_STATE = 0u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    return LED_STATE;
}
static void LED_HEV_Execution(Tellib_uint16_t led_status)
{
   ;
}


/*硬线-P19 电压值*/
static Tellib_uint16_t LED_Voltage_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Voltage))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Voltage_Execution(Tellib_uint16_t led_status)
{
  ;
}


/*硬线P14－阻值*/
static Tellib_uint16_t LED_Fuel_Level_Low_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Line_In_Get_Status(LINE_IN_Fuel_Level_Low))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Fuel_Level_Low_Execution(Tellib_uint16_t led_status)
{
   
}


/*信号来源：ECU_101 +硬线-P11 阻值 CAN>硬线*/
static Tellib_uint16_t LED_Coolant_Temperature_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_101_Msg_Count) == CAN_SIG_LOST)
    {
        LED_STATE = 0u;
        if(Line_In_Get_Status(LINE_IN_Coolant_Temperature))
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        if(Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State() == 0x01UL)
        {
          LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    return LED_STATE;
}
static void LED_Coolant_Temperature_Execution(Tellib_uint16_t led_status)
{
  
}


/*wifi*/
static Tellib_uint16_t LED_WIFI_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;/*设置为常灭*/
    return LED_STATE;
}
static void LED_WIFI_Execution(Tellib_uint16_t led_status)
{
    ;
}

/*bluetooth*/
static Tellib_uint16_t LED_Bluetooth_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    return LED_STATE;
}
static void LED_Bluetooth_Execution(Tellib_uint16_t led_status)
{
   ;
}


/*
* E S指示灯
*信号来源：0x111
* 0-都不亮  1-E亮 2-S亮
*/
static Tellib_uint16_t LED_E_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_111_Msg_Count) == CAN_SIG_LOST)
    {
       LED_STATE = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_111_Sig_ISG_Power() == 0x01UL)
        {
            if(Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable() == 1u)
            {
                LED_STATE = 1u;
            }
            else if(Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable() == 2u)
            {
                LED_STATE = 2u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    return LED_STATE;
}
static void LED_E_Execution(Tellib_uint16_t led_status)
{
   ;
}

