#ifndef AMT_630H_H
#define AMT_630H_H
#include <stdint.h>

typedef enum
{
    EM_FLASH_CHECK_RESULT_NO_ACT = 0,
    EM_FLASH_CHECK_RESULT_CHECKING,
    EM_FLASH_CHECK_RESULT_SUCCESS,
    EM_FLASH_CHECK_RESULT_FAIL,
}EM_FLASH_CHECK_RESULT_T;

typedef struct __attribute__((aligned(4)))
{
    uint8_t Flag;
    uint32_t InquireTime;
    uint32_t CheckStateTime;
    uint8_t Result;
}s_AMT630H_FlashCheck_t;

#define AMT630H_REFRESH_TIME        50U

#define AMT630H_ANIMATION_TIME                  4000U   //ms
#define AMT630H_ANIMATION_PIC_NUM               77U
#define AMT630H_ANIMATION_REFRESHTIME_DEF(x)    ((AMT630H_ANIMATION_TIME > x) ? \
                                                (((AMT630H_ANIMATION_TIME - x) / AMT630H_ANIMATION_PIC_NUM) - 5) : \
                                                (((AMT630H_ANIMATION_TIME) / AMT630H_ANIMATION_PIC_NUM) - 5)) 


void AMT630H_Timer(unsigned char Tms);
void Delay_Time_Ctrl(unsigned long Tms);
void Amt630hUartRecvData(uint16_t u16UARTData);
void AMT630H_Animation_PlayProc(uint16_t PicIndex);
void AMT630H_RstCtrl(void);
void Amt630hInit(void);
void AMT630H_Sleep(void);
static void AMT630H_AliveCounterMonitor(void);
void AMT630H_Main(void);
unsigned char AMT630H_isInitFinish(void);
unsigned char AMT630H_Animation_Finish_Flage(void);
void AMT630H_Animation_IGON(void);

#endif
