
#include "Line_In_user.h"
#include "Components.h"


const Line_In_Attribute_st g_stLineInAttribute[LINE_IN_MAX] =
{
    {LEVEL_LOW,   LEVEL_HIGH,    LINE_IN_IG_ON,     20U,  20U,  Get_LINE_IN_Turn_Left,        },/*P10*/
    {LEVEL_LOW,   LEVEL_HIGH,    LINE_IN_IG_ON,     20U,  20U,  Get_LINE_IN_Turn_Right,       },/*P9*/
    {LEVEL_LOW,   LEVEL_HIGH,    LINE_IN_IG_ON,     40U,  20U,  Get_LINE_IN_High_Beam,        },/*P18*/
    {LEVEL_HIGH,  LEVEL_LOW,     LINE_IN_IG_ON,     125U, 20U,  Get_LINE_IN_Efi_Fault,          },/*P15*/
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     125U,  0U,  Get_LINE_IN_ABS,              },/*P7*/
    {LEVEL_HIGH,    LEVEL_LOW,   LINE_IN_IG_ON,     125U,  20U,  Get_LINE_IN_Auto_Start_Stop,  },/*P12*/
    {LEVEL_HIGH,    LEVEL_LOW,   LINE_IN_IG_ON,     2000U,  20U,  Get_LINE_IN_Oil_Pressure_Alert, },/*P21*/
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     125U,  20U,  Get_LINE_IN_Coolant_Temperature }, /*P11*/
};
Linelib_uint8_t Get_LINE_IN_Turn_Left(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(LeftTurn_MUC_OUT))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Turn_Right(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(RightTurn_MUC_OUT))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_High_Beam(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(HighBeam_MCU))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Efi_Fault(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(MAINTENANCE_LAMP_OUT))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_ABS(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(ABS_Faulty_lights))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Auto_Start_Stop(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(Start_stop_MCU))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Oil_Pressure_Alert(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(MCU_SPI_MOSI))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Coolant_Temperature(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(A_WaterTemp_IN))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}



__align(4)
Linelib_uint8_t LINE_IN_Men[LINE_IN_MAX * LINE_IN_BLOCK_SIZE];

static Linelib_uint16_t LINE_GET_PWR(void)
{
    Linelib_uint16_t Res;
    Res = Common_Get_IG_Sts() & 0x00FFu;
    return Res;
}

void LINE_IN_Init(void)
{
    Line_In_KL30_WakeUp_Init(LINE_IN_Men, g_stLineInAttribute, LINE_IN_MAX, LINE_GET_PWR);
}
