#include "stddef.h"
#include "RTE_Components.h"
#include "BAT32A279.h"
#include "RTE_CLOCK_Select.h"
#include "cgc.h"
#include "delay.h"
#include "core_cm0plus.h"
#define USED_FX_FCLK
//#define USED_FHOCO_FCLK
uint32_t RTE_SystemCoreClock; 
extern uint32_t SystemCoreClock; 
void RTE_CLOCK_Select_Start(void)
{


#ifdef USED_FX_FCLK
 CGC_Osc_Setting(OSC_OSCILLATOR,OSC_UNDER_10M,OSC_OSCILLATOR,OSC_NORMAL_POWER);
 CGC_PLL_Setting(PLL_SR_fMX,PLL_DIV_2,PLL_MUL_16);/* CGC_PLL_Setting 用于配置PLL（相位锁定环）作为系统时钟以及可能的外设硬件电路的时钟源。 */
 CGC_PLL_CFG_AS_FCLK();  /* PLL的输出频率配置为CPU系统时钟以及外设硬件电路的时钟源。 */
 delay_init(64000000);
 SystemCoreClock = 64000000UL;
#endif

#ifdef USED_FHOCO_FCLK 
 SystemCoreClockUpdate();
 msCnt = SystemCoreClock / 1000;
 SysTick_Config(msCnt);
 delay_init(SystemCoreClock);
#endif
}

void RTE_CLOCK_Select_Stop(void)
{

}

uint32_t RTE_CLOCK_Sys_Get(void)
{
	return RTE_SystemCoreClock;
}


void RTE_CLOCK_Select_Sleep(void)
{
	uint8_t           u8tempstabset1  = 0U;
    uint8_t           u8tempstabwait1 = 0U;
	u8tempstabset1 = _FF_CGC_OSCSTAB_STA18;
    do
    {
        u8tempstabwait1 = CGC->OSTC;
        u8tempstabwait1 &= u8tempstabset1;
    }
    while (u8tempstabwait1 != u8tempstabset1);
    CGC_PLL_Setting(PLL_SR_fMX,PLL_DIV_2,PLL_MUL_16); 
	CGC_PLL_CFG_AS_FCLK();//SRAM区运行
    SystemCoreClock = 64000000UL;
	
}

