#include "Data_OilPressure.h"
#include "Components.h"


#define OIL_DATA_TIME 25u /*这里填写多长时间采集一个数据，单位ms*/
#define OIL_DATA_NUM 20u  /*机油压力电阻采集数据总数 最大255*/
#define OIL_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define OIL_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/

uint16_t g_u16OilData[OIL_DATA_NUM];
uint8_t g_u8OilDataCount = 0u;

// uint8_t g_u8OILStateInitFlag = 0u;
uint32_t OilPressureR = 0u; /*滤波后的机油压力电阻，精度0.1*/
uint8_t g_u8OilADCompleteFlg = 0u;

void Oil_Pressure_KL30_Init(void)
{
    // g_u8OILStateInitFlag = 1u;
    g_u8OilADCompleteFlg = 0u;
}

void Oil_Pressure_KL15_Init(void)
{
    // g_u8OILStateInitFlag = 1u;
    g_u8OilADCompleteFlg = 0u;
}

void Oil_R_Cal(uint8_t deltaTime)
{
    uint16_t OilPressureRes = 0;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;

    // if(g_u8OILStateInitFlag)
    // {
    //     OilPressureR = ADC_Read_Signal(ADC_CH_OIL_PRESSURE_R);
    // }
    if(AMT630H_Animation_Finish_Flage() == 1)
    {
        if (timeCount >= OIL_DATA_TIME)
        {
            timeCount = 0;
            if (g_u8OilDataCount < OIL_DATA_NUM)
            {
                /*获取机油压力电阻*/
                OilPressureRes = ADC_Read_Signal(ADC_CH_OIL_PRESSURE_R);

                /*四舍五入*/
                if (OilPressureRes < 60000)  //针对此项目机油压力采集电路补偿后的阻值
                {
                    if (OilPressureRes % 10 >= 5)
                    {
                        OilPressureRes += 5;
                    }
                }
                else
                {
                    OilPressureRes = 0xFFFF;
                }
                /*由小到大插入数据*/
                for (i = 0; i < g_u8OilDataCount; i++)
                {
                    if (OilPressureRes < g_u16OilData[i])
                    {
                        break;
                    }
                }
                for (j = g_u8OilDataCount; j > i; j--)
                {
                    g_u16OilData[j] = g_u16OilData[j - 1];
                }
                g_u16OilData[i] = OilPressureRes;
                g_u8OilDataCount++;
            }
            else
            {
                /*一组数据采集完毕，取中间部分计算平均值*/
                temp32 = 0;
                for (i = OIL_CAL_START; i < OIL_CAL_END; i++)
                {
                    temp32 += g_u16OilData[i];
                }
                OilPressureR = temp32 / (OIL_CAL_END - OIL_CAL_START);
                g_u8OilDataCount = 0;
                g_u8OilADCompleteFlg = 1;
            }
        }
        timeCount += deltaTime;
    }
}

uint8_t Get_OilPressureStauts(void)
{
    if(OilPressureR < 59500)
    {
        return 1U;
    }
    else
    {
        return 0u;
    }
}