#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#include "Components.h"
#include "CAN_Signal\CAN_Lib.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;
extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_CH0_101_Msg_Count,
    CAN_CH0_ID_CH0_111_Msg_Count,
    CAN_CH0_ID_CH0_401_Msg_Count,
    CAN_CH0_ID_CH0_402_Msg_Count,
    CAN_CH0_ID_CH0_12B_Msg_Count,
    CAN_CH0_ID_CH0_450_Msg_Count,
    CAN_CH0_ID_CH0_37B_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    TEST,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_CH0_101_Msg    0x101ul
#define  CAN_CH0_ID_CH0_111_Msg    0x111ul
#define  CAN_CH0_ID_CH0_401_Msg    0x401ul
#define  CAN_CH0_ID_CH0_402_Msg    0x402ul
#define  CAN_CH0_ID_CH0_12B_Msg    0x12Bul
#define  CAN_CH0_ID_CH0_450_Msg    0x450ul
#define  CAN_CH0_ID_CH0_37B_Msg    0x37Bul

extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed_State(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Tair_Enable(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Power(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Ready(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Batt(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Livecounter(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Fuel_Consumption(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Environment_Presure(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH2(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTC1Amnt(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL1(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM1(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH1(void);
extern uint8_t  Get_CAN_CH0_ID_12B_Sig_Abs_warning_lamp(void);
extern uint8_t  Get_CAN_CH0_ID_450_Sig_Dashboard_TCSFunSwitch(void);
extern uint8_t  Get_CAN_CH0_ID_450_Sig_ABSOFF_Selection(void);
extern uint8_t  Get_CAN_CH0_ID_37B_Sig_TCS_Work_Mode(void);
extern uint8_t  Get_CAN_CH0_ID_37B_Sig_TCS_Warning_Lamp(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
