
#ifndef LINE_IN_H
#define LINE_IN_H

#ifdef Platform_16Bit
    #define Linelib_uint8_t  unsigned char
    #define Linelib_uint16_t unsigned int
    #define Linelib_uint32_t unsigned long
#else

    #define Linelib_uint8_t  unsigned char
    #define Linelib_uint16_t unsigned short
    #define Linelib_uint32_t unsigned int
    #define Linelib_uint64_t unsigned long long
#endif

#define LINE_IN_BLOCK_SIZE (( Linelib_uint8_t )(8u))

#define LINE_IN_IG_OFF   (Linelib_uint8_t)(0x00u)
#define LINE_IN_IG_ON    (Linelib_uint8_t)(0x01u)
#define LINE_IN_IG_ONOFF (Linelib_uint8_t)(0x02u)

#define LEVEL_LOW  (Linelib_uint8_t)(0x00u)
#define LEVEL_HIGH (Linelib_uint8_t)(0x01u)

#define LINE_IN_LOGIC_INVALID (Linelib_uint8_t)(0x00u)
#define LINE_IN_LOGIC_VALID   (Linelib_uint8_t)(0x01u)

/*获取实时硬线电平函数指针*/
typedef Linelib_uint8_t (*LineIn_Read_Level)(void);
typedef Linelib_uint16_t (*LineIn_GetPowerMode)(void);
/**@struct st_CANMsgAttribute
 * @brief 硬线去抖属性结构体 \n
 * 定义报接收文属性
 */
typedef struct
{
    Linelib_uint8_t   DefaultLevel;       /**< 初始电平 LEVEL_LOW /LEVEL_HIGH */
    Linelib_uint8_t   TriggerLevel;       /**< 触发电平 LEVEL_LOW /LEVEL_HIGH */
    Linelib_uint16_t  enPowerStatus;      /**< 硬线工作的电源状态 LINE_IN_IG_OFF/LINE_IN_IG_ON/LINE_IN_IG_ONOFF */
    Linelib_uint16_t  ValidTime;          /**< 从无效到有效的消抖时间,单位ms */
    Linelib_uint16_t  InvalidTime;        /**< 从有效到无效的消抖时间,单位ms */
    LineIn_Read_Level pfnLineIn_Read_Cbk; /**< 获取实时电平的回调函数 */
} Line_In_Attribute_st;

extern void             Line_In_KL30_WakeUp_Init(Linelib_uint8_t *MemSpace, const Line_In_Attribute_st *Array, Linelib_uint16_t length, LineIn_GetPowerMode pfunc);
extern void             Line_In_Debounce_Service(Linelib_uint16_t CbkCycle);
extern void             Line_In_KL15_OFF_Init(void);
extern void             Line_In_KL15_ON_Init(void);
extern Linelib_uint16_t Line_In_Get_Status(Linelib_uint16_t Channel);
extern Linelib_uint16_t Get_LineIn_Version(void);
#endif
