#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_



#ifdef Platform_16Bit
    #define Light_uint8_t  unsigned char
    #define Light_uint16_t unsigned int
    #define Light_uint32_t unsigned long

#else
    #define Light_uint8_t  unsigned char
    #define Light_uint16_t unsigned short
    #define Light_uint32_t unsigned int
    #define Light_uint64_t unsigned long long

#endif


#ifndef Backlight_NULL
    #define Backlight_NULL ( void * )0u
#endif /* NULL */

extern Light_uint16_t LightR_Status ;

extern void BackLight_30_Init(void);

extern void BackLight_15_Init(void);

extern void BackLight_WakeUp_Init(void);

extern void BackLight_Sleep_Init(void);

extern void BackLight_Back_PWM_Init(void);

extern void BackLight_Set_Lvl(Light_uint8_t lvl);

extern void BackLight_Process(void);

extern Light_uint8_t Backlight_GetPwmLevel(void);

extern void Data_Light_Res_service(Light_uint8_t deltaTime);



#endif
