/*
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontroller, but can be equally used for other
 * suitable processor architectures. This file can be freely distributed.
 * Modifications to this file shall be clearly marked.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * @file     BAT32A279.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     22. July 2021
 * @note     Generated by SVDConv V3.3.18 on Thursday, 22.07.2021 13:44:49
 *           from File 'Files/SVD/BAT32G179.svd',
 *           last modified on Wednesday, 21.07.2021 14:33:50
 */



/** @addtogroup CMS
  * @{
  */


/** @addtogroup BAT32A279
  * @{
  */


#ifndef BAT32A279_H
#define BAT32A279_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0+ Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* =========================================  BAT32G179 Specific Interrupt Numbers  ========================================== */
  LVI_IRQn                  =   0,              /*!< 0  Low Voltage detection interrupt                                        */
  INTP0_IRQn                =   1,              /*!< 1  INTP0 External interrupt request input is valid                        */
  INTP1_IRQn                =   2,              /*!< 2  INTP1 External interrupt request input is valid                        */
  INTP2_IRQn                =   3,              /*!< 3  INTP2 External interrupt request input is valid                        */
  INTP3_IRQn                =   4,              /*!< 4  INTP3 External interrupt request input is valid                        */
  INTP4_IRQn                =   5,              /*!< 5  INTP4 External interrupt request input is valid                        */
  INTP5_IRQn                =   6,              /*!< 6  INTP5 External interrupt request input is valid                        */
  ST2_IRQn                  =   7,              /*!< 7  UART2 transmission transfer end or buffer empty                        */
  SPI20_IRQn                =   7,              /*!< 7  SPI20 transfer end or buffer empty                                     */
  IIC20_IRQn                =   7,              /*!< 7  IIC20 transfer end                                                     */
  SR2_IRQn                  =   8,              /*!< 8  UART2 rerception transfer                                              */
  SPI21_IRQn                =   8,              /*!< 8  SPI21 transfer end or buffer empty                                     */
  IIC21_IRQn                =   8,              /*!< 8  IIC21 transfer end                                                     */
  SRE2_IRQn                 =   9,              /*!< 9  UART2 rerception communication error occurrence                        */
  ST0_IRQn                  =  10,              /*!< 10 UART0 transmission transfer end or buffer empty                        */
  SPI00_IRQn                =  10,              /*!< 10 SPI00 transfer end or buffer empty                                     */
  IIC00_IRQn                =  10,              /*!< 10 IIC00 transfer end                                                     */
  SR0_IRQn                  =  11,              /*!< 11 UART0 rerception transfer                                              */
  SPI01_IRQn                =  11,              /*!< 11 SPI01 transfer end or buffer empty                                     */
  IIC01_IRQn                =  11,              /*!< 11 IIC01 transfer end                                                     */
  SRE0_IRQn                 =  12,              /*!< 12 UART0 rerception communication error occurrence                        */
  ST1_IRQn                  =  13,              /*!< 13 UART1 transmission transfer end or buffer empty                        */
  SPI10_IRQn                =  13,              /*!< 13 SPI10 transfer end or buffer empty                                     */
  IIC10_IRQn                =  13,              /*!< 13 IIC10 transfer end                                                     */
  SR1_IRQn                  =  14,              /*!< 14 UART1 rerception transfer                                              */
  SPI11_IRQn                =  14,              /*!< 14 SPI11 transfer end or buffer empty                                     */
  IIC11_IRQn                =  14,              /*!< 14 IIC11 transfer end                                                     */
  SRE1_IRQn                 =  15,              /*!< 15 UART1 rerception communication error occurrence                        */
  IICA0_IRQn                =  16,              /*!< 16 IICA0 interrupt request                                                */
  TM00_IRQn                 =  17,              /*!< 17 TM4 channel 0 interrupt request                                        */
  TM01_IRQn                 =  18,              /*!< 18 TM4 channel 1 interrupt request                                        */
  TM02_IRQn                 =  19,              /*!< 19 TM4 channel 2 interrupt request                                        */
  TM03_IRQn                 =  20,              /*!< 20 TM4 channel 3 interrupt request                                        */
  ADC_IRQn                  =  21,              /*!< 21 ADC interrupt request                                                  */
  RTC_IRQn                  =  22,              /*!< 22 Real-Time Clock interrupt request                                      */
  KEY_IRQn                  =  23,              /*!< 23 KEY return interrupt request                                           */
  CMP0_IRQn                 =  24,              /*!< 24 CMP0 interrupt request                                                 */
  CMP1_IRQn                 =  25,              /*!< 25 CMP1 interrupt request                                                 */
  TMA_IRQn                  =  26,              /*!< 26 TMA interrupt request                                                  */
  TMM0_IRQn                 =  27,              /*!< 27 TMM channel 0 interrupt request                                        */
  TMM1_IRQn                 =  28,              /*!< 28 TMM channel 1 interrupt request                                        */
  TMB_IRQn                  =  29,              /*!< 29 TMB interrupt request                                                  */
  TMC_IRQn                  =  30,              /*!< 30 TMC interrupt request                                                  */
  FMC_IRQn                  =  31,              /*!< 31 Flash erase or write finish                                            */
  OSDC_IRQn                 =  32,              /*!< 32 OSDC interrupt request                                                 */
  INTP6_IRQn                =  33,              /*!< 33 INTP6 External interrupt request input is valid                        */
  INTP7_IRQn                =  34,              /*!< 34 INTP7 External interrupt request input is valid                        */
  INTP8_IRQn                =  35,              /*!< 35 INTP8 External interrupt request input is valid                        */
  INTP9_IRQn                =  36,              /*!< 36 INTP9 External interrupt request input is valid                        */
  INTP10_IRQn               =  37,              /*!< 37 INTP10 External interrupt request input is valid                       */
  INTP11_IRQn               =  38,              /*!< 38 INTP11 External interrupt request input is valid                       */
  ST3_IRQn                  =  39,              /*!< 39 UART2 transmission transfer end or buffer empty                        */
  SPI30_IRQn                =  39,              /*!< 39 SPI20 transfer end or buffer empty                                     */
  IIC30_IRQn                =  39,              /*!< 39 IIC20 transfer end                                                     */
  SR3_IRQn                  =  40,              /*!< 40 UART2 rerception transfer                                              */
  SPI31_IRQn                =  40,              /*!< 40 SPI21 transfer end or buffer empty                                     */
  IIC31_IRQn                =  40,              /*!< 40 IIC21 transfer end                                                     */
  CAN0ERR_IRQn              =  41,              /*!< 41 CAN0 error interrupt                                                   */
  SPI0_IRQn                 =  42,              /*!< 42 SPI0 interrupt                                                         */
  TM01H_IRQn                =  44,              /*!< 44 TM4 channel 0 (8bit) interrupt request                                 */
  TM03H_IRQn                =  47,              /*!< 47 TM4 channel 3 (8bit) interrupt request                                 */
  DIV_IRQn                  =  48,              /*!< 48 Hardware divider interrupt                                             */
  TM10_IRQn                 =  49,              /*!< 49 TM8 channel 0 interrupt request                                        */
  TM11_IRQn                 =  50,              /*!< 50 TM8 channel 1 interrupt request                                        */
  TM12_IRQn                 =  51,              /*!< 51 TM8 channel 2 interrupt request                                        */
  TM13_IRQn                 =  52,              /*!< 52 TM8 channel 3 interrupt request                                        */
  IT_IRQn                   =  54,              /*!< 54 15-bit interval timer interrupt request                                */
  CAN0REC_IRQn              =  55,              /*!< 55 CAN0 reception completion interrupt                                    */
  CAN0WUP_IRQn              =  56,              /*!< 56 CAN0 wakeup interrupt                                                  */
  CAN0TRX_IRQn              =  57,              /*!< 57 CAN0 transmission completion interrupt                                 */
  CAN1ERR_IRQn              =  58,              /*!< 58 CAN1 error interrupt                                                   */
  CAN1REC_IRQn              =  61,              /*!< 61 CAN1 reception completion interrupt                                    */
  CAN1WUP_IRQn              =  62,              /*!< 62 CAN1 wakeup interrupt                                                  */
  CAN1TRX_IRQn              =  63,              /*!< 63 CAN1 transmission completion interrupt                                 */
  OCRV_IRQn                 =  64,              /*!< 64 OCRV interrupt request                                                 */
  SPI1_IRQn                 =  74,              /*!< 74 SPI1 interrupt                                                         */
  LCDB_IRQn                 =  76,              /*!< 76 LCDB interrupt                                                         */
  IICA1_IRQn                =  80,              /*!< 80 IICA1 interrupt request                                                */
  TM14_IRQn                 =  81,              /*!< 81 TM8 channel 4 interrupt request                                        */
  TM15_IRQn                 =  82,              /*!< 82 TM8 channel 5 interrupt request                                        */
  TM16_IRQn                 =  83,              /*!< 83 TM8 channel 6 interrupt request                                        */
  TM17_IRQn                 =  84,              /*!< 84 TM8 channel 7 interrupt request                                        */
  CAN2ERR_IRQn              =  90,              /*!< 90 CAN2 error interrupt                                                   */
  CAN2REC_IRQn              =  93,              /*!< 93 CAN2 reception completion interrupt                                    */
  CAN2WUP_IRQn              =  94,              /*!< 94 CAN2 wakeup interrupt                                                  */
  CAN2TRX_IRQn              =  95,              /*!< 95 CAN2 transmission completion interrupt                                 */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M0+ Processor and Core Peripherals  =========================== */
#define __CM0PLUS_REV                 0x0001U   /*!< CM0PLUS Core Revision                                                     */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0plus.h"                       /*!< ARM Cortex-M0+ processor and core peripherals                             */
#include "system_BAT32A279.h"                   /*!< BAT32G179 System                                                          */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_clusters
  * @{
  */


/**
  * @brief DMAVEC_CTRL [CTRL] (DMA control data area)
  */
typedef struct {
  __IOM uint16_t  DMACR;                        /*!< (@ 0x00000000) DMA Control register                                       */
  __IOM uint16_t  DMBLS;                        /*!< (@ 0x00000002) DMA Block Size register                                    */
  __IOM uint16_t  DMACT;                        /*!< (@ 0x00000004) DMA Transfer Count register                                */
  __IOM uint16_t  DMRLD;                        /*!< (@ 0x00000006) DMA Transfer Count Reload register                         */
  __IOM uint32_t  DMSAR;                        /*!< (@ 0x00000008) DMA Source Address register                                */
  __IOM uint32_t  DMDAR;                        /*!< (@ 0x0000000C) DMA Destination Address register                           */
} DMAVEC_CTRL_Type;                             /*!< Size = 16 (0x10)                                                          */


/**
  * @brief INT_IF [IF] (Interrupt flag register)
  */
typedef struct {
  __IOM uint8_t   IFL;                          /*!< (@ 0x00000000) Interrupt flag register                                    */
  __IOM uint8_t   IFH;                          /*!< (@ 0x00000001) Interrupt flag register                                    */
  __IOM uint8_t   IFT;                          /*!< (@ 0x00000002) Interrupt flag register                                    */
  __IM  uint8_t   RESERVED;
} INT_IF_Type;                                  /*!< Size = 4 (0x4)                                                            */


/**
  * @brief INT_MK [MK] (Interrupt mask register)
  */
typedef struct {
  __IOM uint8_t   MKL;                          /*!< (@ 0x00000000) Interrupt mask register                                    */
  __IOM uint8_t   MKH;                          /*!< (@ 0x00000001) Interrupt mask register                                    */
  __IOM uint8_t   MKT;                          /*!< (@ 0x00000002) Interrupt mask register                                    */
  __IM  uint8_t   RESERVED;
} INT_MK_Type;                                  /*!< Size = 4 (0x4)                                                            */


/** @} */ /* End of group Device_Peripheral_clusters */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            CGC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generate Control (CGC)
  */

typedef struct {                                /*!< (@ 0x40020400) CGC Structure                                              */
  __IOM uint8_t   CMC;                          /*!< (@ 0x00000000) Clock operaton Mode Control Register                       */
  __IOM uint8_t   CSC;                          /*!< (@ 0x00000001) Clock operation Status Register                            */
  __IM  uint8_t   OSTC;                         /*!< (@ 0x00000002) Oscillation stabilization time counter status              */
  __IOM uint8_t   OSTS;                         /*!< (@ 0x00000003) Oscillation stabilization time select register             */
  __IOM uint8_t   CKC;                          /*!< (@ 0x00000004) System clock control register                              */
  __IOM uint8_t   LOCKCTL;                      /*!< (@ 0x00000005) Lockup Watchdog timer enable register                      */
  __IOM uint8_t   PRCR;                         /*!< (@ 0x00000006) Lockup Watchdog timer enable protect register              */
  __IOM uint8_t   SUBCKSEL;                     /*!< (@ 0x00000007) Subsystem Clock select register                            */
  __IOM uint8_t   WDTCFG0;                      /*!< (@ 0x00000008) WDT Configeration 0 register                               */
  __IOM uint8_t   WDTCFG1;                      /*!< (@ 0x00000009) WDT Configeration 1 register                               */
  __IOM uint8_t   WDTCFG2;                      /*!< (@ 0x0000000A) WDT Configeration 2 register                               */
  __IOM uint8_t   WDTCFG3;                      /*!< (@ 0x0000000B) WDT Configeration 3 register                               */
  __IM  uint16_t  RESERVED[10];
  __IOM uint8_t   PER0;                         /*!< (@ 0x00000020) Peripheral enable register 0                               */
  __IM  uint8_t   RESERVED1[2];
  __IOM uint8_t   OSMC;                         /*!< (@ 0x00000023) Subsystem clock supply mode control register               */
  __IM  uint16_t  RESERVED2[507];
  __IOM uint8_t   PER1;                         /*!< (@ 0x0000041A) Peripheral enable register 1                               */
  __IOM uint8_t   PER2;                         /*!< (@ 0x0000041B) Peripheral enable register 2                               */
  __IOM uint8_t   PER3;                         /*!< (@ 0x0000041C) Peripheral enable register 2                               */
  __IM  uint8_t   RESERVED3;
  __IM  uint16_t  RESERVED4[497];
  __IOM uint8_t   MCKC;                         /*!< (@ 0x00000800) Main system clock control register                         */
  __IM  uint8_t   RESERVED5;
  __IOM uint8_t   PLLCR;                        /*!< (@ 0x00000802) System PLL clock control register                          */
  __IM  uint8_t   RESERVED6;
  __IM  uint16_t  RESERVED7[2046];
  __IOM uint8_t   HIOTRM;                       /*!< (@ 0x00001800) High-speed on-chip oscillator trimming register            */
  __IM  uint8_t   RESERVED8;
  __IM  uint16_t  RESERVED9[15];
  __IOM uint8_t   HOCODIV;                      /*!< (@ 0x00001820) High-speed on-chip oscillator frequency select
                                                                    register                                                   */
  __IM  uint8_t   RESERVED10;
  __IM  uint16_t  RESERVED11[751];
  __IOM uint16_t  SCMCTL;                       /*!< (@ 0x00001E00) Oscillator stop detection control register                 */
  __IOM uint16_t  SCMMD;                        /*!< (@ 0x00001E02) Oscillator stop detection mode register                    */
  __IOM uint8_t   SCMST;                        /*!< (@ 0x00001E04) Oscillator stop detected status register                   */
  __IM  uint8_t   RESERVED12;
  __IM  uint16_t  RESERVED13[253];
  __IOM uint8_t   HOCOFC;                       /*!< (@ 0x00002000) High-speed on-chip oscillator frequency correction
                                                                    register                                                   */
  __IM  uint8_t   RESERVED15;
  __IM  uint16_t  RESERVED16;
} CGC_Type;                                     /*!< Size = 8196 (0x2004)                                                      */



/* =========================================================================================================================== */
/* ================                                            RST                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Reset Function (RST)
  */

typedef struct {                                /*!< (@ 0x40020420) RST Structure                                              */
  __IM  uint8_t   RESERVED[32];
  __IM  uint8_t   RESF;                         /*!< (@ 0x00000020) Reset flag register                                        */
} RST_Type;                                     /*!< Size = 33 (0x21)                                                          */



/* =========================================================================================================================== */
/* ================                                            LVD                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage detector (LVD)
  */

typedef struct {                                /*!< (@ 0x40020440) LVD Structure                                              */
  __IM  uint8_t   RESERVED;
  __IOM uint8_t   LVIM;                         /*!< (@ 0x00000001) Voltage detection register                                 */
  __IOM uint8_t   LVIS;                         /*!< (@ 0x00000002) Voltage detection level register                           */
} LVD_Type;                                     /*!< Size = 3 (0x3)                                                            */



/* =========================================================================================================================== */
/* ================                                           PORT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Port functions (PORT)
  */

typedef struct {                                /*!< (@ 0x40040000) PORT Structure                                             */
  __IM  uint8_t   RESERVED[48];
  __IOM uint8_t   PU0;                          /*!< (@ 0x00000030) Pull-up resistor option register 0                         */
  __IOM uint8_t   PU1;                          /*!< (@ 0x00000031) Pull-up resistor option register 1                         */
  __IM  uint8_t   RESERVED1;
  __IOM uint8_t   PU3;                          /*!< (@ 0x00000033) Pull-up resistor option register 3                         */
  __IOM uint8_t   PU4;                          /*!< (@ 0x00000034) Pull-up resistor option register 4                         */
  __IOM uint8_t   PU5;                          /*!< (@ 0x00000035) Pull-up resistor option register 5                         */
  __IOM uint8_t   PU6;                          /*!< (@ 0x00000036) Pull-up resistor option register 6                         */
  __IOM uint8_t   PU7;                          /*!< (@ 0x00000037) Pull-up resistor option register 7                         */
  __IOM uint8_t   PU8;                          /*!< (@ 0x00000038) Pull-up resistor option register 8                         */
  __IM  uint8_t   RESERVED2;
  __IOM uint8_t   PU10;                         /*!< (@ 0x0000003A) Pull-up resistor option register 10                        */
  __IOM uint8_t   PU11;                         /*!< (@ 0x0000003B) Pull-up resistor option register 11                        */
  __IOM uint8_t   PU12;                         /*!< (@ 0x0000003C) Pull-up resistor option register 12                        */
  __IOM uint8_t   PU13;                         /*!< (@ 0x0000003D) Pull-up resistor option register 13                        */
  __IOM uint8_t   PU14;                         /*!< (@ 0x0000003E) Pull-up resistor option register 14                        */
  __IM  uint8_t   RESERVED3;
  __IOM uint8_t   PIM0;                         /*!< (@ 0x00000040) Port input mode register 0                                 */
  __IOM uint8_t   PIM1;                         /*!< (@ 0x00000041) Port input mode register 1                                 */
  __IM  uint8_t   RESERVED4;
  __IOM uint8_t   PIM3;                         /*!< (@ 0x00000043) Port input mode register 3                                 */
  __IOM uint8_t   PIM4;                         /*!< (@ 0x00000044) Port input mode register 4                                 */
  __IOM uint8_t   PIM5;                         /*!< (@ 0x00000045) Port input mode register 5                                 */
  __IM  uint8_t   RESERVED5;
  __IOM uint8_t   PIM7;                         /*!< (@ 0x00000047) Port input mode register 7                                 */
  __IOM uint8_t   PIM8;                         /*!< (@ 0x00000048) Port input mode register 8                                 */
  __IM  uint8_t   RESERVED6[5];
  __IOM uint8_t   PIM14;                        /*!< (@ 0x0000004E) Port input mode register 14                                */
  __IM  uint8_t   RESERVED7;
  __IOM uint8_t   POM0;                         /*!< (@ 0x00000050) Port output mode register 0                                */
  __IOM uint8_t   POM1;                         /*!< (@ 0x00000051) Port output mode register 1                                */
  __IM  uint8_t   RESERVED8;
  __IOM uint8_t   POM3;                         /*!< (@ 0x00000053) Port output mode register 3                                */
  __IOM uint8_t   POM4;                         /*!< (@ 0x00000054) Port output mode register 4                                */
  __IOM uint8_t   POM5;                         /*!< (@ 0x00000055) Port output mode register 5                                */
  __IM  uint8_t   RESERVED9;
  __IOM uint8_t   POM7;                         /*!< (@ 0x00000057) Port output mode register 7                                */
  __IOM uint8_t   POM8;                         /*!< (@ 0x00000058) Port output mode register 8                                */
  __IM  uint8_t   RESERVED10[5];
  __IOM uint8_t   POM14;                        /*!< (@ 0x0000005E) Port output mode register 14                               */
  __IM  uint8_t   RESERVED11;
  __IOM uint8_t   PMC0;                         /*!< (@ 0x00000060) Port mode control register 0                               */
  __IOM uint8_t   PMC1;                         /*!< (@ 0x00000061) Port mode control register 1                               */
  __IOM uint8_t   PMC2;                         /*!< (@ 0x00000062) Port mode control register 2                               */
  __IM  uint8_t   RESERVED12[7];
  __IOM uint8_t   PMC10;                        /*!< (@ 0x0000006A) Port mode control register 10                              */
  __IM  uint8_t   RESERVED13;
  __IOM uint8_t   PMC12;                        /*!< (@ 0x0000006C) Port mode control register 12                              */
  __IOM uint8_t   PMC13;                        /*!< (@ 0x0000006D) Port mode control register 13                              */
  __IOM uint8_t   PMC14;                        /*!< (@ 0x0000006E) Port mode control register 14                              */
  __IOM uint8_t   PMC15;                        /*!< (@ 0x0000006F) Port mode control register 15                              */
  __IM  uint8_t   RESERVED14[16];
  __IOM uint8_t   PSET0;                        /*!< (@ 0x00000080) Port set register 0                                        */
  __IOM uint8_t   PSET1;                        /*!< (@ 0x00000081) Port set register 1                                        */
  __IOM uint8_t   PSET2;                        /*!< (@ 0x00000082) Port set register 2                                        */
  __IOM uint8_t   PSET3;                        /*!< (@ 0x00000083) Port set register 3                                        */
  __IOM uint8_t   PSET4;                        /*!< (@ 0x00000084) Port set register 4                                        */
  __IOM uint8_t   PSET5;                        /*!< (@ 0x00000085) Port set register 5                                        */
  __IOM uint8_t   PSET6;                        /*!< (@ 0x00000086) Port set register 6                                        */
  __IOM uint8_t   PSET7;                        /*!< (@ 0x00000087) Port set register 7                                        */
  __IOM uint8_t   PSET8;                        /*!< (@ 0x00000088) Port set register 8                                        */
  __IM  uint8_t   RESERVED15;
  __IOM uint8_t   PSET10;                       /*!< (@ 0x0000008A) Port set register 10                                       */
  __IOM uint8_t   PSET11;                       /*!< (@ 0x0000008B) Port set register 11                                       */
  __IOM uint8_t   PSET12;                       /*!< (@ 0x0000008C) Port set register 12                                       */
  __IOM uint8_t   PSET13;                       /*!< (@ 0x0000008D) Port set register 13                                       */
  __IOM uint8_t   PSET14;                       /*!< (@ 0x0000008E) Port set register 14                                       */
  __IOM uint8_t   PSET15;                       /*!< (@ 0x0000008F) Port set register 15                                       */
  __IOM uint8_t   PCLR0;                        /*!< (@ 0x00000090) Port clear register 0                                      */
  __IOM uint8_t   PCLR1;                        /*!< (@ 0x00000091) Port clear register 1                                      */
  __IOM uint8_t   PCLR2;                        /*!< (@ 0x00000092) Port clear register 2                                      */
  __IOM uint8_t   PCLR3;                        /*!< (@ 0x00000093) Port clear register 3                                      */
  __IOM uint8_t   PCLR4;                        /*!< (@ 0x00000094) Port clear register 4                                      */
  __IOM uint8_t   PCLR5;                        /*!< (@ 0x00000095) Port clear register 5                                      */
  __IOM uint8_t   PCLR6;                        /*!< (@ 0x00000096) Port clear register 6                                      */
  __IOM uint8_t   PCLR7;                        /*!< (@ 0x00000097) Port clear register 7                                      */
  __IOM uint8_t   PCLR8;                        /*!< (@ 0x00000098) Port clear register 8                                      */
  __IM  uint8_t   RESERVED16;
  __IOM uint8_t   PCLR10;                       /*!< (@ 0x0000009A) Port clear register 10                                     */
  __IOM uint8_t   PCLR11;                       /*!< (@ 0x0000009B) Port clear register 11                                     */
  __IOM uint8_t   PCLR12;                       /*!< (@ 0x0000009C) Port clear register 12                                     */
  __IOM uint8_t   PCLR13;                       /*!< (@ 0x0000009D) Port clear register 13                                     */
  __IOM uint8_t   PCLR14;                       /*!< (@ 0x0000009E) Port clear register 14                                     */
  __IOM uint8_t   PCLR15;                       /*!< (@ 0x0000009F) Port clear register 15                                     */
  __IOM uint8_t   PREAD0;                       /*!< (@ 0x000000A0) Port read register 0                                       */
  __IOM uint8_t   PREAD1;                       /*!< (@ 0x000000A1) Port read register 1                                       */
  __IOM uint8_t   PREAD2;                       /*!< (@ 0x000000A2) Port read register 2                                       */
  __IOM uint8_t   PREAD3;                       /*!< (@ 0x000000A3) Port read register 3                                       */
  __IOM uint8_t   PREAD4;                       /*!< (@ 0x000000A4) Port read register 4                                       */
  __IOM uint8_t   PREAD5;                       /*!< (@ 0x000000A5) Port read register 5                                       */
  __IOM uint8_t   PREAD6;                       /*!< (@ 0x000000A6) Port read register 6                                       */
  __IOM uint8_t   PREAD7;                       /*!< (@ 0x000000A7) Port read register 7                                       */
  __IOM uint8_t   PREAD8;                       /*!< (@ 0x000000A8) Port read register 8                                       */
  __IM  uint8_t   RESERVED17;
  __IOM uint8_t   PREAD10;                      /*!< (@ 0x000000AA) Port read register 10                                      */
  __IOM uint8_t   PREAD11;                      /*!< (@ 0x000000AB) Port read register 11                                      */
  __IOM uint8_t   PREAD12;                      /*!< (@ 0x000000AC) Port read register 12                                      */
  __IOM uint8_t   PREAD13;                      /*!< (@ 0x000000AD) Port read register 13                                      */
  __IOM uint8_t   PREAD14;                      /*!< (@ 0x000000AE) Port read register 14                                      */
  __IOM uint8_t   PREAD15;                      /*!< (@ 0x000000AF) Port read register 15                                      */
  __IM  uint8_t   RESERVED18[592];
  __IOM uint8_t   P0;                           /*!< (@ 0x00000300) Port register 0                                            */
  __IOM uint8_t   P1;                           /*!< (@ 0x00000301) Port register 1                                            */
  __IOM uint8_t   P2;                           /*!< (@ 0x00000302) Port register 2                                            */
  __IOM uint8_t   P3;                           /*!< (@ 0x00000303) Port register 3                                            */
  __IOM uint8_t   P4;                           /*!< (@ 0x00000304) Port register 4                                            */
  __IOM uint8_t   P5;                           /*!< (@ 0x00000305) Port register 5                                            */
  __IOM uint8_t   P6;                           /*!< (@ 0x00000306) Port register 6                                            */
  __IOM uint8_t   P7;                           /*!< (@ 0x00000307) Port register 7                                            */
  __IOM uint8_t   P8;                           /*!< (@ 0x00000308) Port register 8                                            */
  __IM  uint8_t   RESERVED19;
  __IOM uint8_t   P10;                          /*!< (@ 0x0000030A) Port register 10                                           */
  __IOM uint8_t   P11;                          /*!< (@ 0x0000030B) Port register 11                                           */
  __IOM uint8_t   P12;                          /*!< (@ 0x0000030C) Port register 12                                           */
  __IOM uint8_t   P13;                          /*!< (@ 0x0000030D) Port register 13                                           */
  __IOM uint8_t   P14;                          /*!< (@ 0x0000030E) Port register 14                                           */
  __IOM uint8_t   P15;                          /*!< (@ 0x0000030F) Port register 15                                           */
  __IM  uint8_t   RESERVED20[16];
  __IOM uint8_t   PM0;                          /*!< (@ 0x00000320) Port mode register 0                                       */
  __IOM uint8_t   PM1;                          /*!< (@ 0x00000321) Port mode register 1                                       */
  __IOM uint8_t   PM2;                          /*!< (@ 0x00000322) Port mode register 2                                       */
  __IOM uint8_t   PM3;                          /*!< (@ 0x00000323) Port mode register 3                                       */
  __IOM uint8_t   PM4;                          /*!< (@ 0x00000324) Port mode register 4                                       */
  __IOM uint8_t   PM5;                          /*!< (@ 0x00000325) Port mode register 5                                       */
  __IOM uint8_t   PM6;                          /*!< (@ 0x00000326) Port mode register 6                                       */
  __IOM uint8_t   PM7;                          /*!< (@ 0x00000327) Port mode register 7                                       */
  __IOM uint8_t   PM8;                          /*!< (@ 0x00000328) Port mode register 8                                       */
  __IM  uint8_t   RESERVED21;
  __IOM uint8_t   PM10;                         /*!< (@ 0x0000032A) Port mode register 10                                      */
  __IOM uint8_t   PM11;                         /*!< (@ 0x0000032B) Port mode register 11                                      */
  __IOM uint8_t   PM12;                         /*!< (@ 0x0000032C) Port mode register 12                                      */
  __IOM uint8_t   PM13;                         /*!< (@ 0x0000032D) Port mode register 13                                      */
  __IOM uint8_t   PM14;                         /*!< (@ 0x0000032E) Port mode register 14                                      */
  __IOM uint8_t   PM15;                         /*!< (@ 0x0000032F) Port mode register 15                                      */
  __IM  uint8_t   RESERVED22[1348];
  __IOM uint8_t   PIOR4;                        /*!< (@ 0x00000874) Peripheral I/O redirection register 3                      */
  __IOM uint8_t   PIOR2;                        /*!< (@ 0x00000875) Peripheral I/O redirection register 2                      */
  __IM  uint8_t   RESERVED23;
  __IOM uint8_t   PIOR0;                        /*!< (@ 0x00000877) Peripheral I/O redirection register 0                      */
  __IM  uint8_t   RESERVED24;
  __IOM uint8_t   PIOR1;                        /*!< (@ 0x00000879) Peripheral I/O redirection register 1                      */
  __IM  uint8_t   RESERVED25;
  __IOM uint8_t   PMS;                          /*!< (@ 0x0000087B) Port mode select register                                  */
  __IOM uint8_t   PIOR3;                        /*!< (@ 0x0000087C) Peripheral I/O redirection register 3                      */
  __IOM uint8_t   GDIDIS;                       /*!< (@ 0x0000087D) Global digital input disable register                      */
} PORT_Type;                                    /*!< Size = 2174 (0x87e)                                                       */



/* =========================================================================================================================== */
/* ================                                            DIV                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Hardware divider (DIV)
  */

typedef struct {                                /*!< (@ 0x4001A000) DIV Structure                                              */
  __IOM uint32_t  DIVIDEND;                     /*!< (@ 0x00000000) Dividend register                                          */
  __IOM uint32_t  DIVISOR;                      /*!< (@ 0x00000004) Divisor register                                           */
  __IM  uint32_t  QUOTIENT;                     /*!< (@ 0x00000008) Quotient register                                          */
  __IM  uint32_t  REMAINDER;                    /*!< (@ 0x0000000C) Remainder register                                         */
  __IM  uint32_t  STATUS;                       /*!< (@ 0x00000010) Status register                                            */
} DIV_Type;                                     /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                           TM40                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Timer 4 (TM40)
  */

//typedef struct {                                /*!< (@ 0x40041D80) TM40 Structure                                             */
//  __IM  uint16_t  TCR00;                        /*!< (@ 0x00000000) Timer count register 00                                    */
//  __IM  uint16_t  TCR01;                        /*!< (@ 0x00000002) Timer count register 01                                    */
//  __IM  uint16_t  TCR02;                        /*!< (@ 0x00000004) Timer count register 02                                    */
//  __IM  uint16_t  TCR03;                        /*!< (@ 0x00000006) Timer count register 03                                    */
//  __IM  uint16_t  RESERVED[4];
//  __IOM uint16_t  TMR00;                        /*!< (@ 0x00000010) Timer mode register mn                                     */
//  __IOM uint16_t  TMR01;                        /*!< (@ 0x00000012) Timer mode register mn                                     */
//  __IOM uint16_t  TMR02;                        /*!< (@ 0x00000014) Timer mode register mn                                     */
//  __IOM uint16_t  TMR03;                        /*!< (@ 0x00000016) Timer mode register mn                                     */
//  __IM  uint16_t  RESERVED1[4];
//  __IM  uint16_t  TSR00;                        /*!< (@ 0x00000020) Timer status register mn                                   */
//  __IM  uint16_t  TSR01;                        /*!< (@ 0x00000022) Timer status register mn                                   */
//  __IM  uint16_t  TSR02;                        /*!< (@ 0x00000024) Timer status register mn                                   */
//  __IM  uint16_t  TSR03;                        /*!< (@ 0x00000026) Timer status register mn                                   */
//  __IM  uint16_t  RESERVED2[4];
//  __IM  uint16_t  TE0;                          /*!< (@ 0x00000030) Timer channel enable status register m                     */
//  __IOM uint16_t  TS0;                          /*!< (@ 0x00000032) Timer channel start register 0                             */
//  __IOM uint16_t  TT0;                          /*!< (@ 0x00000034) Timer channel stop register 0                              */
//  __IOM uint16_t  TPS0;                         /*!< (@ 0x00000036) Timer clock select register 0                              */
//  __IOM uint16_t  TO0;                          /*!< (@ 0x00000038) Timer output register 0                                    */
//  __IOM uint16_t  TOE0;                         /*!< (@ 0x0000003A) Timer output enable register 0                             */
//  __IOM uint16_t  TOL0;                         /*!< (@ 0x0000003C) Timer output level register 0                              */
//  __IOM uint16_t  TOM0;                         /*!< (@ 0x0000003E) Timer output mode register 0                               */
//  __IM  uint16_t  RESERVED3[168];
//  __IOM uint16_t  TDR00;                        /*!< (@ 0x00000190) Timer data register 00                                     */
//  
//  union {
//    __IOM uint16_t TDR01;                       /*!< (@ 0x00000192) Timer data register 01                                     */
//    
//    struct {
//      __IOM uint8_t TDR01L;                     /*!< (@ 0x00000192) Timer data lower register 01                               */
//      __IOM uint8_t TDR01H;                     /*!< (@ 0x00000193) Timer data higher register 01                              */
//    };
//  };
//  __IOM uint16_t  TDR02;                        /*!< (@ 0x00000194) Timer data register 02                                     */
//  
//  union {
//    __IOM uint16_t TDR03;                       /*!< (@ 0x00000196) Timer data register 03                                     */
//    
//    struct {
//      __IOM uint8_t TDR03L;                     /*!< (@ 0x00000196) Timer data lower register 03                               */
//      __IOM uint8_t TDR03H;                     /*!< (@ 0x00000197) Timer data higher register 03                              */
//    };
//  };
//} TM40_Type;                                    /*!< Size = 408 (0x198)                                                        */

/**
  * @brief General Purpose Timer 4 (TM81)
  */
typedef struct {                                /*!< (@ 0x40045D80) TM81 Structure                                             */
	__IM  uint16_t  TCR[8];                        /*!< (@ 0x00000000) Timer count register 00                                    */
	__IOM uint16_t  TMR[8];                        /*!< (@ 0x00000010) Timer mode register mn                                     */
	__IM  uint16_t  TSR[8];                        /*!< (@ 0x00000020) Timer status register mn                                   */
	__IM  uint16_t  TE;                          /*!< (@ 0x00000030) Timer channel enable status register m                     */
	__IOM uint16_t  TS;                          /*!< (@ 0x00000032) Timer channel start register 0                             */
	__IOM uint16_t  TT;                          /*!< (@ 0x00000034) Timer channel stop register 0                              */
	__IOM uint16_t  TPS;                         /*!< (@ 0x00000036) Timer clock select register 0                              */
	__IOM uint16_t  TO;                          /*!< (@ 0x00000038) Timer output register 0                                    */
	__IOM uint16_t  TOE;                         /*!< (@ 0x0000003A) Timer output enable register 0                             */
	__IOM uint16_t  TOL;                         /*!< (@ 0x0000003C) Timer output level register 0                              */
	__IOM uint16_t  TOM;                         /*!< (@ 0x0000003E) Timer output mode register 0                               */
	__IM  uint16_t  RESERVED[168];
	__IOM uint16_t  TDR[8];                        /*!< (@ 0x00000190) Timer data register 00                                     */

	
//  union {
//    __IOM uint16_t TDR11;                       /*!< (@ 0x00000192) Timer data register 01                                     */
//    
//    struct {
//      __IOM uint8_t TDR11L;                     /*!< (@ 0x00000192) Timer data lower register 11                               */
//      __IOM uint8_t TDR11H;                     /*!< (@ 0x00000193) Timer data higher register 11                              */
//    };
//  };
//  __IOM uint16_t  TDR12;                        /*!< (@ 0x00000194) Timer data register 02                                     */
//  
//  union {
//    __IOM uint16_t TDR13;                       /*!< (@ 0x00000196) Timer data register 03                                     */
//    
//    struct {
//      __IOM uint8_t TDR13L;                     /*!< (@ 0x00000196) Timer data lower register 13                               */
//      __IOM uint8_t TDR13H;                     /*!< (@ 0x00000197) Timer data higher register 13                              */
//    };
//  };
//  __IOM uint16_t  TDR14;                        /*!< (@ 0x00000198) Timer data register 04                                     */
//  __IOM uint16_t  TDR15;                        /*!< (@ 0x0000019A) Timer data register 05                                     */
//  __IOM uint16_t  TDR16;                        /*!< (@ 0x0000019C) Timer data register 06                                     */
//  __IOM uint16_t  TDR17;                        /*!< (@ 0x0000019E) Timer data register 07                                     */
} TMx_Type;                                    /*!< Size = 416 (0x1a0)  */



/* =========================================================================================================================== */
/* ================                                           TM81                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Timer 4 (TM81)
  */

//typedef struct {                                /*!< (@ 0x40045D80) TM81 Structure                                             */
//  __IM  uint16_t  TCR10;                        /*!< (@ 0x00000000) Timer count register 00                                    */
//  __IM  uint16_t  TCR11;                        /*!< (@ 0x00000002) Timer count register 01                                    */
//  __IM  uint16_t  TCR12;                        /*!< (@ 0x00000004) Timer count register 02                                    */
//  __IM  uint16_t  TCR13;                        /*!< (@ 0x00000006) Timer count register 03                                    */
//  __IM  uint16_t  TCR14;                        /*!< (@ 0x00000008) Timer count register 04                                    */
//  __IM  uint16_t  TCR15;                        /*!< (@ 0x0000000A) Timer count register 05                                    */
//  __IM  uint16_t  TCR16;                        /*!< (@ 0x0000000C) Timer count register 06                                    */
//  __IM  uint16_t  TCR17;                        /*!< (@ 0x0000000E) Timer count register 07                                    */
//  __IOM uint16_t  TMR10;                        /*!< (@ 0x00000010) Timer mode register mn                                     */
//  __IOM uint16_t  TMR11;                        /*!< (@ 0x00000012) Timer mode register mn                                     */
//  __IOM uint16_t  TMR12;                        /*!< (@ 0x00000014) Timer mode register mn                                     */
//  __IOM uint16_t  TMR13;                        /*!< (@ 0x00000016) Timer mode register mn                                     */
//  __IOM uint16_t  TMR14;                        /*!< (@ 0x00000018) Timer mode register mn                                     */
//  __IOM uint16_t  TMR15;                        /*!< (@ 0x0000001A) Timer mode register mn                                     */
//  __IOM uint16_t  TMR16;                        /*!< (@ 0x0000001C) Timer mode register mn                                     */
//  __IOM uint16_t  TMR17;                        /*!< (@ 0x0000001E) Timer mode register mn                                     */
//  __IM  uint16_t  TSR10;                        /*!< (@ 0x00000020) Timer status register mn                                   */
//  __IM  uint16_t  TSR11;                        /*!< (@ 0x00000022) Timer status register mn                                   */
//  __IM  uint16_t  TSR12;                        /*!< (@ 0x00000024) Timer status register mn                                   */
//  __IM  uint16_t  TSR13;                        /*!< (@ 0x00000026) Timer status register mn                                   */
//  __IM  uint16_t  TSR14;                        /*!< (@ 0x00000028) Timer status register mn                                   */
//  __IM  uint16_t  TSR15;                        /*!< (@ 0x0000002A) Timer status register mn                                   */
//  __IM  uint16_t  TSR16;                        /*!< (@ 0x0000002C) Timer status register mn                                   */
//  __IM  uint16_t  TSR17;                        /*!< (@ 0x0000002E) Timer status register mn                                   */
//  __IM  uint16_t  TE1;                          /*!< (@ 0x00000030) Timer channel enable status register m                     */
//  __IOM uint16_t  TS1;                          /*!< (@ 0x00000032) Timer channel start register 0                             */
//  __IOM uint16_t  TT1;                          /*!< (@ 0x00000034) Timer channel stop register 0                              */
//  __IOM uint16_t  TPS1;                         /*!< (@ 0x00000036) Timer clock select register 0                              */
//  __IOM uint16_t  TO1;                          /*!< (@ 0x00000038) Timer output register 0                                    */
//  __IOM uint16_t  TOE1;                         /*!< (@ 0x0000003A) Timer output enable register 0                             */
//  __IOM uint16_t  TOL1;                         /*!< (@ 0x0000003C) Timer output level register 0                              */
//  __IOM uint16_t  TOM1;                         /*!< (@ 0x0000003E) Timer output mode register 0                               */
//  __IM  uint16_t  RESERVED[168];
//  __IOM uint16_t  TDR10;                        /*!< (@ 0x00000190) Timer data register 00                                     */
//  
//  union {
//    __IOM uint16_t TDR11;                       /*!< (@ 0x00000192) Timer data register 01                                     */
//    
//    struct {
//      __IOM uint8_t TDR11L;                     /*!< (@ 0x00000192) Timer data lower register 11                               */
//      __IOM uint8_t TDR11H;                     /*!< (@ 0x00000193) Timer data higher register 11                              */
//    };
//  };
//  __IOM uint16_t  TDR12;                        /*!< (@ 0x00000194) Timer data register 02                                     */
//  
//  union {
//    __IOM uint16_t TDR13;                       /*!< (@ 0x00000196) Timer data register 03                                     */
//    
//    struct {
//      __IOM uint8_t TDR13L;                     /*!< (@ 0x00000196) Timer data lower register 13                               */
//      __IOM uint8_t TDR13H;                     /*!< (@ 0x00000197) Timer data higher register 13                              */
//    };
//  };
//  __IOM uint16_t  TDR14;                        /*!< (@ 0x00000198) Timer data register 04                                     */
//  __IOM uint16_t  TDR15;                        /*!< (@ 0x0000019A) Timer data register 05                                     */
//  __IOM uint16_t  TDR16;                        /*!< (@ 0x0000019C) Timer data register 06                                     */
//  __IOM uint16_t  TDR17;                        /*!< (@ 0x0000019E) Timer data register 07                                     */
//} TM81_Type;                                    /*!< Size = 416 (0x1a0)                                                        */



/* =========================================================================================================================== */
/* ================                                            TMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Timer A (TMA)
  */

typedef struct {                                /*!< (@ 0x40042240) TMA Structure                                              */
  __IOM uint8_t   TACR0;                        /*!< (@ 0x00000000) Timer control register 0                                   */
  __IOM uint8_t   TAIOC0;                       /*!< (@ 0x00000001) Timer I/O control register 0                               */
  __IOM uint8_t   TAMR0;                        /*!< (@ 0x00000002) Timer mode register 0                                      */
  __IOM uint8_t   TAISR0;                       /*!< (@ 0x00000003) Timer event pin select register 0                          */
  __IM  uint16_t  RESERVED[94];
  __IOM uint16_t  TA0;                          /*!< (@ 0x000000C0) Timer counter register 0                                   */
} TMA_Type;                                     /*!< Size = 194 (0xc2)                                                         */



/* =========================================================================================================================== */
/* ================                                            TMB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Timer B (TMB)
  */

typedef struct {                                /*!< (@ 0x40042650) TMB Structure                                              */
  __IOM uint8_t   TBMR;                         /*!< (@ 0x00000000) Timer mode register                                        */
  __IOM uint8_t   TBCNTC;                       /*!< (@ 0x00000001) Timer count control register                               */
  __IOM uint8_t   TBCR;                         /*!< (@ 0x00000002) Timer control register                                     */
  __IOM uint8_t   TBIER;                        /*!< (@ 0x00000003) Timer interrupt enable register                            */
  __IOM uint8_t   TBSR;                         /*!< (@ 0x00000004) Timer status enable register                               */
  __IOM uint8_t   TBIOR;                        /*!< (@ 0x00000005) Timer I/O control register                                 */
  __IOM uint16_t  TB;                           /*!< (@ 0x00000006) Timer counter register                                     */
  __IOM uint16_t  TBGRA;                        /*!< (@ 0x00000008) Timer general register A                                   */
  __IOM uint16_t  TBGRB;                        /*!< (@ 0x0000000A) Timer general register B                                   */
  __IOM uint16_t  TBGRC;                        /*!< (@ 0x0000000C) Timer general register C                                   */
  __IOM uint16_t  TBGRD;                        /*!< (@ 0x0000000E) Timer general register D                                   */
} TMB_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                            TMC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Timer C (TMC)
  */

typedef struct {                                /*!< (@ 0x40042C50) TMC Structure                                              */
  __IOM uint16_t  TC;                           /*!< (@ 0x00000000) Timer counter register                                     */
  __IOM uint16_t  TCBUF;                        /*!< (@ 0x00000002) Timer count buffer register                                */
  __IOM uint8_t   TCCR1;                        /*!< (@ 0x00000004) Timer control register 1                                   */
  __IOM uint8_t   TCCR2;                        /*!< (@ 0x00000005) Timer control register 2                                   */
  __IOM uint8_t   TCSR;                         /*!< (@ 0x00000006) Timer status register                                      */
  __IM  uint8_t   RESERVED;
  __IM  uint16_t  RESERVED1;
} TMC_Type;                                     /*!< Size = 10 (0xa)                                                           */



/* =========================================================================================================================== */
/* ================                                            TMM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief BLDC Motor control Timer M (TMM)
  */

typedef struct {                                /*!< (@ 0x40042A60) TMM Structure                                              */
  __IOM uint8_t   TMELC;                        /*!< (@ 0x00000000) Timer ELC register                                         */
  __IM  uint8_t   RESERVED[2];
  __IOM uint8_t   TMSTR;                        /*!< (@ 0x00000003) Timer start register                                       */
  __IOM uint8_t   TMMR;                         /*!< (@ 0x00000004) Timer mode register                                        */
  __IOM uint8_t   TMPMR;                        /*!< (@ 0x00000005) PWM function select register                               */
  __IOM uint8_t   TMFCR;                        /*!< (@ 0x00000006) Timer function control register                            */
  __IOM uint8_t   TMOER1;                       /*!< (@ 0x00000007) Timer output master enable register 1                      */
  __IOM uint8_t   TMOER2;                       /*!< (@ 0x00000008) Timer output master enable register 2                      */
  __IOM uint8_t   TMOCR;                        /*!< (@ 0x00000009) Timer output control register                              */
  __IOM uint8_t   TMDF0;                        /*!< (@ 0x0000000A) Digital filter function select register 0                  */
  __IOM uint8_t   TMDF1;                        /*!< (@ 0x0000000B) Digital filter function select register 1                  */
  __IM  uint16_t  RESERVED1[2];
  __IOM uint8_t   TMCR0;                        /*!< (@ 0x00000010) Timer control register 0                                   */
  __IOM uint8_t   TMIORA0;                      /*!< (@ 0x00000011) Timer I/O control register A0                              */
  __IOM uint8_t   TMIORC0;                      /*!< (@ 0x00000012) Timer I/O control register C0                              */
  __IOM uint8_t   TMSR0;                        /*!< (@ 0x00000013) Timer status register 0                                    */
  __IOM uint8_t   TMIER0;                       /*!< (@ 0x00000014) Timer interrupt enable register 0                          */
  __IOM uint8_t   TMPOCR0;                      /*!< (@ 0x00000015) PWM output level control register 0                        */
  __IOM uint16_t  TM0;                          /*!< (@ 0x00000016) Timer M counter 0                                          */
  __IOM uint16_t  TMGRA0;                       /*!< (@ 0x00000018) Timer M general register A0                                */
  __IOM uint16_t  TMGRB0;                       /*!< (@ 0x0000001A) Timer M general register B0                                */
  __IM  uint16_t  RESERVED2[2];
  __IOM uint8_t   TMCR1;                        /*!< (@ 0x00000020) Timer control register 1                                   */
  __IOM uint8_t   TMIORA1;                      /*!< (@ 0x00000021) Timer I/O control register A1                              */
  __IOM uint8_t   TMIORC1;                      /*!< (@ 0x00000022) Timer I/O control register C1                              */
  __IOM uint8_t   TMSR1;                        /*!< (@ 0x00000023) Timer status register 1                                    */
  __IOM uint8_t   TMIER1;                       /*!< (@ 0x00000024) Timer interrupt enable register 1                          */
  __IOM uint8_t   TMPOCR1;                      /*!< (@ 0x00000025) PWM output level control register 1                        */
  __IOM uint16_t  TM1;                          /*!< (@ 0x00000026) Timer M counter 1                                          */
  __IOM uint16_t  TMGRA1;                       /*!< (@ 0x00000028) Timer M general register A1                                */
  __IOM uint16_t  TMGRB1;                       /*!< (@ 0x0000002A) Timer M general register B1                                */
  __IM  uint16_t  RESERVED3[102];
  __IOM uint16_t  TMGRC0;                       /*!< (@ 0x000000F8) Timer M general register C0                                */
  __IOM uint16_t  TMGRD0;                       /*!< (@ 0x000000FA) Timer M general register D0                                */
  __IOM uint16_t  TMGRC1;                       /*!< (@ 0x000000FC) Timer M general register C1                                */
  __IOM uint16_t  TMGRD1;                       /*!< (@ 0x000000FE) Timer M general register D1                                */
  __IM  uint16_t  RESERVED4[2172];
  __IOM uint8_t   OPCTL0;                       /*!< (@ 0x000011F8) PWMOPA control register 0                                  */
  __IOM uint8_t   OPDF0;                        /*!< (@ 0x000011F9) PWMOPA cutoff control register 0                           */
  __IOM uint8_t   OPDF1;                        /*!< (@ 0x000011FA) PWMOPA cutoff control register 1                           */
  __IOM uint8_t   OPEDGE;                       /*!< (@ 0x000011FB) PWMOPA edge selection register                             */
  __IM  uint8_t   OPSR;                         /*!< (@ 0x000011FC) PWMOPA status register                                     */
  __IM  uint8_t   RESERVED5;
  __IM  uint16_t  RESERVED6;
} TMM_Type;                                     /*!< Size = 4608 (0x1200)                                                      */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real-Time clock (RTC)
  */

typedef struct {                                /*!< (@ 0x40044F00) RTC Structure                                              */
  __IM  uint16_t  RESERVED[26];
  __IOM uint16_t  SUBCUD;                       /*!< (@ 0x00000034) Watch error correction register                            */
  __IM  uint16_t  RESERVED1[13];
  __IOM uint16_t  ITMC;                         /*!< (@ 0x00000050) 15-bit interval timer control register                     */
  __IOM uint8_t   SEC;                          /*!< (@ 0x00000052) Second count register                                      */
  __IOM uint8_t   MIN;                          /*!< (@ 0x00000053) Minute count register                                      */
  __IOM uint8_t   HOUR;                         /*!< (@ 0x00000054) Hour count register                                        */
  __IOM uint8_t   WEEK;                         /*!< (@ 0x00000055) Week count register                                        */
  __IOM uint8_t   DAY;                          /*!< (@ 0x00000056) Day count register                                         */
  __IOM uint8_t   MONTH;                        /*!< (@ 0x00000057) Month count register                                       */
  __IOM uint8_t   YEAR;                         /*!< (@ 0x00000058) Year count register                                        */
  __IM  uint8_t   RESERVED2;
  __IOM uint8_t   ALARMWM;                      /*!< (@ 0x0000005A) Alarm minute register                                      */
  __IOM uint8_t   ALARMWH;                      /*!< (@ 0x0000005B) Alarm hour register                                        */
  __IOM uint8_t   ALARMWW;                      /*!< (@ 0x0000005C) Alarm week register                                        */
  __IOM uint8_t   RTCC0;                        /*!< (@ 0x0000005D) Real-time clock control register 0                         */
  __IOM uint8_t   RTCC1;                        /*!< (@ 0x0000005E) Real-time clock control register 1                         */
  __IM  uint8_t   RESERVED3;
  __IM  uint16_t  RESERVED4;
} RTC_Type;                                     /*!< Size = 98 (0x62)                                                          */



/* =========================================================================================================================== */
/* ================                                           PCBZ                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock/Buzzer output controller (PCBZ)
  */

typedef struct {                                /*!< (@ 0x40040FA0) PCBZ Structure                                             */
  __IM  uint8_t   RESERVED[5];
  __IOM uint8_t   CKS0;                         /*!< (@ 0x00000005) Clock output select registers 0                            */
  __IOM uint8_t   CKS1;                         /*!< (@ 0x00000006) Clock output select registers 1                            */
} PCBZ_Type;                                    /*!< Size = 7 (0x7)                                                            */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer with window (WDT)
  */

typedef struct {                                /*!< (@ 0x40021000) WDT Structure                                              */
  __IM  uint8_t   RESERVED;
  __IOM uint8_t   WDTE;                         /*!< (@ 0x00000001) Watchdog timer enable register                             */
} WDT_Type;                                     /*!< Size = 2 (0x2)                                                            */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief A/D Converter (ADC)
  */

typedef struct {                                /*!< (@ 0x40045000) ADC Structure                                              */
  __IOM uint8_t   ADM0;                         /*!< (@ 0x00000000) A/D mode register 0                                        */
  __IM  uint8_t   RESERVED;
  __IOM uint8_t   ADM1;                         /*!< (@ 0x00000002) A/D mode register 1                                        */
  __IM  uint8_t   RESERVED1;
  __IOM uint8_t   ADM2;                         /*!< (@ 0x00000004) A/D mode register 2                                        */
  __IM  uint8_t   RESERVED2;
  __IOM uint8_t   ADTRG;                        /*!< (@ 0x00000006) A/D mode register 2                                        */
  __IM  uint8_t   RESERVED3;
  __IOM uint8_t   ADS;                          /*!< (@ 0x00000008) Analog input channel specification register                */
  __IM  uint8_t   RESERVED4;
  __IOM uint8_t   ADLL;                         /*!< (@ 0x0000000A) Conversion result comparison lower limit setting
                                                                    register                                                   */
  __IOM uint8_t   ADUL;                         /*!< (@ 0x0000000B) Conversion result comparison upper limit setting
                                                                    register                                                   */
  __IOM uint8_t   ADNSMP;                       /*!< (@ 0x0000000C) A/D sampling time control register                         */
  __IM  uint8_t   RESERVED5;
  
  union {
    __IOM uint16_t ADCR;                        /*!< (@ 0x0000000E) 12-bit A/D conversion result register                      */
    
    struct {
      __IM  uint8_t RESERVED6;
      __IOM uint8_t ADCRH;                      /*!< (@ 0x0000000F) Higher 8-bit A/D conversion result register                */
    };
  };
  __IOM uint8_t   ADTES;                        /*!< (@ 0x00000010) A/D test register                                          */
  __IOM uint8_t   ADNDIS;                       /*!< (@ 0x00000011) A/D charge/discharge control register                      */
  __IM  uint16_t  RESERVED7;
  __IM  uint8_t   RESERVED8;
  __IOM uint8_t   ADSMPWAIT;                    /*!< (@ 0x00000015) A/D sampling wait control register                         */
  __IOM uint8_t   ADFLG;                        /*!< (@ 0x00000016) A/D flag register                                          */
  __IM  uint8_t   RESERVED9;
  __IM  uint16_t  RESERVED10;
} ADC_Type;                                     /*!< Size = 26 (0x1a)                                                          */



/* =========================================================================================================================== */
/* ================                                            DAC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief D/A Converter (DAC)
  */

typedef struct {                                /*!< (@ 0x40044700) DAC Structure                                              */
  __IM  uint8_t   RESERVED[52];
  __IOM uint8_t   DACS0;                        /*!< (@ 0x00000034) D/A conversion value setting register 0                    */
  __IOM uint8_t   DACS1;                        /*!< (@ 0x00000035) D/A conversion value setting register 1                    */
  __IOM uint8_t   DAM;                          /*!< (@ 0x00000036) D/A conversion mode register                               */
} DAC_Type;                                     /*!< Size = 55 (0x37)                                                          */



/* =========================================================================================================================== */
/* ================                                            CMP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Comparator (CMP)
  */

typedef struct {                                /*!< (@ 0x40043840) CMP Structure                                              */
  __IOM uint8_t   COMPMDR;                      /*!< (@ 0x00000000) Comparator mode setting register                           */
  __IOM uint8_t   COMPFIR;                      /*!< (@ 0x00000001) Comparator filter control register                         */
  __IOM uint8_t   COMPOCR;                      /*!< (@ 0x00000002) Comparator output control register                         */
  __IOM uint8_t   CVRCTL;                       /*!< (@ 0x00000003) Comparator internal reference voltage control
                                                                    register                                                   */
  __IOM uint8_t   C0RVM;                        /*!< (@ 0x00000004) Comparator internal reference voltage select
                                                                    register 0                                                 */
  __IOM uint8_t   C1RVM;                        /*!< (@ 0x00000005) Comparator internal reference voltage select
                                                                    register 1                                                 */
  __IM  uint8_t   RESERVED[4];
  __IOM uint8_t   CMPSEL0;                      /*!< (@ 0x0000000A) Comparator 0 input signal selection control register       */
  __IOM uint8_t   CMPSEL1;                      /*!< (@ 0x0000000B) Comparator 1 input signal selection control register       */
  __IM  uint8_t   RESERVED1[2];
  __IOM uint8_t   CMP0HY;                       /*!< (@ 0x0000000E) Comparator 0 hysteresis control register                   */
  __IOM uint8_t   CMP1HY;                       /*!< (@ 0x0000000F) Comparator 1 hysteresis control register                   */
} CMP_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                            PGA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Programmable Gain Amplifier (PGA)
  */

typedef struct {                                /*!< (@ 0x40043840) PGA Structure                                              */
  __IM  uint8_t   RESERVED[6];
  __IOM uint8_t   PGA0CTL;                      /*!< (@ 0x00000006) PGA 0 control register                                     */
  __IOM uint8_t   PGA1CTL;                      /*!< (@ 0x00000007) PGA 1 control register                                     */
} PGA_Type;                                     /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                           SCI0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Communication Interface 0 with UART, SPI and simplified I2C supported (SCI0)
  */

typedef struct {                                /*!< (@ 0x40041100) SCI0 Structure                                             */
  __IM  uint16_t  SSR00;                        /*!< (@ 0x00000000) Serial status register mn                                  */
  __IM  uint16_t  SSR01;                        /*!< (@ 0x00000002) Serial status register mn                                  */
  __IM  uint16_t  SSR02;                        /*!< (@ 0x00000004) Serial status register mn                                  */
  __IM  uint16_t  SSR03;                        /*!< (@ 0x00000006) Serial status register mn                                  */
  __IOM uint16_t  SIR00;                        /*!< (@ 0x00000008) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SIR01;                        /*!< (@ 0x0000000A) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SIR02;                        /*!< (@ 0x0000000C) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SIR03;                        /*!< (@ 0x0000000E) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SMR00;                        /*!< (@ 0x00000010) Serial mode register mn                                    */
  __IOM uint16_t  SMR01;                        /*!< (@ 0x00000012) Serial mode register mn                                    */
  __IOM uint16_t  SMR02;                        /*!< (@ 0x00000014) Serial mode register mn                                    */
  __IOM uint16_t  SMR03;                        /*!< (@ 0x00000016) Serial mode register mn                                    */
  __IOM uint16_t  SCR00;                        /*!< (@ 0x00000018) Serial communication operation setting register
                                                                    mn                                                         */
  __IOM uint16_t  SCR01;                        /*!< (@ 0x0000001A) Serial communication operation setting register
                                                                    mn                                                         */
  __IOM uint16_t  SCR02;                        /*!< (@ 0x0000001C) Serial communication operation setting register
                                                                    mn                                                         */
  __IOM uint16_t  SCR03;                        /*!< (@ 0x0000001E) Serial communication operation setting register
                                                                    mn                                                         */
  __IM  uint16_t  SE0;                          /*!< (@ 0x00000020) Serial channel enable status register m                    */
  __IOM uint16_t  SS0;                          /*!< (@ 0x00000022) Serial channel start register 0                            */
  __IOM uint16_t  ST0;                          /*!< (@ 0x00000024) Serial channel stop register 0                             */
  __IOM uint16_t  SPS0;                         /*!< (@ 0x00000026) Serial clock select register 0                             */
  __IOM uint16_t  SO0;                          /*!< (@ 0x00000028) Serial output register 0                                   */
  __IOM uint16_t  SOE0;                         /*!< (@ 0x0000002A) Serial output enable register 0                            */
  __IM  uint16_t  RESERVED[4];
  __IOM uint16_t  SOL0;                         /*!< (@ 0x00000034) Serial output level register 0                             */
  __IM  uint16_t  RESERVED1[237];
  
  union {
    __IOM uint16_t SDR00;                       /*!< (@ 0x00000210) Serial data register 00                                    */
    __IOM uint8_t SIO00;                        /*!< (@ 0x00000210) SPI data register                                          */
    __IOM uint8_t TXD0;                         /*!< (@ 0x00000210) UART transmit data register                                */
  };
  
  union {
    __IOM uint16_t SDR01;                       /*!< (@ 0x00000212) Serial data register 01                                    */
    __IOM uint8_t SIO01;                        /*!< (@ 0x00000212) SPI data register                                          */
    __IOM uint8_t RXD0;                         /*!< (@ 0x00000212) UART receive data register                                 */
  };
  
  union {
    __IOM uint16_t SDR02;                       /*!< (@ 0x00000214) Serial data register 02                                    */
    __IOM uint8_t SIO10;                        /*!< (@ 0x00000214) SPI data register                                          */
    __IOM uint8_t TXD1;                         /*!< (@ 0x00000214) UART transmit data register                                */
  };
  
  union {
    __IOM uint16_t SDR03;                       /*!< (@ 0x00000216) Serial data register 03                                    */
    __IOM uint8_t SIO11;                        /*!< (@ 0x00000216) SPI data register                                          */
    __IOM uint8_t RXD1;                         /*!< (@ 0x00000216) UART receive data register                                 */
  };
} SCI0_TypeDef;                                    /*!< Size = 536 (0x218)                                                        */

typedef struct {
	__IM  uint16_t  TSSR;						/*!< */
	__IM  uint16_t  RSSR;						/*!< */
	__IM  uint16_t  RESERVED1[2];
	
	__IOM uint16_t  TSIR;						/*!< */
	__IOM uint16_t  RSIR;						/*!< */
	__IOM uint16_t  RESERVED2[2];
	
	__IOM uint16_t  TSMR;						/*!< */
	__IOM uint16_t  RSMR;						/*!< */
	__IOM uint16_t  RESERVED3[2];
	
	__IOM uint16_t  TSCR;						/*!< */
	__IOM uint16_t  RSCR;						/*!< */
	__IOM uint16_t  RESERVED4[2];
	
	__IM  uint16_t  SE :  2;					/*!< */
	__IM  uint16_t     : 14;
	
	__IOM uint16_t  SS :  2;					/*!< */
	__IOM uint16_t	   : 14;

	__IOM uint16_t  ST :  2;					/*!< */
	__IOM uint16_t	   : 14;
	
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     : 12;
	
	__IOM uint16_t  SO;							/*!< */
	__IOM uint16_t  SOE;						/*!< */
	__IM  uint16_t  RESERVED5[4];
	__IOM uint16_t  SOL;						/*!< */
	__IM  uint16_t  RESERVED6[237];

	__IOM uint16_t TXD : 9;
	__IOM uint16_t TSDR: 7;
	__IOM uint16_t RXD : 9;						/*!< */
	__IOM uint16_t RSDR: 7;
	
	__IM  uint16_t  RESERVED7[2];
} UART0_TypeDef;

typedef struct {
	__IM  uint16_t  RESERVED1[2];
	__IM  uint16_t  TSSR;						/*!< */
	__IM  uint16_t  RSSR;						/*!< */
	
	__IOM uint16_t  RESERVED2[2];
	__IOM uint16_t  TSIR;						/*!< */
	__IOM uint16_t  RSIR;						/*!< */
	
	__IOM uint16_t  RESERVED3[2];
	__IOM uint16_t  TSMR;						/*!< */
	__IOM uint16_t  RSMR;						/*!< */
	
	__IOM uint16_t  RESERVED4[2];
	__IOM uint16_t  TSCR;						/*!< */
	__IOM uint16_t  RSCR;						/*!< */
	
	__IM  uint16_t     :  2;
	__IM  uint16_t  SE :  2;					/*!< */
	__IM  uint16_t	   : 12;
	
	__IOM uint16_t     :  2;
	__IOM uint16_t  SS :  2;					/*!< */
	__IOM uint16_t	   : 12;

	__IOM uint16_t     :  2;
	__IOM uint16_t  ST :  2;					/*!< */
	__IOM uint16_t	   : 12;
	
	__IOM uint16_t     :  4;
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     :  8;
	
	__IOM uint16_t     :  2;
	__IOM uint16_t  SO :  2;					/*!< */
	__IOM uint16_t	   : 12;

	__IOM uint16_t     :  2;
	__IOM uint16_t  SOE:  2;					/*!< */
	__IOM uint16_t	   : 12;

	__IM  uint16_t  RESERVED5[4];
	__IOM uint16_t  SOL;						/*!< */
	__IM  uint16_t  RESERVED6[237];

	__IM  uint16_t  RESERVED7[2];

	
	__IOM uint16_t TXD : 9;
	__IOM uint16_t TSDR: 7;
	__IOM uint16_t RXD : 9;						/*!< */
	__IOM uint16_t RSDR: 7;
} UART1_TypeDef;

typedef struct {
	__IM  uint16_t  SSR;						/*!< */
	__IM  uint16_t  RESERVED1[3];

	__IOM uint16_t  SIR;						/*!< */
	__IOM uint16_t  RESERVED2[3];
	
	__IOM uint16_t  SMR;						/*!< */
	__IOM uint16_t  RESERVED3[3];
	
	__IOM uint16_t  SCR;						/*!< */
	__IOM uint16_t  RESERVED4[3];
	
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     :  15;
	
	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 15;

	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 15;
	
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     : 12;
	
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
  	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  7;

	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 15;

	__IM  uint16_t  RESERVED5[242];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t    : 1;
	__IOM uint16_t SDR: 7;

	__IM  uint16_t  RESERVED6[3];
} I2C0_TypeDef;

typedef struct {
	__IM  uint16_t  RESERVED1[1];
	__IM  uint16_t  SSR;						/*!< */
	__IM  uint16_t  RESERVED2[2];

	__IOM uint16_t  RESERVED3[1];
	__IOM uint16_t  SIR;						/*!< */
	__IOM uint16_t  RESERVED4[2];
	
	__IOM uint16_t  RESERVED5[1];
	__IOM uint16_t  SMR;						/*!< */
	__IOM uint16_t  RESERVED6[2];
	
	__IOM uint16_t  RESERVED7[1];
	__IOM uint16_t  SCR;						/*!< */
	__IOM uint16_t  RESERVED8[2];
	
	__IM  uint16_t     :  1;
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     :  14;
	
	__IOM uint16_t     :  1;
	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 14;

	__IOM uint16_t     :  1;
	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 14;
	
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     : 12;
	
	__IOM uint16_t     :  1;
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  6;

	__IOM uint16_t     :  1;
	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 14;

	__IM  uint16_t  RESERVED9[243];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t    : 1;
	__IOM uint16_t SDR: 7;

	__IM  uint16_t  RESERVED10[2];
} I2C1_TypeDef;

typedef struct {
	__IM  uint16_t  RESERVED1[2];
	__IM  uint16_t  SSR;						/*!< */
	__IM  uint16_t  RESERVED2[1];

	__IOM uint16_t  RESERVED3[2];
	__IOM uint16_t  SIR;						/*!< */
	__IOM uint16_t  RESERVED4[1];
	
	__IOM uint16_t  RESERVED5[2];
	__IOM uint16_t  SMR;						/*!< */
	__IOM uint16_t  RESERVED6[1];
	
	__IOM uint16_t  RESERVED7[2];
	__IOM uint16_t  SCR;						/*!< */
	__IOM uint16_t  RESERVED8[1];
	
	__IM  uint16_t     :  2;
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     :  13;
	
	__IOM uint16_t     :  2;
	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 13;

	__IOM uint16_t     :  2;
	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 13;
	
	__IOM uint16_t     :  4;
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     :  8;
	
	__IOM uint16_t     :  2;
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  5;

	__IOM uint16_t     :  2;
	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 13;

	__IM  uint16_t  RESERVED9[244];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t    : 1;
	__IOM uint16_t SDR: 7;
	
	__IM  uint16_t  RESERVED10;
} I2C2_TypeDef;

typedef struct {
	__IM  uint16_t  RESERVED1[3];
	__IM  uint16_t  SSR;						/*!< */

	__IOM uint16_t  RESERVED2[3];
	__IOM uint16_t  SIR;						/*!< */
	
	__IOM uint16_t  RESERVED3[3];
	__IOM uint16_t  SMR;						/*!< */
	
	__IOM uint16_t  RESERVED4[3];
	__IOM uint16_t  SCR;						/*!< */
	
	__IM  uint16_t     :  3;
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     :  12;
	
	__IOM uint16_t     :  3;
	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 12;

	__IOM uint16_t     :  3;
	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 12;
	
	__IOM uint16_t     :  4;
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     :  8;
	
	__IOM uint16_t     :  3;
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  4;

	__IOM uint16_t     :  3;
	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 12;

	__IM  uint16_t  RESERVED5[245];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t    : 1;
	__IOM uint16_t SDR: 7;
} I2C3_TypeDef;

typedef struct {                                /*!< (@ 0x40041100) SCI0 Structure                                             */
	union {
		SCI0_TypeDef	SCI;
		UART0_TypeDef 	UART0;
		UART1_TypeDef 	UART1;
		I2C0_TypeDef	I2C0;
		I2C1_TypeDef	I2C1;
		I2C2_TypeDef	I2C2;
		I2C3_TypeDef	I2C3;
	};
} SCI0_Type;    
/* =========================================================================================================================== */
/* ================                                           SCI1                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Communication Interface 1 with UART, SPI and simplified I2C supported (SCI1)
  */

typedef struct {                                /*!< (@ 0x40041400) SCI1 Structure                                             */
  __IM  uint16_t  SSR10;                        /*!< (@ 0x00000000) Serial status register mn                                  */
  __IM  uint16_t  SSR11;                        /*!< (@ 0x00000002) Serial status register mn                                  */
  __IOM uint16_t  SIR10;                        /*!< (@ 0x00000004) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SIR11;                        /*!< (@ 0x00000006) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SMR10;                        /*!< (@ 0x00000008) Serial mode register mn                                    */
  __IOM uint16_t  SMR11;                        /*!< (@ 0x0000000A) Serial mode register mn                                    */
  __IOM uint16_t  SCR10;                        /*!< (@ 0x0000000C) Serial communication operation setting register
                                                                    mn                                                         */
  __IOM uint16_t  SCR11;                        /*!< (@ 0x0000000E) Serial communication operation setting register
                                                                    mn                                                         */
  __IM  uint16_t  SE1;                          /*!< (@ 0x00000010) Serial channel enable status register 1                    */
  __IOM uint16_t  SS1;                          /*!< (@ 0x00000012) Serial channel start register 1                            */
  __IOM uint16_t  ST1;                          /*!< (@ 0x00000014) Serial channel stop register 1                             */
  __IOM uint16_t  SPS1;                         /*!< (@ 0x00000016) Serial clock select register 1                             */
  __IOM uint16_t  SO1;                          /*!< (@ 0x00000018) Serial output register 1                                   */
  __IOM uint16_t  SOE1;                         /*!< (@ 0x0000001A) Serial output enable register 1                            */
  __IM  uint16_t  RESERVED[2];
  __IOM uint16_t  SOL1;                         /*!< (@ 0x00000020) Serial output level register 1                             */
  __IM  uint16_t  RESERVED1[119];
  
  union {
    __IOM uint16_t SDR10;                       /*!< (@ 0x00000110) Serial data register 10                                    */
    __IOM uint8_t SIO20;                        /*!< (@ 0x00000110) SPI data register                                          */
    __IOM uint8_t TXD2;                         /*!< (@ 0x00000110) UART transmit data register                                */
  };
  
  union {
    __IOM uint16_t SDR11;                       /*!< (@ 0x00000112) Serial data register 11                                    */
    __IOM uint8_t SIO21;                        /*!< (@ 0x00000112) SPI data register                                          */
    __IOM uint8_t RXD2;                         /*!< (@ 0x00000112) UART receive data register                                 */
  };
} SCI1_TypeDef;                                    /*!< Size = 276 (0x114)                                                        */

typedef struct {
	__IM  uint16_t  TSSR;						/*!< */
	__IM  uint16_t  RSSR;						/*!< */
	
	__IOM uint16_t  TSIR;						/*!< */
	__IOM uint16_t  RSIR;						/*!< */
	
	__IOM uint16_t  TSMR;						/*!< */
	__IOM uint16_t  RSMR;						/*!< */
	
	__IOM uint16_t  TSCR;						/*!< */
	__IOM uint16_t  RSCR;						/*!< */
	
	__IM  uint16_t  SE :  2;					/*!< */
	__IM  uint16_t     :  14;
	
	__IOM uint16_t  SS :  2;					/*!< */
	__IOM uint16_t	   : 14;
	__IOM uint16_t  ST :  2;					/*!< */
	__IOM uint16_t	   : 14;
	
	__IOM uint16_t  SPS: 4;						/*!< */
	__IOM uint16_t     :12;
	
	__IOM uint16_t  SO :  2;					/*!< */
	__IOM uint16_t	   : 14;
	__IOM uint16_t  SOE:  2;					/*!< */
	__IOM uint16_t	   : 14;
	__IM  uint16_t  RESERVED5[2];
	__IOM uint16_t  SOL;						/*!< */
	__IM  uint16_t  RESERVED6[119];

	__IOM uint16_t TXD : 9;
	__IOM uint16_t TSDR: 7;
	__IOM uint16_t RXD : 9;						/*!< */
	__IOM uint16_t RSDR: 7;
} UART2_TypeDef,UART3_TypeDef;

typedef struct {
	__IM  uint16_t  SSR;						/*!< */
	__IM  uint16_t  RESERVED1;
	
	__IOM uint16_t  SIR;						/*!< */
	__IOM uint16_t  RESERVED2;
	
	__IOM uint16_t  SMR;						/*!< */
	__IOM uint16_t  RESERVED3;
	
	__IOM uint16_t  SCR;						/*!< */
	__IOM uint16_t  RESERVED4;
	
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     :  15;

	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 15;

	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 15;
	
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     : 12;
	
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  7;

	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 15;

	__IM  uint16_t  RESERVED5[122];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t    : 1;
	__IOM uint16_t SDR: 7;

	__IM  uint16_t  RESERVED6;
} I2C4_TypeDef,I2C6_TypeDef;

typedef struct {
	__IM  uint16_t  RESERVED1;
	__IM  uint16_t  SSR;						/*!< */
	
	__IM  uint16_t  RESERVED3;
	__IOM uint16_t  SIR;						/*!< */
	
	__IM  uint16_t  RESERVED5;
	__IOM uint16_t  SMR;						/*!< */
	
	__IM  uint16_t  RESERVED7;
	__IOM uint16_t  SCR;						/*!< */
	
	__IM  uint16_t     :  1;
	__IM  uint16_t  SE :  1;					/*!< */
	__IM  uint16_t     : 14;

	__IOM uint16_t     :  1;
	__IOM uint16_t  SS :  1;					/*!< */
	__IOM uint16_t	   : 14;

	__IOM uint16_t     :  1;
	__IOM uint16_t  ST :  1;					/*!< */
	__IOM uint16_t	   : 14;
	
	__IOM uint16_t  SPS:  4;					/*!< */
	__IOM uint16_t     : 12;
	
	__IOM uint16_t	   :  1;
	__IOM uint16_t  SO :  1;					/*!< */
	__IOM uint16_t	   :  7;
	__IOM uint16_t  CKO:  1;					/*!< */
	__IOM uint16_t	   :  6;

	__IOM uint16_t     :  1;
	__IOM uint16_t  SOE:  1;					/*!< */
	__IOM uint16_t	   : 14;

	__IM  uint16_t  RESERVED9[123];

	__IOM uint16_t SIO: 8;
	__IOM uint16_t	  : 1;
	__IOM uint16_t SDR: 7;
} I2C5_TypeDef,I2C7_TypeDef;

typedef struct {                                /*!< (@ 0x40041540) SCI1 Structure                                             */
	union {
		SCI1_TypeDef	SCI;
		UART2_TypeDef	UART2;
		I2C4_TypeDef	I2C4;
		I2C5_TypeDef	I2C5;
	};
} SCI1_Type; 
/* =========================================================================================================================== */
/* ================                                           SCI2                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Communication Interface 2 with UART, SPI and simplified I2C supported (SCI2)
  */

typedef struct {                                /*!< (@ 0x40041600) SCI2 Structure                                             */
  __IM  uint16_t  SSR20;                        /*!< (@ 0x00000000) Serial status register mn                                  */
  __IM  uint16_t  SSR21;                        /*!< (@ 0x00000002) Serial status register mn                                  */
  __IOM uint16_t  SIR20;                        /*!< (@ 0x00000004) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SIR21;                        /*!< (@ 0x00000006) Serial flag clear trigger register mn                      */
  __IOM uint16_t  SMR20;                        /*!< (@ 0x00000008) Serial mode register mn                                    */
  __IOM uint16_t  SMR21;                        /*!< (@ 0x0000000A) Serial mode register mn                                    */
  __IOM uint16_t  SCR20;                        /*!< (@ 0x0000000C) Serial communication operation setting register
                                                                    mn                                                         */
  __IOM uint16_t  SCR21;                        /*!< (@ 0x0000000E) Serial communication operation setting register
                                                                    mn                                                         */
  __IM  uint16_t  SE2;                          /*!< (@ 0x00000010) Serial channel enable status register 2                    */
  __IOM uint16_t  SS2;                          /*!< (@ 0x00000012) Serial channel start register 2                            */
  __IOM uint16_t  ST2;                          /*!< (@ 0x00000014) Serial channel stop register 2                             */
  __IOM uint16_t  SPS2;                         /*!< (@ 0x00000016) Serial clock select register 0                             */
  __IOM uint16_t  SO2;                          /*!< (@ 0x00000018) Serial output register 0                                   */
  __IOM uint16_t  SOE2;                         /*!< (@ 0x0000001A) Serial output enable register 2                            */
  __IM  uint16_t  RESERVED[2];
  __IOM uint16_t  SOL2;                         /*!< (@ 0x00000020) Serial output level register 2                             */
  __IM  uint16_t  RESERVED1[119];
  
  union {
    __IOM uint16_t SDR20;                       /*!< (@ 0x00000110) Serial data register 20                                    */
    __IOM uint8_t SIO30;                        /*!< (@ 0x00000110) SPI data register                                          */
    __IOM uint8_t TXD3;                         /*!< (@ 0x00000110) UART transmit data register                                */
  };
  
  union {
    __IOM uint16_t SDR21;                       /*!< (@ 0x00000112) Serial data register 21                                    */
    __IOM uint8_t SIO31;                        /*!< (@ 0x00000112) SPI data register                                          */
    __IOM uint8_t RXD3;                         /*!< (@ 0x00000112) UART receive data register                                 */
  };
} SCI2_TypeDef;                                    /*!< Size = 276 (0x114)                                                        */

typedef struct {                                /*!< (@ 0x40041540) SCI1 Structure                                             */
	union {
		SCI2_TypeDef	SCI;
		UART3_TypeDef	UART3;
		I2C6_TypeDef	I2C6;
		I2C7_TypeDef	I2C7;
	};
} SCI2_Type; 

/* =========================================================================================================================== */
/* ================                                          SPIHS0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Interface SPI0 (SPIHS0)
  */

typedef struct {                                /*!< (@ 0x40046C00) SPIHS0 Structure                                           */
  __IOM uint32_t  SPIM0;                        /*!< (@ 0x00000000) SPI mode control register                                  */
  __IOM uint32_t  SPIC0;                        /*!< (@ 0x00000004) SPI control register                                       */
  __IOM uint32_t  SDRO0;                        /*!< (@ 0x00000008) Data buffer of transmission                                */
  __IOM uint32_t  SDRI0;                        /*!< (@ 0x0000000C) Data buffer of reception                                   */
  __IOM uint32_t  SPIS0;                        /*!< (@ 0x00000010) SPI status register                                        */
} SPIHS0_Type;                                  /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                          SPIHS1                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Interface SPI1 (SPIHS1)
  */

typedef struct {                                /*!< (@ 0x40047000) SPIHS1 Structure                                           */
  __IOM uint32_t  SPIM1;                        /*!< (@ 0x00000000) SPI mode control register                                  */
  __IOM uint32_t  SPIC1;                        /*!< (@ 0x00000004) SPI control register                                       */
  __IOM uint32_t  SDRO1;                        /*!< (@ 0x00000008) Data buffer of transmission                                */
  __IOM uint32_t  SDRI1;                        /*!< (@ 0x0000000C) Data buffer of reception                                   */
  __IOM uint32_t  SPIS1;                        /*!< (@ 0x00000010) SPI status register                                        */
} SPIHS1_Type;                                  /*!< Size = 20 (0x14)                                                          */

/**
  * @brief Serial Interface SPI (SPI)
  */

typedef struct {                                /*!< (@ 0x40042400) SPI Structure                                              */
  __IOM uint32_t  SPIM;                         /*!< (@ 0x00000000) SPI mode control register                                  */
  __IOM uint32_t  SPIC;                         /*!< (@ 0x00000004) SPI control register                                       */
  __IOM uint32_t  SDRO;                         /*!< (@ 0x00000008) Data buffer of transmission                                */
  __IOM uint32_t  SDRI;                         /*!< (@ 0x0000000C) Data buffer of reception                                   */
  __IOM uint32_t  SPIS;                        /*!< (@ 0x00000010) SPI status register                                        */	
} SPI_Type;     

/* =========================================================================================================================== */
/* ================                                           IICA0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Interface I2C with multimaster and wakeup supported (IICA0)
  */

typedef struct {                                /*!< (@ 0x40041A30) IICA0 Structure                                            */
  __IOM uint8_t   IICCTL00;                     /*!< (@ 0x00000000) IICA control register 0                                    */
  __IOM uint8_t   IICCTL01;                     /*!< (@ 0x00000001) IICA control register 1                                    */
  __IOM uint8_t   IICWL0;                       /*!< (@ 0x00000002) IICA low-level width setting register 0                    */
  __IOM uint8_t   IICWH0;                       /*!< (@ 0x00000003) IICA high-level width setting register 0                   */
  __IOM uint8_t   SVA0;                         /*!< (@ 0x00000004) Slave address register 0                                   */
  __IM  uint8_t   RESERVED[283];
  __IOM uint8_t   IICA00;                       /*!< (@ 0x00000120) IICA shift register 00                                     */
  __IM  uint8_t   IICS0;                        /*!< (@ 0x00000121) IICA status register 0                                     */
  __IOM uint8_t   IICF0;                        /*!< (@ 0x00000122) IICA flag register 0                                       */
} IICA0_Type;                                   /*!< Size = 291 (0x123)                                                        */



/* =========================================================================================================================== */
/* ================                                           IICA1                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Interface I2C with multimaster and wakeup supported (IICA1)
  */

typedef struct {                                /*!< (@ 0x40046230) IICA1 Structure                                            */
  __IOM uint8_t   IICCTL10;                     /*!< (@ 0x00000000) IICA control register 0                                    */
  __IOM uint8_t   IICCTL11;                     /*!< (@ 0x00000001) IICA control register 1                                    */
  __IOM uint8_t   IICWL1;                       /*!< (@ 0x00000002) IICA low-level width setting register 1                    */
  __IOM uint8_t   IICWH1;                       /*!< (@ 0x00000003) IICA high-level width setting register 1                   */
  __IOM uint8_t   SVA1;                         /*!< (@ 0x00000004) Slave address register 1                                   */
  __IM  uint8_t   RESERVED[283];
  __IOM uint8_t   IICA10;                       /*!< (@ 0x00000120) IICA shift register 10                                     */
  __IM  uint8_t   IICS1;                        /*!< (@ 0x00000121) IICA status register 1                                     */
  __IOM uint8_t   IICF1;                        /*!< (@ 0x00000122) IICA flag register 1                                       */
} IICA1_Type;                                   /*!< Size = 291 (0x123)                                                        */


typedef struct {                                                               
  __IOM uint8_t   IICCTL0;                                                  
  __IOM uint8_t   IICCTL1;                     
  __IOM uint8_t   IICWL;                       
  __IOM uint8_t   IICWH;                       
  __IOM uint8_t   SVA;                        
  __IM  uint8_t   RESERVED[283];
  __IOM uint8_t   IICA;                       
  __IM  uint8_t   IICS0;                        
  __IOM uint8_t   IICF0;                        
} IICA_TypeDef; 

/* =========================================================================================================================== */
/* ================                                           LCDB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LCD Bus Interface (LCDB)
  */

typedef struct {                                /*!< (@ 0x40047400) LCDB Structure                                             */
  __IOM uint8_t   LBCTL;                        /*!< (@ 0x00000000) LCD Bus Interface mode register                            */
  __IOM uint8_t   LBCYC;                        /*!< (@ 0x00000001) LCB Bus Interface cycle control register                   */
  __IOM uint8_t   LBWST;                        /*!< (@ 0x00000002) LCB Bus Interface wait control register                    */
  __IM  uint8_t   RESERVED;
  __IM  uint16_t  RESERVED1[6];
  
  union {
    __IOM uint16_t LBDATA;                      /*!< (@ 0x00000010) LCD Bus Interface data register                            */
    __IOM uint8_t LBDATAL;                      /*!< (@ 0x00000010) SPI data register                                          */
  };
  
  union {
    __IOM uint16_t LBDATAR;                     /*!< (@ 0x00000012) LCD Bus Interface read data register                       */
    __IOM uint8_t LBDATARL;                     /*!< (@ 0x00000012) LCD Bus Interface read data register                       */
  };
} LCDB_Type;                                    /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Enhanced DMA Controller (DMA)
  */

typedef struct {                                /*!< (@ 0x40005000) DMA Structure                                              */
  __IOM uint8_t   DMAEN0;                       /*!< (@ 0x00000000) DMA activation enable register 0                           */
  __IOM uint8_t   DMAEN1;                       /*!< (@ 0x00000001) DMA activation enable register 1                           */
  __IOM uint8_t   DMAEN2;                       /*!< (@ 0x00000002) DMA activation enable register 2                           */
  __IOM uint8_t   DMAEN3;                       /*!< (@ 0x00000003) DMA activation enable register 3                           */
  __IOM uint8_t   DMAEN4;                       /*!< (@ 0x00000004) DMA activation enable register 4                           */
  __IM  uint8_t   RESERVED;
  __IM  uint16_t  RESERVED1;
  __IOM uint32_t  DMABAR;                       /*!< (@ 0x00000008) DMA base address register                                  */
  __IOM uint32_t  IFPRCR;                       /*!< (@ 0x0000000C) DMA Trigger Protect register                               */
  __IOM uint8_t   DMAIF0;                       /*!< (@ 0x00000010) DMA Trigger enable register 0                              */
  __IOM uint8_t   DMAIF1;                       /*!< (@ 0x00000011) DMA Trigger enable register 1                              */
  __IOM uint8_t   DMAIF2;                       /*!< (@ 0x00000012) DMA Trigger enable register 2                              */
  __IOM uint8_t   DMAIF3;                       /*!< (@ 0x00000013) DMA Trigger enable register 3                              */
  __IOM uint8_t   DMAIF4;                       /*!< (@ 0x00000014) DMA Trigger enable register 4                              */
  __IM  uint8_t   RESERVED2;
  __IM  uint16_t  RESERVED3;
  __IOM uint8_t   DMSET0;                       /*!< (@ 0x00000018) DMA activation enable set register 0                       */
  __IOM uint8_t   DMSET1;                       /*!< (@ 0x00000019) DMA activation enable set register 1                       */
  __IOM uint8_t   DMSET2;                       /*!< (@ 0x0000001A) DMA activation enable set register 2                       */
  __IOM uint8_t   DMSET3;                       /*!< (@ 0x0000001B) DMA activation enable set register 3                       */
  __IOM uint8_t   DMSET4;                       /*!< (@ 0x0000001C) DMA activation enable set register 4                       */
  __IM  uint8_t   RESERVED4;
  __IM  uint16_t  RESERVED5;
  __IOM uint8_t   DMCLR0;                       /*!< (@ 0x00000020) DMA activation enable clear register 0                     */
  __IOM uint8_t   DMCLR1;                       /*!< (@ 0x00000021) DMA activation enable clear register 1                     */
  __IOM uint8_t   DMCLR2;                       /*!< (@ 0x00000022) DMA activation enable clear register 2                     */
  __IOM uint8_t   DMCLR3;                       /*!< (@ 0x00000023) DMA activation enable clear register 3                     */
  __IOM uint8_t   DMCLR4;                       /*!< (@ 0x00000024) DMA activation enable clear register 4                     */
  __IM  uint8_t   RESERVED6;
  __IM  uint16_t  RESERVED7;
} DMA_Type;                                     /*!< Size = 40 (0x28)                                                          */



/* =========================================================================================================================== */
/* ================                                          DMAVEC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief DMA Vector and Control Data Area (DMAVEC)
  */

typedef struct {                                /*!< (@ 0x20000000) DMAVEC Structure                                           */
  __IOM uint8_t   VEC[64];                      /*!< (@ 0x00000000) DMA vector area                                            */
  __IOM DMAVEC_CTRL_Type CTRL[40];              /*!< (@ 0x00000040) DMA control data area                                      */
} DMAVEC_Type;                                  /*!< Size = 704 (0x2c0)                                                        */



/* =========================================================================================================================== */
/* ================                                            ELC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Event Link Controller (ELC)
  */

typedef struct {                                /*!< (@ 0x40043400) ELC Structure                                              */
  __IOM uint8_t   ELSELR00;                     /*!< (@ 0x00000000) Event output destination select register 00                */
  __IOM uint8_t   ELSELR01;                     /*!< (@ 0x00000001) Event output destination select register 01                */
  __IOM uint8_t   ELSELR02;                     /*!< (@ 0x00000002) Event output destination select register 02                */
  __IOM uint8_t   ELSELR03;                     /*!< (@ 0x00000003) Event output destination select register 03                */
  __IOM uint8_t   ELSELR04;                     /*!< (@ 0x00000004) Event output destination select register 04                */
  __IOM uint8_t   ELSELR05;                     /*!< (@ 0x00000005) Event output destination select register 05                */
  __IOM uint8_t   ELSELR06;                     /*!< (@ 0x00000006) Event output destination select register 06                */
  __IOM uint8_t   ELSELR07;                     /*!< (@ 0x00000007) Event output destination select register 07                */
  __IOM uint8_t   ELSELR08;                     /*!< (@ 0x00000008) Event output destination select register 08                */
  __IOM uint8_t   ELSELR09;                     /*!< (@ 0x00000009) Event output destination select register 09                */
  __IOM uint8_t   ELSELR10;                     /*!< (@ 0x0000000A) Event output destination select register 10                */
  __IOM uint8_t   ELSELR11;                     /*!< (@ 0x0000000B) Event output destination select register 11                */
  __IOM uint8_t   ELSELR12;                     /*!< (@ 0x0000000C) Event output destination select register 12                */
  __IOM uint8_t   ELSELR13;                     /*!< (@ 0x0000000D) Event output destination select register 13                */
  __IOM uint8_t   ELSELR14;                     /*!< (@ 0x0000000E) Event output destination select register 14                */
  __IOM uint8_t   ELSELR15;                     /*!< (@ 0x0000000F) Event output destination select register 15                */
  __IOM uint8_t   ELSELR16;                     /*!< (@ 0x00000010) Event output destination select register 16                */
  __IOM uint8_t   ELSELR17;                     /*!< (@ 0x00000011) Event output destination select register 17                */
  __IOM uint8_t   ELSELR18;                     /*!< (@ 0x00000012) Event output destination select register 18                */
  __IOM uint8_t   ELSELR19;                     /*!< (@ 0x00000013) Event output destination select register 19                */
  __IOM uint8_t   ELSELR20;                     /*!< (@ 0x00000014) Event output destination select register 20                */
  __IOM uint8_t   ELSELR21;                     /*!< (@ 0x00000015) Event output destination select register 21                */
  __IOM uint8_t   ELSELR22;                     /*!< (@ 0x00000016) Event output destination select register 21                */
} ELC_Type;                                     /*!< Size = 23 (0x17)                                                          */



/* =========================================================================================================================== */
/* ================                                            INT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Interrupt Controller (INT)
  */

typedef struct {                                /*!< (@ 0x40006000) INT Structure                                              */
  __IOM INT_IF_Type IF[32];                     /*!< (@ 0x00000000) Interrupt flag register                                    */
  __IM  uint8_t   RESERVED[128];
  __IOM INT_MK_Type MK[32];                     /*!< (@ 0x00000100) Interrupt mask register                                    */
} INT_Type;                                     /*!< Size = 384 (0x180)                                                        */



/* =========================================================================================================================== */
/* ================                                           INTM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Pin input edge detection (INTM)
  */

typedef struct {                                /*!< (@ 0x40046B38) INTM Structure                                             */
  __IOM uint8_t   EGP0;                         /*!< (@ 0x00000000) External interrupt rising edge enable register             */
  __IOM uint8_t   EGN0;                         /*!< (@ 0x00000001) External interrupt falling edge enable register            */
  __IOM uint8_t   EGP1;                         /*!< (@ 0x00000002) External interrupt rising edge enable register             */
  __IOM uint8_t   EGN1;                         /*!< (@ 0x00000003) External interrupt falling edge enable register            */
} INTM_Type;                                    /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                            KEY                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Key interrupt (KEY)
  */

typedef struct {                                /*!< (@ 0x40044B30) KEY Structure                                              */
  __IM  uint8_t   RESERVED[7];
  __IOM uint8_t   KRM;                          /*!< (@ 0x00000007) Key return mode register                                   */
} KEY_Type;                                     /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                           MISC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Miscellaneous function (MISC)
  */

typedef struct {                                /*!< (@ 0x40040470) MISC Structure                                             */
  __IOM uint8_t   NFEN0;                        /*!< (@ 0x00000000) Noise filter enable register 0                             */
  __IOM uint8_t   NFEN1;                        /*!< (@ 0x00000001) Noise filter enable register 1                             */
  __IOM uint8_t   NFEN2;                        /*!< (@ 0x00000002) Noise filter enable register 2                             */
  __IOM uint8_t   ISC;                          /*!< (@ 0x00000003) Input switch control register                              */
  __IOM uint8_t   TIOS0;                        /*!< (@ 0x00000004) Timer I/O select register 0                                */
  __IOM uint8_t   TIOS1;                        /*!< (@ 0x00000005) Timer I/O select register 1                                */
  __IM  uint8_t   RESERVED[6];
  __IOM uint8_t   RTCCL;                        /*!< (@ 0x0000000C) Real-time clock select register                            */
} MISC_Type;                                    /*!< Size = 13 (0xd)                                                           */



/* =========================================================================================================================== */
/* ================                                            FMC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Memory Controller (FMC)
  */

typedef struct {                                /*!< (@ 0x40020000) FMC Structure                                              */
  __IOM uint32_t  FLSTS;                        /*!< (@ 0x00000000) Flash status register                                      */
  __IOM uint32_t  FLOPMD1;                      /*!< (@ 0x00000004) Flash operation mode register 1                            */
  __IOM uint32_t  FLOPMD2;                      /*!< (@ 0x00000008) Flash operation mode register 2                            */
  __IOM uint32_t  FLERMD;                       /*!< (@ 0x0000000C) Flash erase mode register                                  */
  __IOM uint32_t  FLCERCNT;                     /*!< (@ 0x00000010) Flash chip erase control register                          */
  __IOM uint32_t  FLSERCNT;                     /*!< (@ 0x00000014) Flash sector erase control register                        */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  FLPROCNT;                     /*!< (@ 0x0000001C) Flash program (write) control register                     */
  __IOM uint32_t  FLPROT;                       /*!< (@ 0x00000020) Flash protect control register                             */
} FMC_Type;                                     /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                            SAF                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash memory CRC operation function (High-Speed CRC) (SAF)
  */

typedef struct {                                /*!< (@ 0x40020100) SAF Structure                                              */
  __IM  uint16_t  RESERVED[402];
  __IM  uint8_t   RESERVED1;
  __IOM uint8_t   RPECTL;                       /*!< (@ 0x00000325) RAM parity error control register                          */
  __IM  uint16_t  RESERVED2[2549];
  __IOM uint8_t   CRC0CTL;                      /*!< (@ 0x00001710) Flash memory CRC control register                          */
  __IM  uint8_t   RESERVED3;
  __IOM uint16_t  PGCRCL;                       /*!< (@ 0x00001712) Flash memory CRC operation result register                 */
  __IM  uint16_t  RESERVED4[63026];
  __IOM uint16_t  SFRGD;                        /*!< (@ 0x00020378) SFR guard control register                                 */
  __IM  uint16_t  RESERVED5[5952];
  __IOM uint16_t  CRCD;                         /*!< (@ 0x000231FA) CRC data register                                          */
  __IM  uint16_t  RESERVED6[88];
  __IOM uint8_t   CRCIN;                        /*!< (@ 0x000232AC) CRC input register                                         */
  __IM  uint8_t   RESERVED7;
  __IM  uint16_t  RESERVED8;
} SAF_Type;                                     /*!< Size = 144048 (0x232b0)                                                   */



/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose CRC (CRC)
  */

typedef struct {                                /*!< (@ 0x400432F0) CRC Structure                                              */
  __IM  uint16_t  RESERVED[5];
  __IOM uint16_t  CRCD;                         /*!< (@ 0x0000000A) CRC data register                                          */
  __IM  uint16_t  RESERVED1[88];
  __IOM uint8_t   CRCIN;                        /*!< (@ 0x000000BC) CRC input register                                         */
  __IM  uint8_t   RESERVED2;
  __IM  uint16_t  RESERVED3;
} CRC_Type;                                     /*!< Size = 192 (0xc0)                                                         */



/* =========================================================================================================================== */
/* ================                                            DBG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DBG Controller (DBG)
  */

typedef struct {                                /*!< (@ 0x4001B000) DBG Structure                                              */
  __IM  uint32_t  DBGSTR;                       /*!< (@ 0x00000000) Debug status register                                      */
  __IOM uint32_t  DBGSTOPCR;                    /*!< (@ 0x00000004) Debug Stop Control register                                */
} DBG_Type;                                     /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                           CAN0/1/2                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief CAN Controller (CAN)
  */

typedef struct {                                /*!< (@ 0x40045400/0x40045800/0x40046400) CAN0/1/2 Structure                   */
  __IOM uint16_t  CGMCTRL;                      /*!< (@ 0x00000000) CAN global module control register                         */
  __IOM uint8_t   CGMCS;                        /*!< (@ 0x00000002) CAN global module clock select register                    */
  __IM  uint8_t   RESERVED;
  __IM  uint16_t  RESERVED1;
  __IOM uint16_t  CGMABT;                       /*!< (@ 0x00000006) CAN global automatic block transmission control
                                                                    register                                                   */
  __IOM uint8_t   CGMABTD;                      /*!< (@ 0x00000008) CAN global automatic block transmission delay
                                                                    setting register                                           */
  __IM  uint8_t   RESERVED2;
  __IM  uint16_t  RESERVED3[27];
  __IOM uint16_t  CMASK1L;                      /*!< (@ 0x00000040) CAN module mask 1 register                                 */
  __IOM uint16_t  CMASK1H;                      /*!< (@ 0x00000042) CAN module mask 1 register                                 */
  __IOM uint16_t  CMASK2L;                      /*!< (@ 0x00000044) CAN module mask 2 register                                 */
  __IOM uint16_t  CMASK2H;                      /*!< (@ 0x00000046) CAN module mask 2 register                                 */
  __IOM uint16_t  CMASK3L;                      /*!< (@ 0x00000048) CAN module mask 3 register                                 */
  __IOM uint16_t  CMASK3H;                      /*!< (@ 0x0000004A) CAN module mask 3 register                                 */
  __IOM uint16_t  CMASK4L;                      /*!< (@ 0x0000004C) CAN module mask 4 register                                 */
  __IOM uint16_t  CMASK4H;                      /*!< (@ 0x0000004E) CAN module mask 4 register                                 */
  __IOM uint16_t  CCTRL;                        /*!< (@ 0x00000050) CAN module control register                                */
  __IOM uint8_t   CLEC;                         /*!< (@ 0x00000052) CAN module last error code register                        */
  __IM  uint8_t   CINFO;                        /*!< (@ 0x00000053) CAN module information register                            */
  __IM  uint16_t  CERC;                         /*!< (@ 0x00000054) CAN module error counter register                          */
  __IOM uint16_t  CIE;                          /*!< (@ 0x00000056) CAN module interrupt enable register                       */
  __IOM uint16_t  CINTS;                        /*!< (@ 0x00000058) CAN module interrupt status register                       */
  __IOM uint8_t   CBRP;                         /*!< (@ 0x0000005A) CAN module bit rate prescaler register                     */
  __IM  uint8_t   RESERVED4;
  __IOM uint16_t  CBTR;                         /*!< (@ 0x0000005C) CAN module bit rate register                               */
  __IM  uint8_t   CLIPT;                        /*!< (@ 0x0000005E) CAN module last in-pointer register                        */
  __IM  uint8_t   RESERVED5;
  __IOM uint16_t  CRGPT;                        /*!< (@ 0x00000060) CAN module receive history list register                   */
  __IM  uint8_t   CLOPT;                        /*!< (@ 0x00000062) CAN module last out-pointer register                       */
  __IM  uint8_t   RESERVED6;
  __IOM uint16_t  CTGPT;                        /*!< (@ 0x00000064) CAN module transmit history list register                  */
  __IOM uint16_t  CTS;                          /*!< (@ 0x00000066) CAN module time stamp register                             */
} CAN_Type;                                    /*!< Size = 104 (0x68)                                                         */



/* =========================================================================================================================== */
/* ================                                         CANMSG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief CAN Controller Message (CANMSG)
  */

typedef struct {                                /*!< (@ 0x40045500*) CANMSG Structure                                          */
  
  union {
    __IOM uint16_t CMDB01;                      /*!< (@ 0x00000000) CAN message data byte 01 register                          */
    
    struct {
      __IOM uint8_t CMDB0;                      /*!< (@ 0x00000000) CAN message data byte 0 register                           */
      __IOM uint8_t CMDB1;                      /*!< (@ 0x00000001) CAN message data byte 1 register                           */
    };
  };
  
  union {
    __IOM uint16_t CMDB23;                      /*!< (@ 0x00000002) CAN message data byte 23 register                          */
    
    struct {
      __IOM uint8_t CMDB2;                      /*!< (@ 0x00000002) CAN message data byte 2 register                           */
      __IOM uint8_t CMDB3;                      /*!< (@ 0x00000003) CAN message data byte 3 register                           */
    };
  };
  
  union {
    __IOM uint16_t CMDB45;                      /*!< (@ 0x00000004) CAN message data byte 45 register                          */
    
    struct {
      __IOM uint8_t CMDB4;                      /*!< (@ 0x00000004) CAN message data byte 4 register                           */
      __IOM uint8_t CMDB5;                      /*!< (@ 0x00000005) CAN message data byte 5 register                           */
    };
  };
  
  union {
    __IOM uint16_t CMDB67;                      /*!< (@ 0x00000006) CAN message data byte 67 register                          */
    
    struct {
      __IOM uint8_t CMDB6;                      /*!< (@ 0x00000006) CAN message data byte 6 register                           */
      __IOM uint8_t CMDB7;                      /*!< (@ 0x00000007) CAN message data byte 7 register                           */
    };
  };
  __IOM uint8_t   CMDLC;                        /*!< (@ 0x00000008) CAN message data length register                           */
  __IOM uint8_t   CMCONF;                       /*!< (@ 0x00000009) CAN message configuration register                         */
  __IOM uint16_t  CMIDL;                        /*!< (@ 0x0000000A) CAN message ID register                                    */
  __IOM uint16_t  CMIDH;                        /*!< (@ 0x0000000C) CAN message ID register                                    */
  __IOM uint16_t  CMCTRL;                       /*!< (@ 0x0000000E) CAN message control register                               */
} CANMSG_Type;                               /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                            BGR                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Temperature Sensor calibration data (BGR)
  */

typedef struct {                                /*!< (@ 0x00500C60) BGR Structure                                              */
  __IM  uint16_t  VBG85;                        /*!< (@ 0x00000000) The A/D conversion value of VBGR at 85 degrees
                                                                    and 3.0V reference voltage                                 */
  __IM  uint16_t  RESERVED;
  __IM  uint16_t  VBG25;                        /*!< (@ 0x00000004) The A/D conversion value of VBGR at 25 degrees
                                                                    and 3.0V reference voltage                                 */
} BGR_Type;                                     /*!< Size = 6 (0x6)                                                            */



/* =========================================================================================================================== */
/* ================                                            TSN                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Temperature Sensor calibration data (TSN)
  */

typedef struct {                                /*!< (@ 0x00500C68) TSN Structure                                              */
  __IM  int16_t   TSN85;                        /*!< (@ 0x00000000) The A/D conversion value of Temperature Sensor
                                                                    at 85 degrees and 3.0V reference voltage                   */
  __IM  uint16_t  RESERVED;
  __IM  int16_t   TSN25;                        /*!< (@ 0x00000004) The A/D conversion value of Temperature Sensor
                                                                    at 25 degrees and 3.0V reference voltage                   */
} TSN_Type;                                     /*!< Size = 6 (0x6)                                                            */



/* =========================================================================================================================== */
/* ================                                            UID                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief 128-bit Unique ID (UID)
  */

typedef struct {                                /*!< (@ 0x00500E4C) UID Structure                                              */
  __IM  uint32_t  UID0;                         /*!< (@ 0x00000000) UID word 0                                                 */
  __IM  uint32_t  UID1;                         /*!< (@ 0x00000004) UID word 1                                                 */
  __IM  uint32_t  UID2;                         /*!< (@ 0x00000008) UID word 2                                                 */
  __IM  uint32_t  UID3;                         /*!< (@ 0x0000000C) UID word 3                                                 */
} UID_Type;                                     /*!< Size = 16 (0x10)                                                          */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define CGC_BASE                    0x40020400UL
#define RST_BASE                    0x40020420UL
#define LVD_BASE                    0x40020440UL
#define PORT_BASE                   0x40040000UL
#define DIV_BASE                    0x4001A000UL
#define TM40_BASE                   0x40041D80UL
#define TM81_BASE                   0x40045D80UL
#define TMA_BASE                    0x40042240UL
#define TMB_BASE                    0x40042650UL
#define TMC_BASE                    0x40042C50UL
#define TMM_BASE                    0x40042A60UL
#define RTC_BASE                    0x40044F00UL
#define PCBZ_BASE                   0x40040FA0UL
#define WDT_BASE                    0x40021000UL
#define ADC_BASE                    0x40045000UL
#define DAC_BASE                    0x40044700UL
#define CMP_BASE                    0x40043840UL
#define PGA_BASE                    0x40043840UL
#define SCI0_BASE                   0x40041100UL
#define SCI1_BASE                   0x40041400UL
#define SCI2_BASE                   0x40041600UL
#define SPIHS0_BASE                 0x40046C00UL
#define SPIHS1_BASE                 0x40047000UL
#define IICA0_BASE                  0x40041A30UL
#define IICA1_BASE                  0x40046230UL
#define LCDB_BASE                   0x40047400UL
#define DMA_BASE                    0x40005000UL
#define DMAVEC_BASE                 0x20000000UL
#define ELC_BASE                    0x40043400UL
#define INT_BASE                    0x40006000UL
#define INTM_BASE                   0x40046B38UL
#define KEY_BASE                    0x40044B30UL
#define MISC_BASE                   0x40040470UL
#define FMC_BASE                    0x40020000UL
#define SAF_BASE                    0x40020100UL
#define CRC_BASE                    0x400432F0UL
#define DBG_BASE                    0x4001B000UL
#define CAN0_BASE                   0x40045400UL
#define CAN0MSG00_BASE              0x40045500UL
#define CAN0MSG01_BASE              0x40045510UL
#define CAN0MSG02_BASE              0x40045520UL
#define CAN0MSG03_BASE              0x40045530UL
#define CAN0MSG04_BASE              0x40045540UL
#define CAN0MSG05_BASE              0x40045550UL
#define CAN0MSG06_BASE              0x40045560UL
#define CAN0MSG07_BASE              0x40045570UL
#define CAN0MSG08_BASE              0x40045580UL
#define CAN0MSG09_BASE              0x40045590UL
#define CAN0MSG10_BASE              0x400455A0UL
#define CAN0MSG11_BASE              0x400455B0UL
#define CAN0MSG12_BASE              0x400455C0UL
#define CAN0MSG13_BASE              0x400455D0UL
#define CAN0MSG14_BASE              0x400455E0UL
#define CAN0MSG15_BASE              0x400455F0UL
#define CAN1_BASE                   0x40045800UL
#define CAN1MSG00_BASE              0x40045900UL
#define CAN1MSG01_BASE              0x40045910UL
#define CAN1MSG02_BASE              0x40045920UL
#define CAN1MSG03_BASE              0x40045930UL
#define CAN1MSG04_BASE              0x40045940UL
#define CAN1MSG05_BASE              0x40045950UL
#define CAN1MSG06_BASE              0x40045960UL
#define CAN1MSG07_BASE              0x40045970UL
#define CAN1MSG08_BASE              0x40045980UL
#define CAN1MSG09_BASE              0x40045990UL
#define CAN1MSG10_BASE              0x400459A0UL
#define CAN1MSG11_BASE              0x400459B0UL
#define CAN1MSG12_BASE              0x400459C0UL
#define CAN1MSG13_BASE              0x400459D0UL
#define CAN1MSG14_BASE              0x400459E0UL
#define CAN1MSG15_BASE              0x400459F0UL
#define CAN2_BASE                   0x40046400UL
#define CAN2MSG00_BASE              0x40046500UL
#define CAN2MSG01_BASE              0x40046510UL
#define CAN2MSG02_BASE              0x40046520UL
#define CAN2MSG03_BASE              0x40046530UL
#define CAN2MSG04_BASE              0x40046540UL
#define CAN2MSG05_BASE              0x40046550UL
#define CAN2MSG06_BASE              0x40046560UL
#define CAN2MSG07_BASE              0x40046570UL
#define CAN2MSG08_BASE              0x40046580UL
#define CAN2MSG09_BASE              0x40046590UL
#define CAN2MSG10_BASE              0x400465A0UL
#define CAN2MSG11_BASE              0x400465B0UL
#define CAN2MSG12_BASE              0x400465C0UL
#define CAN2MSG13_BASE              0x400465D0UL
#define CAN2MSG14_BASE              0x400465E0UL
#define CAN2MSG15_BASE              0x400465F0UL
#define BGR_BASE                    0x00500C60UL
#define TSN_BASE                    0x00500C68UL
#define UID_BASE                    0x00500E4CUL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define CGC                         ((CGC_Type*)               CGC_BASE)
#define RST                         ((RST_Type*)               RST_BASE)
#define LVD                         ((LVD_Type*)               LVD_BASE)
#define PORT                        ((PORT_Type*)              PORT_BASE)
#define DIV                         ((DIV_Type*)               DIV_BASE)
#define TM40                        ((TMx_Type*)              TM40_BASE)
#define TM81                        ((TMx_Type*)              TM81_BASE)
#define TMA                         ((TMA_Type*)               TMA_BASE)
#define TMB                         ((TMB_Type*)               TMB_BASE)
#define TMC                         ((TMC_Type*)               TMC_BASE)
#define TMM                         ((TMM_Type*)               TMM_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define PCBZ                        ((PCBZ_Type*)              PCBZ_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)
#define ADC                         ((ADC_Type*)               ADC_BASE)
#define DAC                         ((DAC_Type*)               DAC_BASE)
#define CMP                         ((CMP_Type*)               CMP_BASE)
#define PGA                         ((PGA_Type*)               PGA_BASE)
#define SCI0                        ((SCI0_Type*)              SCI0_BASE)
#define SCI1                        ((SCI1_Type*)              SCI1_BASE)
#define SCI2                        ((SCI2_Type*)              SCI2_BASE)
#define SPIHS0                      ((SPI_Type*)				SPIHS0_BASE)
#define SPIHS1                      ((SPI_Type*)            	SPIHS1_BASE)
#define IICA0                       ((IICA_TypeDef*)             IICA0_BASE)
#define IICA1                       ((IICA_TypeDef*)             IICA1_BASE)
#define LCDB                        ((LCDB_Type*)              LCDB_BASE)
#define DMA                         ((DMA_Type*)               DMA_BASE)
#define DMAVEC                      ((DMAVEC_Type*)            DMAVEC_BASE)
#define ELC                         ((ELC_Type*)               ELC_BASE)
#define INT                         ((INT_Type*)               INT_BASE)
#define INTM                        ((INTM_Type*)              INTM_BASE)
#define KEY                         ((KEY_Type*)               KEY_BASE)
#define MISC                        ((MISC_Type*)              MISC_BASE)
#define FMC                         ((FMC_Type*)               FMC_BASE)
#define SAF                         ((SAF_Type*)               SAF_BASE)
#define CRC                         ((CRC_Type*)               CRC_BASE)
#define DBG                         ((DBG_Type*)               DBG_BASE)
#define CAN0                        ((CAN_Type*)               CAN0_BASE)
#define CAN0MSG00                   ((CANMSG_Type*)            CAN0MSG00_BASE)
#define CAN0MSG01                   ((CANMSG_Type*)            CAN0MSG01_BASE)
#define CAN0MSG02                   ((CANMSG_Type*)            CAN0MSG02_BASE)
#define CAN0MSG03                   ((CANMSG_Type*)            CAN0MSG03_BASE)
#define CAN0MSG04                   ((CANMSG_Type*)            CAN0MSG04_BASE)
#define CAN0MSG05                   ((CANMSG_Type*)            CAN0MSG05_BASE)
#define CAN0MSG06                   ((CANMSG_Type*)            CAN0MSG06_BASE)
#define CAN0MSG07                   ((CANMSG_Type*)            CAN0MSG07_BASE)
#define CAN0MSG08                   ((CANMSG_Type*)            CAN0MSG08_BASE)
#define CAN0MSG09                   ((CANMSG_Type*)            CAN0MSG09_BASE)
#define CAN0MSG10                   ((CANMSG_Type*)            CAN0MSG10_BASE)
#define CAN0MSG11                   ((CANMSG_Type*)            CAN0MSG11_BASE)
#define CAN0MSG12                   ((CANMSG_Type*)            CAN0MSG12_BASE)
#define CAN0MSG13                   ((CANMSG_Type*)            CAN0MSG13_BASE)
#define CAN0MSG14                   ((CANMSG_Type*)            CAN0MSG14_BASE)
#define CAN0MSG15                   ((CANMSG_Type*)            CAN0MSG15_BASE)
#define CAN1                        ((CAN_Type*)               CAN1_BASE)
#define CAN1MSG00                   ((CANMSG_Type*)            CAN1MSG00_BASE)
#define CAN1MSG01                   ((CANMSG_Type*)            CAN1MSG01_BASE)
#define CAN1MSG02                   ((CANMSG_Type*)            CAN1MSG02_BASE)
#define CAN1MSG03                   ((CANMSG_Type*)            CAN1MSG03_BASE)
#define CAN1MSG04                   ((CANMSG_Type*)            CAN1MSG04_BASE)
#define CAN1MSG05                   ((CANMSG_Type*)            CAN1MSG05_BASE)
#define CAN1MSG06                   ((CANMSG_Type*)            CAN1MSG06_BASE)
#define CAN1MSG07                   ((CANMSG_Type*)            CAN1MSG07_BASE)
#define CAN1MSG08                   ((CANMSG_Type*)            CAN1MSG08_BASE)
#define CAN1MSG09                   ((CANMSG_Type*)            CAN1MSG09_BASE)
#define CAN1MSG10                   ((CANMSG_Type*)            CAN1MSG10_BASE)
#define CAN1MSG11                   ((CANMSG_Type*)            CAN1MSG11_BASE)
#define CAN1MSG12                   ((CANMSG_Type*)            CAN1MSG12_BASE)
#define CAN1MSG13                   ((CANMSG_Type*)            CAN1MSG13_BASE)
#define CAN1MSG14                   ((CANMSG_Type*)            CAN1MSG14_BASE)
#define CAN1MSG15                   ((CANMSG_Type*)            CAN1MSG15_BASE)
#define CAN2                        ((CAN_Type*)               CAN2_BASE)
#define CAN2MSG00                   ((CANMSG_Type*)            CAN2MSG00_BASE)
#define CAN2MSG01                   ((CANMSG_Type*)            CAN2MSG01_BASE)
#define CAN2MSG02                   ((CANMSG_Type*)            CAN2MSG02_BASE)
#define CAN2MSG03                   ((CANMSG_Type*)            CAN2MSG03_BASE)
#define CAN2MSG04                   ((CANMSG_Type*)            CAN2MSG04_BASE)
#define CAN2MSG05                   ((CANMSG_Type*)            CAN2MSG05_BASE)
#define CAN2MSG06                   ((CANMSG_Type*)            CAN2MSG06_BASE)
#define CAN2MSG07                   ((CANMSG_Type*)            CAN2MSG07_BASE)
#define CAN2MSG08                   ((CANMSG_Type*)            CAN2MSG08_BASE)
#define CAN2MSG09                   ((CANMSG_Type*)            CAN2MSG09_BASE)
#define CAN2MSG10                   ((CANMSG_Type*)            CAN2MSG10_BASE)
#define CAN2MSG11                   ((CANMSG_Type*)            CAN2MSG11_BASE)
#define CAN2MSG12                   ((CANMSG_Type*)            CAN2MSG12_BASE)
#define CAN2MSG13                   ((CANMSG_Type*)            CAN2MSG13_BASE)
#define CAN2MSG14                   ((CANMSG_Type*)            CAN2MSG14_BASE)
#define CAN2MSG15                   ((CANMSG_Type*)            CAN2MSG15_BASE)
#define BGR                         ((BGR_Type*)               BGR_BASE)
#define TSN                         ((TSN_Type*)               TSN_BASE)
#define UID                         ((UID_Type*)               UID_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                 Pos/Mask Cluster Section                                  ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_clusters
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           CTRL                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  DMACR  ========================================================= */
#define CTRL_DMACR_SZ_Pos                 (6UL)                     /*!< CTRL DMACR: SZ (Bit 6)                                */
#define CTRL_DMACR_SZ_Msk                 (0xc0UL)                  /*!< CTRL DMACR: SZ (Bitfield-Mask: 0x03)                  */
#define CTRL_DMACR_RPTINT_Pos             (5UL)                     /*!< CTRL DMACR: RPTINT (Bit 5)                            */
#define CTRL_DMACR_RPTINT_Msk             (0x20UL)                  /*!< CTRL DMACR: RPTINT (Bitfield-Mask: 0x01)              */
#define CTRL_DMACR_CHNE_Pos               (4UL)                     /*!< CTRL DMACR: CHNE (Bit 4)                              */
#define CTRL_DMACR_CHNE_Msk               (0x10UL)                  /*!< CTRL DMACR: CHNE (Bitfield-Mask: 0x01)                */
#define CTRL_DMACR_DAMOD_Pos              (3UL)                     /*!< CTRL DMACR: DAMOD (Bit 3)                             */
#define CTRL_DMACR_DAMOD_Msk              (0x8UL)                   /*!< CTRL DMACR: DAMOD (Bitfield-Mask: 0x01)               */
#define CTRL_DMACR_SAMOD_Pos              (2UL)                     /*!< CTRL DMACR: SAMOD (Bit 2)                             */
#define CTRL_DMACR_SAMOD_Msk              (0x4UL)                   /*!< CTRL DMACR: SAMOD (Bitfield-Mask: 0x01)               */
#define CTRL_DMACR_RPTSEL_Pos             (1UL)                     /*!< CTRL DMACR: RPTSEL (Bit 1)                            */
#define CTRL_DMACR_RPTSEL_Msk             (0x2UL)                   /*!< CTRL DMACR: RPTSEL (Bitfield-Mask: 0x01)              */
#define CTRL_DMACR_MODE_Pos               (0UL)                     /*!< CTRL DMACR: MODE (Bit 0)                              */
#define CTRL_DMACR_MODE_Msk               (0x1UL)                   /*!< CTRL DMACR: MODE (Bitfield-Mask: 0x01)                */
/* =========================================================  DMBLS  ========================================================= */
/* =========================================================  DMACT  ========================================================= */
/* =========================================================  DMRLD  ========================================================= */
/* =========================================================  DMSAR  ========================================================= */
/* =========================================================  DMDAR  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            IF                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  IFL  ========================================================== */
/* ==========================================================  IFH  ========================================================== */
/* ==========================================================  IFT  ========================================================== */


/* =========================================================================================================================== */
/* ================                                            MK                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  MKL  ========================================================== */
/* ==========================================================  MKH  ========================================================== */
/* ==========================================================  MKT  ========================================================== */

/** @} */ /* End of group PosMask_clusters */


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            CGC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CMC  ========================================================== */
#define CGC_CMC_AMPH_Pos                  (0UL)                     /*!< CGC CMC: AMPH (Bit 0)                                 */
#define CGC_CMC_AMPH_Msk                  (0x1UL)                   /*!< CGC CMC: AMPH (Bitfield-Mask: 0x01)                   */
#define CGC_CMC_AMPHS_Pos                 (1UL)                     /*!< CGC CMC: AMPHS (Bit 1)                                */
#define CGC_CMC_AMPHS_Msk                 (0x6UL)                   /*!< CGC CMC: AMPHS (Bitfield-Mask: 0x03)                  */
#define CGC_CMC_OSCSELS_Pos               (4UL)                     /*!< CGC CMC: OSCSELS (Bit 4)                              */
#define CGC_CMC_OSCSELS_Msk               (0x10UL)                  /*!< CGC CMC: OSCSELS (Bitfield-Mask: 0x01)                */
#define CGC_CMC_EXCLKS_Pos                (5UL)                     /*!< CGC CMC: EXCLKS (Bit 5)                               */
#define CGC_CMC_EXCLKS_Msk                (0x20UL)                  /*!< CGC CMC: EXCLKS (Bitfield-Mask: 0x01)                 */
#define CGC_CMC_OSCSEL_Pos                (6UL)                     /*!< CGC CMC: OSCSEL (Bit 6)                               */
#define CGC_CMC_OSCSEL_Msk                (0x40UL)                  /*!< CGC CMC: OSCSEL (Bitfield-Mask: 0x01)                 */
#define CGC_CMC_EXCLK_Pos                 (7UL)                     /*!< CGC CMC: EXCLK (Bit 7)                                */
#define CGC_CMC_EXCLK_Msk                 (0x80UL)                  /*!< CGC CMC: EXCLK (Bitfield-Mask: 0x01)                  */
/* ==========================================================  CSC  ========================================================== */
#define CGC_CSC_HIOSTOP_Pos               (0UL)                     /*!< CGC CSC: HIOSTOP (Bit 0)                              */
#define CGC_CSC_HIOSTOP_Msk               (0x1UL)                   /*!< CGC CSC: HIOSTOP (Bitfield-Mask: 0x01)                */
#define CGC_CSC_XTSTOP_Pos                (6UL)                     /*!< CGC CSC: XTSTOP (Bit 6)                               */
#define CGC_CSC_XTSTOP_Msk                (0x40UL)                  /*!< CGC CSC: XTSTOP (Bitfield-Mask: 0x01)                 */
#define CGC_CSC_MSTOP_Pos                 (7UL)                     /*!< CGC CSC: MSTOP (Bit 7)                                */
#define CGC_CSC_MSTOP_Msk                 (0x80UL)                  /*!< CGC CSC: MSTOP (Bitfield-Mask: 0x01)                  */
/* =========================================================  OSTC  ========================================================== */
/* =========================================================  OSTS  ========================================================== */
/* ==========================================================  CKC  ========================================================== */
#define CGC_CKC_MCM0_Pos                  (4UL)                     /*!< CGC CKC: MCM0 (Bit 4)                                 */
#define CGC_CKC_MCM0_Msk                  (0x10UL)                  /*!< CGC CKC: MCM0 (Bitfield-Mask: 0x01)                   */
#define CGC_CKC_MCS_Pos                   (5UL)                     /*!< CGC CKC: MCS (Bit 5)                                  */
#define CGC_CKC_MCS_Msk                   (0x20UL)                  /*!< CGC CKC: MCS (Bitfield-Mask: 0x01)                    */
#define CGC_CKC_CSS_Pos                   (6UL)                     /*!< CGC CKC: CSS (Bit 6)                                  */
#define CGC_CKC_CSS_Msk                   (0x40UL)                  /*!< CGC CKC: CSS (Bitfield-Mask: 0x01)                    */
#define CGC_CKC_CLS_Pos                   (7UL)                     /*!< CGC CKC: CLS (Bit 7)                                  */
#define CGC_CKC_CLS_Msk                   (0x80UL)                  /*!< CGC CKC: CLS (Bitfield-Mask: 0x01)                    */
/* ========================================================  LOCKCTL  ======================================================== */
/* =========================================================  PRCR  ========================================================== */
/* =======================================================  SUBCKSEL  ======================================================== */
#define CGC_SUBCKSEL_SELLOSC_Pos          (0UL)                     /*!< CGC SUBCKSEL: SELLOSC (Bit 0)                         */
#define CGC_SUBCKSEL_SELLOSC_Msk          (0x1UL)                   /*!< CGC SUBCKSEL: SELLOSC (Bitfield-Mask: 0x01)           */
#define CGC_SUBCKSEL_LOCOSEL_Pos          (1UL)                     /*!< CGC SUBCKSEL: LOCOSEL (Bit 1)                         */
#define CGC_SUBCKSEL_LOCOSEL_Msk          (0x2UL)                   /*!< CGC SUBCKSEL: LOCOSEL (Bitfield-Mask: 0x01)           */
/* ========================================================  WDTCFG0  ======================================================== */
/* ========================================================  WDTCFG1  ======================================================== */
/* ========================================================  WDTCFG2  ======================================================== */
/* ========================================================  WDTCFG3  ======================================================== */
/* =========================================================  PER0  ========================================================== */
#define CGC_PER0_TM40EN_Pos               (0UL)                     /*!< CGC PER0: TM40EN (Bit 0)                              */
#define CGC_PER0_TM40EN_Msk               (0x1UL)                   /*!< CGC PER0: TM40EN (Bitfield-Mask: 0x01)                */
#define CGC_PER0_CAN0EN_Pos               (1UL)                     /*!< CGC PER0: CAN0EN (Bit 1)                              */
#define CGC_PER0_CAN0EN_Msk               (0x2UL)                   /*!< CGC PER0: CAN0EN (Bitfield-Mask: 0x01)                */
#define CGC_PER0_SCI0EN_Pos               (2UL)                     /*!< CGC PER0: SCI0EN (Bit 2)                              */
#define CGC_PER0_SCI0EN_Msk               (0x4UL)                   /*!< CGC PER0: SCI0EN (Bitfield-Mask: 0x01)                */
#define CGC_PER0_SCI1EN_Pos               (3UL)                     /*!< CGC PER0: SCI1EN (Bit 3)                              */
#define CGC_PER0_SCI1EN_Msk               (0x8UL)                   /*!< CGC PER0: SCI1EN (Bitfield-Mask: 0x01)                */
#define CGC_PER0_IICA0EN_Pos              (4UL)                     /*!< CGC PER0: IICA0EN (Bit 4)                             */
#define CGC_PER0_IICA0EN_Msk              (0x10UL)                  /*!< CGC PER0: IICA0EN (Bitfield-Mask: 0x01)               */
#define CGC_PER0_ADCEN_Pos                (5UL)                     /*!< CGC PER0: ADCEN (Bit 5)                               */
#define CGC_PER0_ADCEN_Msk                (0x20UL)                  /*!< CGC PER0: ADCEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER0_RTCEN_Pos                (7UL)                     /*!< CGC PER0: RTCEN (Bit 7)                               */
#define CGC_PER0_RTCEN_Msk                (0x80UL)                  /*!< CGC PER0: RTCEN (Bitfield-Mask: 0x01)                 */
/* =========================================================  PER1  ========================================================== */
#define CGC_PER1_TMAEN_Pos                (0UL)                     /*!< CGC PER1: TMAEN (Bit 0)                               */
#define CGC_PER1_TMAEN_Msk                (0x1UL)                   /*!< CGC PER1: TMAEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER1_TMCEN_Pos                (1UL)                     /*!< CGC PER1: TMCEN (Bit 1)                               */
#define CGC_PER1_TMCEN_Msk                (0x2UL)                   /*!< CGC PER1: TMCEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER1_PWMOPEN_Pos              (2UL)                     /*!< CGC PER1: PWMOPEN (Bit 2)                             */
#define CGC_PER1_PWMOPEN_Msk              (0x4UL)                   /*!< CGC PER1: PWMOPEN (Bitfield-Mask: 0x01)               */
#define CGC_PER1_DMAEN_Pos                (3UL)                     /*!< CGC PER1: DMAEN (Bit 3)                               */
#define CGC_PER1_DMAEN_Msk                (0x8UL)                   /*!< CGC PER1: DMAEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER1_TMMEN_Pos                (4UL)                     /*!< CGC PER1: TMMEN (Bit 4)                               */
#define CGC_PER1_TMMEN_Msk                (0x10UL)                  /*!< CGC PER1: TMMEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER1_PGACMPEN_Pos             (5UL)                     /*!< CGC PER1: PGACMPEN (Bit 5)                            */
#define CGC_PER1_PGACMPEN_Msk             (0x20UL)                  /*!< CGC PER1: PGACMPEN (Bitfield-Mask: 0x01)              */
#define CGC_PER1_TMBEN_Pos                (6UL)                     /*!< CGC PER1: TMBEN (Bit 6)                               */
#define CGC_PER1_TMBEN_Msk                (0x40UL)                  /*!< CGC PER1: TMBEN (Bitfield-Mask: 0x01)                 */
#define CGC_PER1_DACEN_Pos                (7UL)                     /*!< CGC PER1: DACEN (Bit 7)                               */
#define CGC_PER1_DACEN_Msk                (0x80UL)                  /*!< CGC PER1: DACEN (Bitfield-Mask: 0x01)                 */
/* =========================================================  PER2  ========================================================== */
#define CGC_PER2_TM81EN_Pos               (0UL)                     /*!< CGC PER2: TM81EN (Bit 0)                              */
#define CGC_PER2_TM81EN_Msk               (0x1UL)                   /*!< CGC PER2: TM81EN (Bitfield-Mask: 0x01)                */
#define CGC_PER2_CAN1EN_Pos               (1UL)                     /*!< CGC PER2: CAN1EN (Bit 1)                              */
#define CGC_PER2_CAN1EN_Msk               (0x2UL)                   /*!< CGC PER2: CAN1EN (Bitfield-Mask: 0x01)                */
#define CGC_PER2_IICA1EN_Pos              (2UL)                     /*!< CGC PER2: IICA1EN (Bit 2)                             */
#define CGC_PER2_IICA1EN_Msk              (0x4UL)                   /*!< CGC PER2: IICA1EN (Bitfield-Mask: 0x01)               */
#define CGC_PER2_SCI2EN_Pos               (3UL)                     /*!< CGC PER2: SCI2EN (Bit 3)                              */
#define CGC_PER2_SCI2EN_Msk               (0x8UL)                   /*!< CGC PER2: SCI2EN (Bitfield-Mask: 0x01)                */
#define CGC_PER2_OSDCEN_Pos               (4UL)                     /*!< CGC PER2: OSDCEN (Bit 4)                              */
#define CGC_PER2_OSDCEN_Msk               (0x10UL)                  /*!< CGC PER2: OSDCEN (Bitfield-Mask: 0x01)                */
#define CGC_PER2_CAN2EN_Pos               (5UL)                     /*!< CGC PER2: CAN2EN (Bit 5)                              */
#define CGC_PER2_CAN2EN_Msk               (0x20UL)                  /*!< CGC PER2: CAN2EN (Bitfield-Mask: 0x01)                */
#define CGC_PER2_SPIHS0EN_Pos             (6UL)                     /*!< CGC PER2: SPIHS0EN (Bit 6)                            */
#define CGC_PER2_SPIHS0EN_Msk             (0x40UL)                  /*!< CGC PER2: SPIHS0EN (Bitfield-Mask: 0x01)              */
#define CGC_PER2_SPIHS1EN_Pos             (7UL)                     /*!< CGC PER2: SPIHS1EN (Bit 7)                            */
#define CGC_PER2_SPIHS1EN_Msk             (0x80UL)                  /*!< CGC PER2: SPIHS1EN (Bitfield-Mask: 0x01)              */
/* =========================================================  PER3  ========================================================== */
#define CGC_PER3_LCDBEN_Pos               (0UL)                     /*!< CGC PER3: LCDBEN (Bit 0)                              */
#define CGC_PER3_LCDBEN_Msk               (0x1UL)                   /*!< CGC PER3: LCDBEN (Bitfield-Mask: 0x01)                */
/* =========================================================  OSMC  ========================================================== */
#define CGC_OSMC_WUTMMCK0_Pos             (4UL)                     /*!< CGC OSMC: WUTMMCK0 (Bit 4)                            */
#define CGC_OSMC_WUTMMCK0_Msk             (0x10UL)                  /*!< CGC OSMC: WUTMMCK0 (Bitfield-Mask: 0x01)              */
#define CGC_OSMC_RTCLPC_Pos               (7UL)                     /*!< CGC OSMC: RTCLPC (Bit 7)                              */
#define CGC_OSMC_RTCLPC_Msk               (0x80UL)                  /*!< CGC OSMC: RTCLPC (Bitfield-Mask: 0x01)                */
/* =========================================================  MCKC  ========================================================== */
#define CGC_MCKC_CKSELR_Pos               (0UL)                     /*!< CGC MCKC: CKSELR (Bit 0)                              */
#define CGC_MCKC_CKSELR_Msk               (0x1UL)                   /*!< CGC MCKC: CKSELR (Bitfield-Mask: 0x01)                */
#define CGC_MCKC_PDIV_Pos                 (1UL)                     /*!< CGC MCKC: PDIV (Bit 1)                                */
#define CGC_MCKC_PDIV_Msk                 (0x6UL)                   /*!< CGC MCKC: PDIV (Bitfield-Mask: 0x03)                  */
#define CGC_MCKC_CKSTR_Pos                (7UL)                     /*!< CGC MCKC: CKSTR (Bit 7)                               */
#define CGC_MCKC_CKSTR_Msk                (0x80UL)                  /*!< CGC MCKC: CKSTR (Bitfield-Mask: 0x01)                 */
/* =========================================================  PLLCR  ========================================================= */
#define CGC_PLLCR_PLLON_Pos               (0UL)                     /*!< CGC PLLCR: PLLON (Bit 0)                              */
#define CGC_PLLCR_PLLON_Msk               (0x1UL)                   /*!< CGC PLLCR: PLLON (Bitfield-Mask: 0x01)                */
#define CGC_PLLCR_PLLM_Pos                (1UL)                     /*!< CGC PLLCR: PLLM (Bit 1)                               */
#define CGC_PLLCR_PLLM_Msk                (0x2UL)                   /*!< CGC PLLCR: PLLM (Bitfield-Mask: 0x01)                 */
#define CGC_PLLCR_PLLD_Pos                (2UL)                     /*!< CGC PLLCR: PLLD (Bit 2)                               */
#define CGC_PLLCR_PLLD_Msk                (0xcUL)                   /*!< CGC PLLCR: PLLD (Bitfield-Mask: 0x03)                 */
#define CGC_PLLCR_PLLSRSEL_Pos            (7UL)                     /*!< CGC PLLCR: PLLSRSEL (Bit 7)                           */
#define CGC_PLLCR_PLLSRSEL_Msk            (0x80UL)                  /*!< CGC PLLCR: PLLSRSEL (Bitfield-Mask: 0x01)             */
/* ========================================================  HIOTRM  ========================================================= */
/* ========================================================  HOCODIV  ======================================================== */
/* ========================================================  SCMCTL  ========================================================= */
#define CGC_SCMCTL_OSDCCMP_Pos            (0UL)                     /*!< CGC SCMCTL: OSDCCMP (Bit 0)                           */
#define CGC_SCMCTL_OSDCCMP_Msk            (0xfffUL)                 /*!< CGC SCMCTL: OSDCCMP (Bitfield-Mask: 0xfff)            */
#define CGC_SCMCTL_OSCDEN_Pos             (15UL)                    /*!< CGC SCMCTL: OSCDEN (Bit 15)                           */
#define CGC_SCMCTL_OSCDEN_Msk             (0x8000UL)                /*!< CGC SCMCTL: OSCDEN (Bitfield-Mask: 0x01)              */
/* =========================================================  SCMMD  ========================================================= */
#define CGC_SCMMD_CKSEL_Pos               (0UL)                     /*!< CGC SCMMD: CKSEL (Bit 0)                              */
#define CGC_SCMMD_CKSEL_Msk               (0x1UL)                   /*!< CGC SCMMD: CKSEL (Bitfield-Mask: 0x01)                */
#define CGC_SCMMD_MDSEL_Pos               (1UL)                     /*!< CGC SCMMD: MDSEL (Bit 1)                              */
#define CGC_SCMMD_MDSEL_Msk               (0x2UL)                   /*!< CGC SCMMD: MDSEL (Bitfield-Mask: 0x01)                */
/* =========================================================  SCMST  ========================================================= */
#define CGC_SCMST_OSTDF_Pos               (0UL)                     /*!< CGC SCMST: OSTDF (Bit 0)                              */
#define CGC_SCMST_OSTDF_Msk               (0x1UL)                   /*!< CGC SCMST: OSTDF (Bitfield-Mask: 0x01)                */
/* ========================================================  HOCOFC  ========================================================= */
#define CGC_HOCOFC_FCST_Pos               (0UL)                     /*!< CGC HOCOFC: FCST (Bit 0)                              */
#define CGC_HOCOFC_FCST_Msk               (0x1UL)                   /*!< CGC HOCOFC: FCST (Bitfield-Mask: 0x01)                */
#define CGC_HOCOFC_FCIE_Pos               (6UL)                     /*!< CGC HOCOFC: FCIE (Bit 6)                              */
#define CGC_HOCOFC_FCIE_Msk               (0x40UL)                  /*!< CGC HOCOFC: FCIE (Bitfield-Mask: 0x01)                */
#define CGC_HOCOFC_FCMD_Pos               (7UL)                     /*!< CGC HOCOFC: FCMD (Bit 7)                              */
#define CGC_HOCOFC_FCMD_Msk               (0x80UL)                  /*!< CGC HOCOFC: FCMD (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                            RST                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  RESF  ========================================================== */
#define RST_RESF_LVIRF_Pos                (0UL)                     /*!< RST RESF: LVIRF (Bit 0)                               */
#define RST_RESF_LVIRF_Msk                (0x1UL)                   /*!< RST RESF: LVIRF (Bitfield-Mask: 0x01)                 */
#define RST_RESF_IAWRF_Pos                (1UL)                     /*!< RST RESF: IAWRF (Bit 1)                               */
#define RST_RESF_IAWRF_Msk                (0x2UL)                   /*!< RST RESF: IAWRF (Bitfield-Mask: 0x01)                 */
#define RST_RESF_RPERF_Pos                (2UL)                     /*!< RST RESF: RPERF (Bit 2)                               */
#define RST_RESF_RPERF_Msk                (0x4UL)                   /*!< RST RESF: RPERF (Bitfield-Mask: 0x01)                 */
#define RST_RESF_WDTRF_Pos                (4UL)                     /*!< RST RESF: WDTRF (Bit 4)                               */
#define RST_RESF_WDTRF_Msk                (0x10UL)                  /*!< RST RESF: WDTRF (Bitfield-Mask: 0x01)                 */
#define RST_RESF_SYSRF_Pos                (7UL)                     /*!< RST RESF: SYSRF (Bit 7)                               */
#define RST_RESF_SYSRF_Msk                (0x80UL)                  /*!< RST RESF: SYSRF (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                            LVD                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  LVIM  ========================================================== */
#define LVD_LVIM_LVIF_Pos                 (0UL)                     /*!< LVD LVIM: LVIF (Bit 0)                                */
#define LVD_LVIM_LVIF_Msk                 (0x1UL)                   /*!< LVD LVIM: LVIF (Bitfield-Mask: 0x01)                  */
#define LVD_LVIM_LVIOMSK_Pos              (1UL)                     /*!< LVD LVIM: LVIOMSK (Bit 1)                             */
#define LVD_LVIM_LVIOMSK_Msk              (0x2UL)                   /*!< LVD LVIM: LVIOMSK (Bitfield-Mask: 0x01)               */
#define LVD_LVIM_LVISEN_Pos               (7UL)                     /*!< LVD LVIM: LVISEN (Bit 7)                              */
#define LVD_LVIM_LVISEN_Msk               (0x80UL)                  /*!< LVD LVIM: LVISEN (Bitfield-Mask: 0x01)                */
/* =========================================================  LVIS  ========================================================== */
#define LVD_LVIS_LVILV_Pos                (0UL)                     /*!< LVD LVIS: LVILV (Bit 0)                               */
#define LVD_LVIS_LVILV_Msk                (0x1UL)                   /*!< LVD LVIS: LVILV (Bitfield-Mask: 0x01)                 */
#define LVD_LVIS_LVIMD_Pos                (7UL)                     /*!< LVD LVIS: LVIMD (Bit 7)                               */
#define LVD_LVIS_LVIMD_Msk                (0x80UL)                  /*!< LVD LVIS: LVIMD (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                           PORT                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  PM0  ========================================================== */
/* ==========================================================  PM1  ========================================================== */
/* ==========================================================  PM2  ========================================================== */
/* ==========================================================  PM3  ========================================================== */
/* ==========================================================  PM4  ========================================================== */
/* ==========================================================  PM5  ========================================================== */
/* ==========================================================  PM6  ========================================================== */
/* ==========================================================  PM7  ========================================================== */
/* ==========================================================  PM8  ========================================================== */
/* =========================================================  PM10  ========================================================== */
/* =========================================================  PM11  ========================================================== */
/* =========================================================  PM12  ========================================================== */
/* =========================================================  PM13  ========================================================== */
/* =========================================================  PM14  ========================================================== */
/* =========================================================  PM15  ========================================================== */
/* ==========================================================  P0  =========================================================== */
/* ==========================================================  P1  =========================================================== */
/* ==========================================================  P2  =========================================================== */
/* ==========================================================  P3  =========================================================== */
/* ==========================================================  P4  =========================================================== */
/* ==========================================================  P5  =========================================================== */
/* ==========================================================  P6  =========================================================== */
/* ==========================================================  P7  =========================================================== */
/* ==========================================================  P8  =========================================================== */
/* ==========================================================  P10  ========================================================== */
/* ==========================================================  P11  ========================================================== */
/* ==========================================================  P12  ========================================================== */
/* ==========================================================  P13  ========================================================== */
/* ==========================================================  P14  ========================================================== */
/* ==========================================================  P15  ========================================================== */
/* ==========================================================  PU0  ========================================================== */
/* ==========================================================  PU1  ========================================================== */
/* ==========================================================  PU3  ========================================================== */
/* ==========================================================  PU4  ========================================================== */
/* ==========================================================  PU5  ========================================================== */
/* ==========================================================  PU6  ========================================================== */
/* ==========================================================  PU7  ========================================================== */
/* ==========================================================  PU8  ========================================================== */
/* =========================================================  PU10  ========================================================== */
/* =========================================================  PU11  ========================================================== */
/* =========================================================  PU12  ========================================================== */
/* =========================================================  PU13  ========================================================== */
/* =========================================================  PU14  ========================================================== */
/* =========================================================  PIM0  ========================================================== */
/* =========================================================  PIM1  ========================================================== */
/* =========================================================  PIM3  ========================================================== */
/* =========================================================  PIM4  ========================================================== */
/* =========================================================  PIM5  ========================================================== */
/* =========================================================  PIM7  ========================================================== */
/* =========================================================  PIM8  ========================================================== */
/* =========================================================  PIM14  ========================================================= */
/* =========================================================  POM0  ========================================================== */
/* =========================================================  POM1  ========================================================== */
/* =========================================================  POM3  ========================================================== */
/* =========================================================  POM4  ========================================================== */
/* =========================================================  POM5  ========================================================== */
/* =========================================================  POM7  ========================================================== */
/* =========================================================  POM8  ========================================================== */
/* =========================================================  POM14  ========================================================= */
/* =========================================================  PMC0  ========================================================== */
/* =========================================================  PMC1  ========================================================== */
/* =========================================================  PMC2  ========================================================== */
/* =========================================================  PMC10  ========================================================= */
/* =========================================================  PMC12  ========================================================= */
/* =========================================================  PMC13  ========================================================= */
/* =========================================================  PMC14  ========================================================= */
/* =========================================================  PMC15  ========================================================= */
/* =========================================================  PSET0  ========================================================= */
/* =========================================================  PSET1  ========================================================= */
/* =========================================================  PSET2  ========================================================= */
/* =========================================================  PSET3  ========================================================= */
/* =========================================================  PSET4  ========================================================= */
/* =========================================================  PSET5  ========================================================= */
/* =========================================================  PSET6  ========================================================= */
/* =========================================================  PSET7  ========================================================= */
/* =========================================================  PSET8  ========================================================= */
/* ========================================================  PSET10  ========================================================= */
/* ========================================================  PSET11  ========================================================= */
/* ========================================================  PSET12  ========================================================= */
/* ========================================================  PSET13  ========================================================= */
/* ========================================================  PSET14  ========================================================= */
/* ========================================================  PSET15  ========================================================= */
/* =========================================================  PCLR0  ========================================================= */
/* =========================================================  PCLR1  ========================================================= */
/* =========================================================  PCLR2  ========================================================= */
/* =========================================================  PCLR3  ========================================================= */
/* =========================================================  PCLR4  ========================================================= */
/* =========================================================  PCLR5  ========================================================= */
/* =========================================================  PCLR6  ========================================================= */
/* =========================================================  PCLR7  ========================================================= */
/* =========================================================  PCLR8  ========================================================= */
/* ========================================================  PCLR10  ========================================================= */
/* ========================================================  PCLR11  ========================================================= */
/* ========================================================  PCLR12  ========================================================= */
/* ========================================================  PCLR13  ========================================================= */
/* ========================================================  PCLR14  ========================================================= */
/* ========================================================  PCLR15  ========================================================= */
/* ========================================================  PREAD0  ========================================================= */
/* ========================================================  PREAD1  ========================================================= */
/* ========================================================  PREAD2  ========================================================= */
/* ========================================================  PREAD3  ========================================================= */
/* ========================================================  PREAD4  ========================================================= */
/* ========================================================  PREAD5  ========================================================= */
/* ========================================================  PREAD6  ========================================================= */
/* ========================================================  PREAD7  ========================================================= */
/* ========================================================  PREAD8  ========================================================= */
/* ========================================================  PREAD10  ======================================================== */
/* ========================================================  PREAD11  ======================================================== */
/* ========================================================  PREAD12  ======================================================== */
/* ========================================================  PREAD13  ======================================================== */
/* ========================================================  PREAD14  ======================================================== */
/* ========================================================  PREAD15  ======================================================== */
/* =========================================================  PIOR0  ========================================================= */
/* =========================================================  PIOR1  ========================================================= */
/* =========================================================  PIOR2  ========================================================= */
/* =========================================================  PIOR3  ========================================================= */
/* =========================================================  PIOR4  ========================================================= */
/* ==========================================================  PMS  ========================================================== */
/* ========================================================  GDIDIS  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            DIV                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  DIVIDEND  ======================================================== */
/* ========================================================  DIVISOR  ======================================================== */
/* =======================================================  QUOTIENT  ======================================================== */
/* =======================================================  REMAINDER  ======================================================= */
/* ========================================================  STATUS  ========================================================= */
#define DIV_STATUS_BUSY_Pos               (8UL)                     /*!< DIV STATUS: BUSY (Bit 8)                              */
#define DIV_STATUS_BUSY_Msk               (0x100UL)                 /*!< DIV STATUS: BUSY (Bitfield-Mask: 0x01)                */
#define DIV_STATUS_DIVBYZERO_Pos          (9UL)                     /*!< DIV STATUS: DIVBYZERO (Bit 9)                         */
#define DIV_STATUS_DIVBYZERO_Msk          (0x200UL)                 /*!< DIV STATUS: DIVBYZERO (Bitfield-Mask: 0x01)           */


/* =========================================================================================================================== */
/* ================                                           TM40                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TCR0  ========================================================== */
/* =========================================================  TMR00  ========================================================= */
#define TM40_TMR00_MD_Pos                 (0UL)                     /*!< TM40 TMR00: MD (Bit 0)                                */
#define TM40_TMR00_MD_Msk                 (0xfUL)                   /*!< TM40 TMR00: MD (Bitfield-Mask: 0x0f)                  */
#define TM40_TMR00_CIS_Pos                (6UL)                     /*!< TM40 TMR00: CIS (Bit 6)                               */
#define TM40_TMR00_CIS_Msk                (0xc0UL)                  /*!< TM40 TMR00: CIS (Bitfield-Mask: 0x03)                 */
#define TM40_TMR00_STS_Pos                (8UL)                     /*!< TM40 TMR00: STS (Bit 8)                               */
#define TM40_TMR00_STS_Msk                (0x700UL)                 /*!< TM40 TMR00: STS (Bitfield-Mask: 0x07)                 */
#define TM40_TMR00_CCS_Pos                (12UL)                    /*!< TM40 TMR00: CCS (Bit 12)                              */
#define TM40_TMR00_CCS_Msk                (0x1000UL)                /*!< TM40 TMR00: CCS (Bitfield-Mask: 0x01)                 */
#define TM40_TMR00_CKS_Pos                (14UL)                    /*!< TM40 TMR00: CKS (Bit 14)                              */
#define TM40_TMR00_CKS_Msk                (0xc000UL)                /*!< TM40 TMR00: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR01  ========================================================= */
#define TM40_TMR01_MD_Pos                 (0UL)                     /*!< TM40 TMR01: MD (Bit 0)                                */
#define TM40_TMR01_MD_Msk                 (0xfUL)                   /*!< TM40 TMR01: MD (Bitfield-Mask: 0x0f)                  */
#define TM40_TMR01_CIS_Pos                (6UL)                     /*!< TM40 TMR01: CIS (Bit 6)                               */
#define TM40_TMR01_CIS_Msk                (0xc0UL)                  /*!< TM40 TMR01: CIS (Bitfield-Mask: 0x03)                 */
#define TM40_TMR01_STS_Pos                (8UL)                     /*!< TM40 TMR01: STS (Bit 8)                               */
#define TM40_TMR01_STS_Msk                (0x700UL)                 /*!< TM40 TMR01: STS (Bitfield-Mask: 0x07)                 */
#define TM40_TMR01_SPLIT_Pos              (11UL)                    /*!< TM40 TMR01: SPLIT (Bit 11)                            */
#define TM40_TMR01_SPLIT_Msk              (0x800UL)                 /*!< TM40 TMR01: SPLIT (Bitfield-Mask: 0x01)               */
#define TM40_TMR01_CCS_Pos                (12UL)                    /*!< TM40 TMR01: CCS (Bit 12)                              */
#define TM40_TMR01_CCS_Msk                (0x1000UL)                /*!< TM40 TMR01: CCS (Bitfield-Mask: 0x01)                 */
#define TM40_TMR01_CKS_Pos                (14UL)                    /*!< TM40 TMR01: CKS (Bit 14)                              */
#define TM40_TMR01_CKS_Msk                (0xc000UL)                /*!< TM40 TMR01: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR02  ========================================================= */
#define TM40_TMR02_MD_Pos                 (0UL)                     /*!< TM40 TMR02: MD (Bit 0)                                */
#define TM40_TMR02_MD_Msk                 (0xfUL)                   /*!< TM40 TMR02: MD (Bitfield-Mask: 0x0f)                  */
#define TM40_TMR02_CIS_Pos                (6UL)                     /*!< TM40 TMR02: CIS (Bit 6)                               */
#define TM40_TMR02_CIS_Msk                (0xc0UL)                  /*!< TM40 TMR02: CIS (Bitfield-Mask: 0x03)                 */
#define TM40_TMR02_STS_Pos                (8UL)                     /*!< TM40 TMR02: STS (Bit 8)                               */
#define TM40_TMR02_STS_Msk                (0x700UL)                 /*!< TM40 TMR02: STS (Bitfield-Mask: 0x07)                 */
#define TM40_TMR02_MASTER_Pos             (11UL)                    /*!< TM40 TMR02: MASTER (Bit 11)                           */
#define TM40_TMR02_MASTER_Msk             (0x800UL)                 /*!< TM40 TMR02: MASTER (Bitfield-Mask: 0x01)              */
#define TM40_TMR02_CCS_Pos                (12UL)                    /*!< TM40 TMR02: CCS (Bit 12)                              */
#define TM40_TMR02_CCS_Msk                (0x1000UL)                /*!< TM40 TMR02: CCS (Bitfield-Mask: 0x01)                 */
#define TM40_TMR02_CKS_Pos                (14UL)                    /*!< TM40 TMR02: CKS (Bit 14)                              */
#define TM40_TMR02_CKS_Msk                (0xc000UL)                /*!< TM40 TMR02: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR03  ========================================================= */
#define TM40_TMR03_MD_Pos                 (0UL)                     /*!< TM40 TMR03: MD (Bit 0)                                */
#define TM40_TMR03_MD_Msk                 (0xfUL)                   /*!< TM40 TMR03: MD (Bitfield-Mask: 0x0f)                  */
#define TM40_TMR03_CIS_Pos                (6UL)                     /*!< TM40 TMR03: CIS (Bit 6)                               */
#define TM40_TMR03_CIS_Msk                (0xc0UL)                  /*!< TM40 TMR03: CIS (Bitfield-Mask: 0x03)                 */
#define TM40_TMR03_STS_Pos                (8UL)                     /*!< TM40 TMR03: STS (Bit 8)                               */
#define TM40_TMR03_STS_Msk                (0x700UL)                 /*!< TM40 TMR03: STS (Bitfield-Mask: 0x07)                 */
#define TM40_TMR03_SPLIT_Pos              (11UL)                    /*!< TM40 TMR03: SPLIT (Bit 11)                            */
#define TM40_TMR03_SPLIT_Msk              (0x800UL)                 /*!< TM40 TMR03: SPLIT (Bitfield-Mask: 0x01)               */
#define TM40_TMR03_CCS_Pos                (12UL)                    /*!< TM40 TMR03: CCS (Bit 12)                              */
#define TM40_TMR03_CCS_Msk                (0x1000UL)                /*!< TM40 TMR03: CCS (Bitfield-Mask: 0x01)                 */
#define TM40_TMR03_CKS_Pos                (14UL)                    /*!< TM40 TMR03: CKS (Bit 14)                              */
#define TM40_TMR03_CKS_Msk                (0xc000UL)                /*!< TM40 TMR03: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TSR00  ========================================================= */
#define TM40_TSR00_OVF_Pos                (0UL)                     /*!< TM40 TSR00: OVF (Bit 0)                               */
#define TM40_TSR00_OVF_Msk                (0x1UL)                   /*!< TM40 TSR00: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR01  ========================================================= */
#define TM40_TSR01_OVF_Pos                (0UL)                     /*!< TM40 TSR01: OVF (Bit 0)                               */
#define TM40_TSR01_OVF_Msk                (0x1UL)                   /*!< TM40 TSR01: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR02  ========================================================= */
#define TM40_TSR02_OVF_Pos                (0UL)                     /*!< TM40 TSR02: OVF (Bit 0)                               */
#define TM40_TSR02_OVF_Msk                (0x1UL)                   /*!< TM40 TSR02: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR03  ========================================================= */
#define TM40_TSR03_OVF_Pos                (0UL)                     /*!< TM40 TSR03: OVF (Bit 0)                               */
#define TM40_TSR03_OVF_Msk                (0x1UL)                   /*!< TM40 TSR03: OVF (Bitfield-Mask: 0x01)                 */
/* ==========================================================  TE0  ========================================================== */
#define TM40_TE0_TE00_Pos                 (0UL)                     /*!< TM40 TE0: TE00 (Bit 0)                                */
#define TM40_TE0_TE00_Msk                 (0x1UL)                   /*!< TM40 TE0: TE00 (Bitfield-Mask: 0x01)                  */
#define TM40_TE0_TE01_Pos                 (1UL)                     /*!< TM40 TE0: TE01 (Bit 1)                                */
#define TM40_TE0_TE01_Msk                 (0x2UL)                   /*!< TM40 TE0: TE01 (Bitfield-Mask: 0x01)                  */
#define TM40_TE0_TE02_Pos                 (2UL)                     /*!< TM40 TE0: TE02 (Bit 2)                                */
#define TM40_TE0_TE02_Msk                 (0x4UL)                   /*!< TM40 TE0: TE02 (Bitfield-Mask: 0x01)                  */
#define TM40_TE0_TE03_Pos                 (3UL)                     /*!< TM40 TE0: TE03 (Bit 3)                                */
#define TM40_TE0_TE03_Msk                 (0x8UL)                   /*!< TM40 TE0: TE03 (Bitfield-Mask: 0x01)                  */
#define TM40_TE0_TEH01_Pos                (9UL)                     /*!< TM40 TE0: TEH01 (Bit 9)                               */
#define TM40_TE0_TEH01_Msk                (0x200UL)                 /*!< TM40 TE0: TEH01 (Bitfield-Mask: 0x01)                 */
#define TM40_TE0_TEH03_Pos                (11UL)                    /*!< TM40 TE0: TEH03 (Bit 11)                              */
#define TM40_TE0_TEH03_Msk                (0x800UL)                 /*!< TM40 TE0: TEH03 (Bitfield-Mask: 0x01)                 */
/* ==========================================================  TS0  ========================================================== */
#define TM40_TS0_TS00_Pos                 (0UL)                     /*!< TM40 TS0: TS00 (Bit 0)                                */
#define TM40_TS0_TS00_Msk                 (0x1UL)                   /*!< TM40 TS0: TS00 (Bitfield-Mask: 0x01)                  */
#define TM40_TS0_TS01_Pos                 (1UL)                     /*!< TM40 TS0: TS01 (Bit 1)                                */
#define TM40_TS0_TS01_Msk                 (0x2UL)                   /*!< TM40 TS0: TS01 (Bitfield-Mask: 0x01)                  */
#define TM40_TS0_TS02_Pos                 (2UL)                     /*!< TM40 TS0: TS02 (Bit 2)                                */
#define TM40_TS0_TS02_Msk                 (0x4UL)                   /*!< TM40 TS0: TS02 (Bitfield-Mask: 0x01)                  */
#define TM40_TS0_TS03_Pos                 (3UL)                     /*!< TM40 TS0: TS03 (Bit 3)                                */
#define TM40_TS0_TS03_Msk                 (0x8UL)                   /*!< TM40 TS0: TS03 (Bitfield-Mask: 0x01)                  */
#define TM40_TS0_TSH01_Pos                (9UL)                     /*!< TM40 TS0: TSH01 (Bit 9)                               */
#define TM40_TS0_TSH01_Msk                (0x200UL)                 /*!< TM40 TS0: TSH01 (Bitfield-Mask: 0x01)                 */
#define TM40_TS0_TSH03_Pos                (11UL)                    /*!< TM40 TS0: TSH03 (Bit 11)                              */
#define TM40_TS0_TSH03_Msk                (0x800UL)                 /*!< TM40 TS0: TSH03 (Bitfield-Mask: 0x01)                 */
/* ==========================================================  TT0  ========================================================== */
#define TM40_TT0_TT00_Pos                 (0UL)                     /*!< TM40 TT0: TT00 (Bit 0)                                */
#define TM40_TT0_TT00_Msk                 (0x1UL)                   /*!< TM40 TT0: TT00 (Bitfield-Mask: 0x01)                  */
#define TM40_TT0_TT01_Pos                 (1UL)                     /*!< TM40 TT0: TT01 (Bit 1)                                */
#define TM40_TT0_TT01_Msk                 (0x2UL)                   /*!< TM40 TT0: TT01 (Bitfield-Mask: 0x01)                  */
#define TM40_TT0_TT02_Pos                 (2UL)                     /*!< TM40 TT0: TT02 (Bit 2)                                */
#define TM40_TT0_TT02_Msk                 (0x4UL)                   /*!< TM40 TT0: TT02 (Bitfield-Mask: 0x01)                  */
#define TM40_TT0_TT03_Pos                 (3UL)                     /*!< TM40 TT0: TT03 (Bit 3)                                */
#define TM40_TT0_TT03_Msk                 (0x8UL)                   /*!< TM40 TT0: TT03 (Bitfield-Mask: 0x01)                  */
#define TM40_TT0_TTH01_Pos                (9UL)                     /*!< TM40 TT0: TTH01 (Bit 9)                               */
#define TM40_TT0_TTH01_Msk                (0x200UL)                 /*!< TM40 TT0: TTH01 (Bitfield-Mask: 0x01)                 */
#define TM40_TT0_TTH03_Pos                (11UL)                    /*!< TM40 TT0: TTH03 (Bit 11)                              */
#define TM40_TT0_TTH03_Msk                (0x800UL)                 /*!< TM40 TT0: TTH03 (Bitfield-Mask: 0x01)                 */
/* =========================================================  TPS0  ========================================================== */
#define TM40_TPS0_PRS00_Pos               (0UL)                     /*!< TM40 TPS0: PRS00 (Bit 0)                              */
#define TM40_TPS0_PRS00_Msk               (0xfUL)                   /*!< TM40 TPS0: PRS00 (Bitfield-Mask: 0x0f)                */
#define TM40_TPS0_PRS01_Pos               (4UL)                     /*!< TM40 TPS0: PRS01 (Bit 4)                              */
#define TM40_TPS0_PRS01_Msk               (0xf0UL)                  /*!< TM40 TPS0: PRS01 (Bitfield-Mask: 0x0f)                */
#define TM40_TPS0_PRS02_Pos               (8UL)                     /*!< TM40 TPS0: PRS02 (Bit 8)                              */
#define TM40_TPS0_PRS02_Msk               (0x300UL)                 /*!< TM40 TPS0: PRS02 (Bitfield-Mask: 0x03)                */
#define TM40_TPS0_PRS03_Pos               (12UL)                    /*!< TM40 TPS0: PRS03 (Bit 12)                             */
#define TM40_TPS0_PRS03_Msk               (0x3000UL)                /*!< TM40 TPS0: PRS03 (Bitfield-Mask: 0x03)                */
/* ==========================================================  TO0  ========================================================== */
#define TM40_TO0_TO00_Pos                 (0UL)                     /*!< TM40 TO0: TO00 (Bit 0)                                */
#define TM40_TO0_TO00_Msk                 (0x1UL)                   /*!< TM40 TO0: TO00 (Bitfield-Mask: 0x01)                  */
#define TM40_TO0_TO01_Pos                 (1UL)                     /*!< TM40 TO0: TO01 (Bit 1)                                */
#define TM40_TO0_TO01_Msk                 (0x2UL)                   /*!< TM40 TO0: TO01 (Bitfield-Mask: 0x01)                  */
#define TM40_TO0_TO02_Pos                 (2UL)                     /*!< TM40 TO0: TO02 (Bit 2)                                */
#define TM40_TO0_TO02_Msk                 (0x4UL)                   /*!< TM40 TO0: TO02 (Bitfield-Mask: 0x01)                  */
#define TM40_TO0_TO03_Pos                 (3UL)                     /*!< TM40 TO0: TO03 (Bit 3)                                */
#define TM40_TO0_TO03_Msk                 (0x8UL)                   /*!< TM40 TO0: TO03 (Bitfield-Mask: 0x01)                  */
/* =========================================================  TOE0  ========================================================== */
#define TM40_TOE0_TOE00_Pos               (0UL)                     /*!< TM40 TOE0: TOE00 (Bit 0)                              */
#define TM40_TOE0_TOE00_Msk               (0x1UL)                   /*!< TM40 TOE0: TOE00 (Bitfield-Mask: 0x01)                */
#define TM40_TOE0_TOE01_Pos               (1UL)                     /*!< TM40 TOE0: TOE01 (Bit 1)                              */
#define TM40_TOE0_TOE01_Msk               (0x2UL)                   /*!< TM40 TOE0: TOE01 (Bitfield-Mask: 0x01)                */
#define TM40_TOE0_TOE02_Pos               (2UL)                     /*!< TM40 TOE0: TOE02 (Bit 2)                              */
#define TM40_TOE0_TOE02_Msk               (0x4UL)                   /*!< TM40 TOE0: TOE02 (Bitfield-Mask: 0x01)                */
#define TM40_TOE0_TOE03_Pos               (3UL)                     /*!< TM40 TOE0: TOE03 (Bit 3)                              */
#define TM40_TOE0_TOE03_Msk               (0x8UL)                   /*!< TM40 TOE0: TOE03 (Bitfield-Mask: 0x01)                */
/* =========================================================  TOL0  ========================================================== */
#define TM40_TOL0_TOL01_Pos               (1UL)                     /*!< TM40 TOL0: TOL01 (Bit 1)                              */
#define TM40_TOL0_TOL01_Msk               (0x2UL)                   /*!< TM40 TOL0: TOL01 (Bitfield-Mask: 0x01)                */
#define TM40_TOL0_TOL02_Pos               (2UL)                     /*!< TM40 TOL0: TOL02 (Bit 2)                              */
#define TM40_TOL0_TOL02_Msk               (0x4UL)                   /*!< TM40 TOL0: TOL02 (Bitfield-Mask: 0x01)                */
#define TM40_TOL0_TOL03_Pos               (3UL)                     /*!< TM40 TOL0: TOL03 (Bit 3)                              */
#define TM40_TOL0_TOL03_Msk               (0x8UL)                   /*!< TM40 TOL0: TOL03 (Bitfield-Mask: 0x01)                */
/* =========================================================  TOM0  ========================================================== */
#define TM40_TOM0_TOM01_Pos               (1UL)                     /*!< TM40 TOM0: TOM01 (Bit 1)                              */
#define TM40_TOM0_TOM01_Msk               (0x2UL)                   /*!< TM40 TOM0: TOM01 (Bitfield-Mask: 0x01)                */
#define TM40_TOM0_TOM02_Pos               (2UL)                     /*!< TM40 TOM0: TOM02 (Bit 2)                              */
#define TM40_TOM0_TOM02_Msk               (0x4UL)                   /*!< TM40 TOM0: TOM02 (Bitfield-Mask: 0x01)                */
#define TM40_TOM0_TOM03_Pos               (3UL)                     /*!< TM40 TOM0: TOM03 (Bit 3)                              */
#define TM40_TOM0_TOM03_Msk               (0x8UL)                   /*!< TM40 TOM0: TOM03 (Bitfield-Mask: 0x01)                */
/* =========================================================  TDR0  ========================================================== */
/* ========================================================  TDR01L  ========================================================= */
/* ========================================================  TDR01H  ========================================================= */
/* ========================================================  TDR03L  ========================================================= */
/* ========================================================  TDR03H  ========================================================= */


/* =========================================================================================================================== */
/* ================                                           TM81                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TCR1  ========================================================== */
/* =========================================================  TMR10  ========================================================= */
#define TM81_TMR10_MD_Pos                 (0UL)                     /*!< TM81 TMR10: MD (Bit 0)                                */
#define TM81_TMR10_MD_Msk                 (0xfUL)                   /*!< TM81 TMR10: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR10_CIS_Pos                (6UL)                     /*!< TM81 TMR10: CIS (Bit 6)                               */
#define TM81_TMR10_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR10: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR10_STS_Pos                (8UL)                     /*!< TM81 TMR10: STS (Bit 8)                               */
#define TM81_TMR10_STS_Msk                (0x700UL)                 /*!< TM81 TMR10: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR10_CCS_Pos                (12UL)                    /*!< TM81 TMR10: CCS (Bit 12)                              */
#define TM81_TMR10_CCS_Msk                (0x1000UL)                /*!< TM81 TMR10: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR10_CKS_Pos                (14UL)                    /*!< TM81 TMR10: CKS (Bit 14)                              */
#define TM81_TMR10_CKS_Msk                (0xc000UL)                /*!< TM81 TMR10: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR11  ========================================================= */
#define TM81_TMR11_MD_Pos                 (0UL)                     /*!< TM81 TMR11: MD (Bit 0)                                */
#define TM81_TMR11_MD_Msk                 (0xfUL)                   /*!< TM81 TMR11: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR11_CIS_Pos                (6UL)                     /*!< TM81 TMR11: CIS (Bit 6)                               */
#define TM81_TMR11_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR11: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR11_STS_Pos                (8UL)                     /*!< TM81 TMR11: STS (Bit 8)                               */
#define TM81_TMR11_STS_Msk                (0x700UL)                 /*!< TM81 TMR11: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR11_SPLIT_Pos              (11UL)                    /*!< TM81 TMR11: SPLIT (Bit 11)                            */
#define TM81_TMR11_SPLIT_Msk              (0x800UL)                 /*!< TM81 TMR11: SPLIT (Bitfield-Mask: 0x01)               */
#define TM81_TMR11_CCS_Pos                (12UL)                    /*!< TM81 TMR11: CCS (Bit 12)                              */
#define TM81_TMR11_CCS_Msk                (0x1000UL)                /*!< TM81 TMR11: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR11_CKS_Pos                (14UL)                    /*!< TM81 TMR11: CKS (Bit 14)                              */
#define TM81_TMR11_CKS_Msk                (0xc000UL)                /*!< TM81 TMR11: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR12  ========================================================= */
#define TM81_TMR12_MD_Pos                 (0UL)                     /*!< TM81 TMR12: MD (Bit 0)                                */
#define TM81_TMR12_MD_Msk                 (0xfUL)                   /*!< TM81 TMR12: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR12_CIS_Pos                (6UL)                     /*!< TM81 TMR12: CIS (Bit 6)                               */
#define TM81_TMR12_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR12: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR12_STS_Pos                (8UL)                     /*!< TM81 TMR12: STS (Bit 8)                               */
#define TM81_TMR12_STS_Msk                (0x700UL)                 /*!< TM81 TMR12: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR12_MASTER_Pos             (11UL)                    /*!< TM81 TMR12: MASTER (Bit 11)                           */
#define TM81_TMR12_MASTER_Msk             (0x800UL)                 /*!< TM81 TMR12: MASTER (Bitfield-Mask: 0x01)              */
#define TM81_TMR12_CCS_Pos                (12UL)                    /*!< TM81 TMR12: CCS (Bit 12)                              */
#define TM81_TMR12_CCS_Msk                (0x1000UL)                /*!< TM81 TMR12: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR12_CKS_Pos                (14UL)                    /*!< TM81 TMR12: CKS (Bit 14)                              */
#define TM81_TMR12_CKS_Msk                (0xc000UL)                /*!< TM81 TMR12: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR13  ========================================================= */
#define TM81_TMR13_MD_Pos                 (0UL)                     /*!< TM81 TMR13: MD (Bit 0)                                */
#define TM81_TMR13_MD_Msk                 (0xfUL)                   /*!< TM81 TMR13: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR13_CIS_Pos                (6UL)                     /*!< TM81 TMR13: CIS (Bit 6)                               */
#define TM81_TMR13_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR13: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR13_STS_Pos                (8UL)                     /*!< TM81 TMR13: STS (Bit 8)                               */
#define TM81_TMR13_STS_Msk                (0x700UL)                 /*!< TM81 TMR13: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR13_SPLIT_Pos              (11UL)                    /*!< TM81 TMR13: SPLIT (Bit 11)                            */
#define TM81_TMR13_SPLIT_Msk              (0x800UL)                 /*!< TM81 TMR13: SPLIT (Bitfield-Mask: 0x01)               */
#define TM81_TMR13_CCS_Pos                (12UL)                    /*!< TM81 TMR13: CCS (Bit 12)                              */
#define TM81_TMR13_CCS_Msk                (0x1000UL)                /*!< TM81 TMR13: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR13_CKS_Pos                (14UL)                    /*!< TM81 TMR13: CKS (Bit 14)                              */
#define TM81_TMR13_CKS_Msk                (0xc000UL)                /*!< TM81 TMR13: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR14  ========================================================= */
#define TM81_TMR14_MD_Pos                 (0UL)                     /*!< TM81 TMR14: MD (Bit 0)                                */
#define TM81_TMR14_MD_Msk                 (0xfUL)                   /*!< TM81 TMR14: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR14_CIS_Pos                (6UL)                     /*!< TM81 TMR14: CIS (Bit 6)                               */
#define TM81_TMR14_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR14: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR14_STS_Pos                (8UL)                     /*!< TM81 TMR14: STS (Bit 8)                               */
#define TM81_TMR14_STS_Msk                (0x700UL)                 /*!< TM81 TMR14: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR14_MASTER_Pos             (11UL)                    /*!< TM81 TMR14: MASTER (Bit 11)                           */
#define TM81_TMR14_MASTER_Msk             (0x800UL)                 /*!< TM81 TMR14: MASTER (Bitfield-Mask: 0x01)              */
#define TM81_TMR14_CCS_Pos                (12UL)                    /*!< TM81 TMR14: CCS (Bit 12)                              */
#define TM81_TMR14_CCS_Msk                (0x1000UL)                /*!< TM81 TMR14: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR14_CKS_Pos                (14UL)                    /*!< TM81 TMR14: CKS (Bit 14)                              */
#define TM81_TMR14_CKS_Msk                (0xc000UL)                /*!< TM81 TMR14: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR15  ========================================================= */
#define TM81_TMR15_MD_Pos                 (0UL)                     /*!< TM81 TMR15: MD (Bit 0)                                */
#define TM81_TMR15_MD_Msk                 (0xfUL)                   /*!< TM81 TMR15: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR15_CIS_Pos                (6UL)                     /*!< TM81 TMR15: CIS (Bit 6)                               */
#define TM81_TMR15_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR15: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR15_STS_Pos                (8UL)                     /*!< TM81 TMR15: STS (Bit 8)                               */
#define TM81_TMR15_STS_Msk                (0x700UL)                 /*!< TM81 TMR15: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR15_CCS_Pos                (12UL)                    /*!< TM81 TMR15: CCS (Bit 12)                              */
#define TM81_TMR15_CCS_Msk                (0x1000UL)                /*!< TM81 TMR15: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR15_CKS_Pos                (14UL)                    /*!< TM81 TMR15: CKS (Bit 14)                              */
#define TM81_TMR15_CKS_Msk                (0xc000UL)                /*!< TM81 TMR15: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR16  ========================================================= */
#define TM81_TMR16_MD_Pos                 (0UL)                     /*!< TM81 TMR16: MD (Bit 0)                                */
#define TM81_TMR16_MD_Msk                 (0xfUL)                   /*!< TM81 TMR16: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR16_CIS_Pos                (6UL)                     /*!< TM81 TMR16: CIS (Bit 6)                               */
#define TM81_TMR16_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR16: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR16_STS_Pos                (8UL)                     /*!< TM81 TMR16: STS (Bit 8)                               */
#define TM81_TMR16_STS_Msk                (0x700UL)                 /*!< TM81 TMR16: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR16_MASTER_Pos             (11UL)                    /*!< TM81 TMR16: MASTER (Bit 11)                           */
#define TM81_TMR16_MASTER_Msk             (0x800UL)                 /*!< TM81 TMR16: MASTER (Bitfield-Mask: 0x01)              */
#define TM81_TMR16_CCS_Pos                (12UL)                    /*!< TM81 TMR16: CCS (Bit 12)                              */
#define TM81_TMR16_CCS_Msk                (0x1000UL)                /*!< TM81 TMR16: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR16_CKS_Pos                (14UL)                    /*!< TM81 TMR16: CKS (Bit 14)                              */
#define TM81_TMR16_CKS_Msk                (0xc000UL)                /*!< TM81 TMR16: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMR17  ========================================================= */
#define TM81_TMR17_MD_Pos                 (0UL)                     /*!< TM81 TMR17: MD (Bit 0)                                */
#define TM81_TMR17_MD_Msk                 (0xfUL)                   /*!< TM81 TMR17: MD (Bitfield-Mask: 0x0f)                  */
#define TM81_TMR17_CIS_Pos                (6UL)                     /*!< TM81 TMR17: CIS (Bit 6)                               */
#define TM81_TMR17_CIS_Msk                (0xc0UL)                  /*!< TM81 TMR17: CIS (Bitfield-Mask: 0x03)                 */
#define TM81_TMR17_STS_Pos                (8UL)                     /*!< TM81 TMR17: STS (Bit 8)                               */
#define TM81_TMR17_STS_Msk                (0x700UL)                 /*!< TM81 TMR17: STS (Bitfield-Mask: 0x07)                 */
#define TM81_TMR17_CCS_Pos                (12UL)                    /*!< TM81 TMR17: CCS (Bit 12)                              */
#define TM81_TMR17_CCS_Msk                (0x1000UL)                /*!< TM81 TMR17: CCS (Bitfield-Mask: 0x01)                 */
#define TM81_TMR17_CKS_Pos                (14UL)                    /*!< TM81 TMR17: CKS (Bit 14)                              */
#define TM81_TMR17_CKS_Msk                (0xc000UL)                /*!< TM81 TMR17: CKS (Bitfield-Mask: 0x03)                 */
/* =========================================================  TSR10  ========================================================= */
#define TM81_TSR10_OVF_Pos                (0UL)                     /*!< TM81 TSR10: OVF (Bit 0)                               */
#define TM81_TSR10_OVF_Msk                (0x1UL)                   /*!< TM81 TSR10: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR11  ========================================================= */
#define TM81_TSR11_OVF_Pos                (0UL)                     /*!< TM81 TSR11: OVF (Bit 0)                               */
#define TM81_TSR11_OVF_Msk                (0x1UL)                   /*!< TM81 TSR11: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR12  ========================================================= */
#define TM81_TSR12_OVF_Pos                (0UL)                     /*!< TM81 TSR12: OVF (Bit 0)                               */
#define TM81_TSR12_OVF_Msk                (0x1UL)                   /*!< TM81 TSR12: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR13  ========================================================= */
#define TM81_TSR13_OVF_Pos                (0UL)                     /*!< TM81 TSR13: OVF (Bit 0)                               */
#define TM81_TSR13_OVF_Msk                (0x1UL)                   /*!< TM81 TSR13: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR14  ========================================================= */
#define TM81_TSR14_OVF_Pos                (0UL)                     /*!< TM81 TSR14: OVF (Bit 0)                               */
#define TM81_TSR14_OVF_Msk                (0x1UL)                   /*!< TM81 TSR14: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR15  ========================================================= */
#define TM81_TSR15_OVF_Pos                (0UL)                     /*!< TM81 TSR15: OVF (Bit 0)                               */
#define TM81_TSR15_OVF_Msk                (0x1UL)                   /*!< TM81 TSR15: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR16  ========================================================= */
#define TM81_TSR16_OVF_Pos                (0UL)                     /*!< TM81 TSR16: OVF (Bit 0)                               */
#define TM81_TSR16_OVF_Msk                (0x1UL)                   /*!< TM81 TSR16: OVF (Bitfield-Mask: 0x01)                 */
/* =========================================================  TSR17  ========================================================= */
#define TM81_TSR17_OVF_Pos                (0UL)                     /*!< TM81 TSR17: OVF (Bit 0)                               */
#define TM81_TSR17_OVF_Msk                (0x1UL)                   /*!< TM81 TSR17: OVF (Bitfield-Mask: 0x01)                 */
/* ==========================================================  TE1  ========================================================== */
#define TM81_TE1_TE10_Pos                 (0UL)                     /*!< TM81 TE1: TE10 (Bit 0)                                */
#define TM81_TE1_TE10_Msk                 (0x1UL)                   /*!< TM81 TE1: TE10 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE11_Pos                 (1UL)                     /*!< TM81 TE1: TE11 (Bit 1)                                */
#define TM81_TE1_TE11_Msk                 (0x2UL)                   /*!< TM81 TE1: TE11 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE12_Pos                 (2UL)                     /*!< TM81 TE1: TE12 (Bit 2)                                */
#define TM81_TE1_TE12_Msk                 (0x4UL)                   /*!< TM81 TE1: TE12 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE13_Pos                 (3UL)                     /*!< TM81 TE1: TE13 (Bit 3)                                */
#define TM81_TE1_TE13_Msk                 (0x8UL)                   /*!< TM81 TE1: TE13 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE14_Pos                 (4UL)                     /*!< TM81 TE1: TE14 (Bit 4)                                */
#define TM81_TE1_TE14_Msk                 (0x10UL)                  /*!< TM81 TE1: TE14 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE15_Pos                 (5UL)                     /*!< TM81 TE1: TE15 (Bit 5)                                */
#define TM81_TE1_TE15_Msk                 (0x20UL)                  /*!< TM81 TE1: TE15 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE16_Pos                 (6UL)                     /*!< TM81 TE1: TE16 (Bit 6)                                */
#define TM81_TE1_TE16_Msk                 (0x40UL)                  /*!< TM81 TE1: TE16 (Bitfield-Mask: 0x01)                  */
#define TM81_TE1_TE17_Pos                 (7UL)                     /*!< TM81 TE1: TE17 (Bit 7)                                */
#define TM81_TE1_TE17_Msk                 (0x80UL)                  /*!< TM81 TE1: TE17 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  TS1  ========================================================== */
#define TM81_TS1_TS10_Pos                 (0UL)                     /*!< TM81 TS1: TS10 (Bit 0)                                */
#define TM81_TS1_TS10_Msk                 (0x1UL)                   /*!< TM81 TS1: TS10 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS11_Pos                 (1UL)                     /*!< TM81 TS1: TS11 (Bit 1)                                */
#define TM81_TS1_TS11_Msk                 (0x2UL)                   /*!< TM81 TS1: TS11 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS12_Pos                 (2UL)                     /*!< TM81 TS1: TS12 (Bit 2)                                */
#define TM81_TS1_TS12_Msk                 (0x4UL)                   /*!< TM81 TS1: TS12 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS13_Pos                 (3UL)                     /*!< TM81 TS1: TS13 (Bit 3)                                */
#define TM81_TS1_TS13_Msk                 (0x8UL)                   /*!< TM81 TS1: TS13 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS14_Pos                 (4UL)                     /*!< TM81 TS1: TS14 (Bit 4)                                */
#define TM81_TS1_TS14_Msk                 (0x10UL)                  /*!< TM81 TS1: TS14 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS15_Pos                 (5UL)                     /*!< TM81 TS1: TS15 (Bit 5)                                */
#define TM81_TS1_TS15_Msk                 (0x20UL)                  /*!< TM81 TS1: TS15 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS16_Pos                 (6UL)                     /*!< TM81 TS1: TS16 (Bit 6)                                */
#define TM81_TS1_TS16_Msk                 (0x40UL)                  /*!< TM81 TS1: TS16 (Bitfield-Mask: 0x01)                  */
#define TM81_TS1_TS17_Pos                 (7UL)                     /*!< TM81 TS1: TS17 (Bit 7)                                */
#define TM81_TS1_TS17_Msk                 (0x80UL)                  /*!< TM81 TS1: TS17 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  TT1  ========================================================== */
#define TM81_TT1_TT10_Pos                 (0UL)                     /*!< TM81 TT1: TT10 (Bit 0)                                */
#define TM81_TT1_TT10_Msk                 (0x1UL)                   /*!< TM81 TT1: TT10 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT11_Pos                 (1UL)                     /*!< TM81 TT1: TT11 (Bit 1)                                */
#define TM81_TT1_TT11_Msk                 (0x2UL)                   /*!< TM81 TT1: TT11 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT12_Pos                 (2UL)                     /*!< TM81 TT1: TT12 (Bit 2)                                */
#define TM81_TT1_TT12_Msk                 (0x4UL)                   /*!< TM81 TT1: TT12 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT13_Pos                 (3UL)                     /*!< TM81 TT1: TT13 (Bit 3)                                */
#define TM81_TT1_TT13_Msk                 (0x8UL)                   /*!< TM81 TT1: TT13 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT14_Pos                 (4UL)                     /*!< TM81 TT1: TT14 (Bit 4)                                */
#define TM81_TT1_TT14_Msk                 (0x10UL)                  /*!< TM81 TT1: TT14 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT15_Pos                 (5UL)                     /*!< TM81 TT1: TT15 (Bit 5)                                */
#define TM81_TT1_TT15_Msk                 (0x20UL)                  /*!< TM81 TT1: TT15 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT16_Pos                 (6UL)                     /*!< TM81 TT1: TT16 (Bit 6)                                */
#define TM81_TT1_TT16_Msk                 (0x40UL)                  /*!< TM81 TT1: TT16 (Bitfield-Mask: 0x01)                  */
#define TM81_TT1_TT17_Pos                 (7UL)                     /*!< TM81 TT1: TT17 (Bit 7)                                */
#define TM81_TT1_TT17_Msk                 (0x80UL)                  /*!< TM81 TT1: TT17 (Bitfield-Mask: 0x01)                  */
/* =========================================================  TPS1  ========================================================== */
#define TM81_TPS1_PRS10_Pos               (0UL)                     /*!< TM81 TPS1: PRS10 (Bit 0)                              */
#define TM81_TPS1_PRS10_Msk               (0xfUL)                   /*!< TM81 TPS1: PRS10 (Bitfield-Mask: 0x0f)                */
#define TM81_TPS1_PRS11_Pos               (4UL)                     /*!< TM81 TPS1: PRS11 (Bit 4)                              */
#define TM81_TPS1_PRS11_Msk               (0xf0UL)                  /*!< TM81 TPS1: PRS11 (Bitfield-Mask: 0x0f)                */
#define TM81_TPS1_PRS12_Pos               (8UL)                     /*!< TM81 TPS1: PRS12 (Bit 8)                              */
#define TM81_TPS1_PRS12_Msk               (0x300UL)                 /*!< TM81 TPS1: PRS12 (Bitfield-Mask: 0x03)                */
#define TM81_TPS1_PRS13_Pos               (12UL)                    /*!< TM81 TPS1: PRS13 (Bit 12)                             */
#define TM81_TPS1_PRS13_Msk               (0x3000UL)                /*!< TM81 TPS1: PRS13 (Bitfield-Mask: 0x03)                */
/* ==========================================================  TO1  ========================================================== */
#define TM81_TO1_TO10_Pos                 (0UL)                     /*!< TM81 TO1: TO10 (Bit 0)                                */
#define TM81_TO1_TO10_Msk                 (0x1UL)                   /*!< TM81 TO1: TO10 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO11_Pos                 (1UL)                     /*!< TM81 TO1: TO11 (Bit 1)                                */
#define TM81_TO1_TO11_Msk                 (0x2UL)                   /*!< TM81 TO1: TO11 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO12_Pos                 (2UL)                     /*!< TM81 TO1: TO12 (Bit 2)                                */
#define TM81_TO1_TO12_Msk                 (0x4UL)                   /*!< TM81 TO1: TO12 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO13_Pos                 (3UL)                     /*!< TM81 TO1: TO13 (Bit 3)                                */
#define TM81_TO1_TO13_Msk                 (0x8UL)                   /*!< TM81 TO1: TO13 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO14_Pos                 (4UL)                     /*!< TM81 TO1: TO14 (Bit 4)                                */
#define TM81_TO1_TO14_Msk                 (0x10UL)                  /*!< TM81 TO1: TO14 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO15_Pos                 (5UL)                     /*!< TM81 TO1: TO15 (Bit 5)                                */
#define TM81_TO1_TO15_Msk                 (0x20UL)                  /*!< TM81 TO1: TO15 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO16_Pos                 (6UL)                     /*!< TM81 TO1: TO16 (Bit 6)                                */
#define TM81_TO1_TO16_Msk                 (0x40UL)                  /*!< TM81 TO1: TO16 (Bitfield-Mask: 0x01)                  */
#define TM81_TO1_TO17_Pos                 (7UL)                     /*!< TM81 TO1: TO17 (Bit 7)                                */
#define TM81_TO1_TO17_Msk                 (0x80UL)                  /*!< TM81 TO1: TO17 (Bitfield-Mask: 0x01)                  */
/* =========================================================  TOE1  ========================================================== */
#define TM81_TOE1_TOE10_Pos               (0UL)                     /*!< TM81 TOE1: TOE10 (Bit 0)                              */
#define TM81_TOE1_TOE10_Msk               (0x1UL)                   /*!< TM81 TOE1: TOE10 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE11_Pos               (1UL)                     /*!< TM81 TOE1: TOE11 (Bit 1)                              */
#define TM81_TOE1_TOE11_Msk               (0x2UL)                   /*!< TM81 TOE1: TOE11 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE12_Pos               (2UL)                     /*!< TM81 TOE1: TOE12 (Bit 2)                              */
#define TM81_TOE1_TOE12_Msk               (0x4UL)                   /*!< TM81 TOE1: TOE12 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE13_Pos               (3UL)                     /*!< TM81 TOE1: TOE13 (Bit 3)                              */
#define TM81_TOE1_TOE13_Msk               (0x8UL)                   /*!< TM81 TOE1: TOE13 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE14_Pos               (4UL)                     /*!< TM81 TOE1: TOE14 (Bit 4)                              */
#define TM81_TOE1_TOE14_Msk               (0x10UL)                  /*!< TM81 TOE1: TOE14 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE15_Pos               (5UL)                     /*!< TM81 TOE1: TOE15 (Bit 5)                              */
#define TM81_TOE1_TOE15_Msk               (0x20UL)                  /*!< TM81 TOE1: TOE15 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE16_Pos               (6UL)                     /*!< TM81 TOE1: TOE16 (Bit 6)                              */
#define TM81_TOE1_TOE16_Msk               (0x40UL)                  /*!< TM81 TOE1: TOE16 (Bitfield-Mask: 0x01)                */
#define TM81_TOE1_TOE17_Pos               (7UL)                     /*!< TM81 TOE1: TOE17 (Bit 7)                              */
#define TM81_TOE1_TOE17_Msk               (0x80UL)                  /*!< TM81 TOE1: TOE17 (Bitfield-Mask: 0x01)                */
/* =========================================================  TOL1  ========================================================== */
#define TM81_TOL1_TOL11_Pos               (1UL)                     /*!< TM81 TOL1: TOL11 (Bit 1)                              */
#define TM81_TOL1_TOL11_Msk               (0x2UL)                   /*!< TM81 TOL1: TOL11 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL12_Pos               (2UL)                     /*!< TM81 TOL1: TOL12 (Bit 2)                              */
#define TM81_TOL1_TOL12_Msk               (0x4UL)                   /*!< TM81 TOL1: TOL12 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL13_Pos               (3UL)                     /*!< TM81 TOL1: TOL13 (Bit 3)                              */
#define TM81_TOL1_TOL13_Msk               (0x8UL)                   /*!< TM81 TOL1: TOL13 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL14_Pos               (4UL)                     /*!< TM81 TOL1: TOL14 (Bit 4)                              */
#define TM81_TOL1_TOL14_Msk               (0x10UL)                  /*!< TM81 TOL1: TOL14 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL15_Pos               (5UL)                     /*!< TM81 TOL1: TOL15 (Bit 5)                              */
#define TM81_TOL1_TOL15_Msk               (0x20UL)                  /*!< TM81 TOL1: TOL15 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL16_Pos               (6UL)                     /*!< TM81 TOL1: TOL16 (Bit 6)                              */
#define TM81_TOL1_TOL16_Msk               (0x40UL)                  /*!< TM81 TOL1: TOL16 (Bitfield-Mask: 0x01)                */
#define TM81_TOL1_TOL17_Pos               (7UL)                     /*!< TM81 TOL1: TOL17 (Bit 7)                              */
#define TM81_TOL1_TOL17_Msk               (0x80UL)                  /*!< TM81 TOL1: TOL17 (Bitfield-Mask: 0x01)                */
/* =========================================================  TOM1  ========================================================== */
#define TM81_TOM1_TOM11_Pos               (1UL)                     /*!< TM81 TOM1: TOM11 (Bit 1)                              */
#define TM81_TOM1_TOM11_Msk               (0x2UL)                   /*!< TM81 TOM1: TOM11 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM12_Pos               (2UL)                     /*!< TM81 TOM1: TOM12 (Bit 2)                              */
#define TM81_TOM1_TOM12_Msk               (0x4UL)                   /*!< TM81 TOM1: TOM12 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM13_Pos               (3UL)                     /*!< TM81 TOM1: TOM13 (Bit 3)                              */
#define TM81_TOM1_TOM13_Msk               (0x8UL)                   /*!< TM81 TOM1: TOM13 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM14_Pos               (4UL)                     /*!< TM81 TOM1: TOM14 (Bit 4)                              */
#define TM81_TOM1_TOM14_Msk               (0x10UL)                  /*!< TM81 TOM1: TOM14 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM15_Pos               (5UL)                     /*!< TM81 TOM1: TOM15 (Bit 5)                              */
#define TM81_TOM1_TOM15_Msk               (0x20UL)                  /*!< TM81 TOM1: TOM15 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM16_Pos               (6UL)                     /*!< TM81 TOM1: TOM16 (Bit 6)                              */
#define TM81_TOM1_TOM16_Msk               (0x40UL)                  /*!< TM81 TOM1: TOM16 (Bitfield-Mask: 0x01)                */
#define TM81_TOM1_TOM17_Pos               (7UL)                     /*!< TM81 TOM1: TOM17 (Bit 7)                              */
#define TM81_TOM1_TOM17_Msk               (0x80UL)                  /*!< TM81 TOM1: TOM17 (Bitfield-Mask: 0x01)                */
/* =========================================================  TDR1  ========================================================== */
/* ========================================================  TDR11L  ========================================================= */
/* ========================================================  TDR11H  ========================================================= */
/* ========================================================  TDR13L  ========================================================= */
/* ========================================================  TDR13H  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            TMA                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TACR0  ========================================================= */
#define TMA_TACR0_TSTART_Pos              (0UL)                     /*!< TMA TACR0: TSTART (Bit 0)                             */
#define TMA_TACR0_TSTART_Msk              (0x1UL)                   /*!< TMA TACR0: TSTART (Bitfield-Mask: 0x01)               */
#define TMA_TACR0_TCSTF_Pos               (1UL)                     /*!< TMA TACR0: TCSTF (Bit 1)                              */
#define TMA_TACR0_TCSTF_Msk               (0x2UL)                   /*!< TMA TACR0: TCSTF (Bitfield-Mask: 0x01)                */
#define TMA_TACR0_TSTOP_Pos               (2UL)                     /*!< TMA TACR0: TSTOP (Bit 2)                              */
#define TMA_TACR0_TSTOP_Msk               (0x4UL)                   /*!< TMA TACR0: TSTOP (Bitfield-Mask: 0x01)                */
#define TMA_TACR0_TEDGF_Pos               (4UL)                     /*!< TMA TACR0: TEDGF (Bit 4)                              */
#define TMA_TACR0_TEDGF_Msk               (0x10UL)                  /*!< TMA TACR0: TEDGF (Bitfield-Mask: 0x01)                */
#define TMA_TACR0_TUNDF_Pos               (5UL)                     /*!< TMA TACR0: TUNDF (Bit 5)                              */
#define TMA_TACR0_TUNDF_Msk               (0x20UL)                  /*!< TMA TACR0: TUNDF (Bitfield-Mask: 0x01)                */
/* ========================================================  TAIOC0  ========================================================= */
#define TMA_TAIOC0_TEDGSEL_Pos            (0UL)                     /*!< TMA TAIOC0: TEDGSEL (Bit 0)                           */
#define TMA_TAIOC0_TEDGSEL_Msk            (0x1UL)                   /*!< TMA TAIOC0: TEDGSEL (Bitfield-Mask: 0x01)             */
#define TMA_TAIOC0_TOENA_Pos              (2UL)                     /*!< TMA TAIOC0: TOENA (Bit 2)                             */
#define TMA_TAIOC0_TOENA_Msk              (0x4UL)                   /*!< TMA TAIOC0: TOENA (Bitfield-Mask: 0x01)               */
#define TMA_TAIOC0_TIPF_Pos               (4UL)                     /*!< TMA TAIOC0: TIPF (Bit 4)                              */
#define TMA_TAIOC0_TIPF_Msk               (0x30UL)                  /*!< TMA TAIOC0: TIPF (Bitfield-Mask: 0x03)                */
#define TMA_TAIOC0_TIOGT_Pos              (6UL)                     /*!< TMA TAIOC0: TIOGT (Bit 6)                             */
#define TMA_TAIOC0_TIOGT_Msk              (0xc0UL)                  /*!< TMA TAIOC0: TIOGT (Bitfield-Mask: 0x03)               */
/* =========================================================  TAMR0  ========================================================= */
#define TMA_TAMR0_TMOD_Pos                (0UL)                     /*!< TMA TAMR0: TMOD (Bit 0)                               */
#define TMA_TAMR0_TMOD_Msk                (0x7UL)                   /*!< TMA TAMR0: TMOD (Bitfield-Mask: 0x07)                 */
#define TMA_TAMR0_TEDGPL_Pos              (3UL)                     /*!< TMA TAMR0: TEDGPL (Bit 3)                             */
#define TMA_TAMR0_TEDGPL_Msk              (0x8UL)                   /*!< TMA TAMR0: TEDGPL (Bitfield-Mask: 0x01)               */
#define TMA_TAMR0_TCK_Pos                 (4UL)                     /*!< TMA TAMR0: TCK (Bit 4)                                */
#define TMA_TAMR0_TCK_Msk                 (0x70UL)                  /*!< TMA TAMR0: TCK (Bitfield-Mask: 0x07)                  */
/* ========================================================  TAISR0  ========================================================= */
#define TMA_TAISR0_RCCPSEL_Pos            (0UL)                     /*!< TMA TAISR0: RCCPSEL (Bit 0)                           */
#define TMA_TAISR0_RCCPSEL_Msk            (0x7UL)                   /*!< TMA TAISR0: RCCPSEL (Bitfield-Mask: 0x07)             */
/* ==========================================================  TA0  ========================================================== */


/* =========================================================================================================================== */
/* ================                                            TMB                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TBMR  ========================================================== */
#define TMB_TBMR_TBPWM_Pos                (0UL)                     /*!< TMB TBMR: TBPWM (Bit 0)                               */
#define TMB_TBMR_TBPWM_Msk                (0x1UL)                   /*!< TMB TBMR: TBPWM (Bitfield-Mask: 0x01)                 */
#define TMB_TBMR_TBMDF_Pos                (1UL)                     /*!< TMB TBMR: TBMDF (Bit 1)                               */
#define TMB_TBMR_TBMDF_Msk                (0x2UL)                   /*!< TMB TBMR: TBMDF (Bitfield-Mask: 0x01)                 */
#define TMB_TBMR_TBDFA_Pos                (2UL)                     /*!< TMB TBMR: TBDFA (Bit 2)                               */
#define TMB_TBMR_TBDFA_Msk                (0x4UL)                   /*!< TMB TBMR: TBDFA (Bitfield-Mask: 0x01)                 */
#define TMB_TBMR_TBDFB_Pos                (3UL)                     /*!< TMB TBMR: TBDFB (Bit 3)                               */
#define TMB_TBMR_TBDFB_Msk                (0x8UL)                   /*!< TMB TBMR: TBDFB (Bitfield-Mask: 0x01)                 */
#define TMB_TBMR_TBDFCK_Pos               (4UL)                     /*!< TMB TBMR: TBDFCK (Bit 4)                              */
#define TMB_TBMR_TBDFCK_Msk               (0x30UL)                  /*!< TMB TBMR: TBDFCK (Bitfield-Mask: 0x03)                */
#define TMB_TBMR_TBELCICE_Pos             (6UL)                     /*!< TMB TBMR: TBELCICE (Bit 6)                            */
#define TMB_TBMR_TBELCICE_Msk             (0x40UL)                  /*!< TMB TBMR: TBELCICE (Bitfield-Mask: 0x01)              */
#define TMB_TBMR_TBSTART_Pos              (7UL)                     /*!< TMB TBMR: TBSTART (Bit 7)                             */
#define TMB_TBMR_TBSTART_Msk              (0x80UL)                  /*!< TMB TBMR: TBSTART (Bitfield-Mask: 0x01)               */
/* ========================================================  TBCNTC  ========================================================= */
#define TMB_TBCNTC_CNTEN0_Pos             (0UL)                     /*!< TMB TBCNTC: CNTEN0 (Bit 0)                            */
#define TMB_TBCNTC_CNTEN0_Msk             (0x1UL)                   /*!< TMB TBCNTC: CNTEN0 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN1_Pos             (1UL)                     /*!< TMB TBCNTC: CNTEN1 (Bit 1)                            */
#define TMB_TBCNTC_CNTEN1_Msk             (0x2UL)                   /*!< TMB TBCNTC: CNTEN1 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN2_Pos             (2UL)                     /*!< TMB TBCNTC: CNTEN2 (Bit 2)                            */
#define TMB_TBCNTC_CNTEN2_Msk             (0x4UL)                   /*!< TMB TBCNTC: CNTEN2 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN3_Pos             (3UL)                     /*!< TMB TBCNTC: CNTEN3 (Bit 3)                            */
#define TMB_TBCNTC_CNTEN3_Msk             (0x8UL)                   /*!< TMB TBCNTC: CNTEN3 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN4_Pos             (4UL)                     /*!< TMB TBCNTC: CNTEN4 (Bit 4)                            */
#define TMB_TBCNTC_CNTEN4_Msk             (0x10UL)                  /*!< TMB TBCNTC: CNTEN4 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN5_Pos             (5UL)                     /*!< TMB TBCNTC: CNTEN5 (Bit 5)                            */
#define TMB_TBCNTC_CNTEN5_Msk             (0x20UL)                  /*!< TMB TBCNTC: CNTEN5 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN6_Pos             (6UL)                     /*!< TMB TBCNTC: CNTEN6 (Bit 6)                            */
#define TMB_TBCNTC_CNTEN6_Msk             (0x40UL)                  /*!< TMB TBCNTC: CNTEN6 (Bitfield-Mask: 0x01)              */
#define TMB_TBCNTC_CNTEN7_Pos             (7UL)                     /*!< TMB TBCNTC: CNTEN7 (Bit 7)                            */
#define TMB_TBCNTC_CNTEN7_Msk             (0x80UL)                  /*!< TMB TBCNTC: CNTEN7 (Bitfield-Mask: 0x01)              */
/* =========================================================  TBCR  ========================================================== */
#define TMB_TBCR_TBTCK_Pos                (0UL)                     /*!< TMB TBCR: TBTCK (Bit 0)                               */
#define TMB_TBCR_TBTCK_Msk                (0x7UL)                   /*!< TMB TBCR: TBTCK (Bitfield-Mask: 0x07)                 */
#define TMB_TBCR_TBCKEG_Pos               (3UL)                     /*!< TMB TBCR: TBCKEG (Bit 3)                              */
#define TMB_TBCR_TBCKEG_Msk               (0x18UL)                  /*!< TMB TBCR: TBCKEG (Bitfield-Mask: 0x03)                */
#define TMB_TBCR_TBCCLR_Pos               (5UL)                     /*!< TMB TBCR: TBCCLR (Bit 5)                              */
#define TMB_TBCR_TBCCLR_Msk               (0x60UL)                  /*!< TMB TBCR: TBCCLR (Bitfield-Mask: 0x03)                */
/* =========================================================  TBIER  ========================================================= */
#define TMB_TBIER_TBIMIEA_Pos             (0UL)                     /*!< TMB TBIER: TBIMIEA (Bit 0)                            */
#define TMB_TBIER_TBIMIEA_Msk             (0x1UL)                   /*!< TMB TBIER: TBIMIEA (Bitfield-Mask: 0x01)              */
#define TMB_TBIER_TBIMIEB_Pos             (1UL)                     /*!< TMB TBIER: TBIMIEB (Bit 1)                            */
#define TMB_TBIER_TBIMIEB_Msk             (0x2UL)                   /*!< TMB TBIER: TBIMIEB (Bitfield-Mask: 0x01)              */
#define TMB_TBIER_TBUDIE_Pos              (2UL)                     /*!< TMB TBIER: TBUDIE (Bit 2)                             */
#define TMB_TBIER_TBUDIE_Msk              (0x4UL)                   /*!< TMB TBIER: TBUDIE (Bitfield-Mask: 0x01)               */
#define TMB_TBIER_TBOVIE_Pos              (3UL)                     /*!< TMB TBIER: TBOVIE (Bit 3)                             */
#define TMB_TBIER_TBOVIE_Msk              (0x8UL)                   /*!< TMB TBIER: TBOVIE (Bitfield-Mask: 0x01)               */
/* =========================================================  TBSR  ========================================================== */
#define TMB_TBSR_TBIMFA_Pos               (0UL)                     /*!< TMB TBSR: TBIMFA (Bit 0)                              */
#define TMB_TBSR_TBIMFA_Msk               (0x1UL)                   /*!< TMB TBSR: TBIMFA (Bitfield-Mask: 0x01)                */
#define TMB_TBSR_TBIMFB_Pos               (1UL)                     /*!< TMB TBSR: TBIMFB (Bit 1)                              */
#define TMB_TBSR_TBIMFB_Msk               (0x2UL)                   /*!< TMB TBSR: TBIMFB (Bitfield-Mask: 0x01)                */
#define TMB_TBSR_TBUDF_Pos                (2UL)                     /*!< TMB TBSR: TBUDF (Bit 2)                               */
#define TMB_TBSR_TBUDF_Msk                (0x4UL)                   /*!< TMB TBSR: TBUDF (Bitfield-Mask: 0x01)                 */
#define TMB_TBSR_TBOVF_Pos                (3UL)                     /*!< TMB TBSR: TBOVF (Bit 3)                               */
#define TMB_TBSR_TBOVF_Msk                (0x8UL)                   /*!< TMB TBSR: TBOVF (Bitfield-Mask: 0x01)                 */
#define TMB_TBSR_TBDIRF_Pos               (4UL)                     /*!< TMB TBSR: TBDIRF (Bit 4)                              */
#define TMB_TBSR_TBDIRF_Msk               (0x10UL)                  /*!< TMB TBSR: TBDIRF (Bitfield-Mask: 0x01)                */
/* =========================================================  TBIOR  ========================================================= */
#define TMB_TBIOR_TBIOA_Pos               (0UL)                     /*!< TMB TBIOR: TBIOA (Bit 0)                              */
#define TMB_TBIOR_TBIOA_Msk               (0x7UL)                   /*!< TMB TBIOR: TBIOA (Bitfield-Mask: 0x07)                */
#define TMB_TBIOR_TBBUFA_Pos              (3UL)                     /*!< TMB TBIOR: TBBUFA (Bit 3)                             */
#define TMB_TBIOR_TBBUFA_Msk              (0x8UL)                   /*!< TMB TBIOR: TBBUFA (Bitfield-Mask: 0x01)               */
#define TMB_TBIOR_TBIOB_Pos               (4UL)                     /*!< TMB TBIOR: TBIOB (Bit 4)                              */
#define TMB_TBIOR_TBIOB_Msk               (0x70UL)                  /*!< TMB TBIOR: TBIOB (Bitfield-Mask: 0x07)                */
#define TMB_TBIOR_TBBUFB_Pos              (7UL)                     /*!< TMB TBIOR: TBBUFB (Bit 7)                             */
#define TMB_TBIOR_TBBUFB_Msk              (0x80UL)                  /*!< TMB TBIOR: TBBUFB (Bitfield-Mask: 0x01)               */
/* ==========================================================  TB  =========================================================== */
/* =========================================================  TBGR  ========================================================== */


/* =========================================================================================================================== */
/* ================                                            TMC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  TC  =========================================================== */
/* =========================================================  TCBUF  ========================================================= */
/* =========================================================  TCCR1  ========================================================= */
#define TMC_TCCR1_OVIE_Pos                (0UL)                     /*!< TMC TCCR1: OVIE (Bit 0)                               */
#define TMC_TCCR1_OVIE_Msk                (0x1UL)                   /*!< TMC TCCR1: OVIE (Bitfield-Mask: 0x01)                 */
#define TMC_TCCR1_TM_TRIG_Pos             (1UL)                     /*!< TMC TCCR1: TM_TRIG (Bit 1)                            */
#define TMC_TCCR1_TM_TRIG_Msk             (0x2UL)                   /*!< TMC TCCR1: TM_TRIG (Bitfield-Mask: 0x01)              */
#define TMC_TCCR1_TRIG_MD_HW_Pos          (2UL)                     /*!< TMC TCCR1: TRIG_MD_HW (Bit 2)                         */
#define TMC_TCCR1_TRIG_MD_HW_Msk          (0x4UL)                   /*!< TMC TCCR1: TRIG_MD_HW (Bitfield-Mask: 0x01)           */
#define TMC_TCCR1_TRIG_MD_SW_Pos          (3UL)                     /*!< TMC TCCR1: TRIG_MD_SW (Bit 3)                         */
#define TMC_TCCR1_TRIG_MD_SW_Msk          (0x8UL)                   /*!< TMC TCCR1: TRIG_MD_SW (Bitfield-Mask: 0x01)           */
#define TMC_TCCR1_START_MD_Pos            (4UL)                     /*!< TMC TCCR1: START_MD (Bit 4)                           */
#define TMC_TCCR1_START_MD_Msk            (0x10UL)                  /*!< TMC TCCR1: START_MD (Bitfield-Mask: 0x01)             */
#define TMC_TCCR1_TCK_Pos                 (5UL)                     /*!< TMC TCCR1: TCK (Bit 5)                                */
#define TMC_TCCR1_TCK_Msk                 (0xe0UL)                  /*!< TMC TCCR1: TCK (Bitfield-Mask: 0x07)                  */
/* =========================================================  TCCR2  ========================================================= */
#define TMC_TCCR2_TSTART_Pos              (0UL)                     /*!< TMC TCCR2: TSTART (Bit 0)                             */
#define TMC_TCCR2_TSTART_Msk              (0x1UL)                   /*!< TMC TCCR2: TSTART (Bitfield-Mask: 0x01)               */
#define TMC_TCCR2_CMP1_TCR_Pos            (1UL)                     /*!< TMC TCCR2: CMP1_TCR (Bit 1)                           */
#define TMC_TCCR2_CMP1_TCR_Msk            (0x6UL)                   /*!< TMC TCCR2: CMP1_TCR (Bitfield-Mask: 0x03)             */
/* =========================================================  TCSR  ========================================================== */
#define TMC_TCSR_TCOVF_Pos                (0UL)                     /*!< TMC TCSR: TCOVF (Bit 0)                               */
#define TMC_TCSR_TCOVF_Msk                (0x1UL)                   /*!< TMC TCSR: TCOVF (Bitfield-Mask: 0x01)                 */
#define TMC_TCSR_TCSB_Pos                 (1UL)                     /*!< TMC TCSR: TCSB (Bit 1)                                */
#define TMC_TCSR_TCSB_Msk                 (0x2UL)                   /*!< TMC TCSR: TCSB (Bitfield-Mask: 0x01)                  */


/* =========================================================================================================================== */
/* ================                                            TMM                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TMELC  ========================================================= */
#define TMM_TMELC_ELCICE0_Pos             (0UL)                     /*!< TMM TMELC: ELCICE0 (Bit 0)                            */
#define TMM_TMELC_ELCICE0_Msk             (0x1UL)                   /*!< TMM TMELC: ELCICE0 (Bitfield-Mask: 0x01)              */
#define TMM_TMELC_ELCOBE0_Pos             (1UL)                     /*!< TMM TMELC: ELCOBE0 (Bit 1)                            */
#define TMM_TMELC_ELCOBE0_Msk             (0x2UL)                   /*!< TMM TMELC: ELCOBE0 (Bitfield-Mask: 0x01)              */
#define TMM_TMELC_ELCICE1_Pos             (4UL)                     /*!< TMM TMELC: ELCICE1 (Bit 4)                            */
#define TMM_TMELC_ELCICE1_Msk             (0x10UL)                  /*!< TMM TMELC: ELCICE1 (Bitfield-Mask: 0x01)              */
#define TMM_TMELC_ELCOBE1_Pos             (5UL)                     /*!< TMM TMELC: ELCOBE1 (Bit 5)                            */
#define TMM_TMELC_ELCOBE1_Msk             (0x20UL)                  /*!< TMM TMELC: ELCOBE1 (Bitfield-Mask: 0x01)              */
/* =========================================================  TMSTR  ========================================================= */
#define TMM_TMSTR_TSTART0_Pos             (0UL)                     /*!< TMM TMSTR: TSTART0 (Bit 0)                            */
#define TMM_TMSTR_TSTART0_Msk             (0x1UL)                   /*!< TMM TMSTR: TSTART0 (Bitfield-Mask: 0x01)              */
#define TMM_TMSTR_TSTART1_Pos             (1UL)                     /*!< TMM TMSTR: TSTART1 (Bit 1)                            */
#define TMM_TMSTR_TSTART1_Msk             (0x2UL)                   /*!< TMM TMSTR: TSTART1 (Bitfield-Mask: 0x01)              */
#define TMM_TMSTR_CSEL0_Pos               (2UL)                     /*!< TMM TMSTR: CSEL0 (Bit 2)                              */
#define TMM_TMSTR_CSEL0_Msk               (0x4UL)                   /*!< TMM TMSTR: CSEL0 (Bitfield-Mask: 0x01)                */
#define TMM_TMSTR_CSEL1_Pos               (3UL)                     /*!< TMM TMSTR: CSEL1 (Bit 3)                              */
#define TMM_TMSTR_CSEL1_Msk               (0x8UL)                   /*!< TMM TMSTR: CSEL1 (Bitfield-Mask: 0x01)                */
/* =========================================================  TMMR  ========================================================== */
#define TMM_TMMR_TMSYNC_Pos               (0UL)                     /*!< TMM TMMR: TMSYNC (Bit 0)                              */
#define TMM_TMMR_TMSYNC_Msk               (0x1UL)                   /*!< TMM TMMR: TMSYNC (Bitfield-Mask: 0x01)                */
#define TMM_TMMR_TMBFC0_Pos               (4UL)                     /*!< TMM TMMR: TMBFC0 (Bit 4)                              */
#define TMM_TMMR_TMBFC0_Msk               (0x10UL)                  /*!< TMM TMMR: TMBFC0 (Bitfield-Mask: 0x01)                */
#define TMM_TMMR_TMBFD0_Pos               (5UL)                     /*!< TMM TMMR: TMBFD0 (Bit 5)                              */
#define TMM_TMMR_TMBFD0_Msk               (0x20UL)                  /*!< TMM TMMR: TMBFD0 (Bitfield-Mask: 0x01)                */
#define TMM_TMMR_TMBFC1_Pos               (6UL)                     /*!< TMM TMMR: TMBFC1 (Bit 6)                              */
#define TMM_TMMR_TMBFC1_Msk               (0x40UL)                  /*!< TMM TMMR: TMBFC1 (Bitfield-Mask: 0x01)                */
#define TMM_TMMR_TMBFD1_Pos               (7UL)                     /*!< TMM TMMR: TMBFD1 (Bit 7)                              */
#define TMM_TMMR_TMBFD1_Msk               (0x80UL)                  /*!< TMM TMMR: TMBFD1 (Bitfield-Mask: 0x01)                */
/* =========================================================  TMPMR  ========================================================= */
#define TMM_TMPMR_TMPWMB0_Pos             (0UL)                     /*!< TMM TMPMR: TMPWMB0 (Bit 0)                            */
#define TMM_TMPMR_TMPWMB0_Msk             (0x1UL)                   /*!< TMM TMPMR: TMPWMB0 (Bitfield-Mask: 0x01)              */
#define TMM_TMPMR_TMPWMC0_Pos             (1UL)                     /*!< TMM TMPMR: TMPWMC0 (Bit 1)                            */
#define TMM_TMPMR_TMPWMC0_Msk             (0x2UL)                   /*!< TMM TMPMR: TMPWMC0 (Bitfield-Mask: 0x01)              */
#define TMM_TMPMR_TMPWMD0_Pos             (2UL)                     /*!< TMM TMPMR: TMPWMD0 (Bit 2)                            */
#define TMM_TMPMR_TMPWMD0_Msk             (0x4UL)                   /*!< TMM TMPMR: TMPWMD0 (Bitfield-Mask: 0x01)              */
#define TMM_TMPMR_TMPWMB1_Pos             (4UL)                     /*!< TMM TMPMR: TMPWMB1 (Bit 4)                            */
#define TMM_TMPMR_TMPWMB1_Msk             (0x10UL)                  /*!< TMM TMPMR: TMPWMB1 (Bitfield-Mask: 0x01)              */
#define TMM_TMPMR_TMPWMC1_Pos             (5UL)                     /*!< TMM TMPMR: TMPWMC1 (Bit 5)                            */
#define TMM_TMPMR_TMPWMC1_Msk             (0x20UL)                  /*!< TMM TMPMR: TMPWMC1 (Bitfield-Mask: 0x01)              */
#define TMM_TMPMR_TMPWMD1_Pos             (6UL)                     /*!< TMM TMPMR: TMPWMD1 (Bit 6)                            */
#define TMM_TMPMR_TMPWMD1_Msk             (0x40UL)                  /*!< TMM TMPMR: TMPWMD1 (Bitfield-Mask: 0x01)              */
/* =========================================================  TMFCR  ========================================================= */
#define TMM_TMFCR_CMD_Pos                 (0UL)                     /*!< TMM TMFCR: CMD (Bit 0)                                */
#define TMM_TMFCR_CMD_Msk                 (0x3UL)                   /*!< TMM TMFCR: CMD (Bitfield-Mask: 0x03)                  */
#define TMM_TMFCR_OLS0_Pos                (2UL)                     /*!< TMM TMFCR: OLS0 (Bit 2)                               */
#define TMM_TMFCR_OLS0_Msk                (0x4UL)                   /*!< TMM TMFCR: OLS0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMFCR_OLS1_Pos                (3UL)                     /*!< TMM TMFCR: OLS1 (Bit 3)                               */
#define TMM_TMFCR_OLS1_Msk                (0x8UL)                   /*!< TMM TMFCR: OLS1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMFCR_STCLK_Pos               (6UL)                     /*!< TMM TMFCR: STCLK (Bit 6)                              */
#define TMM_TMFCR_STCLK_Msk               (0x40UL)                  /*!< TMM TMFCR: STCLK (Bitfield-Mask: 0x01)                */
#define TMM_TMFCR_PWM3_Pos                (7UL)                     /*!< TMM TMFCR: PWM3 (Bit 7)                               */
#define TMM_TMFCR_PWM3_Msk                (0x80UL)                  /*!< TMM TMFCR: PWM3 (Bitfield-Mask: 0x01)                 */
/* ========================================================  TMOER1  ========================================================= */
#define TMM_TMOER1_EA0_Pos                (0UL)                     /*!< TMM TMOER1: EA0 (Bit 0)                               */
#define TMM_TMOER1_EA0_Msk                (0x1UL)                   /*!< TMM TMOER1: EA0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_EB0_Pos                (1UL)                     /*!< TMM TMOER1: EB0 (Bit 1)                               */
#define TMM_TMOER1_EB0_Msk                (0x2UL)                   /*!< TMM TMOER1: EB0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_EC0_Pos                (2UL)                     /*!< TMM TMOER1: EC0 (Bit 2)                               */
#define TMM_TMOER1_EC0_Msk                (0x4UL)                   /*!< TMM TMOER1: EC0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_ED0_Pos                (3UL)                     /*!< TMM TMOER1: ED0 (Bit 3)                               */
#define TMM_TMOER1_ED0_Msk                (0x8UL)                   /*!< TMM TMOER1: ED0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_EA1_Pos                (4UL)                     /*!< TMM TMOER1: EA1 (Bit 4)                               */
#define TMM_TMOER1_EA1_Msk                (0x10UL)                  /*!< TMM TMOER1: EA1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_EB1_Pos                (5UL)                     /*!< TMM TMOER1: EB1 (Bit 5)                               */
#define TMM_TMOER1_EB1_Msk                (0x20UL)                  /*!< TMM TMOER1: EB1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_EC1_Pos                (6UL)                     /*!< TMM TMOER1: EC1 (Bit 6)                               */
#define TMM_TMOER1_EC1_Msk                (0x40UL)                  /*!< TMM TMOER1: EC1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOER1_ED1_Pos                (7UL)                     /*!< TMM TMOER1: ED1 (Bit 7)                               */
#define TMM_TMOER1_ED1_Msk                (0x80UL)                  /*!< TMM TMOER1: ED1 (Bitfield-Mask: 0x01)                 */
/* ========================================================  TMOER2  ========================================================= */
#define TMM_TMOER2_TMSHUTS_Pos            (0UL)                     /*!< TMM TMOER2: TMSHUTS (Bit 0)                           */
#define TMM_TMOER2_TMSHUTS_Msk            (0x1UL)                   /*!< TMM TMOER2: TMSHUTS (Bitfield-Mask: 0x01)             */
#define TMM_TMOER2_TMPTO_Pos              (7UL)                     /*!< TMM TMOER2: TMPTO (Bit 7)                             */
#define TMM_TMOER2_TMPTO_Msk              (0x80UL)                  /*!< TMM TMOER2: TMPTO (Bitfield-Mask: 0x01)               */
/* =========================================================  TMOCR  ========================================================= */
#define TMM_TMOCR_TOA0_Pos                (0UL)                     /*!< TMM TMOCR: TOA0 (Bit 0)                               */
#define TMM_TMOCR_TOA0_Msk                (0x1UL)                   /*!< TMM TMOCR: TOA0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOB0_Pos                (1UL)                     /*!< TMM TMOCR: TOB0 (Bit 1)                               */
#define TMM_TMOCR_TOB0_Msk                (0x2UL)                   /*!< TMM TMOCR: TOB0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOC0_Pos                (2UL)                     /*!< TMM TMOCR: TOC0 (Bit 2)                               */
#define TMM_TMOCR_TOC0_Msk                (0x4UL)                   /*!< TMM TMOCR: TOC0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOD0_Pos                (3UL)                     /*!< TMM TMOCR: TOD0 (Bit 3)                               */
#define TMM_TMOCR_TOD0_Msk                (0x8UL)                   /*!< TMM TMOCR: TOD0 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOA1_Pos                (4UL)                     /*!< TMM TMOCR: TOA1 (Bit 4)                               */
#define TMM_TMOCR_TOA1_Msk                (0x10UL)                  /*!< TMM TMOCR: TOA1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOB1_Pos                (5UL)                     /*!< TMM TMOCR: TOB1 (Bit 5)                               */
#define TMM_TMOCR_TOB1_Msk                (0x20UL)                  /*!< TMM TMOCR: TOB1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOC1_Pos                (6UL)                     /*!< TMM TMOCR: TOC1 (Bit 6)                               */
#define TMM_TMOCR_TOC1_Msk                (0x40UL)                  /*!< TMM TMOCR: TOC1 (Bitfield-Mask: 0x01)                 */
#define TMM_TMOCR_TOD1_Pos                (7UL)                     /*!< TMM TMOCR: TOD1 (Bit 7)                               */
#define TMM_TMOCR_TOD1_Msk                (0x80UL)                  /*!< TMM TMOCR: TOD1 (Bitfield-Mask: 0x01)                 */
/* =========================================================  TMDF0  ========================================================= */
#define TMM_TMDF0_DFA_Pos                 (0UL)                     /*!< TMM TMDF0: DFA (Bit 0)                                */
#define TMM_TMDF0_DFA_Msk                 (0x1UL)                   /*!< TMM TMDF0: DFA (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF0_DFB_Pos                 (1UL)                     /*!< TMM TMDF0: DFB (Bit 1)                                */
#define TMM_TMDF0_DFB_Msk                 (0x2UL)                   /*!< TMM TMDF0: DFB (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF0_DFC_Pos                 (2UL)                     /*!< TMM TMDF0: DFC (Bit 2)                                */
#define TMM_TMDF0_DFC_Msk                 (0x4UL)                   /*!< TMM TMDF0: DFC (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF0_DFD_Pos                 (3UL)                     /*!< TMM TMDF0: DFD (Bit 3)                                */
#define TMM_TMDF0_DFD_Msk                 (0x8UL)                   /*!< TMM TMDF0: DFD (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF0_DFCK_Pos                (6UL)                     /*!< TMM TMDF0: DFCK (Bit 6)                               */
#define TMM_TMDF0_DFCK_Msk                (0xc0UL)                  /*!< TMM TMDF0: DFCK (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMDF1  ========================================================= */
#define TMM_TMDF1_DFA_Pos                 (0UL)                     /*!< TMM TMDF1: DFA (Bit 0)                                */
#define TMM_TMDF1_DFA_Msk                 (0x1UL)                   /*!< TMM TMDF1: DFA (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF1_DFB_Pos                 (1UL)                     /*!< TMM TMDF1: DFB (Bit 1)                                */
#define TMM_TMDF1_DFB_Msk                 (0x2UL)                   /*!< TMM TMDF1: DFB (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF1_DFC_Pos                 (2UL)                     /*!< TMM TMDF1: DFC (Bit 2)                                */
#define TMM_TMDF1_DFC_Msk                 (0x4UL)                   /*!< TMM TMDF1: DFC (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF1_DFD_Pos                 (3UL)                     /*!< TMM TMDF1: DFD (Bit 3)                                */
#define TMM_TMDF1_DFD_Msk                 (0x8UL)                   /*!< TMM TMDF1: DFD (Bitfield-Mask: 0x01)                  */
#define TMM_TMDF1_DFCK_Pos                (6UL)                     /*!< TMM TMDF1: DFCK (Bit 6)                               */
#define TMM_TMDF1_DFCK_Msk                (0xc0UL)                  /*!< TMM TMDF1: DFCK (Bitfield-Mask: 0x03)                 */
/* =========================================================  TMCR0  ========================================================= */
#define TMM_TMCR0_TCK_Pos                 (0UL)                     /*!< TMM TMCR0: TCK (Bit 0)                                */
#define TMM_TMCR0_TCK_Msk                 (0x7UL)                   /*!< TMM TMCR0: TCK (Bitfield-Mask: 0x07)                  */
#define TMM_TMCR0_CKEG_Pos                (3UL)                     /*!< TMM TMCR0: CKEG (Bit 3)                               */
#define TMM_TMCR0_CKEG_Msk                (0x18UL)                  /*!< TMM TMCR0: CKEG (Bitfield-Mask: 0x03)                 */
#define TMM_TMCR0_CCLR_Pos                (5UL)                     /*!< TMM TMCR0: CCLR (Bit 5)                               */
#define TMM_TMCR0_CCLR_Msk                (0xe0UL)                  /*!< TMM TMCR0: CCLR (Bitfield-Mask: 0x07)                 */
/* =========================================================  TMCR1  ========================================================= */
#define TMM_TMCR1_TCK_Pos                 (0UL)                     /*!< TMM TMCR1: TCK (Bit 0)                                */
#define TMM_TMCR1_TCK_Msk                 (0x7UL)                   /*!< TMM TMCR1: TCK (Bitfield-Mask: 0x07)                  */
#define TMM_TMCR1_CKEG_Pos                (3UL)                     /*!< TMM TMCR1: CKEG (Bit 3)                               */
#define TMM_TMCR1_CKEG_Msk                (0x18UL)                  /*!< TMM TMCR1: CKEG (Bitfield-Mask: 0x03)                 */
#define TMM_TMCR1_CCLR_Pos                (5UL)                     /*!< TMM TMCR1: CCLR (Bit 5)                               */
#define TMM_TMCR1_CCLR_Msk                (0xe0UL)                  /*!< TMM TMCR1: CCLR (Bitfield-Mask: 0x07)                 */
/* ========================================================  TMIORA0  ======================================================== */
#define TMM_TMIORA0_IOA_Pos               (0UL)                     /*!< TMM TMIORA0: IOA (Bit 0)                              */
#define TMM_TMIORA0_IOA_Msk               (0x7UL)                   /*!< TMM TMIORA0: IOA (Bitfield-Mask: 0x07)                */
#define TMM_TMIORA0_IOB_Pos               (4UL)                     /*!< TMM TMIORA0: IOB (Bit 4)                              */
#define TMM_TMIORA0_IOB_Msk               (0x70UL)                  /*!< TMM TMIORA0: IOB (Bitfield-Mask: 0x07)                */
/* ========================================================  TMIORA1  ======================================================== */
#define TMM_TMIORA1_IOA_Pos               (0UL)                     /*!< TMM TMIORA1: IOA (Bit 0)                              */
#define TMM_TMIORA1_IOA_Msk               (0x7UL)                   /*!< TMM TMIORA1: IOA (Bitfield-Mask: 0x07)                */
#define TMM_TMIORA1_IOB_Pos               (4UL)                     /*!< TMM TMIORA1: IOB (Bit 4)                              */
#define TMM_TMIORA1_IOB_Msk               (0x70UL)                  /*!< TMM TMIORA1: IOB (Bitfield-Mask: 0x07)                */
/* ========================================================  TMIORC0  ======================================================== */
#define TMM_TMIORC0_IOC_Pos               (0UL)                     /*!< TMM TMIORC0: IOC (Bit 0)                              */
#define TMM_TMIORC0_IOC_Msk               (0xfUL)                   /*!< TMM TMIORC0: IOC (Bitfield-Mask: 0x0f)                */
#define TMM_TMIORC0_IOD_Pos               (4UL)                     /*!< TMM TMIORC0: IOD (Bit 4)                              */
#define TMM_TMIORC0_IOD_Msk               (0xf0UL)                  /*!< TMM TMIORC0: IOD (Bitfield-Mask: 0x0f)                */
/* ========================================================  TMIORC1  ======================================================== */
#define TMM_TMIORC1_IOC_Pos               (0UL)                     /*!< TMM TMIORC1: IOC (Bit 0)                              */
#define TMM_TMIORC1_IOC_Msk               (0xfUL)                   /*!< TMM TMIORC1: IOC (Bitfield-Mask: 0x0f)                */
#define TMM_TMIORC1_IOD_Pos               (4UL)                     /*!< TMM TMIORC1: IOD (Bit 4)                              */
#define TMM_TMIORC1_IOD_Msk               (0xf0UL)                  /*!< TMM TMIORC1: IOD (Bitfield-Mask: 0x0f)                */
/* =========================================================  TMSR0  ========================================================= */
#define TMM_TMSR0_IMFA_Pos                (0UL)                     /*!< TMM TMSR0: IMFA (Bit 0)                               */
#define TMM_TMSR0_IMFA_Msk                (0x1UL)                   /*!< TMM TMSR0: IMFA (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR0_IMFB_Pos                (1UL)                     /*!< TMM TMSR0: IMFB (Bit 1)                               */
#define TMM_TMSR0_IMFB_Msk                (0x2UL)                   /*!< TMM TMSR0: IMFB (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR0_IMFC_Pos                (2UL)                     /*!< TMM TMSR0: IMFC (Bit 2)                               */
#define TMM_TMSR0_IMFC_Msk                (0x4UL)                   /*!< TMM TMSR0: IMFC (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR0_IMFD_Pos                (3UL)                     /*!< TMM TMSR0: IMFD (Bit 3)                               */
#define TMM_TMSR0_IMFD_Msk                (0x8UL)                   /*!< TMM TMSR0: IMFD (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR0_OVF_Pos                 (4UL)                     /*!< TMM TMSR0: OVF (Bit 4)                                */
#define TMM_TMSR0_OVF_Msk                 (0x10UL)                  /*!< TMM TMSR0: OVF (Bitfield-Mask: 0x01)                  */
/* =========================================================  TMSR1  ========================================================= */
#define TMM_TMSR1_IMFA_Pos                (0UL)                     /*!< TMM TMSR1: IMFA (Bit 0)                               */
#define TMM_TMSR1_IMFA_Msk                (0x1UL)                   /*!< TMM TMSR1: IMFA (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR1_IMFB_Pos                (1UL)                     /*!< TMM TMSR1: IMFB (Bit 1)                               */
#define TMM_TMSR1_IMFB_Msk                (0x2UL)                   /*!< TMM TMSR1: IMFB (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR1_IMFC_Pos                (2UL)                     /*!< TMM TMSR1: IMFC (Bit 2)                               */
#define TMM_TMSR1_IMFC_Msk                (0x4UL)                   /*!< TMM TMSR1: IMFC (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR1_IMFD_Pos                (3UL)                     /*!< TMM TMSR1: IMFD (Bit 3)                               */
#define TMM_TMSR1_IMFD_Msk                (0x8UL)                   /*!< TMM TMSR1: IMFD (Bitfield-Mask: 0x01)                 */
#define TMM_TMSR1_OVF_Pos                 (4UL)                     /*!< TMM TMSR1: OVF (Bit 4)                                */
#define TMM_TMSR1_OVF_Msk                 (0x10UL)                  /*!< TMM TMSR1: OVF (Bitfield-Mask: 0x01)                  */
#define TMM_TMSR1_UDF_Pos                 (5UL)                     /*!< TMM TMSR1: UDF (Bit 5)                                */
#define TMM_TMSR1_UDF_Msk                 (0x20UL)                  /*!< TMM TMSR1: UDF (Bitfield-Mask: 0x01)                  */
/* ========================================================  TMIER0  ========================================================= */
#define TMM_TMIER0_IMIEA_Pos              (0UL)                     /*!< TMM TMIER0: IMIEA (Bit 0)                             */
#define TMM_TMIER0_IMIEA_Msk              (0x1UL)                   /*!< TMM TMIER0: IMIEA (Bitfield-Mask: 0x01)               */
#define TMM_TMIER0_IMIEB_Pos              (1UL)                     /*!< TMM TMIER0: IMIEB (Bit 1)                             */
#define TMM_TMIER0_IMIEB_Msk              (0x2UL)                   /*!< TMM TMIER0: IMIEB (Bitfield-Mask: 0x01)               */
#define TMM_TMIER0_IMIEC_Pos              (2UL)                     /*!< TMM TMIER0: IMIEC (Bit 2)                             */
#define TMM_TMIER0_IMIEC_Msk              (0x4UL)                   /*!< TMM TMIER0: IMIEC (Bitfield-Mask: 0x01)               */
#define TMM_TMIER0_IMIED_Pos              (3UL)                     /*!< TMM TMIER0: IMIED (Bit 3)                             */
#define TMM_TMIER0_IMIED_Msk              (0x8UL)                   /*!< TMM TMIER0: IMIED (Bitfield-Mask: 0x01)               */
#define TMM_TMIER0_OVIE_Pos               (4UL)                     /*!< TMM TMIER0: OVIE (Bit 4)                              */
#define TMM_TMIER0_OVIE_Msk               (0x10UL)                  /*!< TMM TMIER0: OVIE (Bitfield-Mask: 0x01)                */
/* ========================================================  TMIER1  ========================================================= */
#define TMM_TMIER1_IMIEA_Pos              (0UL)                     /*!< TMM TMIER1: IMIEA (Bit 0)                             */
#define TMM_TMIER1_IMIEA_Msk              (0x1UL)                   /*!< TMM TMIER1: IMIEA (Bitfield-Mask: 0x01)               */
#define TMM_TMIER1_IMIEB_Pos              (1UL)                     /*!< TMM TMIER1: IMIEB (Bit 1)                             */
#define TMM_TMIER1_IMIEB_Msk              (0x2UL)                   /*!< TMM TMIER1: IMIEB (Bitfield-Mask: 0x01)               */
#define TMM_TMIER1_IMIEC_Pos              (2UL)                     /*!< TMM TMIER1: IMIEC (Bit 2)                             */
#define TMM_TMIER1_IMIEC_Msk              (0x4UL)                   /*!< TMM TMIER1: IMIEC (Bitfield-Mask: 0x01)               */
#define TMM_TMIER1_IMIED_Pos              (3UL)                     /*!< TMM TMIER1: IMIED (Bit 3)                             */
#define TMM_TMIER1_IMIED_Msk              (0x8UL)                   /*!< TMM TMIER1: IMIED (Bitfield-Mask: 0x01)               */
#define TMM_TMIER1_OVIE_Pos               (4UL)                     /*!< TMM TMIER1: OVIE (Bit 4)                              */
#define TMM_TMIER1_OVIE_Msk               (0x10UL)                  /*!< TMM TMIER1: OVIE (Bitfield-Mask: 0x01)                */
/* ========================================================  TMPOCR0  ======================================================== */
#define TMM_TMPOCR0_POLB_Pos              (0UL)                     /*!< TMM TMPOCR0: POLB (Bit 0)                             */
#define TMM_TMPOCR0_POLB_Msk              (0x1UL)                   /*!< TMM TMPOCR0: POLB (Bitfield-Mask: 0x01)               */
#define TMM_TMPOCR0_POLC_Pos              (1UL)                     /*!< TMM TMPOCR0: POLC (Bit 1)                             */
#define TMM_TMPOCR0_POLC_Msk              (0x2UL)                   /*!< TMM TMPOCR0: POLC (Bitfield-Mask: 0x01)               */
#define TMM_TMPOCR0_POLD_Pos              (2UL)                     /*!< TMM TMPOCR0: POLD (Bit 2)                             */
#define TMM_TMPOCR0_POLD_Msk              (0x4UL)                   /*!< TMM TMPOCR0: POLD (Bitfield-Mask: 0x01)               */
/* ========================================================  TMPOCR1  ======================================================== */
#define TMM_TMPOCR1_POLB_Pos              (0UL)                     /*!< TMM TMPOCR1: POLB (Bit 0)                             */
#define TMM_TMPOCR1_POLB_Msk              (0x1UL)                   /*!< TMM TMPOCR1: POLB (Bitfield-Mask: 0x01)               */
#define TMM_TMPOCR1_POLC_Pos              (1UL)                     /*!< TMM TMPOCR1: POLC (Bit 1)                             */
#define TMM_TMPOCR1_POLC_Msk              (0x2UL)                   /*!< TMM TMPOCR1: POLC (Bitfield-Mask: 0x01)               */
#define TMM_TMPOCR1_POLD_Pos              (2UL)                     /*!< TMM TMPOCR1: POLD (Bit 2)                             */
#define TMM_TMPOCR1_POLD_Msk              (0x4UL)                   /*!< TMM TMPOCR1: POLD (Bitfield-Mask: 0x01)               */
/* ==========================================================  TM0  ========================================================== */
/* ==========================================================  TM1  ========================================================== */
/* ========================================================  TMGRA0  ========================================================= */
/* ========================================================  TMGRA1  ========================================================= */
/* ========================================================  TMGRB0  ========================================================= */
/* ========================================================  TMGRB1  ========================================================= */
/* ========================================================  TMGRC0  ========================================================= */
/* ========================================================  TMGRC1  ========================================================= */
/* ========================================================  TMGRD0  ========================================================= */
/* ========================================================  TMGRD1  ========================================================= */
/* ========================================================  OPCTL0  ========================================================= */
#define TMM_OPCTL0_HS_SEL_Pos             (0UL)                     /*!< TMM OPCTL0: HS_SEL (Bit 0)                            */
#define TMM_OPCTL0_HS_SEL_Msk             (0x1UL)                   /*!< TMM OPCTL0: HS_SEL (Bitfield-Mask: 0x01)              */
#define TMM_OPCTL0_HZ_REL_Pos             (1UL)                     /*!< TMM OPCTL0: HZ_REL (Bit 1)                            */
#define TMM_OPCTL0_HZ_REL_Msk             (0x2UL)                   /*!< TMM OPCTL0: HZ_REL (Bitfield-Mask: 0x01)              */
#define TMM_OPCTL0_ACT_Pos                (2UL)                     /*!< TMM OPCTL0: ACT (Bit 2)                               */
#define TMM_OPCTL0_ACT_Msk                (0x4UL)                   /*!< TMM OPCTL0: ACT (Bitfield-Mask: 0x01)                 */
#define TMM_OPCTL0_IN_SEL_Pos             (3UL)                     /*!< TMM OPCTL0: IN_SEL (Bit 3)                            */
#define TMM_OPCTL0_IN_SEL_Msk             (0x18UL)                  /*!< TMM OPCTL0: IN_SEL (Bitfield-Mask: 0x03)              */
#define TMM_OPCTL0_IN_EG_Pos              (5UL)                     /*!< TMM OPCTL0: IN_EG (Bit 5)                             */
#define TMM_OPCTL0_IN_EG_Msk              (0x20UL)                  /*!< TMM OPCTL0: IN_EG (Bitfield-Mask: 0x01)               */
#define TMM_OPCTL0_HAZAD_SET_Pos          (6UL)                     /*!< TMM OPCTL0: HAZAD_SET (Bit 6)                         */
#define TMM_OPCTL0_HAZAD_SET_Msk          (0x40UL)                  /*!< TMM OPCTL0: HAZAD_SET (Bitfield-Mask: 0x01)           */
/* =========================================================  OPDF0  ========================================================= */
#define TMM_OPDF0_DFA0_Pos                (0UL)                     /*!< TMM OPDF0: DFA0 (Bit 0)                               */
#define TMM_OPDF0_DFA0_Msk                (0x3UL)                   /*!< TMM OPDF0: DFA0 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF0_DFB0_Pos                (2UL)                     /*!< TMM OPDF0: DFB0 (Bit 2)                               */
#define TMM_OPDF0_DFB0_Msk                (0xcUL)                   /*!< TMM OPDF0: DFB0 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF0_DFC0_Pos                (4UL)                     /*!< TMM OPDF0: DFC0 (Bit 4)                               */
#define TMM_OPDF0_DFC0_Msk                (0x30UL)                  /*!< TMM OPDF0: DFC0 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF0_DFD0_Pos                (6UL)                     /*!< TMM OPDF0: DFD0 (Bit 6)                               */
#define TMM_OPDF0_DFD0_Msk                (0xc0UL)                  /*!< TMM OPDF0: DFD0 (Bitfield-Mask: 0x03)                 */
/* =========================================================  OPDF1  ========================================================= */
#define TMM_OPDF1_DFA1_Pos                (0UL)                     /*!< TMM OPDF1: DFA1 (Bit 0)                               */
#define TMM_OPDF1_DFA1_Msk                (0x3UL)                   /*!< TMM OPDF1: DFA1 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF1_DFB1_Pos                (2UL)                     /*!< TMM OPDF1: DFB1 (Bit 2)                               */
#define TMM_OPDF1_DFB1_Msk                (0xcUL)                   /*!< TMM OPDF1: DFB1 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF1_DFC1_Pos                (4UL)                     /*!< TMM OPDF1: DFC1 (Bit 4)                               */
#define TMM_OPDF1_DFC1_Msk                (0x30UL)                  /*!< TMM OPDF1: DFC1 (Bitfield-Mask: 0x03)                 */
#define TMM_OPDF1_DFD1_Pos                (6UL)                     /*!< TMM OPDF1: DFD1 (Bit 6)                               */
#define TMM_OPDF1_DFD1_Msk                (0xc0UL)                  /*!< TMM OPDF1: DFD1 (Bitfield-Mask: 0x03)                 */
/* ========================================================  OPEDGE  ========================================================= */
#define TMM_OPEDGE_EG_Pos                 (0UL)                     /*!< TMM OPEDGE: EG (Bit 0)                                */
#define TMM_OPEDGE_EG_Msk                 (0x3UL)                   /*!< TMM OPEDGE: EG (Bitfield-Mask: 0x03)                  */
/* =========================================================  OPSR  ========================================================== */
#define TMM_OPSR_HZIF0_Pos                (0UL)                     /*!< TMM OPSR: HZIF0 (Bit 0)                               */
#define TMM_OPSR_HZIF0_Msk                (0x1UL)                   /*!< TMM OPSR: HZIF0 (Bitfield-Mask: 0x01)                 */
#define TMM_OPSR_HZOF0_Pos                (1UL)                     /*!< TMM OPSR: HZOF0 (Bit 1)                               */
#define TMM_OPSR_HZOF0_Msk                (0x2UL)                   /*!< TMM OPSR: HZOF0 (Bitfield-Mask: 0x01)                 */
#define TMM_OPSR_HZOF1_Pos                (2UL)                     /*!< TMM OPSR: HZOF1 (Bit 2)                               */
#define TMM_OPSR_HZOF1_Msk                (0x4UL)                   /*!< TMM OPSR: HZOF1 (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  SUBCUD  ========================================================= */
#define RTC_SUBCUD_F_Pos                  (0UL)                     /*!< RTC SUBCUD: F (Bit 0)                                 */
#define RTC_SUBCUD_F_Msk                  (0x1fffUL)                /*!< RTC SUBCUD: F (Bitfield-Mask: 0x1fff)                 */
#define RTC_SUBCUD_DEV_Pos                (15UL)                    /*!< RTC SUBCUD: DEV (Bit 15)                              */
#define RTC_SUBCUD_DEV_Msk                (0x8000UL)                /*!< RTC SUBCUD: DEV (Bitfield-Mask: 0x01)                 */
/* =========================================================  ITMC  ========================================================== */
#define RTC_ITMC_ITCMP_Pos                (0UL)                     /*!< RTC ITMC: ITCMP (Bit 0)                               */
#define RTC_ITMC_ITCMP_Msk                (0x7fffUL)                /*!< RTC ITMC: ITCMP (Bitfield-Mask: 0x7fff)               */
#define RTC_ITMC_RINTE_Pos                (15UL)                    /*!< RTC ITMC: RINTE (Bit 15)                              */
#define RTC_ITMC_RINTE_Msk                (0x8000UL)                /*!< RTC ITMC: RINTE (Bitfield-Mask: 0x01)                 */
/* ==========================================================  SEC  ========================================================== */
/* ==========================================================  MIN  ========================================================== */
/* =========================================================  HOUR  ========================================================== */
/* =========================================================  WEEK  ========================================================== */
/* ==========================================================  DAY  ========================================================== */
/* =========================================================  MONTH  ========================================================= */
/* =========================================================  YEAR  ========================================================== */
/* ========================================================  ALARMWM  ======================================================== */
/* ========================================================  ALARMWH  ======================================================== */
/* ========================================================  ALARMWW  ======================================================== */
/* =========================================================  RTCC0  ========================================================= */
#define RTC_RTCC0_CT_Pos                  (0UL)                     /*!< RTC RTCC0: CT (Bit 0)                                 */
#define RTC_RTCC0_CT_Msk                  (0x7UL)                   /*!< RTC RTCC0: CT (Bitfield-Mask: 0x07)                   */
#define RTC_RTCC0_AMPM_Pos                (3UL)                     /*!< RTC RTCC0: AMPM (Bit 3)                               */
#define RTC_RTCC0_AMPM_Msk                (0x8UL)                   /*!< RTC RTCC0: AMPM (Bitfield-Mask: 0x01)                 */
#define RTC_RTCC0_RCLOE_Pos               (5UL)                     /*!< RTC RTCC0: RCLOE (Bit 5)                              */
#define RTC_RTCC0_RCLOE_Msk               (0x20UL)                  /*!< RTC RTCC0: RCLOE (Bitfield-Mask: 0x01)                */
#define RTC_RTCC0_RTCE_Pos                (7UL)                     /*!< RTC RTCC0: RTCE (Bit 7)                               */
#define RTC_RTCC0_RTCE_Msk                (0x80UL)                  /*!< RTC RTCC0: RTCE (Bitfield-Mask: 0x01)                 */
/* =========================================================  RTCC1  ========================================================= */
#define RTC_RTCC1_RWAIT_Pos               (0UL)                     /*!< RTC RTCC1: RWAIT (Bit 0)                              */
#define RTC_RTCC1_RWAIT_Msk               (0x1UL)                   /*!< RTC RTCC1: RWAIT (Bitfield-Mask: 0x01)                */
#define RTC_RTCC1_RWST_Pos                (1UL)                     /*!< RTC RTCC1: RWST (Bit 1)                               */
#define RTC_RTCC1_RWST_Msk                (0x2UL)                   /*!< RTC RTCC1: RWST (Bitfield-Mask: 0x01)                 */
#define RTC_RTCC1_RIFG_Pos                (3UL)                     /*!< RTC RTCC1: RIFG (Bit 3)                               */
#define RTC_RTCC1_RIFG_Msk                (0x8UL)                   /*!< RTC RTCC1: RIFG (Bitfield-Mask: 0x01)                 */
#define RTC_RTCC1_WAFG_Pos                (4UL)                     /*!< RTC RTCC1: WAFG (Bit 4)                               */
#define RTC_RTCC1_WAFG_Msk                (0x10UL)                  /*!< RTC RTCC1: WAFG (Bitfield-Mask: 0x01)                 */
#define RTC_RTCC1_WALIE_Pos               (6UL)                     /*!< RTC RTCC1: WALIE (Bit 6)                              */
#define RTC_RTCC1_WALIE_Msk               (0x40UL)                  /*!< RTC RTCC1: WALIE (Bitfield-Mask: 0x01)                */
#define RTC_RTCC1_WALE_Pos                (7UL)                     /*!< RTC RTCC1: WALE (Bit 7)                               */
#define RTC_RTCC1_WALE_Msk                (0x80UL)                  /*!< RTC RTCC1: WALE (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                           PCBZ                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  CKS0  ========================================================== */
#define PCBZ_CKS0_CCS_Pos                 (0UL)                     /*!< PCBZ CKS0: CCS (Bit 0)                                */
#define PCBZ_CKS0_CCS_Msk                 (0x7UL)                   /*!< PCBZ CKS0: CCS (Bitfield-Mask: 0x07)                  */
#define PCBZ_CKS0_CSEL_Pos                (3UL)                     /*!< PCBZ CKS0: CSEL (Bit 3)                               */
#define PCBZ_CKS0_CSEL_Msk                (0x8UL)                   /*!< PCBZ CKS0: CSEL (Bitfield-Mask: 0x01)                 */
#define PCBZ_CKS0_PCLOE_Pos               (7UL)                     /*!< PCBZ CKS0: PCLOE (Bit 7)                              */
#define PCBZ_CKS0_PCLOE_Msk               (0x80UL)                  /*!< PCBZ CKS0: PCLOE (Bitfield-Mask: 0x01)                */
/* =========================================================  CKS1  ========================================================== */
#define PCBZ_CKS1_CCS_Pos                 (0UL)                     /*!< PCBZ CKS1: CCS (Bit 0)                                */
#define PCBZ_CKS1_CCS_Msk                 (0x7UL)                   /*!< PCBZ CKS1: CCS (Bitfield-Mask: 0x07)                  */
#define PCBZ_CKS1_CSEL_Pos                (3UL)                     /*!< PCBZ CKS1: CSEL (Bit 3)                               */
#define PCBZ_CKS1_CSEL_Msk                (0x8UL)                   /*!< PCBZ CKS1: CSEL (Bitfield-Mask: 0x01)                 */
#define PCBZ_CKS1_PCLOE_Pos               (7UL)                     /*!< PCBZ CKS1: PCLOE (Bit 7)                              */
#define PCBZ_CKS1_PCLOE_Msk               (0x80UL)                  /*!< PCBZ CKS1: PCLOE (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  WDTE  ========================================================== */


/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  ADM0  ========================================================== */
#define ADC_ADM0_ADCE_Pos                 (0UL)                     /*!< ADC ADM0: ADCE (Bit 0)                                */
#define ADC_ADM0_ADCE_Msk                 (0x1UL)                   /*!< ADC ADM0: ADCE (Bitfield-Mask: 0x01)                  */
#define ADC_ADM0_FR_Pos                   (3UL)                     /*!< ADC ADM0: FR (Bit 3)                                  */
#define ADC_ADM0_FR_Msk                   (0x38UL)                  /*!< ADC ADM0: FR (Bitfield-Mask: 0x07)                    */
#define ADC_ADM0_ADCS_Pos                 (7UL)                     /*!< ADC ADM0: ADCS (Bit 7)                                */
#define ADC_ADM0_ADCS_Msk                 (0x80UL)                  /*!< ADC ADM0: ADCS (Bitfield-Mask: 0x01)                  */
/* =========================================================  ADM1  ========================================================== */
#define ADC_ADM1_ADMODE_Pos               (0UL)                     /*!< ADC ADM1: ADMODE (Bit 0)                              */
#define ADC_ADM1_ADMODE_Msk               (0x3UL)                   /*!< ADC ADM1: ADMODE (Bitfield-Mask: 0x03)                */
#define ADC_ADM1_ADSCM_Pos                (3UL)                     /*!< ADC ADM1: ADSCM (Bit 3)                               */
#define ADC_ADM1_ADSCM_Msk                (0x8UL)                   /*!< ADC ADM1: ADSCM (Bitfield-Mask: 0x01)                 */
#define ADC_ADM1_ADMD_Pos                 (7UL)                     /*!< ADC ADM1: ADMD (Bit 7)                                */
#define ADC_ADM1_ADMD_Msk                 (0x80UL)                  /*!< ADC ADM1: ADMD (Bitfield-Mask: 0x01)                  */
/* =========================================================  ADM2  ========================================================== */
#define ADC_ADM2_CHRDE_Pos                (1UL)                     /*!< ADC ADM2: CHRDE (Bit 1)                               */
#define ADC_ADM2_CHRDE_Msk                (0x2UL)                   /*!< ADC ADM2: CHRDE (Bitfield-Mask: 0x01)                 */
#define ADC_ADM2_ADRCK_Pos                (3UL)                     /*!< ADC ADM2: ADRCK (Bit 3)                               */
#define ADC_ADM2_ADRCK_Msk                (0x8UL)                   /*!< ADC ADM2: ADRCK (Bitfield-Mask: 0x01)                 */
#define ADC_ADM2_ADREFM_Pos               (5UL)                     /*!< ADC ADM2: ADREFM (Bit 5)                              */
#define ADC_ADM2_ADREFM_Msk               (0x20UL)                  /*!< ADC ADM2: ADREFM (Bitfield-Mask: 0x01)                */
#define ADC_ADM2_ADREFP_Pos               (6UL)                     /*!< ADC ADM2: ADREFP (Bit 6)                              */
#define ADC_ADM2_ADREFP_Msk               (0xc0UL)                  /*!< ADC ADM2: ADREFP (Bitfield-Mask: 0x03)                */
/* =========================================================  ADTRG  ========================================================= */
#define ADC_ADTRG_ADTMD_Pos               (6UL)                     /*!< ADC ADTRG: ADTMD (Bit 6)                              */
#define ADC_ADTRG_ADTMD_Msk               (0xc0UL)                  /*!< ADC ADTRG: ADTMD (Bitfield-Mask: 0x03)                */
#define ADC_ADTRG_ADTRS_Pos               (0UL)                     /*!< ADC ADTRG: ADTRS (Bit 0)                              */
#define ADC_ADTRG_ADTRS_Msk               (0x3UL)                   /*!< ADC ADTRG: ADTRS (Bitfield-Mask: 0x03)                */
/* ==========================================================  ADS  ========================================================== */
#define ADC_ADS_ADSCHn_Pos                (4UL)                     /*!< ADC ADS: ADSCHn (Bit 4)                               */
#define ADC_ADS_ADSCHn_Msk                (0x0UL)                   /*!< ADC ADS: ADSCHn (Bitfield-Mask: 0x00)                 */ Even number for MASK detected!
#define ADC_ADS_ADCHPGA0_Pos              (5UL)                     /*!< ADC ADS: ADCHPGA0 (Bit 5)                             */
#define ADC_ADS_ADCHPGA0_Msk              (0x20UL)                  /*!< ADC ADS: ADCHPGA0 (Bitfield-Mask: 0x01)               */
#define ADC_ADS_ADCHPGA1_Pos              (6UL)                     /*!< ADC ADS: ADCHPGA1 (Bit 6)                             */
#define ADC_ADS_ADCHPGA1_Msk              (0x40UL)                  /*!< ADC ADS: ADCHPGA1 (Bitfield-Mask: 0x01)               */
#define ADC_ADS_ADISS_Pos                 (7UL)                     /*!< ADC ADS: ADISS (Bit 7)                                */
#define ADC_ADS_ADISS_Msk                 (0x80UL)                  /*!< ADC ADS: ADISS (Bitfield-Mask: 0x01)                  */
/* =========================================================  ADCR  ========================================================== */
/* =========================================================  ADCRH  ========================================================= */
/* =========================================================  ADUL  ========================================================== */
/* =========================================================  ADLL  ========================================================== */
/* =========================================================  ADTES  ========================================================= */
/* =========================================================  ADFLG  ========================================================= */
/* ========================================================  ADNSMP  ========================================================= */
/* =======================================================  ADSMPWAIT  ======================================================= */
/* ========================================================  ADNDIS  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            DAC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  DACS0  ========================================================= */
/* =========================================================  DACS1  ========================================================= */
/* ==========================================================  DAM  ========================================================== */
#define DAC_DAM_DAMD0_Pos                 (0UL)                     /*!< DAC DAM: DAMD0 (Bit 0)                                */
#define DAC_DAM_DAMD0_Msk                 (0x1UL)                   /*!< DAC DAM: DAMD0 (Bitfield-Mask: 0x01)                  */
#define DAC_DAM_DAMD1_Pos                 (1UL)                     /*!< DAC DAM: DAMD1 (Bit 1)                                */
#define DAC_DAM_DAMD1_Msk                 (0x2UL)                   /*!< DAC DAM: DAMD1 (Bitfield-Mask: 0x01)                  */
#define DAC_DAM_DACE0_Pos                 (4UL)                     /*!< DAC DAM: DACE0 (Bit 4)                                */
#define DAC_DAM_DACE0_Msk                 (0x10UL)                  /*!< DAC DAM: DACE0 (Bitfield-Mask: 0x01)                  */
#define DAC_DAM_DACE1_Pos                 (5UL)                     /*!< DAC DAM: DACE1 (Bit 5)                                */
#define DAC_DAM_DACE1_Msk                 (0x20UL)                  /*!< DAC DAM: DACE1 (Bitfield-Mask: 0x01)                  */


/* =========================================================================================================================== */
/* ================                                            CMP                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  COMPMDR  ======================================================== */
#define CMP_COMPMDR_C0ENB_Pos             (0UL)                     /*!< CMP COMPMDR: C0ENB (Bit 0)                            */
#define CMP_COMPMDR_C0ENB_Msk             (0x1UL)                   /*!< CMP COMPMDR: C0ENB (Bitfield-Mask: 0x01)              */
#define CMP_COMPMDR_C0MON_Pos             (3UL)                     /*!< CMP COMPMDR: C0MON (Bit 3)                            */
#define CMP_COMPMDR_C0MON_Msk             (0x8UL)                   /*!< CMP COMPMDR: C0MON (Bitfield-Mask: 0x01)              */
#define CMP_COMPMDR_C1ENB_Pos             (4UL)                     /*!< CMP COMPMDR: C1ENB (Bit 4)                            */
#define CMP_COMPMDR_C1ENB_Msk             (0x10UL)                  /*!< CMP COMPMDR: C1ENB (Bitfield-Mask: 0x01)              */
#define CMP_COMPMDR_C1MON_Pos             (7UL)                     /*!< CMP COMPMDR: C1MON (Bit 7)                            */
#define CMP_COMPMDR_C1MON_Msk             (0x80UL)                  /*!< CMP COMPMDR: C1MON (Bitfield-Mask: 0x01)              */
/* ========================================================  COMPFIR  ======================================================== */
#define CMP_COMPFIR_C0FCK_Pos             (0UL)                     /*!< CMP COMPFIR: C0FCK (Bit 0)                            */
#define CMP_COMPFIR_C0FCK_Msk             (0x3UL)                   /*!< CMP COMPFIR: C0FCK (Bitfield-Mask: 0x03)              */
#define CMP_COMPFIR_C0EPO_Pos             (2UL)                     /*!< CMP COMPFIR: C0EPO (Bit 2)                            */
#define CMP_COMPFIR_C0EPO_Msk             (0x4UL)                   /*!< CMP COMPFIR: C0EPO (Bitfield-Mask: 0x01)              */
#define CMP_COMPFIR_C0EDG_Pos             (3UL)                     /*!< CMP COMPFIR: C0EDG (Bit 3)                            */
#define CMP_COMPFIR_C0EDG_Msk             (0x8UL)                   /*!< CMP COMPFIR: C0EDG (Bitfield-Mask: 0x01)              */
#define CMP_COMPFIR_C1FCK_Pos             (4UL)                     /*!< CMP COMPFIR: C1FCK (Bit 4)                            */
#define CMP_COMPFIR_C1FCK_Msk             (0x30UL)                  /*!< CMP COMPFIR: C1FCK (Bitfield-Mask: 0x03)              */
#define CMP_COMPFIR_C1EPO_Pos             (6UL)                     /*!< CMP COMPFIR: C1EPO (Bit 6)                            */
#define CMP_COMPFIR_C1EPO_Msk             (0x40UL)                  /*!< CMP COMPFIR: C1EPO (Bitfield-Mask: 0x01)              */
#define CMP_COMPFIR_C1EDG_Pos             (7UL)                     /*!< CMP COMPFIR: C1EDG (Bit 7)                            */
#define CMP_COMPFIR_C1EDG_Msk             (0x80UL)                  /*!< CMP COMPFIR: C1EDG (Bitfield-Mask: 0x01)              */
/* ========================================================  COMPOCR  ======================================================== */
#define CMP_COMPOCR_C0IE_Pos              (0UL)                     /*!< CMP COMPOCR: C0IE (Bit 0)                             */
#define CMP_COMPOCR_C0IE_Msk              (0x1UL)                   /*!< CMP COMPOCR: C0IE (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C0OE_Pos              (1UL)                     /*!< CMP COMPOCR: C0OE (Bit 1)                             */
#define CMP_COMPOCR_C0OE_Msk              (0x2UL)                   /*!< CMP COMPOCR: C0OE (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C0OP_Pos              (2UL)                     /*!< CMP COMPOCR: C0OP (Bit 2)                             */
#define CMP_COMPOCR_C0OP_Msk              (0x4UL)                   /*!< CMP COMPOCR: C0OP (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C1IE_Pos              (4UL)                     /*!< CMP COMPOCR: C1IE (Bit 4)                             */
#define CMP_COMPOCR_C1IE_Msk              (0x10UL)                  /*!< CMP COMPOCR: C1IE (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C1OE_Pos              (5UL)                     /*!< CMP COMPOCR: C1OE (Bit 5)                             */
#define CMP_COMPOCR_C1OE_Msk              (0x20UL)                  /*!< CMP COMPOCR: C1OE (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C1OP_Pos              (6UL)                     /*!< CMP COMPOCR: C1OP (Bit 6)                             */
#define CMP_COMPOCR_C1OP_Msk              (0x40UL)                  /*!< CMP COMPOCR: C1OP (Bitfield-Mask: 0x01)               */
#define CMP_COMPOCR_C1OTWMD_Pos           (7UL)                     /*!< CMP COMPOCR: C1OTWMD (Bit 7)                          */
#define CMP_COMPOCR_C1OTWMD_Msk           (0x80UL)                  /*!< CMP COMPOCR: C1OTWMD (Bitfield-Mask: 0x01)            */
/* ========================================================  CVRCTL  ========================================================= */
#define CMP_CVRCTL_CVRVS0_Pos             (0UL)                     /*!< CMP CVRCTL: CVRVS0 (Bit 0)                            */
#define CMP_CVRCTL_CVRVS0_Msk             (0x1UL)                   /*!< CMP CVRCTL: CVRVS0 (Bitfield-Mask: 0x01)              */
#define CMP_CVRCTL_CVRE0_Pos              (1UL)                     /*!< CMP CVRCTL: CVRE0 (Bit 1)                             */
#define CMP_CVRCTL_CVRE0_Msk              (0x2UL)                   /*!< CMP CVRCTL: CVRE0 (Bitfield-Mask: 0x01)               */
#define CMP_CVRCTL_CVRVS1_Pos             (4UL)                     /*!< CMP CVRCTL: CVRVS1 (Bit 4)                            */
#define CMP_CVRCTL_CVRVS1_Msk             (0x10UL)                  /*!< CMP CVRCTL: CVRVS1 (Bitfield-Mask: 0x01)              */
#define CMP_CVRCTL_CVRE1_Pos              (5UL)                     /*!< CMP CVRCTL: CVRE1 (Bit 5)                             */
#define CMP_CVRCTL_CVRE1_Msk              (0x20UL)                  /*!< CMP CVRCTL: CVRE1 (Bitfield-Mask: 0x01)               */
/* =========================================================  C0RVM  ========================================================= */
/* =========================================================  C1RVM  ========================================================= */
/* ========================================================  CMPSEL0  ======================================================== */
#define CMP_CMPSEL0_C0REFS_Pos            (0UL)                     /*!< CMP CMPSEL0: C0REFS (Bit 0)                           */
#define CMP_CMPSEL0_C0REFS_Msk            (0x3UL)                   /*!< CMP CMPSEL0: C0REFS (Bitfield-Mask: 0x03)             */
#define CMP_CMPSEL0_CMP0SEL_Pos           (7UL)                     /*!< CMP CMPSEL0: CMP0SEL (Bit 7)                          */
#define CMP_CMPSEL0_CMP0SEL_Msk           (0x80UL)                  /*!< CMP CMPSEL0: CMP0SEL (Bitfield-Mask: 0x01)            */
/* ========================================================  CMPSEL1  ======================================================== */
#define CMP_CMPSEL1_C1REFS_Pos            (0UL)                     /*!< CMP CMPSEL1: C1REFS (Bit 0)                           */
#define CMP_CMPSEL1_C1REFS_Msk            (0x7UL)                   /*!< CMP CMPSEL1: C1REFS (Bitfield-Mask: 0x07)             */
#define CMP_CMPSEL1_CMP1SEL_Pos           (6UL)                     /*!< CMP CMPSEL1: CMP1SEL (Bit 6)                          */
#define CMP_CMPSEL1_CMP1SEL_Msk           (0xc0UL)                  /*!< CMP CMPSEL1: CMP1SEL (Bitfield-Mask: 0x03)            */
/* ========================================================  CMP0HY  ========================================================= */
#define CMP_CMP0HY_C0HYSLS_Pos            (0UL)                     /*!< CMP CMP0HY: C0HYSLS (Bit 0)                           */
#define CMP_CMP0HY_C0HYSLS_Msk            (0x3UL)                   /*!< CMP CMP0HY: C0HYSLS (Bitfield-Mask: 0x03)             */
#define CMP_CMP0HY_C0HYSVS_Pos            (4UL)                     /*!< CMP CMP0HY: C0HYSVS (Bit 4)                           */
#define CMP_CMP0HY_C0HYSVS_Msk            (0x30UL)                  /*!< CMP CMP0HY: C0HYSVS (Bitfield-Mask: 0x03)             */
/* ========================================================  CMP1HY  ========================================================= */
#define CMP_CMP1HY_C1HYSLS_Pos            (0UL)                     /*!< CMP CMP1HY: C1HYSLS (Bit 0)                           */
#define CMP_CMP1HY_C1HYSLS_Msk            (0x3UL)                   /*!< CMP CMP1HY: C1HYSLS (Bitfield-Mask: 0x03)             */
#define CMP_CMP1HY_C1HYSVS_Pos            (4UL)                     /*!< CMP CMP1HY: C1HYSVS (Bit 4)                           */
#define CMP_CMP1HY_C1HYSVS_Msk            (0x30UL)                  /*!< CMP CMP1HY: C1HYSVS (Bitfield-Mask: 0x03)             */


/* =========================================================================================================================== */
/* ================                                            PGA                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PGA0CTL  ======================================================== */
#define PGA_PGA0CTL_PGAVG_Pos             (0UL)                     /*!< PGA PGA0CTL: PGAVG (Bit 0)                            */
#define PGA_PGA0CTL_PGAVG_Msk             (0x7UL)                   /*!< PGA PGA0CTL: PGAVG (Bitfield-Mask: 0x07)              */
#define PGA_PGA0CTL_PVRVS_Pos             (3UL)                     /*!< PGA PGA0CTL: PVRVS (Bit 3)                            */
#define PGA_PGA0CTL_PVRVS_Msk             (0x8UL)                   /*!< PGA PGA0CTL: PVRVS (Bitfield-Mask: 0x01)              */
#define PGA_PGA0CTL_PGAEN_Pos             (7UL)                     /*!< PGA PGA0CTL: PGAEN (Bit 7)                            */
#define PGA_PGA0CTL_PGAEN_Msk             (0x80UL)                  /*!< PGA PGA0CTL: PGAEN (Bitfield-Mask: 0x01)              */
/* ========================================================  PGA1CTL  ======================================================== */
#define PGA_PGA1CTL_PGAVG_Pos             (0UL)                     /*!< PGA PGA1CTL: PGAVG (Bit 0)                            */
#define PGA_PGA1CTL_PGAVG_Msk             (0x7UL)                   /*!< PGA PGA1CTL: PGAVG (Bitfield-Mask: 0x07)              */
#define PGA_PGA1CTL_PVRVS_Pos             (3UL)                     /*!< PGA PGA1CTL: PVRVS (Bit 3)                            */
#define PGA_PGA1CTL_PVRVS_Msk             (0x8UL)                   /*!< PGA PGA1CTL: PVRVS (Bitfield-Mask: 0x01)              */
#define PGA_PGA1CTL_PGAEN_Pos             (7UL)                     /*!< PGA PGA1CTL: PGAEN (Bit 7)                            */
#define PGA_PGA1CTL_PGAEN_Msk             (0x80UL)                  /*!< PGA PGA1CTL: PGAEN (Bitfield-Mask: 0x01)              */


/* =========================================================================================================================== */
/* ================                                           SCI0                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  SSR00  ========================================================= */
#define SCI0_SSR00_OVF_Pos                (0UL)                     /*!< SCI0 SSR00: OVF (Bit 0)                               */
#define SCI0_SSR00_OVF_Msk                (0x1UL)                   /*!< SCI0 SSR00: OVF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR00_PEF_Pos                (1UL)                     /*!< SCI0 SSR00: PEF (Bit 1)                               */
#define SCI0_SSR00_PEF_Msk                (0x2UL)                   /*!< SCI0 SSR00: PEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR00_FEF_Pos                (2UL)                     /*!< SCI0 SSR00: FEF (Bit 2)                               */
#define SCI0_SSR00_FEF_Msk                (0x4UL)                   /*!< SCI0 SSR00: FEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR00_BFF_Pos                (5UL)                     /*!< SCI0 SSR00: BFF (Bit 5)                               */
#define SCI0_SSR00_BFF_Msk                (0x20UL)                  /*!< SCI0 SSR00: BFF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR00_TSF_Pos                (6UL)                     /*!< SCI0 SSR00: TSF (Bit 6)                               */
#define SCI0_SSR00_TSF_Msk                (0x40UL)                  /*!< SCI0 SSR00: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SSR01  ========================================================= */
#define SCI0_SSR01_OVF_Pos                (0UL)                     /*!< SCI0 SSR01: OVF (Bit 0)                               */
#define SCI0_SSR01_OVF_Msk                (0x1UL)                   /*!< SCI0 SSR01: OVF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR01_PEF_Pos                (1UL)                     /*!< SCI0 SSR01: PEF (Bit 1)                               */
#define SCI0_SSR01_PEF_Msk                (0x2UL)                   /*!< SCI0 SSR01: PEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR01_FEF_Pos                (2UL)                     /*!< SCI0 SSR01: FEF (Bit 2)                               */
#define SCI0_SSR01_FEF_Msk                (0x4UL)                   /*!< SCI0 SSR01: FEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR01_BFF_Pos                (5UL)                     /*!< SCI0 SSR01: BFF (Bit 5)                               */
#define SCI0_SSR01_BFF_Msk                (0x20UL)                  /*!< SCI0 SSR01: BFF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR01_TSF_Pos                (6UL)                     /*!< SCI0 SSR01: TSF (Bit 6)                               */
#define SCI0_SSR01_TSF_Msk                (0x40UL)                  /*!< SCI0 SSR01: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SSR02  ========================================================= */
#define SCI0_SSR02_OVF_Pos                (0UL)                     /*!< SCI0 SSR02: OVF (Bit 0)                               */
#define SCI0_SSR02_OVF_Msk                (0x1UL)                   /*!< SCI0 SSR02: OVF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR02_PEF_Pos                (1UL)                     /*!< SCI0 SSR02: PEF (Bit 1)                               */
#define SCI0_SSR02_PEF_Msk                (0x2UL)                   /*!< SCI0 SSR02: PEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR02_FEF_Pos                (2UL)                     /*!< SCI0 SSR02: FEF (Bit 2)                               */
#define SCI0_SSR02_FEF_Msk                (0x4UL)                   /*!< SCI0 SSR02: FEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR02_BFF_Pos                (5UL)                     /*!< SCI0 SSR02: BFF (Bit 5)                               */
#define SCI0_SSR02_BFF_Msk                (0x20UL)                  /*!< SCI0 SSR02: BFF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR02_TSF_Pos                (6UL)                     /*!< SCI0 SSR02: TSF (Bit 6)                               */
#define SCI0_SSR02_TSF_Msk                (0x40UL)                  /*!< SCI0 SSR02: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SSR03  ========================================================= */
#define SCI0_SSR03_OVF_Pos                (0UL)                     /*!< SCI0 SSR03: OVF (Bit 0)                               */
#define SCI0_SSR03_OVF_Msk                (0x1UL)                   /*!< SCI0 SSR03: OVF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR03_PEF_Pos                (1UL)                     /*!< SCI0 SSR03: PEF (Bit 1)                               */
#define SCI0_SSR03_PEF_Msk                (0x2UL)                   /*!< SCI0 SSR03: PEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR03_FEF_Pos                (2UL)                     /*!< SCI0 SSR03: FEF (Bit 2)                               */
#define SCI0_SSR03_FEF_Msk                (0x4UL)                   /*!< SCI0 SSR03: FEF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR03_BFF_Pos                (5UL)                     /*!< SCI0 SSR03: BFF (Bit 5)                               */
#define SCI0_SSR03_BFF_Msk                (0x20UL)                  /*!< SCI0 SSR03: BFF (Bitfield-Mask: 0x01)                 */
#define SCI0_SSR03_TSF_Pos                (6UL)                     /*!< SCI0 SSR03: TSF (Bit 6)                               */
#define SCI0_SSR03_TSF_Msk                (0x40UL)                  /*!< SCI0 SSR03: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SIR00  ========================================================= */
#define SCI0_SIR00_OVCT_Pos               (0UL)                     /*!< SCI0 SIR00: OVCT (Bit 0)                              */
#define SCI0_SIR00_OVCT_Msk               (0x1UL)                   /*!< SCI0 SIR00: OVCT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR00_PECT_Pos               (1UL)                     /*!< SCI0 SIR00: PECT (Bit 1)                              */
#define SCI0_SIR00_PECT_Msk               (0x2UL)                   /*!< SCI0 SIR00: PECT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR00_FECT_Pos               (2UL)                     /*!< SCI0 SIR00: FECT (Bit 2)                              */
#define SCI0_SIR00_FECT_Msk               (0x4UL)                   /*!< SCI0 SIR00: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SIR01  ========================================================= */
#define SCI0_SIR01_OVCT_Pos               (0UL)                     /*!< SCI0 SIR01: OVCT (Bit 0)                              */
#define SCI0_SIR01_OVCT_Msk               (0x1UL)                   /*!< SCI0 SIR01: OVCT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR01_PECT_Pos               (1UL)                     /*!< SCI0 SIR01: PECT (Bit 1)                              */
#define SCI0_SIR01_PECT_Msk               (0x2UL)                   /*!< SCI0 SIR01: PECT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR01_FECT_Pos               (2UL)                     /*!< SCI0 SIR01: FECT (Bit 2)                              */
#define SCI0_SIR01_FECT_Msk               (0x4UL)                   /*!< SCI0 SIR01: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SIR02  ========================================================= */
#define SCI0_SIR02_OVCT_Pos               (0UL)                     /*!< SCI0 SIR02: OVCT (Bit 0)                              */
#define SCI0_SIR02_OVCT_Msk               (0x1UL)                   /*!< SCI0 SIR02: OVCT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR02_PECT_Pos               (1UL)                     /*!< SCI0 SIR02: PECT (Bit 1)                              */
#define SCI0_SIR02_PECT_Msk               (0x2UL)                   /*!< SCI0 SIR02: PECT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR02_FECT_Pos               (2UL)                     /*!< SCI0 SIR02: FECT (Bit 2)                              */
#define SCI0_SIR02_FECT_Msk               (0x4UL)                   /*!< SCI0 SIR02: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SIR03  ========================================================= */
#define SCI0_SIR03_OVCT_Pos               (0UL)                     /*!< SCI0 SIR03: OVCT (Bit 0)                              */
#define SCI0_SIR03_OVCT_Msk               (0x1UL)                   /*!< SCI0 SIR03: OVCT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR03_PECT_Pos               (1UL)                     /*!< SCI0 SIR03: PECT (Bit 1)                              */
#define SCI0_SIR03_PECT_Msk               (0x2UL)                   /*!< SCI0 SIR03: PECT (Bitfield-Mask: 0x01)                */
#define SCI0_SIR03_FECT_Pos               (2UL)                     /*!< SCI0 SIR03: FECT (Bit 2)                              */
#define SCI0_SIR03_FECT_Msk               (0x4UL)                   /*!< SCI0 SIR03: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SMR00  ========================================================= */
#define SCI0_SMR00_MD_Pos                 (0UL)                     /*!< SCI0 SMR00: MD (Bit 0)                                */
#define SCI0_SMR00_MD_Msk                 (0xfUL)                   /*!< SCI0 SMR00: MD (Bitfield-Mask: 0x0f)                  */
#define SCI0_SMR00_SIS_Pos                (6UL)                     /*!< SCI0 SMR00: SIS (Bit 6)                               */
#define SCI0_SMR00_SIS_Msk                (0x40UL)                  /*!< SCI0 SMR00: SIS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR00_STS_Pos                (8UL)                     /*!< SCI0 SMR00: STS (Bit 8)                               */
#define SCI0_SMR00_STS_Msk                (0x100UL)                 /*!< SCI0 SMR00: STS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR00_CCS_Pos                (14UL)                    /*!< SCI0 SMR00: CCS (Bit 14)                              */
#define SCI0_SMR00_CCS_Msk                (0x4000UL)                /*!< SCI0 SMR00: CCS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR00_CKS_Pos                (15UL)                    /*!< SCI0 SMR00: CKS (Bit 15)                              */
#define SCI0_SMR00_CKS_Msk                (0x8000UL)                /*!< SCI0 SMR00: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SMR01  ========================================================= */
#define SCI0_SMR01_MD_Pos                 (0UL)                     /*!< SCI0 SMR01: MD (Bit 0)                                */
#define SCI0_SMR01_MD_Msk                 (0xfUL)                   /*!< SCI0 SMR01: MD (Bitfield-Mask: 0x0f)                  */
#define SCI0_SMR01_SIS_Pos                (6UL)                     /*!< SCI0 SMR01: SIS (Bit 6)                               */
#define SCI0_SMR01_SIS_Msk                (0x40UL)                  /*!< SCI0 SMR01: SIS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR01_STS_Pos                (8UL)                     /*!< SCI0 SMR01: STS (Bit 8)                               */
#define SCI0_SMR01_STS_Msk                (0x100UL)                 /*!< SCI0 SMR01: STS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR01_CCS_Pos                (14UL)                    /*!< SCI0 SMR01: CCS (Bit 14)                              */
#define SCI0_SMR01_CCS_Msk                (0x4000UL)                /*!< SCI0 SMR01: CCS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR01_CKS_Pos                (15UL)                    /*!< SCI0 SMR01: CKS (Bit 15)                              */
#define SCI0_SMR01_CKS_Msk                (0x8000UL)                /*!< SCI0 SMR01: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SMR02  ========================================================= */
#define SCI0_SMR02_MD_Pos                 (0UL)                     /*!< SCI0 SMR02: MD (Bit 0)                                */
#define SCI0_SMR02_MD_Msk                 (0xfUL)                   /*!< SCI0 SMR02: MD (Bitfield-Mask: 0x0f)                  */
#define SCI0_SMR02_SIS_Pos                (6UL)                     /*!< SCI0 SMR02: SIS (Bit 6)                               */
#define SCI0_SMR02_SIS_Msk                (0x40UL)                  /*!< SCI0 SMR02: SIS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR02_STS_Pos                (8UL)                     /*!< SCI0 SMR02: STS (Bit 8)                               */
#define SCI0_SMR02_STS_Msk                (0x100UL)                 /*!< SCI0 SMR02: STS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR02_CCS_Pos                (14UL)                    /*!< SCI0 SMR02: CCS (Bit 14)                              */
#define SCI0_SMR02_CCS_Msk                (0x4000UL)                /*!< SCI0 SMR02: CCS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR02_CKS_Pos                (15UL)                    /*!< SCI0 SMR02: CKS (Bit 15)                              */
#define SCI0_SMR02_CKS_Msk                (0x8000UL)                /*!< SCI0 SMR02: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SMR03  ========================================================= */
#define SCI0_SMR03_MD_Pos                 (0UL)                     /*!< SCI0 SMR03: MD (Bit 0)                                */
#define SCI0_SMR03_MD_Msk                 (0xfUL)                   /*!< SCI0 SMR03: MD (Bitfield-Mask: 0x0f)                  */
#define SCI0_SMR03_SIS_Pos                (6UL)                     /*!< SCI0 SMR03: SIS (Bit 6)                               */
#define SCI0_SMR03_SIS_Msk                (0x40UL)                  /*!< SCI0 SMR03: SIS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR03_STS_Pos                (8UL)                     /*!< SCI0 SMR03: STS (Bit 8)                               */
#define SCI0_SMR03_STS_Msk                (0x100UL)                 /*!< SCI0 SMR03: STS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR03_CCS_Pos                (14UL)                    /*!< SCI0 SMR03: CCS (Bit 14)                              */
#define SCI0_SMR03_CCS_Msk                (0x4000UL)                /*!< SCI0 SMR03: CCS (Bitfield-Mask: 0x01)                 */
#define SCI0_SMR03_CKS_Pos                (15UL)                    /*!< SCI0 SMR03: CKS (Bit 15)                              */
#define SCI0_SMR03_CKS_Msk                (0x8000UL)                /*!< SCI0 SMR03: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR00  ========================================================= */
#define SCI0_SCR00_DLS_Pos                (0UL)                     /*!< SCI0 SCR00: DLS (Bit 0)                               */
#define SCI0_SCR00_DLS_Msk                (0x3UL)                   /*!< SCI0 SCR00: DLS (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR00_SLC_Pos                (4UL)                     /*!< SCI0 SCR00: SLC (Bit 4)                               */
#define SCI0_SCR00_SLC_Msk                (0x30UL)                  /*!< SCI0 SCR00: SLC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR00_DIR_Pos                (7UL)                     /*!< SCI0 SCR00: DIR (Bit 7)                               */
#define SCI0_SCR00_DIR_Msk                (0x80UL)                  /*!< SCI0 SCR00: DIR (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR00_PTC_Pos                (8UL)                     /*!< SCI0 SCR00: PTC (Bit 8)                               */
#define SCI0_SCR00_PTC_Msk                (0x300UL)                 /*!< SCI0 SCR00: PTC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR00_EOC_Pos                (10UL)                    /*!< SCI0 SCR00: EOC (Bit 10)                              */
#define SCI0_SCR00_EOC_Msk                (0x400UL)                 /*!< SCI0 SCR00: EOC (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR00_CKP_Pos                (12UL)                    /*!< SCI0 SCR00: CKP (Bit 12)                              */
#define SCI0_SCR00_CKP_Msk                (0x1000UL)                /*!< SCI0 SCR00: CKP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR00_DAP_Pos                (13UL)                    /*!< SCI0 SCR00: DAP (Bit 13)                              */
#define SCI0_SCR00_DAP_Msk                (0x2000UL)                /*!< SCI0 SCR00: DAP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR00_RXE_Pos                (14UL)                    /*!< SCI0 SCR00: RXE (Bit 14)                              */
#define SCI0_SCR00_RXE_Msk                (0x4000UL)                /*!< SCI0 SCR00: RXE (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR00_TXE_Pos                (15UL)                    /*!< SCI0 SCR00: TXE (Bit 15)                              */
#define SCI0_SCR00_TXE_Msk                (0x8000UL)                /*!< SCI0 SCR00: TXE (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR01  ========================================================= */
#define SCI0_SCR01_DLS_Pos                (0UL)                     /*!< SCI0 SCR01: DLS (Bit 0)                               */
#define SCI0_SCR01_DLS_Msk                (0x3UL)                   /*!< SCI0 SCR01: DLS (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR01_SLC_Pos                (4UL)                     /*!< SCI0 SCR01: SLC (Bit 4)                               */
#define SCI0_SCR01_SLC_Msk                (0x30UL)                  /*!< SCI0 SCR01: SLC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR01_DIR_Pos                (7UL)                     /*!< SCI0 SCR01: DIR (Bit 7)                               */
#define SCI0_SCR01_DIR_Msk                (0x80UL)                  /*!< SCI0 SCR01: DIR (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR01_PTC_Pos                (8UL)                     /*!< SCI0 SCR01: PTC (Bit 8)                               */
#define SCI0_SCR01_PTC_Msk                (0x300UL)                 /*!< SCI0 SCR01: PTC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR01_EOC_Pos                (10UL)                    /*!< SCI0 SCR01: EOC (Bit 10)                              */
#define SCI0_SCR01_EOC_Msk                (0x400UL)                 /*!< SCI0 SCR01: EOC (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR01_CKP_Pos                (12UL)                    /*!< SCI0 SCR01: CKP (Bit 12)                              */
#define SCI0_SCR01_CKP_Msk                (0x1000UL)                /*!< SCI0 SCR01: CKP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR01_DAP_Pos                (13UL)                    /*!< SCI0 SCR01: DAP (Bit 13)                              */
#define SCI0_SCR01_DAP_Msk                (0x2000UL)                /*!< SCI0 SCR01: DAP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR01_RXE_Pos                (14UL)                    /*!< SCI0 SCR01: RXE (Bit 14)                              */
#define SCI0_SCR01_RXE_Msk                (0x4000UL)                /*!< SCI0 SCR01: RXE (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR01_TXE_Pos                (15UL)                    /*!< SCI0 SCR01: TXE (Bit 15)                              */
#define SCI0_SCR01_TXE_Msk                (0x8000UL)                /*!< SCI0 SCR01: TXE (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR02  ========================================================= */
#define SCI0_SCR02_DLS_Pos                (0UL)                     /*!< SCI0 SCR02: DLS (Bit 0)                               */
#define SCI0_SCR02_DLS_Msk                (0x3UL)                   /*!< SCI0 SCR02: DLS (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR02_SLC_Pos                (4UL)                     /*!< SCI0 SCR02: SLC (Bit 4)                               */
#define SCI0_SCR02_SLC_Msk                (0x30UL)                  /*!< SCI0 SCR02: SLC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR02_DIR_Pos                (7UL)                     /*!< SCI0 SCR02: DIR (Bit 7)                               */
#define SCI0_SCR02_DIR_Msk                (0x80UL)                  /*!< SCI0 SCR02: DIR (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR02_PTC_Pos                (8UL)                     /*!< SCI0 SCR02: PTC (Bit 8)                               */
#define SCI0_SCR02_PTC_Msk                (0x300UL)                 /*!< SCI0 SCR02: PTC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR02_EOC_Pos                (10UL)                    /*!< SCI0 SCR02: EOC (Bit 10)                              */
#define SCI0_SCR02_EOC_Msk                (0x400UL)                 /*!< SCI0 SCR02: EOC (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR02_CKP_Pos                (12UL)                    /*!< SCI0 SCR02: CKP (Bit 12)                              */
#define SCI0_SCR02_CKP_Msk                (0x1000UL)                /*!< SCI0 SCR02: CKP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR02_DAP_Pos                (13UL)                    /*!< SCI0 SCR02: DAP (Bit 13)                              */
#define SCI0_SCR02_DAP_Msk                (0x2000UL)                /*!< SCI0 SCR02: DAP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR02_RXE_Pos                (14UL)                    /*!< SCI0 SCR02: RXE (Bit 14)                              */
#define SCI0_SCR02_RXE_Msk                (0x4000UL)                /*!< SCI0 SCR02: RXE (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR02_TXE_Pos                (15UL)                    /*!< SCI0 SCR02: TXE (Bit 15)                              */
#define SCI0_SCR02_TXE_Msk                (0x8000UL)                /*!< SCI0 SCR02: TXE (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR03  ========================================================= */
#define SCI0_SCR03_DLS_Pos                (0UL)                     /*!< SCI0 SCR03: DLS (Bit 0)                               */
#define SCI0_SCR03_DLS_Msk                (0x3UL)                   /*!< SCI0 SCR03: DLS (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR03_SLC_Pos                (4UL)                     /*!< SCI0 SCR03: SLC (Bit 4)                               */
#define SCI0_SCR03_SLC_Msk                (0x30UL)                  /*!< SCI0 SCR03: SLC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR03_DIR_Pos                (7UL)                     /*!< SCI0 SCR03: DIR (Bit 7)                               */
#define SCI0_SCR03_DIR_Msk                (0x80UL)                  /*!< SCI0 SCR03: DIR (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR03_PTC_Pos                (8UL)                     /*!< SCI0 SCR03: PTC (Bit 8)                               */
#define SCI0_SCR03_PTC_Msk                (0x300UL)                 /*!< SCI0 SCR03: PTC (Bitfield-Mask: 0x03)                 */
#define SCI0_SCR03_EOC_Pos                (10UL)                    /*!< SCI0 SCR03: EOC (Bit 10)                              */
#define SCI0_SCR03_EOC_Msk                (0x400UL)                 /*!< SCI0 SCR03: EOC (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR03_CKP_Pos                (12UL)                    /*!< SCI0 SCR03: CKP (Bit 12)                              */
#define SCI0_SCR03_CKP_Msk                (0x1000UL)                /*!< SCI0 SCR03: CKP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR03_DAP_Pos                (13UL)                    /*!< SCI0 SCR03: DAP (Bit 13)                              */
#define SCI0_SCR03_DAP_Msk                (0x2000UL)                /*!< SCI0 SCR03: DAP (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR03_RXE_Pos                (14UL)                    /*!< SCI0 SCR03: RXE (Bit 14)                              */
#define SCI0_SCR03_RXE_Msk                (0x4000UL)                /*!< SCI0 SCR03: RXE (Bitfield-Mask: 0x01)                 */
#define SCI0_SCR03_TXE_Pos                (15UL)                    /*!< SCI0 SCR03: TXE (Bit 15)                              */
#define SCI0_SCR03_TXE_Msk                (0x8000UL)                /*!< SCI0 SCR03: TXE (Bitfield-Mask: 0x01)                 */
/* ==========================================================  SE0  ========================================================== */
#define SCI0_SE0_SE00_Pos                 (0UL)                     /*!< SCI0 SE0: SE00 (Bit 0)                                */
#define SCI0_SE0_SE00_Msk                 (0x1UL)                   /*!< SCI0 SE0: SE00 (Bitfield-Mask: 0x01)                  */
#define SCI0_SE0_SE01_Pos                 (1UL)                     /*!< SCI0 SE0: SE01 (Bit 1)                                */
#define SCI0_SE0_SE01_Msk                 (0x2UL)                   /*!< SCI0 SE0: SE01 (Bitfield-Mask: 0x01)                  */
#define SCI0_SE0_SE02_Pos                 (2UL)                     /*!< SCI0 SE0: SE02 (Bit 2)                                */
#define SCI0_SE0_SE02_Msk                 (0x4UL)                   /*!< SCI0 SE0: SE02 (Bitfield-Mask: 0x01)                  */
#define SCI0_SE0_SE03_Pos                 (3UL)                     /*!< SCI0 SE0: SE03 (Bit 3)                                */
#define SCI0_SE0_SE03_Msk                 (0x8UL)                   /*!< SCI0 SE0: SE03 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  SS0  ========================================================== */
#define SCI0_SS0_SS00_Pos                 (0UL)                     /*!< SCI0 SS0: SS00 (Bit 0)                                */
#define SCI0_SS0_SS00_Msk                 (0x1UL)                   /*!< SCI0 SS0: SS00 (Bitfield-Mask: 0x01)                  */
#define SCI0_SS0_SS01_Pos                 (1UL)                     /*!< SCI0 SS0: SS01 (Bit 1)                                */
#define SCI0_SS0_SS01_Msk                 (0x2UL)                   /*!< SCI0 SS0: SS01 (Bitfield-Mask: 0x01)                  */
#define SCI0_SS0_SS02_Pos                 (2UL)                     /*!< SCI0 SS0: SS02 (Bit 2)                                */
#define SCI0_SS0_SS02_Msk                 (0x4UL)                   /*!< SCI0 SS0: SS02 (Bitfield-Mask: 0x01)                  */
#define SCI0_SS0_SS03_Pos                 (3UL)                     /*!< SCI0 SS0: SS03 (Bit 3)                                */
#define SCI0_SS0_SS03_Msk                 (0x8UL)                   /*!< SCI0 SS0: SS03 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  ST0  ========================================================== */
#define SCI0_ST0_ST00_Pos                 (0UL)                     /*!< SCI0 ST0: ST00 (Bit 0)                                */
#define SCI0_ST0_ST00_Msk                 (0x1UL)                   /*!< SCI0 ST0: ST00 (Bitfield-Mask: 0x01)                  */
#define SCI0_ST0_ST01_Pos                 (1UL)                     /*!< SCI0 ST0: ST01 (Bit 1)                                */
#define SCI0_ST0_ST01_Msk                 (0x2UL)                   /*!< SCI0 ST0: ST01 (Bitfield-Mask: 0x01)                  */
#define SCI0_ST0_ST02_Pos                 (2UL)                     /*!< SCI0 ST0: ST02 (Bit 2)                                */
#define SCI0_ST0_ST02_Msk                 (0x4UL)                   /*!< SCI0 ST0: ST02 (Bitfield-Mask: 0x01)                  */
#define SCI0_ST0_ST03_Pos                 (3UL)                     /*!< SCI0 ST0: ST03 (Bit 3)                                */
#define SCI0_ST0_ST03_Msk                 (0x8UL)                   /*!< SCI0 ST0: ST03 (Bitfield-Mask: 0x01)                  */
/* =========================================================  SPS0  ========================================================== */
#define SCI0_SPS0_PRS00_Pos               (0UL)                     /*!< SCI0 SPS0: PRS00 (Bit 0)                              */
#define SCI0_SPS0_PRS00_Msk               (0xfUL)                   /*!< SCI0 SPS0: PRS00 (Bitfield-Mask: 0x0f)                */
#define SCI0_SPS0_PRS01_Pos               (4UL)                     /*!< SCI0 SPS0: PRS01 (Bit 4)                              */
#define SCI0_SPS0_PRS01_Msk               (0xf0UL)                  /*!< SCI0 SPS0: PRS01 (Bitfield-Mask: 0x0f)                */
/* ==========================================================  SO0  ========================================================== */
#define SCI0_SO0_SO00_Pos                 (0UL)                     /*!< SCI0 SO0: SO00 (Bit 0)                                */
#define SCI0_SO0_SO00_Msk                 (0x1UL)                   /*!< SCI0 SO0: SO00 (Bitfield-Mask: 0x01)                  */
#define SCI0_SO0_SO01_Pos                 (1UL)                     /*!< SCI0 SO0: SO01 (Bit 1)                                */
#define SCI0_SO0_SO01_Msk                 (0x2UL)                   /*!< SCI0 SO0: SO01 (Bitfield-Mask: 0x01)                  */
#define SCI0_SO0_SO02_Pos                 (2UL)                     /*!< SCI0 SO0: SO02 (Bit 2)                                */
#define SCI0_SO0_SO02_Msk                 (0x4UL)                   /*!< SCI0 SO0: SO02 (Bitfield-Mask: 0x01)                  */
#define SCI0_SO0_SO03_Pos                 (3UL)                     /*!< SCI0 SO0: SO03 (Bit 3)                                */
#define SCI0_SO0_SO03_Msk                 (0x8UL)                   /*!< SCI0 SO0: SO03 (Bitfield-Mask: 0x01)                  */
#define SCI0_SO0_CKO00_Pos                (8UL)                     /*!< SCI0 SO0: CKO00 (Bit 8)                               */
#define SCI0_SO0_CKO00_Msk                (0x100UL)                 /*!< SCI0 SO0: CKO00 (Bitfield-Mask: 0x01)                 */
#define SCI0_SO0_CKO01_Pos                (9UL)                     /*!< SCI0 SO0: CKO01 (Bit 9)                               */
#define SCI0_SO0_CKO01_Msk                (0x200UL)                 /*!< SCI0 SO0: CKO01 (Bitfield-Mask: 0x01)                 */
#define SCI0_SO0_CKO02_Pos                (10UL)                    /*!< SCI0 SO0: CKO02 (Bit 10)                              */
#define SCI0_SO0_CKO02_Msk                (0x400UL)                 /*!< SCI0 SO0: CKO02 (Bitfield-Mask: 0x01)                 */
#define SCI0_SO0_CKO03_Pos                (11UL)                    /*!< SCI0 SO0: CKO03 (Bit 11)                              */
#define SCI0_SO0_CKO03_Msk                (0x800UL)                 /*!< SCI0 SO0: CKO03 (Bitfield-Mask: 0x01)                 */
/* =========================================================  SOE0  ========================================================== */
#define SCI0_SOE0_SOE00_Pos               (0UL)                     /*!< SCI0 SOE0: SOE00 (Bit 0)                              */
#define SCI0_SOE0_SOE00_Msk               (0x1UL)                   /*!< SCI0 SOE0: SOE00 (Bitfield-Mask: 0x01)                */
#define SCI0_SOE0_SOE01_Pos               (1UL)                     /*!< SCI0 SOE0: SOE01 (Bit 1)                              */
#define SCI0_SOE0_SOE01_Msk               (0x2UL)                   /*!< SCI0 SOE0: SOE01 (Bitfield-Mask: 0x01)                */
#define SCI0_SOE0_SOE02_Pos               (2UL)                     /*!< SCI0 SOE0: SOE02 (Bit 2)                              */
#define SCI0_SOE0_SOE02_Msk               (0x4UL)                   /*!< SCI0 SOE0: SOE02 (Bitfield-Mask: 0x01)                */
#define SCI0_SOE0_SOE03_Pos               (3UL)                     /*!< SCI0 SOE0: SOE03 (Bit 3)                              */
#define SCI0_SOE0_SOE03_Msk               (0x8UL)                   /*!< SCI0 SOE0: SOE03 (Bitfield-Mask: 0x01)                */
/* =========================================================  SOL0  ========================================================== */
#define SCI0_SOL0_SOL00_Pos               (0UL)                     /*!< SCI0 SOL0: SOL00 (Bit 0)                              */
#define SCI0_SOL0_SOL00_Msk               (0x1UL)                   /*!< SCI0 SOL0: SOL00 (Bitfield-Mask: 0x01)                */
#define SCI0_SOL0_SOL02_Pos               (2UL)                     /*!< SCI0 SOL0: SOL02 (Bit 2)                              */
#define SCI0_SOL0_SOL02_Msk               (0x4UL)                   /*!< SCI0 SOL0: SOL02 (Bitfield-Mask: 0x01)                */
/* =========================================================  SDR0  ========================================================== */
/* =========================================================  SIO00  ========================================================= */
/* =========================================================  SIO01  ========================================================= */
/* =========================================================  SIO10  ========================================================= */
/* =========================================================  SIO11  ========================================================= */
/* =========================================================  TXD0  ========================================================== */
/* =========================================================  RXD0  ========================================================== */
/* =========================================================  TXD1  ========================================================== */
/* =========================================================  RXD1  ========================================================== */


/* =========================================================================================================================== */
/* ================                                           SCI1                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  SSR10  ========================================================= */
#define SCI1_SSR10_OVF_Pos                (0UL)                     /*!< SCI1 SSR10: OVF (Bit 0)                               */
#define SCI1_SSR10_OVF_Msk                (0x1UL)                   /*!< SCI1 SSR10: OVF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR10_PEF_Pos                (1UL)                     /*!< SCI1 SSR10: PEF (Bit 1)                               */
#define SCI1_SSR10_PEF_Msk                (0x2UL)                   /*!< SCI1 SSR10: PEF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR10_FEF_Pos                (2UL)                     /*!< SCI1 SSR10: FEF (Bit 2)                               */
#define SCI1_SSR10_FEF_Msk                (0x4UL)                   /*!< SCI1 SSR10: FEF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR10_BFF_Pos                (5UL)                     /*!< SCI1 SSR10: BFF (Bit 5)                               */
#define SCI1_SSR10_BFF_Msk                (0x20UL)                  /*!< SCI1 SSR10: BFF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR10_TSF_Pos                (6UL)                     /*!< SCI1 SSR10: TSF (Bit 6)                               */
#define SCI1_SSR10_TSF_Msk                (0x40UL)                  /*!< SCI1 SSR10: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SSR11  ========================================================= */
#define SCI1_SSR11_OVF_Pos                (0UL)                     /*!< SCI1 SSR11: OVF (Bit 0)                               */
#define SCI1_SSR11_OVF_Msk                (0x1UL)                   /*!< SCI1 SSR11: OVF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR11_PEF_Pos                (1UL)                     /*!< SCI1 SSR11: PEF (Bit 1)                               */
#define SCI1_SSR11_PEF_Msk                (0x2UL)                   /*!< SCI1 SSR11: PEF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR11_FEF_Pos                (2UL)                     /*!< SCI1 SSR11: FEF (Bit 2)                               */
#define SCI1_SSR11_FEF_Msk                (0x4UL)                   /*!< SCI1 SSR11: FEF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR11_BFF_Pos                (5UL)                     /*!< SCI1 SSR11: BFF (Bit 5)                               */
#define SCI1_SSR11_BFF_Msk                (0x20UL)                  /*!< SCI1 SSR11: BFF (Bitfield-Mask: 0x01)                 */
#define SCI1_SSR11_TSF_Pos                (6UL)                     /*!< SCI1 SSR11: TSF (Bit 6)                               */
#define SCI1_SSR11_TSF_Msk                (0x40UL)                  /*!< SCI1 SSR11: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SIR10  ========================================================= */
#define SCI1_SIR10_OVCT_Pos               (0UL)                     /*!< SCI1 SIR10: OVCT (Bit 0)                              */
#define SCI1_SIR10_OVCT_Msk               (0x1UL)                   /*!< SCI1 SIR10: OVCT (Bitfield-Mask: 0x01)                */
#define SCI1_SIR10_PECT_Pos               (1UL)                     /*!< SCI1 SIR10: PECT (Bit 1)                              */
#define SCI1_SIR10_PECT_Msk               (0x2UL)                   /*!< SCI1 SIR10: PECT (Bitfield-Mask: 0x01)                */
#define SCI1_SIR10_FECT_Pos               (2UL)                     /*!< SCI1 SIR10: FECT (Bit 2)                              */
#define SCI1_SIR10_FECT_Msk               (0x4UL)                   /*!< SCI1 SIR10: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SIR11  ========================================================= */
#define SCI1_SIR11_OVCT_Pos               (0UL)                     /*!< SCI1 SIR11: OVCT (Bit 0)                              */
#define SCI1_SIR11_OVCT_Msk               (0x1UL)                   /*!< SCI1 SIR11: OVCT (Bitfield-Mask: 0x01)                */
#define SCI1_SIR11_PECT_Pos               (1UL)                     /*!< SCI1 SIR11: PECT (Bit 1)                              */
#define SCI1_SIR11_PECT_Msk               (0x2UL)                   /*!< SCI1 SIR11: PECT (Bitfield-Mask: 0x01)                */
#define SCI1_SIR11_FECT_Pos               (2UL)                     /*!< SCI1 SIR11: FECT (Bit 2)                              */
#define SCI1_SIR11_FECT_Msk               (0x4UL)                   /*!< SCI1 SIR11: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SMR10  ========================================================= */
#define SCI1_SMR10_MD_Pos                 (0UL)                     /*!< SCI1 SMR10: MD (Bit 0)                                */
#define SCI1_SMR10_MD_Msk                 (0x7UL)                   /*!< SCI1 SMR10: MD (Bitfield-Mask: 0x07)                  */
#define SCI1_SMR10_SIS_Pos                (6UL)                     /*!< SCI1 SMR10: SIS (Bit 6)                               */
#define SCI1_SMR10_SIS_Msk                (0x40UL)                  /*!< SCI1 SMR10: SIS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR10_STS_Pos                (8UL)                     /*!< SCI1 SMR10: STS (Bit 8)                               */
#define SCI1_SMR10_STS_Msk                (0x100UL)                 /*!< SCI1 SMR10: STS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR10_CCS_Pos                (14UL)                    /*!< SCI1 SMR10: CCS (Bit 14)                              */
#define SCI1_SMR10_CCS_Msk                (0x4000UL)                /*!< SCI1 SMR10: CCS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR10_CKS_Pos                (15UL)                    /*!< SCI1 SMR10: CKS (Bit 15)                              */
#define SCI1_SMR10_CKS_Msk                (0x8000UL)                /*!< SCI1 SMR10: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SMR11  ========================================================= */
#define SCI1_SMR11_MD_Pos                 (0UL)                     /*!< SCI1 SMR11: MD (Bit 0)                                */
#define SCI1_SMR11_MD_Msk                 (0x7UL)                   /*!< SCI1 SMR11: MD (Bitfield-Mask: 0x07)                  */
#define SCI1_SMR11_SIS_Pos                (6UL)                     /*!< SCI1 SMR11: SIS (Bit 6)                               */
#define SCI1_SMR11_SIS_Msk                (0x40UL)                  /*!< SCI1 SMR11: SIS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR11_STS_Pos                (8UL)                     /*!< SCI1 SMR11: STS (Bit 8)                               */
#define SCI1_SMR11_STS_Msk                (0x100UL)                 /*!< SCI1 SMR11: STS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR11_CCS_Pos                (14UL)                    /*!< SCI1 SMR11: CCS (Bit 14)                              */
#define SCI1_SMR11_CCS_Msk                (0x4000UL)                /*!< SCI1 SMR11: CCS (Bitfield-Mask: 0x01)                 */
#define SCI1_SMR11_CKS_Pos                (15UL)                    /*!< SCI1 SMR11: CKS (Bit 15)                              */
#define SCI1_SMR11_CKS_Msk                (0x8000UL)                /*!< SCI1 SMR11: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR10  ========================================================= */
#define SCI1_SCR10_DLS_Pos                (0UL)                     /*!< SCI1 SCR10: DLS (Bit 0)                               */
#define SCI1_SCR10_DLS_Msk                (0xfUL)                   /*!< SCI1 SCR10: DLS (Bitfield-Mask: 0x0f)                 */
#define SCI1_SCR10_SLC_Pos                (4UL)                     /*!< SCI1 SCR10: SLC (Bit 4)                               */
#define SCI1_SCR10_SLC_Msk                (0x30UL)                  /*!< SCI1 SCR10: SLC (Bitfield-Mask: 0x03)                 */
#define SCI1_SCR10_DIR_Pos                (7UL)                     /*!< SCI1 SCR10: DIR (Bit 7)                               */
#define SCI1_SCR10_DIR_Msk                (0x80UL)                  /*!< SCI1 SCR10: DIR (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR10_PTC_Pos                (8UL)                     /*!< SCI1 SCR10: PTC (Bit 8)                               */
#define SCI1_SCR10_PTC_Msk                (0x300UL)                 /*!< SCI1 SCR10: PTC (Bitfield-Mask: 0x03)                 */
#define SCI1_SCR10_EOC_Pos                (10UL)                    /*!< SCI1 SCR10: EOC (Bit 10)                              */
#define SCI1_SCR10_EOC_Msk                (0x400UL)                 /*!< SCI1 SCR10: EOC (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR10_CKP_Pos                (12UL)                    /*!< SCI1 SCR10: CKP (Bit 12)                              */
#define SCI1_SCR10_CKP_Msk                (0x1000UL)                /*!< SCI1 SCR10: CKP (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR10_DAP_Pos                (13UL)                    /*!< SCI1 SCR10: DAP (Bit 13)                              */
#define SCI1_SCR10_DAP_Msk                (0x2000UL)                /*!< SCI1 SCR10: DAP (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR10_RXE_Pos                (14UL)                    /*!< SCI1 SCR10: RXE (Bit 14)                              */
#define SCI1_SCR10_RXE_Msk                (0x4000UL)                /*!< SCI1 SCR10: RXE (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR10_TXE_Pos                (15UL)                    /*!< SCI1 SCR10: TXE (Bit 15)                              */
#define SCI1_SCR10_TXE_Msk                (0x8000UL)                /*!< SCI1 SCR10: TXE (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR11  ========================================================= */
#define SCI1_SCR11_DLS_Pos                (0UL)                     /*!< SCI1 SCR11: DLS (Bit 0)                               */
#define SCI1_SCR11_DLS_Msk                (0xfUL)                   /*!< SCI1 SCR11: DLS (Bitfield-Mask: 0x0f)                 */
#define SCI1_SCR11_SLC_Pos                (4UL)                     /*!< SCI1 SCR11: SLC (Bit 4)                               */
#define SCI1_SCR11_SLC_Msk                (0x30UL)                  /*!< SCI1 SCR11: SLC (Bitfield-Mask: 0x03)                 */
#define SCI1_SCR11_DIR_Pos                (7UL)                     /*!< SCI1 SCR11: DIR (Bit 7)                               */
#define SCI1_SCR11_DIR_Msk                (0x80UL)                  /*!< SCI1 SCR11: DIR (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR11_PTC_Pos                (8UL)                     /*!< SCI1 SCR11: PTC (Bit 8)                               */
#define SCI1_SCR11_PTC_Msk                (0x300UL)                 /*!< SCI1 SCR11: PTC (Bitfield-Mask: 0x03)                 */
#define SCI1_SCR11_EOC_Pos                (10UL)                    /*!< SCI1 SCR11: EOC (Bit 10)                              */
#define SCI1_SCR11_EOC_Msk                (0x400UL)                 /*!< SCI1 SCR11: EOC (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR11_CKP_Pos                (12UL)                    /*!< SCI1 SCR11: CKP (Bit 12)                              */
#define SCI1_SCR11_CKP_Msk                (0x1000UL)                /*!< SCI1 SCR11: CKP (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR11_DAP_Pos                (13UL)                    /*!< SCI1 SCR11: DAP (Bit 13)                              */
#define SCI1_SCR11_DAP_Msk                (0x2000UL)                /*!< SCI1 SCR11: DAP (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR11_RXE_Pos                (14UL)                    /*!< SCI1 SCR11: RXE (Bit 14)                              */
#define SCI1_SCR11_RXE_Msk                (0x4000UL)                /*!< SCI1 SCR11: RXE (Bitfield-Mask: 0x01)                 */
#define SCI1_SCR11_TXE_Pos                (15UL)                    /*!< SCI1 SCR11: TXE (Bit 15)                              */
#define SCI1_SCR11_TXE_Msk                (0x8000UL)                /*!< SCI1 SCR11: TXE (Bitfield-Mask: 0x01)                 */
/* ==========================================================  SE1  ========================================================== */
#define SCI1_SE1_SE10_Pos                 (0UL)                     /*!< SCI1 SE1: SE10 (Bit 0)                                */
#define SCI1_SE1_SE10_Msk                 (0x1UL)                   /*!< SCI1 SE1: SE10 (Bitfield-Mask: 0x01)                  */
#define SCI1_SE1_SE11_Pos                 (1UL)                     /*!< SCI1 SE1: SE11 (Bit 1)                                */
#define SCI1_SE1_SE11_Msk                 (0x2UL)                   /*!< SCI1 SE1: SE11 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  SS1  ========================================================== */
#define SCI1_SS1_SS10_Pos                 (0UL)                     /*!< SCI1 SS1: SS10 (Bit 0)                                */
#define SCI1_SS1_SS10_Msk                 (0x1UL)                   /*!< SCI1 SS1: SS10 (Bitfield-Mask: 0x01)                  */
#define SCI1_SS1_SS11_Pos                 (1UL)                     /*!< SCI1 SS1: SS11 (Bit 1)                                */
#define SCI1_SS1_SS11_Msk                 (0x2UL)                   /*!< SCI1 SS1: SS11 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  ST1  ========================================================== */
#define SCI1_ST1_ST10_Pos                 (0UL)                     /*!< SCI1 ST1: ST10 (Bit 0)                                */
#define SCI1_ST1_ST10_Msk                 (0x1UL)                   /*!< SCI1 ST1: ST10 (Bitfield-Mask: 0x01)                  */
#define SCI1_ST1_ST11_Pos                 (1UL)                     /*!< SCI1 ST1: ST11 (Bit 1)                                */
#define SCI1_ST1_ST11_Msk                 (0x2UL)                   /*!< SCI1 ST1: ST11 (Bitfield-Mask: 0x01)                  */
/* =========================================================  SPS1  ========================================================== */
#define SCI1_SPS1_PRS10_Pos               (0UL)                     /*!< SCI1 SPS1: PRS10 (Bit 0)                              */
#define SCI1_SPS1_PRS10_Msk               (0xfUL)                   /*!< SCI1 SPS1: PRS10 (Bitfield-Mask: 0x0f)                */
#define SCI1_SPS1_PRS11_Pos               (4UL)                     /*!< SCI1 SPS1: PRS11 (Bit 4)                              */
#define SCI1_SPS1_PRS11_Msk               (0xf0UL)                  /*!< SCI1 SPS1: PRS11 (Bitfield-Mask: 0x0f)                */
/* ==========================================================  SO1  ========================================================== */
#define SCI1_SO1_SO10_Pos                 (0UL)                     /*!< SCI1 SO1: SO10 (Bit 0)                                */
#define SCI1_SO1_SO10_Msk                 (0x1UL)                   /*!< SCI1 SO1: SO10 (Bitfield-Mask: 0x01)                  */
#define SCI1_SO1_SO11_Pos                 (1UL)                     /*!< SCI1 SO1: SO11 (Bit 1)                                */
#define SCI1_SO1_SO11_Msk                 (0x2UL)                   /*!< SCI1 SO1: SO11 (Bitfield-Mask: 0x01)                  */
#define SCI1_SO1_CKO10_Pos                (8UL)                     /*!< SCI1 SO1: CKO10 (Bit 8)                               */
#define SCI1_SO1_CKO10_Msk                (0x100UL)                 /*!< SCI1 SO1: CKO10 (Bitfield-Mask: 0x01)                 */
#define SCI1_SO1_CKO11_Pos                (9UL)                     /*!< SCI1 SO1: CKO11 (Bit 9)                               */
#define SCI1_SO1_CKO11_Msk                (0x200UL)                 /*!< SCI1 SO1: CKO11 (Bitfield-Mask: 0x01)                 */
/* =========================================================  SOE1  ========================================================== */
#define SCI1_SOE1_SOE10_Pos               (0UL)                     /*!< SCI1 SOE1: SOE10 (Bit 0)                              */
#define SCI1_SOE1_SOE10_Msk               (0x1UL)                   /*!< SCI1 SOE1: SOE10 (Bitfield-Mask: 0x01)                */
#define SCI1_SOE1_SOE11_Pos               (1UL)                     /*!< SCI1 SOE1: SOE11 (Bit 1)                              */
#define SCI1_SOE1_SOE11_Msk               (0x2UL)                   /*!< SCI1 SOE1: SOE11 (Bitfield-Mask: 0x01)                */
/* =========================================================  SOL1  ========================================================== */
#define SCI1_SOL1_SOL10_Pos               (0UL)                     /*!< SCI1 SOL1: SOL10 (Bit 0)                              */
#define SCI1_SOL1_SOL10_Msk               (0x1UL)                   /*!< SCI1 SOL1: SOL10 (Bitfield-Mask: 0x01)                */
/* =========================================================  SDR1  ========================================================== */
/* =========================================================  SIO20  ========================================================= */
/* =========================================================  SIO21  ========================================================= */
/* =========================================================  TXD2  ========================================================== */
/* =========================================================  RXD2  ========================================================== */


/* =========================================================================================================================== */
/* ================                                           SCI2                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  SSR20  ========================================================= */
#define SCI2_SSR20_OVF_Pos                (0UL)                     /*!< SCI2 SSR20: OVF (Bit 0)                               */
#define SCI2_SSR20_OVF_Msk                (0x1UL)                   /*!< SCI2 SSR20: OVF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR20_PEF_Pos                (1UL)                     /*!< SCI2 SSR20: PEF (Bit 1)                               */
#define SCI2_SSR20_PEF_Msk                (0x2UL)                   /*!< SCI2 SSR20: PEF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR20_FEF_Pos                (2UL)                     /*!< SCI2 SSR20: FEF (Bit 2)                               */
#define SCI2_SSR20_FEF_Msk                (0x4UL)                   /*!< SCI2 SSR20: FEF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR20_BFF_Pos                (5UL)                     /*!< SCI2 SSR20: BFF (Bit 5)                               */
#define SCI2_SSR20_BFF_Msk                (0x20UL)                  /*!< SCI2 SSR20: BFF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR20_TSF_Pos                (6UL)                     /*!< SCI2 SSR20: TSF (Bit 6)                               */
#define SCI2_SSR20_TSF_Msk                (0x40UL)                  /*!< SCI2 SSR20: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SSR21  ========================================================= */
#define SCI2_SSR21_OVF_Pos                (0UL)                     /*!< SCI2 SSR21: OVF (Bit 0)                               */
#define SCI2_SSR21_OVF_Msk                (0x1UL)                   /*!< SCI2 SSR21: OVF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR21_PEF_Pos                (1UL)                     /*!< SCI2 SSR21: PEF (Bit 1)                               */
#define SCI2_SSR21_PEF_Msk                (0x2UL)                   /*!< SCI2 SSR21: PEF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR21_FEF_Pos                (2UL)                     /*!< SCI2 SSR21: FEF (Bit 2)                               */
#define SCI2_SSR21_FEF_Msk                (0x4UL)                   /*!< SCI2 SSR21: FEF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR21_BFF_Pos                (5UL)                     /*!< SCI2 SSR21: BFF (Bit 5)                               */
#define SCI2_SSR21_BFF_Msk                (0x20UL)                  /*!< SCI2 SSR21: BFF (Bitfield-Mask: 0x01)                 */
#define SCI2_SSR21_TSF_Pos                (6UL)                     /*!< SCI2 SSR21: TSF (Bit 6)                               */
#define SCI2_SSR21_TSF_Msk                (0x40UL)                  /*!< SCI2 SSR21: TSF (Bitfield-Mask: 0x01)                 */
/* =========================================================  SIR20  ========================================================= */
#define SCI2_SIR20_OVCT_Pos               (0UL)                     /*!< SCI2 SIR20: OVCT (Bit 0)                              */
#define SCI2_SIR20_OVCT_Msk               (0x1UL)                   /*!< SCI2 SIR20: OVCT (Bitfield-Mask: 0x01)                */
#define SCI2_SIR20_PECT_Pos               (1UL)                     /*!< SCI2 SIR20: PECT (Bit 1)                              */
#define SCI2_SIR20_PECT_Msk               (0x2UL)                   /*!< SCI2 SIR20: PECT (Bitfield-Mask: 0x01)                */
#define SCI2_SIR20_FECT_Pos               (2UL)                     /*!< SCI2 SIR20: FECT (Bit 2)                              */
#define SCI2_SIR20_FECT_Msk               (0x4UL)                   /*!< SCI2 SIR20: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SIR21  ========================================================= */
#define SCI2_SIR21_OVCT_Pos               (0UL)                     /*!< SCI2 SIR21: OVCT (Bit 0)                              */
#define SCI2_SIR21_OVCT_Msk               (0x1UL)                   /*!< SCI2 SIR21: OVCT (Bitfield-Mask: 0x01)                */
#define SCI2_SIR21_PECT_Pos               (1UL)                     /*!< SCI2 SIR21: PECT (Bit 1)                              */
#define SCI2_SIR21_PECT_Msk               (0x2UL)                   /*!< SCI2 SIR21: PECT (Bitfield-Mask: 0x01)                */
#define SCI2_SIR21_FECT_Pos               (2UL)                     /*!< SCI2 SIR21: FECT (Bit 2)                              */
#define SCI2_SIR21_FECT_Msk               (0x4UL)                   /*!< SCI2 SIR21: FECT (Bitfield-Mask: 0x01)                */
/* =========================================================  SMR20  ========================================================= */
#define SCI2_SMR20_MD_Pos                 (0UL)                     /*!< SCI2 SMR20: MD (Bit 0)                                */
#define SCI2_SMR20_MD_Msk                 (0x7UL)                   /*!< SCI2 SMR20: MD (Bitfield-Mask: 0x07)                  */
#define SCI2_SMR20_SIS_Pos                (6UL)                     /*!< SCI2 SMR20: SIS (Bit 6)                               */
#define SCI2_SMR20_SIS_Msk                (0x40UL)                  /*!< SCI2 SMR20: SIS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR20_STS_Pos                (8UL)                     /*!< SCI2 SMR20: STS (Bit 8)                               */
#define SCI2_SMR20_STS_Msk                (0x100UL)                 /*!< SCI2 SMR20: STS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR20_CCS_Pos                (14UL)                    /*!< SCI2 SMR20: CCS (Bit 14)                              */
#define SCI2_SMR20_CCS_Msk                (0x4000UL)                /*!< SCI2 SMR20: CCS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR20_CKS_Pos                (15UL)                    /*!< SCI2 SMR20: CKS (Bit 15)                              */
#define SCI2_SMR20_CKS_Msk                (0x8000UL)                /*!< SCI2 SMR20: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SMR21  ========================================================= */
#define SCI2_SMR21_MD_Pos                 (0UL)                     /*!< SCI2 SMR21: MD (Bit 0)                                */
#define SCI2_SMR21_MD_Msk                 (0x7UL)                   /*!< SCI2 SMR21: MD (Bitfield-Mask: 0x07)                  */
#define SCI2_SMR21_SIS_Pos                (6UL)                     /*!< SCI2 SMR21: SIS (Bit 6)                               */
#define SCI2_SMR21_SIS_Msk                (0x40UL)                  /*!< SCI2 SMR21: SIS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR21_STS_Pos                (8UL)                     /*!< SCI2 SMR21: STS (Bit 8)                               */
#define SCI2_SMR21_STS_Msk                (0x100UL)                 /*!< SCI2 SMR21: STS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR21_CCS_Pos                (14UL)                    /*!< SCI2 SMR21: CCS (Bit 14)                              */
#define SCI2_SMR21_CCS_Msk                (0x4000UL)                /*!< SCI2 SMR21: CCS (Bitfield-Mask: 0x01)                 */
#define SCI2_SMR21_CKS_Pos                (15UL)                    /*!< SCI2 SMR21: CKS (Bit 15)                              */
#define SCI2_SMR21_CKS_Msk                (0x8000UL)                /*!< SCI2 SMR21: CKS (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR20  ========================================================= */
#define SCI2_SCR20_DLS_Pos                (0UL)                     /*!< SCI2 SCR20: DLS (Bit 0)                               */
#define SCI2_SCR20_DLS_Msk                (0x3UL)                   /*!< SCI2 SCR20: DLS (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR20_SLC_Pos                (4UL)                     /*!< SCI2 SCR20: SLC (Bit 4)                               */
#define SCI2_SCR20_SLC_Msk                (0x30UL)                  /*!< SCI2 SCR20: SLC (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR20_DIR_Pos                (7UL)                     /*!< SCI2 SCR20: DIR (Bit 7)                               */
#define SCI2_SCR20_DIR_Msk                (0x80UL)                  /*!< SCI2 SCR20: DIR (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR20_PTC_Pos                (8UL)                     /*!< SCI2 SCR20: PTC (Bit 8)                               */
#define SCI2_SCR20_PTC_Msk                (0x300UL)                 /*!< SCI2 SCR20: PTC (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR20_EOC_Pos                (10UL)                    /*!< SCI2 SCR20: EOC (Bit 10)                              */
#define SCI2_SCR20_EOC_Msk                (0x400UL)                 /*!< SCI2 SCR20: EOC (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR20_CKP_Pos                (12UL)                    /*!< SCI2 SCR20: CKP (Bit 12)                              */
#define SCI2_SCR20_CKP_Msk                (0x1000UL)                /*!< SCI2 SCR20: CKP (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR20_DAP_Pos                (13UL)                    /*!< SCI2 SCR20: DAP (Bit 13)                              */
#define SCI2_SCR20_DAP_Msk                (0x2000UL)                /*!< SCI2 SCR20: DAP (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR20_RXE_Pos                (14UL)                    /*!< SCI2 SCR20: RXE (Bit 14)                              */
#define SCI2_SCR20_RXE_Msk                (0x4000UL)                /*!< SCI2 SCR20: RXE (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR20_TXE_Pos                (15UL)                    /*!< SCI2 SCR20: TXE (Bit 15)                              */
#define SCI2_SCR20_TXE_Msk                (0x8000UL)                /*!< SCI2 SCR20: TXE (Bitfield-Mask: 0x01)                 */
/* =========================================================  SCR21  ========================================================= */
#define SCI2_SCR21_DLS_Pos                (0UL)                     /*!< SCI2 SCR21: DLS (Bit 0)                               */
#define SCI2_SCR21_DLS_Msk                (0x3UL)                   /*!< SCI2 SCR21: DLS (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR21_SLC_Pos                (4UL)                     /*!< SCI2 SCR21: SLC (Bit 4)                               */
#define SCI2_SCR21_SLC_Msk                (0x30UL)                  /*!< SCI2 SCR21: SLC (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR21_DIR_Pos                (7UL)                     /*!< SCI2 SCR21: DIR (Bit 7)                               */
#define SCI2_SCR21_DIR_Msk                (0x80UL)                  /*!< SCI2 SCR21: DIR (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR21_PTC_Pos                (8UL)                     /*!< SCI2 SCR21: PTC (Bit 8)                               */
#define SCI2_SCR21_PTC_Msk                (0x300UL)                 /*!< SCI2 SCR21: PTC (Bitfield-Mask: 0x03)                 */
#define SCI2_SCR21_EOC_Pos                (10UL)                    /*!< SCI2 SCR21: EOC (Bit 10)                              */
#define SCI2_SCR21_EOC_Msk                (0x400UL)                 /*!< SCI2 SCR21: EOC (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR21_CKP_Pos                (12UL)                    /*!< SCI2 SCR21: CKP (Bit 12)                              */
#define SCI2_SCR21_CKP_Msk                (0x1000UL)                /*!< SCI2 SCR21: CKP (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR21_DAP_Pos                (13UL)                    /*!< SCI2 SCR21: DAP (Bit 13)                              */
#define SCI2_SCR21_DAP_Msk                (0x2000UL)                /*!< SCI2 SCR21: DAP (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR21_RXE_Pos                (14UL)                    /*!< SCI2 SCR21: RXE (Bit 14)                              */
#define SCI2_SCR21_RXE_Msk                (0x4000UL)                /*!< SCI2 SCR21: RXE (Bitfield-Mask: 0x01)                 */
#define SCI2_SCR21_TXE_Pos                (15UL)                    /*!< SCI2 SCR21: TXE (Bit 15)                              */
#define SCI2_SCR21_TXE_Msk                (0x8000UL)                /*!< SCI2 SCR21: TXE (Bitfield-Mask: 0x01)                 */
/* ==========================================================  SE2  ========================================================== */
#define SCI2_SE2_SE20_Pos                 (0UL)                     /*!< SCI2 SE2: SE20 (Bit 0)                                */
#define SCI2_SE2_SE20_Msk                 (0x1UL)                   /*!< SCI2 SE2: SE20 (Bitfield-Mask: 0x01)                  */
#define SCI2_SE2_SE21_Pos                 (1UL)                     /*!< SCI2 SE2: SE21 (Bit 1)                                */
#define SCI2_SE2_SE21_Msk                 (0x2UL)                   /*!< SCI2 SE2: SE21 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  SS2  ========================================================== */
#define SCI2_SS2_SS20_Pos                 (0UL)                     /*!< SCI2 SS2: SS20 (Bit 0)                                */
#define SCI2_SS2_SS20_Msk                 (0x1UL)                   /*!< SCI2 SS2: SS20 (Bitfield-Mask: 0x01)                  */
#define SCI2_SS2_SS21_Pos                 (1UL)                     /*!< SCI2 SS2: SS21 (Bit 1)                                */
#define SCI2_SS2_SS21_Msk                 (0x2UL)                   /*!< SCI2 SS2: SS21 (Bitfield-Mask: 0x01)                  */
/* ==========================================================  ST2  ========================================================== */
#define SCI2_ST2_ST20_Pos                 (0UL)                     /*!< SCI2 ST2: ST20 (Bit 0)                                */
#define SCI2_ST2_ST20_Msk                 (0x1UL)                   /*!< SCI2 ST2: ST20 (Bitfield-Mask: 0x01)                  */
#define SCI2_ST2_ST21_Pos                 (1UL)                     /*!< SCI2 ST2: ST21 (Bit 1)                                */
#define SCI2_ST2_ST21_Msk                 (0x2UL)                   /*!< SCI2 ST2: ST21 (Bitfield-Mask: 0x01)                  */
/* =========================================================  SPS2  ========================================================== */
#define SCI2_SPS2_PRS20_Pos               (0UL)                     /*!< SCI2 SPS2: PRS20 (Bit 0)                              */
#define SCI2_SPS2_PRS20_Msk               (0xfUL)                   /*!< SCI2 SPS2: PRS20 (Bitfield-Mask: 0x0f)                */
#define SCI2_SPS2_PRS21_Pos               (4UL)                     /*!< SCI2 SPS2: PRS21 (Bit 4)                              */
#define SCI2_SPS2_PRS21_Msk               (0xf0UL)                  /*!< SCI2 SPS2: PRS21 (Bitfield-Mask: 0x0f)                */
/* ==========================================================  SO2  ========================================================== */
#define SCI2_SO2_SO20_Pos                 (0UL)                     /*!< SCI2 SO2: SO20 (Bit 0)                                */
#define SCI2_SO2_SO20_Msk                 (0x1UL)                   /*!< SCI2 SO2: SO20 (Bitfield-Mask: 0x01)                  */
#define SCI2_SO2_SO21_Pos                 (1UL)                     /*!< SCI2 SO2: SO21 (Bit 1)                                */
#define SCI2_SO2_SO21_Msk                 (0x2UL)                   /*!< SCI2 SO2: SO21 (Bitfield-Mask: 0x01)                  */
#define SCI2_SO2_CKO20_Pos                (8UL)                     /*!< SCI2 SO2: CKO20 (Bit 8)                               */
#define SCI2_SO2_CKO20_Msk                (0x100UL)                 /*!< SCI2 SO2: CKO20 (Bitfield-Mask: 0x01)                 */
#define SCI2_SO2_CKO21_Pos                (9UL)                     /*!< SCI2 SO2: CKO21 (Bit 9)                               */
#define SCI2_SO2_CKO21_Msk                (0x200UL)                 /*!< SCI2 SO2: CKO21 (Bitfield-Mask: 0x01)                 */
/* =========================================================  SOE2  ========================================================== */
#define SCI2_SOE2_SOE20_Pos               (0UL)                     /*!< SCI2 SOE2: SOE20 (Bit 0)                              */
#define SCI2_SOE2_SOE20_Msk               (0x1UL)                   /*!< SCI2 SOE2: SOE20 (Bitfield-Mask: 0x01)                */
#define SCI2_SOE2_SOE21_Pos               (1UL)                     /*!< SCI2 SOE2: SOE21 (Bit 1)                              */
#define SCI2_SOE2_SOE21_Msk               (0x2UL)                   /*!< SCI2 SOE2: SOE21 (Bitfield-Mask: 0x01)                */
/* =========================================================  SOL2  ========================================================== */
#define SCI2_SOL2_SOL20_Pos               (0UL)                     /*!< SCI2 SOL2: SOL20 (Bit 0)                              */
#define SCI2_SOL2_SOL20_Msk               (0x1UL)                   /*!< SCI2 SOL2: SOL20 (Bitfield-Mask: 0x01)                */
/* =========================================================  SDR2  ========================================================== */
/* =========================================================  SIO30  ========================================================= */
/* =========================================================  SIO31  ========================================================= */
/* =========================================================  TXD3  ========================================================== */
/* =========================================================  RXD3  ========================================================== */


/* =========================================================================================================================== */
/* ================                                          SPIHS0/SPIHS1                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  SPIM  ========================================================= */
#define SPI_SPIM_RECMD_Pos            (1UL)                     /*!< SPIHS0 SPIM0: RECMD (Bit 1)                           */
#define SPI_SPIM_RECMD_Msk            (0x2UL)                   /*!< SPIHS0 SPIM0: RECMD (Bitfield-Mask: 0x01)             */
#define SPI_SPIM_DLS_Pos                  (2UL)                     /*!< SPI SPIM: DLS (Bit 2)                                 */
#define SPI_SPIM_DLS_Msk                  (0x4UL)                   /*!< SPI SPIM: DLS (Bitfield-Mask: 0x01)                   */
#define SPI_SPIM_INTMD_Pos                (3UL)                     /*!< SPI SPIM: INTMD (Bit 3)                               */
#define SPI_SPIM_INTMD_Msk                (0x8UL)                   /*!< SPI SPIM: INTMD (Bitfield-Mask: 0x01)                 */
#define SPI_SPIM_DIR_Pos                  (4UL)                     /*!< SPI SPIM: DIR (Bit 4)                                 */
#define SPI_SPIM_DIR_Msk                  (0x10UL)                  /*!< SPI SPIM: DIR (Bitfield-Mask: 0x01)                   */
#define SPI_SPIM_NSSE_Pos                 (5UL)                     /*!< SPI SPIM: NSSE (Bit 5)                                */
#define SPI_SPIM_NSSE_Msk                 (0x20UL)                  /*!< SPI SPIM: NSSE (Bitfield-Mask: 0x01)                  */
#define SPI_SPIM_TRMD_Pos                 (6UL)                     /*!< SPI SPIM: TRMD (Bit 6)                                */
#define SPI_SPIM_TRMD_Msk                 (0x40UL)                  /*!< SPI SPIM: TRMD (Bitfield-Mask: 0x01)                  */
#define SPI_SPIM_SPIE_Pos                 (7UL)                     /*!< SPI SPIM: SPIE (Bit 7)                                */
#define SPI_SPIM_SPIE_Msk                 (0x80UL)                  /*!< SPI SPIM: SPIE (Bitfield-Mask: 0x01)                  */
/* =========================================================  SPIC  ========================================================= */
#define SPI_SPIC_CKS_Pos                  (0UL)                     /*!< SPI SPIC: CKS (Bit 0)                                 */
#define SPI_SPIC_CKS_Msk                  (0x7UL)                   /*!< SPI SPIC: CKS (Bitfield-Mask: 0x07)                   */
#define SPI_SPIC_DAP_Pos                  (3UL)                     /*!< SPI SPIC: DAP (Bit 3)                                 */
#define SPI_SPIC_DAP_Msk                  (0x8UL)                   /*!< SPI SPIC: DAP (Bitfield-Mask: 0x01)                   */
#define SPI_SPIC_CKP_Pos                  (4UL)                     /*!< SPI SPIC: CKP (Bit 4)                                 */
#define SPI_SPIC_CKP_Msk                  (0x10UL)                  /*!< SPI SPIC: CKP (Bitfield-Mask: 0x01)                   */
/* =========================================================  SDRO  ========================================================= */
/* =========================================================  SDRI  ========================================================= */
/* =========================================================  SPIS  ========================================================= */
#define SPI_SPIM_SPTF_Pos                 (0UL)                     /*!< SPI SPIM: SPTF (Bit 0)                                */
#define SPI_SPIM_SPTF_Msk                 (0x1UL)                   /*!< SPI SPIM: SPTF (Bitfield-Mask: 0x01)                  */
#define SPI_SPIM_SDRIF_Msk                (0x2UL)                   /*!< SPI SPIM: SDRIF (Bitfield-Mask: 0x01)                 */
#define SPI_SPIM_DLS_Pos                  (2UL)                     /*!< SPI SPIM: DLS (Bit 2)                                 */




/* =========================================================================================================================== */
/* ================                                           IICA0                                           ================ */
/* =========================================================================================================================== */

/* =======================================================  IICCTL00  ======================================================== */
#define IICA0_IICCTL00_SPT_Pos            (0UL)                     /*!< IICA0 IICCTL00: SPT (Bit 0)                           */
#define IICA0_IICCTL00_SPT_Msk            (0x1UL)                   /*!< IICA0 IICCTL00: SPT (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL00_STT_Pos            (1UL)                     /*!< IICA0 IICCTL00: STT (Bit 1)                           */
#define IICA0_IICCTL00_STT_Msk            (0x2UL)                   /*!< IICA0 IICCTL00: STT (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL00_ACKE_Pos           (2UL)                     /*!< IICA0 IICCTL00: ACKE (Bit 2)                          */
#define IICA0_IICCTL00_ACKE_Msk           (0x4UL)                   /*!< IICA0 IICCTL00: ACKE (Bitfield-Mask: 0x01)            */
#define IICA0_IICCTL00_WTIM_Pos           (3UL)                     /*!< IICA0 IICCTL00: WTIM (Bit 3)                          */
#define IICA0_IICCTL00_WTIM_Msk           (0x8UL)                   /*!< IICA0 IICCTL00: WTIM (Bitfield-Mask: 0x01)            */
#define IICA0_IICCTL00_SPIE_Pos           (4UL)                     /*!< IICA0 IICCTL00: SPIE (Bit 4)                          */
#define IICA0_IICCTL00_SPIE_Msk           (0x10UL)                  /*!< IICA0 IICCTL00: SPIE (Bitfield-Mask: 0x01)            */
#define IICA0_IICCTL00_WREL_Pos           (5UL)                     /*!< IICA0 IICCTL00: WREL (Bit 5)                          */
#define IICA0_IICCTL00_WREL_Msk           (0x20UL)                  /*!< IICA0 IICCTL00: WREL (Bitfield-Mask: 0x01)            */
#define IICA0_IICCTL00_LREL_Pos           (6UL)                     /*!< IICA0 IICCTL00: LREL (Bit 6)                          */
#define IICA0_IICCTL00_LREL_Msk           (0x40UL)                  /*!< IICA0 IICCTL00: LREL (Bitfield-Mask: 0x01)            */
#define IICA0_IICCTL00_IICE_Pos           (7UL)                     /*!< IICA0 IICCTL00: IICE (Bit 7)                          */
#define IICA0_IICCTL00_IICE_Msk           (0x80UL)                  /*!< IICA0 IICCTL00: IICE (Bitfield-Mask: 0x01)            */
/* =======================================================  IICCTL01  ======================================================== */
#define IICA0_IICCTL01_PRS_Pos            (0UL)                     /*!< IICA0 IICCTL01: PRS (Bit 0)                           */
#define IICA0_IICCTL01_PRS_Msk            (0x1UL)                   /*!< IICA0 IICCTL01: PRS (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL01_DFC_Pos            (2UL)                     /*!< IICA0 IICCTL01: DFC (Bit 2)                           */
#define IICA0_IICCTL01_DFC_Msk            (0x4UL)                   /*!< IICA0 IICCTL01: DFC (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL01_SMC_Pos            (3UL)                     /*!< IICA0 IICCTL01: SMC (Bit 3)                           */
#define IICA0_IICCTL01_SMC_Msk            (0x8UL)                   /*!< IICA0 IICCTL01: SMC (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL01_DAD_Pos            (4UL)                     /*!< IICA0 IICCTL01: DAD (Bit 4)                           */
#define IICA0_IICCTL01_DAD_Msk            (0x10UL)                  /*!< IICA0 IICCTL01: DAD (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL01_CLD_Pos            (5UL)                     /*!< IICA0 IICCTL01: CLD (Bit 5)                           */
#define IICA0_IICCTL01_CLD_Msk            (0x20UL)                  /*!< IICA0 IICCTL01: CLD (Bitfield-Mask: 0x01)             */
#define IICA0_IICCTL01_WUP_Pos            (7UL)                     /*!< IICA0 IICCTL01: WUP (Bit 7)                           */
#define IICA0_IICCTL01_WUP_Msk            (0x80UL)                  /*!< IICA0 IICCTL01: WUP (Bitfield-Mask: 0x01)             */
/* ========================================================  IICWL0  ========================================================= */
/* ========================================================  IICWH0  ========================================================= */
/* =========================================================  SVA0  ========================================================== */
/* ========================================================  IICA00  ========================================================= */
/* =========================================================  IICS0  ========================================================= */
#define IICA0_IICS0_MSTS_Pos              (7UL)                     /*!< IICA0 IICS0: MSTS (Bit 7)                             */
#define IICA0_IICS0_MSTS_Msk              (0x80UL)                  /*!< IICA0 IICS0: MSTS (Bitfield-Mask: 0x01)               */
#define IICA0_IICS0_ALD_Pos               (6UL)                     /*!< IICA0 IICS0: ALD (Bit 6)                              */
#define IICA0_IICS0_ALD_Msk               (0x40UL)                  /*!< IICA0 IICS0: ALD (Bitfield-Mask: 0x01)                */
#define IICA0_IICS0_EXC_Pos               (5UL)                     /*!< IICA0 IICS0: EXC (Bit 5)                              */
#define IICA0_IICS0_EXC_Msk               (0x20UL)                  /*!< IICA0 IICS0: EXC (Bitfield-Mask: 0x01)                */
#define IICA0_IICS0_COI_Pos               (4UL)                     /*!< IICA0 IICS0: COI (Bit 4)                              */
#define IICA0_IICS0_COI_Msk               (0x10UL)                  /*!< IICA0 IICS0: COI (Bitfield-Mask: 0x01)                */
#define IICA0_IICS0_TRC_Pos               (3UL)                     /*!< IICA0 IICS0: TRC (Bit 3)                              */
#define IICA0_IICS0_TRC_Msk               (0x8UL)                   /*!< IICA0 IICS0: TRC (Bitfield-Mask: 0x01)                */
#define IICA0_IICS0_ACKD_Pos              (2UL)                     /*!< IICA0 IICS0: ACKD (Bit 2)                             */
#define IICA0_IICS0_ACKD_Msk              (0x4UL)                   /*!< IICA0 IICS0: ACKD (Bitfield-Mask: 0x01)               */
#define IICA0_IICS0_STD_Pos               (1UL)                     /*!< IICA0 IICS0: STD (Bit 1)                              */
#define IICA0_IICS0_STD_Msk               (0x2UL)                   /*!< IICA0 IICS0: STD (Bitfield-Mask: 0x01)                */
#define IICA0_IICS0_SPD_Pos               (0UL)                     /*!< IICA0 IICS0: SPD (Bit 0)                              */
#define IICA0_IICS0_SPD_Msk               (0x1UL)                   /*!< IICA0 IICS0: SPD (Bitfield-Mask: 0x01)                */
/* =========================================================  IICF0  ========================================================= */
#define IICA0_IICF0_STCF_Pos              (7UL)                     /*!< IICA0 IICF0: STCF (Bit 7)                             */
#define IICA0_IICF0_STCF_Msk              (0x80UL)                  /*!< IICA0 IICF0: STCF (Bitfield-Mask: 0x01)               */
#define IICA0_IICF0_IICBSY_Pos            (6UL)                     /*!< IICA0 IICF0: IICBSY (Bit 6)                           */
#define IICA0_IICF0_IICBSY_Msk            (0x40UL)                  /*!< IICA0 IICF0: IICBSY (Bitfield-Mask: 0x01)             */
#define IICA0_IICF0_STCEN_Pos             (1UL)                     /*!< IICA0 IICF0: STCEN (Bit 1)                            */
#define IICA0_IICF0_STCEN_Msk             (0x2UL)                   /*!< IICA0 IICF0: STCEN (Bitfield-Mask: 0x01)              */
#define IICA0_IICF0_IICRSV_Pos            (0UL)                     /*!< IICA0 IICF0: IICRSV (Bit 0)                           */
#define IICA0_IICF0_IICRSV_Msk            (0x1UL)                   /*!< IICA0 IICF0: IICRSV (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                           IICA1                                           ================ */
/* =========================================================================================================================== */

/* =======================================================  IICCTL10  ======================================================== */
#define IICA1_IICCTL10_SPT_Pos            (0UL)                     /*!< IICA1 IICCTL10: SPT (Bit 0)                           */
#define IICA1_IICCTL10_SPT_Msk            (0x1UL)                   /*!< IICA1 IICCTL10: SPT (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL10_STT_Pos            (1UL)                     /*!< IICA1 IICCTL10: STT (Bit 1)                           */
#define IICA1_IICCTL10_STT_Msk            (0x2UL)                   /*!< IICA1 IICCTL10: STT (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL10_ACKE_Pos           (2UL)                     /*!< IICA1 IICCTL10: ACKE (Bit 2)                          */
#define IICA1_IICCTL10_ACKE_Msk           (0x4UL)                   /*!< IICA1 IICCTL10: ACKE (Bitfield-Mask: 0x01)            */
#define IICA1_IICCTL10_WTIM_Pos           (3UL)                     /*!< IICA1 IICCTL10: WTIM (Bit 3)                          */
#define IICA1_IICCTL10_WTIM_Msk           (0x8UL)                   /*!< IICA1 IICCTL10: WTIM (Bitfield-Mask: 0x01)            */
#define IICA1_IICCTL10_SPIE_Pos           (4UL)                     /*!< IICA1 IICCTL10: SPIE (Bit 4)                          */
#define IICA1_IICCTL10_SPIE_Msk           (0x10UL)                  /*!< IICA1 IICCTL10: SPIE (Bitfield-Mask: 0x01)            */
#define IICA1_IICCTL10_WREL_Pos           (5UL)                     /*!< IICA1 IICCTL10: WREL (Bit 5)                          */
#define IICA1_IICCTL10_WREL_Msk           (0x20UL)                  /*!< IICA1 IICCTL10: WREL (Bitfield-Mask: 0x01)            */
#define IICA1_IICCTL10_LREL_Pos           (6UL)                     /*!< IICA1 IICCTL10: LREL (Bit 6)                          */
#define IICA1_IICCTL10_LREL_Msk           (0x40UL)                  /*!< IICA1 IICCTL10: LREL (Bitfield-Mask: 0x01)            */
#define IICA1_IICCTL10_IICE_Pos           (7UL)                     /*!< IICA1 IICCTL10: IICE (Bit 7)                          */
#define IICA1_IICCTL10_IICE_Msk           (0x80UL)                  /*!< IICA1 IICCTL10: IICE (Bitfield-Mask: 0x01)            */
/* =======================================================  IICCTL11  ======================================================== */
#define IICA1_IICCTL11_PRS_Pos            (0UL)                     /*!< IICA1 IICCTL11: PRS (Bit 0)                           */
#define IICA1_IICCTL11_PRS_Msk            (0x1UL)                   /*!< IICA1 IICCTL11: PRS (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL11_DFC_Pos            (2UL)                     /*!< IICA1 IICCTL11: DFC (Bit 2)                           */
#define IICA1_IICCTL11_DFC_Msk            (0x4UL)                   /*!< IICA1 IICCTL11: DFC (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL11_SMC_Pos            (3UL)                     /*!< IICA1 IICCTL11: SMC (Bit 3)                           */
#define IICA1_IICCTL11_SMC_Msk            (0x8UL)                   /*!< IICA1 IICCTL11: SMC (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL11_DAD_Pos            (4UL)                     /*!< IICA1 IICCTL11: DAD (Bit 4)                           */
#define IICA1_IICCTL11_DAD_Msk            (0x10UL)                  /*!< IICA1 IICCTL11: DAD (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL11_CLD_Pos            (5UL)                     /*!< IICA1 IICCTL11: CLD (Bit 5)                           */
#define IICA1_IICCTL11_CLD_Msk            (0x20UL)                  /*!< IICA1 IICCTL11: CLD (Bitfield-Mask: 0x01)             */
#define IICA1_IICCTL11_WUP_Pos            (7UL)                     /*!< IICA1 IICCTL11: WUP (Bit 7)                           */
#define IICA1_IICCTL11_WUP_Msk            (0x80UL)                  /*!< IICA1 IICCTL11: WUP (Bitfield-Mask: 0x01)             */
/* ========================================================  IICWL1  ========================================================= */
/* ========================================================  IICWH1  ========================================================= */
/* =========================================================  SVA1  ========================================================== */
/* ========================================================  IICA10  ========================================================= */
/* =========================================================  IICS1  ========================================================= */
#define IICA1_IICS1_MSTS_Pos              (7UL)                     /*!< IICA1 IICS1: MSTS (Bit 7)                             */
#define IICA1_IICS1_MSTS_Msk              (0x80UL)                  /*!< IICA1 IICS1: MSTS (Bitfield-Mask: 0x01)               */
#define IICA1_IICS1_ALD_Pos               (6UL)                     /*!< IICA1 IICS1: ALD (Bit 6)                              */
#define IICA1_IICS1_ALD_Msk               (0x40UL)                  /*!< IICA1 IICS1: ALD (Bitfield-Mask: 0x01)                */
#define IICA1_IICS1_EXC_Pos               (5UL)                     /*!< IICA1 IICS1: EXC (Bit 5)                              */
#define IICA1_IICS1_EXC_Msk               (0x20UL)                  /*!< IICA1 IICS1: EXC (Bitfield-Mask: 0x01)                */
#define IICA1_IICS1_COI_Pos               (4UL)                     /*!< IICA1 IICS1: COI (Bit 4)                              */
#define IICA1_IICS1_COI_Msk               (0x10UL)                  /*!< IICA1 IICS1: COI (Bitfield-Mask: 0x01)                */
#define IICA1_IICS1_TRC_Pos               (3UL)                     /*!< IICA1 IICS1: TRC (Bit 3)                              */
#define IICA1_IICS1_TRC_Msk               (0x8UL)                   /*!< IICA1 IICS1: TRC (Bitfield-Mask: 0x01)                */
#define IICA1_IICS1_ACKD_Pos              (2UL)                     /*!< IICA1 IICS1: ACKD (Bit 2)                             */
#define IICA1_IICS1_ACKD_Msk              (0x4UL)                   /*!< IICA1 IICS1: ACKD (Bitfield-Mask: 0x01)               */
#define IICA1_IICS1_STD_Pos               (1UL)                     /*!< IICA1 IICS1: STD (Bit 1)                              */
#define IICA1_IICS1_STD_Msk               (0x2UL)                   /*!< IICA1 IICS1: STD (Bitfield-Mask: 0x01)                */
#define IICA1_IICS1_SPD_Pos               (0UL)                     /*!< IICA1 IICS1: SPD (Bit 0)                              */
#define IICA1_IICS1_SPD_Msk               (0x1UL)                   /*!< IICA1 IICS1: SPD (Bitfield-Mask: 0x01)                */
/* =========================================================  IICF1  ========================================================= */
#define IICA1_IICF1_STCF_Pos              (7UL)                     /*!< IICA1 IICF1: STCF (Bit 7)                             */
#define IICA1_IICF1_STCF_Msk              (0x80UL)                  /*!< IICA1 IICF1: STCF (Bitfield-Mask: 0x01)               */
#define IICA1_IICF1_IICBSY_Pos            (6UL)                     /*!< IICA1 IICF1: IICBSY (Bit 6)                           */
#define IICA1_IICF1_IICBSY_Msk            (0x40UL)                  /*!< IICA1 IICF1: IICBSY (Bitfield-Mask: 0x01)             */
#define IICA1_IICF1_STCEN_Pos             (1UL)                     /*!< IICA1 IICF1: STCEN (Bit 1)                            */
#define IICA1_IICF1_STCEN_Msk             (0x2UL)                   /*!< IICA1 IICF1: STCEN (Bitfield-Mask: 0x01)              */
#define IICA1_IICF1_IICRSV_Pos            (0UL)                     /*!< IICA1 IICF1: IICRSV (Bit 0)                           */
#define IICA1_IICF1_IICRSV_Msk            (0x1UL)                   /*!< IICA1 IICF1: IICRSV (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                           LCDB                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  LBCTL  ========================================================= */
#define LCDB_LBCTL_BYF_Pos                (0UL)                     /*!< LCDB LBCTL: BYF (Bit 0)                               */
#define LCDB_LBCTL_BYF_Msk                (0x1UL)                   /*!< LCDB LBCTL: BYF (Bitfield-Mask: 0x01)                 */
#define LCDB_LBCTL_TPF_Pos                (1UL)                     /*!< LCDB LBCTL: TPF (Bit 1)                               */
#define LCDB_LBCTL_TPF_Msk                (0x2UL)                   /*!< LCDB LBCTL: TPF (Bitfield-Mask: 0x01)                 */
#define LCDB_LBCTL_TCIS_Pos               (3UL)                     /*!< LCDB LBCTL: TCIS (Bit 3)                              */
#define LCDB_LBCTL_TCIS_Msk               (0x8UL)                   /*!< LCDB LBCTL: TCIS (Bitfield-Mask: 0x01)                */
#define LCDB_LBCTL_LBC_Pos                (4UL)                     /*!< LCDB LBCTL: LBC (Bit 4)                               */
#define LCDB_LBCTL_LBC_Msk                (0x30UL)                  /*!< LCDB LBCTL: LBC (Bitfield-Mask: 0x03)                 */
#define LCDB_LBCTL_IMD_Pos                (6UL)                     /*!< LCDB LBCTL: IMD (Bit 6)                               */
#define LCDB_LBCTL_IMD_Msk                (0x40UL)                  /*!< LCDB LBCTL: IMD (Bitfield-Mask: 0x01)                 */
#define LCDB_LBCTL_EL_Pos                 (7UL)                     /*!< LCDB LBCTL: EL (Bit 7)                                */
#define LCDB_LBCTL_EL_Msk                 (0x80UL)                  /*!< LCDB LBCTL: EL (Bitfield-Mask: 0x01)                  */
/* =========================================================  LBCYC  ========================================================= */
/* =========================================================  LBWST  ========================================================= */
/* ========================================================  LBDATA  ========================================================= */
/* ========================================================  LBDATAL  ======================================================== */
/* ========================================================  LBDATAR  ======================================================== */
/* =======================================================  LBDATARL  ======================================================== */


/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  DMAEN  ========================================================= */
/* ========================================================  DMABAR  ========================================================= */
/* ========================================================  IFPRCR  ========================================================= */
/* =========================================================  DMAIF  ========================================================= */
/* =========================================================  DMSET  ========================================================= */
/* =========================================================  DMCLR  ========================================================= */


/* =========================================================================================================================== */
/* ================                                          DMAVEC                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  VEC  ========================================================== */


/* =========================================================================================================================== */
/* ================                                            ELC                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  ELSELR00  ======================================================== */
/* =======================================================  ELSELR01  ======================================================== */
/* =======================================================  ELSELR02  ======================================================== */
/* =======================================================  ELSELR03  ======================================================== */
/* =======================================================  ELSELR04  ======================================================== */
/* =======================================================  ELSELR05  ======================================================== */
/* =======================================================  ELSELR06  ======================================================== */
/* =======================================================  ELSELR07  ======================================================== */
/* =======================================================  ELSELR08  ======================================================== */
/* =======================================================  ELSELR09  ======================================================== */
/* =======================================================  ELSELR10  ======================================================== */
/* =======================================================  ELSELR11  ======================================================== */
/* =======================================================  ELSELR12  ======================================================== */
/* =======================================================  ELSELR13  ======================================================== */
/* =======================================================  ELSELR14  ======================================================== */
/* =======================================================  ELSELR15  ======================================================== */
/* =======================================================  ELSELR16  ======================================================== */
/* =======================================================  ELSELR17  ======================================================== */
/* =======================================================  ELSELR18  ======================================================== */
/* =======================================================  ELSELR19  ======================================================== */
/* =======================================================  ELSELR20  ======================================================== */
/* =======================================================  ELSELR21  ======================================================== */
/* =======================================================  ELSELR22  ======================================================== */


/* =========================================================================================================================== */
/* ================                                            INT                                            ================ */
/* =========================================================================================================================== */



/* =========================================================================================================================== */
/* ================                                           INTM                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  EGP0  ========================================================== */
#define INTM_EGP0_EGP0_Pos                (0UL)                     /*!< INTM EGP0: EGP0 (Bit 0)                               */
#define INTM_EGP0_EGP0_Msk                (0x1UL)                   /*!< INTM EGP0: EGP0 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP1_Pos                (1UL)                     /*!< INTM EGP0: EGP1 (Bit 1)                               */
#define INTM_EGP0_EGP1_Msk                (0x2UL)                   /*!< INTM EGP0: EGP1 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP2_Pos                (2UL)                     /*!< INTM EGP0: EGP2 (Bit 2)                               */
#define INTM_EGP0_EGP2_Msk                (0x4UL)                   /*!< INTM EGP0: EGP2 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP3_Pos                (3UL)                     /*!< INTM EGP0: EGP3 (Bit 3)                               */
#define INTM_EGP0_EGP3_Msk                (0x8UL)                   /*!< INTM EGP0: EGP3 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP4_Pos                (4UL)                     /*!< INTM EGP0: EGP4 (Bit 4)                               */
#define INTM_EGP0_EGP4_Msk                (0x10UL)                  /*!< INTM EGP0: EGP4 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP5_Pos                (5UL)                     /*!< INTM EGP0: EGP5 (Bit 5)                               */
#define INTM_EGP0_EGP5_Msk                (0x20UL)                  /*!< INTM EGP0: EGP5 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP6_Pos                (6UL)                     /*!< INTM EGP0: EGP6 (Bit 6)                               */
#define INTM_EGP0_EGP6_Msk                (0x40UL)                  /*!< INTM EGP0: EGP6 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP0_EGP7_Pos                (7UL)                     /*!< INTM EGP0: EGP7 (Bit 7)                               */
#define INTM_EGP0_EGP7_Msk                (0x80UL)                  /*!< INTM EGP0: EGP7 (Bitfield-Mask: 0x01)                 */
/* =========================================================  EGN0  ========================================================== */
#define INTM_EGN0_EGN0_Pos                (0UL)                     /*!< INTM EGN0: EGN0 (Bit 0)                               */
#define INTM_EGN0_EGN0_Msk                (0x1UL)                   /*!< INTM EGN0: EGN0 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN1_Pos                (1UL)                     /*!< INTM EGN0: EGN1 (Bit 1)                               */
#define INTM_EGN0_EGN1_Msk                (0x2UL)                   /*!< INTM EGN0: EGN1 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN2_Pos                (2UL)                     /*!< INTM EGN0: EGN2 (Bit 2)                               */
#define INTM_EGN0_EGN2_Msk                (0x4UL)                   /*!< INTM EGN0: EGN2 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN3_Pos                (3UL)                     /*!< INTM EGN0: EGN3 (Bit 3)                               */
#define INTM_EGN0_EGN3_Msk                (0x8UL)                   /*!< INTM EGN0: EGN3 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN4_Pos                (4UL)                     /*!< INTM EGN0: EGN4 (Bit 4)                               */
#define INTM_EGN0_EGN4_Msk                (0x10UL)                  /*!< INTM EGN0: EGN4 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN5_Pos                (5UL)                     /*!< INTM EGN0: EGN5 (Bit 5)                               */
#define INTM_EGN0_EGN5_Msk                (0x20UL)                  /*!< INTM EGN0: EGN5 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN6_Pos                (6UL)                     /*!< INTM EGN0: EGN6 (Bit 6)                               */
#define INTM_EGN0_EGN6_Msk                (0x40UL)                  /*!< INTM EGN0: EGN6 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN0_EGN7_Pos                (7UL)                     /*!< INTM EGN0: EGN7 (Bit 7)                               */
#define INTM_EGN0_EGN7_Msk                (0x80UL)                  /*!< INTM EGN0: EGN7 (Bitfield-Mask: 0x01)                 */
/* =========================================================  EGP1  ========================================================== */
#define INTM_EGP1_EGP8_Pos                (0UL)                     /*!< INTM EGP1: EGP8 (Bit 0)                               */
#define INTM_EGP1_EGP8_Msk                (0x1UL)                   /*!< INTM EGP1: EGP8 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP1_EGP9_Pos                (1UL)                     /*!< INTM EGP1: EGP9 (Bit 1)                               */
#define INTM_EGP1_EGP9_Msk                (0x2UL)                   /*!< INTM EGP1: EGP9 (Bitfield-Mask: 0x01)                 */
#define INTM_EGP1_EGP10_Pos               (2UL)                     /*!< INTM EGP1: EGP10 (Bit 2)                              */
#define INTM_EGP1_EGP10_Msk               (0x4UL)                   /*!< INTM EGP1: EGP10 (Bitfield-Mask: 0x01)                */
#define INTM_EGP1_EGP11_Pos               (3UL)                     /*!< INTM EGP1: EGP11 (Bit 3)                              */
#define INTM_EGP1_EGP11_Msk               (0x8UL)                   /*!< INTM EGP1: EGP11 (Bitfield-Mask: 0x01)                */
/* =========================================================  EGN1  ========================================================== */
#define INTM_EGN1_EGN8_Pos                (0UL)                     /*!< INTM EGN1: EGN8 (Bit 0)                               */
#define INTM_EGN1_EGN8_Msk                (0x1UL)                   /*!< INTM EGN1: EGN8 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN1_EGN9_Pos                (1UL)                     /*!< INTM EGN1: EGN9 (Bit 1)                               */
#define INTM_EGN1_EGN9_Msk                (0x2UL)                   /*!< INTM EGN1: EGN9 (Bitfield-Mask: 0x01)                 */
#define INTM_EGN1_EGN10_Pos               (2UL)                     /*!< INTM EGN1: EGN10 (Bit 2)                              */
#define INTM_EGN1_EGN10_Msk               (0x4UL)                   /*!< INTM EGN1: EGN10 (Bitfield-Mask: 0x01)                */
#define INTM_EGN1_EGN11_Pos               (3UL)                     /*!< INTM EGN1: EGN11 (Bit 3)                              */
#define INTM_EGN1_EGN11_Msk               (0x8UL)                   /*!< INTM EGN1: EGN11 (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                            KEY                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  KRM  ========================================================== */


/* =========================================================================================================================== */
/* ================                                           MISC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  NFEN0  ========================================================= */
#define MISC_NFEN0_SNFEN00_Pos            (0UL)                     /*!< MISC NFEN0: SNFEN00 (Bit 0)                           */
#define MISC_NFEN0_SNFEN00_Msk            (0x1UL)                   /*!< MISC NFEN0: SNFEN00 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN0_SNFEN10_Pos            (2UL)                     /*!< MISC NFEN0: SNFEN10 (Bit 2)                           */
#define MISC_NFEN0_SNFEN10_Msk            (0x4UL)                   /*!< MISC NFEN0: SNFEN10 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN0_SNFEN20_Pos            (4UL)                     /*!< MISC NFEN0: SNFEN20 (Bit 4)                           */
#define MISC_NFEN0_SNFEN20_Msk            (0x10UL)                  /*!< MISC NFEN0: SNFEN20 (Bitfield-Mask: 0x01)             */
/* =========================================================  NFEN1  ========================================================= */
#define MISC_NFEN1_TNFEN00_Pos            (0UL)                     /*!< MISC NFEN1: TNFEN00 (Bit 0)                           */
#define MISC_NFEN1_TNFEN00_Msk            (0x1UL)                   /*!< MISC NFEN1: TNFEN00 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN1_TNFEN01_Pos            (1UL)                     /*!< MISC NFEN1: TNFEN01 (Bit 1)                           */
#define MISC_NFEN1_TNFEN01_Msk            (0x2UL)                   /*!< MISC NFEN1: TNFEN01 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN1_TNFEN02_Pos            (2UL)                     /*!< MISC NFEN1: TNFEN02 (Bit 2)                           */
#define MISC_NFEN1_TNFEN02_Msk            (0x4UL)                   /*!< MISC NFEN1: TNFEN02 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN1_TNFEN03_Pos            (3UL)                     /*!< MISC NFEN1: TNFEN03 (Bit 3)                           */
#define MISC_NFEN1_TNFEN03_Msk            (0x8UL)                   /*!< MISC NFEN1: TNFEN03 (Bitfield-Mask: 0x01)             */
/* =========================================================  NFEN2  ========================================================= */
#define MISC_NFEN2_TNFEN10_Pos            (0UL)                     /*!< MISC NFEN2: TNFEN10 (Bit 0)                           */
#define MISC_NFEN2_TNFEN10_Msk            (0x1UL)                   /*!< MISC NFEN2: TNFEN10 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN11_Pos            (1UL)                     /*!< MISC NFEN2: TNFEN11 (Bit 1)                           */
#define MISC_NFEN2_TNFEN11_Msk            (0x2UL)                   /*!< MISC NFEN2: TNFEN11 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN12_Pos            (2UL)                     /*!< MISC NFEN2: TNFEN12 (Bit 2)                           */
#define MISC_NFEN2_TNFEN12_Msk            (0x4UL)                   /*!< MISC NFEN2: TNFEN12 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN13_Pos            (3UL)                     /*!< MISC NFEN2: TNFEN13 (Bit 3)                           */
#define MISC_NFEN2_TNFEN13_Msk            (0x8UL)                   /*!< MISC NFEN2: TNFEN13 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN14_Pos            (4UL)                     /*!< MISC NFEN2: TNFEN14 (Bit 4)                           */
#define MISC_NFEN2_TNFEN14_Msk            (0x10UL)                  /*!< MISC NFEN2: TNFEN14 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN15_Pos            (5UL)                     /*!< MISC NFEN2: TNFEN15 (Bit 5)                           */
#define MISC_NFEN2_TNFEN15_Msk            (0x20UL)                  /*!< MISC NFEN2: TNFEN15 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN16_Pos            (6UL)                     /*!< MISC NFEN2: TNFEN16 (Bit 6)                           */
#define MISC_NFEN2_TNFEN16_Msk            (0x40UL)                  /*!< MISC NFEN2: TNFEN16 (Bitfield-Mask: 0x01)             */
#define MISC_NFEN2_TNFEN17_Pos            (7UL)                     /*!< MISC NFEN2: TNFEN17 (Bit 7)                           */
#define MISC_NFEN2_TNFEN17_Msk            (0x80UL)                  /*!< MISC NFEN2: TNFEN17 (Bitfield-Mask: 0x01)             */
/* ==========================================================  ISC  ========================================================== */
#define MISC_ISC_ISC0_Pos                 (0UL)                     /*!< MISC ISC: ISC0 (Bit 0)                                */
#define MISC_ISC_ISC0_Msk                 (0x1UL)                   /*!< MISC ISC: ISC0 (Bitfield-Mask: 0x01)                  */
#define MISC_ISC_ISC1_Pos                 (1UL)                     /*!< MISC ISC: ISC1 (Bit 1)                                */
#define MISC_ISC_ISC1_Msk                 (0x2UL)                   /*!< MISC ISC: ISC1 (Bitfield-Mask: 0x01)                  */
#define MISC_ISC_SSIE00_Pos               (7UL)                     /*!< MISC ISC: SSIE00 (Bit 7)                              */
#define MISC_ISC_SSIE00_Msk               (0x80UL)                  /*!< MISC ISC: SSIE00 (Bitfield-Mask: 0x01)                */
/* =========================================================  TIOS0  ========================================================= */
/* =========================================================  TIOS1  ========================================================= */
/* =========================================================  RTCCL  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            FMC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  FLSTS  ========================================================= */
#define FMC_FLSTS_OVF_Pos                 (0UL)                     /*!< FMC FLSTS: OVF (Bit 0)                                */
#define FMC_FLSTS_OVF_Msk                 (0x1UL)                   /*!< FMC FLSTS: OVF (Bitfield-Mask: 0x01)                  */
#define FMC_FLSTS_EVF_Pos                 (2UL)                     /*!< FMC FLSTS: EVF (Bit 2)                                */
#define FMC_FLSTS_EVF_Msk                 (0x4UL)                   /*!< FMC FLSTS: EVF (Bitfield-Mask: 0x01)                  */
/* ========================================================  FLOPMD1  ======================================================== */
/* ========================================================  FLOPMD2  ======================================================== */
/* ========================================================  FLERMD  ========================================================= */
/* =======================================================  FLCERCNT  ======================================================== */
/* =======================================================  FLSERCNT  ======================================================== */
/* =======================================================  FLPROCNT  ======================================================== */
/* ========================================================  FLPROT  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            SAF                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  CRC0CTL  ======================================================== */
#define SAF_CRC0CTL_CRC0EN_Pos            (7UL)                     /*!< SAF CRC0CTL: CRC0EN (Bit 7)                           */
#define SAF_CRC0CTL_CRC0EN_Msk            (0x80UL)                  /*!< SAF CRC0CTL: CRC0EN (Bitfield-Mask: 0x01)             */
#define SAF_CRC0CTL_FEA_Pos               (0UL)                     /*!< SAF CRC0CTL: FEA (Bit 0)                              */
#define SAF_CRC0CTL_FEA_Msk               (0x7fUL)                  /*!< SAF CRC0CTL: FEA (Bitfield-Mask: 0x7f)                */
/* ========================================================  PGCRCL  ========================================================= */
/* =========================================================  CRCIN  ========================================================= */
/* =========================================================  CRCD  ========================================================== */
/* ========================================================  RPECTL  ========================================================= */
#define SAF_RPECTL_RPEF_Pos               (0UL)                     /*!< SAF RPECTL: RPEF (Bit 0)                              */
#define SAF_RPECTL_RPEF_Msk               (0x1UL)                   /*!< SAF RPECTL: RPEF (Bitfield-Mask: 0x01)                */
#define SAF_RPECTL_RPERDIS_Pos            (7UL)                     /*!< SAF RPECTL: RPERDIS (Bit 7)                           */
#define SAF_RPECTL_RPERDIS_Msk            (0x80UL)                  /*!< SAF RPECTL: RPERDIS (Bitfield-Mask: 0x01)             */
/* =========================================================  SFRGD  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  CRCD  ========================================================== */
/* =========================================================  CRCIN  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            DBG                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  DBGSTR  ========================================================= */
#define DBG_DBGSTR_CDBGPWRUPACK_Pos       (29UL)                    /*!< DBG DBGSTR: CDBGPWRUPACK (Bit 29)                     */
#define DBG_DBGSTR_CDBGPWRUPACK_Msk       (0x20000000UL)            /*!< DBG DBGSTR: CDBGPWRUPACK (Bitfield-Mask: 0x01)        */
#define DBG_DBGSTR_CDBGPWRUPREQ_Pos       (28UL)                    /*!< DBG DBGSTR: CDBGPWRUPREQ (Bit 28)                     */
#define DBG_DBGSTR_CDBGPWRUPREQ_Msk       (0x10000000UL)            /*!< DBG DBGSTR: CDBGPWRUPREQ (Bitfield-Mask: 0x01)        */
/* =======================================================  DBGSTOPCR  ======================================================= */
#define DBG_DBGSTOPCR_SWDIS_Pos           (24UL)                    /*!< DBG DBGSTOPCR: SWDIS (Bit 24)                         */
#define DBG_DBGSTOPCR_SWDIS_Msk           (0x1000000UL)             /*!< DBG DBGSTOPCR: SWDIS (Bitfield-Mask: 0x01)            */
#define DBG_DBGSTOPCR_RPERMSK_Pos         (16UL)                    /*!< DBG DBGSTOPCR: RPERMSK (Bit 16)                       */
#define DBG_DBGSTOPCR_RPERMSK_Msk         (0x10000UL)               /*!< DBG DBGSTOPCR: RPERMSK (Bitfield-Mask: 0x01)          */
#define DBG_DBGSTOPCR_RESMSK_Pos          (2UL)                     /*!< DBG DBGSTOPCR: RESMSK (Bit 2)                         */
#define DBG_DBGSTOPCR_RESMSK_Msk          (0x4UL)                   /*!< DBG DBGSTOPCR: RESMSK (Bitfield-Mask: 0x01)           */
#define DBG_DBGSTOPCR_FRZEN1_Pos          (1UL)                     /*!< DBG DBGSTOPCR: FRZEN1 (Bit 1)                         */
#define DBG_DBGSTOPCR_FRZEN1_Msk          (0x2UL)                   /*!< DBG DBGSTOPCR: FRZEN1 (Bitfield-Mask: 0x01)           */
#define DBG_DBGSTOPCR_FRZEN0_Pos          (0UL)                     /*!< DBG DBGSTOPCR: FRZEN0 (Bit 0)                         */
#define DBG_DBGSTOPCR_FRZEN0_Msk          (0x1UL)                   /*!< DBG DBGSTOPCR: FRZEN0 (Bitfield-Mask: 0x01)           */


/* =========================================================================================================================== */
/* ================                                           CAN0                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  CGMCTRL  ======================================================== */
/* =========================================================  CGMCS  ========================================================= */
/* ========================================================  CGMABT  ========================================================= */
/* ========================================================  CGMABTD  ======================================================== */
/* ========================================================  CMASK1  ========================================================= */
/* ========================================================  CMASK2  ========================================================= */
/* ========================================================  CMASK3  ========================================================= */
/* ========================================================  CMASK4  ========================================================= */
/* =========================================================  CCTRL  ========================================================= */
/* =========================================================  CLEC  ========================================================== */
/* =========================================================  CINFO  ========================================================= */
/* =========================================================  CERC  ========================================================== */
/* ==========================================================  CIE  ========================================================== */
/* =========================================================  CINTS  ========================================================= */
/* =========================================================  CBRP  ========================================================== */
/* =========================================================  CBTR  ========================================================== */
/* =========================================================  CLIPT  ========================================================= */
/* =========================================================  CRGPT  ========================================================= */
/* =========================================================  CLOPT  ========================================================= */
/* =========================================================  CTGPT  ========================================================= */
/* ==========================================================  CTS  ========================================================== */


/* =========================================================================================================================== */
/* ================                                         CAN0MSG00                                         ================ */
/* =========================================================================================================================== */

/* =========================================================  CMDB  ========================================================== */
/* =========================================================  CMDB  ========================================================== */
/* =========================================================  CMDB  ========================================================== */
/* =========================================================  CMDB  ========================================================== */
/* =========================================================  CMDB  ========================================================== */
/* =========================================================  CMDLC  ========================================================= */
/* ========================================================  CMCONF  ========================================================= */
/* =========================================================  CMIDL  ========================================================= */
/* =========================================================  CMIDH  ========================================================= */
/* ========================================================  CMCTRL  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            BGR                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  VBG85  ========================================================= */
/* =========================================================  VBG25  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            TSN                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  TSN85  ========================================================= */
/* =========================================================  TSN25  ========================================================= */


/* =========================================================================================================================== */
/* ================                                            UID                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  UID  ========================================================== */

/** @} */ /* End of group PosMask_peripherals */
#ifdef USE_STDPERIPH_DRIVER
  #include "BAT32A279_conf.h"
#endif /* USE_STDPERIPH_DRIVER */
#ifdef __cplusplus
}
#endif

#endif /* BAT32G179_H */


/** @} */ /* End of group BAT32G179 */

/** @} */ /* End of group CMS */
