#include "AMT630H.h"
#include <stdint.h>
#include "UartProtocol.h"
#include "Components.h"
#include "PicBin.h"
#include "GpioUser.h"
//#include "AMT630H_Datas.h"
#define AMT630H_ERR_TIME            10000U
#define AMT630H_RELEASE_MODE        1U
unsigned int AMT630H_InitTime = 0;
uint8_t g_sysFlag_Lcdcheck = 0;
/* Initialization */
LCD_TFT_SOUND_PARA_ST LcdSoundParamterData;
SOFTWARE_VERSION_ST amt630Version;

uint8_t Amt630hInitFinishFlag = 0;

uint32_t Amt630hInitTimerCnts = 0;
uint32_t Amt630hSequentialTimerCnts = 0;
uint32_t Amt630hFlashCheckTimerCnts = 0;
uint32_t Amt630hServiceTimerCnts = 0;


/* SOC Error */
uint16_t AMT630H_REQ_Time[ALIVE_COUNTER_TOTAL] = { 0 };
uint8_t AMT630H_Err = 0U;
uint8_t AMT630H_AliveCounter[ALIVE_COUNTER_TOTAL] = { 0 };
uint16_t AMT630H_CrcErrTime = 0;
uint32_t AMT630H_CrcErrCounter = 0;
uint8_t AMT630H_CrcErrMaxCounter = 0;

/* Flash Check */
#define  FLASH_CHECK_TIME_NUM       20000
s_AMT630H_FlashCheck_t AMT630H_FlashCheck;

/* Delay Time */
unsigned long Delay_Time = 0;
unsigned long Delay_Time_Set = 0;

/* Refresh Time */
unsigned long AMT630H_RefreshTime = 0;
static uint8_t AMT630H_Animation_Start = 0;
static uint8_t AMT630H_Animation_Finish = 0;
static uint16_t AMT630H_Animation_DispPic = 0;
static uint16_t AMT630H_Animation_RefreshTime = 0;
static uint16_t AMT630H_Animation_RefreshTime_default = 0;
static const uint16_t BootAnimationList[AMT630H_ANIMATION_PIC_NUM] = {
    Pic_0268_0_0,Pic_0268_0_0,Pic_0268_0_0,Pic_0267_0_0,Pic_0266_0_0,Pic_0265_0_0,
    Pic_0264_0_0,Pic_0263_0_0,Pic_0262_0_0,Pic_0261_0_0,Pic_0260_0_0,Pic_0259_0_0,
    Pic_0258_0_0,Pic_0257_0_0,Pic_0256_0_0,Pic_0255_0_0,Pic_0254_0_0,Pic_0253_0_0,
    Pic_0252_0_0,Pic_0251_0_0,Pic_0250_0_0,Pic_0249_0_0,Pic_0248_0_0,Pic_0247_0_0,
    Pic_0246_0_0,Pic_0245_0_0,Pic_0244_0_0,Pic_0243_0_0,Pic_0242_0_0,Pic_0241_0_0,
    Pic_0240_0_0,Pic_0239_0_0,Pic_0238_0_0,Pic_0237_0_0,Pic_0236_0_0,Pic_0235_0_0,
    Pic_0234_0_0,Pic_0233_0_0,Pic_0232_0_0,Pic_0231_0_0,Pic_0230_0_0,Pic_0229_0_0,
    Pic_0228_0_0,Pic_0227_0_0,Pic_0226_0_0,Pic_0225_0_0,Pic_0224_0_0,Pic_0223_0_0,
    Pic_0222_0_0,Pic_0221_0_0,Pic_0220_0_0,Pic_0219_0_0,Pic_0218_0_0,Pic_0217_0_0,
    Pic_0216_0_0,Pic_0215_0_0,Pic_0214_0_0,Pic_0213_0_0,Pic_0212_0_0,Pic_0211_0_0,
    Pic_0210_0_0,Pic_0209_0_0,Pic_0208_0_0,Pic_0207_0_0,Pic_0206_0_0,Pic_0205_0_0,
    Pic_0204_0_0,Pic_0203_0_0,Pic_0202_0_0,Pic_0201_0_0,Pic_0200_0_0,Pic_0199_0_0,
    Pic_0198_0_0,Pic_0197_0_0,Pic_0196_0_0,Pic_0195_0_0,Pic_0194_0_0,Pic_0193_0_0,
    Pic_0192_0_0,Pic_0191_0_0,Pic_0190_0_0,Pic_0189_0_0,Pic_0188_0_0,Pic_0187_0_0,
    Pic_0186_0_0,Pic_0185_0_0,Pic_0184_0_0,Pic_0183_0_0,Pic_0182_0_0,Pic_0181_0_0,
    Pic_0180_0_0,Pic_0179_0_0,Pic_0178_0_0,Pic_0177_0_0,Pic_0176_0_0,Pic_0175_0_0,
    Pic_0174_0_0,Pic_0173_0_0,Pic_0172_0_0,Pic_0171_0_0,Pic_0170_0_0,Pic_0169_0_0,
    Pic_0168_0_0,Pic_0167_0_0,Pic_0166_0_0,Pic_0165_0_0,Pic_0164_0_0,Pic_0163_0_0,
    Pic_0162_0_0,Pic_0161_0_0,Pic_0160_0_0,Pic_0159_0_0,Pic_0158_0_0,Pic_0157_0_0,
    Pic_0156_0_0,Pic_0155_0_0,Pic_0154_0_0,Pic_0153_0_0,Pic_0152_0_0,Pic_0152_0_0,
    Pic_0150_0_0,Pic_0149_0_0,Pic_0148_0_0,Pic_0147_0_0,Pic_0146_0_0,Pic_0145_0_0,
    Pic_0144_0_0,Pic_0143_0_0,Pic_0142_0_0,Pic_0141_0_0,Pic_0140_0_0,Pic_0139_0_0,
    Pic_0138_0_0,Pic_0137_0_0,Pic_0136_0_0,Pic_0135_0_0,Pic_0134_0_0,Pic_0133_0_0,
    Pic_0132_0_0,Pic_0131_0_0,Pic_0130_0_0,Pic_0129_0_0,Pic_0128_0_0,Pic_0127_0_0,
    Pic_0126_0_0,Pic_0125_0_0
};
void AMT630H_Animation_PlayProc(uint16_t PicIndex)
{
    unsigned char *pBuf;
    uint32_t tmpLen = 0;
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0); 
    SetPageBackground(GRAPHICS_PAGE_0, PicIndex);
    PackedTransfer_Page();
  //  PackedTransfer_GetSwVer();

}
/* Timer */
void AMT630H_Timer(unsigned char Tms)
{
    unsigned char i = 0U;

    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_REQ_Time[i] < AMT630H_ERR_TIME)
        {
            AMT630H_REQ_Time[i] += Tms;
        }
    }
    if(AMT630H_RefreshTime < AMT630H_REFRESH_TIME)
    {
        AMT630H_RefreshTime += Tms;
    }
    if(Delay_Time < Delay_Time_Set)
    {
        Delay_Time += Tms;
    }
    if(AMT630H_InitTime < 5000)
    {
        AMT630H_InitTime += Tms;
    }
    if(AMT630H_Animation_Finish == 0)
    {
        if(AMT630H_Animation_RefreshTime < AMT630H_ANIMATION_TIME)
        {
            AMT630H_Animation_RefreshTime += Tms;
        }
    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
    }
}
void Delay_Time_Ctrl(unsigned long Tms)
{
    Delay_Time = 0;
    Delay_Time_Set = Tms;

    while(Delay_Time < Delay_Time_Set)
    {
        RTE_WDT_Clear();
    }

    Delay_Time = 0;
    Delay_Time_Set = 0;
}

uint8_t UartRevBuff[0x1000] = { 0 };
uint32_t UartRevCnts = 0;
void Amt630hUartRecvData(uint16_t u16UARTData)
{
    UartRevBuff[UartRevCnts++] = (u16UARTData & 0xff);
    if (UartRevCnts >= 0x1000) 
    {
        UartRevCnts = 0;
    }
}
void AMT630H_RstCtrl(void)
{
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);//630
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 0);//630
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);//lcd
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);//lcd
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 1);   
    Delay_Time_Ctrl(15);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 1);
    Delay_Time_Ctrl(30);
    RTE_GPIO_Set_Level(x1530_EN_MCU, 1);//1530
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 1); 
    Delay_Time_Ctrl(15); 
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 1); 
   
}
void Amt630hInit(void)
{
    uint8_t i = 0;
    AMT630H_RstCtrl();
    AMT630H_RefreshTime = AMT630H_REFRESH_TIME;
    // Error State Init
    AMT630H_Err = 0U;
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        AMT630H_REQ_Time[i] = 0U;
        AMT630H_AliveCounter[i] = 0;
    }
    AMT630H_CrcErrTime = 0;
    AMT630H_CrcErrCounter = 0;

    // Param Config
    LcdSoundParamterData.LcdWidth = 1024;
    LcdSoundParamterData.LcdHeight = 600;
    LcdSoundParamterData.LcdBpp = 32;
    LcdSoundParamterData.LcdVideoInputValid = 0;
    LcdSoundParamterData.Ark7116ResetPin = 0;
    LcdSoundParamterData.LcdInterfaceType = LCD_INTERFACE_TTL;
    LcdSoundParamterData.LcdWiringMode = LCD_WIRING_MODE_BGR;
    LcdSoundParamterData.LcdWiringBitOrder = LCD_WIRING_BIT_ORDER_MSB;
    LcdSoundParamterData.LcdDotClkReverse = 0;  /* NuoMa 50pin TFT */
    LcdSoundParamterData.LvdsPanelFormat = LVDS_PANEL_FORMAT_TI;
    LcdSoundParamterData.LvdsPanelData = LVDS_PANEL_DATA_8BIT;

    LcdSoundParamterData.LcdTimingVBP = 60;
    LcdSoundParamterData.LcdTimingVFP = 12;
    LcdSoundParamterData.LcdTimingVSW = 4;

    LcdSoundParamterData.LcdTimingHBP = 20;
    LcdSoundParamterData.LcdTimingHFP = 80;
    LcdSoundParamterData.LcdTimingHSW = 20;

    LcdSoundParamterData.LcdClkFreq = 48000000;

    LcdSoundParamterData.SoundChannelNum = 0;
    LcdSoundParamterData.SoundFreq = AUDIO_FREQ_48K;
    SetLcdSoundParameter(&LcdSoundParamterData);
    SetSwVerBuf((uint8_t*)&amt630Version);

    User_PicIndexDataInit();
    ResetInitedState();    

    AnalysisUartData();

    AMT630H_InitTime = 0;

    AMT630H_Animation_Start = 0;
    AMT630H_Animation_Finish = 0;
    AMT630H_Animation_DispPic = 0;
    AMT630H_Animation_RefreshTime = 0;
    AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);

    Amt630hInitFinishFlag = 0;

    AMT630H_FlashCheck.Flag = 0;
    AMT630H_FlashCheck.InquireTime = 0;
    AMT630H_FlashCheck.CheckStateTime = 0;
    AMT630H_FlashCheck.Result = 0;
}
void AMT630H_Sleep(void)
{
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);    
    Delay_Time_Ctrl(30);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 0);
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);
    
}
static void AMT630H_AliveCounterMonitor(void)
{
    uint8_t i = 0;
    if(AMT630H_CrcErrCounter != GetCrcErrCnts())
    {
        AMT630H_CrcErrCounter = GetCrcErrCnts();
        AMT630H_CrcErrTime++;
        if(AMT630H_CrcErrTime >= 120)
        {
            AMT630H_Err = 1;
        }
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0;
        }
    }
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_AliveCounter[i] != GetAliveCounter(i))
        {
            AMT630H_AliveCounter[i] = GetAliveCounter(i);
            AMT630H_REQ_Time[i] = 0;
            if(AMT630H_CrcErrMaxCounter < AMT630H_CrcErrTime)
            {
                AMT630H_CrcErrMaxCounter = (unsigned char)AMT630H_CrcErrTime;
            }
            AMT630H_CrcErrTime = 0;
        }
        if(AMT630H_REQ_Time[i] >= AMT630H_ERR_TIME)
        {
            AMT630H_Err = 1;
        }
    }
}

void AMT630H_Main(void)
{
    unsigned char i;
    AnalysisUartData();
        
    if(GetLcdInitSt() != 1)
    {
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0U;           
        }
        return;
    }
    AMT630H_AliveCounterMonitor();
    if(AMT630H_Err == 1U)
    {
        AMT630H_Err = 0;
        Amt630hInit();
        AMT630H_Animation_Finish = 1;
        return;
    }
    if(g_sysFlag_Lcdcheck == 1)
    {
        if(AMT630H_FlashCheck.Flag == 0)
        {
            AMT630H_FlashCheck.Flag = 1;
            AMT630H_FlashCheck.InquireTime = 0;
            AMT630H_FlashCheck.CheckStateTime = 0;
            PackedTransfer_CheckFlash();           
            AMT630H_FlashCheck.Result = 0xFF;
        }
        if(AMT630H_FlashCheck.Flag == 1)
        {
            if(AMT630H_FlashCheck.InquireTime >= 100)
            {
                AMT630H_FlashCheck.InquireTime = 0;
                AMT630H_FlashCheck.Result = PackedTransfer_CheckFlashGetResult();
                if(AMT630H_FlashCheck.Result != 0xFF)
                {
                    if(AMT630H_FlashCheck.Result == 1)
                    {
                        PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_PASS, 3000);
                        AMT630H_FlashCheck.Flag = 2;
                    }
                    else if (AMT630H_FlashCheck.CheckStateTime >= FLASH_CHECK_TIME_NUM)
                    {
                        PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_FAIL, 60000);
                        AMT630H_FlashCheck.Flag = 2;
                    }
                }
                
            }
            else
            {
                PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECKING, 60000);
            }
        }
    }
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(AMT630H_Animation_Finish == 1)
        {
            AMT630H_Animation_RefreshTime = 0;
            if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
            {                
                AMT630H_RefreshTime = 0;
                AMT630H_GUI_DisplayProc();
                //SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);
                //SetPageBackground( GRAPHICS_PAGE_0, Pic_0001_0_0 );
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0002_751_440);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0003_681_441);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0005_521_444);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0010_90_443);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0012_0_95);
                //PackedTransfer_Page();
            }
        }
        else
        {
            AMT630H_RefreshTime = 0;
            if(AMT630H_Animation_Start == 0)
            {
                AMT630H_Animation_Start = 1;                
                AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);
            }
            if(AMT630H_Animation_RefreshTime >= AMT630H_Animation_RefreshTime_default)
            {
                AMT630H_Animation_RefreshTime = 0;
                AMT630H_Animation_PlayProc(BootAnimationList[AMT630H_Animation_DispPic]);
                AMT630H_Animation_DispPic++;
                if(AMT630H_Animation_DispPic >= AMT630H_ANIMATION_PIC_NUM)
                {
                    AMT630H_Animation_Finish = 1;
                }
            }
        } 
        

    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
        if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
        {
            AMT630H_RefreshTime = 0;
            //AMT630H_GUI_DisplayProc();
        }
    }
}

unsigned char AMT630H_isInitFinish(void)
{
    if((AMT630H_InitTime >= 600) || (GetLcdInitSt() == 1))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}