/******************************************************************************
文 件 名：UDS_ISO14229_Server_Config.h
功能描述：ISO 14229 规范规定的诊断服务服务器端配置文件
作    者：张暄
版    本：V1.0
日    期：2016.11.1
******************************************************************************/

/******************************************************************************
                         诊断服务的OSI模型映射
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
  *      7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
  *      5      Session          ISO 14229-2
         4      Transport        ISO 15765-2
         3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/
#ifndef _UDS_ISO14229_SERVER_CONFIG_H_
#define _UDS_ISO14229_SERVER_CONFIG_H_

#include "stdint.h"
#include "Diag_ID_Def.h"

#define A_DATA_RX_BUFFER_SIZE N_USDATA_RX_BUFFER_SIZE
#define A_DATA_TX_BUFFER_SIZE N_USDATA_TX_BUFFER_SIZE

#define P2_SERVER       (uint16_t)50    /*P2Server*/
#define P2_AST_SERVER   (uint16_t)200   /*P2*Server*/
#define S3_SERVER       (uint8_t)50     /*S3Server 50 00ms*/

#endif
