
#include "Key_user.h"
#include "Components.h"
#include "UDS_ISO14229_Services.h"

__align(4)

#define BACK_MENU_TIME		800
_Menu_Data MenuData;
RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;
RTC_CounterTypeDef counter_val;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)//选择
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		Key_Event_Short_Press_Left();
		Key_Clear_Time();
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
	if((Get_Dis_OdoAndTrip() == 1) && (Get_ActualVechileSpeed() == 0))
	{
		Data_Clear_Trip(EM_TRIP_A);
	}
	Key_Clear_Time();
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
        /* 进入630H升级MCU模式 */
        // Get_Into_630H_Update_MCU_Mode();
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_LEFT_EVENT_NONE_Service();
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)//确认
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
	/* 在数字闪烁界面的时候，按确认键保存时间 */
	if 	(((Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET) || 
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET ) ||
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET ) ||
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET  )  ) && (Get_ActualVechileSpeed() == 0))
		{
			// Menu_Logic_Operation_Clock_Hour_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
			counter_val.time.RTC_Hours   = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    		counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
			counter_val.time.RTC_Seconds = 0U; 
			RTC_SetTime(&counter_val.time);
		}	
		Key_Event_Short_Press_Right();
		Key_Clear_Time();
		break;
	case KEY_EVENT_SHORT_PRESS_2:
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		Key_Event_LONG_PRESS_1_Right();
		Key_Clear_Time();
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		TYW_RESET_ODO();
		Get_Into_OTA_Update_Mode();
		Key_Clear_Time();
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_RIGHT_EVENT_NONE_Service();
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (RTE_GPIO_Get_Level(KEY_SELECT_MCU))//选择
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	else
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	return enKeyReal;
}

Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;

	if (RTE_GPIO_Get_Level(KEY_OK_MCU))//确认
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}
	else
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_2_Time(2100U,5000U);
	Key_Parameter_Set_Short_Press_1_Time(50U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(8000U);
	Key_Parameter_Set_Long_Press_3_Time(9000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_2_Time(2100U,5000U);
	Key_Parameter_Set_Short_Press_1_Time(50U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(8000U);
	Key_Parameter_Set_Long_Press_3_Time(9000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);
}

void Key_TimeOut_Service(void)
{
	if(OTA_Update_Flag == 0)
	{
		if((MenuData.Back_Time_Left_Flag == 1)&&(MenuData.Back_Time_Right_Flag == 1))
		{
			Menu_Service(MENU_KEY_TIMEOUT);
		}
		else
		{
			;
		}
	}
	else
	{
		;
	}
}

void Key_Auto_Save(void)
{
	
	// {
	// 	RTC_SetTime(&counter_val.time);
	// }


	// {
	// 	RTC_SetTime(&counter_val.time);
	// }

}

void Key_Event_Short_Press_Left(void)//选择
{		
	if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM)//接电话，切换大小计
	{
		if(BlueToothPhoneData.BlueToothPhoneSate == Phone_Incoming)
    	{
    	    PackedTransfer_BlueTooth_DataSet(Phone_Pick_Up);
    	}
		else if(Get_ActualVechileSpeed() == 0)
		{
			Menu_Service(MENU_KEY_FUNCTION_1_SHORT);
		}	
		else
		{
			;
		}
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_APP)
	{
		if(BlueToothPhoneData.BlueToothPhoneSate == Phone_Incoming)
    	{
    	    PackedTransfer_BlueTooth_DataSet(Phone_Pick_Up);
    	}
		else
		{
			;
		}
	}

	if(((Menu_Get_Current_Cursor_Information() == MENU_ITEM_DISPLAY_MODE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_FAULT_INFORMATION)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_QUIT)) && (Get_ActualVechileSpeed() == 0))
	{
		Menu_Service(MENU_KEY_RIGHT_SHORT);
	}
	else
	{
		if(((Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_DAYTIME)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_NIGHTTIME)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_AUTO)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_5)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_4)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_3)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_2)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_1)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_AUTO)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_OPEN_CLOSE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_SYNC)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_BACK)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_BACK)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_KM)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_MILE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_CHINESE)||
		   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_ENGLISH)) && (Get_ActualVechileSpeed() == 0))
		{
			Menu_Service(MENU_KEY_DOWN_SHORT);
			Key_Event_BackLight_Press_Left();
		}
	}
	
}

void Key_Event_Short_Press_Right(void)//确认
{
	if(((Menu_Get_Current_Cursor_Information() == MENU_ITEM_DISPLAY_MODE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_SETTING)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_FAULT_INFORMATION)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_QUIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_DAYTIME)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_NIGHTTIME)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_SELECT_AUTO)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_5)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_4)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_3)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_2)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_1)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_AUTO)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_OPEN_CLOSE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_SYNC)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_BLUETOOTH_BACK)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_BACK)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_KM)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_UNIT_MILE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_CHINESE)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_LANGUAGE_ENGLISH)||
	   (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_SET)) && (Get_ActualVechileSpeed() == 0))
	{
		Menu_Service(MENU_KEY_CONFIRM_SHORT);
	}
	else if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM) || (Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_APP))
	{
		if((BlueToothPhoneData.BlueToothPhoneSate == Phone_Outgoing) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Incoming) || (BlueToothPhoneData.BlueToothPhoneSate == Phone_Talking))
		{
			PackedTransfer_BlueTooth_DataSet(Phone_Hangup_Out);
		}
		else if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_PHONE_CONNECT_APP)||
	    	   ((Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM) && (Get_ActualVechileSpeed() == 0)))
		{
			Menu_Service(MENU_KEY_CONFIRM_SHORT);
		}
		else
		{
			;
		}
	}
	else
	{
		;
	}
}

void Key_Event_LONG_PRESS_1_Right(void)
{
	if((Get_DispVechileSpeed() >= 1990)&&(Get_DispEngineSpeed() >= 12000))
	{
		;
	}
	else
	{
		if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION,MENU_ITEM_PHONE_CONNECT_APP);
		}
		else
		{
			;
		}
	}
	
}

void Key_Event_BackLight_Press_Left(void)
{
	if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_5)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_4)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_3)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_2)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_1)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
	else if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_BACKLIGHT_AUTO)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 1);
	}
}

uint8_t OTA_Update_Flag = 0;
void Get_Into_OTA_Update_Mode(void)
{
	if((Menu_Get_Current_Cursor_Information() == MENU_ITEM_FAULT_INFORMATION) && (Get_ActualVechileSpeed() == 0))
	{
		OTA_Update_Flag = 1U;
	}
}
void KEY_LEFT_EVENT_NONE_Service(void)	
{
	MenuData.Back_Time_Left++;
	if(MenuData.Back_Time_Left > BACK_MENU_TIME)
	{
		MenuData.Back_Time_Left = BACK_MENU_TIME;
		MenuData.Back_Time_Left_Flag = 1;
	}
}

void KEY_RIGHT_EVENT_NONE_Service(void)	
{
	MenuData.Back_Time_Right++;
	if(MenuData.Back_Time_Right > BACK_MENU_TIME)
	{
		MenuData.Back_Time_Right = BACK_MENU_TIME;
		MenuData.Back_Time_Right_Flag = 1;
	}
}

void Key_Clear_Time(void)
{
	// if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	// {
		MenuData.Back_Time_Left = 0;
		// MenuData.Back_Time_Left_Flag = 0;
		// MenuData.Back_Time_Right_Flag = 0;
	// }
	// if(Key_Status_Read_Right() == KEY_REALTIME_PRESS)
	// {
		MenuData.Back_Time_Right = 0;
		MenuData.Back_Time_Left_Flag = 0;
		MenuData.Back_Time_Right_Flag = 0;
	// }
}

uint8_t ClearODO_Flag = 0;
void TYW_RESET_ODO(void)
{
	if(SYS_OPR_STAT_IGN_ON)
    {
        if(ClearODO_Flag < 1)
        {
            if((Get_DispVechileSpeed() >= 1990)&&(Get_DispEngineSpeed() >= 12000)&&((Menu_Get_Current_Cursor_Information() == MENU_ITEM_MAIN_ITEM)))
            {
                ClearODO_Flag = 1;
                Data_Mileage_Clear();
            }
        }
    }
    else
    {
        ClearODO_Flag = 0;
    }
}

void Get_DisTime_Service(void)
{
	if ((Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_TENB_SET) || 
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_HOUR_BIT_SET ) ||
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_TENB_SET ) ||
		(Menu_Get_Current_Cursor_Information() == MENU_ITEM_CLOCK_MIN_BIT_SET  )  )
	    {
	    }
		else
		{
			/* 由于需要不保存时间，需要另外一套计时的方式 */
			RTE_RTC_Get_CounterValue(&counter_val);
	        counter_val.time.RTC_Hours = RTC_Bcd2ToByte(counter_val.time.RTC_Hours);
			MenuData.u8Dis_Hour = counter_val.time.RTC_Hours;
			counter_val.time.RTC_Minutes = RTC_Bcd2ToByte(counter_val.time.RTC_Minutes);
			MenuData.u8Dis_Minute = counter_val.time.RTC_Minutes;
		}
}


void My_Key_Service(void)
{
	/* 自检和OTA界面时不可操作按键 */
	// if((g_u8SelfCheck) && (OTA_Update_Flag == 0))
	if(OTA_Update_Flag == 0)
    {
			Key_Service();
    }
	else
	{
		;
	}
}

uint8_t Get_Dis_Hour_Time(void)
{
	return MenuData.u8Dis_Hour;
}

uint8_t Get_Dis_Minute_Time(void)
{
	return MenuData.u8Dis_Minute;
}

uint8_t Get_Dis_Unit(void)
{
	return MenuData.Unit; //0km,1mile
}

uint8_t Get_Dis_OdoAndTrip(void)
{
	return MenuData.OdoAndTrip; //0Odo,1Trip
}

uint8_t Get_Dis_Bluetooth_Open_Close(void)
{
	return MenuData.Bluetooth_Open_Close; //0开,1关
}

uint8_t Get_Dis_Language(void)
{
	return MenuData.Language; //0中文,1英文
}
