
#include "Menu.h"
#include "Components.h"

/*-------------------Logic_Operation Call Back---------------------*/
uint8_t g_u8Cursor_Posittion;
extern _Menu_Data MenuData;
extern RTC_CounterTypeDef counter_val;

void Menu_Logic_Operation_MAIN_ITEM(Menu_Key_en_t enKeyType);   

void Menu_Logic_Operation_Display_Mode(Menu_Key_en_t enKeyType);   			
void Menu_Logic_Operation_Backlight_Setting(Menu_Key_en_t enKeyType);   	
void Menu_Logic_Operation_Bluetooth_Connect(Menu_Key_en_t enKeyType);   	
void Menu_Logic_Operation_Clock_Setting(Menu_Key_en_t enKeyType);  	  		
void Menu_Logic_Operation_Unit_Setting(Menu_Key_en_t enKeyType);	   		
void Menu_Logic_Operation_Language_Setting(Menu_Key_en_t enKeyType);		
void Menu_Logic_Operation_Fault_Information(Menu_Key_en_t enKeyType);		
void Menu_Logic_Operation_Phone_Connect(Menu_Key_en_t enKeyType);  			
void Menu_Logic_Operation_Quit(Menu_Key_en_t enKeyType);  		

void Menu_Logic_Operation_Select_Daytime(Menu_Key_en_t enKeyType);	   		
void Menu_Logic_Operation_Select_Nighttime(Menu_Key_en_t enKeyType);    	
void Menu_Logic_Operation_Select_Auto(Menu_Key_en_t enKeyType);	  

void Menu_Logic_Operation_Backlight_Auto(Menu_Key_en_t enKeyType);	 		
void Menu_Logic_Operation_Backlight_1(Menu_Key_en_t enKeyType);	      		
void Menu_Logic_Operation_Backlight_2(Menu_Key_en_t enKeyType);        		
void Menu_Logic_Operation_Backlight_3(Menu_Key_en_t enKeyType);	   	   		
void Menu_Logic_Operation_Backlight_4(Menu_Key_en_t enKeyType);		   		
void Menu_Logic_Operation_Backlight_5(Menu_Key_en_t enKeyType);	  

void Menu_Logic_Operation_Bluetooth_Open_Close(Menu_Key_en_t enKeyType);    
void Menu_Logic_Operation_Bluetooth_Sync_Contacts(Menu_Key_en_t enKeyType);	
void Menu_Logic_Operation_Bluetooth_Back(Menu_Key_en_t enKeyType);	

void Menu_Logic_Operation_Clock_Back(Menu_Key_en_t enKeyType); 	      		
void Menu_Logic_Operation_Clock_Min_Bit(Menu_Key_en_t enKeyType);	  		
void Menu_Logic_Operation_Clock_Min_Tenb(Menu_Key_en_t enKeyType);	  		
void Menu_Logic_Operation_Clock_Hour_Bit(Menu_Key_en_t enKeyType);			
void Menu_Logic_Operation_Clock_Hour_Tenb(Menu_Key_en_t enKeyType);	   

void Menu_Logic_Operation_Clock_Hour_Tenb_Set(Menu_Key_en_t enKeyType); 
void Menu_Logic_Operation_Clock_Hour_Bit_Set(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_Clock_Min_Tenb_Set(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_Clock_Min_Bit_Set(Menu_Key_en_t enKeyType);	

void Menu_Logic_Operation_Unit_Km(Menu_Key_en_t enKeyType);	   					
void Menu_Logic_Operation_Unit_Mile(Menu_Key_en_t enKeyType);	   

void Menu_Logic_Operation_Language_Chinese(Menu_Key_en_t enKeyType);   			
void Menu_Logic_Operation_Language_English(Menu_Key_en_t enKeyType);

void Menu_Logic_Operation_Phone_Connect_Set(Menu_Key_en_t enKeyType);  			
void Menu_Logic_Operation_Phone_Connect_App(Menu_Key_en_t enKeyType);

void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat);


void Menu_User_Init(void)
{
	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;
	Menu_Item_Select_Set(MENU_ITEM_SELECT_DAYTIME, 1);
	Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 1);
	Menu_Item_Select_Set(MENU_ITEM_UNIT_KM, 1);
	Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_CHINESE, 1);
	Menu_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
}

void Menu_User_WAKEUP(void)
{
	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;
	Menu_Item_Select_Set(MENU_ITEM_SELECT_DAYTIME, 1);
	Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 1);
	Menu_Item_Select_Set(MENU_ITEM_UNIT_KM, 1);
	Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_CHINESE, 1);
	Menu_Wake_Up_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
}

/*---------------------------------------------------------------------------------------*/
const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{
/*MENU_ITEM_MAIN_ITEM = 0,	    */	{0, MENU_INTF_MAIN_INTF,          	MENU_ITEM_MAX,		 		 	0U,  1U,  1U,  0,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_MODE,                	MENU_JUMP_FIRST,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_MAIN_ITEM              },
/*MENU_ITEM_DISPLAY_MODE,  		*/	{0, MENU_INTF_MODE,          		MENU_ITEM_MAIN_ITEM, 		 	0U,  9U,  1U,  1,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_DISPLAY_MODE,        	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Display_Mode           },
/*MENU_ITEM_BACKLIGHT_SETTING,	*/	{0, MENU_INTF_MODE,            		MENU_ITEM_MAIN_ITEM, 		 	1U,  9U,  1U,  2,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_BACKLIGHT_SETTING,   	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_Setting      },
/*MENU_ITEM_BLUETOOTH_CONNECT,	*/	{0, MENU_INTF_MODE,            		MENU_ITEM_MAIN_ITEM, 		 	2U,  9U,  1U,  3,     MENU_ITEM_MAX, MENU_DIRECTION_TRANSVERSE,   0XFFU, MENU_INTF_BLUETOOTH_CONNECT,   	MENU_JUMP_FIRST,  	    	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Bluetooth_Connect      },
/*MENU_ITEM_CLOCK_SETTING,  	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	3U,  9U,  1U,  4,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       	MENU_JUMP_FIRST,  	    	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Setting          },
/*MENU_ITEM_UNIT_SETTING,	   	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	4U,  9U,  1U,  5,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_UNIT_SETTING,        	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Setting           },
/*MENU_ITEM_LANGUAGE_SETTING,	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	5U,  9U,  1U,  6,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_LANGUAGE_SETTING,    	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_Setting       },
/*MENU_ITEM_FAULT_INFORMATION, 	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	6U,  9U,  1U,  7,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_FAULT_INFORMATION,   	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Fault_Information      },
/*MENU_ITEM_PHONE_CONNECT,  	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	7U,  9U,  1U,  8,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_PHONE_CONNECT,       	MENU_JUMP_SELECT,  			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Phone_Connect          },
/*MENU_ITEM_QUIT,  			 	*/	{0, MENU_INTF_MODE,         		MENU_ITEM_MAIN_ITEM, 		 	8U,  9U,  1U,  9,     MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Quit           		},
/*MENU_ITEM_SELECT_DAYTIME,		*/	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 	0U,  3U,  1U,  10,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Daytime 		},
/*MENU_ITEM_SELECT_NIGHTTIME,   */	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 	1U,  3U,  1U,  11,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Nighttime       },
/*MENU_ITEM_SELECT_AUTO,	    */	{0, MENU_INTF_DISPLAY_MODE,         MENU_ITEM_DISPLAY_MODE, 	 	2U,  3U,  1U,  12,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Select_Auto            },
/*MENU_ITEM_BACKLIGHT_5,	    */	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	0U,  6U,  1U,  13,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_5 	        },
/*MENU_ITEM_BACKLIGHT_4,		*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	1U,  6U,  1U,  14,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_4            },
/*MENU_ITEM_BACKLIGHT_3,	 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	2U,  6U,  1U,  15,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_3            },
/*MENU_ITEM_BACKLIGHT_2,     	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	3U,  6U,  1U,  16,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_2            },
/*MENU_ITEM_BACKLIGHT_1,	 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	4U,  6U,  1U,  17,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_1            },
/*MENU_ITEM_BACKLIGHT_AUTO, 	*/	{0, MENU_INTF_BACKLIGHT_SETTING,    MENU_ITEM_BACKLIGHT_SETTING, 	5U,  6U,  1U,  18,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Backlight_Auto         },
/*MENU_ITEM_BLUETOOTH_OPEN_CLOSE*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 	0U,  3U,  1U,  19,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BLUETOOTH_CONNECT,   	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Bluetooth_Open_Close   },
/*MENU_ITEM_BLUETOOTH_SYNC,		*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 	1U,  3U,  1U,  20,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_BLUETOOTH_CONNECT,   	MENU_JUMP_LAST_POSITION,	0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Bluetooth_Sync_Contacts},
/*MENU_ITEM_BLUETOOTH_BACK,		*/	{0, MENU_INTF_BLUETOOTH_CONNECT,    MENU_ITEM_BLUETOOTH_CONNECT, 	2U,  3U,  1U,  21,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MODE,                	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Bluetooth_Back         },
/*MENU_ITEM_CLOCK_HOUR_TENB,	*/	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     	0U,  5U,  1U,  22,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_HOUR_TENB_SET,     MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Hour_Tenb        },
/*MENU_ITEM_CLOCK_HOUR_BIT,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     	1U,  5U,  1U,  23,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_HOUR_BIT_SET,      MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Hour_Bit         },
/*MENU_ITEM_CLOCK_MIN_TENB,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     	2U,  5U,  1U,  24,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_MIN_TENB_SET,      MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Min_Tenb         },
/*MENU_ITEM_CLOCK_MIN_BIT,	    */	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     	3U,  5U,  1U,  25,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_MIN_BIT_SET,       MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Min_Bit          },
/*MENU_ITEM_CLOCK_BACK, 	  	*/	{0, MENU_INTF_CLOCK_SETTING,        MENU_ITEM_CLOCK_SETTING,     	4U,  5U,  1U,  26,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MODE,       		 		MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Back             },
/*MENU_ITEM_CLOCK_HOUR_TENB_SET,*/	{0, MENU_INTF_CLOCK_HOUR_TENB_SET,  MENU_ITEM_CLOCK_HOUR_TENB_SET,  0U,  1U,  1U,  27,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Hour_Tenb_Set    },
/*MENU_ITEM_CLOCK_HOUR_BIT_SET,	 */	{0, MENU_INTF_CLOCK_HOUR_BIT_SET,   MENU_ITEM_CLOCK_HOUR_BIT_SET,   0U,  1U,  1U,  28,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Hour_Bit_Set     },
/*MENU_ITEM_CLOCK_MIN_TENB_SET,	 */	{0, MENU_INTF_CLOCK_MIN_TENB_SET,   MENU_ITEM_CLOCK_MIN_TENB,       0U,  1U,  1U,  29,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Min_Tenb_Set     },
/*MENU_ITEM_CLOCK_MIN_BIT_SET,	 */	{0, MENU_INTF_CLOCK_MIN_BIT_SET,    MENU_ITEM_CLOCK_MIN_BIT,        0U,  1U,  1U,  30,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_CLOCK_SETTING,       	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Clock_Min_Bit_Set      },
/*MENU_ITEM_UNIT_KM,		    */	{0, MENU_INTF_UNIT_SETTING,         MENU_ITEM_UNIT_SETTING,         0U,  2U,  1U,  31,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Km                },
/*MENU_ITEM_UNIT_MILE,	        */	{0, MENU_INTF_UNIT_SETTING, 		MENU_ITEM_UNIT_SETTING,         1U,  2U,  1U,  32,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Unit_Mile              },
/*MENU_ITEM_LANGUAGE_CHINESE, 	*/	{0, MENU_INTF_LANGUAGE_SETTING, 	MENU_ITEM_LANGUAGE_SETTING,     0U,  2U,  1U,  33,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_Chinese       },
/*MENU_ITEM_LANGUAGE_ENGLISH,	*/	{0, MENU_INTF_LANGUAGE_SETTING, 	MENU_ITEM_LANGUAGE_SETTING,     1U,  2U,  1U,  34,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_SELECT, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Language_English       },
/*MENU_ITEM_PHONE_CONNECT_SET	*/	{0, MENU_INTF_PHONE_CONNECT, 		MENU_ITEM_PHONE_CONNECT,        0U,  1U,  1U,  35,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_PHONE_CONNECT_SET,       MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		MENU_INTF_MAIN_INTF,  MENU_JUMP_FIRST,  Menu_Logic_Operation_Phone_Connect_Set      },
/*MENU_ITEM_PHONE_CONNECT_APP	*/	{0, MENU_INTF_PHONE_CONNECT_SET, 	MENU_ITEM_PHONE_CONNECT_SET,    0U,  1U,  1U,  36,    MENU_ITEM_MAX, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_MAIN_INTF,           	MENU_JUMP_FIRST, 			0XFFU,  MENU_JUMP_FIRST, 		0XFFU,                MENU_JUMP_FIRST,  Menu_Logic_Operation_Phone_Connect_App      },
};

/*-------------------------------------------------------------------------------------------------*/

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

//static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
//static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);
void Menu_Service(Menu_Key_en_t enMenuKey);

/*传入按键动作执行之前需要预先处理的动作*/
// static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
// {

// 	/*预处理中执行过本次按键了，后续不必执行时调用一次*/
// 	/*u8MenuKeyExecute = 0U;*/
// }
/*传入按键动作执行之后需要后置处理的动作*/
// static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
// {
// }

/*------------传入按键类型-----------------------*/
void Menu_Service(Menu_Key_en_t enMenuKey)
{
	/*功能回调函数的调用*/
	Menu_Logic_Process(enMenuKey);
	/*--------------------------------------------------*/
	/*按键动作对光标的处理*/
	//Menu_Cursor_Preprocess(enMenuKey);
	Menu_Cursor_Process(enMenuKey);
	//Menu_Cursor_Postprocess(enMenuKey);
	/*--------------------------------------------------*/
}

/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
/*------------请放在休眠，唤醒之后不会被清除的RAM区域中-------------------------*/
//#pragma ghs section bss = ".myNonInitArea"
Menu_uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
//#pragma ghs section bss = default
/*---------------------------------------*/
/*---------------------------------------*/
/*---------------------------------------*/


void Menu_Logic_Operation_MAIN_ITEM(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_FUNCTION_1_SHORT)//大小计切换
	{
		if(Get_Dis_OdoAndTrip() == 0)
		{
			MenuData.OdoAndTrip = 1;
		}
		else
		{
			MenuData.OdoAndTrip = 0;
		}
	}
}

void Menu_Logic_Operation_Display_Mode(Menu_Key_en_t enKeyType)
{

} 	

void Menu_Logic_Operation_Select_Daytime(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_SELECT_DAYTIME, 1);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_NIGHTTIME, 0);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_AUTO, 0);
		g_u8Display_Mode = ModeDAY;
    	g_u8Display_Mode_select = ModeDAY;
	}
}

void Menu_Logic_Operation_Select_Nighttime(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_SELECT_DAYTIME, 0);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_NIGHTTIME, 1);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_AUTO, 0);
		g_u8Display_Mode = ModeNIGHT;
    	g_u8Display_Mode_select = ModeNIGHT;
	}
}

void Menu_Logic_Operation_Select_Auto(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_SELECT_DAYTIME, 0);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_NIGHTTIME, 0);
		Menu_Item_Select_Set(MENU_ITEM_SELECT_AUTO, 1);
    	g_u8Display_Mode_select = ModeATUO;
	}
}

void Menu_Logic_Operation_Backlight_5(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
}

void Menu_Logic_Operation_Backlight_4(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
}

void Menu_Logic_Operation_Backlight_3(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
}

void Menu_Logic_Operation_Backlight_2(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
}

void Menu_Logic_Operation_Backlight_1(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 1);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 0);
	}
}

void Menu_Logic_Operation_Backlight_Auto(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_5, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_4, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_3, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_2, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_1, 0);
		Menu_Item_Select_Set(MENU_ITEM_BACKLIGHT_AUTO, 1);
	}
}

void Menu_Logic_Operation_Bluetooth_Open_Close(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_BLUETOOTH_OPEN_CLOSE, 1);
		Menu_Item_Select_Set(MENU_ITEM_BLUETOOTH_SYNC, 0);
		Menu_Item_Select_Set(MENU_ITEM_BLUETOOTH_BACK, 0);

		if(Get_Dis_Bluetooth_Open_Close() == 0)
		{
			MenuData.Bluetooth_Open_Close = 1;
		}
		else
		{
			MenuData.Bluetooth_Open_Close = 0;
		}
	}
}

void Menu_Logic_Operation_Bluetooth_Sync_Contacts(Menu_Key_en_t enKeyType)
{

}

void Menu_Logic_Operation_Bluetooth_Back(Menu_Key_en_t enKeyType)
{

}

void Menu_Logic_Operation_Clock_Hour_Tenb(Menu_Key_en_t enKeyType) 
{
	RTE_RTC_Get_CounterValue(&counter_val);
    counter_val.time.RTC_Hours = RTC_Bcd2ToByte(counter_val.time.RTC_Hours);
	counter_val.time.RTC_Minutes = RTC_Bcd2ToByte(counter_val.time.RTC_Minutes);

	MenuData.Dis_Hour_Tenb = counter_val.time.RTC_Hours / 10;
	MenuData.Dis_Hour_Bit = counter_val.time.RTC_Hours % 10;

	MenuData.Dis_Minute_Tenb = counter_val.time.RTC_Minutes / 10;
	MenuData.Dis_Minute_Bit = counter_val.time.RTC_Minutes % 10;
}

void Menu_Logic_Operation_Clock_Hour_Bit(Menu_Key_en_t enKeyType)
{
	// counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    // counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
    // if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	// {
	// 	RTC_SetTime(&counter_val.time);
	// }
}

void Menu_Logic_Operation_Clock_Min_Tenb(Menu_Key_en_t enKeyType)
{
	// counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    // counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
    // if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	// {
	// 	RTC_SetTime(&counter_val.time);
	// }
}

void Menu_Logic_Operation_Clock_Min_Bit(Menu_Key_en_t enKeyType)	
{
	// counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    // counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
    
} 

void Menu_Logic_Operation_Clock_Back(Menu_Key_en_t enKeyType)  
{

}  

void Menu_Logic_Operation_Clock_Hour_Tenb_Set(Menu_Key_en_t enKeyType) 
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;	
	

	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
		datmax = 2u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Dis_Hour_Tenb));
	}

	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    		counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
		RTC_SetTime(&counter_val.time);
	}
}
void Menu_Logic_Operation_Clock_Hour_Bit_Set(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;	
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
		datmax = 9u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Dis_Hour_Bit));
	}

	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    	counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
		RTC_SetTime(&counter_val.time);
	}
}

void Menu_Logic_Operation_Clock_Min_Tenb_Set(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;	
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
		datmax = 5u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Dis_Minute_Tenb));
	}

	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    	counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
		RTC_SetTime(&counter_val.time);
	}
}

void Menu_Logic_Operation_Clock_Min_Bit_Set(Menu_Key_en_t enKeyType)	
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;	
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
		datmax = 9u;
    	datmin = 0u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Dis_Minute_Bit));
	}

	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		counter_val.time.RTC_Hours = (MenuData.Dis_Hour_Tenb*10 + MenuData.Dis_Hour_Bit);
    		counter_val.time.RTC_Minutes = (MenuData.Dis_Minute_Tenb*10 + MenuData.Dis_Minute_Bit);
		RTC_SetTime(&counter_val.time);
	}
} 

void Menu_Logic_Operation_Backlight_Setting(Menu_Key_en_t enKeyType)
{
	
} 	

void Menu_Logic_Operation_Bluetooth_Connect(Menu_Key_en_t enKeyType)
{
 
} 	

void Menu_Logic_Operation_Clock_Setting(Menu_Key_en_t enKeyType)
{
	//RTE_RTC_Get_CounterValue(&counter_val);
    // counter_val.time.RTC_Hours = RTC_Bcd2ToByte(counter_val.time.RTC_Hours);
	// counter_val.time.RTC_Minutes = RTC_Bcd2ToByte(counter_val.time.RTC_Minutes);
} 	

void Menu_Logic_Operation_Unit_Setting(Menu_Key_en_t enKeyType)
{

} 	

void Menu_Logic_Operation_Language_Setting(Menu_Key_en_t enKeyType)
{

} 	

void Menu_Logic_Operation_Fault_Information(Menu_Key_en_t enKeyType)
{

} 

void Menu_Logic_Operation_Phone_Connect(Menu_Key_en_t enKeyType)
{

} 

void Menu_Logic_Operation_Quit(Menu_Key_en_t enKeyType)
{

}	

void Menu_Logic_Operation_Unit_Km(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_UNIT_KM, 1);
		Menu_Item_Select_Set(MENU_ITEM_UNIT_MILE, 0);
		MenuData.Unit = 0;
	}
}

void Menu_Logic_Operation_Unit_Mile(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_UNIT_KM, 0);
		Menu_Item_Select_Set(MENU_ITEM_UNIT_MILE, 1);
		MenuData.Unit = 1;
	}
}

void Menu_Logic_Operation_Language_Chinese(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_CHINESE, 1);
		Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_ENGLISH, 0);
		MenuData.Language = 0;
	}
}

void Menu_Logic_Operation_Language_English(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_CHINESE, 0);
		Menu_Item_Select_Set(MENU_ITEM_LANGUAGE_ENGLISH, 1);
		MenuData.Language = 1;
	}
}

void Menu_Logic_Operation_Phone_Connect_Set(Menu_Key_en_t enKeyType)
{

}

void Menu_Logic_Operation_Phone_Connect_App(Menu_Key_en_t enKeyType)
{

}

void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat)
{
	uint8_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (255u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
                temp = datMin;
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}
			
