#include "Components.h"


uint8_t Pic_mode = PIC_DAYTIME_CH;
uint8_t g_u8Display_Mode = ModeDAY;
uint8_t g_u8Display_Mode_select = ModeDAY;
uint8_t g_u8Language = CH;
uint8_t g_u8Backlight = Backlight_4 ;
uint8_t g_u8Backlight_select = Backlight_4 ;
uint8_t g_u8UnitSetting = Metric ;

uint8_t g_u8SelfCheck = 0;/*自检*/
uint16_t g_u16fuelnumberup = 0;
uint16_t g_u16vspeednumberup = 0;
uint16_t g_u16vspeednumberdown = 300;
uint16_t g_u16espeednumberup = 0;
uint16_t g_u16espeednumberdown = 300;

//自检函数
void AMT630H_GUI_BACKGRAND_SelfCheck(void);
// 菜单背景,菜单前必带
void AMT630H_GUI_BACKGRAND(void);
// 菜单调用函数
void AMT630H_GUI_SETTING(void);
// 一级菜单
void AMT630H_GUI_Quit(void);
void AMT630H_GUI_Phone_Connect(void);
void AMT630H_GUI_Fault_Information(void);
void AMT630H_GUI_FaultCode(uint8_t FaultCodevalid,uint8_t FaultCode_hight,uint8_t FaultCode_mid);
void AMT630H_GUI_Language_Information(void);
void AMT630H_GUI_Unit_Information(void);
void AMT630H_GUI_Display_Mode_Information(void);
void AMT630H_GUI_Backlight_Information(void);
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON);
void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min);
// 二级菜单
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT);       /*时钟设置*/
void AMT630H_GUI_Backlight_Setting(Menu_Item_en_t back_mode);                                                 /*背光设置*/
void AMT630H_GUI_Display_Mode_Setting(Menu_Item_en_t display_mode);                                           /*显示模式*/
void AMT630H_GUI_Bluetooth_Connect_Setting(uint8_t select, uint8_t sync_contacts, uint8_t Connect_ON); /*蓝牙连接*/
void AMT630H_GUI_Unit_Setting(Menu_Interface_en_t select);                                                         /*单位设置*/
void AMT630H_GUI_Language_Setting(Menu_Interface_en_t select);                                                     /*语言设置*/
void AMT630H_GUI_Phone_Connect_Win(void);                                                              /*手机互联*/
void AMT630H_GUI_ReadPosittion_Display(void);
void AMT630H_GUI_Background()
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(g_u8SelfCheck == 1)
        {
            AMT630H_GUI_ReadPosittion_Display();
        }
        else
        {
            AMT630H_GUI_BACKGRAND_SelfCheck();
        }
        
    }
    else
    {
        ;
    }
}

/***********************************************一级菜单*******************************************/
/**
 * @brief 故障信息 一级菜单
 * @param[in] //暂无
 */
void AMT630H_GUI_Fault_Information(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0163_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0164_913_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0165_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0155_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0166_445_517);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0091_567_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0167_341_354);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0093_574_292);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0168_350_290);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0169_353_227);/*历史故障*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0170_354_162);/*当前故障*/
            AMT630H_GUI_FaultCode(Get_FaultCode_Valid(),Get_Current_Hight_FaultCode(),Get_Current_Mid_FaultCode());
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0088_47_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0084_869_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0089_193_488);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0086_762_487);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0090_435_519);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0091_567_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0092_368_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0093_574_292);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0094_375_292);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0096_338_228);/*Fault history*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0097_334_163);/*current fault*/
            AMT630H_GUI_FaultCode(Get_FaultCode_Valid(),Get_Current_Hight_FaultCode(),Get_Current_Mid_FaultCode());
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0900_610_229);//夜间 历史故障P
        SetPagePic(GRAPHICS_PAGE_0, Pic_0900_610_164);//夜间 当前故障P
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0350_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0351_913_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0352_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0342_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0353_445_517);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0279_567_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0354_341_354);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0281_574_292);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0355_350_290);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0356_353_227);/*历史故障*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0357_354_162);/*当前故障*/
            AMT630H_GUI_FaultCode(Get_FaultCode_Valid(),Get_Current_Hight_FaultCode(),Get_Current_Mid_FaultCode());
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0274_47_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0275_916_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0276_193_488);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0277_728_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_435_519);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0279_567_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0280_368_356);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0281_574_292);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0282_375_292);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0284_338_228);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0285_334_163);
            AMT630H_GUI_FaultCode(Get_FaultCode_Valid(),Get_Current_Hight_FaultCode(),Get_Current_Mid_FaultCode());
        }
    }
}


static uint16_t NumbeList_FaultCode_day[]={
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289,
};
static uint16_t NumbeList_FaultCode_night[]={
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289,
};


/*故障码显示函数*/
static void AMT630H_GUI_FaultCode(uint8_t FaultCodevalid,uint8_t FaultCode_hight,uint8_t FaultCode_mid)
{
    /*数字只有两组 历史故障和故障信息纵坐标不同*/
    DISPLAY_NUM_ST DisplayNumPara;
    uint16_t frontnumber;
    uint16_t midnumber;
    frontnumber = FaultCode_hight;
    midnumber = FaultCode_mid;
    if(FaultCodevalid == 1)
    {
        if(g_u8Display_Mode == ModeDAY)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0876_639_293, 610, 164);//当前故障码的P
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0876_639_293, 610, 229);//历史故障码的P
            /*当前故障码前两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_day;
            DisplayNumPara.x = 639;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 164;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, frontnumber);
            /*当前故障码后两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_day;
            DisplayNumPara.x = 667;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 164;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, midnumber);
            /*历史故障码前两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_day;
            DisplayNumPara.x = 639;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 229;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, frontnumber);
            /*历史故障码后两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_day;
            DisplayNumPara.x = 667;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 229;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, frontnumber);
        }
        else if(g_u8Display_Mode == ModeNIGHT)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0912_639_293, 610, 175);//当前故障码的P
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0912_639_293, 610, 240);//历史故障码的P
            /*当前故障码前两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_night;
            DisplayNumPara.x = 639;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 164;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, frontnumber);
            /*当前故障码后两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_night;
            DisplayNumPara.x = 667;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 164;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, midnumber);
            /*历史故障码前两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_night;
            DisplayNumPara.x = 639;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 229;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, frontnumber);
            /*历史故障码后两位显示*/
            DisplayNumPara.NumList = NumbeList_FaultCode_night;
            DisplayNumPara.x = 667;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.y = 229;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, midnumber);
        }
    }
    else
    {
        if(g_u8Display_Mode == ModeDAY)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0926_619_240, 610, 175);
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0926_619_240, 610, 240);
        }
        else if(g_u8Display_Mode == ModeNIGHT)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0927_619_175, 610, 175);
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0927_619_175, 610, 240);
        }
        else
        {
            ;
        }
    }   
}
/**
 * @brief 显示模式信息 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Display_Mode_Information()
{
    if (g_u8Display_Mode_select == ModeDAY)
    {
       if(g_u8Language == CH)/*日间中文*/
       {
           SetPagePic(GRAPHICS_PAGE_0, Pic_0190_27_396);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0191_903_396);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0161_207_485);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0185_737_485);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0192_445_517);
    
           SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_256);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0149_448_101);
       }
       else if(g_u8Language == EN)/*日间英文*/
       {
           SetPagePic(GRAPHICS_PAGE_0, Pic_0123_18_397);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0124_898_397);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0086_222_487);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0125_729_486);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0126_415_519);
           
           SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_257);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0074_422_103);     
       }
    }
    else if(g_u8Display_Mode_select == ModeNIGHT)
    {
       if(g_u8Language == CH)/*夜间中文*/
       {
           SetPagePic(GRAPHICS_PAGE_0, Pic_0377_27_396);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0378_903_396);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0348_207_485);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0372_737_485);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0379_445_517);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0339_434_232);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
       }
       else if(g_u8Language == EN)/*夜间英文*/
       {
           SetPagePic(GRAPHICS_PAGE_0, Pic_0311_18_397);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0312_898_397);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0272_222_487);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0313_729_486);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0314_415_519);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0263_414_234);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
       }
    } 
    else if(g_u8Display_Mode_select == ModeATUO)
    {
        if(g_u8Display_Mode == ModeDAY)
        {
            if(g_u8Language == CH)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);/*下方菜单*/
                SetPagePic(GRAPHICS_PAGE_0, Pic_0150_448_343);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_231);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
            }
            else if(g_u8Language == EN)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0071_18_397);/*下方菜单*/
                SetPagePic(GRAPHICS_PAGE_0, Pic_0075_409_345);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_232);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);
            }
        }
        else if(g_u8Display_Mode == ModeNIGHT)
        {
            if(g_u8Language == CH)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0337_448_343);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_231);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
            }
            else if(g_u8Language == EN)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0257_18_397);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0261_409_345);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0259_456_232);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
            }
        }
    }
}


/**
 * @brief 背光设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Backlight_Information(void)
{
    /*日间中文*/
    if (g_u8Display_Mode == ModeDAY)/*日间模式下*/
    {
        /*语言*/
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0187_37_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0188_904_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0156_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0181_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0189_446_517);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0118_52_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0119_891_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0120_174_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0121_732_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0122_436_519);
        }
        /*背光等级选择*/
        if(g_u8Backlight_select == Backlight_5)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0063_495_145);
        }
        else if(g_u8Backlight_select == Backlight_4)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0064_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
        }
        else if(g_u8Backlight_select == Backlight_3)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0066_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
        }
        else if(g_u8Backlight_select == Backlight_2)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0067_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
        }
        else if(g_u8Backlight_select == Backlight_1)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
        }
        else if(g_u8Backlight_select == Backlight_ATUO)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_136);
            if(g_u8Language == CH)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0145_477_340);   
            }
            else if(g_u8Language == EN )
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0070_466_342);
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0374_37_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0375_904_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0343_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0368_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0376_446_517);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0306_52_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0307_891_398);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0308_174_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0309_732_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0310_436_519);
        }
        /*背光等级选择*/
        if(g_u8Backlight_select == Backlight_5)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0249_495_145);
        }
        else if(g_u8Backlight_select == Backlight_4)
        {
           SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0250_493_190);
           SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
        }
        else if(g_u8Backlight_select == Backlight_3)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0252_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
        }
        else if(g_u8Backlight_select == Backlight_2)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0253_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
        }
        else if(g_u8Backlight_select == Backlight_1)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
        }
        else if(g_u8Backlight_select == Backlight_ATUO)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_136);
            if(g_u8Language == CH)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0332_477_340);
            }
            else if(g_u8Language == EN )
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0256_466_342);
            }
        }
    }
}

static uint16_t Bluetooth_num_day[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};
static uint16_t Bluetooth_num_night[] = {
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289,
};
/**
 * @brief 蓝牙连接 一级菜单
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0137_26_396);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163);

            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
            }
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0034_14_397);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_348);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0037_376_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0054_377_227);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0056_377_166);
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0053_573_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0052_574_226);
            }
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0325_26_396);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_345);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0326_369_287);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0329_367_226);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0330_367_163);
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0327_584_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0328_584_226);
            }
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0222_14_397);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_348);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0237_376_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0240_377_227);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0242_377_166);

            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0239_573_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0238_574_226);
            }
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
    }
}

static uint16_t Time_num_day[] = {
    Pic_0022_550_211,
    Pic_0023_564_211,
    Pic_0024_550_211,
    Pic_0025_552_211,
    Pic_0026_548_211,
    Pic_0027_550_211,
    Pic_0028_551_211,
    Pic_0029_549_211,
    Pic_0030_550_211,
    Pic_0031_551_211,
};
static uint16_t Time_num_night[] = {
    Pic_0210_550_211,
    Pic_0211_564_211,
    Pic_0212_550_211,
    Pic_0213_552_211,
    Pic_0214_548_211,
    Pic_0215_550_211,
    Pic_0216_551_211,
    Pic_0217_549_211,
    Pic_0218_550_211,
    Pic_0219_551_211,
};
/**
 * @brief 时钟设置 一级菜单
 * @param[in]  Clock_Hour  小时
 * @param[in]  Clock_Min   分钟
 */
void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min)
{
    DISPLAY_NUM_ST DisplayNumPara;
    uint8_t Clock_HourNumber;
    uint8_t Clock_MinNumber;
    Clock_HourNumber = Clock_Hour;
    Clock_MinNumber = Clock_Min;

    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0135_27_396);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);/*返回*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);/* ： */
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0017_19_397);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_341);/*return*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);/* ： */
        }
         
        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0323_27_396);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_338);/*返回*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);/* ： */
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0206_19_397);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_341);/*return*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);/* ： */
        }
        
        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
}

/**
 * @brief 单位设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Unit_Information(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0130_27_396);/*组*/
            if(g_u8UnitSetting == Metric)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
            } 
            else if(g_u8UnitSetting == Imperial)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0131_435_272);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0132_474_168);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0012_22_397);/*组*/
            if(g_u8UnitSetting == Metric)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0015_469_289);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0016_457_155);
            }
            else if(g_u8UnitSetting == Imperial)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0013_437_274);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0014_481_170);
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0318_27_396);
            if(g_u8UnitSetting == Metric)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
            }
            else if(g_u8UnitSetting == Imperial)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0319_435_272);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0320_474_168);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0201_22_397);
            if(g_u8UnitSetting == Metric)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0204_469_289);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0205_457_155);
            }
            else if(g_u8UnitSetting == Imperial)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0202_437_274);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0203_481_170);
            }
        }
    }
}

/**
 * @brief 语言设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Language_Information(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0129_28_396);/*组*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0006_14_397);/*组*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0317_28_396);/*组*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0196_14_397);/*组*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
        }
    }
}


/**
 * @brief 手机互联 一级菜单
 *
 */
void AMT630H_GUI_Phone_Connect(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0158_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0159_903_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0160_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0161_747_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0162_445_517);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0083_23_399);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0084_869_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0085_188_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0086_762_487);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0087_435_519);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0005_304_155);
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0345_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0346_903_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0347_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0348_747_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0349_445_517);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0269_23_399);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0270_869_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0271_188_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0272_762_487);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0273_435_519);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0195_304_155);
        }
    }
}

/**
 * @brief 退出 一级菜单
 * @param[in]  null
 */
void AMT630H_GUI_Quit(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0153_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0154_903_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0155_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0156_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0157_461_517);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0078_18_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0079_895_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0080_188_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0081_714_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0082_481_519);
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0340_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0341_903_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0342_197_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0343_737_485);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0344_461_517);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0264_18_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0265_895_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0266_188_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0267_714_486);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0268_481_519);
        }
    }
}

/***********************************************二级菜单*******************************************/
static uint16_t time_num_day[] = {
    Pic_0022_550_211,
    Pic_0023_564_211,
    Pic_0024_550_211,
    Pic_0025_552_211,
    Pic_0026_548_211,
    Pic_0027_550_211,
    Pic_0028_551_211,
    Pic_0029_549_211,
    Pic_0030_550_211,
    Pic_0031_551_211
};
static uint16_t time_num_night[] = {
    Pic_0210_550_211,
    Pic_0211_564_211,
    Pic_0212_550_211,
    Pic_0213_552_211,
    Pic_0214_548_211,
    Pic_0215_550_211,
    Pic_0216_551_211,
    Pic_0217_549_211,
    Pic_0218_550_211,
    Pic_0219_551_211
};
/**
 * @brief 时间设
        置 二级菜单
 * @param[in]  Clock_Hour  小时
 * @param[in]  Clock_Min   分钟
 * @param[in]  Clock_BIT   选中位数 5选中返回
 */
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);/* ： */
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0135_27_396);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);/*key 返回*/
            switch (Clock_BIT)
            {
            case MENU_ITEM_CLOCK_HOUR_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_BACK:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/  
                Menu_Logic_Operation_Clock_Hour_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_455_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Hour_Bit_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_525_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_572_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Bit_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            default:
                break;
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0017_19_397);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_341);/*return*/
            switch (Clock_BIT)
            {
            case MENU_ITEM_CLOCK_HOUR_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_BACK:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/  
                Menu_Logic_Operation_Clock_Hour_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_455_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Hour_Bit_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_525_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_572_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Bit_Set(MENU_KEY_CONFIRM_SHORT);
            default:
                break;
            }
        }

        /*display time*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;
        /*Data processing*/
        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 455;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);
        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 572;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);/* ： */
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0323_27_396);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_338);/*return*/
            switch (Clock_BIT)
            {
            case MENU_ITEM_CLOCK_HOUR_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_BACK:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/  
                Menu_Logic_Operation_Clock_Hour_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_455_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Hour_Bit_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_525_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_572_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Bit_Set(MENU_KEY_CONFIRM_SHORT);
            default:
                break;
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0206_19_397);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_341);/*return*/
            switch (Clock_BIT)
            {
            case MENU_ITEM_CLOCK_HOUR_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_TENB:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_MIN_BIT:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_BACK:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335);/*cursor*/
                break;
            case MENU_ITEM_CLOCK_HOUR_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/  
                Menu_Logic_Operation_Clock_Hour_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_HOUR_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_455_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Hour_Bit_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_TENB_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_525_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Tenb_Set(MENU_KEY_CONFIRM_SHORT);
                break;
            case MENU_ITEM_CLOCK_MIN_BIT_SET:
                /*Cursor blinking*/
                if(FLASH_SYNC_1Hz)
                {
                    SetPagePic(GRAPHICS_PAGE_0,Pic_0020_572_209);
                }
                else
                {
                    ;
                }
                /*Digital changes*/
                Menu_Logic_Operation_Clock_Min_Bit_Set(MENU_KEY_CONFIRM_SHORT);
            default:
                break;
            }
        }
        /*display time*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;
        /*data processing*/
        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 455;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);
        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 572;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
}

/**
 * @brief 显示模式设置 二级菜单
 * @param[in]  back_mode  显示模式 0为日间 1为夜间 2为自动
 */

void AMT630H_GUI_Display_Mode_Setting(Menu_Item_en_t display_mode) /*图 显示模式*/
{
    if(g_u8Display_Mode == ModeDAY)
    {
        switch (display_mode)
        {
            case MENU_ITEM_SELECT_DAYTIME:
                if(g_u8Language == CH)/*处于日间模式 进入显示模式设置 ：中文 光标选中日间模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_256);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0149_448_101);
                }   
                else if(g_u8Language == EN)/*处于日间模式 进入显示模式设置 ：英文 光标选中日间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0071_18_397);/*组*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_257);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0074_422_103);
                }
                // if(Menu_Item_Select_Get(MENU_ITEM_SELECT_DAYTIME) == 1)
                // {
                //     g_u8Display_Mode = ModeDAY;
                //     g_u8Display_Mode_select = ModeDAY;
                // }
                // else
                // {
                //     ;
                // }
                break;
            case MENU_ITEM_SELECT_NIGHTTIME:
                if(g_u8Language == CH)/*处于日间模式 进入显示模式设置 ：中文 光标选中夜间模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0152_434_232);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
                }   
                else if(g_u8Language == EN)/*处于日间模式 进入显示模式设置 ：英文 光标选中夜间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0071_18_397);/*组*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);/*光标*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0077_414_234);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);
                }
                // if(Menu_Item_Select_Get(MENU_ITEM_SELECT_NIGHTTIME) == 1)
                // {
                //     g_u8Display_Mode = ModeNIGHT;
                //     g_u8Display_Mode_select = ModeNIGHT;
                // }
                // else
                // {
                //     ;
                // }
                break;
            case MENU_ITEM_SELECT_AUTO:
                if(g_u8Language == CH)/*处于日间模式 进入显示模式设置 ：中文 光标选中自动模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0150_448_343);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_231);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
                }   
                else if(g_u8Language == EN)/*处于日间模式 进入显示模式设置 ：英文 光标选中夜间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0071_18_397);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0075_409_345);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_232);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);
                }
                if(Menu_Item_Select_Get(MENU_ITEM_SELECT_AUTO) == 1)
                {
                    // g_u8Display_Mode_select = ModeATUO;
                    if(LightR_Status == 0)
                    {
                        g_u8Display_Mode = ModeNIGHT;
                    }
                    else if(LightR_Status == 1)
                    {
                        g_u8Display_Mode = ModeDAY;
                    }
                }
                else
                {
                    ;
                }
                break;
            default:
                break;
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        switch (display_mode)
        {
            case MENU_ITEM_SELECT_DAYTIME:
                if(g_u8Language == CH)/*处于夜间模式 进入显示模式设置 ：中文 光标选中日间模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_256);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0336_448_101);

                }   
                else if(g_u8Language == EN)/*处于夜间模式 进入显示模式设置 ：英文 光标选中日间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0257_18_397);/*组*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0259_456_257);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0260_422_103);
                }
                if(Menu_Item_Select_Get(MENU_ITEM_SELECT_DAYTIME) == 1)
                {
                    g_u8Display_Mode = ModeDAY;
                    g_u8Display_Mode_select = ModeDAY;
                }
                else
                {
                    ;
                }
                break;

            case MENU_ITEM_SELECT_NIGHTTIME:
                if(g_u8Language == CH)/*处于夜间模式 进入显示模式设置 ：中文 光标选中夜间模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0339_434_232);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
                }   
                else if(g_u8Language == EN)/*处于夜间模式 进入显示模式设置 ：英文 光标选中夜间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0257_18_397);/*组*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);/*光标*/
                    
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0263_414_234);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
                }
                if(Menu_Item_Select_Get(MENU_ITEM_SELECT_NIGHTTIME) == 1)
                {
                    g_u8Display_Mode = ModeNIGHT;
                    g_u8Display_Mode_select = ModeNIGHT;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_SELECT_AUTO:
                if(g_u8Language == CH)/*处于夜间模式 进入显示模式设置 ：中文 光标选中自动模式*/
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0337_448_343);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_231);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
                }   
                else if(g_u8Language == EN)/*处于夜间模式 进入显示模式设置 ：英文 光标选中夜间模式*/
                {   
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0257_18_397);/*组*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);/*光标*/

                    SetPagePic(GRAPHICS_PAGE_0, Pic_0261_409_345);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0259_456_232);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
                }
                if(Menu_Item_Select_Get(MENU_ITEM_SELECT_AUTO) == 1)
                {
                    g_u8Display_Mode_select = ModeATUO;
                    if(LightR_Status == 0)
                    {
                        g_u8Display_Mode = ModeNIGHT;
                    }
                    else if(LightR_Status == 1)
                    {
                        g_u8Display_Mode = ModeDAY;
                    }
                }
                else
                {
                    ;
                }
                break;
            default:
                break;
        }
    }
    else
    {
        ;
    }
}


/**
 * @brief 背光设置 二级菜单
 * @param[in]  back_mode  背光模式 0为自动
 */
void AMT630H_GUI_Backlight_Setting(Menu_Item_en_t back_mode) /*图 背光*/
{
    if(g_u8Display_Mode == ModeDAY)/*日间模式*/
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0144_37_396);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0057_52_398);
        }

        switch (back_mode)
        {
            case MENU_ITEM_BACKLIGHT_5:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_138);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_219);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0063_495_145);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_5))
                {
                    g_u8Backlight = Backlight_5 ;
                    g_u8Backlight_select =Backlight_5 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_4:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_183);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0064_493_190);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_4))
                {
                    g_u8Backlight = Backlight_4 ;
                    g_u8Backlight_select =Backlight_4 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_3:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_229);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0066_496_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_3))
                {
                    g_u8Backlight = Backlight_3 ;
                    g_u8Backlight_select =Backlight_3 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_2:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_274);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0067_495_281);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_2))
                {
                    g_u8Backlight = Backlight_2 ;
                    g_u8Backlight_select =Backlight_2 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_1:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_325);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_1))
                {
                    g_u8Backlight = Backlight_1 ;
                    g_u8Backlight_select =Backlight_1 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_AUTO:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_332);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_286);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_136);
                if(g_u8Language == CH)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0145_477_340);   
                }
                else if(g_u8Language == EN )
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0070_466_342);
                }
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_AUTO))
                {
                    g_u8Backlight_select = Backlight_ATUO ;
                    if(Backlight_SetPwmLevel() == 5)
                    {
                        g_u8Backlight = Backlight_5;
                    }
                    else if(Backlight_SetPwmLevel() == 4)
                    {
                        g_u8Backlight = Backlight_4;
                    }
                    else if(Backlight_SetPwmLevel() == 3)
                    {
                        g_u8Backlight = Backlight_3;
                    }
                    else if(Backlight_SetPwmLevel() == 2)
                    {
                        g_u8Backlight = Backlight_2;
                    }
                    else if(Backlight_SetPwmLevel() == 1)
                    {
                        g_u8Backlight = Backlight_1;
                    }
                    else
                    {
                        ;
                    }
                }
                else
                {
                    ;
                }
                break;
            default:
                break;
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0331_37_396);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0243_52_398);
        }

        switch (back_mode)
        {
            case MENU_ITEM_BACKLIGHT_5:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_138);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_219);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0249_495_145);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_5))
                {
                    g_u8Backlight = Backlight_5 ;
                    g_u8Backlight_select = Backlight_5 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_4:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_183);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0250_493_190);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_4))
                {
                    g_u8Backlight = Backlight_4 ;
                    g_u8Backlight_select = Backlight_4 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_3:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_229);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0252_496_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_3))
                {
                    g_u8Backlight = Backlight_3 ;
                    g_u8Backlight_select = Backlight_3 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_2:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_274);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0253_495_281);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_2))
                {
                    g_u8Backlight = Backlight_2 ;
                    g_u8Backlight_select = Backlight_2 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_1:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_325);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_1))
                {
                    g_u8Backlight = Backlight_1 ;
                    g_u8Backlight_select = Backlight_1 ;
                }
                else
                {
                    ;
                }
                break;
            case MENU_ITEM_BACKLIGHT_AUTO:
                SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_332);

                SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_286);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_236);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_186);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_136);
                if(g_u8Language == CH)
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0332_477_340);
                }
                else if(g_u8Language == EN )
                {
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0256_466_342);
                }
                /*记忆选择*/
                if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_AUTO))
                {
                    g_u8Backlight_select = Backlight_ATUO ;
                    if(Backlight_SetPwmLevel() == 5)
                    {
                        g_u8Backlight = Backlight_5;
                    }
                    else if(Backlight_SetPwmLevel() == 4)
                    {
                        g_u8Backlight = Backlight_4;
                    }
                    else if(Backlight_SetPwmLevel() == 3)
                    {
                        g_u8Backlight = Backlight_3;
                    }
                    else if(Backlight_SetPwmLevel() == 2)
                    {
                        g_u8Backlight = Backlight_2;
                    }
                    else if(Backlight_SetPwmLevel() == 1)
                    {
                        g_u8Backlight = Backlight_1;
                    }
                    else
                    {
                        ;
                    }
                }
                else
                {
                    ;
                }
                break;
        }
    }
}

static uint16_t Bluetooth_Connect_num_day[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};

static uint16_t Bluetooth_Connect_num_night[] = {
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289};
/**
 * @brief 蓝牙连接 二级菜单
 * @param[in]  select  0为选择蓝牙连接 1选择同步联系人 2选择返回
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Connect_Setting(Menu_Item_en_t select, uint8_t sync_contacts, uint8_t Connect_ON)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0137_26_396);  /*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345); /*返回*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287); /*同步联系人*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226); /*蓝牙连接*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165); /*HI3EA0*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163); /*蓝牙名称*/

            switch (select)
            {
                case MENU_ITEM_BLUETOOTH_OPEN_CLOSE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);/*蓝牙连接 光标*/
                    break;
                case MENU_ITEM_BLUETOOTH_SYNC:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);/*同步联系人 光标*/
                    break;
                case MENU_ITEM_BLUETOOTH_BACK:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);/*返回 光标*/
                    break;
                default:
                    break; 
            }
            /*蓝牙开关*/
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
            }

            /*同步联系人*/
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0034_14_397);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_348);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0037_376_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0054_377_227);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0056_377_166);
            switch (select)
            {
                case MENU_ITEM_BLUETOOTH_OPEN_CLOSE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);/*蓝牙连接 光标*/
                    
                    break;
                case MENU_ITEM_BLUETOOTH_SYNC:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);/*同步联系人 光标*/
                    
                    break;
                case MENU_ITEM_BLUETOOTH_BACK:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);/*返回 光标*/
                    break;
                default:
                    break;
            }
            /*蓝牙连接*/    
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0053_573_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0052_574_226);
            }

            /*蓝牙联系人*/
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_day;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0325_26_396);/*下方菜单*/
            SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_345);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0326_369_287);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0329_367_226);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0330_367_163);
            switch (select)
            {
                case MENU_ITEM_BLUETOOTH_OPEN_CLOSE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);/*蓝牙连接 光标*/
                    break;
                case MENU_ITEM_BLUETOOTH_SYNC:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);/*同步联系人 光标*/
                    break;
                case MENU_ITEM_BLUETOOTH_BACK:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);/*返回 光标*/
                    break;
                default:
                    break;
            }

            /*蓝牙连接*/
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0327_584_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0328_584_226);
            }

            /*蓝牙联系人选择*/
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0223_590_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0224_583_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0222_14_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_348);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0237_376_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0240_377_227);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0242_377_166);
            switch (select)
            {
                case MENU_ITEM_BLUETOOTH_OPEN_CLOSE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);/*蓝牙连接 光标*/ 
                    break;
                case MENU_ITEM_BLUETOOTH_SYNC:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);/*同步联系人 光标*/
                    
                    break;
                case MENU_ITEM_BLUETOOTH_BACK:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);/*返回 光标*/
                    break;
                default:
                    break;
            }

            /*蓝牙连接*/
            if (Connect_ON == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0239_573_226);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0238_574_226);
            }

            /*蓝牙联系人选择*/
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t sync_contactsNumber;
            sync_contactsNumber = sync_contacts;
            if (sync_contacts < 10)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0223_590_287);
                DisplayNumPara.NumList = Bluetooth_Connect_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 604;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 1;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0224_583_287);
                DISPLAY_NUM_ST DisplayNumPara;
                uint8_t ArrivalNumber;
                ArrivalNumber = sync_contacts;
                DisplayNumPara.NumList = Bluetooth_Connect_num_night;
                DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
                DisplayNumPara.x = 612;
                DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
                DisplayNumPara.DecimalNum = 0;
                DisplayNumPara.MinDigits = 2;
                DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
            }
        }
    }
}


/**
 * @brief 单位设置 二级菜单
 * @param[in]  select  0为公制 1为英制
 */
void AMT630H_GUI_Unit_Setting(Menu_Interface_en_t select) /*图 单位设置*/
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0130_27_396);/*组*/
            switch (select)
            {
                case MENU_ITEM_UNIT_KM:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_KM) == 1)
                    {
                       g_u8UnitSetting = Metric;
                    }
                    break;
                case MENU_ITEM_UNIT_MILE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0131_435_272);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0132_474_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_MILE) == 1)
                    {
                        g_u8UnitSetting = Imperial;
                    }
                default:
                    break;
            }
        } 
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0012_22_397);/*组*/
            switch (select)
            {
                case MENU_ITEM_UNIT_KM:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0015_469_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0016_457_155);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_KM) == 1)
                    {
                        g_u8UnitSetting = Metric;
                    }
                    break;
                case MENU_ITEM_UNIT_MILE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0013_437_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0014_481_170);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_MILE) == 1)
                    {
                        g_u8UnitSetting = Imperial;
                    }
                default:
                    break;
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_27_396);/*组*/
        if(g_u8Language == CH)
        {
            switch (select)
            {
                case MENU_ITEM_UNIT_KM:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_KM) == 1)
                    {
                        g_u8UnitSetting = Metric;
                    }
                    break;
                case MENU_ITEM_UNIT_MILE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0319_435_272);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0320_474_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_MILE) == 1)
                    {
                        g_u8UnitSetting = Imperial;
                    }
                default:
                    break;
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0201_22_397);/*组*/
            switch (select)
            {
                case MENU_ITEM_UNIT_KM:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0204_469_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0205_457_155);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_KM) == 1)
                    {
                        g_u8UnitSetting = Metric;
                    }
                    break;
                case MENU_ITEM_UNIT_MILE:
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0202_437_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0203_481_170);
                    if(Menu_Item_Select_Get(MENU_ITEM_UNIT_MILE) == 1)
                    {
                        g_u8UnitSetting = Imperial;
                    }
                default:
                    break;
            }
        }
    }
}

/**
 * @brief 语言设置 二级菜单
 * @param[in]  select  0为中文 1为英文
 */
void AMT630H_GUI_Language_Setting(Menu_Interface_en_t select) /*图 语言设置*/
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0129_28_396);/*下方菜单*/
            switch (select)
            {
                case MENU_ITEM_LANGUAGE_CHINESE:/*在日间模式中文下  光标选择中文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_CHINESE) == 1)
                    {
                        g_u8Language = CH;
                    }
                    else
                    {
                        ;
                    }
                    break;
                case MENU_ITEM_LANGUAGE_ENGLISH:/*在日间模式中文下  光标选择英文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_ENGLISH) == 1)
                    {
                        g_u8Language = EN;
                    }
                    else
                    {
                        ;
                    }
                    break;
                default:
                    break;
            }
        }
        else if(g_u8Language == EN)/*在日间英文模式下*/
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0006_14_397);/*下方菜单*/
            switch (select)
            {
                case MENU_ITEM_LANGUAGE_CHINESE:/*在日间英文模式下  选择中文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_CHINESE) == 1)
                    {
                        g_u8Language = CH;
                    }
                    else
                    {
                        ;
                    }
                    break;
                case MENU_ITEM_LANGUAGE_ENGLISH:/*在日间英文模式下  选择英文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_ENGLISH) == 1)
                    {
                        g_u8Language = EN;
                    }
                    else
                    {
                        ;
                    }
                    break;
                default:
                    break;
            }
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0317_28_396);/*下方菜单*/
            switch (select)
            {
                case MENU_ITEM_LANGUAGE_CHINESE:/*在夜间中文模式下  光标选择中文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_CHINESE) == 1)
                    {
                        g_u8Language = CH;
                    }
                    else
                    {
                        ;
                    }
                    break;
                case MENU_ITEM_LANGUAGE_ENGLISH:/*在夜间英文模式下  光标选择英文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_ENGLISH) == 1)
                    {
                        g_u8Language = EN;
                    }
                    else
                    {
                        ;
                    }
                    break;
                default:
                    break;
            }
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0196_14_397);/*下方菜单*/
            switch (select)
            {
                case MENU_ITEM_LANGUAGE_CHINESE:/*在夜间英文模式下  选择中文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_CHINESE) == 1)
                    {
                        g_u8Language = CH;
                    }
                    else
                    {
                        ;
                    }
                    break;
                case MENU_ITEM_LANGUAGE_ENGLISH:/*在夜间英文模式下  选择英文*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);/*光标*/
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
                    SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
                    if(Menu_Item_Select_Get(MENU_ITEM_LANGUAGE_ENGLISH) == 1)
                    {
                        g_u8Language = EN;
                    }
                    else
                    {
                        ;
                    }
                    break;
                default:
                    break;
            }
        }
    } 
}
    


/**
 * @brief 手机互联成功 二级菜单
 * @param[in]  NULL
 */
void AMT630H_GUI_Phone_Connect_Win(void)
{
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0127_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0003_23_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0005_304_155);
        }
        else
        {
            ;
        }
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0315_27_396);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0194_23_397);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0195_304_155);
        }
        else
        {
            ;
        }
    }
}

/**************************************主界面************************************/
static const uint16_t NumbeList_TIME_DAY[] = {
    Pic_0523_950_491,
    Pic_0524_957_491,
    Pic_0525_951_491,
    Pic_0526_952_491,
    Pic_0527_950_491,
    Pic_0528_951_491,
    Pic_0529_951_491,
    Pic_0530_950_491,
    Pic_0531_951_491,
    Pic_0532_951_491,
    Pic_0533_959_511,
    Pic_0534_953_501,
};
static const uint16_t NumbeList_TIME_NIGHT[] = {
    Pic_0635_950_491,
    Pic_0636_957_491,
    Pic_0637_951_491,
    Pic_0638_952_491,
    Pic_0639_950_491,
    Pic_0640_951_491,
    Pic_0641_951_491,
    Pic_0642_950_491,
    Pic_0643_951_491,
    Pic_0644_951_491,
    Pic_0645_959_511,
    Pic_0646_953_501,
};
static const uint16_t NumbeList_Telephone[] = {
    Pic_0536_54_499,
    Pic_0537_55_499,
    Pic_0538_54_499,
    Pic_0539_54_499,
    Pic_0540_54_499,
    Pic_0541_54_499,
    Pic_0542_55_499,
    Pic_0543_54_499,
    Pic_0544_54_499,
    Pic_0545_54_499,
    Pic_0546_58_514,
    Pic_0547_57_510,
};
static const uint16_t NumbeList_Voltage_DAY[] = {
    Pic_0565_943_451,
    Pic_0567_948_451,
    Pic_0568_944_451,
    Pic_0569_944_451,
    Pic_0570_943_451,
    Pic_0571_943_451,
    Pic_0572_944_451,
    Pic_0573_943_451,
    Pic_0574_943_451,
    Pic_0575_944_451,
    Pic_0566_949_465,
    Pic_0576_945_458,
};
static const uint16_t NumbeList_Voltage_NIGHT[] = {
    Pic_0673_943_451,
    Pic_0675_948_451,
    Pic_0676_944_451,
    Pic_0677_944_451,
    Pic_0678_943_451,
    Pic_0679_943_451,
    Pic_0680_944_451,
    Pic_0681_943_451,
    Pic_0682_943_451,
    Pic_0683_944_451,
    Pic_0674_949_465,
    Pic_0684_945_458,
};
static const uint16_t NumbeList_ODO_DAY[] = {
    Pic_0579_53_328,
    Pic_0581_61_327,
    Pic_0582_54_327,
    Pic_0583_54_327,
    Pic_0584_52_327,
    Pic_0585_54_327,
    Pic_0586_54_327,
    Pic_0587_53_327,
    Pic_0588_53_327,
    Pic_0589_54_327,
    Pic_0590_62_349,
    Pic_0591_56_338,
};
static const uint16_t NumbeList_ODO_NIGHT[] = {
    Pic_0687_53_328,
    Pic_0689_61_327,
    Pic_0690_54_327,
    Pic_0691_54_327,
    Pic_0692_52_327,
    Pic_0693_54_327,
    Pic_0694_54_327,
    Pic_0695_53_327,
    Pic_0696_53_327,
    Pic_0697_54_327,
    Pic_0698_62_349,
    Pic_0699_56_338,
};
static const uint16_t NumbeList_VSpeed_DAY[] = {
    Pic_0594_456_256,
    Pic_0595_492_255,
    Pic_0596_458_255,
    Pic_0597_461_255,
    Pic_0598_451_255,
    Pic_0599_458_255,
    Pic_0600_459_255,
    Pic_0601_454_255,
    Pic_0602_456_255,
    Pic_0603_459_255,
    Pic_0604_500_361,
    Pic_0605_470_308,
};
static const uint16_t NumbeList_VSpeed_NIGHT[] = {
    Pic_0702_456_256,
    Pic_0703_492_255,
    Pic_0704_458_255,
    Pic_0705_461_255,
    Pic_0706_451_255,
    Pic_0707_458_255,
    Pic_0708_459_255,
    Pic_0709_454_255,
    Pic_0710_456_255,
    Pic_0711_459_255,
    Pic_0712_500_361,
    Pic_0713_470_308,
};
static const uint16_t PICList_ESpeed_DAY[] = {
    Pic_0619_94_123,
    Pic_0618_140_111,
    Pic_0617_193_110,
    Pic_0616_291_128,
    Pic_0615_381_149,
    Pic_0614_446_149,
    Pic_0613_511_149,
    Pic_0612_569_149,
    Pic_0611_623_119,
    Pic_0610_677_110,
    Pic_0609_731_111,
    Pic_0608_782_125,
};
static const uint16_t PICList_ESpeed_NIGHT[] = {
    Pic_0727_94_123,
    Pic_0726_138_111,
    Pic_0725_191_110,
    Pic_0724_292_128,
    Pic_0723_379_149,
    Pic_0722_94_114,
    Pic_0721_511_149,
    Pic_0720_570_149,
    Pic_0719_623_119,
    Pic_0718_677_110,
    Pic_0717_731_111,
    Pic_0716_782_125,
};
static const uint16_t PICList_Fuel[] = {
    Pic_0562_315_473,
    Pic_0555_366_473,
    Pic_0556_426_473,
    Pic_0557_469_473,
    Pic_0558_514_473,
    Pic_0559_550_473,
    Pic_0560_586_473,
    Pic_0561_623_473,
};
// static const uint16_t PICList_Fuel_RED[] = {
//     Pic_0562_315_473,
//     Pic_0555_366_473,
//     Pic_0556_426_473,
//     Pic_0557_469_473,
//     Pic_0558_514_473,
//     Pic_0559_550_473,
//     Pic_0560_586_473,
//     Pic_0561_623_473,
// };
static const uint16_t PICList_Fuel_SelfCheck[] ={
    Pic_0554_315_473,
    Pic_0555_366_473,
    Pic_0556_426_473,
    Pic_0557_469_473,
    Pic_0558_514_473,
    Pic_0559_550_473,
    Pic_0560_586_473,
    Pic_0561_623_473,
};

/*指示灯*/
static void AMT630H_GUI_Light()
{
    if(Get_TelltalesLedSts(em_LED_Turn_Left))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0752_28_13);
    }
    if(Get_TelltalesLedSts(em_LED_Turn_Right))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0736_941_13);
    }
    if(Get_TelltalesLedSts(em_LED_High_Beam))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0744_402_21);
    }
    if(Get_TelltalesLedSts(em_LED_Efi_Fault))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0742_544_22);
    }
    if(Get_TelltalesLedSts(em_LED_ABS))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0743_476_20);
    }
    if(Get_TelltalesLedSts(em_LED_Auto_Start_Stop))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0745_341_21);
    }
    if(Get_TelltalesLedSts(em_LED_Oil_Pressure_Alert))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0738_792_25);
    }
    if(Get_TelltalesLedSts(em_LED_TCS) == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0750_106_26);
    }
    else if(Get_TelltalesLedSts(em_LED_TCS) == 2)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0750_106_26);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0751_111_30);
    }
    else
    {
        ;
    }
    if(Get_TelltalesLedSts(em_LED_HEV))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0747_244_26);
    }
    if(Get_TelltalesLedSts(em_LED_Coolant_Temperature))
    {
        if(FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0741_616_20);/*水温灯报警闪烁1HZ*/
        }
        else
        {
            ;
        }
    }
    if(Get_TelltalesLedSts(em_LED_WIFI))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0737_875_23);
    }
    if(Get_TelltalesLedSts(em_LED_Bluetooth))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0740_682_21);
    }
    if(Get_TelltalesLedSts(em_LED_E) == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0748_194_26);//E
    }
    else if(Get_TelltalesLedSts(em_LED_E) == 2)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0749_192_26);//S
    }
    else
    {
        ;
    }
}


/*时间显示函数*/
static void AMT630H_GUI_TIME(uint16_t Hour, uint16_t Minute)
{
    if (g_u8Display_Mode == ModeDAY)
    {
        /*外部接收小时和分钟*/
        if (FLASH_SYNC_1Hz)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0522_916_503, 918, 501);
        }
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t HourNumber;
        uint16_t MinuteNumber;
        HourNumber = Hour;
        MinuteNumber = Minute;
        /*小时显示*/
        DisplayNumPara.NumList = NumbeList_TIME_DAY;
        DisplayNumPara.x = 891;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, HourNumber);
        /*分钟显示*/
        DisplayNumPara.NumList = NumbeList_TIME_DAY;
        DisplayNumPara.x = 950;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, MinuteNumber);
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        /*外部接收小时和分钟*/
        if (FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0634_916_503);
        }
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t HourNumber;
        uint16_t MinuteNumber;
        HourNumber = Hour;
        MinuteNumber = Minute;
        /*小时显示*/
        DisplayNumPara.NumList = NumbeList_TIME_NIGHT;
        DisplayNumPara.x = 891;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, HourNumber);
        /*分钟显示*/
        DisplayNumPara.NumList = NumbeList_TIME_NIGHT;
        DisplayNumPara.x = 950;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, MinuteNumber);
    }
}

/*手机号显示函数*/
// uint16_t Telephone[] = {1,2,3,4,5,6,7,8,9,1,1};
// static void AMT630H_GUI_Telephone(uint16_t Telephone[])
// {
//     DISPLAY_NUM_ST DisplayNumPara;
//     SetPagePic(GRAPHICS_PAGE_0, Pic_0548_62_401); /*电话图标*/
//     /*预留来电人显示*/
//     for(int i=0;i<11;i++)
//     {
//         DisplayNumPara.NumList = NumbeList_Telephone;
//         DisplayNumPara.x = XList_Telephone[i];
//         DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT |0;
//         DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
//         DisplayNumPara.DecimalNum = 0;
//         DisplayNumPara.MinDigits = 1;
//         DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara,Telephone[i]);
//     }
// }

/*燃油显示函数*/
uint8_t g_u16_GUI_PerFuelLevel = 1;
static void AMT630H_GUI_Fuel(uint8_t Fuel)
{
    /*外部传参燃油处于数组第几格*/
    /*R>83且处于非开路状态时 黄色燃油灯闪烁*/
    /*R开路状态时 黄色燃油灯闪烁*/
    /*以上两种情况黄色燃油灯闪烁的频率不同*/
    static uint8_t s_FuelLowTime = 0U;
    uint8_t FuelLevel;
    FuelLevel = Fuel;
    if(Fuel == 0)
    {
        FuelLevel = 1;
    }
    else
    {
        ;
    }
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0553_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0550_715_533); /*F*/
        /*开路状态黄色燃油灯 1HZ闪烁*/
        if (Fuel == 0)
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            s_FuelLowTime = 0;
        }
        else if (Fuel == 1)
        {
            s_FuelLowTime++;
            if (s_FuelLowTime <= 15)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            if (s_FuelLowTime > 20)
            {
                s_FuelLowTime = 0;
            }
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0551_503_529); /*黑色燃油灯*/
            s_FuelLowTime = 0;
        }
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0662_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0660_715_533); /*F*/
        if (Fuel == 0)
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            s_FuelLowTime = 0;
        }
        else if (Fuel == 1)
        {
            s_FuelLowTime++;
            if (s_FuelLowTime <= 15)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            if (s_FuelLowTime > 20)
            {
                s_FuelLowTime = 0;
            }
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0661_503_529); /*白色燃油灯*/
            s_FuelLowTime = 0;
        }

    }
    /*燃油格数走格*/
    if (FuelLevel > 0)
    {
        if (FuelLevel != g_u16_GUI_PerFuelLevel)
        {
            for (uint8_t i = 0; i < g_u16_GUI_PerFuelLevel; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_Fuel[i]);
            }

            if (FuelLevel > g_u16_GUI_PerFuelLevel)
            {
                g_u16_GUI_PerFuelLevel++;
            }
            else if ((FuelLevel < g_u16_GUI_PerFuelLevel) && (g_u16_GUI_PerFuelLevel != 0))
            {
                g_u16_GUI_PerFuelLevel--;
            }
            else
            {
                ;
            }
        }
        if (FuelLevel == g_u16_GUI_PerFuelLevel)
        {
            g_u16_GUI_PerFuelLevel = FuelLevel;
            for (uint8_t i = 0; i < g_u16_GUI_PerFuelLevel; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_Fuel[i]);
            }
        }
    }
    else
    {
        ;
    }
}

uint16_t g_u16PerFuel_SelfCheck = 0;
/*燃油自检函数*/
static void AMT630H_GUI_Fuel_SelfCheck(uint8_t Fuel)
{
    uint8_t FuelLevel;
    FuelLevel = Fuel;
    if(Fuel == 1)
    {
        FuelLevel = 2;
    }
    else
    {
        ;
    }
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0553_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0550_715_533); /*F*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0551_503_529); /*黑色燃油灯*/
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0662_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0660_715_533); /*F*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0661_503_529); /*白色燃油灯*/
    }
    /*开机自检燃油走格*/
    
    if (FuelLevel > 0)
    {
        if (FuelLevel != g_u16_GUI_PerFuelLevel)
        {
            for (uint8_t i = 0; i < g_u16_GUI_PerFuelLevel; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_Fuel_SelfCheck[i]);
            }

            if (FuelLevel > g_u16_GUI_PerFuelLevel)
            {
                g_u16_GUI_PerFuelLevel++;
            }
            else if ((FuelLevel < g_u16_GUI_PerFuelLevel) && (g_u16_GUI_PerFuelLevel != 0))
            {
                g_u16_GUI_PerFuelLevel--;
            }
            else
            {
                ;
            }
        }
        if (FuelLevel == g_u16_GUI_PerFuelLevel)
        {
            g_u16_GUI_PerFuelLevel = FuelLevel;
            for (uint8_t i = 0; i < g_u16_GUI_PerFuelLevel; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_Fuel_SelfCheck[i]);
            }
        }
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0562_315_473);/*燃油红区*/
        
    }
}




/*电压显示函数*/
static void AMT630H_GUI_Voltage(uint16_t Voltage)
{
    if (g_u8Display_Mode == ModeDAY)
    {
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VoltageNumber;
        VoltageNumber = Voltage / 10;
        if (Voltage % 10 > 5)
        {
            VoltageNumber++;
        }
        uint16_t Voltage_Hundred;
        uint16_t Voltage_Ten;
        uint16_t Voltage_Unit;
        uint16_t Front;
        if ((VoltageNumber <= 120) || (VoltageNumber > 150))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0563_923_407); /*红色电压图标*/
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0865_923_407);/*绿色电压图标显示*/
        }
        /*数据处理*/
        Voltage_Hundred = VoltageNumber / 100;
        Voltage_Ten = (VoltageNumber % 100) / 10;
        Voltage_Unit = VoltageNumber % 10;
        Front = Voltage_Hundred * 10 + Voltage_Ten;
        DisplayNumPara.NumList = NumbeList_Voltage_DAY;

        if ((VoltageNumber >= 100) && (VoltageNumber < 1000))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0564_966_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0566_946_465); /* . */
            DisplayNumPara.x = 951;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 0;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Voltage_Unit);

            DisplayNumPara.x = 930;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 15;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Front);
        }

        else if (0 <= VoltageNumber < 100)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0564_958_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0566_938_465); /* . */
            DisplayNumPara.x = 943;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 21;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 1;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VoltageNumber);
        }

        else
        {
            ;
        }
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VoltageNumber;
        VoltageNumber = Voltage / 10;
        if (Voltage % 10 > 5)
        {
            VoltageNumber++;
        }
        uint16_t Voltage_Hundred;
        uint16_t Voltage_Ten;
        uint16_t Voltage_Unit;
        uint16_t Front;
        if ((VoltageNumber <= 120) || (VoltageNumber > 150))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0563_923_407); /*红色电压图标*/
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0865_923_407);/*绿色电压图标显示*/
        }
        /*数据处理*/
        Voltage_Hundred = VoltageNumber / 100;
        Voltage_Ten = (VoltageNumber % 100) / 10;
        Voltage_Unit = VoltageNumber % 10;
        Front = Voltage_Hundred * 10 + Voltage_Ten;
        DisplayNumPara.NumList = NumbeList_Voltage_NIGHT;

        if ((VoltageNumber >= 100) && (VoltageNumber < 1000))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0672_966_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0674_946_465); /* . */
            DisplayNumPara.x = 951;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 0;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Voltage_Unit);

            DisplayNumPara.x = 930;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 15;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Front);
        }

        else if (0 <= VoltageNumber < 100)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0672_958_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0674_938_465); /* . */
            DisplayNumPara.x = 943;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 21;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 1;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VoltageNumber);
        }
        else
        {
            ;
        }
    }

    else
    {
        ;
    }
}

/*大计里程显示函数*/
static void AMT630H_GUI_ODO(uint32_t ODO, uint8_t Uint)
{
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0577_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0578_55_296);/*ODO图标不动*/

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t ODONumber;
        ODONumber = ODO;
        DisplayNumPara.NumList = NumbeList_ODO_DAY;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        if((ODONumber<1000000)&&(ODONumber>=100000))
        {
            DisplayNumPara.x = 173;
            DisplayNumPara.MinDigits = 6; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_211_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_211_324);/*mile*/
            }
        }
        else if((ODONumber<100000)&&(ODONumber>=10000))
        {
            DisplayNumPara.x = 149;
            DisplayNumPara.MinDigits = 5;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_187_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_187_324);/*mile*/
            }
        }
        else if((ODONumber<10000)&&(ODONumber>=1000))
        {
            DisplayNumPara.x = 125;
            DisplayNumPara.MinDigits = 4;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_163_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_163_324);/*mile*/
            }
        }
        else if((ODONumber<1000)&&(ODONumber>=100))
        {
            DisplayNumPara.x = 101;
            DisplayNumPara.MinDigits = 3;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_139_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_139_324);/*mile*/
            }
        }
        else if((ODONumber<100)&&(ODONumber>=10))
        {
            DisplayNumPara.x = 77;
            DisplayNumPara.MinDigits = 2;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_115_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_115_324);/*mile*/
            }
        }
        else if((ODONumber<10)&&(ODONumber>=0))
        {
            DisplayNumPara.x = 53;
            DisplayNumPara.MinDigits = 1;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_91_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_91_324);/*mile*/
            }
        }
        else
        {
            ;
        }
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ODONumber);
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0685_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0686_55_296);/*ODO图标不动*/

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t ODONumber;
        ODONumber = ODO;
        DisplayNumPara.NumList = NumbeList_ODO_NIGHT;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        if((ODONumber<1000000)&&(ODONumber>=100000))
        {
            DisplayNumPara.x = 173;
            DisplayNumPara.MinDigits = 6;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_211_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_211_324);/*单位mile*/
            }
        }
        else if((ODONumber<100000)&&(ODONumber>=10000))
        {
            DisplayNumPara.x = 149;
            DisplayNumPara.MinDigits = 5;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_187_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_187_324);/*单位mile*/
            }
        }
        else if((ODONumber<10000)&&(ODONumber>=1000))
        {
            DisplayNumPara.x = 125;
            DisplayNumPara.MinDigits = 4;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_163_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_163_324);/*单位mile*/
            }
        }
        else if((ODONumber<1000)&&(ODONumber>=100))
        {
            DisplayNumPara.x = 101;
            DisplayNumPara.MinDigits = 3;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_139_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_139_324);/*单位mile*/
            }
        }
        else if((ODONumber<100)&&(ODONumber>=10))
        {
            DisplayNumPara.x = 77;
            DisplayNumPara.MinDigits = 2;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_115_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_115_324);/*单位mile*/
            }
        }
        else if((ODONumber<10)&&(ODONumber>=0))
        {
            DisplayNumPara.x = 53;
            DisplayNumPara.MinDigits = 1;
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0688_91_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_91_324);/*单位mile*/
            }
        }
        else
        {
            ;
        }
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ODONumber);
    }
    else
    {
        ;
    }
}

/*小计里程显示函数*/
static void AMT630H_GUI_Trip(uint32_t Trip, uint8_t Uint)
{
    DISPLAY_NUM_ST DisplayNumPara;
    uint32_t Tripnumber;
    Tripnumber = Trip;
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0577_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0862_54_297);/*TRIP图标*/

        DisplayNumPara.NumList = NumbeList_ODO_DAY;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 1;/*小数点后一位*/
        if((Tripnumber<10000)&&(Tripnumber>=1000))
        {
            DisplayNumPara.x = 140;
            DisplayNumPara.MinDigits = 4; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_187_324);//KM
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_187_324);/*单位mile*/ 
            }
        }
        else if((Tripnumber<1000)&&(Tripnumber>=100))
        {
            DisplayNumPara.x = 116;
            DisplayNumPara.MinDigits = 3; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_163_324);/*KM*/ 
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_163_324);/*单位mile*/ 
            }
        }
        else if((Tripnumber<100)&&(Tripnumber>=10))
        {
            DisplayNumPara.x = 93;
            DisplayNumPara.MinDigits = 2; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_139_324);/*KM*/ 
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_139_324);/*单位mile*/  
            }
        }
        else if((Tripnumber<10)&&(Tripnumber>=0))
        {
            DisplayNumPara.x = 93;
            DisplayNumPara.MinDigits = 2; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0,Pic_0580_139_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0861_139_324);/*单位mile*/
            }
        }
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Tripnumber);
    }
    else if(g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0685_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0864_54_297);/*TRIP图标*/
        DisplayNumPara.NumList = NumbeList_ODO_NIGHT;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 1;/*小数点后一位*/
        if((Tripnumber<10000)&&(Tripnumber>=1000))
        {
            DisplayNumPara.x = 140;
            DisplayNumPara.MinDigits = 4; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_187_324);/*单位km*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_187_324);/*单位mile*/
            }
        }
        else if((Tripnumber<1000)&&(Tripnumber>=100))
        {
            DisplayNumPara.x = 116;
            DisplayNumPara.MinDigits = 3; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_163_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_163_324);/*单位mile*/
            }
        }
        else if((Tripnumber<100)&&(Tripnumber>=10))
        {
            DisplayNumPara.x = 93;
            DisplayNumPara.MinDigits = 2; 
            if(Uint == 0)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_139_324);/*KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_139_324);/*单位mile*/
            }
        }
        else if((Tripnumber<10)&&(Tripnumber>=0))
        {
            DisplayNumPara.x = 93;
            DisplayNumPara.MinDigits = 2;
            if(Uint == 0) 
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0580_139_324);/*单位KM*/
            }
            else
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0863_139_324);/*单位mile*/
            }
        }
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Tripnumber);
    }
}

/*车速显示函数*/
static void AMT630H_GUI_VSpeed(uint16_t VSpeed,uint8_t Unit)
{
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0592_617_271);
        if(Unit == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0593_889_310);/*单位 km*/
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0928_894_310);/*单位 mph */   
        }

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VSpeedNumber;
        VSpeedNumber = VSpeed;

        DisplayNumPara.NumList = NumbeList_VSpeed_DAY;
        if (100 <= VSpeedNumber)
        {
            DisplayNumPara.x = 574;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 3;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if ((10 <= VSpeedNumber))
        {
            DisplayNumPara.x = 515;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (0 <= VSpeedNumber)
        {
            if (VSpeedNumber == 1)
            {
                DisplayNumPara.x = 492; // 1的宽度与其他数字不同 坐标没给
            }
            else
            {
                DisplayNumPara.x = 456;
            }
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }
        else
        {
            ;
        }
    }
    else if (g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0700_617_271);
        if(Unit == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0701_889_310);/*单位 km/h */
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0929_894_310);/*单位 mile/h */
        }

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VSpeedNumber;
        VSpeedNumber = VSpeed;

        DisplayNumPara.NumList = NumbeList_VSpeed_NIGHT;
        if (100 <= VSpeedNumber)
        {
            DisplayNumPara.x = 574;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 3;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (10 <= VSpeedNumber)
        {
            DisplayNumPara.x = 515;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (0 <= VSpeedNumber)
        {
            if (VSpeedNumber == 1)
            {
                DisplayNumPara.x = 492; // 1的宽度与其他数字不同 坐标没给
            }
            else
            {
                DisplayNumPara.x = 456;
            }
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else
        {
            ;
        }
    }
    else
    {
        ;
    }
}

/*转速显示函数*/
static void AMT630H_GUI_ESpeed(uint16_t ESpeed)
{
    uint8_t PIC = 0;
    if (g_u8Display_Mode == ModeDAY)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0606_834_199); /* 1000r/min */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0607_94_110);  /* 底 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0620_56_165);  /* 数字0-12 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0621_118_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0622_178_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0623_268_89);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0624_350_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0625_422_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0626_498_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0627_570_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0628_634_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0629_721_86);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0630_803_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0631_877_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0632_925_165);

        /*数据处理*/
        uint16_t ESpeedLevel;
        uint16_t ESpeedNumber;
        ESpeedNumber = ESpeed;

        if (ESpeedNumber > 0)
        {
            ESpeedLevel = (ESpeedNumber - 1) / 1000;
            for (PIC = 0; PIC <= ESpeedLevel; PIC++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_ESpeed_DAY[PIC]);
            }
        }
        else if (ESpeedNumber == 0)
        {
            ESpeedLevel = 0;
        }
    }

    else if (g_u8Display_Mode == ModeNIGHT)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0714_834_199); /* 1000r/min */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0715_94_110);  /* 底 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0728_56_165);  /* 数字0-12 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0729_118_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0730_178_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0731_268_89);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0732_350_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0733_422_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0734_498_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0735_570_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0628_634_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0629_721_86);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0630_803_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0631_877_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0632_925_165);

        /*数据处理*/
        uint16_t ESpeedLevel;
        uint16_t ESpeedNumber;
        ESpeedNumber = ESpeed;

        if (ESpeedNumber > 0)
        {
            ESpeedLevel = (ESpeedNumber - 1) / 1000;
            for (PIC = 0; PIC <= ESpeedLevel; PIC++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_ESpeed_NIGHT[PIC]);
            }
        }
        else if (ESpeedNumber == 0)
        {
            ESpeedLevel = 0;
        }
    }
    else
    {
        ;
    }
}

/******************************************************************************************/
/**
 * @brief 主界面显示
 *
 */
uint8_t VechileSpeed_time = 0;
uint8_t KL30_VOLTAGE_time = 0;
uint8_t VechileSpeed = 0;
uint16_t KL30_VOLTAGE_Value = 0;
void AMT630H_GUI_BACKGRAND()
{
    /*背景图*/
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
        }
    }
    if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
        }
    }

    /*主界面函数*/
    AMT630H_GUI_Light();
    AMT630H_GUI_TIME(Get_Dis_Hour_Time(), Get_Dis_Minute_Time());
    // AMT630H_GUI_Telephone(Telephone);
    /*燃油*/
    if (Get_Fuel_Sensor_State() == FuelSensorNormal)
    {
        AMT630H_GUI_Fuel(Get_CurFuelSetp());
    }
    else
    {
        AMT630H_GUI_Fuel(0);
    }
    if(KL30_VOLTAGE_time < 10)
    {
        KL30_VOLTAGE_time++;
    }
    else
    {
        KL30_VOLTAGE_time = 0;
        KL30_VOLTAGE_Value = (ADC_Read_Signal(ADC_CH_KL30_VOLTAGE)) / 10;
        
    }
    AMT630H_GUI_Voltage(KL30_VOLTAGE_Value);
    if(Get_Dis_OdoAndTrip() == 0)
    {
        AMT630H_GUI_ODO(Get_ODO_Value() / 10, Get_Dis_Unit());
    }
    else
    {
        AMT630H_GUI_Trip(Get_Trip_Value(), Get_Dis_Unit());
    }
    if(0)
    {
        VechileSpeed_time++;
    }
    else
    {
        VechileSpeed_time = 0;
        VechileSpeed = Get_DispVechileSpeed() / 10;
        
    }
    if (Get_VechileSpeedValid() == 1)
    {
        AMT630H_GUI_VSpeed(VechileSpeed, Get_Dis_Unit());
    }
    else    
    {
        AMT630H_GUI_VSpeed(0,0);
    }
    /*转速*/
    if (Get_EngineValid() == 1)
    {
        AMT630H_GUI_ESpeed(Get_DispEngineSpeed());
    }
    else
    {
        AMT630H_GUI_ESpeed(0);
    }
}


/*自检*/
void AMT630H_GUI_BACKGRAND_SelfCheck()
{
    /*背景图*/
    if(g_u8Display_Mode == ModeDAY)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
        }
    }
    if(g_u8Display_Mode == ModeNIGHT)
    {
        if(g_u8Language == CH)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
        }
        else if(g_u8Language == EN)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
        }
    }
    /*指示灯显示*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0752_28_13);/*左转向*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0736_941_13);/*右转向*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0744_402_21);/*远光灯*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0742_544_22);/*电喷故障指示灯*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0743_476_20);/*ABS*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0745_341_21);/*自动启停灯*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0738_792_25);/*机油压力灯*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0750_106_26);/*TCS*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0751_111_30);/* / */
    SetPagePic(GRAPHICS_PAGE_0, Pic_0747_244_26);/*HEV*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0741_616_20);/*水温灯*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0737_875_23);/*WIFI*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0740_682_21);/*蓝牙*/
    SetPagePic(GRAPHICS_PAGE_0, Pic_0748_194_26);/*E*/
    
    // AMT630H_GUI_Telephone(Telephone);
    AMT630H_GUI_Voltage(KL30_VOLTAGE_Value);
    AMT630H_GUI_TIME(Get_Dis_Hour_Time(), Get_Dis_Minute_Time());
    if(KL30_VOLTAGE_time < 10)
    {
        KL30_VOLTAGE_time++;
    }
    else
    {
        KL30_VOLTAGE_time = 0;
        KL30_VOLTAGE_Value = (ADC_Read_Signal(ADC_CH_KL30_VOLTAGE)) / 10;
    }
    /*里程无自检*/
    if(Get_Dis_OdoAndTrip() == 0)
    {
        AMT630H_GUI_ODO(Get_ODO_Value() / 10, Get_Dis_Unit());
    }
    else 
    {
        AMT630H_GUI_Trip(Get_Trip_Value(), Get_Dis_Unit());
    }
    /*燃油自检*/
    if(g_u16fuelnumberup < 600)
    {
        g_u16fuelnumberup += 6;
        AMT630H_GUI_Fuel_SelfCheck(g_u16fuelnumberup/75);/*初始化g_u16fuelnumberup = 0*/
    }
    else
    {
        ;
    }
    /*车速自检*/
    if(g_u16vspeednumberup < 300)
    {
        AMT630H_GUI_VSpeed(g_u16vspeednumberup,Get_Dis_Unit());/*初始化g_u16vspeednumberup = 0*/
        g_u16vspeednumberup += 6;
    }
    else
    {
        if(g_u16vspeednumberdown >0)
        {
            g_u16vspeednumberdown -= 6;/*初始化g_u16vspeednumberup=1200*/
            AMT630H_GUI_VSpeed(g_u16vspeednumberdown,Get_Dis_Unit());/*if g_u16vspeednumberup=0 车速自检结束*/
        }
        else
        {
            ;
        }
    }
    /*转速自检*/
    if(g_u16espeednumberup <= 300)
    {
        AMT630H_GUI_ESpeed(g_u16espeednumberup*40);/*初始化g_u16espeednumberup = 0*/
        g_u16espeednumberup += 6;
    }
    else
    {
        if(g_u16espeednumberdown > 0)
        {
            AMT630H_GUI_ESpeed(g_u16espeednumberdown*40);/*初始化g_u16espeednumberdown = 600*/
            g_u16espeednumberdown -= 6;/*g_u16espeednumberdown = 0 转速自检结束*/
        }
    }
    /*结束状态*/
    if(g_u16fuelnumberup == 600)
    {
        AMT630H_GUI_Fuel_SelfCheck(8);
    }
    if(g_u16vspeednumberdown == 0)
    {
        AMT630H_GUI_VSpeed(g_u16vspeednumberdown, Get_Dis_Unit());
    }
    if(g_u16espeednumberdown == 0)
    {
        AMT630H_GUI_ESpeed(g_u16espeednumberdown);
    }
    /*结束自检*/
    if((g_u16fuelnumberup == 600)&&(g_u16vspeednumberdown == 0)&&(g_u16espeednumberdown == 0))
    {
        g_u8SelfCheck = 1;/*自检结束标志*/
    }
    else
    {
        ;
    }
}


void AMT630H_GUI_SETTING()
{
   if (g_u8Display_Mode == ModeDAY)
   {
      if(g_u8Language == CH)
      {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
      }
      else if(g_u8Language == EN)
      {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
      }
   }
   else if(g_u8Display_Mode == ModeNIGHT)
   {
      if(g_u8Language == CH)
      {
          SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
          SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
          SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
      }
      else if(g_u8Language == EN)
      {
          SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
          SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
          SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
      }
   }
}

void AMT630H_GUI_DisplayProc(void)
{
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);

    AMT630H_GUI_Background();
    
    PackedTransfer_Page();
}


void AMT630H_GUI_ReadPosittion_Display(void)
{
    switch (g_u8Cursor_Posittion)
    {
    case MENU_ITEM_MAIN_ITEM:    /*主界面*/
        AMT630H_GUI_BACKGRAND();
        break;
    case MENU_ITEM_DISPLAY_MODE: /*01 显示模式*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Display_Mode_Information();
        break;
    case MENU_ITEM_SELECT_DAYTIME: /*10日间模式*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Display_Mode_Setting(MENU_ITEM_SELECT_DAYTIME);
        break;
    case MENU_ITEM_SELECT_NIGHTTIME: /*11夜间模式*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Display_Mode_Setting(MENU_ITEM_SELECT_NIGHTTIME);
        break;            
    case MENU_ITEM_SELECT_AUTO: /*12自动模式*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Display_Mode_Setting(MENU_ITEM_SELECT_AUTO);
        break;
    case MENU_ITEM_BACKLIGHT_SETTING: /*02 背光设置*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Information();
        break;
    case MENU_ITEM_BACKLIGHT_5: /*13 背光_5*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_5);
        break;
    case MENU_ITEM_BACKLIGHT_4: /*14 背光_4*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_4);
        break;
    case MENU_ITEM_BACKLIGHT_3: /*15 背光_3*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_3);
        break;
    case MENU_ITEM_BACKLIGHT_2: /*16 背光_2*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_2);
        break;
    case MENU_ITEM_BACKLIGHT_1: /*17 背光_1*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_1);
        break;
    case MENU_ITEM_BACKLIGHT_AUTO: /*18 背光自动*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Backlight_Setting(MENU_ITEM_BACKLIGHT_AUTO);
        break;

    case MENU_ITEM_BLUETOOTH_CONNECT: /*03 蓝牙连接*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Bluetooth_Information(8, Get_Dis_Bluetooth_Open_Close());
        break;
    case MENU_ITEM_BLUETOOTH_OPEN_CLOSE: /*12 蓝牙_开*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Bluetooth_Connect_Setting(MENU_ITEM_BLUETOOTH_OPEN_CLOSE, 8, Get_Dis_Bluetooth_Open_Close());
        break;
    case MENU_ITEM_BLUETOOTH_SYNC: /*13 蓝牙同步联系人*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Bluetooth_Connect_Setting(MENU_ITEM_BLUETOOTH_SYNC, 8, Get_Dis_Bluetooth_Open_Close());
        break;
    case MENU_ITEM_BLUETOOTH_BACK: /*14 蓝牙返回*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Bluetooth_Connect_Setting(MENU_ITEM_BLUETOOTH_BACK, 8, Get_Dis_Bluetooth_Open_Close());
        break;
    case MENU_ITEM_CLOCK_SETTING: /*15 时钟设置*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Information(Get_Dis_Hour_Time(), Get_Dis_Minute_Time());
        break;
    case MENU_ITEM_CLOCK_HOUR_TENB: /*20 时钟小时十位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_HOUR_TENB);
        break;
    case MENU_ITEM_CLOCK_HOUR_BIT: /*19 时钟小时个位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_HOUR_BIT);
        break;
    case MENU_ITEM_CLOCK_MIN_TENB: /*18 时钟分钟十位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_MIN_TENB);
        break;
    case MENU_ITEM_CLOCK_MIN_BIT: /*17 时钟分钟个位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_MIN_BIT);
        break;
    case MENU_ITEM_CLOCK_BACK: /*16 时钟返回*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_BACK);
        break;
    case MENU_ITEM_CLOCK_HOUR_TENB_SET:/*27 时钟小时十位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_HOUR_TENB_SET);
        break;
    case MENU_ITEM_CLOCK_HOUR_BIT_SET:/*28 时钟小时个位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_HOUR_BIT_SET);
        break;
    case MENU_ITEM_CLOCK_MIN_TENB_SET:/*29 时钟分钟十位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_MIN_TENB_SET);
        break;
    case MENU_ITEM_CLOCK_MIN_BIT_SET:/*30 时钟分钟个位*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Clock_Setting(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), MENU_ITEM_CLOCK_MIN_BIT_SET);
        break;
    case MENU_ITEM_UNIT_SETTING: /*05 单位设置*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Unit_Information();
        break;
    case MENU_ITEM_UNIT_KM: /*31 选中公制*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Unit_Setting(MENU_ITEM_UNIT_KM);
        break;
    case MENU_ITEM_UNIT_MILE: /*32 选中英制*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Unit_Setting(MENU_ITEM_UNIT_MILE);
        break;
    case MENU_ITEM_LANGUAGE_SETTING: /*24 语言设置*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Language_Information();
        break;
    case MENU_ITEM_LANGUAGE_CHINESE: /*25 选中中文*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Language_Setting(MENU_ITEM_LANGUAGE_CHINESE);
        break;
    case MENU_ITEM_LANGUAGE_ENGLISH: /*26 选中英文*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Language_Setting(MENU_ITEM_LANGUAGE_ENGLISH);
        break;
    case MENU_ITEM_FAULT_INFORMATION: /*27 故障信息*/
    if(OTA_Update_Flag == 0)
    {
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Fault_Information();
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0653_54_499);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
    }
        break;
    case MENU_ITEM_PHONE_CONNECT: /*28 手机互联*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Phone_Connect();
        break;
    case MENU_ITEM_QUIT: /*29 退出*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Quit();
        break;
    case MENU_ITEM_PHONE_CONNECT_SET:
        
    case MENU_ITEM_PHONE_CONNECT_APP: /*28 手机互联成功*/
        AMT630H_GUI_SETTING();
        AMT630H_GUI_Phone_Connect_Win();
        break;
    default:
        break;
    }
}

uint8_t GET_Backlight(void)
{
   return g_u8Backlight;
}