
#include "CommonInterface.h"
#include "Components.h"


uint32_t PowerIgnOnTimeLine;
uint32_t PowerIgnOffTimeLine;

static uint32_t PowerSocTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed;          /*实际值,十倍的*/
static uint16_t Disp_V_Speed;         /*显示值,十倍的*/
static DataValid_t PowerSts_Valid;
volatile static DataValid_t Act_V_Speed_Valid;
static DataValid_t Disp_V_Speed_Valid;

// static uint16_t u16SelfCheckTime;
/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;

    PowerSts_Valid = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
    PowerSocTimeLine = 0x0ul;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

uint8_t Common_Get_IG_Sts(void)
{
    return (uint8_t)PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;//需要跑大计测试
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
} 

uint16_t Common_Get_TireSize(void)
{
    return 10020ul;
}

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return Act_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}

void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}



void Common_Input_Para(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        Common_Set_Act_V_Speed(Get_ActualVechileSpeed());
        Common_Set_Disp_V_Speed(Get_DispVechileSpeed());  
        if (Get_VechileSpeedValid() == COMMON_Valid)
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }

        PowerIgnOffTimeLine = 0ul;

        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }
        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
    }
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

uint32_t Common_GetSocTime(void)
{
    return PowerSocTimeLine;
}



/**
 * @brief 公里转换英里
 * @return 公里
 */
uint32_t Data_Km_To_Mile(uint32_t Km)
{   
    //Km *= 621;
    //Km /= 1000;
    Km *= 100;
    Km /= 161;
    return Km;
}
/**
 * @brief 英里转换公里
 * @return 英里
 */
uint32_t Data_Mile_To_Km(uint32_t Mile)
{
    Mile *= 161;
    Mile /= 100;
    return Mile;
}

void Data_SwapWord(uint32_t *pData1, uint32_t *pData2)
{
	uint32_t psw;
	if ((*pData1) > (*pData2))
	{
		psw = (*pData2);
		(*pData2) = (*pData1);
		(*pData1) = psw;
	}
}


void Data_SortNWord(uint32_t *SortData, uint32_t len)
{
	uint8_t n = 0, m;
	for (; n < len - 1; n++)
	{
		for (m = n + 1; m < len; m++)
		{
			Data_SwapWord((SortData + n), (SortData + m));
		}
	}
}




